/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.opplugin.AbstractContractSettleOp;
import kd.pmgt.pmct.opplugin.validator.InContractSettleValidator;

public class InContractSettleOp
extends AbstractContractSettleOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("begindate");
        fields.add("billno");
        fields.add("org");
        fields.add("enddate");
        fields.add("billstatus");
        fields.add("contract");
        fields.add("listentry");
        fields.add("itementry");
        fields.add("payitemdetailentry");
        fields.add("itemid");
        fields.add("payitemid");
        fields.add("itemrate");
        fields.add("listmodelentry");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        boolean isUnaudit = false;
        List validators = e.getValidators();
        for (AbstractValidator val : validators) {
            if (!"unaudit".equals(val.getOperateKey())) continue;
            isUnaudit = true;
        }
        e.getValidators().add(new InContractSettleInvoiceValidator());
        if (!isUnaudit) {
            e.getValidators().add(new InContractSettleValidator());
        }
    }

    @Override
    public void reverseWritingToContract(boolean isAudit, DynamicObject settle) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)settle.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract", (String)Stream.of("totalcalofamt", "totalcaloftaxamt", "totalnotcalofamt", "totalnotcaloftaxamt", "totalsettleamount", "totalsettleoftaxamount").collect(Collectors.joining(",")));
        BigDecimal totalSettleAmount = contract.getBigDecimal("totalsettleamount");
        BigDecimal totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
        BigDecimal settleAmount = settle.getBigDecimal("settleamount");
        BigDecimal settleOfTaxAmount = settle.getBigDecimal("settleoftaxamount");
        if (isAudit) {
            contract.set("totalsettleamount", (Object)totalSettleAmount.add(settleAmount));
            contract.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount.add(settleOfTaxAmount));
            contract.set("totalcalofamt", (Object)contract.getBigDecimal("totalcalofamt").add(settle.getBigDecimal("calofamt")));
            contract.set("totalcaloftaxamt", (Object)contract.getBigDecimal("totalcaloftaxamt").add(settle.getBigDecimal("caloftaxamt")));
            contract.set("totalnotcalofamt", (Object)contract.getBigDecimal("totalnotcalofamt").add(settle.getBigDecimal("notcalofamt")));
            contract.set("totalnotcaloftaxamt", (Object)contract.getBigDecimal("totalnotcaloftaxamt").add(settle.getBigDecimal("notcaloftaxamt")));
        } else {
            contract.set("totalsettleamount", (Object)totalSettleAmount.subtract(settleAmount));
            contract.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount.subtract(settleOfTaxAmount));
            contract.set("totalcalofamt", (Object)contract.getBigDecimal("totalcalofamt").subtract(settle.getBigDecimal("calofamt")));
            contract.set("totalcaloftaxamt", (Object)contract.getBigDecimal("totalcaloftaxamt").subtract(settle.getBigDecimal("caloftaxamt")));
            contract.set("totalnotcalofamt", (Object)contract.getBigDecimal("totalnotcalofamt").subtract(settle.getBigDecimal("notcalofamt")));
            contract.set("totalnotcaloftaxamt", (Object)contract.getBigDecimal("totalnotcaloftaxamt").subtract(settle.getBigDecimal("notcaloftaxamt")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operation = e.getOperationKey();
        DynamicObject[] settleBills = e.getDataEntities();
        List<DynamicObject> settleBillList = Arrays.asList(settleBills);
        List<DynamicObject> listingEntrys = settleBillList.stream().flatMap(settleBill -> {
            String billId = ((DynamicObject)settleBillList.get(0)).getString("id");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract_settle"));
            return bill.getDynamicObjectCollection("listmodelentry").stream();
        }).flatMap(modelObj -> modelObj.getDynamicObjectCollection("listentry").stream()).collect(Collectors.toList());
        if ("audit".equals(operation)) {
            this.updateListing(listingEntrys, true);
        } else if ("unaudit".equals(operation)) {
            this.updateListing(listingEntrys, false);
        }
    }

    private void updateListing(List<DynamicObject> listingEntrys, boolean isaudit) {
        ArrayList listingArr = new ArrayList();
        BigDecimal coefficient = isaudit ? BigDecimal.ONE : BigDecimal.valueOf(-1L);
        listingEntrys.forEach(obj -> {
            BigDecimal thisQty = coefficient.multiply(obj.getBigDecimal("thisqty"));
            BigDecimal thisOfTaxAmount = coefficient.multiply(obj.getBigDecimal("thisoftaxmount"));
            DynamicObject listing = obj.getDynamicObject("listing");
            String listingId = listing.getString("id");
            DynamicObject listingObj = BusinessDataServiceHelper.loadSingle((Object)listingId, (String)"pmct_contractlist");
            listingObj.set("lstsettleqty", (Object)thisQty.add(listingObj.getBigDecimal("lstsettleqty")));
            BigDecimal lstSettleOfTaxAmount = thisOfTaxAmount.add(listingObj.getBigDecimal("lstsettleoftaxamount"));
            listingObj.set("lstsettleoftaxamount", (Object)lstSettleOfTaxAmount);
            if (isaudit) {
                listingObj.set("lstsettletaxamt", (Object)lstSettleOfTaxAmount.subtract(obj.getBigDecimal("lstamount")));
            } else {
                BigDecimal lstSettleTaxAmt = listingObj.getBigDecimal("lstsettletaxamt");
                listingObj.set("lstsettletaxamt", (Object)lstSettleTaxAmt.subtract(obj.getBigDecimal("thistax")));
            }
            listingArr.add(listingObj);
        });
        if (listingArr.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)listingArr.get(0)).getDataEntityType(), (Object[])listingArr.toArray(new DynamicObject[0]));
        }
    }

    static class InContractSettleInvoiceValidator
    extends AbstractValidator {
        InContractSettleInvoiceValidator() {
        }

        public void validate() {
            block7: {
                String key;
                block6: {
                    ExtendedDataEntity[] dataEntities;
                    key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) break block6;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        QFilter orgQFilter;
                        DynamicObject settleBill = dataEntity.getDataEntity();
                        String billNo = settleBill.getString("billno");
                        QFilter billNoQFilter = new QFilter("textfield1", "=", (Object)billNo);
                        boolean exist = QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter[]{billNoQFilter, orgQFilter = new QFilter("orgid", "=", settleBill.getDynamicObject("org").getPkValue())});
                        if (!exist) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u7b97\u5df2\u5b58\u5728\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\uff0c\u53cd\u5ba1\u6838\u53ef\u80fd\u4f1a\u5bf9\u8d22\u52a1\u505a\u8d26\u4ea7\u751f\u5f71\u54cd\u3002", (String)"InContractSettleOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNo));
                    }
                    break block7;
                }
                if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block7;
                block1: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject settleBill = dataEntity.getDataEntity();
                    DynamicObjectCollection itemEntry = settleBill.getDynamicObjectCollection("itementry");
                    DynamicObjectCollection modelEntry = settleBill.getDynamicObjectCollection("listmodelentry");
                    DynamicObjectCollection detailEntry = settleBill.getDynamicObjectCollection("payitemdetailentry");
                    for (int rowIndex = 0; rowIndex < itemEntry.size(); ++rowIndex) {
                        DynamicObject item;
                        DynamicObject rate;
                        StringBuilder listStringBuilder = new StringBuilder();
                        StringBuilder detailStringBuilder = new StringBuilder();
                        Object payItemId = ((DynamicObject)itemEntry.get(rowIndex)).getPkValue();
                        block3: for (DynamicObject model : modelEntry) {
                            for (DynamicObject list : model.getDynamicObjectCollection("listentry")) {
                                if (!payItemId.equals(list.getLong("payitemid"))) continue;
                                listStringBuilder.append(rowIndex + 1).append("\uff0c");
                                break block3;
                            }
                        }
                        for (DynamicObject detail : detailEntry) {
                            if (!payItemId.equals(detail.getLong("itemid"))) continue;
                            detailStringBuilder.append(rowIndex + 1).append("\uff0c");
                            break;
                        }
                        if (listStringBuilder.length() != 0 || detailStringBuilder.length() != 0 || (rate = (item = (DynamicObject)itemEntry.get(rowIndex)).getDynamicObject("itemrate")) != null) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u652f\u4ed8\u9879\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u201c\u7a0e\u7387\u201d", (String)"InContractSettleOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), rowIndex + 1));
                        continue block1;
                    }
                }
            }
        }
    }
}

