/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.opplugin.AbstractContractSettleOp;
import kd.pmgt.pmct.opplugin.validator.OutContractSettleValidator;

public class OutContractSettleOp
extends AbstractContractSettleOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("begindate");
        fields.add("billstatus");
        fields.add("contract");
        fields.add("listentry");
        fields.add("contpartb");
        fields.add("conttotaloftaxamount");
        fields.add("totalsettleoftaxamount");
        fields.add("listmodelentry");
        fields.add("thisqty");
        fields.add("thisoftaxmount");
        fields.add("lstamount");
        fields.add("thistax");
        fields.add("listing");
        fields.add("itementry");
        fields.add("payitemdetailentry");
        fields.add("itemid");
        fields.add("payitemid");
        fields.add("itemrate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new OutContractSettleValidator());
    }

    @Override
    public void reverseWritingToContract(boolean isAudit, DynamicObject settle) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)settle.getDynamicObject("contract").getPkValue(), (String)"pmct_outcontract", (String)Stream.of("totalcalofamt", "totalcaloftaxamt", "totalnotcalofamt", "totalnotcaloftaxamt", "totalsettleamount", "totalsettleoftaxamount").collect(Collectors.joining(",")));
        BigDecimal totalSettleAmount = contract.getBigDecimal("totalsettleamount");
        BigDecimal totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
        BigDecimal settleAmount = settle.getBigDecimal("settleamount");
        BigDecimal settleOfTaxAmount = settle.getBigDecimal("settleoftaxamount");
        if (isAudit) {
            contract.set("totalsettleamount", (Object)totalSettleAmount.add(settleAmount));
            contract.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount.add(settleOfTaxAmount));
            contract.set("totalcalofamt", (Object)contract.getBigDecimal("totalcalofamt").add(settle.getBigDecimal("calofamt")));
            contract.set("totalcaloftaxamt", (Object)contract.getBigDecimal("totalcaloftaxamt").add(settle.getBigDecimal("caloftaxamt")));
            contract.set("totalnotcalofamt", (Object)contract.getBigDecimal("totalnotcalofamt").add(settle.getBigDecimal("notcalofamt")));
            contract.set("totalnotcaloftaxamt", (Object)contract.getBigDecimal("totalnotcaloftaxamt").add(settle.getBigDecimal("notcaloftaxamt")));
        } else {
            contract.set("totalsettleamount", (Object)totalSettleAmount.subtract(settleAmount));
            contract.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount.subtract(settleOfTaxAmount));
            contract.set("totalcalofamt", (Object)contract.getBigDecimal("totalcalofamt").subtract(settle.getBigDecimal("calofamt")));
            contract.set("totalcaloftaxamt", (Object)contract.getBigDecimal("totalcaloftaxamt").subtract(settle.getBigDecimal("caloftaxamt")));
            contract.set("totalnotcalofamt", (Object)contract.getBigDecimal("totalnotcalofamt").subtract(settle.getBigDecimal("notcalofamt")));
            contract.set("totalnotcaloftaxamt", (Object)contract.getBigDecimal("totalnotcaloftaxamt").subtract(settle.getBigDecimal("notcaloftaxamt")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.contractCostLimit(e);
    }

    private void contractCostLimit(BeforeOperationArgs e) {
        String operateKey = e.getOperationKey();
        if (operateKey.equals("unaudit")) {
            List settleBills = e.getValidExtDataEntities();
            for (ExtendedDataEntity entity : settleBills) {
                DynamicObject dataEntity = entity.getDataEntity();
                Long pkValue = (Long)dataEntity.getPkValue();
                DynamicObject[] contractCosts = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)"billname,entryentity.settleid", null);
                if (contractCosts.length <= 0) continue;
                for (DynamicObject bill : contractCosts) {
                    DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryEntity) {
                        Long settleId = row.getLong("settleid");
                        if (!settleId.equals(pkValue)) continue;
                        String formatText = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5408\u540c\u6210\u672c\u5206\u644a\u201c%2$s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"OutContractSettleOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), dataEntity.getString("billno"), bill.getString("billno"));
                        this.addErrMessage(entity, formatText);
                        e.cancel = true;
                    }
                }
            }
        }
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] settleBills;
        super.beginOperationTransaction(e);
        String operation = e.getOperationKey();
        for (DynamicObject settleBill : settleBills = e.getDataEntities()) {
            if (!"audit".equals(operation) && !"unaudit".equals(operation)) continue;
            List<DynamicObject> listingEntries = settleBill.getDynamicObjectCollection("listmodelentry").stream().flatMap(modelObj -> modelObj.getDynamicObjectCollection("listentry").stream()).collect(Collectors.toList());
            boolean isAudit = "audit".equals(operation);
            this.updateListing(listingEntries, isAudit);
        }
    }

    private void updateListing(List<DynamicObject> listingEntries, boolean isaudit) {
        ArrayList listingArr = new ArrayList();
        BigDecimal coefficient = isaudit ? BigDecimal.ONE : BigDecimal.valueOf(-1L);
        listingEntries.forEach(obj -> {
            BigDecimal thisQty = coefficient.multiply(obj.getBigDecimal("thisqty"));
            BigDecimal thisOfTaxAmount = coefficient.multiply(obj.getBigDecimal("thisoftaxmount"));
            DynamicObject listing = obj.getDynamicObject("listing");
            String listingId = listing.getString("id");
            DynamicObject listingObj = BusinessDataServiceHelper.loadSingle((Object)listingId, (String)"pmct_contractlist");
            listingObj.set("lstsettleqty", (Object)thisQty.add(listingObj.getBigDecimal("lstsettleqty")));
            BigDecimal settleOfTaxAmount = thisOfTaxAmount.add(listingObj.getBigDecimal("lstsettleoftaxamount"));
            listingObj.set("lstsettleoftaxamount", (Object)settleOfTaxAmount);
            if (isaudit) {
                listingObj.set("lstsettletaxamt", (Object)settleOfTaxAmount.subtract(obj.getBigDecimal("lstamount")));
            } else {
                BigDecimal lstSettleTaxAmt = listingObj.getBigDecimal("lstsettletaxamt");
                listingObj.set("lstsettletaxamt", (Object)lstSettleTaxAmt.subtract(obj.getBigDecimal("thistax")));
            }
            listingArr.add(listingObj);
        });
        if (listingArr.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)listingArr.get(0)).getDataEntityType(), (Object[])listingArr.toArray(new DynamicObject[0]));
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OutContractSettleCheckBeforeOp", ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u7b97\u5355\u64cd\u4f5c\u524d\u6821\u9a8c\u3002", (String)"OutContractSettleOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

