/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class ApplyPaymentBudgetValidator
extends AbstractValidator {
    private final List<AbstractValidator> validators;

    public ApplyPaymentBudgetValidator(List<AbstractValidator> validators) {
        this.validators = validators;
    }

    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            this.vaildBudget(key);
        }
    }

    private void vaildBudget(String key) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject payBill = dataEntity.getDataEntity();
            DynamicObject contract = payBill.getDynamicObject("contract");
            DynamicObject project = payBill.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean projectCostControl = this.isProjectCostControl(payBill);
            if (!projectCostControl) continue;
            Map<Object, Object> budgetAmountMap = new HashMap(16);
            if (project != null) {
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                if (isNew) continue;
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApps != null && proApps.length > 0) {
                    budgetAmountMap = this.buildBudgetAmountMap(payBill, BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApps[0]));
                }
            } else {
                Set<Object> controlProIdSet = this.getProIdSet(payBill);
                Set<Object> oldProIdSet = controlProIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
                budgetAmountMap = this.buildBudgetAmountMap(payBill, oldProIdSet);
            }
            BudgetValidateInfo validateInfo = null;
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY);
            } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)payBill.getLong("id"), (String)"pmct_applymentpay", (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY, (boolean)false);
            } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)payBill.getLong("id"), (String)"pmct_applymentpay", (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY, (boolean)true);
            }
            this.analysisValidateInfo(dataEntity, validateInfo, null);
        }
    }

    private Set<Object> getProIdSet(DynamicObject payBill) {
        DynamicObjectCollection entryEntity;
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = payBill.getDynamicObject("contract");
        DynamicObject project = payBill.getDynamicObject("project");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            if (project == null) {
                DynamicObjectCollection entryEntity2 = payBill.getDynamicObjectCollection("splitentry");
                proIdSet = new HashSet(entryEntity2.size());
                for (DynamicObject entry : entryEntity2) {
                    DynamicObject budgetItem = entry.getDynamicObject("bugdetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
            }
        } else if (project == null && !(entryEntity = payBill.getDynamicObjectCollection("splitentry")).isEmpty()) {
            project = contract.getDynamicObject("project");
            proIdSet.add(project.getPkValue());
        }
        return proIdSet;
    }

    private boolean isProjectCostControl(DynamicObject bill) {
        DynamicObject[] proApps;
        DynamicObject project = bill.getDynamicObject("project");
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"multipartsettlement", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())})).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            if (project != null) {
                DynamicObject[] proApps2 = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApps2 != null && proApps2.length > 0 && proApps2[0].getBoolean("projectcostcontrol")) {
                    return true;
                }
            } else {
                DynamicObject[] proApps3;
                DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("splitentry");
                HashSet<Object> proIdSet = new HashSet<Object>();
                for (DynamicObject entry : entryEntity) {
                    DynamicObject budgetItem = entry.getDynamicObject("bugdetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
                for (DynamicObject proApp : proApps3 = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                    boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                    if (!projectCostControl) continue;
                    return true;
                }
            }
        } else if (project != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
            return true;
        }
        return false;
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject proCurrency;
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ApplyPaymentBudgetValidator_10", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        proCurrency = originalBudget.getDynamicObject("currency");
                        if (proCurrency != null) {
                            amtPrecision = proCurrency.getInt("amtprecision");
                        }
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%2$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%3$s\u3002", (String)"ApplyPaymentBudgetValidator_11", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"ApplyPaymentBudgetValidator_12", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    proCurrency = originalBudget.getDynamicObject("currency");
                    if (proCurrency != null) {
                        amtPrecision = proCurrency.getInt("amtprecision");
                    }
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"ApplyPaymentBudgetValidator_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("splitentry");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("cursplitamt");
            DynamicObject budget = entry.getDynamicObject("bugdetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, Set<Object> controlProIdSet) {
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", controlProIdSet)});
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : controlProIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("splitentry");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("cursplitamt");
            DynamicObject budget = entry.getDynamicObject("bugdetitem");
            DynamicObject project = budget.getDynamicObject("project");
            if (!controlProIdSet.contains(project.getPkValue()) || budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)hashMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            hashMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return hashMap;
    }

    protected Map<Long, BigDecimal> buildBudgetAmountMapWithLongKey(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<Long, BigDecimal> budgetAmountMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("splitentry");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("cursplitamt");
            DynamicObject budget = entry.getDynamicObject("bugdetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(Long.valueOf(budget.getPkValue().toString()));
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(Long.valueOf(budget.getPkValue().toString()), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    @Deprecated
    protected boolean controlAmount(ExtendedDataEntity dataEntity, DynamicObject payBill, DynamicObject contract) {
        boolean outControl = false;
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
        String settleControlApplyParam = contractType.getString("settlecontrolapply");
        String ammountControlApplyParam = contractType.getString("ammountcontrolapply");
        if ("2".equals(settleControlApplyParam)) {
            outControl = this.settleControl(dataEntity, payBill, contract, outControl);
        } else if ("2".equals(ammountControlApplyParam)) {
            outControl = this.contractControl(dataEntity, payBill, contract, outControl);
        }
        if (!outControl && ("1".equals(settleControlApplyParam) || "1".equals(ammountControlApplyParam))) {
            this.remindControl(dataEntity, payBill, contract, settleControlApplyParam, ammountControlApplyParam);
        }
        return outControl;
    }

    private void remindControl(ExtendedDataEntity dataEntity, DynamicObject payBill, DynamicObject contract, String settleControlApplyParam, String ammountControlApplyParam) {
        Map<Long, BigDecimal> budgetAmountMap = this.buildBudgetAmountMapWithLongKey(payBill, BigDecimal.ONE);
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        for (Map.Entry<Long, BigDecimal> map : budgetAmountMap.entrySet()) {
            QFilter filter1 = new QFilter("budgetitem", "=", (Object)map.getKey());
            DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter, filter1});
            if (contractBudgets.length <= 0) continue;
            BigDecimal payAmount = map.getValue().add(contractBudgets[0].getBigDecimal("payapplysubmitamtex"));
            DynamicObject contractstatus = contract.getDynamicObject("contractstatus");
            DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)map.getKey(), (String)"pmas_projectbudget");
            if ("1".equals(settleControlApplyParam)) {
                if (contractstatus != null && ContractStatusEnum.CLOSED.getValue().equals(contractstatus.getString("number"))) {
                    if (payAmount.compareTo(contractBudgets[0].getBigDecimal("contractauditamtex")) > 0) {
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u51b3\u7b97\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPaymentBudgetValidator_14", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                    }
                } else if (payAmount.compareTo(contractBudgets[0].getBigDecimal("settleauditamtex")) > 0) {
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPaymentBudgetValidator_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                }
            }
            if (!"1".equals(ammountControlApplyParam) || payAmount.compareTo(contractBudgets[0].getBigDecimal("contractauditamtex")) <= 0) continue;
            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPaymentBudgetValidator_16", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
        }
    }

    private boolean contractControl(ExtendedDataEntity dataEntity, DynamicObject payBill, DynamicObject contract, boolean outControl) {
        Map<Long, BigDecimal> budgetAmountMap = this.buildBudgetAmountMapWithLongKey(payBill, BigDecimal.ONE);
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        for (Map.Entry<Long, BigDecimal> map : budgetAmountMap.entrySet()) {
            BigDecimal payAmount;
            QFilter filter1 = new QFilter("budgetitem", "=", (Object)map.getKey());
            DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter, filter1});
            if (contractBudgets.length <= 0 || (payAmount = map.getValue().add(contractBudgets[0].getBigDecimal("payapplysubmitamtex"))).compareTo(contractBudgets[0].getBigDecimal("contractauditamtex")) <= 0) continue;
            DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)map.getKey(), (String)"pmas_projectbudget");
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u5408\u540c\u91d1\u989d\u3002", (String)"ApplyPaymentBudgetValidator_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
            outControl = true;
        }
        return outControl;
    }

    private boolean settleControl(ExtendedDataEntity dataEntity, DynamicObject payBill, DynamicObject contract, boolean outControl) {
        Map<Long, BigDecimal> budgetAmountMap = this.buildBudgetAmountMapWithLongKey(payBill, BigDecimal.ONE);
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        for (Map.Entry<Long, BigDecimal> map : budgetAmountMap.entrySet()) {
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", (Object)map.getKey());
            DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{contractFilter, budgetItemFilter});
            if (contractBudgets.length <= 0) continue;
            BigDecimal payAmount = map.getValue().add(contractBudgets[0].getBigDecimal("payapplysubmitamtex"));
            DynamicObject contractstatus = contract.getDynamicObject("contractstatus");
            DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)map.getKey(), (String)"pmas_projectbudget");
            if (contractstatus != null && ContractStatusEnum.CLOSED.getValue().equals(contractstatus.getString("number"))) {
                if (payAmount.compareTo(contractBudgets[0].getBigDecimal("contractauditamtex")) <= 0) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u51b3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentBudgetValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
                outControl = true;
                continue;
            }
            if (payAmount.compareTo(contractBudgets[0].getBigDecimal("settleauditamtex")) <= 0) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%s\u201d\u7684\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u3002", (String)"ApplyPaymentBudgetValidator_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), budget.getString("name")));
            outControl = true;
        }
        return outControl;
    }
}

