/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class IncomeApplyBudgetValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") && (dataEntities = this.getDataEntities()) != null && dataEntities.length > 0) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject incomeApplyBill = dataEntity.getDataEntity();
                DynamicObjectCollection incomeApplyEntry = incomeApplyBill.getDynamicObjectCollection("entryentity");
                if (incomeApplyEntry == null || incomeApplyEntry.isEmpty()) {
                    return;
                }
                this.incomeApplyAmountValidate(dataEntity, incomeApplyBill, incomeApplyEntry);
            }
        }
    }

    private boolean isProjectCostControl(DynamicObject bill, DynamicObject contractEntry) {
        DynamicObject contract = contractEntry.getDynamicObject("entrycontract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((String)"pmct_incontract", (String)"multipartsettlement,project", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())})).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject project = bill.getDynamicObject("project");
            if (project != null) {
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApps != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                    return true;
                }
            } else {
                DynamicObject[] proApps;
                DynamicObjectCollection entryEntity = contractEntry.getDynamicObjectCollection("inapplysplitentry");
                HashSet<Object> proIdSet = new HashSet<Object>(entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
                for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                    boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                    if (!projectCostControl) continue;
                    return true;
                }
            }
        } else {
            DynamicObject[] proApps;
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                return true;
            }
        }
        return false;
    }

    private boolean incomeApplyAmountValidate(ExtendedDataEntity dataEntity, DynamicObject bill, DynamicObjectCollection infoEntry) {
        for (DynamicObject contractEntryRow : infoEntry) {
            boolean projectCostControl;
            DynamicObjectCollection incomeSplitEntry = contractEntryRow.getDynamicObjectCollection("inapplysplitentry");
            if (incomeSplitEntry.isEmpty() || !(projectCostControl = this.isProjectCostControl(bill, contractEntryRow))) continue;
            BigDecimal curSplitTotalAmount = BigDecimal.ZERO;
            for (DynamicObject entry : incomeSplitEntry) {
                BigDecimal curSplitAmount = entry.getBigDecimal("cursplitamt");
                if (curSplitAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                curSplitTotalAmount = curSplitTotalAmount.add(curSplitAmount);
            }
            BigDecimal curApplyTotal = contractEntryRow.getBigDecimal("applyoftaxamount");
            if (curApplyTotal.compareTo(curSplitTotalAmount) == 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u201c\u8bf7\u6b3e\u5206\u644a\u201d\u7684\u201c\u672c\u6b21\u8bf7\u6b3e\u5206\u644a\u91d1\u989d\u201d\u603b\u8ba1\u5e94\u7b49\u4e8e\u201c\u5408\u540c\u8bf7\u6b3e\u4fe1\u606f\u201d\u7684\u201c\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"IncomeApplyBudgetValidator_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

