/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class IncomeApplyOp
extends AbstractReverseWritingPmctContractOp {
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_AUDIT = "audit";
    private static final String OPERATION_UNAUDIT = "unaudit";
    private static final String OPERATION_CONFIRMBILLREC = "confirmbillrec";
    private static String selector = Stream.of("totalapplyoftaxamount", "totalapplyamount", "ismultirate", "avgtaxrate", "taxrate", "totalinvoiceamount", "totalinvoiceoftaxamount").collect(Collectors.joining(","));

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("entryentity.applyoftaxamount");
        fields.add("entryentity.entrycontract");
        fields.add("sourcetype");
        fields.add("billno");
        fields.add("org");
        fields.add("isbillreceive");
        fields.add("entryentity");
        fields.add("isentryallrec");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new IncomeApplyInvoiceValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)OPERATION_CONFIRMBILLREC, (CharSequence)key)) {
            for (DynamicObject bill : dataEntities) {
                if (bill.getBoolean("isbillreceive")) continue;
                bill.set("isbillreceive", (Object)true);
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    entry.set("isentryallrec", (Object)true);
                }
                SaveServiceHelper.update((DynamicObject)bill);
            }
        }
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
        if ("submit".equals(operationKey)) {
            return;
        }
        DynamicObject incomeApply = BusinessDataServiceHelper.loadSingle((Object)source.getPkValue(), (String)"pmct_incomeapply");
        DynamicObjectCollection entryEntity = incomeApply.getDynamicObjectCollection("entryentity");
        if (entryEntity.size() > 0) {
            ArrayList contractList = new ArrayList(10);
            HashMap<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject incomeEntryObj : entryEntity) {
                DynamicObject taxRate;
                DynamicObject contract;
                if (null == incomeEntryObj.getDynamicObject("entrycontract")) continue;
                BigDecimal thisApplyOfTaxAmount = incomeEntryObj.getBigDecimal("applyoftaxamount");
                Long contractId = incomeEntryObj.getDynamicObject("entrycontract").getLong("id");
                DynamicObject value = (DynamicObject)contractMap.get(contractId);
                if (value != null) {
                    contract = (DynamicObject)contractMap.get(contractId);
                } else {
                    contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_incontract", (String)selector);
                    contractMap.put(contractId, contract);
                }
                BigDecimal totalApplyOfTaxAmount = contract.getBigDecimal("totalapplyoftaxamount");
                BigDecimal totalApplyAmount = contract.getBigDecimal("totalapplyamount");
                boolean isMultiRate = contract.getBoolean("ismultirate");
                BigDecimal rate = isMultiRate ? contract.getBigDecimal("avgtaxrate") : ((taxRate = contract.getDynamicObject("taxrate")) == null ? BigDecimal.ZERO : taxRate.getBigDecimal("taxrate"));
                BigDecimal thisApplyAmount = thisApplyOfTaxAmount.divide(BigDecimal.ONE.add(rate.divide(new BigDecimal(100))), 6, 5);
                if (operationKey.equals(OPERATION_AUDIT)) {
                    contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.add(thisApplyOfTaxAmount));
                    contract.set("totalapplyamount", (Object)totalApplyAmount.add(thisApplyAmount));
                    continue;
                }
                if (!operationKey.equals(OPERATION_UNAUDIT)) continue;
                contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.subtract(thisApplyOfTaxAmount));
                contract.set("totalapplyamount", (Object)totalApplyAmount.subtract(thisApplyAmount));
            }
            Set entriesSet = contractMap.entrySet();
            for (Map.Entry entry : entriesSet) {
                contractList.add(entry.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])contractList.toArray(new DynamicObject[contractList.size()]));
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        switch (key) {
            case "delete": {
                this.updateInvoice(bills, OPERATION_DELETE);
                break;
            }
            case "audit": {
                this.updateInvoice(bills, OPERATION_AUDIT);
                break;
            }
            case "unaudit": {
                this.updateInvoice(bills, OPERATION_UNAUDIT);
                break;
            }
        }
    }

    private void updateInvoice(DynamicObject[] bills, String operation) {
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)bills[i].getPkValue(), (String)"pmct_incomeapply");
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
            if (entryCol.size() == 0) continue;
            for (DynamicObject entryObj : entryCol) {
                DynamicObject contract = entryObj.getDynamicObject("entrycontract");
                DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
                if (subEntryCol.size() <= 0) continue;
                this.updateInvoiceInfo(bill, contract, subEntryCol, operation);
            }
        }
    }

    private void updateInvoiceInfo(DynamicObject bill, DynamicObject contract, DynamicObjectCollection subEntryCol, String operation) {
        DynamicObject[] invArr = new DynamicObject[subEntryCol.size()];
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        BigDecimal totalInvoiceAmount = contract.getBigDecimal("totalinvoiceamount");
        BigDecimal totalInvoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
        for (int i = 0; i < subEntryCol.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subEntryCol.get(i);
            DynamicObject invoice = subEntry.getDynamicObject("invoice");
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_outinvoice", (String)"isClaimed,contract,project,isused,totaloftaxamount,totalamount");
            if (operation.equals(OPERATION_DELETE)) {
                boolean isUpdateInvoice = subEntry.getBoolean("isupdateinvoice");
                if (isUpdateInvoice) {
                    invoice.set("isclaimed", (Object)Boolean.FALSE);
                    invoice.set("project", null);
                    invoice.set("contract", null);
                    totalInvoiceAmount = totalInvoiceAmount.subtract(invoice.getBigDecimal("totalamount"));
                    totalInvoiceOfTaxAmount = totalInvoiceOfTaxAmount.subtract(invoice.getBigDecimal("totaloftaxamount"));
                }
            } else if (operation.equals(OPERATION_AUDIT)) {
                if (!invoice.getBoolean("isused")) {
                    invoice.set("isused", (Object)true);
                }
            } else if (operation.equals(OPERATION_UNAUDIT)) {
                QFilter filter = new QFilter("id", "!=", (Object)Long.parseLong(bill.getPkValue().toString()));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("org", "=", (Object)Long.parseLong(bill.getDynamicObject("org").getPkValue().toString())));
                DynamicObject[] incomeApplies = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"id", (QFilter[])new QFilter[]{filter});
                HashSet entryIds = new HashSet();
                if (incomeApplies != null && incomeApplies.length > 0) {
                    Arrays.stream(incomeApplies).forEach(income -> {
                        income = BusinessDataServiceHelper.loadSingle((Object)income.getPkValue(), (String)"pmct_incomeapply");
                        DynamicObjectCollection entryEntity = income.getDynamicObjectCollection("entryentity");
                        Set pks = entryEntity.stream().map(entry -> Long.parseLong(entry.getPkValue().toString())).collect(Collectors.toSet());
                        entryIds.addAll(pks);
                    });
                }
                String invId = invoice.getPkValue().toString();
                DynamicObject[] col1 = BusinessDataServiceHelper.load((String)"pmct_incomeapplyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0]);
                boolean isUsed = false;
                for (DynamicObject entry : col1) {
                    if (entry.getDynamicObject("invoice") == null || !invId.equals(entry.getDynamicObject("invoice").getString("id")) || entryIds.size() <= 0 || !entryIds.contains(entry.getLong("entryid"))) continue;
                    isUsed = true;
                    break;
                }
                invoice.set("isused", (Object)isUsed);
            }
            invArr[i] = invoice;
        }
        contract.set("totalinvoiceoftaxamount", (Object)totalInvoiceOfTaxAmount);
        contract.set("totalinvoiceamount", (Object)totalInvoiceAmount);
        SaveServiceHelper.update((DynamicObject)contract);
        SaveServiceHelper.save((DynamicObject[])invArr);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || OPERATION_AUDIT.equals(operationKey) || OPERATION_UNAUDIT.equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObject incomeApplyObj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_incomeapply");
                DynamicObjectCollection entryColl = incomeApplyObj.getDynamicObjectCollection("entryentity");
                List<DynamicObject> entrys = entryColl.stream().filter(entry -> null != entry.get("incomeitem")).collect(Collectors.toList());
                ContractPayItemHelper.doUpdate((DynamicObject)incomeApplyObj, (DynamicObject[])entrys.toArray(new DynamicObject[0]), (String)operationKey);
            }
        }
    }

    static class IncomeApplyInvoiceValidator
    extends AbstractValidator {
        IncomeApplyInvoiceValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            String key = this.getOperateKey();
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject bill = dataEntity.getDataEntity();
                if (StringUtils.equals((CharSequence)IncomeApplyOp.OPERATION_UNAUDIT, (CharSequence)key)) {
                    if (!bill.getBoolean("isbillreceive")) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6574\u5355\u6536\u6b3e\u7684\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"IncomeApplyOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (!StringUtils.equals((CharSequence)IncomeApplyOp.OPERATION_CONFIRMBILLREC, (CharSequence)key) || !bill.getBoolean("isbillreceive")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6574\u5355\u6536\u6b3e\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u6574\u5355\u6536\u6b3e\u786e\u8ba4\u3002", (String)"IncomeApplyOp_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

