/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateInfo;

public class PayApplyBudgetValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
                this.payApplyAmountValidate();
            }
            this.vaildBudget(key);
        }
    }

    private boolean payApplyAmountValidate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject payApplyBill = dataEntity.getDataEntity();
            DynamicObjectCollection contractEntrys = payApplyBill.getDynamicObjectCollection("entryentity");
            if (contractEntrys.isEmpty()) {
                return false;
            }
            for (int contractIndex = 0; contractIndex < contractEntrys.size(); ++contractIndex) {
                DynamicObjectCollection payApplySplitEntry = ((DynamicObject)contractEntrys.get(contractIndex)).getDynamicObjectCollection("payapplysplitentry");
                boolean projectCostControl = this.isProjectCostControl(payApplyBill, (DynamicObject)contractEntrys.get(contractIndex));
                if (!projectCostControl) continue;
                BigDecimal curSplitTotalAmount = BigDecimal.ZERO;
                for (DynamicObject entry : payApplySplitEntry) {
                    BigDecimal curSplitAmount;
                    if (entry.getBoolean("prepaysplit") || (curSplitAmount = entry.getBigDecimal("cursplitamt")).compareTo(BigDecimal.ZERO) == 0) continue;
                    curSplitTotalAmount = curSplitTotalAmount.add(curSplitAmount);
                }
                BigDecimal thisPayAbleAmount = ((DynamicObject)contractEntrys.get(contractIndex)).getBigDecimal("thispayableamount");
                if (thisPayAbleAmount.compareTo(curSplitTotalAmount) == 0) continue;
                DynamicObject currency = ((DynamicObject)contractEntrys.get(contractIndex)).getDynamicObject("contcurrency");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u7b2c%1$s\u884c\uff1a\u201c\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u201d%3$s\u5e94\u7b49\u4e8e\u5bf9\u5e94\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u4e2d\u975e\u201c\u9884\u4ed8\u6b3e\u5206\u644a\u9884\u7b97\u9879\u201d\u7684\u201c\u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u91d1\u989d\u201d\u603b\u8ba1%2$s\u3002", (String)"PayApplyBudgetValidator_17", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contractIndex + 1, CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)curSplitTotalAmount), CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)thisPayAbleAmount)));
            }
        }
        return false;
    }

    private void vaildBudget(String operationKey) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            boolean projectCostControl;
            DynamicObject payBill = dataEntity.getDataEntity();
            DynamicObjectCollection contractEntrys = payBill.getDynamicObjectCollection("entryentity");
            HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject contractEntryRow : contractEntrys) {
                projectCostControl = this.isProjectCostControl(payBill, contractEntryRow);
                if (!projectCostControl) continue;
                DynamicObject project = payBill.getDynamicObject("project");
                DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
                if (project != null) {
                    DynamicObject[] proApps;
                    boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                    if (isNew || (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) == null || proApps.length <= 0) continue;
                    this.buildBudgetAmountMap(budgetAmountMap, contractEntryRow, BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApps[0]));
                    continue;
                }
                Set<Object> proIdSet = this.getProIdSet(payBill, contractEntryRow);
                Set<Object> oldProIdSet = proIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
                this.buildBudgetAmountMap(budgetAmountMap, contractEntryRow, oldProIdSet);
            }
            for (DynamicObject contractEntryRow : contractEntrys) {
                projectCostControl = this.isProjectCostControl(payBill, contractEntryRow);
                if (!projectCostControl) continue;
                DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
                BudgetValidateInfo validateInfo = null;
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnSubmit(budgetAmountMap, (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY);
                } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)payBill.getLong("id"), (String)"pmct_paymentapply", (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY, (boolean)false);
                } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) {
                    validateInfo = BudgetValidateAndUpdateHelper.validateBudgetAmountOnAuditAndUnaudit(budgetAmountMap, (String)contract.getPkValue().toString(), (long)payBill.getLong("id"), (String)"pmct_paymentapply", (PerformAmountTypeEnum)PerformAmountTypeEnum.PAY, (boolean)true);
                }
                this.analysisValidateInfo(dataEntity, validateInfo, null);
            }
        }
    }

    private boolean isProjectCostControl(DynamicObject bill, DynamicObject contractEntry) {
        DynamicObjectCollection entryEntity = contractEntry.getDynamicObjectCollection("payapplysplitentry");
        if (entryEntity.isEmpty()) {
            return false;
        }
        DynamicObject contract = contractEntry.getDynamicObject("entrycontract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"multipartsettlement,project", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())})).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject project = bill.getDynamicObject("project");
            if (project != null) {
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApps != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                    return true;
                }
            } else {
                DynamicObject[] proApps;
                HashSet<Object> proIdSet = new HashSet<Object>(entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    DynamicObject budgetItem = entry.getDynamicObject("bugdetitem");
                    if (budgetItem == null) continue;
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
                for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                    boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                    if (!projectCostControl) continue;
                    return true;
                }
            }
        } else {
            DynamicObject[] proApps;
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                return true;
            }
        }
        return false;
    }

    private Set<Object> getProIdSet(DynamicObject payBill, DynamicObject contractEntryRow) {
        DynamicObjectCollection entryEntity;
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        DynamicObject project = payBill.getDynamicObject("project");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            if (project == null) {
                DynamicObjectCollection entryEntity2 = contractEntryRow.getDynamicObjectCollection("payapplysplitentry");
                proIdSet = new HashSet(entryEntity2.size());
                for (DynamicObject entry : entryEntity2) {
                    DynamicObject budgetItem = entry.getDynamicObject("bugdetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
            }
        } else if (project == null && !(entryEntity = contractEntryRow.getDynamicObjectCollection("payapplysplitentry")).isEmpty()) {
            project = contract.getDynamicObject("project");
            proIdSet.add(project.getPkValue());
        }
        return proIdSet;
    }

    protected void buildBudgetAmountMap(Map<String, BigDecimal> budgetAmountMap, DynamicObject contractEntryRow, Set<Object> controlProIdSet) {
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", controlProIdSet)});
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : controlProIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        DynamicObjectCollection entryentity = contractEntryRow.getDynamicObjectCollection("payapplysplitentry");
        for (DynamicObject entry : entryentity) {
            DynamicObject project;
            if (entry.getBoolean("prepaysplit")) continue;
            BigDecimal amount = entry.getBigDecimal("cursplitamt");
            DynamicObject budget = entry.getDynamicObject("bugdetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0 || (project = budget.getDynamicObject("project")) == null || !controlProIdSet.contains(project.getPkValue())) continue;
            BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
    }

    protected void buildBudgetAmountMap(Map<String, BigDecimal> budgetAmountMap, DynamicObject contractEntryRow, BigDecimal exchangeRate) {
        DynamicObjectCollection entryentity = contractEntryRow.getDynamicObjectCollection("payapplysplitentry");
        for (DynamicObject entry : entryentity) {
            if (entry.getBoolean("prepaysplit")) continue;
            BigDecimal amount = entry.getBigDecimal("cursplitamt");
            DynamicObject budget = entry.getDynamicObject("bugdetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
    }

    protected void analysisValidateInfo(ExtendedDataEntity dataEntity, BudgetValidateInfo validateInfo, DynamicObject currency) {
        if (validateInfo != null) {
            boolean outOfControl = validateInfo.isOutOfControl();
            boolean outOfRemind = validateInfo.isOutOfRemind();
            Map resultMap = validateInfo.getResultMap();
            if (resultMap != null && !resultMap.isEmpty()) {
                int amtPrecision = 2;
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                }
                for (Map.Entry resultEntry : resultMap.entrySet()) {
                    DynamicObject originalBudget = (DynamicObject)resultEntry.getKey();
                    DynamicObject validateBudget = (DynamicObject)resultEntry.getValue();
                    String projectNumber = originalBudget.getDynamicObject("project").getString("number");
                    String projectName = originalBudget.getDynamicObject("project").getString("name");
                    if (originalBudget.getPkValue().equals(validateBudget.getPkValue())) {
                        if (outOfControl) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%1$s\u7684\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"PayApplyBudgetValidator_18", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), projectName, originalBudget.getString("name")));
                            continue;
                        }
                        if (!outOfRemind) continue;
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%1$s\u7684\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%3$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%4$s\u3002", (String)"PayApplyBudgetValidator_22", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), projectName, originalBudget.getString("name"), originalBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), originalBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                        continue;
                    }
                    if (outOfControl) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%1$s\u7684\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%3$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u63a7\u5236\u9650\u989d\u3002", (String)"PayApplyBudgetValidator_20", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), projectName, originalBudget.getString("name"), validateBudget.getString("name")));
                        continue;
                    }
                    if (!outOfRemind) continue;
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%1$s\u7684\u9884\u7b97\u9879\u201c%2$s\u201d\u7684\u4e0a\u7ea7\u9884\u7b97\u9879\u201c%3$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u5df2\u7ecf\u8fbe\u5230%4$s\uff0c\u9884\u7b97\u91d1\u989d\u662f%5$s\u3002", (String)"PayApplyBudgetValidator_21", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), projectName, originalBudget.getString("name"), validateBudget.getString("name"), validateBudget.getBigDecimal("occupyamt").setScale(amtPrecision, RoundingMode.DOWN).toString(), validateBudget.getBigDecimal("budgetamount").setScale(amtPrecision, RoundingMode.DOWN).toString()));
                }
            }
        }
    }
}

