/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.apply;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.service.BudgetPrePayService;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.CtrlStrategyEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.InvoiceCloudVOStatusEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.business.service.PrePayService;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;

public class PayApplyOp
extends AbstractReverseWritingPmctContractOp {
    private static final Log log = LogFactory.getLog(PayApplyOp.class);
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_AUDIT = "audit";
    private static final String OPERATION_UNAUDIT = "unaudit";
    private static final String OPERATE_BILL_PAY_CONFIRM = "billpayconfirm";
    private static final String OPERATE_PAY_INIT = "payinit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("entryentity.applyoftaxamount");
        fields.add("entryentity.entrycontract");
        fields.add("entryentity.thispayableamount");
        fields.add("entryentity.payitem");
        fields.add("entryentity.payoff");
        fields.add("entryentity.thispayableamount");
        fields.add("entryentity.entrypaidamount");
        fields.add("subentryentity.invoice");
        fields.add("subentryentity.isupdateinvoice");
        fields.add("subentryentity.applyoftaxamtvo");
        fields.add("payapplysplitentry.prepaysplit");
        fields.add("sourcetype");
        fields.add("project");
        fields.add("billno");
        fields.add("billpayoff");
        fields.add("init");
        fields.add("billstatus");
        fields.add("payableamount");
        fields.add("allpaidamount");
        fields.add("totaloftaxamount");
        fields.add("applyoftaxamount");
        fields.add("totalsettleoftaxamount");
        fields.add("paymenttype");
        fields.add("thisprepaydeduction");
        fields.add("contpro");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] operationKey = e.getOperationKey();
        if ("save".equals(operationKey) || "submit".equals(operationKey) || "unsubmit".equals(operationKey) || OPERATION_AUDIT.equals(operationKey) || OPERATION_UNAUDIT.equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            String status = null;
            switch (operationKey) {
                case "save": 
                case "unaudit": 
                case "unsubmit": {
                    status = StatusEnum.TEMPSAVE.getValue();
                    break;
                }
                case "submit": {
                    status = StatusEnum.UNCHECKED.getValue();
                    break;
                }
                case "audit": {
                    status = StatusEnum.CHECKED.getValue();
                    break;
                }
            }
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject payApplyObj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_paymentapply");
                DynamicObjectCollection entryColl = payApplyObj.getDynamicObjectCollection("entryentity");
                if (!"save".equals(operationKey)) {
                    List<DynamicObject> entries = entryColl.stream().filter(entry -> null != entry.get("payitem")).collect(Collectors.toList());
                    ContractPayItemHelper.doUpdate((DynamicObject)payApplyObj, (DynamicObject[])entries.toArray(new DynamicObject[0]), (String)operationKey);
                }
                this.fillPaymentApplyCont(payApplyObj, entryColl, status);
                if ("save".equals(operationKey)) continue;
                this.doUpdateInvoiceAmt(payApplyObj, entryColl, (String)operationKey);
            }
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATE_BILL_PAY_CONFIRM)) {
            DynamicObject[] dataEntities;
            for (DynamicObject payApplyObj : dataEntities = e.getDataEntities()) {
                payApplyObj.set("billpayoff", (Object)Boolean.TRUE);
                payApplyObj.getDynamicObjectCollection("entryentity").stream().forEach(entry -> entry.set("payoff", (Object)Boolean.TRUE));
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATE_PAY_INIT)) {
            DynamicObject[] dataEntities;
            for (DynamicObject payApplyObj : dataEntities = e.getDataEntities()) {
                payApplyObj.set("init", (Object)Boolean.TRUE);
                payApplyObj.set("billpayoff", (Object)Boolean.TRUE);
                payApplyObj.set("allpaidamount", (Object)payApplyObj.getBigDecimal("payableamount"));
                for (DynamicObject entry2 : payApplyObj.getDynamicObjectCollection("entryentity")) {
                    entry2.set("payoff", (Object)Boolean.TRUE);
                    entry2.set("entrypaidamount", (Object)entry2.getBigDecimal("thispayableamount"));
                }
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    private void doUpdateInvoiceAmt(DynamicObject payApplyObj, DynamicObjectCollection entryColl, String operationKey) {
        if (entryColl.size() > 0) {
            List<Object> invoiceList = new ArrayList(10);
            if (OPERATION_AUDIT.equals(operationKey)) {
                DynamicObject[] invoices;
                List<Object> listInvoiceIds = new ArrayList(10);
                for (DynamicObject dynamicObject : entryColl) {
                    DynamicObjectCollection invoiceEntities = dynamicObject.getDynamicObjectCollection("subentryentity");
                    listInvoiceIds = invoiceEntities.stream().filter(o -> o.getDynamicObject("invoice") != null).map(o -> Long.parseLong(o.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toList());
                }
                if (listInvoiceIds.size() > 0 && (invoices = BusinessDataServiceHelper.load((Object[])listInvoiceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"))).length > 0) {
                    invoiceList = Arrays.stream(invoices).collect(Collectors.toList());
                }
            } else {
                HashMap<Object, BigDecimal> invoiceTotalUseAmtMap = new HashMap<Object, BigDecimal>(16);
                for (DynamicObject dynamicObject : entryColl) {
                    DynamicObjectCollection invoiceEntities = dynamicObject.getDynamicObjectCollection("subentryentity");
                    if (invoiceEntities.size() <= 0) continue;
                    for (DynamicObject invoiceEntity : invoiceEntities) {
                        DynamicObject invoice2 = invoiceEntity.getDynamicObject("invoice");
                        if (invoice2 == null) continue;
                        BigDecimal applyOfTaxAmtVO = invoiceEntity.getBigDecimal("applyoftaxamtvo");
                        BigDecimal AmtByInvoice = (BigDecimal)invoiceTotalUseAmtMap.get(invoice2.getPkValue());
                        if (AmtByInvoice == null) {
                            invoiceTotalUseAmtMap.put(invoice2.getPkValue(), applyOfTaxAmtVO);
                            continue;
                        }
                        invoiceTotalUseAmtMap.put(invoice2.getPkValue(), NumberHelper.add((Object)AmtByInvoice, (Object)applyOfTaxAmtVO));
                    }
                }
                for (Map.Entry entry : invoiceTotalUseAmtMap.entrySet()) {
                    DynamicObject invoice3 = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"pmct_ininvoice");
                    BigDecimal totalUseAmt = "submit".equals(operationKey) ? NumberHelper.add((Object)invoice3.getBigDecimal("totaluseamt"), entry.getValue()) : NumberHelper.subtract((Object)invoice3.getBigDecimal("totaluseamt"), entry.getValue());
                    invoice3.set("totaluseamt", (Object)totalUseAmt);
                    invoice3.set("availableamt", (Object)NumberHelper.subtract((Object)invoice3.getBigDecimal("totaloftaxamount"), (Object)totalUseAmt));
                    invoiceList.add(invoice3);
                }
                if (invoiceList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
                }
            }
            if (invoiceList.size() > 0) {
                List<DynamicObject> usedVOs = invoiceList.stream().filter(invoice -> invoice.getBigDecimal("totaloftaxamount").compareTo(invoice.getBigDecimal("totaluseamt")) == 0 && StringUtils.isNotBlank((CharSequence)"serialno")).collect(Collectors.toList());
                this.updateInvoiceStatus(payApplyObj, usedVOs, InvoiceCloudVOStatusEnum.USED.getValue());
                List<DynamicObject> inUseVOs = invoiceList.stream().filter(invoice -> invoice.getBigDecimal("totaloftaxamount").compareTo(invoice.getBigDecimal("totaluseamt")) != 0 && StringUtils.isNotBlank((CharSequence)"serialno")).collect(Collectors.toList());
                this.updateInvoiceStatus(payApplyObj, inUseVOs, InvoiceCloudVOStatusEnum.INUSE.getValue());
            }
        }
    }

    private void updateInvoiceStatus(DynamicObject bill, List<DynamicObject> invoices, String statusValue) {
        if (invoices != null && invoices.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("billId", bill.getPkValue().toString());
            map.put("billNo", bill.getString("billno"));
            map.put("billType", "pmct_paymentapply");
            map.put("entityId", "pmct_paymentapply");
            map.put("appId", "pmct");
            map.put("status", statusValue);
            ArrayList list = new ArrayList(16);
            for (DynamicObject invoice : invoices) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>(16);
                invoiceMap.put("serialNo", invoice.getString("serialno"));
                list.add(invoiceMap);
            }
            map.put("invoiceData", list);
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{map});
            if (!"0000".equals(result.getString("errcode"))) {
                log.error("---\u66f4\u65b0\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)result.getString("description"));
            }
        }
    }

    private void fillPaymentApplyCont(DynamicObject dataEntity, DynamicObjectCollection entryColl, String status) {
        ArrayList<DynamicObject> paymentApplyContList = new ArrayList<DynamicObject>(entryColl.size());
        for (DynamicObject entry : entryColl) {
            DynamicObject paymentApplyCont = BusinessDataServiceHelper.loadSingle((Object)entry.getPkValue(), (String)"pmct_paymentapplycont");
            paymentApplyCont.set("number", (Object)String.join((CharSequence)"_", dataEntity.getString("billno"), String.valueOf(entry.getInt("seq"))));
            paymentApplyCont.set("name", (Object)String.join((CharSequence)"_", dataEntity.getString("billname"), String.valueOf(entry.getInt("seq"))));
            paymentApplyCont.set("billno", (Object)dataEntity.getString("billno"));
            paymentApplyCont.set("org", (Object)dataEntity.getDynamicObject("org"));
            paymentApplyCont.set("billname", (Object)dataEntity.getString("billname"));
            paymentApplyCont.set("period", (Object)dataEntity.getDynamicObject("period"));
            paymentApplyCont.set("payitem", (Object)entry.getDynamicObject("payitem"));
            paymentApplyCont.set("status", (Object)status);
            paymentApplyCont.set("creator", (Object)dataEntity.getDynamicObject("creator"));
            paymentApplyCont.set("modifier", (Object)dataEntity.getDynamicObject("modifier"));
            paymentApplyCont.set("enable", (Object)EnableEnum.ENABLE.getValue());
            paymentApplyCont.set("createtime", (Object)dataEntity.getDate("createtime"));
            paymentApplyCont.set("modifytime", (Object)dataEntity.getDate("modifytime"));
            paymentApplyCont.set("masterid", entry.getPkValue());
            paymentApplyContList.add(paymentApplyCont);
        }
        SaveServiceHelper.save((DynamicObject[])paymentApplyContList.toArray(new DynamicObject[paymentApplyContList.size()]));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bills;
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
            if (entryCol.size() == 0) continue;
            if ("save".equals(key)) {
                this.synCloudVOBusRelation(bill);
            } else if (OPERATION_DELETE.equals(key)) {
                this.delCloudVOAndRelation(bill);
            }
            for (DynamicObject entryObj : entryCol) {
                DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
                if (subEntryCol.size() <= 0) continue;
                if (OPERATION_DELETE.equals(key)) {
                    this.delSubEntry(bill, entryObj, subEntryCol);
                    continue;
                }
                if (OPERATION_AUDIT.equals(key)) {
                    this.updateInvoiceInfo(bill, subEntryCol, key);
                    continue;
                }
                if (!OPERATION_UNAUDIT.equals(key)) continue;
                this.updateInvoiceInfo(bill, subEntryCol, key);
            }
        }
    }

    private void delCloudVOAndRelation(DynamicObject bill) {
        try {
            List invoiceList;
            DynamicObject[] invoices = this.queryInvoices(bill);
            if (invoices == null || invoices.length == 0) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("billId", bill.getPkValue().toString());
            map.put("entityId", "pmct_paymentapply");
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)OPERATION_DELETE, (Object[])new Object[]{map});
            if (!"0000".equals(result.getString("errcode"))) {
                log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
            }
            if ((invoiceList = Arrays.stream(invoices).map(invoice -> invoice.getString("serialno")).collect(Collectors.toList())).size() > 0 && !"0000".equals((result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{invoiceList})).getString("errcode"))) {
                log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
            }
        }
        catch (KDException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53d1\u7968\u4e91\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PayApplyOp_26", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
        }
    }

    private void synCloudVOBusRelation(DynamicObject bill) {
        DynamicObject[] invoices = this.queryInvoices(bill);
        if (invoices != null && invoices.length > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("billId", bill.getPkValue().toString());
            map.put("billNo", bill.getString("billno"));
            map.put("billType", "pmct_paymentapply");
            map.put("entityId", "pmct_paymentapply");
            map.put("appId", "pmct");
            ArrayList list = new ArrayList(16);
            for (DynamicObject invoice : invoices) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>(16);
                invoiceMap.put("serialNo", invoice.getString("serialno"));
                list.add(invoiceMap);
            }
            map.put("invoiceData", list);
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{map});
            if (!"0000".equals(result.getString("errcode"))) {
                log.error("---\u66f4\u65b0\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)result.getString("description"));
            }
        }
    }

    private DynamicObject[] queryInvoices(DynamicObject bill) {
        DynamicObject[] invoiceList = null;
        HashSet invoiceSet = new HashSet(16);
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
        if (entryCol != null && entryCol.size() > 0) {
            entryCol.forEach(contract -> {
                Set invoices;
                DynamicObjectCollection subEntities = contract.getDynamicObjectCollection("subentryentity");
                if (subEntities != null && subEntities.size() > 0 && (invoices = subEntities.stream().filter(subEntity -> subEntity.getDynamicObject("invoice") != null).map(subEntity -> Long.parseLong(subEntity.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
                    invoiceSet.addAll(invoices);
                }
            });
        }
        if (invoiceSet.size() > 0) {
            QFilter qFilter = new QFilter("serialno", "!=", (Object)Character.valueOf(' '));
            qFilter.and("serialno", "is not null", null);
            qFilter.and("id", "in", (Object)invoiceSet.toArray());
            qFilter.and("invoicesourceid", "=", (Object)bill.getPkValue().toString());
            invoiceList = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"serialno", (QFilter[])new QFilter[]{qFilter});
        }
        return invoiceList;
    }

    private void updateInvoiceInfo(DynamicObject bill, DynamicObjectCollection subEntryCol, String operation) {
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < subEntryCol.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subEntryCol.get(i);
            DynamicObject invoice = subEntry.getDynamicObject("invoice");
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice");
            if (operation.equals(OPERATION_AUDIT)) {
                if (!invoice.getBoolean("isused")) {
                    invoice.set("isused", (Object)true);
                }
            } else if (operation.equals(OPERATION_UNAUDIT) && !InvoiceHelper.checkIsQuoteByCheckApplyPay((DynamicObject)invoice, (String)bill.getPkValue().toString())) {
                invoice.set("isused", (Object)false);
            }
            invoiceList.add(invoice);
        }
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        }
    }

    private void delSubEntry(DynamicObject bill, DynamicObject entryObj, DynamicObjectCollection subEntryCol) {
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(10);
        BigDecimal invoiceTotalOfTaxAmount = BigDecimal.ZERO;
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        for (DynamicObject subEntry : subEntryCol) {
            DynamicObject invoice = subEntry.getDynamicObject("invoice");
            String invoiceSourceId = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice")).getString("invoicesourceid");
            if (StringUtils.isNotBlank((CharSequence)invoiceSourceId)) {
                InvoiceHelper.deleteInvoice((DynamicObject)invoice, (String)bill.getPkValue().toString());
                continue;
            }
            boolean isUpdateInvoice = subEntry.getBoolean("isupdateinvoice");
            if (isUpdateInvoice) {
                invoice.set("isclaimed", (Object)Boolean.FALSE);
                invoice.set("project", null);
                invoice.set("contract", null);
                invoice.set("contpartb", null);
                invoice.set("connecttype", (Object)"null");
                invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
            }
            invoiceList.add(invoice);
        }
        DynamicObject contract = entryObj.getDynamicObject("entrycontract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            BigDecimal invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
            BigDecimal invoiceAmount = contract.getBigDecimal("totalinvoiceamount");
            contract.set("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount.subtract(invoiceTotalOfTaxAmount));
            contract.set("totalinvoiceamount", (Object)invoiceAmount.subtract(invoiceTotalAmount));
            SaveServiceHelper.update((DynamicObject)contract);
        }
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        }
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject source) {
        if (OperationEnum.SUBMIT.getValue().equals(operationKey) || OperationEnum.SAVE.getValue().equals(operationKey)) {
            return;
        }
        DynamicObject payApply = BusinessDataServiceHelper.loadSingle((Object)source.getPkValue(), (String)"pmct_paymentapply");
        DynamicObjectCollection entryEntity = payApply.getDynamicObjectCollection("entryentity");
        if (entryEntity.size() > 0) {
            ArrayList contractList = new ArrayList(10);
            HashMap<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject cont : entryEntity) {
                DynamicObject contract;
                BigDecimal thisApplyOfTaxAmount = cont.getBigDecimal("applyoftaxamount");
                if (null == cont.getDynamicObject("entrycontract")) continue;
                Long contractId = cont.getDynamicObject("entrycontract").getLong("id");
                DynamicObject value = (DynamicObject)contractMap.get(contractId);
                if (value != null) {
                    contract = value;
                } else {
                    contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract", (String)Stream.of("totalapplyoftaxamount", "totalapplyamount", "ismultirate", "avgtaxrate", "taxrate", "totalinvoiceamount", "totalinvoiceoftaxamount").collect(Collectors.joining(",")));
                    contractMap.put(contractId, contract);
                }
                BigDecimal totalApplyOfTaxAmount = contract.getBigDecimal("totalapplyoftaxamount");
                BigDecimal totalApplyAmount = contract.getBigDecimal("totalapplyamount");
                DynamicObject taxRateObject = (DynamicObject)contract.get("taxrate");
                boolean isMultiRate = contract.getBoolean("ismultirate");
                BigDecimal taxRate = new BigDecimal("0.0");
                if (isMultiRate) {
                    taxRate = contract.getBigDecimal("avgtaxrate");
                } else if (taxRateObject != null) {
                    taxRate = NumberHelper.toBigDecimal((Object)taxRateObject.getBigDecimal("taxrate"));
                }
                BigDecimal thisApplyAmount = thisApplyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))), 6, 5);
                if (operationKey.equals(OPERATION_AUDIT)) {
                    contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.add(thisApplyOfTaxAmount));
                    contract.set("totalapplyamount", (Object)totalApplyAmount.add(thisApplyAmount));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)OPERATION_UNAUDIT)) continue;
                contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.subtract(thisApplyOfTaxAmount));
                contract.set("totalapplyamount", (Object)totalApplyAmount.subtract(thisApplyAmount));
            }
            Set entriesSet = contractMap.entrySet();
            for (Map.Entry entry : entriesSet) {
                contractList.add(entry.getValue());
            }
            if (contractList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])contractList.toArray(new DynamicObject[contractList.size()]));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block18: {
                    String key;
                    block17: {
                        key = this.getOperateKey();
                        if (!StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.SUBMIT.getValue())) break block17;
                        ExtendedDataEntity[] dataEntities = this.getDataEntities();
                        if (dataEntities == null || dataEntities.length <= 0) break block18;
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            DynamicObject payApplyBill = dataEntity.getDataEntity();
                            DynamicObjectCollection payApplyInfoEntry = payApplyBill.getDynamicObjectCollection("entryentity");
                            if (payApplyInfoEntry == null || payApplyInfoEntry.isEmpty()) {
                                return;
                            }
                            List<DynamicObject> payApplyBills = Arrays.stream(dataEntities).map(data -> data.getDataEntity()).collect(Collectors.toList());
                            this.contTypeCtlValidate(dataEntity, payApplyInfoEntry, payApplyBills);
                            this.checkDeductionAmount(dataEntity, true);
                            this.checkInvoiceSeller(dataEntity, payApplyInfoEntry);
                            this.checkInvoiceAmt(payApplyInfoEntry);
                            this.checkPayItem(dataEntity, payApplyInfoEntry);
                        }
                        break block18;
                    }
                    if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.UNAUDIT.getValue())) {
                        ExtendedDataEntity[] dataEntities;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            DynamicObject payApplyBill = dataEntity.getDataEntity();
                            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmct_paymentapply", (Long[])new Long[]{payApplyBill.getLong("id")});
                            if (!targetBillIds.isEmpty()) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u63a8\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PayApplyOp_13", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if (!payApplyBill.getBoolean("billpayoff")) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u8fdb\u884c\u201d\u6574\u5355\u4ed8\u6b3e\u786e\u8ba4\u201c\u6216\u201c\u4ed8\u6b3e\u521d\u59cb\u5316\u201d\u5904\u7406\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PayApplyOp_15", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)key, (CharSequence)PayApplyOp.OPERATE_BILL_PAY_CONFIRM)) {
                        ExtendedDataEntity[] dataEntities;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            DynamicObject payApplyBill = dataEntity.getDataEntity();
                            if (!StringUtils.equals((CharSequence)payApplyBill.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue())) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u201c\u6574\u5355\u4ed8\u6b3e\u786e\u8ba4\u201d\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayApplyOp_38", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (!payApplyBill.getBoolean("billpayoff")) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u201d\u6574\u5355\u4ed8\u6e05\u201c\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u201d\u6574\u5355\u4ed8\u6b3e\u786e\u8ba4\u201c\u64cd\u4f5c\u3002", (String)"PayApplyOp_40", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)key, (CharSequence)PayApplyOp.OPERATE_PAY_INIT)) {
                        ExtendedDataEntity[] dataEntities;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            DynamicObject payApplyBill = dataEntity.getDataEntity();
                            if (!StringUtils.equals((CharSequence)payApplyBill.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue())) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u201c\u4ed8\u6b3e\u521d\u59cb\u5316\u201d\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayApplyOp_39", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (!payApplyBill.getBoolean("billpayoff")) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u201d\u6574\u5355\u4ed8\u6e05\u201c\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u201d\u4ed8\u6b3e\u521d\u59cb\u5316\u201c\u64cd\u4f5c\u3002", (String)"PayApplyOp_41", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.AUDIT.getValue())) {
                        ExtendedDataEntity[] dataEntities;
                        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                            DynamicObject payApplyBill = dataEntity.getDataEntity();
                            DynamicObjectCollection payApplyInfoEntry = payApplyBill.getDynamicObjectCollection("entryentity");
                            if (payApplyInfoEntry == null || payApplyInfoEntry.isEmpty()) {
                                return;
                            }
                            this.checkDeductionAmount(dataEntity, false);
                        }
                    }
                }
            }

            private void checkPayItem(ExtendedDataEntity dataEntity, DynamicObjectCollection payApplyInfoEntry) {
                Map thisPayableAmountByPayItem = PayApplyOp.this.getThisPayableAmountByPayItem(payApplyInfoEntry);
                for (Map.Entry entry : thisPayableAmountByPayItem.entrySet()) {
                    DynamicObject payItem = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"pmbs_contractpayitem");
                    DynamicObject contract = payItem.getDynamicObject("contract");
                    String nodeSettingSource = payItem.getString("nodesettingsource");
                    DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
                    if (payItem != null && StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue()) && nodeSetting != null) {
                        String ctrlStrategy = payItem.getString("ctrlstrategy");
                        nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)"pmpt_task");
                        QFilter sourceFilter = new QFilter("sourcetask", "=", nodeSetting.getDynamicObject("sourcetask").getPkValue());
                        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
                        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"pmpt_task", (String)"percent,completionstatus", (QFilter[])new QFilter[]{sourceFilter, isLatestFilter});
                        String completionStatus = task.getString("completionstatus");
                        int percent = task.getInt("percent");
                        if (!StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue()) && !StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) && percent != 100) {
                            if (ctrlStrategy != null && StringUtils.equals((CharSequence)CtrlStrategyEnum.WEAK.getValue(), (CharSequence)ctrlStrategy)) {
                                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u662f\u5426\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\uff1f", (String)"PayApplyOp_19", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), payItem.getLocaleString("name").getLocaleValue_zh_CN()));
                            } else if (ctrlStrategy != null && StringUtils.equals((CharSequence)CtrlStrategyEnum.STRONG.getValue(), (CharSequence)ctrlStrategy)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\u3002", (String)"PayApplyOp_20", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), payItem.getLocaleString("name").getLocaleValue_zh_CN()));
                            }
                        }
                    }
                    BigDecimal thisPayableAmount = (BigDecimal)entry.getValue();
                    BigDecimal appliedComAmt = payItem.getBigDecimal("appliedcomamt");
                    BigDecimal payAmount = payItem.getBigDecimal("payamount");
                    DynamicObject contractType = contract.getDynamicObject("contracttype");
                    contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                    String amountControlApply = contractType.getString("ammountcontrolapply");
                    if (thisPayableAmount.add(appliedComAmt).compareTo(payAmount) <= 0) continue;
                    if (StringUtils.equals((CharSequence)amountControlApply, (CharSequence)ContractControlEnum.REMINDCONTROL.getValue())) {
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5df2\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5141\u8bb8\u7533\u8bf7\u91d1\u989d\u9650\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyOp_21", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), payItem.getLocaleString("name").getLocaleValue_zh_CN()));
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)amountControlApply, (CharSequence)ContractControlEnum.STRICTCONTROL.getValue())) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5df2\u7533\u8bf7\u91d1\u989d\u5df2\u8d85\u8fc7\u5141\u8bb8\u7533\u8bf7\u91d1\u989d\u9650\u989d\u3002", (String)"PayApplyOp_22", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), payItem.getLocaleString("name").getLocaleValue_zh_CN()));
                }
            }

            private void checkDeductionAmount(ExtendedDataEntity dataEntity, boolean isSubmit) {
                DynamicObject payApplyBill = dataEntity.getDataEntity();
                PrePayService prePayService = new PrePayService();
                Object orgId = payApplyBill.getDynamicObject("org").getPkValue();
                DynamicObjectCollection contractEntries = payApplyBill.getDynamicObjectCollection("entryentity");
                ArrayList<String> validatedContractList = new ArrayList<String>(10);
                ArrayList validatedBudgetList = new ArrayList(10);
                for (DynamicObject contractEntry : contractEntries) {
                    String contAndProKey;
                    DynamicObject contract = contractEntry.getDynamicObject("entrycontract");
                    DynamicObject currency = contractEntry.getDynamicObject("contcurrency");
                    Object projectId = contractEntry.getDynamicObject("contpro") == null ? null : contractEntry.getDynamicObject("contpro").getPkValue();
                    BigDecimal deductibleAmountByContract = prePayService.getDeductibleAmountByContract(contract, projectId, orgId);
                    BigDecimal thisDeductionAmountByContract = prePayService.getThisDeductionAmountByContract(contract, projectId, contractEntries);
                    BigDecimal validateContractAmount = isSubmit ? deductibleAmountByContract.subtract(thisDeductionAmountByContract) : deductibleAmountByContract;
                    String string = contAndProKey = String.valueOf(contract.getPkValue().toString()) + projectId == null ? "" : String.valueOf(projectId);
                    if (validateContractAmount.compareTo(BigDecimal.ZERO) < 0 && !validatedContractList.contains(contAndProKey)) {
                        BigDecimal showContractAmount = isSubmit ? deductibleAmountByContract : deductibleAmountByContract.add(thisDeductionAmountByContract);
                        String contractName = contract.getString("billname");
                        String showContractAmountString = CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)showContractAmount);
                        String thisDeductionAmountByContractString = CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)thisDeductionAmountByContract);
                        if (projectId == null) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\uff1a%1$s\u7684\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d\u4e3a%2$s\uff0c\u201c\u672c\u6b21\u9884\u4ed8\u6b3e\u62b5\u6263\u201d\u6c47\u603b\u503c%3$s\u4e0d\u53ef\u5927\u4e8e\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%2$s\u3002", (String)"PayApplyOp_57", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contractName, showContractAmountString, thisDeductionAmountByContractString));
                        } else {
                            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
                            String projectName = project.getLocaleString("name").getLocaleValue();
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\u7684\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d\u4e3a%3$s\uff0c\u201c\u672c\u6b21\u9884\u4ed8\u6b3e\u62b5\u6263\u201d\u6c47\u603b\u503c%4$s\u4e0d\u53ef\u5927\u4e8e\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%3$s\u3002", (String)"PayApplyOp_58", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contractName, projectName, showContractAmountString, thisDeductionAmountByContractString));
                        }
                        validatedContractList.add(contAndProKey);
                    }
                    if (validatedBudgetList.contains(contAndProKey)) continue;
                    BudgetPrePayService budgetPrePayService = new BudgetPrePayService();
                    Map prePaySplitBudgetData = budgetPrePayService.getPrePaySplitBudgetData(contract, projectId, orgId);
                    Map thisPrePaySplitBudgetData = prePayService.getThisPrePaySplitBudgetData(contract, projectId, contractEntries);
                    for (Map.Entry budgetData : prePaySplitBudgetData.entrySet()) {
                        BigDecimal prePayAmount = ((Map)budgetData.getValue()).get("prepayamount") == null ? BigDecimal.ZERO : (BigDecimal)((Map)budgetData.getValue()).get("prepayamount");
                        BigDecimal prePayDeduction = ((Map)budgetData.getValue()).get("prepaydeduction") == null ? BigDecimal.ZERO : (BigDecimal)((Map)budgetData.getValue()).get("prepaydeduction");
                        BigDecimal deductibleAmount = prePayAmount.subtract(prePayDeduction);
                        Map thisBudgetData = (Map)thisPrePaySplitBudgetData.get(budgetData.getKey());
                        BigDecimal thisPrePayDeduction = thisBudgetData == null || thisBudgetData.get("prepaydeduction") == null ? BigDecimal.ZERO : (BigDecimal)thisBudgetData.get("prepaydeduction");
                        BigDecimal validateBudgetAmount = isSubmit ? deductibleAmount.subtract(thisPrePayDeduction) : deductibleAmount;
                        if (validateBudgetAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                        BigDecimal showBudgetAmount = isSubmit ? deductibleAmount : deductibleAmount.add(thisPrePayDeduction);
                        String contractName = contract.getString("billname");
                        DynamicObject budgetItem = (DynamicObject)((Map)budgetData.getValue()).get("budgetitem");
                        DynamicObject project = (DynamicObject)((Map)budgetData.getValue()).get("project");
                        String projectName = project == null ? "" : project.getLocaleString("name").getLocaleValue();
                        String budgetItemName = budgetItem == null ? "" : budgetItem.getString("name");
                        String showBudgetAmountString = CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)showBudgetAmount);
                        String thisPrePayDeductionString = CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)thisPrePayDeduction);
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\uff0c\u9884\u7b97\u9879\uff1a%3$s\u7684\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d\u4e3a%4$s\uff0c\u201c\u662f\u5426\u4e3a\u9884\u4ed8\u6b3e\u5206\u644a\u201d\u6807\u8bc6\u503c\u4e3a\u201c\u662f\u201d\u7684\u8be5\u9884\u7b97\u9879\u7684\u201c\u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u91d1\u989d\u201d\u6c47\u603b\u503c%5$s\u4e0d\u53ef\u5927\u4e8e\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%4$s\u3002", (String)"PayApplyOp_59", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contractName, projectName, budgetItemName, showBudgetAmountString, thisPrePayDeductionString));
                    }
                }
            }

            private void contTypeCtlValidate(ExtendedDataEntity dataEntity, DynamicObjectCollection payApplyInfoEntry, List<DynamicObject> payApplyBills) {
                PrePayService prePayService = new PrePayService();
                HashMap payAbleAmountMap = new HashMap(16);
                HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(16);
                for (DynamicObject payApplyEntryObj : payApplyInfoEntry) {
                    BigDecimal payAbleAmountBySupplier;
                    DynamicObject entryContract = payApplyEntryObj.getDynamicObject("entrycontract");
                    HashMap<Object, BigDecimal> amountBySupplerMap = (HashMap<Object, BigDecimal>)payAbleAmountMap.get(entryContract.getPkValue());
                    DynamicObject supplier = payApplyEntryObj.getDynamicObject("contpartb");
                    if (amountBySupplerMap == null) {
                        amountBySupplerMap = new HashMap<Object, BigDecimal>(16);
                        payAbleAmountMap.put(entryContract.getPkValue(), amountBySupplerMap);
                        payAbleAmountBySupplier = prePayService.getPayAbleAmountBySupplier(entryContract, supplier, payApplyBills);
                        amountBySupplerMap.put(supplier.getPkValue(), payAbleAmountBySupplier);
                    } else if (amountBySupplerMap.get(supplier.getPkValue()) == null) {
                        payAbleAmountBySupplier = prePayService.getPayAbleAmountBySupplier(entryContract, supplier, payApplyBills);
                        amountBySupplerMap.put(supplier.getPkValue(), payAbleAmountBySupplier);
                    }
                    contractMap.put(entryContract.getPkValue(), entryContract);
                }
                MainEntityType contractTypeDt = EntityMetadataCache.getDataEntityType((String)"pmct_conttype");
                for (Map.Entry payAbleAmountMapEntry : payAbleAmountMap.entrySet()) {
                    BigDecimal totalOfTaxAmount;
                    String amountControlApply;
                    String settleControlApply;
                    Object contractId = payAbleAmountMapEntry.getKey();
                    DynamicObject contract = (DynamicObject)contractMap.get(contractId);
                    DynamicObject contractType = contract.getDynamicObject("contracttype");
                    if (contractType == null) continue;
                    contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (DynamicObjectType)contractTypeDt);
                    boolean openedContract = contract.getBoolean("openedcontract");
                    if (openedContract) {
                        settleControlApply = contractType.getString("settlecontrolapplyopen");
                        amountControlApply = contractType.getString("ammountcontrolapplyopen");
                    } else {
                        settleControlApply = contractType.getString("settlecontrolapply");
                        amountControlApply = contractType.getString("ammountcontrolapply");
                    }
                    QFilter finalAuditedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and(new QFilter("contract.id", "=", contractId));
                    DynamicObject finalAudited = QueryServiceHelper.queryOne((String)"pmct_outfinalsettle", (String)"apptaxamount", (QFilter[])new QFilter[]{finalAuditedFilter});
                    BigDecimal payAbleAmountByContract = prePayService.getPayAbleAmount(contract);
                    for (DynamicObject payApplyBill : payApplyBills) {
                        DynamicObjectCollection dynamicObjectCollection = payApplyBill.getDynamicObjectCollection("entryentity");
                        for (DynamicObject contractEntry : dynamicObjectCollection) {
                            if (!contractEntry.getDynamicObject("entrycontract").getPkValue().equals(contract.getPkValue())) continue;
                            payAbleAmountByContract = payAbleAmountByContract.add(contractEntry.getBigDecimal("thispayableamount"));
                        }
                    }
                    Map amountBySupplerMap = (Map)payAbleAmountMapEntry.getValue();
                    if (finalAudited != null) {
                        BigDecimal appTaxAmount = finalAudited.getBigDecimal("apptaxamount");
                        if (appTaxAmount.compareTo(payAbleAmountByContract) < 0) {
                            if (StringUtils.equals((CharSequence)ContractControlEnum.REMINDCONTROL.getValue(), (CharSequence)settleControlApply)) {
                                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u51b3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_49", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            } else if (StringUtils.equals((CharSequence)ContractControlEnum.STRICTCONTROL.getValue(), (CharSequence)settleControlApply)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u51b3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_49", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            }
                        }
                    } else if (contract.getBoolean("ismulticontract")) {
                        for (Map.Entry entry : amountBySupplerMap.entrySet()) {
                            String supplierName;
                            BigDecimal payAbleAmountBySupplier;
                            Object supplierId = entry.getKey();
                            BigDecimal settleAmountBySupplier = ContractHelper.getContractSettleAmountBySupplier(contractId, supplierId);
                            if (settleAmountBySupplier.compareTo(payAbleAmountBySupplier = (BigDecimal)entry.getValue()) >= 0) continue;
                            if (StringUtils.equals((CharSequence)ContractControlEnum.REMINDCONTROL.getValue(), (CharSequence)settleControlApply)) {
                                supplierName = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"name", (QFilter[])new QFilter("id", "=", supplierId).toArray()).getString("name");
                                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5bf9\u5e94\u7684\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_51", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), supplierName));
                                continue;
                            }
                            if (!StringUtils.equals((CharSequence)ContractControlEnum.STRICTCONTROL.getValue(), (CharSequence)settleControlApply)) continue;
                            supplierName = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"name", (QFilter[])new QFilter("id", "=", supplierId).toArray()).getString("name");
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5bf9\u5e94\u7684\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_51", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname"), supplierName));
                        }
                    } else {
                        BigDecimal settleAmountByContract = contract.getBigDecimal("totalsettleoftaxamount");
                        if (settleAmountByContract.compareTo(payAbleAmountByContract) < 0) {
                            if (StringUtils.equals((CharSequence)ContractControlEnum.REMINDCONTROL.getValue(), (CharSequence)settleControlApply)) {
                                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5bf9\u5e94\u7684\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_53", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            } else if (StringUtils.equals((CharSequence)ContractControlEnum.STRICTCONTROL.getValue(), (CharSequence)settleControlApply)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5bf9\u5e94\u7684\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u3002", (String)"PayApplyOp_53", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                            }
                        }
                    }
                    if ((totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount")).compareTo(payAbleAmountByContract) >= 0) continue;
                    if (StringUtils.equals((CharSequence)ContractControlEnum.REMINDCONTROL.getValue(), (CharSequence)amountControlApply)) {
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"PayApplyOp_55", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)ContractControlEnum.STRICTCONTROL.getValue(), (CharSequence)amountControlApply)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"PayApplyOp_55", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), contract.getString("billname")));
                }
            }

            private void checkInvoiceSeller(ExtendedDataEntity dataEntity, DynamicObjectCollection payApplyInfoEntry) {
                if (!payApplyInfoEntry.isEmpty()) {
                    String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
                    if (InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam) || InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                        StringBuilder errorMsg = new StringBuilder();
                        for (int i = 0; i < payApplyInfoEntry.size(); ++i) {
                            DynamicObject entry = (DynamicObject)payApplyInfoEntry.get(i);
                            DynamicObjectCollection invoices = entry.getDynamicObjectCollection("subentryentity");
                            DynamicObject supplier = entry.getDynamicObject("contpartb");
                            if (invoices.size() <= 0 || supplier == null) continue;
                            Set invoiceIds = invoices.stream().map(invoice -> Long.parseLong(invoice.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet());
                            String checkTip = InvoiceHelper.checkInvoiceSeller((Long)Long.parseLong(supplier.getPkValue().toString()), invoiceIds);
                            if (!StringUtils.isNotBlank((CharSequence)checkTip)) continue;
                            if (!errorMsg.toString().isEmpty()) {
                                errorMsg.append("\r\n");
                            }
                            errorMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\u7b2c%1$s\u884c\uff1a", (String)"PayApplyOp_56", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), i + 1)).append(checkTip);
                        }
                        if (!errorMsg.toString().isEmpty()) {
                            if (InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                                this.addWarningMessage(dataEntity, errorMsg.toString());
                            } else if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                                throw new KDBizException(errorMsg.toString());
                            }
                        }
                    }
                }
            }

            private void checkInvoiceAmt(DynamicObjectCollection payApplyInfoEntry) {
                if (!payApplyInfoEntry.isEmpty()) {
                    ArrayList invoices = new ArrayList(16);
                    for (DynamicObject entry : payApplyInfoEntry) {
                        DynamicObjectCollection invoiceEntity = entry.getDynamicObjectCollection("subentryentity");
                        if (invoiceEntity.size() <= 0) continue;
                        List checkInvoices = invoiceEntity.stream().filter(invoice -> invoice.getDynamicObject("invoice") != null && invoice.getBigDecimal("applyoftaxamtvo").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                        invoices.addAll(checkInvoices);
                    }
                    if (invoices.size() > 0) {
                        StringBuilder errorTip = new StringBuilder();
                        for (DynamicObject invoiceEntry : invoices) {
                            BigDecimal applyOfTaxAmtVO;
                            DynamicObject invoice2 = invoiceEntry.getDynamicObject("invoice");
                            invoice2 = BusinessDataServiceHelper.loadSingle((Object)invoice2.getPkValue(), (String)"pmct_ininvoice");
                            BigDecimal totalOfTaxAmount = invoice2.getBigDecimal("totaloftaxamount");
                            BigDecimal totalUseAmt = invoice2.getBigDecimal("totaluseamt");
                            if (NumberHelper.add((Object)totalUseAmt, (Object)(applyOfTaxAmtVO = invoiceEntry.getBigDecimal("applyoftaxamtvo"))).compareTo(totalOfTaxAmount) <= 0) continue;
                            if (!errorTip.toString().isEmpty()) {
                                errorTip.append("\r\n");
                            }
                            errorTip.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u7684\u7d2f\u8ba1\u4f7f\u7528\u91d1\u989d\u548c\u672c\u6b21\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u5df2\u8d85\u8fc7\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PayApplyOp_25", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), invoice2.getString("invoicecode"), invoice2.getString("invoiceno")));
                        }
                        if (!errorTip.toString().isEmpty()) {
                            throw new KDBizException(errorTip.toString());
                        }
                    }
                }
            }
        });
    }

    private Map<Object, BigDecimal> getThisPayableAmountByPayItem(DynamicObjectCollection payApplyInfoEntry) {
        HashMap<Object, BigDecimal> thisPayableAmountByPayItem = new HashMap<Object, BigDecimal>(16);
        for (DynamicObject entry : payApplyInfoEntry) {
            BigDecimal thisPayableAmount = entry.getBigDecimal("thispayableamount");
            DynamicObject payItem = entry.getDynamicObject("payitem");
            if (payItem == null) continue;
            if (thisPayableAmountByPayItem.containsKey(payItem.getPkValue())) {
                thisPayableAmountByPayItem.put(payItem.getPkValue(), ((BigDecimal)thisPayableAmountByPayItem.get(payItem.getPkValue())).add(thisPayableAmount));
                continue;
            }
            thisPayableAmountByPayItem.put(payItem.getPkValue(), thisPayableAmount);
        }
        return thisPayableAmountByPayItem;
    }
}

