/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contclaim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TypeUtils;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.business.helper.IncomePlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.contclaim.ContractClaimValidator;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class InContractClaimBillOp
extends AbstractReverseWritingPmctContractOp {
    private static String selector = Stream.of("totalclaimamount", "totalclaimoftaxamount", "totalamount", "totaloftaxamount", "lstavgtaxrate").collect(Collectors.joining(","));
    protected IncomePlanChangeHelper incomePlanChangeHelper = new IncomePlanChangeHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("contract");
        fields.add("project");
        fields.add("claimamount");
        fields.add("claimoftaxamount");
        fields.add("period");
        fields.add("issettle");
        fields.add("paydirection");
        fields.add("budgetitem");
        fields.add("isneedsettle");
        fields.add("id");
        fields.add("currency");
        fields.add("stdcurrency");
        fields.add("exchangerate");
        fields.add("creator");
        fields.add("createtime");
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("billno");
        fields.add("billname");
        fields.add("isneedsettle");
        fields.add("afteroftaxamount");
        fields.add("avgtaxrate");
        fields.add("ismultirate");
        fields.add("kapianentry");
        fields.add("entryentity");
        fields.add("subclaimtype");
        fields.add("listid");
        fields.add("changecount");
        fields.add("thisafteroftaxamount");
        fields.add("newlistingid");
        fields.add("superlistingid");
        fields.add("parentlisting");
        fields.add("listnumber");
        fields.add("listname");
        fields.add("amount");
        fields.add("tax");
        fields.add("oftax");
        fields.add("remark");
        fields.add("listmodelid");
        fields.add("beaffectedcount");
        fields.add("afterclaimoftaxprice");
        fields.add("measureunit");
        fields.add("qty");
        fields.add("price");
        fields.add("subtaxrate");
        fields.add("rateobj");
        fields.add("oftaxprice");
        fields.add("materiel");
        fields.add("cmptype");
        fields.add("sysnum");
        fields.add("listingbudgetitem");
        fields.add("conplanitemid");
        fields.add("claimincomeplanentry");
        fields.add("nodesetting");
        fields.add("nodesettingsource");
        fields.add("ctrlstrategy");
        fields.add("incometype");
        fields.add("taskcompletestate");
        fields.add("planincometime");
        fields.add("incomeitemname");
        fields.add("incomeamountoftax");
        fields.add("incomepercent");
        fields.add("customer");
        fields.add("incomeplansourceid");
        fields.add("remarks");
        fields.add("incomeway");
        fields.add("incomefeq");
        fields.add("seq");
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject dataEntity) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract", (String)selector);
        BigDecimal totalClaimAmount = contract.getBigDecimal("totalclaimamount");
        BigDecimal totalClaimOfTaxAmount = contract.getBigDecimal("totalclaimoftaxamount");
        BigDecimal totalAmount = contract.getBigDecimal("totalamount");
        BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
        BigDecimal claimAmount = dataEntity.getBigDecimal("claimamount");
        BigDecimal claimOfTaxAmount = dataEntity.getBigDecimal("claimoftaxamount");
        Boolean isNeedSettle = dataEntity.getBoolean("isneedsettle");
        if (isNeedSettle.booleanValue()) {
            if (operationKey.equals("audit")) {
                contract.set("totalclaimamount", (Object)totalClaimAmount.add(claimAmount));
                contract.set("totalclaimoftaxamount", (Object)totalClaimOfTaxAmount.add(claimOfTaxAmount));
                contract.set("totalamount", (Object)totalAmount.add(claimAmount));
                contract.set("totaloftaxamount", (Object)totalOfTaxAmount.add(claimOfTaxAmount));
                boolean isMultiRate = dataEntity.getBoolean("ismultirate");
                if (isMultiRate) {
                    contract.set("lstavgtaxrate", dataEntity.get("avgtaxrate"));
                }
                DynamicObjectCollection cardEntry = (DynamicObjectCollection)dataEntity.get("kapianentry");
                ArrayList<DynamicObject> listUpdateList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> listaddList = new ArrayList<DynamicObject>();
                for (int i = 0; i < cardEntry.size(); ++i) {
                    DynamicObjectCollection subentrys = (DynamicObjectCollection)((DynamicObject)cardEntry.get(i)).get("entryentity");
                    HashMap<String, DynamicObject> newListingMap = new HashMap<String, DynamicObject>(16);
                    this.addNotDetailListing(dataEntity, contract, subentrys, listaddList, newListingMap);
                    this.addListingByChangeType(dataEntity, contract, subentrys, listUpdateList, listaddList, newListingMap);
                }
                if (listUpdateList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])listUpdateList.toArray(new DynamicObject[0]));
                }
                if (listaddList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)listaddList.get(0)).getDataEntityType(), (Object[])listaddList.toArray());
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ContractRelationBillUnAuditValidator());
        e.addValidator((AbstractValidator)new ContractClaimValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block4: {
            String operationKey;
            DynamicObject[] dataEntities;
            block3: {
                super.beginOperationTransaction(e);
                dataEntities = e.getDataEntities();
                operationKey = e.getOperationKey();
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
                    this.updateBudgetData(dataEntities, operationKey);
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) break block3;
                for (DynamicObject dataEntity : dataEntities) {
                    this.auditHandleContractIncomeItem(dataEntity);
                }
                break block4;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) break block4;
            for (DynamicObject dataEntity : dataEntities) {
                UnAuditHelper.deleteClaimAutogeneratedItem((DynamicObject)dataEntity);
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_inclaimbill"));
                DynamicObjectCollection planEntry = bill.getDynamicObjectCollection("claimincomeplanentry");
                UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)planEntry);
            }
        }
    }

    protected void auditHandleContractIncomeItem(DynamicObject dataEntity) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_inclaimbill");
        DynamicObject contract = dynamicObject.getDynamicObject("contract");
        if (dynamicObject.getBoolean("isneedsettle")) {
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
            DynamicObject[] incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"", (QFilter[])new QFilter[]{contractFilter, autogenFilter});
            if (incomeItems.length > 0) {
                this.generateFundPlanChangeObj(dynamicObject);
            }
            new ContractCollectItemHelper().doSave(dataEntity, PayPlanSourceEnum.CLAIM);
        } else {
            new ContractCollectItemHelper().doSave(dataEntity, PayPlanSourceEnum.CLAIM, contract.getPkValue());
        }
    }

    protected void generateFundPlanChangeObj(DynamicObject dynamicObject) {
        Object sourceId = dynamicObject.getPkValue();
        Object contractId = ((DynamicObject)dynamicObject.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.CLAIM.getValue();
        DynamicObjectCollection customEntries = dynamicObject.getDynamicObjectCollection("claimincomeplanentry");
        DynamicObject incomePlanChangeObj = this.incomePlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_inclaimbill", true);
        incomePlanChangeObj.set("sourcebillid", dynamicObject.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{incomePlanChangeObj});
    }

    protected void addNotDetailListing(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        ArrayList<DynamicObject> updateLevelList = new ArrayList<DynamicObject>(10);
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            int claimType = TypeUtils.nullToInt((Object)subEntry.get("subclaimtype"));
            if (claimType != 3) continue;
            DynamicObject listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("id", subEntry.get("newlistingid"));
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("isleaf", (Object)Boolean.FALSE);
            listing.set("listparentid", subEntry.get("superlistingid"));
            listing.set("parent", subEntry.get("superlistingid"));
            if (subEntry.getDynamicObject("parentlisting") != null) {
                listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
            } else {
                updateLevelList.add(listing);
            }
            listing.set("number", subEntry.get("listnumber"));
            listing.set("name", subEntry.get("listname"));
            listing.set("amount", subEntry.get("amount"));
            listing.set("tax", subEntry.get("tax"));
            listing.set("oftax", subEntry.get("oftax"));
            listing.set("lstoftaxamount", subEntry.get("oftax"));
            listing.set("desc", subEntry.get("remark"));
            DynamicObject parentnode = (DynamicObject)subEntry.getParent();
            listing.set("listingmodel", parentnode.get("listmodelid"));
            listing.set("contractid", (Object)contract.getPkValue().toString());
            listing.set("enable", (Object)1);
            listing.set("status", (Object)"C");
            listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
            listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
            listing.set("listingbudgetitem", (Object)subEntry.getDynamicObject("listingbudgetitem"));
            listaddList.add(listing);
            newListingMap.put(subEntry.get("newlistingid").toString(), listing);
        }
        for (DynamicObject listing : updateLevelList) {
            if (listing.get("listparentid") != null && listing.getLong("listparentid") != 0L) {
                DynamicObject parent = newListingMap.get(String.valueOf(listing.getLong("listparentid")));
                listing.set("level", (Object)(parent.getInt("level") + 1));
                continue;
            }
            listing.set("level", (Object)1);
        }
    }

    protected void addListingByChangeType(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listUpdateList, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject parentListing;
            BigDecimal avgTaxPrice;
            BigDecimal changedTaxAmount;
            BigDecimal curChangedTaxAmount;
            DynamicObject listing;
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            int claimType = TypeUtils.nullToInt((Object)subEntry.get("subclaimtype"));
            if (claimType == 0) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                double changeqty = TypeUtils.StringToDouble((Object)listing.get("changeqty"));
                listing.set("changeqty", (Object)(changeqty += TypeUtils.StringToDouble((Object)subEntry.get("changecount"))));
                curChangedTaxAmount = (BigDecimal)subEntry.get("thisafteroftaxamount");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("qty")) + changeqty;
                listing.set("totalqty", (Object)totalQty);
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                BigDecimal totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
                BigDecimal taxrate = subEntry.getBigDecimal("subtaxrate");
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                BigDecimal curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                if ((parentListing = listing.getDynamicObject("parent")) != null) {
                    ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                }
                listUpdateList.add(listing);
                continue;
            }
            if (claimType == 1) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                BigDecimal effectQty = subEntry.getBigDecimal("beaffectedcount");
                BigDecimal lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
                listing.set("chgeffectqty", (Object)effectQty.add(lastChangedEffectQty));
                listing.set("curtaxprice", (Object)subEntry.getBigDecimal("afterclaimoftaxprice"));
                curChangedTaxAmount = subEntry.getBigDecimal("thisafteroftaxamount");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                BigDecimal totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
                BigDecimal taxrate = subEntry.getBigDecimal("subtaxrate");
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                BigDecimal curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("totalqty"));
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                if ((parentListing = listing.getDynamicObject("parent")) != null) {
                    ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                }
                listUpdateList.add(listing);
                continue;
            }
            if (claimType != 2) continue;
            listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("id", subEntry.get("newlistingid"));
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("listparentid", (Object)subEntry.getString("superlistingid"));
            listing.set("number", subEntry.get("listnumber"));
            listing.set("name", subEntry.get("listname"));
            if (subEntry.get("measureunit") != null) {
                listing.set("measureunit", subEntry.getDynamicObject("measureunit").getPkValue());
            }
            listing.set("qty", subEntry.get("qty"));
            listing.set("totalqty", subEntry.get("qty"));
            listing.set("price", subEntry.get("price"));
            listing.set("amount", subEntry.get("amount"));
            listing.set("taxrate", subEntry.get("subtaxrate"));
            listing.set("rateobj", subEntry.get("rateobj"));
            listing.set("tax", subEntry.get("tax"));
            listing.set("taxprice", subEntry.get("oftaxprice"));
            listing.set("avgtaxprice", subEntry.get("oftaxprice"));
            listing.set("curtaxprice", subEntry.get("oftaxprice"));
            listing.set("oftax", subEntry.get("oftax"));
            listing.set("lstoftaxamount", subEntry.get("oftax"));
            listing.set("latestamount", subEntry.get("amount"));
            listing.set("desc", subEntry.get("remark"));
            DynamicObject parentnode = (DynamicObject)subEntry.getParent();
            listing.set("listingmodel", parentnode.get("listmodelid"));
            listing.set("contractid", (Object)contract.getPkValue().toString());
            listing.set("enable", (Object)1);
            listing.set("status", (Object)"C");
            listing.set("listingbudgetitem", subEntry.get("listingbudgetitem"));
            listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
            listing.set("isleaf", (Object)Boolean.TRUE);
            if (subEntry.get("materiel") != null) {
                listing.set("material", subEntry.getDynamicObject("materiel").getPkValue());
            }
            if (subEntry.getDynamicObject("parentlisting") != null) {
                listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
                listing.set("parent", subEntry.getDynamicObject("parentlisting").getPkValue());
            } else if (subEntry.get("superlistingid") != null && subEntry.getLong("superlistingid") != 0L) {
                DynamicObject superListing = newListingMap.get(String.valueOf(subEntry.getLong("superlistingid")));
                listing.set("level", (Object)(superListing.getInt("level") + 1));
                listing.set("parent", (Object)subEntry.getLong("superlistingid"));
            } else {
                listing.set("level", (Object)1);
                listing.set("parent", null);
            }
            listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
            listaddList.add(listing);
            DynamicObject parentListing2 = subEntry.getDynamicObject("parentlisting");
            if (parentListing2 == null) continue;
            curChangedTaxAmount = subEntry.getBigDecimal("oftax");
            BigDecimal curChangedAmount = subEntry.getBigDecimal("amount");
            ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing2, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            Map<Object, Object> projectAmountMap = new HashMap(16);
            if (proApp != null && proApp.length > 0) {
                projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            }
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inclaimbill").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(bill.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inclaimbill").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_inclaimbill").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_inclaimbill", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        boolean isNeedSettle = bill.getBoolean("isneedsettle");
        if (isOnList && isNeedSettle) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("kapianentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("entryentity");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subclaimtype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("thisafteroftaxamount").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("claimoftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }
}

