/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contclaim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TypeUtils;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.business.helper.FundPlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.contclaim.ContractClaimValidator;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class OutContractClaimBillOp
extends AbstractReverseWritingPmctContractOp {
    private static String selector = Stream.of("totalclaimamount", "totalclaimoftaxamount", "totalamount", "totaloftaxamount", "lstavgtaxrate").collect(Collectors.joining(","));
    protected FundPlanChangeHelper fundPlanChangeHelper = new FundPlanChangeHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("project");
        fields.add("contract");
        fields.add("claimamount");
        fields.add("claimoftaxamount");
        fields.add("period");
        fields.add("issettle");
        fields.add("budgetitem");
        fields.add("paydirection");
        fields.add("id");
        fields.add("currency");
        fields.add("stdcurrency");
        fields.add("exchangerate");
        fields.add("creator");
        fields.add("createtime");
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("billno");
        fields.add("billname");
        fields.add("isneedsettle");
        fields.add("afteroftaxamount");
        fields.add("avgtaxrate");
        fields.add("ismultirate");
        fields.add("kapianentry");
        fields.add("entryentity");
        fields.add("subclaimtype");
        fields.add("listid");
        fields.add("changecount");
        fields.add("thisafteroftaxamount");
        fields.add("newlistingid");
        fields.add("superlistingid");
        fields.add("parentlisting");
        fields.add("listnumber");
        fields.add("listname");
        fields.add("amount");
        fields.add("tax");
        fields.add("oftax");
        fields.add("remark");
        fields.add("listmodelid");
        fields.add("beaffectedcount");
        fields.add("afterclaimoftaxprice");
        fields.add("measureunit");
        fields.add("qty");
        fields.add("price");
        fields.add("subtaxrate");
        fields.add("rateobj");
        fields.add("oftaxprice");
        fields.add("materiel");
        fields.add("sysnum");
        fields.add("cmptype");
        fields.add("listingbudgetitem");
        fields.add("primaryoftaxamount");
        fields.add("claimpayplanentry");
        fields.add("supplier");
        fields.add("paytype");
        fields.add("payfeq");
        fields.add("payway");
        fields.add("paypercent");
        fields.add("payamountoftax");
        fields.add("planpaytime");
        fields.add("seq");
        fields.add("conplanitemid");
        fields.add("nodesetting");
        fields.add("ctrlstrategy");
        fields.add("nodesettingsource");
        fields.add("taskcompletestate");
    }

    @Override
    public void reverseWritingToContract(String operationKey, DynamicObject dataEntity) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("contract").getPkValue(), (String)"pmct_outcontract", (String)selector);
        BigDecimal totalClaimAmount = contract.getBigDecimal("totalclaimamount");
        BigDecimal totalClaimOfTaxAmount = contract.getBigDecimal("totalclaimoftaxamount");
        BigDecimal totalAmount = contract.getBigDecimal("totalamount");
        BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
        BigDecimal claimAmount = dataEntity.getBigDecimal("claimamount");
        BigDecimal claimOfTaxAmount = dataEntity.getBigDecimal("claimoftaxamount");
        boolean isNeedSettle = dataEntity.getBoolean("isneedsettle");
        if (operationKey.equals("audit") && isNeedSettle) {
            contract.set("totalclaimamount", (Object)totalClaimAmount.add(claimAmount));
            contract.set("totalclaimoftaxamount", (Object)totalClaimOfTaxAmount.add(claimOfTaxAmount));
            contract.set("totalamount", (Object)totalAmount.add(claimAmount));
            contract.set("totaloftaxamount", (Object)totalOfTaxAmount.add(claimOfTaxAmount));
            boolean isMultiRate = dataEntity.getBoolean("ismultirate");
            if (isMultiRate) {
                contract.set("lstavgtaxrate", dataEntity.get("avgtaxrate"));
            }
            DynamicObjectCollection cardEntry = (DynamicObjectCollection)dataEntity.get("kapianentry");
            ArrayList<DynamicObject> listUpdateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> listAddList = new ArrayList<DynamicObject>();
            for (int i = 0; i < cardEntry.size(); ++i) {
                DynamicObjectCollection subEntries = (DynamicObjectCollection)((DynamicObject)cardEntry.get(i)).get("entryentity");
                HashMap<String, DynamicObject> newListingMap = new HashMap<String, DynamicObject>(16);
                this.addNotDetailListing(dataEntity, contract, subEntries, listAddList, newListingMap);
                this.addListingByChangeType(dataEntity, contract, subEntries, listUpdateList, listAddList, newListingMap);
            }
            if (!listUpdateList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])listUpdateList.toArray(new DynamicObject[listUpdateList.size()]));
            }
            if (!listAddList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)listAddList.get(0)).getDataEntityType(), (Object[])listAddList.toArray());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    protected void addListingByChangeType(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listUpdateList, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject parentListing;
            BigDecimal avgTaxPrice;
            BigDecimal curChangedAmount;
            int pricePrecision;
            DynamicObject currency;
            BigDecimal taxrate;
            BigDecimal changedTaxAmount;
            BigDecimal curChangedTaxAmount;
            DynamicObject listing;
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            int claimType = TypeUtils.nullToInt((Object)subEntry.get("subclaimtype"));
            if (claimType == 0) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                double changeqty = TypeUtils.StringToDouble((Object)listing.get("changeqty"));
                listing.set("changeqty", (Object)(changeqty += TypeUtils.StringToDouble((Object)subEntry.get("changecount"))));
                curChangedTaxAmount = (BigDecimal)subEntry.get("thisafteroftaxamount");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                taxrate = subEntry.getBigDecimal("subtaxrate");
                currency = dataEntity.getDynamicObject("currency");
                pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("qty")) + changeqty;
                listing.set("totalqty", (Object)totalQty);
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                BigDecimal totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                if ((parentListing = listing.getDynamicObject("parent")) != null) {
                    ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                }
                listUpdateList.add(listing);
                continue;
            }
            if (claimType == 1) {
                listing = (DynamicObject)subEntry.get("listid");
                if (listing == null) continue;
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                listing.set("ischanged", (Object)Boolean.TRUE);
                listing.set("enable", (Object)1);
                BigDecimal effectQty = subEntry.getBigDecimal("beaffectedcount");
                BigDecimal lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
                listing.set("chgeffectqty", (Object)effectQty.add(lastChangedEffectQty));
                listing.set("curtaxprice", (Object)subEntry.getBigDecimal("afterclaimoftaxprice"));
                curChangedTaxAmount = subEntry.getBigDecimal("thisafteroftaxamount");
                changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
                listing.set("chgoftaxamount", (Object)changedTaxAmount.add(curChangedTaxAmount));
                taxrate = subEntry.getBigDecimal("subtaxrate");
                currency = dataEntity.getDynamicObject("currency");
                pricePrecision = currency != null ? currency.getInt("priceprecision") : 10;
                curChangedAmount = NumberHelper.divide((Object)curChangedTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
                listing.set("latestamount", (Object)subEntry.getBigDecimal("amount").add(curChangedAmount));
                BigDecimal lastTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
                BigDecimal totalChangedTaxAmount = lastTotalChangedTaxAmount.add(curChangedTaxAmount);
                listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
                double totalQty = TypeUtils.StringToDouble((Object)listing.get("totalqty"));
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(totalQty)) != 0) {
                    avgTaxPrice = NumberHelper.divide((Object)totalChangedTaxAmount, (Object)BigDecimal.valueOf(totalQty), (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    listing.set("avgtaxprice", (Object)avgTaxPrice);
                }
                if ((parentListing = listing.getDynamicObject("parent")) != null) {
                    ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount);
                }
                listUpdateList.add(listing);
                continue;
            }
            if (claimType != 2) continue;
            listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("id", subEntry.get("newlistingid"));
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("listparentid", (Object)subEntry.getString("superlistingid"));
            listing.set("number", subEntry.get("listnumber"));
            listing.set("name", subEntry.get("listname"));
            if (subEntry.get("measureunit") != null) {
                listing.set("measureunit", subEntry.getDynamicObject("measureunit").getPkValue());
            }
            listing.set("qty", subEntry.get("qty"));
            listing.set("totalqty", subEntry.get("qty"));
            listing.set("price", subEntry.get("price"));
            listing.set("amount", subEntry.get("amount"));
            listing.set("taxrate", subEntry.get("subtaxrate"));
            listing.set("rateobj", subEntry.get("rateobj"));
            listing.set("tax", subEntry.get("tax"));
            listing.set("taxprice", subEntry.get("oftaxprice"));
            listing.set("avgtaxprice", subEntry.get("oftaxprice"));
            listing.set("curtaxprice", subEntry.get("oftaxprice"));
            listing.set("oftax", subEntry.get("oftax"));
            listing.set("lstoftaxamount", subEntry.get("oftax"));
            listing.set("latestamount", subEntry.get("amount"));
            listing.set("desc", subEntry.get("remark"));
            DynamicObject parentnode = (DynamicObject)subEntry.getParent();
            listing.set("listingmodel", parentnode.get("listmodelid"));
            listing.set("contractid", (Object)contract.getPkValue().toString());
            listing.set("enable", (Object)1);
            listing.set("status", (Object)"C");
            listing.set("listingbudgetitem", subEntry.get("listingbudgetitem"));
            listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
            listing.set("isleaf", (Object)Boolean.TRUE);
            if (subEntry.get("materiel") != null) {
                listing.set("material", subEntry.getDynamicObject("materiel").getPkValue());
            }
            if (subEntry.getDynamicObject("parentlisting") != null) {
                listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
                listing.set("parent", subEntry.getDynamicObject("parentlisting").getPkValue());
            } else if (subEntry.get("superlistingid") != null && subEntry.getLong("superlistingid") != 0L) {
                DynamicObject superListing = newListingMap.get(String.valueOf(subEntry.getLong("superlistingid")));
                listing.set("level", (Object)(superListing.getInt("level") + 1));
                listing.set("parent", (Object)subEntry.getLong("superlistingid"));
            } else {
                listing.set("level", (Object)1);
                listing.set("parent", null);
            }
            listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
            listaddList.add(listing);
            DynamicObject parentListing2 = subEntry.getDynamicObject("parentlisting");
            if (parentListing2 == null) continue;
            curChangedTaxAmount = subEntry.getBigDecimal("oftax");
            BigDecimal curChangedAmount2 = subEntry.getBigDecimal("amount");
            ContractListHelper.updateContractParentDataOnAudit(listUpdateList, (DynamicObject)parentListing2, (BigDecimal)curChangedTaxAmount, (BigDecimal)curChangedAmount2);
        }
    }

    protected void addNotDetailListing(DynamicObject dataEntity, DynamicObject contract, DynamicObjectCollection subentrys, List<DynamicObject> listaddList, Map<String, DynamicObject> newListingMap) {
        ArrayList<DynamicObject> updateLevelList = new ArrayList<DynamicObject>(10);
        for (int k = 0; k < subentrys.size(); ++k) {
            DynamicObject subEntry = (DynamicObject)subentrys.get(k);
            int claimType = TypeUtils.nullToInt((Object)subEntry.get("subclaimtype"));
            if (claimType != 3) continue;
            DynamicObject listing = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            listing.set("id", subEntry.get("newlistingid"));
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("isleaf", (Object)Boolean.FALSE);
            listing.set("listparentid", subEntry.get("superlistingid"));
            listing.set("parent", subEntry.get("superlistingid"));
            if (subEntry.getDynamicObject("parentlisting") != null) {
                listing.set("level", (Object)(subEntry.getDynamicObject("parentlisting").getInt("level") + 1));
            } else {
                updateLevelList.add(listing);
            }
            listing.set("number", subEntry.get("listnumber"));
            listing.set("name", subEntry.get("listname"));
            listing.set("amount", subEntry.get("amount"));
            listing.set("tax", subEntry.get("tax"));
            listing.set("oftax", subEntry.get("oftax"));
            listing.set("lstoftaxamount", subEntry.get("oftax"));
            listing.set("desc", subEntry.get("remark"));
            DynamicObject parentnode = (DynamicObject)subEntry.getParent();
            listing.set("listingmodel", parentnode.get("listmodelid"));
            listing.set("contractid", (Object)contract.getPkValue().toString());
            listing.set("enable", (Object)1);
            listing.set("status", (Object)"C");
            listing.set("currency", dataEntity.getDynamicObject("currency").getPkValue());
            listing.set("sysnumber", (Object)subEntry.getString("sysnum"));
            listaddList.add(listing);
            newListingMap.put(subEntry.get("newlistingid").toString(), listing);
        }
        for (DynamicObject listing : updateLevelList) {
            if (listing.get("listparentid") != null && listing.getLong("listparentid") != 0L) {
                DynamicObject parent = newListingMap.get(String.valueOf(listing.getLong("listparentid")));
                listing.set("level", (Object)(parent.getInt("level") + 1));
                continue;
            }
            listing.set("level", (Object)1);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.addValidator((AbstractValidator)new ContractClaimValidator());
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) continue;
                    this.validatePaymentApplyAmount(dataEntity);
                    this.validateSettleAmount(dataEntity);
                }
            }

            private void validatePaymentApplyAmount(ExtendedDataEntity dataEntity) {
                BigDecimal originAmount;
                boolean needSettle = dataEntity.getDataEntity().getBoolean("isneedsettle");
                if (!needSettle) {
                    return;
                }
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                String amountControl = contType.getString("ammountcontrolapply");
                if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                    return;
                }
                QFilter contractFilter = new QFilter("entryentity.entrycontract", "in", contract.getPkValue());
                QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_paymentapply", (String)"entryentity.applyoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                BigDecimal applyAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("entryentity.applyoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                int compareResult = applyAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("primaryoftaxamount"));
                if (compareResult > 0) {
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractClaimBillOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractClaimBillOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void validateSettleAmount(ExtendedDataEntity dataEntity) {
                BigDecimal originAmount;
                boolean needSettle = dataEntity.getDataEntity().getBoolean("isneedsettle");
                if (!needSettle) {
                    return;
                }
                DynamicObject contract = dataEntity.getDataEntity().getDynamicObject("contract");
                DynamicObject contractType = contract.getDynamicObject("contracttype");
                DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                String amountControl = contType.getString("ammountcontrolsettle");
                if (ContractControlEnum.NOTCONTROL.getValue().equals(amountControl)) {
                    return;
                }
                QFilter contractFilter = new QFilter("contract", "in", contract.getPkValue());
                QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()});
                DynamicObjectCollection amountList = QueryServiceHelper.query((String)"pmct_outcontract_settle", (String)"settleoftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter});
                BigDecimal settleAmount = amountList.stream().map(dyn -> dyn.getBigDecimal("settleoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                int compareResult = settleAmount.compareTo(originAmount = dataEntity.getDataEntity().getBigDecimal("primaryoftaxamount"));
                if (compareResult > 0) {
                    if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControl)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContractClaimBillOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControl)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u5bfc\u81f4\u5408\u540c\u7684\u7d2f\u8ba1\u7ed3\u7b97\u542b\u7a0e\u91d1\u989d\u8d85\u51fa\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractClaimBillOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block5: {
            DynamicObject[] dataEntities;
            String operationKey;
            block4: {
                super.beginOperationTransaction(e);
                operationKey = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
                    this.updateBudgetData(dataEntities, operationKey);
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) break block4;
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_outclaimbill");
                    this.generateFundPlanChangeObj(dataEntity);
                    if (dynamicObject.getBoolean("isneedsettle")) {
                        ContractPayItemHelper.save((DynamicObject)dynamicObject, (PayPlanSourceEnum)PayPlanSourceEnum.CLAIM);
                        continue;
                    }
                    ContractPayItemHelper.save((DynamicObject)dynamicObject, (PayPlanSourceEnum)PayPlanSourceEnum.CLAIM, (Object)dynamicObject.getDynamicObject("contract").getPkValue());
                }
                break block5;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) break block5;
            for (DynamicObject dataEntity : dataEntities) {
                this.returnPayPlan(dataEntity);
            }
        }
    }

    private void returnPayPlan(DynamicObject dataEntity) {
        UnAuditHelper.deleteClaimAutogeneratedItem((DynamicObject)dataEntity);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outclaimbill"));
        DynamicObjectCollection payPlanEntry = bill.getDynamicObjectCollection("claimpayplanentry");
        UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)payPlanEntry);
    }

    private void generateFundPlanChangeObj(DynamicObject dynamicObject) {
        Object sourceId = dynamicObject.getPkValue();
        Object contractId = ((DynamicObject)dynamicObject.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.CLAIM.getValue();
        dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"pmct_outclaimbill");
        DynamicObjectCollection customEntries = dynamicObject.getDynamicObjectCollection("claimpayplanentry");
        DynamicObject fundPlanChangeObj = this.fundPlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])customEntries.toArray((Object[])new DynamicObject[0]), "pmct_outclaimbill", true);
        fundPlanChangeObj.set("sourcebillid", dynamicObject.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            boolean isNew;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean isOpenedContract = contract.getBoolean("openedcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project == null || isOpenedContract || multiPartSettlement || (isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue())))) continue;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            Map<Object, Object> projectAmountMap = new HashMap(16);
            if (proApp != null && proApp.length > 0) {
                projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, proApp[0]));
            }
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outclaimbill").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).contractCurrency(bill.getDynamicObject("currency")).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outclaimbill").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outclaimbill").billNo(bill.getString("billno")).billName(bill.getString("billname")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_outclaimbill", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        boolean isOnList = bill.getDynamicObject("contract").getBoolean("isonlist");
        boolean isNeedSettle = bill.getBoolean("isneedsettle");
        if (isOnList && isNeedSettle) {
            DynamicObjectCollection listModelEntries = bill.getDynamicObjectCollection("kapianentry");
            for (DynamicObject listModelEntry : listModelEntries) {
                DynamicObjectCollection listEntry = listModelEntry.getDynamicObjectCollection("entryentity");
                String cmpType = listModelEntry.getString("cmptype");
                BigDecimal coefficient = BigDecimal.ONE;
                if ("(0)".equals(cmpType)) continue;
                if ("(-)".equals(cmpType)) {
                    coefficient = BigDecimal.valueOf(-1L);
                }
                for (DynamicObject list : listEntry) {
                    BigDecimal amount;
                    DynamicObject budget = list.getDynamicObject("listingbudgetitem");
                    String changeType = list.getString("subclaimtype");
                    if (budget != null && (StringUtils.equals((CharSequence)"0", (CharSequence)changeType) || StringUtils.equals((CharSequence)"1", (CharSequence)changeType))) {
                        amount = list.getBigDecimal("thisafteroftaxamount").multiply(coefficient);
                        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                        continue;
                    }
                    if (budget == null || !StringUtils.equals((CharSequence)"2", (CharSequence)changeType) || (amount = list.getBigDecimal("oftax").multiply(coefficient)) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
                }
            }
        } else {
            DynamicObject budget = bill.getDynamicObject("budgetitem");
            BigDecimal amount = bill.getBigDecimal("claimoftaxamount");
            if (budget != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                this.addBudgetAmount(exchangeRate, budgetAmountMap, budget, amount);
            }
        }
        return budgetAmountMap;
    }

    protected void addBudgetAmount(BigDecimal exchangeRate, Map<String, BigDecimal> budgetAmountMap, DynamicObject budget, BigDecimal amount) {
        BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
        if (budgetAmount == null) {
            budgetAmount = BigDecimal.ZERO;
        }
        budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
    }
}

