/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contclarific;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ContractClarificValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"audit")) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            HashSet<Object> contractid = new HashSet<Object>();
            if (dataEntities != null && dataEntities.length > 0) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject contract = bill.getDynamicObject("contract");
                    QFilter qFilter = new QFilter("contract", "=", contract.getPkValue()).and(new QFilter("billstatus", "=", (Object)"C"));
                    QFilter[] qFilters = new QFilter[]{qFilter};
                    String direction = contract.getString("paydirection");
                    String formBillId = null;
                    if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.IN.getValue())) {
                        formBillId = "pmct_inclarificbill";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)PayDirectionEnum.OUT.getValue())) {
                        formBillId = "pmct_outclarificbill";
                    }
                    boolean flag = QueryServiceHelper.exists((String)formBillId, (QFilter[])qFilters);
                    if (flag || contractid.contains(contract.getPkValue())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u53ea\u80fd\u505a\u4e00\u6b21\u4ea4\u5e95\u3002", (String)"ContractClarificValidator_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    contractid.add(contract.getPkValue());
                }
            }
        }
    }
}

