/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contsettle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.contsettle.FinalSettleValidator;

public class OutContractFinalSettleOp
extends AbstractReverseWritingPmctContractOp {
    private static final String CONTRACTSTATUS = "contractstatus";
    private String selectPro = "appamount, apptaxamount, contractstatus";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("appamount");
        e.getFieldKeys().add("apptaxamount");
        e.getFieldKeys().add("taxamount");
        e.getFieldKeys().add("tempcontstatus");
        e.getFieldKeys().add("paydirection");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("itemsubamount");
        e.getFieldKeys().add("itemappamount");
        e.getFieldKeys().add("itemamount");
        e.getFieldKeys().add("itempayaomunt");
        e.getFieldKeys().add("itemsettaomunt");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("taxrate");
        e.getFieldKeys().add("avgtaxrate");
        e.getFieldKeys().add("ismultirate");
    }

    @Override
    public void reverseWritingToContract(String opkey, DynamicObject finalSettle) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)finalSettle.getDynamicObject("contract").getPkValue(), (String)"pmct_outcontract", (String)this.selectPro);
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)opkey)) {
            contract.set("appamount", (Object)finalSettle.getBigDecimal("appamount"));
            contract.set("apptaxamount", (Object)finalSettle.getBigDecimal("apptaxamount"));
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.CLOSED.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contract.set(CONTRACTSTATUS, (Object)contStatusObj);
        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)opkey)) {
            contract.set("appamount", (Object)BigDecimal.ZERO);
            contract.set("apptaxamount", (Object)BigDecimal.ZERO);
            DynamicObject tempContStatus = finalSettle.getDynamicObject("tempcontstatus");
            if (tempContStatus == null) {
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contract.set(CONTRACTSTATUS, (Object)contStatusObj);
            } else {
                contract.set(CONTRACTSTATUS, (Object)tempContStatus);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinalSettleValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject contract;
                ExtendedDataEntity[] dataEntities;
                String key = this.getOperateKey();
                if ((StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit")) && (dataEntities = this.getDataEntities()) != null) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        int compare;
                        DynamicObject bill = dataEntity.getDataEntity();
                        boolean result = OutContractFinalSettleOp.this.validateRate(bill);
                        if (!result) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u7a0e\u7387\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5355\u636e\u8fdb\u884c\u8c03\u6574\u3002", (String)"OutContractFinalSettleOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        }
                        contract = bill.getDynamicObject("contract");
                        DynamicObject contractType = contract.getDynamicObject("contracttype");
                        contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype");
                        String amountControlSettleParam = contractType.getString("ammountcontrolsettle");
                        if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControlSettleParam)) {
                            compare = OutContractFinalSettleOp.this.amountCompare(bill);
                            if (compare >= 0) break;
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u51b3\u7b97\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractFinalSettleOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (!ContractControlEnum.STRICTCONTROL.getValue().equals(amountControlSettleParam)) continue;
                        compare = OutContractFinalSettleOp.this.amountCompare(bill);
                        if (compare >= 0) break;
                        throw new KDBizException(ResManager.loadKDString((String)"\u51b3\u7b97\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractFinalSettleOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") && (dataEntities = this.getDataEntities()) != null) {
                    BigDecimal sum = BigDecimal.ZERO;
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        BigDecimal apptaxamount;
                        DynamicObject bill = dataEntity.getDataEntity();
                        contract = bill.getDynamicObject("contract");
                        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                        if (entryentity.isEmpty() || (sum = entryentity.stream().map(o -> o.getBigDecimal("itemappamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(apptaxamount = bill.getBigDecimal("apptaxamount")) == 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u603b\u91d1\u989d\u4e0e\u9884\u7b97\u5206\u644a\u5206\u5f55\u5408\u540c\u5ba1\u5b9a\u542b\u7a0e\u91d1\u989d\u6c47\u603b\u503c\u4e0d\u7b49\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutContractFinalSettleOp_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.updateBudgetData(dataEntities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject contract = bill.getDynamicObject("contract");
            DynamicObject project = contract.getDynamicObject("project");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) {
                return;
            }
            DynamicObject[] proApps = null;
            boolean multipartSettlement = contract.getBoolean("multipartsettlement");
            if (multipartSettlement) {
                Set<Object> proIdSet = this.getProIdSetWithMultiSettle(bill);
                Set oldProIdSet = proIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
                proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", oldProIdSet)});
            } else if (project != null) {
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                if (isNew) continue;
                proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            }
            if (proApps == null || proApps.length <= 0) continue;
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, proApps);
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outfinalsettle").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).contractCurrency(bill.getDynamicObject("currency")).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outfinalsettle").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_outfinalsettle").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_outfinalsettle", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, DynamicObject[] proApps) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(proApps.length);
        for (DynamicObject proApp : proApps) {
            BigDecimal exchangeRate = this.getExchangeRate(contract, proApp);
            DynamicObject pro = proApp.getDynamicObject("pro");
            exchangeRateMap.put(pro.getPkValue(), exchangeRate);
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            DynamicObject project;
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey((project = budget.getDynamicObject("project")).getPkValue())) continue;
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return budgetAmountMap;
    }

    protected int amountCompare(DynamicObject settleBill) {
        BigDecimal contractAmount = settleBill.getBigDecimal("taxamount");
        BigDecimal appTaxAmount = settleBill.getBigDecimal("apptaxamount");
        int compare = contractAmount.compareTo(appTaxAmount);
        return compare;
    }

    private Set<Object> getProIdSetWithMultiSettle(DynamicObject bill) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            proIdSet = new HashSet(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
        }
        return proIdSet;
    }

    protected boolean validateRate(DynamicObject bill) {
        DynamicObject contract = bill.getDynamicObject("contract");
        if (contract == null) {
            return true;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        boolean isMultiRate = bill.getBoolean("ismultirate");
        boolean isLastRate = true;
        if (!isMultiRate) {
            BigDecimal settleRate;
            BigDecimal contractRate;
            DynamicObject contractRateDyn = contract.getDynamicObject("lsttaxrate");
            DynamicObject settleRateDyn = bill.getDynamicObject("taxrate");
            if (contractRateDyn != null && settleRateDyn != null && (contractRate = contractRateDyn.getBigDecimal("taxrate")).compareTo(settleRate = settleRateDyn.getBigDecimal("taxrate")) != 0) {
                isLastRate = false;
            }
        } else {
            BigDecimal contractAvgRate = contract.getBigDecimal("lstavgtaxrate");
            BigDecimal settleAvgRate = bill.getBigDecimal("avgtaxrate");
            if (contractAvgRate != null && settleAvgRate != null && contractAvgRate.compareTo(settleAvgRate) != 0) {
                isLastRate = false;
            }
        }
        return isLastRate;
    }
}

