/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.manage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MonthlyFundPlanOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("period");
        fields.add("org");
        fields.add("billno");
        fields.add("inperiodplanamt");
        fields.add("outperiodplanamt");
        fields.add("incontractplanentity");
        fields.add("outcontractplanentity");
        fields.add("outcontract");
        fields.add("incontract");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new MonthlyFundPlanValidator());
    }

    public class MonthlyFundPlanValidator
    extends AbstractValidator {
        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)MonthlyFundPlanOp.OPERATION_UNAUDIT, (CharSequence)key)) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkInContractReference(dataEntity);
                    this.checkApplymentPayReference(dataEntity);
                    this.checkPaymentApplyReference(dataEntity);
                }
            }
        }

        protected void checkInContractReference(ExtendedDataEntity dataEntity) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entities = bill.getDynamicObjectCollection("incontractplanentity");
            HashMap<DynamicObject, DynamicObject[]> referencedBillMap = new HashMap<DynamicObject, DynamicObject[]>();
            for (DynamicObject entity : entities) {
                QFilter fundPlanPkFilter = new QFilter("entryentity.fundplan", "=", entity.getPkValue());
                DynamicObject[] referenceBills = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{fundPlanPkFilter});
                if (referenceBills.length <= 0) continue;
                referencedBillMap.put(entity, referenceBills);
            }
            if (!referencedBillMap.isEmpty()) {
                referencedBillMap.forEach((entry, referencedBills) -> Arrays.stream(referencedBills).forEach(referencedBill -> this.addErrorMessage(dataEntity, (DynamicObject)entry, (DynamicObject)referencedBill, "incontract")));
            }
        }

        protected void checkApplymentPayReference(ExtendedDataEntity dataEntity) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entities = bill.getDynamicObjectCollection("outcontractplanentity");
            HashMap<DynamicObject, DynamicObject[]> referencedBillMap = new HashMap<DynamicObject, DynamicObject[]>();
            for (DynamicObject entity : entities) {
                QFilter fundPlanPkFilter = new QFilter("fundplan", "=", entity.getPkValue());
                DynamicObject[] referenceBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{fundPlanPkFilter});
                if (referenceBills.length <= 0) continue;
                referencedBillMap.put(entity, referenceBills);
            }
            if (!referencedBillMap.isEmpty()) {
                referencedBillMap.forEach((entry, referencedBills) -> Arrays.stream(referencedBills).forEach(referencedBill -> this.addErrorMessage(dataEntity, (DynamicObject)entry, (DynamicObject)referencedBill, "outcontract")));
            }
        }

        protected void checkPaymentApplyReference(ExtendedDataEntity dataEntity) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entities = bill.getDynamicObjectCollection("outcontractplanentity");
            HashMap<DynamicObject, DynamicObject[]> referencedBillMap = new HashMap<DynamicObject, DynamicObject[]>();
            for (DynamicObject entity : entities) {
                QFilter fundPlanPkFilter = new QFilter("entryentity.fundplan", "=", entity.getPkValue());
                DynamicObject[] referenceBills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{fundPlanPkFilter});
                if (referenceBills.length <= 0) continue;
                referencedBillMap.put(entity, referenceBills);
            }
            if (!referencedBillMap.isEmpty()) {
                referencedBillMap.forEach((entry, referencedBills) -> Arrays.stream(referencedBills).forEach(referencedBill -> this.addErrorMessage(dataEntity, (DynamicObject)entry, (DynamicObject)referencedBill, "outcontract")));
            }
        }

        protected void addErrorMessage(ExtendedDataEntity dataEntity, DynamicObject upstreamBill, DynamicObject referencedBill, String contractFormId) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e%1$s\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MonthlyFundPlanOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), referencedBill.getDynamicObjectType().getDisplayName().getLocaleValue(), referencedBill.getString("billno"));
            String contractBillNo = upstreamBill.getDynamicObject(contractFormId).getString("billno");
            errorMsg = String.format("%s%s", contractBillNo, errorMsg);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

