/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.register;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.base.AbstractPmctOperationServicePlugin;
import kd.pmgt.pmct.opplugin.register.PayRegisterBudgetValidator;

public class PayRegisterBudgetOp
extends AbstractPmctOperationServicePlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("entryentity");
        fields.add("entrycontract");
        fields.add("sourcetype");
        fields.add("project");
        fields.add("id");
        fields.add("currency");
        fields.add("creator");
        fields.add("createtime");
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("billno");
        fields.add("billname");
        fields.add("entryentity");
        fields.add("contcurrency");
        fields.add("subentryentity");
        fields.add("budgetitem");
        fields.add("curactualpaysplitamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayRegisterBudgetValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.updateBudgetData(dataEntities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        for (DynamicObject payRegistBill : entities) {
            DynamicObject project = payRegistBill.getDynamicObject("project");
            DynamicObjectCollection contractEntrys = payRegistBill.getDynamicObjectCollection("entryentity");
            HashMap<String, DynamicObject> contractIdSet = new HashMap<String, DynamicObject>(16);
            HashMap<String, Map<String, BigDecimal>> contractToProAmountMap = new HashMap<String, Map<String, BigDecimal>>(16);
            HashMap<String, Map<String, BigDecimal>> contractToContAmountMap = new HashMap<String, Map<String, BigDecimal>>(16);
            for (DynamicObject contractEntryRow : contractEntrys) {
                DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                contractIdSet.put(contract.getPkValue().toString(), contract.getDynamicObject("currency"));
                if (project != null) {
                    boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
                    if (isNew) continue;
                    DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    if (proApps != null && proApps.length > 0) {
                        this.buildBudgetAmountMap(contractToProAmountMap, contractEntryRow, BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApps[0]));
                    }
                } else {
                    Set<Object> proIdSet = this.getProIdSet(payRegistBill, contractEntryRow);
                    Set<Object> oldProIdSet = proIdSet.stream().map(Object::toString).map(Long::valueOf).filter(proId -> !ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)proId)).collect(Collectors.toSet());
                    this.buildBudgetAmountMap(contractToProAmountMap, contractEntryRow, oldProIdSet);
                }
                this.buildBudgetAmountMap(contractToContAmountMap, contractEntryRow, BigDecimal.ONE);
            }
            for (Map.Entry entry : contractIdSet.entrySet()) {
                PerformBillInfo billInfo;
                String contractId = (String)entry.getKey();
                DynamicObject contCurrency = (DynamicObject)entry.getValue();
                Map projectAmountMap = (Map)contractToProAmountMap.get(contractId);
                Map contractAmountMap = (Map)contractToContAmountMap.get(contractId);
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_paymentregister").billNo(payRegistBill.getString("billno")).billName(payRegistBill.getString("billname")).creator(payRegistBill.getDynamicObject("creator")).createDate(payRegistBill.getDate("createtime")).id(payRegistBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_PAY).contractCurrency(contCurrency).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnSubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_paymentregister").id(payRegistBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_PAY).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                    billInfo = new PerformBillInfoBuilder().formBillId("pmct_paymentregister").billNo(payRegistBill.getString("billno")).billName(payRegistBill.getString("billname")).creator(payRegistBill.getDynamicObject("creator")).createDate(payRegistBill.getDate("createtime")).auditor(payRegistBill.getDynamicObject("auditor")).auditDate(payRegistBill.getDate("auditdate")).id(payRegistBill.getLong("id")).contractId(contractId).amountType(PerformAmountTypeEnum.ACTUAL_PAY).build();
                    BudgetValidateAndUpdateHelper.updateBudgetOnAudit((Map)projectAmountMap, (Map)contractAmountMap, (PerformBillInfo)billInfo);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
                BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit((Map)projectAmountMap, (Map)contractAmountMap, (String)"pmct_paymentregister", (long)payRegistBill.getLong("id"), (String)contractId, (PerformAmountTypeEnum)PerformAmountTypeEnum.ACTUAL_PAY);
            }
        }
    }

    private Set<Object> getProIdSet(DynamicObject payBill, DynamicObject contractEntryRow) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        DynamicObject project = payBill.getDynamicObject("project");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            if (project == null) {
                DynamicObjectCollection entryEntity = contractEntryRow.getDynamicObjectCollection("subentryentity");
                proIdSet = new HashSet(entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
            }
        } else if (project == null && (project = contract.getDynamicObject("project")) != null) {
            proIdSet.add(project.getPkValue());
        }
        return proIdSet;
    }

    protected void buildBudgetAmountMap(Map<String, Map<String, BigDecimal>> contractToAmountMap, DynamicObject contractEntryRow, Set<Object> proIdSet) {
        Map<String, BigDecimal> budgetAmountMap;
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)});
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        if (proApps != null && proApps.length > 0) {
            for (DynamicObject proApp : proApps) {
                BigDecimal exchangeRate = BudgetValidateAndUpdateHelper.getExchangeRate((DynamicObject)contract, (DynamicObject)proApp);
                DynamicObject pro = proApp.getDynamicObject("pro");
                exchangeRateMap.put(pro.getPkValue(), exchangeRate);
            }
        } else {
            for (Object e : proIdSet) {
                exchangeRateMap.put(e, BigDecimal.ONE);
            }
        }
        if ((budgetAmountMap = contractToAmountMap.get(contract.getPkValue().toString())) == null) {
            budgetAmountMap = new HashMap<String, BigDecimal>(16);
        }
        DynamicObjectCollection dynamicObjectCollection = contractEntryRow.getDynamicObjectCollection("subentryentity");
        for (DynamicObject entry : dynamicObjectCollection) {
            DynamicObject project;
            BigDecimal amount = entry.getBigDecimal("curactualpaysplitamt");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || !proIdSet.contains((project = budget.getDynamicObject("project")).getPkValue()) || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey(project.getPkValue())) continue;
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        contractToAmountMap.put(contract.getPkValue().toString(), budgetAmountMap);
    }

    protected void buildBudgetAmountMap(Map<String, Map<String, BigDecimal>> contractToAmountMap, DynamicObject contractEntryRow, BigDecimal exchangeRate) {
        DynamicObject contract = contractEntryRow.getDynamicObject("entrycontract");
        Map<String, BigDecimal> budgetAmountMap = contractToAmountMap.get((contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getPkValue().toString());
        if (budgetAmountMap == null) {
            budgetAmountMap = new HashMap<String, BigDecimal>(16);
        }
        DynamicObjectCollection entryentity = contractEntryRow.getDynamicObjectCollection("subentryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("curactualpaysplitamt");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        contractToAmountMap.put(contract.getPkValue().toString(), budgetAmountMap);
    }
}

