/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ContractValidator
extends AbstractValidator {
    public void validate() {
        block13: {
            String key;
            block12: {
                key = this.getOperateKey();
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) break block12;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    boolean flag;
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject contractStatus = bill.getDynamicObject("contractstatus");
                    boolean bl = flag = bill.getBoolean("auditassign") && StringUtils.equals((CharSequence)contractStatus.getString("number"), (CharSequence)ContractStatusEnum.RUNNING.getValue());
                    if (!StringUtils.equals((CharSequence)contractStatus.getString("number"), (CharSequence)ContractStatusEnum.APPROVED.getValue()) && !flag) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u6279\u51c6\u201d\u5408\u540c\u72b6\u6001\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ContractValidator_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!bill.getString("paydirection").isEmpty() && bill.getString("paydirection").equals(PayDirectionEnum.OUT.getValue())) {
                        DynamicObject[] payItems;
                        QFilter contractFilter = new QFilter("contract", "=", bill.getPkValue());
                        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "reimbursedcomamt", "paidcomamt"), (QFilter[])new QFilter[]{contractFilter});
                        if (contractPayItems != null && contractPayItems.length > 0) {
                            DynamicObject contractPayItem = contractPayItems[0];
                            BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
                            BigDecimal paidComAmt = contractPayItem.getBigDecimal("paidcomamt");
                            if (BigDecimal.ZERO.compareTo(reimbursedComAmt) < 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5df2\u7ecf\u53d1\u751f\u62a5\u9500\u3002", (String)"ContractValidator_6", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                            if (BigDecimal.ZERO.compareTo(paidComAmt) < 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5df2\u7ecf\u53d1\u751f\u4ed8\u6b3e\u3002", (String)"ContractValidator_7", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                            }
                        }
                        DynamicObjectCollection payPlanEntry = bill.getDynamicObjectCollection("outcontpayplanentry");
                        HashSet entryIds = new HashSet(payPlanEntry.size());
                        payPlanEntry.forEach(payPlan -> entryIds.add(payPlan.getPkValue()));
                        for (DynamicObject payItem : payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"name, billno,  masterid, status, enable, supplier, paytype, payfeq, payway, paypercent, payamount, planpaytime, remarks, reimbursedamt, reimbursedcomamt, reimbursableamt, paidamt, paidcomamt, unpaidamt, source, payplansource, contract, autogenerated, creator, createtime, modifier, modifytime, payplanentryid, performentryid, currency, paydirection, appliedamt, appliedcomamt, appliableamt, ctrlstrategy, nodesettingsource, nodesetting, taskcompletestatus,paidamount,unpayamount", (QFilter[])new QFilter[]{new QFilter("payplanentryid", "in", entryIds)})) {
                            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{payItem.getLong("id")});
                            if (targetBillIds.isEmpty()) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u5df2\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), payItem.getString("name")));
                        }
                    } else if (!bill.getString("paydirection").isEmpty() && bill.getString("paydirection").equals(PayDirectionEnum.IN.getValue())) {
                        DynamicObject[] incomeItems;
                        DynamicObjectCollection incomePlanEntry = bill.getDynamicObjectCollection("incontpayplanentry");
                        HashSet entryIds = new HashSet(incomePlanEntry.size());
                        incomePlanEntry.forEach(incomePlan -> entryIds.add(incomePlan.getPkValue()));
                        for (DynamicObject incomeItem : incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"masterid, status, billno, enable, customer, collecttype, collectfeq, collectway, collectpercent, currency, collectamount, plancollecttime, remarks, collectedamt, collectedcomamt, uncollectedamt, contract, sourcebilltype, autogenerated, creator, createtime, modifier, modifytime, sourcebill, paydirection", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", entryIds)})) {
                            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{incomeItem.getLong("id")});
                            if (targetBillIds.isEmpty()) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u5df2\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractValidator_9", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), incomeItem.getString("name")));
                        }
                    }
                    this.checkRefrenced(dataEntity);
                }
                break block13;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"dounsign")) break block13;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObject contractStatus = bill.getDynamicObject("contractstatus");
                if (!StringUtils.equals((CharSequence)contractStatus.getString("number"), (CharSequence)ContractStatusEnum.RUNNING.getValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6267\u884c\u4e2d\u201d\u5408\u540c\u72b6\u6001\u624d\u80fd\u53cd\u7b7e\u8ba2\u3002", (String)"ContractValidator_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                    continue;
                }
                this.checkRefrenced(dataEntity);
            }
        }
    }

    private void checkRefrenced(ExtendedDataEntity dataEntity) {
        Object billPkid = dataEntity.getBillPkId();
        ArrayList<String> ignoreEntityIds = new ArrayList<String>(10);
        if ("pmct_outcontract".equals(dataEntity.getDataEntity().getDynamicObjectType().getName())) {
            ignoreEntityIds.add("pmct_incontract_settle");
            ignoreEntityIds.add("pmct_inaddagreement");
            ignoreEntityIds.add("pmct_incontractrevision");
            ignoreEntityIds.add("pmct_inclaimbill");
            ignoreEntityIds.add("pmct_infinalsettle");
        } else {
            ignoreEntityIds.add("pmct_outcontract_settle");
            ignoreEntityIds.add("pmct_outaddagreement");
            ignoreEntityIds.add("pmct_outcontractrevision");
            ignoreEntityIds.add("pmct_outclaimbill");
            ignoreEntityIds.add("pmct_outfinalsettle");
        }
        ignoreEntityIds.add("pmct_contsign");
        ignoreEntityIds.add("pmct_contractlist");
        ignoreEntityIds.add("pmct_contdocbill");
        ignoreEntityIds.add("pmct_incontract");
        ignoreEntityIds.add("pmct_outcontract");
        ignoreEntityIds.add("pmct_all_contractf7");
        ignoreEntityIds.add("pmct_contracttpl");
        ignoreEntityIds.add("pmct_incontractf7");
        ignoreEntityIds.add("pmct_outcontractf7");
        ignoreEntityIds.add("pmct_contractf7");
        ignoreEntityIds.add("pmbs_bidmessage");
        ignoreEntityIds.add("pmfs_supplierident");
        ignoreEntityIds.add("pmct_revisiontpl");
        ignoreEntityIds.add("pmas_projectbudget");
        ignoreEntityIds.add("pmbs_budgetuserecord");
        ignoreEntityIds.add("pmbs_contractbudget");
        ignoreEntityIds.add("pmas_projectbudgetperform");
        ignoreEntityIds.add("pmbs_contbudgetperform");
        ignoreEntityIds.add("pmbs_incontractbudgetperf");
        ignoreEntityIds.add("pmas_projectinbudgetperf");
        ignoreEntityIds.add("pmbs_contractpayitem");
        ignoreEntityIds.add("pmbs_contractpayitembook");
        ignoreEntityIds.add("pmbs_contractcollectitem");
        ignoreEntityIds.add("pmbs_contractcolitembook");
        Map map = BaseDataRefrenceHelper.checkRefrenced((String)"pmct_contractf7", (Object[])new Object[]{billPkid}, ignoreEntityIds, null, null);
        if (!map.isEmpty()) {
            BaseDataCheckRefrenceResult referResult = (BaseDataCheckRefrenceResult)map.get(billPkid);
            String refFormId = referResult.getRefenceKey().getRefEntityKey();
            refFormId = refFormId.contains("pmct_ininvoicef7") ? "pmct_ininvoice" : refFormId;
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
            String billName = refMainType.getDisplayName().toString();
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u5df2\u88ab\u5355\u636e\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractValidator_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billName.replace(ResManager.loadKDString((String)"\u6a21\u677f", (String)"ContractValidator_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), "")));
        } else {
            boolean isRefed = QueryServiceHelper.exists((String)"pmct_contractf7", (QFilter[])new QFilter[]{new QFilter("contract", "=", billPkid)});
            if (isRefed) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u5df2\u88ab\u5176\u4ed6\u5408\u540c\u5173\u8054\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractValidator_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

