/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;

public class OutContractSettleValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        MainEntityType contractTypeDt = EntityMetadataCache.getDataEntityType((String)"pmct_conttype");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String billStatus;
            int compare;
            DynamicObject settleBill;
            DynamicObject contract;
            DynamicObject contractType;
            if (!operateKey.equals("submit") && !operateKey.equals("audit") && !operateKey.equals("unaudit") || (contractType = (contract = (settleBill = dataEntity.getDataEntity()).getDynamicObject("contract")).getDynamicObject("contracttype")) == null) continue;
            contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (DynamicObjectType)contractTypeDt);
            boolean openedContract = contract.getBoolean("openedcontract");
            String amountControlSettleParam = openedContract ? contractType.getString("ammountcontrolsettleopen") : contractType.getString("ammountcontrolsettle");
            if (ContractControlEnum.REMINDCONTROL.getValue().equals(amountControlSettleParam)) {
                int compare2 = this.amountCompare(settleBill);
                if (compare2 < 0) {
                    this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5df2\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractSettleValidator_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
                }
            } else if (ContractControlEnum.STRICTCONTROL.getValue().equals(amountControlSettleParam) && (compare = this.amountCompare(settleBill)) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c\u603b\u91d1\u989d\u3002", (String)"OutContractSettleValidator_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
                this.validatePaymentRate(dataEntity);
            }
            if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey) && !StringUtils.equals((CharSequence)"B", (CharSequence)(billStatus = settleBill.getString("billstatus")))) {
                return;
            }
            if (!operateKey.equals("unaudit")) continue;
            this.contractCostLimit(dataEntities);
        }
    }

    protected int amountCompare(DynamicObject settleBill) {
        BigDecimal contractAmount = settleBill.getBigDecimal("conttotaloftaxamount");
        BigDecimal totalSettleAmount = settleBill.getBigDecimal("totalsettleoftaxamount");
        return contractAmount.compareTo(totalSettleAmount);
    }

    private void contractCostLimit(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            Long pkValue = (Long)dataEntity.getPkValue();
            DynamicObject[] contractCosts = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)"billno,billname,entryentity.settleid", null);
            if (contractCosts.length <= 0) continue;
            for (DynamicObject bill : contractCosts) {
                DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entryEntity) {
                    Long settleId = row.getLong("settleid");
                    if (!settleId.equals(pkValue)) continue;
                    String formatText = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5408\u540c\u6210\u672c\u5206\u644a\u201c%2$s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"OutContractSettleValidator_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), dataEntity.getString("billno"), bill.getString("billno"));
                    this.addFatalErrorMessage(entity, formatText);
                }
            }
        }
    }

    private void validatePaymentRate(ExtendedDataEntity dataEntity) {
        DynamicObject settleBill = dataEntity.getDataEntity();
        DynamicObjectCollection itemEntry = settleBill.getDynamicObjectCollection("itementry");
        DynamicObjectCollection modelEntry = settleBill.getDynamicObjectCollection("listmodelentry");
        DynamicObjectCollection detailEntry = settleBill.getDynamicObjectCollection("payitemdetailentry");
        for (int rowIndex = 0; rowIndex < itemEntry.size(); ++rowIndex) {
            DynamicObject item;
            DynamicObject rate;
            StringBuilder listStringBuilder = new StringBuilder();
            StringBuilder detailStringBuilder = new StringBuilder();
            Object payItemId = ((DynamicObject)itemEntry.get(rowIndex)).getPkValue();
            block1: for (DynamicObject model : modelEntry) {
                for (DynamicObject list : model.getDynamicObjectCollection("listentry")) {
                    if (!payItemId.equals(list.getLong("payitemid"))) continue;
                    listStringBuilder.append(rowIndex + 1).append("\uff0c");
                    break block1;
                }
            }
            for (DynamicObject detail : detailEntry) {
                if (!payItemId.equals(detail.getLong("itemid"))) continue;
                detailStringBuilder.append(rowIndex + 1).append("\uff0c");
                break;
            }
            if (listStringBuilder.length() != 0 || detailStringBuilder.length() != 0 || (rate = (item = (DynamicObject)itemEntry.get(rowIndex)).getDynamicObject("itemrate")) != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u652f\u4ed8\u9879\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u201c\u7a0e\u7387\u201d", (String)"OutContractSettleValidator_5", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), rowIndex + 1));
            break;
        }
    }
}

