/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class AbstractAccountSetEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    private static String AccountOrg = "accountorg";
    private static final String Project = "project";

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty accountorgProperty = dataEntity.getDynamicObjectType().getProperty(AccountOrg);
        if (accountorgProperty != null) {
            dataEntity.getDataEntityState().setBizChanged(accountorgProperty.getOrdinal(), false);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String entityId = this.getView().getEntityId();
        AccountOrg = "pmct_applymentpay".equals(entityId) ? "costorg" : "accountorg";
        Object accountOrg = this.getModel().getValue(AccountOrg);
        if (accountOrg == null) {
            BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
            if (BillOperationStatus.ADDNEW.getValue() == billShowParameter.getBillStatus().getValue()) {
                this.setUpAccountingOrg();
            } else {
                long accountOrgId = 0L;
                DynamicObject project = (DynamicObject)this.getModel().getValue(Project);
                if (project != null) {
                    accountOrgId = this.getAccountOrgByProject(Long.parseLong(project.getPkValue().toString()));
                }
                if (accountOrgId == 0L) {
                    this.setUpAccountingOrg();
                } else {
                    this.getModel().setValue(AccountOrg, (Object)accountOrgId);
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String entityId = this.getView().getEntityId();
        AccountOrg = "pmct_applymentpay".equals(entityId) ? "costorg" : "accountorg";
        BasedataEdit accountOrg = (BasedataEdit)this.getControl(AccountOrg);
        if (accountOrg != null) {
            accountOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)AccountOrg, (CharSequence)key)) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            if (hashPermOrgUnits.size() == 0) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                ArrayList accountPermOrgs = new ArrayList(16);
                hashPermOrgUnits.forEach(orgId -> {
                    Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    if (mapOrg != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
                        accountPermOrgs.add(Long.parseLong(mapOrg.get("id").toString()));
                    }
                });
                if (accountPermOrgs.size() > 0) {
                    String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
                    List accountOrgs = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, accountPermOrgs, (String)"10");
                    if (accountOrgs.size() == 0) {
                        qFilters.add(new QFilter("id", "=", (Object)0L));
                    } else {
                        List allOrgIds = OrgTreeUtils.getParentByOrgIds((List)accountOrgs, (String)"10");
                        if (allOrgIds.size() > 0) {
                            qFilters.add(new QFilter("id", "in", (Object)allOrgIds));
                        }
                    }
                } else {
                    qFilters.add(new QFilter("id", "=", (Object)0L));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if (Project.equals(propertyName)) {
            this.onchangeProject();
        } else if (StringUtils.equals((CharSequence)AccountOrg, (CharSequence)propertyName) && args.getChangeSet()[0].getNewValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u6e05\u9664\u3002", (String)"AbstractAccountSetEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(AccountOrg, args.getChangeSet()[0].getOldValue());
        }
    }

    private void setUpAccountingOrg() {
        DynamicObject org;
        Map mapOrg;
        if (this.getModel().getValue("org") != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)Long.parseLong((org = (DynamicObject)this.getModel().getValue("org")).getPkValue().toString()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
            this.getModel().setValue(AccountOrg, mapOrg.get("id"));
        }
    }

    private void onchangeProject() {
        if (this.getModel().getValue(Project) == null) {
            this.setUpAccountingOrg();
        } else {
            DynamicObject project = (DynamicObject)this.getModel().getValue(Project);
            long accountOrgId = this.getAccountOrgByProject(Long.parseLong(project.getPkValue().toString()));
            this.getModel().beginInit();
            this.getModel().setValue(AccountOrg, (Object)accountOrgId);
            this.getView().updateView(AccountOrg);
            this.getModel().endInit();
        }
    }

    protected long getAccountOrgByProject(long projectId) {
        QFilter approvalFilter = new QFilter("pro", "=", (Object)projectId);
        approvalFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"accountorg", (QFilter[])new QFilter[]{approvalFilter});
        if (projectApprovals != null && projectApprovals.length > 0) {
            DynamicObject accountOrg = projectApprovals[0].getDynamicObject("accountorg");
            return accountOrg == null ? 0L : accountOrg.getLong("id");
        }
        return 0L;
    }
}

