/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.pmgt.pmbs.business.utils.AutoPushUtil;
import kd.pmgt.pmbs.common.enums.AgreementSrouceEnum;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class AgreementSignEditPlugin
extends AbstractPmctBillPlugin
implements ClickListener {
    private static final Log LOG = LogFactory.getLog(AutoPushUtil.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object agreementId = this.getView().getFormShowParameter().getCustomParam("agreementId");
        if (agreementId != null) {
            String detailadress;
            String address;
            DynamicObject agreementSign = BusinessDataServiceHelper.loadSingle((Object)agreementId, (String)"pmct_strategicagreement");
            Date signDate = agreementSign.getDate("contractdate");
            if (signDate == null) {
                signDate = new Date();
            }
            this.getModel().setValue("contractdate", (Object)signDate);
            DynamicObject partaperson = agreementSign.getDynamicObject("partaperson");
            if (partaperson != null) {
                this.getModel().setValue("partaperson", (Object)partaperson);
            }
            this.getModel().setValue("contractdate", (Object)signDate);
            String signpartbinfo = agreementSign.get("signpartbinfo").toString();
            if (signpartbinfo != null) {
                this.getModel().setValue("signpartbinfo", (Object)signpartbinfo);
            }
            if ((address = agreementSign.get("address").toString()) != null) {
                this.getModel().setValue("address", (Object)address);
            }
            if ((detailadress = agreementSign.get("detailadress").toString()) != null) {
                this.getModel().setValue("detailadress", (Object)detailadress);
            }
            DynamicObjectCollection attachmentSignField = (DynamicObjectCollection)this.getModel().getValue("attachmentfield");
            DynamicObjectCollection attachmentField = agreementSign.getDynamicObjectCollection("attachmentfield");
            attachmentSignField.clear();
            DynamicObjectType DT = attachmentSignField.getDynamicObjectType();
            if (attachmentField.size() > 0) {
                for (DynamicObject attachmentSign : attachmentField) {
                    DynamicObject attachmentObject = new DynamicObject(DT);
                    attachmentObject.set("fbasedataid", attachmentSign.get("fbasedataid"));
                    attachmentObject.set("fbasedataid.id", attachmentSign.get("fbasedataid_id"));
                    attachmentSignField.add((Object)attachmentObject);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"okbtn", (CharSequence)operateKey)) {
            Date signDate = (Date)this.getModel().getValue("contractdate");
            if (signDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgreementSignEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date validDate = (Date)this.getModel().getValue("agreementvaliddate");
            if (validDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgreementSignEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date expireDate = (Date)this.getModel().getValue("agreementexpiredate");
            if (expireDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgreementSignEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                validDate = df.parse(df.format(validDate));
                expireDate = df.parse(df.format(expireDate));
                if (validDate.compareTo(expireDate) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u6709\u6548\u5f00\u59cb\u65e5\u671f\u3002", (String)"AgreementSignEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"docancel", (CharSequence)operateKey)) {
            this.getView().invokeOperation("close");
        } else if (StringUtils.equals((CharSequence)"okbtn", (CharSequence)operateKey)) {
            String address;
            String signpartbinfo;
            DynamicObject partaperson;
            Object agreementId = this.getView().getFormShowParameter().getCustomParam("agreementId");
            DynamicObject strategicAgreement = BusinessDataServiceHelper.loadSingle((Object)agreementId, (String)"pmct_strategicagreement");
            Date date = new Date();
            Date signDate = (Date)this.getModel().getValue("contractdate");
            if (signDate == null) {
                strategicAgreement.set("contractdate", (Object)date);
            } else {
                strategicAgreement.set("contractdate", (Object)signDate);
            }
            Date validDate = (Date)this.getModel().getValue("agreementvaliddate");
            Date expireDate = (Date)this.getModel().getValue("agreementexpiredate");
            strategicAgreement.set("agreementvaliddate", (Object)validDate);
            strategicAgreement.set("agreementexpiredate", (Object)expireDate);
            String detailadress = this.getModel().getValue("detailadress").toString();
            if (detailadress != null) {
                strategicAgreement.set("detailadress", (Object)detailadress);
            }
            if ((partaperson = (DynamicObject)this.getModel().getValue("partaperson")) != null) {
                strategicAgreement.set("partaperson", (Object)partaperson);
            }
            if ((signpartbinfo = this.getModel().getValue("signpartbinfo").toString()) != null) {
                strategicAgreement.set("signpartbinfo", (Object)signpartbinfo);
            }
            if ((address = this.getModel().getValue("address").toString()) != null) {
                strategicAgreement.set("address", (Object)address);
            }
            DynamicObjectCollection attachmentSignField = (DynamicObjectCollection)this.getModel().getValue("attachmentfield");
            DynamicObjectCollection attachmentField = strategicAgreement.getDynamicObjectCollection("attachmentfield");
            attachmentField.clear();
            DynamicObjectType DT = attachmentField.getDynamicObjectType();
            if (attachmentSignField.size() > 0) {
                for (DynamicObject attachmentSign : attachmentSignField) {
                    DynamicObject attachment = (DynamicObject)attachmentSign.get("fbasedataid");
                    if (attachment == null) continue;
                    attachment = this.PersistAttachment(attachment);
                    DynamicObject attachmentObject = new DynamicObject(DT);
                    attachmentObject.set("fbasedataid", (Object)attachment);
                    attachmentObject.set("fbasedataid.id", attachmentSign.get("fbasedataid_id"));
                    attachmentField.add((Object)attachmentSign);
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String billStatus = (String)strategicAgreement.get("billstatus");
            String agreementStatus = (String)strategicAgreement.get("agreementstate");
            try {
                Date agreementValidDate = df.parse(df.format(strategicAgreement.getDate("agreementvaliddate")));
                Date endDate = strategicAgreement.getBoolean("renew") ? df.parse(df.format(strategicAgreement.getDate("agreementdelaydate"))) : df.parse(df.format(strategicAgreement.getDate("agreementexpiredate")));
                Date auditTime = df.parse(df.format(strategicAgreement.getDate("auditdate")));
                if (StatusEnum.CHECKED.getValue().equals(billStatus) && AgreementStatusEnum.APPROVAL.getValue().equals(agreementStatus)) {
                    if (auditTime.compareTo(agreementValidDate) >= 0 && auditTime.compareTo(endDate) <= 0) {
                        strategicAgreement.set("agreementstate", (Object)AgreementStatusEnum.EFFECTING.getValue());
                    } else if (auditTime.compareTo(agreementValidDate) < 0) {
                        strategicAgreement.set("agreementstate", (Object)AgreementStatusEnum.UNEFFECT.getValue());
                    } else {
                        strategicAgreement.set("agreementstate", (Object)AgreementStatusEnum.EXPIRE.getValue());
                    }
                    strategicAgreement.set("issign", (Object)true);
                    BigDecimal version = (BigDecimal)strategicAgreement.get("version");
                    if (null == version || BigDecimal.ZERO.compareTo(version) == 0) {
                        strategicAgreement.set("version", (Object)new BigDecimal(1));
                    }
                    strategicAgreement.set("islatest", (Object)Boolean.TRUE);
                    DynamicObject previousBillF7 = strategicAgreement.getDynamicObject("previousbill");
                    if (null != previousBillF7) {
                        DynamicObject previousBill = BusinessDataServiceHelper.loadSingle((Object)previousBillF7.getPkValue(), (String)"pmct_strategicagreement");
                        previousBill.set("islatest", (Object)Boolean.FALSE);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{previousBill});
                        String agreementBillFrom = strategicAgreement.getString("agreementbillfrom");
                        if (AgreementSrouceEnum.CHANGED.getValue().equals(agreementBillFrom)) {
                            DynamicObject[] outContracts;
                            QFilter qFilter = new QFilter("strategicagreement", "=", previousBillF7.getPkValue());
                            for (DynamicObject contract : outContracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"strategicagreement", (QFilter[])new QFilter[]{qFilter})) {
                                contract.set("strategicagreement", strategicAgreement.getPkValue());
                            }
                            if (outContracts.length > 0) {
                                SaveServiceHelper.save((DynamicObject[])outContracts);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{strategicAgreement});
            this.getView().returnDataToParent((Object)"okbtn");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private DynamicObject PersistAttachment(DynamicObject attachment) {
        attachment = BusinessDataServiceHelper.loadSingle((Object)attachment.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_attachment"));
        String url = attachment.getString("url");
        String name = attachment.getString("name");
        String tempFile = attachment.getString("tempfile");
        if (tempFile.equals("0")) {
            InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
            FileItem fileItem = new FileItem(name, AgreementSignEditPlugin.generateAttPath(name), inputStream);
            fileItem.setCreateNewFileWhenExists(true);
            String fullUrl = FileServiceFactory.getAttachmentFileService().upload(fileItem);
            attachment.set("url", (Object)fullUrl);
            attachment.set("tempfile", (Object)1);
            attachment.set("pageid", null);
            SaveServiceHelper.update((DynamicObject)attachment);
        }
        return attachment;
    }

    public static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)"pmct_strategicagreement", (String)fileName);
    }
}

