/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContMultiCurrencyControlPlugin
extends AbstractPmctBillPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean isMultiCurrency = this.getModel().getDataEntity().getBoolean("ismulticurrency");
        this.getView().setVisible(isMultiCurrency, new String[]{"multicurrencyinfo", "stdcurrencyinfo"});
        this.setCurrencyFlexSpace(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"contract", (CharSequence)propName)) {
            this.carrayContMultiCurrencyInfoToThisBill();
        }
    }

    private void carrayContMultiCurrencyInfoToThisBill() {
        DynamicObject contract = this.getModel().getDataEntity().getDynamicObject("contract");
        if (contract != null) {
            DynamicObject currency;
            DynamicObject stdCurrency = contract.getDynamicObject("stdcurrency");
            if (stdCurrency != null) {
                this.getModel().setValue("stdcurrency", stdCurrency.getPkValue());
            }
            if ((currency = contract.getDynamicObject("currency")) != null) {
                this.getModel().setValue("currency", currency.getPkValue());
            }
            if (contract.getBoolean("ismulticurrency")) {
                DynamicObject exrateTable = contract.getDynamicObject("exratetable");
                Date exchangeDate = contract.getDate("exchangedate");
                BigDecimal exchangeRate = contract.getBigDecimal("exchangerate");
                this.getModel().setValue("ismulticurrency", (Object)Boolean.TRUE);
                this.getModel().setValue("exratetable", exrateTable.getPkValue());
                this.getModel().setValue("exchangedate", (Object)exchangeDate);
                this.getModel().setValue("exchangerate", (Object)exchangeRate);
                this.getView().setVisible(Boolean.TRUE, new String[]{"multicurrencyinfo", "stdcurrencyinfo"});
            } else {
                this.getModel().setValue("ismulticurrency", (Object)Boolean.FALSE);
                this.getModel().setValue("exratetable", null);
                this.getModel().setValue("exchangedate", null);
                this.getModel().setValue("exchangerate", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"multicurrencyinfo", "stdcurrencyinfo"});
            }
        } else {
            this.getModel().setValue("ismulticurrency", (Object)Boolean.FALSE);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("exratetable", null);
            this.getModel().setValue("exchangedate", null);
            this.getModel().setValue("exchangerate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"multicurrencyinfo", "stdcurrencyinfo"});
        }
    }

    private void setCurrencyFlexSpace(DynamicObject newContract) {
        boolean isMultiCurrency = this.getModel().getDataEntity().getBoolean("ismulticurrency");
        if (newContract != null) {
            isMultiCurrency = newContract.getBoolean("ismulticurrency");
        }
        if (isMultiCurrency) {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
            ctrl = new HashMap();
            marginMap = new HashMap();
            styleMap = new HashMap();
            marginMap.put("l", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("stdcurrencyinfo", ctrl);
        } else {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "0px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
        }
    }
}

