/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.common.utils.RichEditorUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ContRichTextBillEditPlugin
extends AbstractPmctFormPlugin {
    private static final String CTL_RICHTEMPLATE = "richtemplate";
    private static final String CTL_BILLID = "billId";
    private static final String CTL_BILLTYPENAME = "billtypename";
    private static final String CTL_RICHTEXT = "richtext";
    private static final String CTL_TEMPLATETEXT = "templatetext";
    private static final String RICHTEXTEDITOR = "richtexteditor";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject richTemplate = this.getRichTemplate();
        if (richTemplate != null) {
            this.getModel().setValue(CTL_RICHTEMPLATE, richTemplate.getPkValue());
            String billId = this.getModel().getDataEntity().getString(CTL_BILLID);
            String billTypeName = this.getModel().getDataEntity().getString(CTL_BILLTYPENAME);
            DynamicObject contTemplate = this.getModel().getDataEntity().getDynamicObject(CTL_RICHTEMPLATE);
            if (contTemplate != null) {
                String templateText = contTemplate.getString(CTL_TEMPLATETEXT);
                this.initRichText(templateText, billId, billTypeName);
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
            richTextEditor.setText(this.getModel().getDataEntity().getString(CTL_RICHTEXT));
        }
    }

    private DynamicObject getRichTemplate() {
        DynamicObject contAtt;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object billId = showParameter.getCustomParam("billid");
        String billTypeName = (String)showParameter.getCustomParam(CTL_BILLTYPENAME);
        Object contractTypeId = showParameter.getCustomParam("contracttypeid");
        this.getModel().setValue("billid", billId);
        this.getModel().setValue(CTL_BILLTYPENAME, (Object)billTypeName);
        String templateType = "";
        templateType = StringUtils.equals((CharSequence)"pmct_incontract", (CharSequence)billTypeName) ? "IN" : "OUT";
        DynamicObject contType = BusinessDataServiceHelper.loadSingle((Object)contractTypeId, (String)"pmct_conttype");
        if (contType != null && (contAtt = contType.getDynamicObject("contattr")) != null) {
            QFilter contArrFilter = new QFilter("group", "=", contAtt.getPkValue());
            QFilter effectiveFilter = new QFilter("effective", "=", (Object)"1");
            QFilter templateTypeFilter = new QFilter("conttemplatetype", "=", (Object)templateType);
            QFilter statusFilter = new QFilter("status", "=", (Object)"A");
            DynamicObject contTemplate = BusinessDataServiceHelper.loadSingle((String)"pmct_conttemplate", (String)"id,modifytime,templatetext", (QFilter[])new QFilter[]{contArrFilter, effectiveFilter, templateTypeFilter, statusFilter});
            return contTemplate;
        }
        return null;
    }

    private void initRichText(String templateText, String billId, String billTypeName) {
        String newDoc = "";
        if (StringUtils.isNotBlank((CharSequence)templateText)) {
            Document document = Jsoup.parse((String)templateText);
            newDoc = RichEditorUtils.wirteListTableData((Document)document, (String)billId);
            newDoc = RichEditorUtils.wirteTableData((Document)document, (String)billId, (String)billTypeName);
            newDoc = RichEditorUtils.wirteFieldData((Document)document, (String)billId, (String)billTypeName);
        }
        this.getModel().setValue(CTL_RICHTEXT, (Object)newDoc);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (isFromDb) {
            String billStatus = (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
                DynamicObject richTemplate = this.getRichTemplate();
                if (richTemplate != null) {
                    this.getModel().setValue(CTL_RICHTEMPLATE, richTemplate.getPkValue());
                    this.updateRichText();
                    this.saveObj();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u4e0b\u6ca1\u6709\u5bf9\u5e94\u7684\u6709\u6548\u7248\u672c\u7684\u5408\u540c\u6a21\u677f\uff0c\u6240\u4ee5\u53ea\u80fd\u663e\u793a\u4e0a\u4e00\u6b21\u4fdd\u5b58\u7684\u6587\u672c\u5185\u5bb9\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u542f\u7528\u6709\u6548\u7248\u672c\u7684\u6a21\u677f\u3002", (String)"ContRichTextBillEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
                    richTextEditor.setText(this.getModel().getDataEntity().getString(CTL_RICHTEXT));
                }
            } else {
                this.updateRichText();
                this.saveObj();
            }
        } else {
            this.getView().invokeOperation("save");
        }
    }

    private void saveObj() {
        DynamicObject thisModel = this.getModel().getDataEntity();
        String richtext = thisModel.getString(CTL_RICHTEXT);
        DynamicObject contTemplate = thisModel.getDynamicObject(CTL_RICHTEMPLATE);
        DynamicObject contTextBill = BusinessDataServiceHelper.loadSingle((Object)thisModel.getPkValue(), (String)"pmct_contrichtextbill");
        contTextBill.set(CTL_RICHTEXT, (Object)richtext);
        if (contTemplate != null) {
            contTextBill.set(CTL_RICHTEMPLATE, contTemplate.getPkValue());
        } else {
            contTextBill.set(CTL_RICHTEMPLATE, (Object)0);
        }
        contTextBill.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contTextBill});
    }

    private void updateRichText() {
        String billId = this.getModel().getDataEntity().getString(CTL_BILLID);
        String billTypeName = this.getModel().getDataEntity().getString(CTL_BILLTYPENAME);
        DynamicObject contTemplate = this.getModel().getDataEntity().getDynamicObject(CTL_RICHTEMPLATE);
        if (contTemplate != null) {
            String templateText = contTemplate.getString(CTL_TEMPLATETEXT);
            this.initRichText(templateText, billId, billTypeName);
        }
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
        richTextEditor.setText(this.getModel().getDataEntity().getString(CTL_RICHTEXT));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey())) {
            DynamicObject richTemplate = this.getModel().getDataEntity().getDynamicObject(CTL_RICHTEMPLATE);
            Object pk = this.getModel().getDataEntity().getPkValue();
            if (richTemplate != null) {
                Object richTemplatePk = richTemplate.getPkValue();
                boolean existOne = QueryServiceHelper.exists((String)"pmct_contrichtextbill", (QFilter[])new QFilter[]{new QFilter(CTL_RICHTEMPLATE, "=", richTemplatePk), new QFilter("billid", "=", this.getModel().getValue("billid")), new QFilter("id", "!=", pk)});
                if (existOne) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e00\u5f20\u76f8\u540c\u6a21\u677f\u7c7b\u578b\u7684\u5185\u5bb9\u3002", (String)"ContRichTextBillEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITOR);
            String text = richTextEditor.getText();
            this.getModel().setValue(CTL_RICHTEXT, (Object)text);
        }
    }
}

