/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ContractClaimInvoicePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invoice = (BasedataEdit)this.getView().getControl("invoice");
        invoice.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_ininvoice", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        List invoiceIds;
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.get("invoiceIds") != null && (invoiceIds = (List)params.get("invoiceIds")).size() > 0) {
            DynamicObject[] invoices;
            DynamicObjectCollection claimEntry = this.getModel().getEntryEntity("claimentry");
            claimEntry.clear();
            DynamicObjectType dt = claimEntry.getDynamicObjectType();
            QFilter qFilter = new QFilter("id", "in", (Object)invoiceIds);
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoicef7", (String)String.join((CharSequence)",", "number", "invoicecode", "invoiceno", "invoicetypeid", "totaloftaxamount", "totalamount", "totaltax", "currency"), (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject item = new DynamicObject(dt);
                item.set("invoice", (Object)invoice);
                item.set("amount", (Object)invoice.getBigDecimal("totalamount"));
                item.set("taxofamt", (Object)invoice.getBigDecimal("totaltax"));
                item.set("totalamount", (Object)invoice.getBigDecimal("totaloftaxamount"));
                item.set("currency", (Object)invoice.getDynamicObject("currency"));
                claimEntry.add((Object)item);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("contract".equals(key)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            DynamicObject selectProject = null;
            List orgList = new ArrayList();
            if (params.get("selectProject") != null) {
                selectProject = (DynamicObject)params.get("selectProject");
            }
            if (params.get("orgList") != null) {
                orgList = (List)params.get("orgList");
            }
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)true, (int)2);
            parameter.setShowUsed(true);
            parameter.setShowApproved(true);
            parameter.setMultiSelect(false);
            QFilter contractFilter = ProjectPermissionHelper.getPermContractFilter(orgList, (boolean)false, (DynamicObject)selectProject, (String)"pmct_ininvoice", (String)key);
            parameter.getListFilterParameter().getQFilters().add(contractFilter);
        } else if ("supplier".equals(key)) {
            EntryGrid claimEntryControl = (EntryGrid)this.getView().getControl("claimentry");
            int[] selectRows = claimEntryControl.getSelectRows();
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract", selectRows[0]);
            if (contract != null) {
                ArrayList<Object> contSupplier = new ArrayList<Object>();
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                DynamicObject partB = contract.getDynamicObject("partb");
                DynamicObjectCollection otherPart = contract.getDynamicObjectCollection("otherpart");
                contSupplier.add(partB.getPkValue());
                if (otherPart.size() > 0) {
                    for (DynamicObject other : otherPart) {
                        contSupplier.add(other.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
                QFilter contPartBFilter = new QFilter("id", "in", contSupplier);
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(contPartBFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal totalUseAmt;
        BigDecimal totalAmount;
        String propertyName = e.getProperty().getName();
        EntryGrid claimEntryControl = (EntryGrid)this.getView().getControl("claimentry");
        int[] selectRows = claimEntryControl.getSelectRows();
        if ("totaluseamt".equals(propertyName) && (totalAmount = (BigDecimal)this.getModel().getValue("totalamount", selectRows[0])).compareTo(totalUseAmt = (BigDecimal)this.getModel().getValue("totaluseamt", selectRows[0])) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7d2f\u8ba1\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u51fa\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"ContractClaimInvoicePlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("totaluseamt", (Object)BigDecimal.ZERO, selectRows[0]);
            this.getView().updateView("totaluseamt", selectRows[0]);
            this.getModel().endInit();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("conClaimInvoice".equals(callBackId) && result.getValue() == MessageBoxResult.Yes.getValue()) {
            this.executeClaim();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchpadding".equals(operateKey)) {
            EntryGrid claimEntryControl = (EntryGrid)this.getView().getControl("claimentry");
            int[] selectRows = claimEntryControl.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractClaimInvoicePlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("contract", selectRows[0]) != null) {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract", selectRows[0]);
                DynamicObjectCollection claimEntry = this.getModel().getEntryEntity("claimentry");
                if (claimEntry.size() > 0) {
                    for (int i = 0; i < claimEntry.size(); ++i) {
                        DynamicObject entry = (DynamicObject)claimEntry.get(i);
                        if (i == selectRows[0] || entry.getDynamicObject("contract") != null) continue;
                        this.getModel().setValue("contract", (Object)contract, i);
                    }
                }
            }
        } else if ("confirm".equals(operateKey)) {
            DynamicObjectCollection claimEntry = this.getModel().getEntryEntity("claimentry");
            if (claimEntry == null || claimEntry.size() == 0) {
                return;
            }
            boolean checkResult = true;
            for (int row = 0; row < claimEntry.size(); ++row) {
                Object contract = this.getModel().getValue("contract", row);
                Object supplier = this.getModel().getValue("supplier", row);
                if (contract != null && supplier != null) continue;
                checkResult = false;
                break;
            }
            if (!checkResult) {
                return;
            }
            StringBuffer errTip = new StringBuffer();
            String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
            if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam) || InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                Set supplierIds;
                HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(16);
                HashMap<Long, DynamicObject> supplierMap = new HashMap<Long, DynamicObject>(16);
                Set invoiceIds = claimEntry.stream().filter(o -> o.getDynamicObject("invoice") != null).map(o -> Long.parseLong(o.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet());
                if (invoiceIds.size() > 0) {
                    DynamicObject[] invoices;
                    for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((Object[])invoiceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"))) {
                        invoiceMap.put(Long.parseLong(invoice.getPkValue().toString()), invoice);
                    }
                }
                if ((supplierIds = claimEntry.stream().filter(o -> o.getDynamicObject("supplier") != null).map(o -> Long.parseLong(o.getDynamicObject("supplier").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
                    DynamicObject[] suppliers;
                    for (DynamicObject supplier : suppliers = BusinessDataServiceHelper.load((Object[])supplierIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_supplier"))) {
                        supplierMap.put(Long.parseLong(supplier.getPkValue().toString()), supplier);
                    }
                }
                if (invoiceMap.isEmpty() || supplierMap.isEmpty()) {
                    return;
                }
                for (int row = 0; row < claimEntry.size(); ++row) {
                    this.checkSupplier(row, errTip, invoiceMap, supplierMap);
                }
                if (!StringUtil.isEmpty((String)errTip.toString())) {
                    if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                        this.getView().showErrorNotification(errTip.toString());
                    } else if (InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                        ConfirmCallBackListener opCallback = new ConfirmCallBackListener("conClaimInvoice", (IFormPlugin)this);
                        this.getView().showConfirm(errTip.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, opCallback);
                    }
                } else {
                    this.executeClaim();
                }
            } else {
                this.executeClaim();
            }
        }
    }

    private void executeClaim() {
        DynamicObjectCollection claimEntry = this.getModel().getEntryEntity("claimentry");
        HashMap<Object, DynamicObject> contractByIdMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject entry : claimEntry) {
            DynamicObject invoice = entry.getDynamicObject("invoice");
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice");
            if (entry.getDynamicObject("contract") != null) {
                invoice.set("contract", (Object)entry.getDynamicObject("contract"));
                invoice.set("project", (Object)entry.getDynamicObject("contract").getDynamicObject("project"));
            }
            invoice.set("contpartb", (Object)entry.getDynamicObject("supplier"));
            invoice.set("isclaimed", (Object)Boolean.TRUE);
            invoice.set("totaluseamt", (Object)entry.getBigDecimal("totaluseamt"));
            invoice.set("availableamt", (Object)invoice.getBigDecimal("totaloftaxamount").subtract(entry.getBigDecimal("totaluseamt")));
            SaveServiceHelper.update((DynamicObject)invoice);
            DynamicObject contract = (DynamicObject)contractByIdMap.get(entry.getDynamicObject("contract").getPkValue());
            if (contract == null) {
                contract = entry.getDynamicObject("contract");
                contractByIdMap.put(entry.getDynamicObject("contract").getPkValue(), contract);
            }
            ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)invoice, (String)"claim");
        }
        this.getView().close();
    }

    private void checkSupplier(int row, StringBuffer errTip, Map<Long, DynamicObject> invoiceMap, Map<Long, DynamicObject> supplierMap) {
        boolean checkResult = true;
        DynamicObject invoice = (DynamicObject)this.getModel().getValue("invoice", row);
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier", row);
        if (invoice != null && supplier != null) {
            supplier = supplierMap.get(Long.parseLong(supplier.getPkValue().toString()));
            invoice = invoiceMap.get(Long.parseLong(invoice.getPkValue().toString()));
            DynamicObject bizPartner = supplier.getDynamicObject("bizpartner");
            String invoiceNo = invoice.getString("invoiceno");
            String invoiceCode = invoice.getString("invoicecode");
            if (bizPartner == null && invoice.get("seller") != null || bizPartner != null && invoice.get("seller") == null) {
                checkResult = false;
            } else if (bizPartner != null && invoice.get("seller") != null) {
                DynamicObject seller = (DynamicObject)invoice.get("seller");
                long sellerId = Long.parseLong(seller.getPkValue().toString());
                long bizPartnerId = Long.parseLong(bizPartner.getPkValue().toString());
                if (bizPartnerId != sellerId) {
                    checkResult = false;
                }
            }
            if (!checkResult) {
                if (!StringUtil.isEmpty((String)errTip.toString())) {
                    errTip.append("\r\n");
                }
                errTip.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"ContractClaimInvoicePlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), row + 1, invoiceNo));
                if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    errTip.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%2$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%3$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"ContractClaimInvoicePlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), row + 1, invoiceCode, invoiceNo));
                }
            }
        }
    }
}

