/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.FieldEdit;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractCurrencyEditPlugin
extends AbstractPmctBillPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"currency", (CharSequence)propName)) {
            this.setExchangeRate();
        } else if (StringUtils.equals((CharSequence)"stdcurrency", (CharSequence)propName)) {
            this.setExchangeRate();
        } else if (StringUtils.equals((CharSequence)"exratetable", (CharSequence)propName)) {
            this.setExchangeRate();
        } else if (StringUtils.equals((CharSequence)"exchangedate", (CharSequence)propName)) {
            this.setExchangeRate();
        } else if (!StringUtils.equals((CharSequence)"bizaccountorg", (CharSequence)propName)) {
            if (StringUtils.equals((CharSequence)"ismulticurrency", (CharSequence)propName)) {
                this.onIsMultiCurrencyChange();
                this.setExchangeRate();
            } else if (StringUtils.equals((CharSequence)this.getCompanyOrgField(), (CharSequence)propName)) {
                DynamicObject currency;
                DynamicObject fiAccountOrg = this.getModel().getDataEntity().getDynamicObject(this.getCompanyOrgField());
                if (fiAccountOrg == null) {
                    fiAccountOrg = this.getModel().getDataEntity().getDynamicObject("org");
                }
                if (fiAccountOrg != null && (currency = CurrencyHelper.getCurrency((Long)((Long)fiAccountOrg.getPkValue()))) != null) {
                    boolean isMutiCurrency = this.getModel().getDataEntity().getBoolean("ismulticurrency");
                    if (isMutiCurrency) {
                        this.getModel().setValue("stdcurrency", (Object)currency);
                    } else {
                        this.getModel().setValue("stdcurrency", (Object)currency);
                        this.getModel().setValue("currency", (Object)currency);
                    }
                }
            }
        }
    }

    protected String getCompanyOrgField() {
        return "fiaccountorg";
    }

    private void onIsMultiCurrencyChange() {
        this.setMultiCurrencyMustInput();
        boolean isMultiCurrency = (Boolean)this.getModel().getValue("ismulticurrency");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("bizaccountorg");
        if (org == null) {
            org = (DynamicObject)this.getModel().getValue("org");
        }
        if (org == null) {
            return;
        }
        if (isMultiCurrency) {
            DynamicObject exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
            if (null != exRateTable) {
                this.getModel().setValue("exratetable", exRateTable.getPkValue());
                this.getModel().setValue("exchangedate", (Object)new Date());
            }
        } else {
            DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
            this.getModel().setValue(this.getCurrency(), (Object)currency);
        }
    }

    private void setMultiCurrencyMustInput() {
        boolean isMultiCurrency = (Boolean)this.getModel().getValue("ismulticurrency");
        ((FieldEdit)this.getControl("exratetable")).setMustInput(isMultiCurrency);
        ((FieldEdit)this.getControl("currency")).setMustInput(isMultiCurrency);
        ((FieldEdit)this.getControl("exchangerate")).setMustInput(isMultiCurrency);
        ((FieldEdit)this.getControl("exchangedate")).setMustInput(isMultiCurrency);
    }

    private void setExchangeRate() {
        BigDecimal exchangeRate = this.getExchangeRate();
        if (BigDecimal.ZERO.compareTo(exchangeRate) == 0) {
            return;
        }
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
    }

    private BigDecimal getExchangeRate() {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObject stdCurrency = dynamicObject.getDynamicObject("stdcurrency");
        DynamicObject exrateTable = dynamicObject.getDynamicObject("exratetable");
        DynamicObject currency = dynamicObject.getDynamicObject("currency");
        Date exchangeDate = dynamicObject.getDate("exchangedate");
        if (stdCurrency == null || exrateTable == null || currency == null || exchangeDate == null) {
            return exchangeRate;
        }
        exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exrateTable.getLong("id"), (Date)exchangeDate);
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ZERO;
        }
        return exchangeRate;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMultiCurrencyMustInput();
    }
}

