/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.business.helper.ContractSettleHelper;
import kd.pmgt.pmct.common.enums.ReferBillTypeEnum;
import kd.pmgt.pmct.common.utils.SettleUpdateAmtUtils;

public class ContractSettleDetailEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ContractSettleDetailEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        DynamicObject contract = this.getModel().getDataEntity().getDynamicObject("contract");
        if ("contract".equals(name) || "period".equals(name)) {
            DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
            if (StringUtils.equals((CharSequence)"period", (CharSequence)name)) {
                int rowCount = this.getModel().getEntryRowCount("payitemdetailentry");
                int[] selectRows = new int[rowCount];
                for (int i = 0; i < rowCount; ++i) {
                    selectRows[i] = i;
                }
                this.updateItemEntry(selectRows);
            }
            if (StringUtils.equals((CharSequence)"contract", (CharSequence)name)) {
                this.getModel().setValue("showcurrency", (Object)"A");
            }
            if (contract == null || period == null) {
                this.getModel().deleteEntryData("payitemdetailentry");
                if (contract == null) {
                    this.clearAllAmtWhenDelContract();
                    this.getModel().setValue("isonlist", (Object)false);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"listingpanelap"});
                    this.getView().updateView("listingpanelap");
                }
                return;
            }
            this.updateItemDetailEntry();
            SettleUpdateAmtUtils.calAllTypeAmount((IDataModel)this.getModel());
            this.changeShowAndHide(contract);
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        } else if ("contpartb".equals(name)) {
            DynamicObject contpartb = this.getModel().getDataEntity().getDynamicObject("contpartb");
            if (contpartb == null) {
                this.clearAllAmtWhenDelContract();
                return;
            }
            SettleUpdateAmtUtils.calAllTypeAmount((IDataModel)this.getModel());
        } else if ("ismulticontract".equals(name)) {
            if (contract != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u6e05\u7a7a\u5df2\u9009\u62e9\u7684\u5408\u540c\u548c\u5f55\u5165\u7684\u7ed3\u7b97\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractSettleDetailEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ismulticontract"));
            } else {
                this.changeShowAndHide(null);
            }
        } else if ("project".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (contract != null) {
                if (newValue != null && !newValue.equals(contract.getDynamicObject("project"))) {
                    this.getModel().setValue("contract", null);
                } else if (newValue == null) {
                    this.getModel().setValue("contract", null);
                }
            }
        }
    }

    private void changeShowAndHide(DynamicObject contract) {
        Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        if (null == contract) {
            if (!isMultiContract.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumamountfield_org_pro"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaloftaxamt_org_pro"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleoftaxamt_org_pro"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcalofamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcalofamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleofamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcaltaxamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaltaxamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettletaxamt"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumamountfield_org_pro"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaloftaxamt_org_pro"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleoftaxamt_org_pro"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcalofamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcalofamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleofamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcaltaxamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaltaxamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettletaxamt"});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayoftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayoftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpaytaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpaytaxamt"});
        } else if (!isMultiContract.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcaloftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcaloftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettleoftaxamount"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcalofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcalofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettleofamount"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcaltaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcaltaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettletaxamount"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayoftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayoftaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayofamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpaytaxamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpaytaxamt"});
        } else {
            boolean multiPartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
            if (multiPartSettlement) {
                String multiPayType = contract.getString("multipaytype");
                if (StringUtils.equals((CharSequence)"unifiedpay", (CharSequence)multiPayType)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumamountfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaloftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleoftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettletaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumamtfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcalamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettleamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettletaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalplanpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalrealpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalplanpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalrealpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalplanpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalrealpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalplanpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalrealpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalplanpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalrealpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalplanpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdtotalrealpaytaxamt"});
                }
                if (StringUtils.equals((CharSequence)"separatepay", (CharSequence)multiPayType)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumamountfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaloftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleoftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettletaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumamtfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcalamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettleamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdsumsettletaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalplanpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalrealpayoftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalplanpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalrealpayofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalplanpaytaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"stdtotalrealpaytaxamt"});
                }
            }
        }
        this.getView().updateView("flexpanelap2");
        this.getView().updateView("flexpanelap21");
        this.getView().updateView("flexpanelap22");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            String key = messageBoxClosedEvent.getCallBackId();
            if (StringUtils.equals((CharSequence)"ismulticontract", (CharSequence)key)) {
                this.getModel().setValue("contract", null);
                Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
                if (isMultiContract.booleanValue()) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalcaloftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalnotcaloftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalsettleoftaxamount"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalsettleofamount"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"totalsettletaxamount"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumamountfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaloftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleoftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"sumsettletaxamt"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcaloftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcaloftaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettleoftaxamount"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettleofamount"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalsettletaxamount"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumamountfield_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaloftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleoftaxamt_org_pro"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcalofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleofamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaltaxamt"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettletaxamt"});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayoftaxamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayoftaxamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpayofamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpayofamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalplanpaytaxamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"totalrealpaytaxamt"});
                this.getView().updateView("flexpanelap2");
                this.getView().updateView("flexpanelap21");
                this.getView().updateView("flexpanelap22");
            }
        } else {
            this.getModel().beginInit();
            Boolean ismulticontract = (Boolean)this.getModel().getValue("ismulticontract");
            if (ismulticontract.booleanValue()) {
                this.getModel().setValue("ismulticontract", (Object)false);
            } else {
                this.getModel().setValue("ismulticontract", (Object)true);
            }
            this.getModel().endInit();
            this.getView().updateView("ismulticontract");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = this.getModel().getDataEntity().getDynamicObject("contract");
        this.changeShowAndHide(contract);
    }

    private void updateItemDetailEntry() {
        this.getModel().deleteEntryData("payitemdetailentry");
        IDataModel model = this.getModel();
        DynamicObject parentObject = model.getDataEntity();
        String payDirection = parentObject.getString("paydirection");
        DynamicObject period = parentObject.getDynamicObject("period");
        Date beginDate = parentObject.getDate("begindate");
        Date endDate = parentObject.getDate("enddate");
        DynamicObject contract = parentObject.getDynamicObject("contract");
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter periodFilter = new QFilter("period", "=", period.getPkValue());
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)payDirection);
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)"0");
        QFilter isNotSettleFilter = new QFilter("issettle", "=", (Object)"0");
        QFilter largeEqBeginDateFilter = new QFilter("bizdate", ">=", (Object)beginDate);
        QFilter lessEqEndDateFilter = new QFilter("bizdate", "<=", (Object)endDate);
        QFilter[] claimQfilters = new QFilter[]{contractFilter, billStatusFilter, periodFilter, payDirectionFilter, isNeedSettleFilter, isNotSettleFilter};
        QFilter[] performRecordQfilters = new QFilter[]{contractFilter, billStatusFilter, largeEqBeginDateFilter, lessEqEndDateFilter, payDirectionFilter};
        DynamicObject[] claimArr = this.getClaimArr(payDirection, claimQfilters);
        DynamicObject[] performRecordArr = this.getPerformRecordArr(payDirection, performRecordQfilters);
        ArrayList<Integer> relateDetailPayItemsSeq = new ArrayList<Integer>(10);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCollection = data.getDynamicObjectCollection("payitemdetailentry");
        DynamicObjectCollection itemEntry = data.getDynamicObjectCollection("itementry");
        entryCollection = this.setClaimArrDataToEntry(itemEntry, entryCollection, claimArr, relateDetailPayItemsSeq);
        entryCollection = this.setPerformRecordArrToEntry(itemEntry, entryCollection, performRecordArr, relateDetailPayItemsSeq);
        entryCollection.sort((o1, o2) -> {
            DynamicObject detailPayItem1 = o1.getDynamicObject("detailpayitem");
            DynamicObject detailPayItem2 = o2.getDynamicObject("detailpayitem");
            String referBillType1 = o1.getString("referbilltype");
            String referBillType2 = o2.getString("referbilltype");
            Date detailAuditDate1 = o1.getDate("detailauditdate");
            Date detailAuditDate2 = o2.getDate("detailauditdate");
            if (detailPayItem1 == null || detailPayItem2 == null) {
                return 0;
            }
            if (detailPayItem1.getPkValue().equals(detailPayItem2.getPkValue())) {
                if (StringUtils.equals((CharSequence)referBillType1, (CharSequence)referBillType2)) {
                    return detailAuditDate1.compareTo(detailAuditDate2);
                }
                return referBillType1.compareTo(referBillType2);
            }
            return -detailPayItem1.getString("number").compareTo(detailPayItem2.getString("number"));
        });
        this.getView().updateView("itementry");
        this.getView().updateView("payitemdetailentry");
    }

    private DynamicObjectCollection setPerformRecordArrToEntry(DynamicObjectCollection itemEntry, DynamicObjectCollection entryCollection, DynamicObject[] performRecordArr, List<Integer> relateDetailPayItemsSeq) {
        if (performRecordArr == null || performRecordArr.length == 0) {
            return entryCollection;
        }
        DynamicObjectType entryType = entryCollection.getDynamicObjectType();
        for (DynamicObject performRecord : performRecordArr) {
            DynamicObjectCollection performRecordEntryCol = performRecord.getDynamicObjectCollection("entryentity");
            for (DynamicObject performRecordEntry : performRecordEntryCol) {
                boolean isSettle = performRecordEntry.getBoolean("issettle");
                boolean isNeedSettle = performRecordEntry.getBoolean("isneedsettle");
                if (!isNeedSettle || isSettle) continue;
                DynamicObject entryObj = this.newEntry(performRecord, performRecordEntry, entryType);
                entryCollection.add((Object)entryObj);
                this.checkAndGeneratePayItem(entryObj, relateDetailPayItemsSeq, itemEntry);
            }
        }
        return entryCollection;
    }

    private DynamicObject newEntry(DynamicObject performRecord, DynamicObject performRecordEntry, DynamicObjectType entryType) {
        Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        DynamicObject entryObj = new DynamicObject(entryType);
        entryObj.set("detailitem", (Object)performRecordEntry.getString("record"));
        entryObj.set("detailpayitem", (Object)performRecordEntry.getDynamicObject("contpayitem"));
        entryObj.set("detailoftaxamt", (Object)performRecordEntry.getBigDecimal("amount"));
        entryObj.set("detailtaxamt", (Object)performRecordEntry.getBigDecimal("tax"));
        entryObj.set("detailamt", (Object)performRecordEntry.getBigDecimal("notaxamount"));
        entryObj.set("referbillnumber", (Object)performRecord.getString("billno"));
        entryObj.set("referbilltype", (Object)ReferBillTypeEnum.PERFORM.getValue());
        entryObj.set("detailauditdate", (Object)performRecord.getDate("auditdate"));
        entryObj.set("referbillid", performRecord.getPkValue());
        entryObj.set("referentryid", performRecordEntry.getPkValue());
        if (!isMultiContract.booleanValue()) {
            entryObj.set("detailbudgetitem", (Object)performRecordEntry.getDynamicObject("budgetitem"));
        }
        return entryObj;
    }

    private DynamicObjectCollection setClaimArrDataToEntry(DynamicObjectCollection itemEntry, DynamicObjectCollection entryCollection, DynamicObject[] claimArr, List<Integer> relateDetailPayItemsSeq) {
        if (claimArr == null || claimArr.length == 0) {
            return entryCollection;
        }
        Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        DynamicObjectType entryType = entryCollection.getDynamicObjectType();
        for (DynamicObject claim : claimArr) {
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("detailitem", (Object)claim.getString("billname"));
            entryObj.set("detailpayitem", (Object)claim.getDynamicObject("contpayitem"));
            entryObj.set("detailoftaxamt", (Object)claim.getBigDecimal("claimoftaxamount"));
            entryObj.set("detailtaxamt", (Object)claim.getBigDecimal("taxamount"));
            entryObj.set("detailamt", (Object)claim.getBigDecimal("claimamount"));
            entryObj.set("detailauditdate", (Object)claim.getDate("auditdate"));
            entryObj.set("referbillnumber", (Object)claim.getString("billno"));
            entryObj.set("referbilltype", (Object)ReferBillTypeEnum.CLAIM.getValue());
            entryObj.set("referbillid", claim.getPkValue());
            if (!isMultiContract.booleanValue()) {
                entryObj.set("detailbudgetitem", (Object)claim.getDynamicObject("budgetitem"));
            }
            entryCollection.add((Object)entryObj);
            this.checkAndGeneratePayItem(entryObj, relateDetailPayItemsSeq, itemEntry);
        }
        return entryCollection;
    }

    private DynamicObject[] getClaimArr(String payDirection, QFilter[] qFilters) {
        if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
            return BusinessDataServiceHelper.load((String)"pmct_inclaimbill", (String)"billno,billname,contract,period,contpayitem,claimoftaxamount,taxamount,taxrate,claimamount,creator,createtime,auditor,auditdate,isneedsettle,issettle,budgetitem", (QFilter[])qFilters);
        }
        return BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"billno,billname,contract,period,contpayitem,claimoftaxamount,taxamount,taxrate,claimamount,creator,createtime,auditor,auditdate,budgetitem", (QFilter[])qFilters);
    }

    private DynamicObject[] getPerformRecordArr(String payDirection, QFilter[] qFilters) {
        if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
            DynamicObject[] inPerformRecordArr = BusinessDataServiceHelper.load((String)"pmct_inperformrecords", (String)"billno,name,contract,entryentity,entryentity.record,entryentity.tax,entryentity.amount,entryentity.notaxamount,entryentity.contpayitem,creator,createtime,auditor,auditdate,entryentity.isneedsettle,entryentity.issettle,entryentity.budgetitem", (QFilter[])qFilters);
            return inPerformRecordArr;
        }
        DynamicObject[] outPerformRecordArr = BusinessDataServiceHelper.load((String)"pmct_outperformrecords", (String)"billno,name,contract,entryentity,entryentity.record,entryentity.tax,entryentity.amount,entryentity.notaxamount,entryentity.contpayitem,creator,createtime,auditor,auditdate,entryentity.isneedsettle,entryentity.issettle,entryentity.budgetitem", (QFilter[])qFilters);
        return outPerformRecordArr;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"adddetailentry", (CharSequence)operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject contract = dataEntity.getDynamicObject("contract");
            DynamicObject period = dataEntity.getDynamicObject("period");
            Date beginDate = dataEntity.getDate("begindate");
            Date endDate = dataEntity.getDate("enddate");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ContractSettleDetailEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u91cf\u671f\u95f4\u3002", (String)"ContractSettleDetailEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (beginDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u65e5\u671f\u3002", (String)"ContractSettleDetailEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u65e5\u671f\u3002", (String)"ContractSettleDetailEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmct_itemdetail_f7");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adddetail"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency != null) {
                showParameter.setCustomParam("currency", currency.getPkValue());
            }
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"deleteitemdetail", (CharSequence)operateKey)) {
            EntryGrid payItemDetailEntryGrid = (EntryGrid)this.getControl("payitemdetailentry");
            int[] selectRows = payItemDetailEntryGrid.getSelectRows();
            this.updateItemEntry(selectRows);
            DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
            for (int index = 0; index < itemEntry.size(); ++index) {
                ContractSettleHelper.checkNeedReComputeItem((int)index, (IFormView)this.getView());
            }
            SettleUpdateAmtUtils.calAllTypeAmount((IDataModel)this.getModel());
        }
    }

    private void updateItemEntry(int[] selectRows) {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection itemEntry = data.getDynamicObjectCollection("itementry");
        DynamicObjectCollection detailEntry = data.getDynamicObjectCollection("payitemdetailentry");
        ArrayList<Integer> alreadyDeleteDetailIndexList = new ArrayList<Integer>(10);
        for (int rowIndex : selectRows) {
            DynamicObject payItemDetailEntryObj = this.getModel().getEntryRowEntity("payitemdetailentry", rowIndex);
            Long itemId = payItemDetailEntryObj.getLong("itemid");
            if (itemId == null) continue;
            Iterator it = itemEntry.iterator();
            while (it.hasNext()) {
                DynamicObject payItem = (DynamicObject)it.next();
                if (!payItem.getPkValue().equals(itemId)) continue;
                int relateCount = 0;
                for (int detailIndex = 0; detailIndex < detailEntry.size(); ++detailIndex) {
                    if (alreadyDeleteDetailIndexList.contains(detailIndex) || !payItem.getPkValue().equals(((DynamicObject)detailEntry.get(detailIndex)).getLong("itemid"))) continue;
                    ++relateCount;
                }
                if (relateCount <= 1) {
                    it.remove();
                    continue;
                }
                BigDecimal ofTaxAmount = payItem.getBigDecimal("oftaxamount");
                BigDecimal amount = payItem.getBigDecimal("amount");
                BigDecimal taxAmt = payItem.getBigDecimal("taxamt");
                BigDecimal detailOfTaxAmount = payItemDetailEntryObj.getBigDecimal("detailoftaxamt");
                BigDecimal detailAmt = payItemDetailEntryObj.getBigDecimal("detailamt");
                BigDecimal detailTaxAmt = payItemDetailEntryObj.getBigDecimal("detailtaxamt");
                amount = amount.subtract(detailAmt);
                taxAmt = taxAmt.subtract(detailTaxAmt);
                payItem.set("oftaxamount", (Object)ofTaxAmount.subtract(detailOfTaxAmount));
                payItem.set("amount", (Object)amount);
                payItem.set("taxamt", (Object)taxAmt);
                BigDecimal rate = amount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.multiply(new BigDecimal(100)).divide(amount, 2, 4);
                payItem.set("rate", (Object)rate);
            }
            alreadyDeleteDetailIndexList.add(rowIndex);
        }
        this.getView().updateView("itementry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteitemdetail", (CharSequence)operateKey)) {
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection selectRows;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"adddetail", (CharSequence)actionId) && (returnData = closedCallBackEvent.getReturnData()) != null && (selectRows = (DynamicObjectCollection)returnData).size() > 0) {
            ArrayList<Integer> relateDetailPayItemsSeq = new ArrayList<Integer>(10);
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection itemEntry = data.getDynamicObjectCollection("itementry");
            DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("payitemdetailentry");
            for (DynamicObject detail : detailEntry) {
                Long itemId = detail.getLong("itemid");
                for (int index = 0; index < itemEntry.size(); ++index) {
                    if (!((DynamicObject)itemEntry.get(index)).getPkValue().equals(itemId)) continue;
                    relateDetailPayItemsSeq.add(index);
                }
            }
            DynamicObjectCollection payItemDetailCol = this.getModel().getEntryEntity("payitemdetailentry");
            DynamicObjectType payItemDetailType = payItemDetailCol.getDynamicObjectType();
            Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
            for (DynamicObject dynamicObject : selectRows) {
                DynamicObject payItemDetail = new DynamicObject(payItemDetailType);
                payItemDetail.set("detailitem", (Object)dynamicObject.getString("detailitem"));
                payItemDetail.set("detailpayitem", (Object)dynamicObject.getDynamicObject("detailpayitem"));
                payItemDetail.set("detailoftaxamt", (Object)dynamicObject.getBigDecimal("detailoftaxamt"));
                payItemDetail.set("detailtaxamt", (Object)dynamicObject.getBigDecimal("detailtaxamt"));
                payItemDetail.set("detailamt", (Object)dynamicObject.getBigDecimal("detailamt"));
                payItemDetail.set("referbillnumber", (Object)dynamicObject.getString("billnumber"));
                payItemDetail.set("referbillid", dynamicObject.get("referbillid"));
                payItemDetail.set("referbilltype", dynamicObject.get("referbilltype"));
                payItemDetail.set("referentryid", dynamicObject.get("referentryid"));
                if (!isMultiContract.booleanValue()) {
                    payItemDetail.set("detailbudgetitem", dynamicObject.get("detailbudgetitem"));
                }
                payItemDetailCol.add((Object)payItemDetail);
                this.checkAndGeneratePayItem(payItemDetail, relateDetailPayItemsSeq, itemEntry);
            }
            SettleUpdateAmtUtils.calAllTypeAmount((IDataModel)this.getModel());
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
            this.getView().updateView("itementry");
            this.getView().updateView("payitemdetailentry");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid payItemDetailEntry = (EntryGrid)this.getControl("payitemdetailentry");
        payItemDetailEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String fieldName = paramHyperLinkClickEvent.getFieldName();
        int rowIndex = paramHyperLinkClickEvent.getRowIndex();
        String paydirection = this.getModel().getDataEntity().getString("paydirection");
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"referbillnumber")) {
            DynamicObject detailEntry = this.getModel().getEntryRowEntity("payitemdetailentry", rowIndex);
            String referBillType = detailEntry.getString("referbilltype");
            Long referBillId = detailEntry.getLong("referbillid");
            if (StringUtils.equals((CharSequence)referBillType, (CharSequence)ReferBillTypeEnum.CLAIM.getValue())) {
                if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)paydirection)) {
                    this.showBillDetailForm(referBillId, "pmct_inclaimbill");
                } else {
                    this.showBillDetailForm(referBillId, "pmct_outclaimbill");
                }
            } else if (StringUtils.equals((CharSequence)referBillType, (CharSequence)ReferBillTypeEnum.PERFORM.getValue())) {
                if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)paydirection)) {
                    this.showBillDetailForm(referBillId, "pmct_inperformrecords");
                } else {
                    this.showBillDetailForm(referBillId, "pmct_outperformrecords");
                }
            }
        }
    }

    private void clearAllAmtWhenDelContract() {
        IDataModel model = this.getModel();
        model.setValue("caloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("notcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("settleoftaxamount", (Object)BigDecimal.ZERO);
        model.setValue("totalcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalnotcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalsettleoftaxamount", (Object)BigDecimal.ZERO);
        model.setValue("totalplanpayoftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalrealpayoftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("sumamountfield_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("sumnotcaloftaxamt_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("sumsettleoftaxamt_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("stdcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdnotcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsettleoftaxamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalnotcaloftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalsettleoftaxamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalplanpayoftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalrealpayoftaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumamtfield_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("stdsumnotcalamt_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("stdsumsettleamt_org_pro", (Object)BigDecimal.ZERO);
        model.setValue("calofamt", (Object)BigDecimal.ZERO);
        model.setValue("notcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("settleamount", (Object)BigDecimal.ZERO);
        model.setValue("totalcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("totalnotcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("totalsettleofamount", (Object)BigDecimal.ZERO);
        model.setValue("totalplanpayofamt", (Object)BigDecimal.ZERO);
        model.setValue("totalrealpayofamt", (Object)BigDecimal.ZERO);
        model.setValue("sumcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("sumnotcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("sumsettleofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdnotcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsettleamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalnotcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalsettleofamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalplanpayofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalrealpayofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumnotcalofamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumsettleofamt", (Object)BigDecimal.ZERO);
        model.setValue("caltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("notcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("taxamount", (Object)BigDecimal.ZERO);
        model.setValue("totalcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalnotcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalsettletaxamount", (Object)BigDecimal.ZERO);
        model.setValue("totalplanpaytaxamt", (Object)BigDecimal.ZERO);
        model.setValue("totalrealpaytaxamt", (Object)BigDecimal.ZERO);
        model.setValue("sumcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("sumnotcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("sumsettletaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdnotcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtaxamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalnotcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalsettletaxamount", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalplanpaytaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdtotalrealpaytaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumnotcaltaxamt", (Object)BigDecimal.ZERO);
        model.setValue("stdsumsettletaxamt", (Object)BigDecimal.ZERO);
        if ("out".equals(model.getValue("paydirection"))) {
            model.setValue("suptotalcaloftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalnotcaloftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalsettleoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalplanpayoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalrealpayoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalcaloftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalnotcaloftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalsettleoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptplanpayoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptrealpayoftaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalcalofamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalnotcalofamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalsettleofamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalplanpayofamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalrealpayofamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalcalofamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalnotcalofamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalsettleofamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalplanpayofamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalrealpayofamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalcaltaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalnotcaltaxamt", (Object)BigDecimal.ZERO);
            model.setValue("suptotalsettletaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptplanpaytaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptrealpaytaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalcaltaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalnotcaltaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptotalsettletaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptplanpaytaxamt", (Object)BigDecimal.ZERO);
            model.setValue("stdsuptrealpaytaxamt", (Object)BigDecimal.ZERO);
        }
        model.setValue("conttotaloftaxamount", (Object)BigDecimal.ZERO);
    }

    private void showBillDetailForm(Long pkId, String billFormId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("formId", billFormId);
        paramMap.put("pkId", String.valueOf(pkId));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void checkAndGeneratePayItem(DynamicObject payItemDetail, List<Integer> relateDetailPayItemsSeq, DynamicObjectCollection itemEntry) {
        ORM orm = ORM.create();
        Object detailPayItemId = payItemDetail.getDynamicObject("detailpayitem").getPkValue();
        DynamicObject detailBudget = payItemDetail.getDynamicObject("detailbudgetitem");
        boolean findPayItem = false;
        for (Integer seq : relateDetailPayItemsSeq) {
            DynamicObject payItem = (DynamicObject)itemEntry.get(seq.intValue());
            BigDecimal ofTaxAmount = payItem.getBigDecimal("oftaxamount");
            BigDecimal amount = payItem.getBigDecimal("amount");
            BigDecimal taxAmt = payItem.getBigDecimal("taxamt");
            BigDecimal detailOfTaxAmt = payItemDetail.getBigDecimal("detailoftaxamt");
            BigDecimal detailAmt = payItemDetail.getBigDecimal("detailamt");
            BigDecimal detailTaxAmt = payItemDetail.getBigDecimal("detailtaxamt");
            DynamicObject payItemBudget = payItem.getDynamicObject("paybudgetitem");
            if (!payItem.getDynamicObject("payitem").getPkValue().equals(detailPayItemId)) continue;
            if (detailBudget != null && payItemBudget != null && detailBudget.getPkValue().equals(payItemBudget.getPkValue())) {
                payItemDetail.set("itemid", payItem.getPkValue());
                ofTaxAmount = ofTaxAmount.add(detailOfTaxAmt);
                amount = amount.add(detailAmt);
                taxAmt = taxAmt.add(detailTaxAmt);
                payItem.set("oftaxamount", (Object)ofTaxAmount);
                payItem.set("amount", (Object)amount);
                payItem.set("taxamt", (Object)taxAmt);
                BigDecimal rate = amount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.multiply(new BigDecimal(100)).divide(amount, 2, 4);
                payItem.set("rate", (Object)rate);
                findPayItem = true;
                break;
            }
            if (detailBudget != null || payItemBudget != null) continue;
            payItemDetail.set("itemid", payItem.getPkValue());
            ofTaxAmount = ofTaxAmount.add(detailOfTaxAmt);
            amount = amount.add(detailAmt);
            taxAmt = taxAmt.add(detailTaxAmt);
            payItem.set("oftaxamount", (Object)ofTaxAmount);
            payItem.set("amount", (Object)amount);
            payItem.set("taxamt", (Object)taxAmt);
            BigDecimal rate = amount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.multiply(new BigDecimal(100)).divide(amount, 2, 4);
            payItem.set("rate", (Object)rate);
            findPayItem = true;
            break;
        }
        if (!findPayItem) {
            long newPayItemId = orm.genLongId((IDataEntityType)itemEntry.getDynamicObjectType());
            DynamicObject newPayItem = new DynamicObject(itemEntry.getDynamicObjectType());
            newPayItem.set("id", (Object)newPayItemId);
            newPayItem.set("paybudgetitem", (Object)payItemDetail.getDynamicObject("detailbudgetitem"));
            newPayItem.set("oftaxamount", (Object)payItemDetail.getBigDecimal("detailoftaxamt"));
            BigDecimal amount = payItemDetail.getBigDecimal("detailamt");
            newPayItem.set("amount", (Object)amount);
            BigDecimal taxAmt = payItemDetail.getBigDecimal("detailtaxamt");
            newPayItem.set("taxamt", (Object)taxAmt);
            BigDecimal rate = amount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxAmt.multiply(new BigDecimal(100)).divide(amount, 2, 4);
            newPayItem.set("rate", (Object)rate);
            itemEntry.add((Object)newPayItem);
            this.getModel().setValue("payitem", (Object)payItemDetail.getDynamicObject("detailpayitem"), itemEntry.size() - 1);
            payItemDetail.set("itemid", (Object)newPayItemId);
            relateDetailPayItemsSeq.add(itemEntry.size() - 1);
        }
    }
}

