/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractTplEditPlugin
extends AbstractPmctBillPlugin
implements ClickListener,
BeforeF7SelectListener {
    public static final String PARTAPERSON = "partaperson";
    public static final String PARTBPERSON = "partbperson";
    public static final String PARTOTHERPERSON = "partotherperson";
    public static final String UNIFIED_PAY = "unifiedpay";
    private static final String RISKENTRY = "riskentry";
    private static final String DELCOMP2 = "delcomp2";
    private static final String RISKITEM = "riskitem";
    private static final String RISK_PANEL = "risk_panel";
    private static final String CALLBACKDELETERISKENTRY = "deleteriskentry";
    private static final String OP_DOUNSIGN = "dounsign";
    private static final String OP_DOSIGN = "dosign";
    private static final String OP_DOSIGNINFO = "dosigninfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARTAPERSON, PARTBPERSON, PARTOTHERPERSON});
        BasedataEdit multiSettlePro = (BasedataEdit)this.getView().getControl("multisettlepro");
        multiSettlePro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountOrg = (BasedataEdit)this.getView().getControl("fiaccountorg");
        accountOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit otherPart = (BasedataEdit)this.getView().getControl("otherpart");
        otherPart.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject org;
        super.beforeBindData(e);
        boolean ifExist = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!ifExist && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            Object changeStandard = SystemParamHelper.getSystemParameter((String)"taxchangestandard", (String)"pmct", (Long)org.getLong("id"));
            this.getModel().setValue("changestandard", changeStandard);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount(RISKENTRY);
        this.getView().setVisible(Boolean.valueOf(rowCount > 0), new String[]{RISK_PANEL});
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        FieldEdit taxRate = (FieldEdit)this.getControl("taxrate");
        taxRate.setMustInput(!isMultiRate);
        FieldEdit signdate = (FieldEdit)this.getControl("signdate");
        signdate.setMustInput(this.getModel().getDataEntity().getBoolean("auditassign"));
        DynamicObject contType = (DynamicObject)this.getModel().getValue("contracttype");
        if (contType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractTplEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "loadriskitem": {
                this.getView().setVisible(Boolean.TRUE, new String[]{RISK_PANEL, DELCOMP2});
                this.getView().setVisible(Boolean.FALSE, new String[]{RISKITEM});
                break;
            }
            case "deleteriskentrycomp": {
                ConfirmCallBackListener riskCallback = new ConfirmCallBackListener(CALLBACKDELETERISKENTRY, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5220\u9664\u5408\u540c\u98ce\u9669\u9879\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ContractTplEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, riskCallback);
                break;
            }
            case "showdataview": {
                if (!"C".equals(this.getModel().getValue("billstatus"))) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u67e5\u770b\u5408\u540c\u770b\u677f\u3002", (String)"ContractTplEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<String, Object> custormMap = new HashMap<String, Object>();
                custormMap.put("contractId", this.getModel().getDataEntity().getPkValue());
                custormMap.put("payDirection", this.getModel().getDataEntity().get("paydirection"));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formId", "pmct_contractkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (key.equalsIgnoreCase("project")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                return;
            }
            DynamicObject refContract = (DynamicObject)this.getModel().getValue("refcontract");
            if (refContract == null) {
                return;
            }
            String refContractPro = Optional.ofNullable(refContract.getDynamicObject("project")).map(DataEntityBase::getPkValue).map(Object::toString).orElse(null);
            if (refContractPro != null && !project.getPkValue().toString().equals(refContractPro)) {
                this.getModel().setValue("refcontract", null);
            }
        } else if (key.equalsIgnoreCase("audit")) {
            this.getView().invokeOperation("refresh");
        } else if (key.equalsIgnoreCase(OP_DOSIGN)) {
            this.doContractSign();
        } else if (key.equalsIgnoreCase(OP_DOUNSIGN)) {
            this.getView().invokeOperation("refresh");
        } else if (key.equalsIgnoreCase(OP_DOSIGNINFO)) {
            this.doSignInfo();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals(CALLBACKDELETERISKENTRY) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData(RISKENTRY);
            this.getView().setVisible(Boolean.FALSE, new String[]{RISK_PANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{RISKITEM});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "project": {
                DynamicObject contractProject;
                if (newValue == null) break;
                DynamicObject project = (DynamicObject)newValue;
                long orgId = this.getAccountOrgByProjct(project.getLong("id"));
                if (orgId == 0L) {
                    orgId = this.getAccountOrg();
                }
                this.getModel().setValue("fiaccountorg", (Object)orgId);
                DynamicObject refContract = (DynamicObject)this.getModel().getValue("refcontract");
                if (refContract == null || (contractProject = refContract.getDynamicObject("project")) != null && contractProject.getLong("id") == project.getLong("id")) break;
                this.getModel().setValue("refcontract", null);
                break;
            }
            case "auditassign": {
                FieldEdit signdate = (FieldEdit)this.getControl("signdate");
                signdate.setMustInput(Boolean.TRUE.equals(newValue));
                break;
            }
            case "originaloftaxamount": {
                this.originalOfTaxAmountChanged(newValue);
                break;
            }
            case "originalamount": {
                this.originalAmountChanged(newValue);
                break;
            }
            case "taxrate": {
                this.taxRateChange();
                break;
            }
            case "multipartsettlement": {
                this.multiPartSettlementChange(newValue);
                break;
            }
            case "exchangerate": {
                this.exchangerRateChange();
                break;
            }
            case "multisettlepro": {
                DynamicObject newProject = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (newProject == null) break;
                DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"prostatus", (QFilter[])new QFilter[]{new QFilter("id", "=", newProject.getPkValue())});
                QFilter proStatusFilter = new QFilter("number", "=", (Object)ProjectStatusEnum.FINANCIAL_CLOSE.getValue());
                DynamicObject proPassStatus = BusinessDataServiceHelper.loadSingle((String)"bd_projectstatus", (String)"id", (QFilter[])new QFilter[]{proStatusFilter});
                if (project == null || project.getDynamicObject("prostatus") == null || !project.getDynamicObject("prostatus").getPkValue().equals(proPassStatus.getPkValue())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u8d22\u52a1\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u53d1\u751f\u6b64\u4e1a\u52a1\u3002", (String)"ContractTplEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("multisettlepro", e.getChangeSet()[0].getOldValue(), rowIndex);
                return;
            }
        }
    }

    protected void exchangerRateChange() {
        this.changeMultiCurrencyAmount();
    }

    protected void changeMultiCurrencyAmount() {
        Boolean isMultiCurrency = (Boolean)this.getModel().getValue("ismulticurrency");
        if (isMultiCurrency.booleanValue()) {
            BigDecimal originalOfTaxAmount = (BigDecimal)this.getModel().getValue("originaloftaxamount");
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount");
            BigDecimal originalAmount = (BigDecimal)this.getModel().getValue("originalamount");
            BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
            this.getModel().setValue("signamount", (Object)originalOfTaxAmount.multiply(exchangeRate));
            this.getModel().setValue("stdtaxamount", (Object)taxAmount.multiply(exchangeRate));
            this.getModel().setValue("stdoriginalamount", (Object)originalAmount.multiply(exchangeRate));
        }
    }

    private void multiPartSettlementChange(Object newValue) {
        Boolean multiPartSettle = (Boolean)newValue;
        if (multiPartSettle.booleanValue()) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                int row = this.getModel().createNewEntryRow("contproscope");
                this.getModel().setValue("multisettlepro", (Object)project, row);
            } else {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                int row = this.getModel().createNewEntryRow("contorgscope");
                this.getModel().setValue("multisettleorg", (Object)org, row);
            }
        } else {
            this.getModel().deleteEntryData("contorgscope");
            this.getModel().deleteEntryData("contproscope");
            this.getModel().setValue("multipaytype", (Object)UNIFIED_PAY);
        }
    }

    public void taxRateChange() {
        IDataModel model = this.getModel();
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        Boolean isOnList = (Boolean)model.getValue("isonlist");
        if (!isMultiRate.booleanValue() && !isOnList.booleanValue()) {
            BigDecimal originalOfTaxAmount = (BigDecimal)model.getValue("originaloftaxamount");
            DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
            BigDecimal taxRate = taxRateObject == null ? BigDecimal.ZERO : taxRateObject.getBigDecimal("taxrate");
            BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
            BigDecimal originalAmount = originalOfTaxAmount.divide(BigDecimal.ONE.add(rate), 10, 4);
            BigDecimal taxAmount = originalOfTaxAmount.subtract(originalAmount);
            model.beginInit();
            model.setValue("originalamount", (Object)originalAmount);
            model.setValue("taxamount", (Object)taxAmount);
            model.endInit();
            this.getView().updateView("originalamount");
            this.getView().updateView("taxamount");
            this.changeMultiCurrencyAmount();
        }
    }

    public void originalOfTaxAmountChanged(Object newValue) {
        IDataModel model = this.getModel();
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        if (!isMultiRate.booleanValue()) {
            BigDecimal originalOfTaxAmount = (BigDecimal)newValue;
            DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
            BigDecimal taxRate = taxRateObject == null ? BigDecimal.ZERO : taxRateObject.getBigDecimal("taxrate");
            BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
            BigDecimal originalAmount = originalOfTaxAmount.divide(BigDecimal.ONE.add(rate), 10, 4);
            BigDecimal taxAmount = originalOfTaxAmount.subtract(originalAmount);
            model.beginInit();
            model.setValue("originalamount", (Object)originalAmount);
            model.setValue("taxamount", (Object)taxAmount);
            model.endInit();
            this.getView().updateView("originalamount");
            this.getView().updateView("taxamount");
            this.changeMultiCurrencyAmount();
        }
    }

    public void originalAmountChanged(Object newValue) {
        IDataModel model = this.getModel();
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        if (!isMultiRate.booleanValue()) {
            BigDecimal originalAmount = (BigDecimal)newValue;
            DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
            BigDecimal taxRate = taxRateObject == null ? BigDecimal.ZERO : taxRateObject.getBigDecimal("taxrate");
            BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
            BigDecimal originalOfTaxAmount = originalAmount.multiply(BigDecimal.ONE.add(rate));
            BigDecimal taxAmount = originalOfTaxAmount.subtract(originalAmount);
            model.beginInit();
            model.setValue("originaloftaxamount", (Object)originalOfTaxAmount);
            model.setValue("taxamount", (Object)taxAmount);
            model.endInit();
            this.getView().updateView("originaloftaxamount");
            this.getView().updateView("taxamount");
            this.changeMultiCurrencyAmount();
        }
    }

    public void click(EventObject evt) {
        QFilter qFilter;
        super.click(evt);
        TextEdit textEdit = (TextEdit)evt.getSource();
        String personProp = textEdit.getKey();
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false);
        para.setCustomParam("person", (Object)personProp);
        para.setShowQuickFilter(true);
        para.setF7Style(3);
        List qFilters = para.getListFilterParameter().getQFilters();
        long currUserId = RequestContext.get().getCurrUserId();
        long projectId = 0L;
        Object projectObj = this.getModel().getValue("project");
        if (projectObj != null) {
            DynamicObject project = (DynamicObject)projectObj;
            projectId = Long.parseLong(project.getPkValue().toString());
        }
        if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) != null) {
            qFilters.add(qFilter);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, String.format("%s_callback", personProp));
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object data = closedCallBackEvent.getReturnData();
        if (data == null) {
            return;
        }
        if (data instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)data;
            if (returnData.isEmpty()) {
                return;
            }
            ListSelectedRow row = returnData.get(0);
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bos_user");
            Object phone = user.get("phone");
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partaperson_callback")) {
                this.getModel().setValue(PARTAPERSON, (Object)row.getName());
                this.getModel().setValue("partaphone", phone);
            } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partbperson_callback")) {
                this.getModel().setValue(PARTBPERSON, (Object)row.getName());
                this.getModel().setValue("partbphone", phone);
            } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"partotherperson_callback")) {
                this.getModel().setValue(PARTOTHERPERSON, (Object)row.getName());
                this.getModel().setValue("partotherphone", phone);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"pmct_contsign")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u8ba2\u6210\u529f\u3002", (String)"ContractTplEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    protected long getAccountOrgByProjct(long projectId) {
        QFilter approvalFilter = new QFilter("pro", "=", (Object)projectId);
        approvalFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"accountorg", (QFilter[])new QFilter[]{approvalFilter});
        if (projectApprovals != null && projectApprovals.length > 0) {
            DynamicObject accountOrg = projectApprovals[0].getDynamicObject("accountorg");
            return accountOrg == null ? 0L : accountOrg.getLong("id");
        }
        return 0L;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "multisettlepro": {
                this.beforeMultiSettleProSelect(e);
                break;
            }
            case "fiaccountorg": {
                this.beforeOpenAccountOrg(e);
                break;
            }
            case "otherpart": {
                this.beforeOpenOtherPart(e);
                break;
            }
        }
    }

    private void beforeOpenOtherPart(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        DynamicObjectCollection otherParts = this.getModel().getEntryEntity("otherpart");
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ContractTplEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        if (otherParts != null && otherParts.size() > 0) {
            List selectParts = otherParts.stream().map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "not in", selectParts);
            qFilters.add(qFilter);
            param.setSelectedRows(selectParts.toArray());
        }
    }

    private void beforeOpenAccountOrg(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        if (hashPermOrgUnits.size() == 0) {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        } else {
            String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
            List accountOrgs = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)hashPermOrgUnits, (String)"10");
            if (accountOrgs.size() == 0) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                List allOrgIds = OrgTreeUtils.getParentByOrgIds((List)accountOrgs, (String)"10");
                if (allOrgIds.size() > 0) {
                    qFilters.add(new QFilter("id", "in", (Object)allOrgIds));
                    param.setF7ClickByFilter(true);
                }
            }
        }
    }

    private void beforeMultiSettleProSelect(BeforeF7SelectEvent e) {
        ArrayList<Object> proList = new ArrayList<Object>(10);
        DynamicObjectCollection contProScope = this.getModel().getEntryEntity("contproscope");
        for (DynamicObject entry : contProScope) {
            DynamicObject pro = entry.getDynamicObject("multisettlepro");
            if (pro == null) continue;
            proList.add(pro.getPkValue());
        }
        QFilter filter = new QFilter("id", "not in", proList);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private long getAccountOrg() {
        long currentOrgId = RequestContext.get().getOrgId();
        List allOrgIds = OrgTreeUtils.getParentByOrgIds(Collections.singletonList(currentOrgId), (String)"10");
        if (!allOrgIds.isEmpty()) {
            return (Long)allOrgIds.get(allOrgIds.size() - 1);
        }
        return 0L;
    }

    private void doContractSign() {
        Object id = this.getModel().getDataEntity().getPkValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject contract = this.getModel().getDataEntity();
        String contStatus = contract.getDynamicObject("contractstatus").getString("number");
        if (!StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a\u201c\u5df2\u6279\u51c6\u201d\u65f6\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractTplEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        map.put("contractId", id);
        map.put("formId", "pmct_contsign");
        map.put("contractstatus", contStatus);
        map.put("ismulticontract", contract.get("ismulticontract"));
        FormShowParameter showParameter = new FormShowParameter();
        QFilter contFilter = new QFilter("contract", "=", id);
        String selectedProperties = "partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, signdate, signaddress, signaddressdetail, contract";
        DynamicObject[] contractSigns = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)selectedProperties, (QFilter[])new QFilter[]{contFilter});
        if (contractSigns != null && contractSigns.length == 1) {
            DynamicObject contractSign = contractSigns[0];
            map.put("pkId", contractSign.getPkValue().toString());
            String payDirection = contract.getString("paydirection");
            if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                map.put("signdate", contractSign.getDate("signdate"));
            }
            showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.EDIT);
        } else if (contractSigns == null || contractSigns.length == 0) {
            showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_contsign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doSignInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object id = this.getModel().getDataEntity().getPkValue();
        DynamicObject contract = this.getModel().getDataEntity();
        String contStatus = contract.getDynamicObject("contractstatus").getString("number");
        if (StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u67e5\u770b\u7b7e\u8ba2\u4fe1\u606f\u3002", (String)"ContractTplEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        map.put("contractId", id);
        map.put("formId", "pmct_contsign");
        map.put("contractstatus", contStatus);
        map.put("ismulticontract", contract.get("ismulticontract"));
        FormShowParameter showParameter = new FormShowParameter();
        QFilter contFilter = new QFilter("contract", "=", id);
        String selectedProperties = "partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, signdate, signaddress, signaddressdetail, contract";
        DynamicObject[] contractSigns = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)selectedProperties, (QFilter[])new QFilter[]{contFilter});
        if (contractSigns != null && contractSigns.length == 1) {
            DynamicObject contractSign = contractSigns[0];
            map.put("pkId", contractSign.getPkValue().toString());
            showParameter = FormShowParameter.createFormShowParameter(map);
            Object signDate = contractSign.get("signdate");
            showParameter.setCustomParam("signdate", signDate);
            showParameter.setStatus(OperationStatus.VIEW);
        } else if (contractSigns == null || contractSigns.length == 0) {
            showParameter = FormShowParameter.createFormShowParameter(map);
            Object signDate = contract.get("signdate");
            showParameter.setCustomParam("signdate", signDate);
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_contsign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

