/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ContractTplListPlugin
extends AbstractListPlugin {
    private static final String STATUSCHANGE = "statuschange";
    private static final String STATUSHISTORY = "statushistory";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        ListView listView = (ListView)this.getView();
        if (StringUtils.equals((CharSequence)"viewconttext", (CharSequence)operateKey)) {
            ListSelectedRow row3 = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
            Long contractPk1 = (Long)row3.getPrimaryKeyValue();
            QFilter billIdFilter = new QFilter("billid", "=", (Object)contractPk1);
            DynamicObject richText = QueryServiceHelper.queryOne((String)"pmct_contrichtextbill", (String)"id", (QFilter[])new QFilter[]{billIdFilter});
            if (richText == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u6ca1\u6709\u5408\u540c\u6b63\u6587\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5408\u540c\u3002", (String)"ContractTplListPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk1, (String)listView.getBillFormId());
            DynamicObject contractType = contract.getDynamicObject("contracttype");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("fromkey", "list");
            paramMap.put("formId", "pmct_contrichtextbill");
            paramMap.put("pkId", richText.get("id").toString());
            paramMap.put("billid", contractPk1);
            paramMap.put("contracttypeid", contractType.getPkValue());
            paramMap.put("billstatus", contract.getString("billstatus"));
            paramMap.put("billtypename", listView.getBillFormId());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"createfromtemp", (CharSequence)operateKey)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(listView.getBillFormId());
            showParameter.setCustomParam("fromTemp", (Object)"true");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("showdataview".equals(operateKey)) {
            int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
            if (rows < 1) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"ContractTplListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rows > 1) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4e0d\u652f\u6301\u540c\u65f6\u67e5\u770b\u591a\u4e2a\u5408\u540c\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u540c\u8fdb\u884c\u67e5\u770b\u3002", (String)"ContractTplListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
            String billStatus = row.getBillStatus();
            if (!"C".equals(billStatus)) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u67e5\u770b\u5408\u540c\u770b\u677f\u3002", (String)"ContractTplListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object pk = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0).getPrimaryKeyValue();
            DynamicObject cotract = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmct_contracttpl");
            HashMap<String, Object> custormMap = new HashMap<String, Object>();
            custormMap.put("contractId", pk.toString());
            custormMap.put("payDirection", cotract.get("paydirection"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formId", "pmct_contractkanban");
            map.put("customParams", custormMap);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        } else if (STATUSHISTORY.equals(operateKey)) {
            int rows = listView.getSelectedRows().getBillListSelectedRowCollection().size();
            if (rows > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u540c\u3002", (String)"ContractTplListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
            Long contractPk = (Long)row.getPrimaryKeyValue();
            ListShowParameter parameter = new ListShowParameter();
            parameter.getListFilterParameter().getQFilters().add(new QFilter("contract", "=", (Object)contractPk));
            String payDirection = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contracttpl").getString("paydirection");
            if (StringUtils.equalsIgnoreCase((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                parameter.setBillFormId("pmct_instatuschange");
            } else {
                parameter.setBillFormId("pmct_statuschange");
            }
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if (STATUSCHANGE.equals(operateKey)) {
            this.doChangeContractStatus(selectedRows);
        }
    }

    private void doChangeContractStatus(ListSelectedRowCollection selectedRowCollection) {
        int rows = selectedRowCollection.size();
        if (rows > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u540c\u3002", (String)"ContractTplListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pmct_contracttpl");
        DynamicObject contStatus = contract.getDynamicObject("contractstatus");
        List statusNums = Stream.of(ContractStatusEnum.INDRAFT.getValue(), ContractStatusEnum.INAUDIT.getValue(), ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
        if (statusNums.contains(contStatus.getString("number"))) {
            String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u8fdb\u884c\u72b6\u6001\u53d8\u66f4\u3002", (String)"ContractTplListPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
            this.getView().showTipNotification(tip);
            return;
        }
        QFilter contFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] staChanges = BusinessDataServiceHelper.load((String)"pmct_statuschange", (String)"id", (QFilter[])new QFilter[]{contFilter, statusFilter});
        if (staChanges.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55\uff0c\u8bf7\u67e5\u770b\u53d8\u66f4\u8bb0\u5f55\u3002", (String)"ContractTplListPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("contractId", contract.getPkValue());
        map.put("contstatusId", contStatus.getPkValue());
        StyleCss css = new StyleCss();
        css.setHeight("708px");
        css.setWidth("1180px");
        BillShowParameter parameter = new BillShowParameter();
        if (StringUtils.equals((CharSequence)contract.getString("paydirection"), (CharSequence)PayDirectionEnum.IN.getValue())) {
            parameter.setFormId("pmct_instatuschange");
        } else {
            parameter.setFormId("pmct_statuschange");
        }
        parameter.setCustomParams(map);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

