/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.sdk.Interface.IContractListUpdateTreeListPlugin;
import kd.pmgt.pmct.business.sdk.impl.ContractListUpdateTreeListPlugin;
import kd.pmgt.pmct.common.utils.ContractListingImportAndExportUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractTreeListingPlugin
extends AbstractPmctBillPlugin
implements RowClickEventListener,
UploadListener,
SelectRowsEventListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(ContractTreeListingPlugin.class);
    private static final String LISTPANEL = "contractlistingpanel";
    private static final String CONTRACTTYPE_CALLBACK = "contracttype_callback";
    private static final String CONTRACTTYPE_CACHE = "contracttype_cache";

    public void registerListener(EventObject e) {
        BasedataEdit treeMaterial;
        BasedataEdit treeContList;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("listmodelentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((treeContList = (BasedataEdit)this.getControl("treecontlistnumber")) != null) {
            treeContList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((treeMaterial = (BasedataEdit)this.getControl("treematerial")) != null) {
            treeMaterial.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contType = (DynamicObject)this.getModel().getValue("contracttype");
        if (contType != null) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection listConfigs = dataEntity.getDynamicObjectCollection("listmodelentry");
            if (listConfigs != null && !listConfigs.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{LISTPANEL});
                CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
                cardEntry.selectRows(0, true);
                if (listConfigs.size() == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
                    this.getPageCache().put("curModelRow", "0");
                    this.initTreeListEntry(0);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
            }
            boolean isOnList = contType.getBoolean("isonlist");
            if (!isOnList) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isonlist"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isonlist"});
            }
        }
        this.setIsShowListingPanel();
        this.getModel().setDataChanged(false);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"listmodelentry", (CharSequence)source.getKey())) {
            int rowIndex = evt.getRow();
            this.getPageCache().put("curModelRow", String.valueOf(rowIndex));
            this.initTreeListEntry(rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": {
                boolean isonlist = (Boolean)this.getModel().getValue("isonlist");
                if (isonlist) break;
                this.getModel().deleteEntryData("treelistentry");
                int modelEntryRowCount = this.getModel().getEntryRowCount("listmodelentry");
                for (int i = 0; i < modelEntryRowCount; ++i) {
                    this.getModel().setValue("rowtaxrate", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowamount", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowtax", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowoftax", (Object)BigDecimal.ZERO, i);
                }
                break;
            }
            case "submit": {
                boolean isonlist = (Boolean)this.getModel().getValue("isonlist");
                if (isonlist) break;
                this.getModel().deleteEntryData("treelistentry");
                int modelEntryRowCount = this.getModel().getEntryRowCount("listmodelentry");
                for (int i = 0; i < modelEntryRowCount; ++i) {
                    this.getModel().setValue("rowtaxrate", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowamount", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowtax", (Object)BigDecimal.ZERO, i);
                    this.getModel().setValue("rowoftax", (Object)BigDecimal.ZERO, i);
                }
                break;
            }
            case "addsubordinate": {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
                int[] selectRows = grid.getSelectRows();
                if (!this.isTreeList()) break;
                if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u591a\u884c\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u884c\u3002", (String)"ContractTreeListingPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (selectRows.length == 1) {
                    this.getView().invokeOperation("inserttreeentry");
                    args.setCancel(true);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractTreeListingPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deletetreeentry": {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
                int[] selectRows = grid.getSelectRows();
                if (selectRows.length == 1) {
                    this.getPageCache().put("delIndex", String.valueOf(selectRows[0]));
                    break;
                }
                if (selectRows.length <= 1) break;
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < selectRows.length; ++i) {
                    s.append(selectRows[i]);
                    if (i >= selectRows.length - 1) continue;
                    s.append(',');
                }
                this.getPageCache().put("delIndex", s.toString());
                break;
            }
            case "inserttreeentry": {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
                int[] selectRows = grid.getSelectRows();
                if (!this.isTreeList() || selectRows.length != 1) break;
                this.getPageCache().put("insertIndex", String.valueOf(selectRows[0]));
                int index = selectRows[0];
                boolean treeIsLeaf = this.getModel().getEntryRowEntity("treelistentry", index).getBoolean("treeisleaf");
                if (!treeIsLeaf) break;
                this.getModel().setValue("treeqty", null, index);
                this.getModel().setValue("treerate", null, index);
                this.getModel().setValue("treerateobj", null, index);
                this.getModel().setValue("treeoftax", null, index);
                this.getModel().setValue("treetax", null, index);
                this.getModel().setValue("treeprice", null, index);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "newtreeentry": {
                this.doNewTreeEntryOperation(null);
                break;
            }
            case "inserttreeentry": {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
                int[] selRows = grid.getSelectRows();
                int parentIndex = Integer.parseInt(this.getPageCache().get("insertIndex"));
                boolean isLeaf = this.getModel().getEntryRowEntity("treelistentry", parentIndex).getBoolean("treeisleaf");
                if (selRows.length <= 0) break;
                this.doInsertTreeEntryOperation(selRows[0]);
                int curIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
                if (!isLeaf) break;
                CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
                cardEntry.entryRowClick(Integer.valueOf(curIndex));
                break;
            }
            case "deletetreeentry": {
                this.doDeleteTreeEntryOperation();
                int curModelIndex = Integer.parseInt(this.getPageCache().get("curModelRow"));
                this.sumListModelEntry(curModelIndex);
                String payDirection = (String)this.getModel().getValue("paydirection");
                if (payDirection == null || !payDirection.equals(PayDirectionEnum.OUT.getValue())) break;
                this.setRateView(true);
                break;
            }
            case "save": 
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.doAfterSaveAndSubmitOperation();
                break;
            }
            case "exportmodel": {
                ContractListingImportAndExportUtils.exportModel((IFormView)this.getView());
                break;
            }
            case "importcontlisting": {
                DynamicObject taxRateObj;
                int curIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
                if (curIndex < 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u6e05\u5355\u6a21\u677f\u5361\u7247\u5206\u5f55\u3002", (String)"ContractTreeListingPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    break;
                }
                boolean isMultiRate = (Boolean)this.getView().getModel().getValue("ismultirate");
                if (!isMultiRate && (taxRateObj = (DynamicObject)this.getView().getModel().getValue("taxrate")) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u5408\u540c\u9009\u62e9\u7684\u662f\u5355\u7a0e\u7387\uff0c\u8bf7\u5148\u8f93\u5165\u5355\u636e\u5934\u7a0e\u7387\u3002", (String)"ContractTreeListingPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sublistentry");
                if (entryEntity.isEmpty()) {
                    this.openUploadPage();
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u5220\u9664\u5355\u636e\u73b0\u6709\u5408\u540c\u6e05\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractTreeListingPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("impContListing"));
                break;
            }
        }
    }

    private void setRateView(boolean flag) {
        DynamicObjectCollection listModelEntry;
        DynamicObject strategicAgreement = (DynamicObject)this.getModel().getValue("strategicagreement");
        String isMultiRateFlag = this.getPageCache().get("ismultirate");
        if (isMultiRateFlag == null && strategicAgreement != null && (listModelEntry = this.getModel().getEntryEntity("listmodelentry")) != null && listModelEntry.size() > 0) {
            HashSet<Object> rateSet = new HashSet<Object>(10);
            for (DynamicObject listModel : listModelEntry) {
                DynamicObjectCollection subListEntry = listModel.getDynamicObjectCollection("sublistentry");
                if (subListEntry == null || subListEntry.size() <= 0) continue;
                for (DynamicObject subListObject : subListEntry) {
                    if (subListObject.getDynamicObject("rateobj") == null) continue;
                    rateSet.add(subListObject.getDynamicObject("rateobj").getPkValue());
                }
            }
            this.getPageCache().put("autoFlag", "true");
            if (rateSet.size() > 1) {
                this.getModel().setValue("ismultirate", (Object)Boolean.TRUE);
            } else if (rateSet.size() == 1) {
                this.getModel().setValue("taxrate", rateSet.toArray()[0]);
                this.getModel().setValue("ismultirate", (Object)Boolean.FALSE);
            } else if (flag) {
                this.getModel().setValue("ismultirate", (Object)Boolean.FALSE);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("impContListing".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.openUploadPage();
        }
        if (CONTRACTTYPE_CALLBACK.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.onContractTypeChange();
            } else {
                String pageCache = this.getPageCache().get(CONTRACTTYPE_CACHE);
                if (pageCache != null) {
                    Long contractTypeId = Long.valueOf(pageCache);
                    this.getModel().beginInit();
                    this.getModel().setValue("contracttype", (Object)contractTypeId);
                    this.getModel().endInit();
                    this.getView().updateView("contracttype");
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (actionId.equals("importExcelClosed") && returnData != null) {
            int curIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
            DynamicObject modelEntry = this.getModel().getEntryRowEntity("listmodelentry", curIndex);
            modelEntry.getDynamicObjectCollection("sublistentry").clear();
            int curModelIndex = Integer.parseInt(this.getPageCache().get("curModelRow"));
            String url = (String)returnData;
            ContractListingImportAndExportUtils.importListing((IFormView)this.getView(), (String)url, (int)curModelIndex);
            this.initTreeListEntry(curModelIndex);
            this.sumListModelEntry(curModelIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName = arg.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        String paydirection = (String)this.getModel().getValue("paydirection");
        if (PayDirectionEnum.OUT.getValue().equals(paydirection)) {
            DynamicObject incontract = (DynamicObject)this.getModel().getValue("refcontract");
            if ("treecontlistnumber".equals(propName)) {
                if (incontract == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u6536\u5165\u5408\u540c\u3002", (String)"ContractTreeListingPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    arg.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("contractid", "=", (Object)incontract.getLong("id"));
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Object[] materielIds = e.getListSelectedRowCollection().getPrimaryKeyValues();
        String payDirection = (String)this.getModel().getValue("paydirection");
        if (payDirection != null && payDirection.equals(PayDirectionEnum.OUT.getValue())) {
            this.setAutoMultiRate(materielIds);
        }
    }

    private void setAutoMultiRate(Object[] materielIds) {
        DynamicObject strategicAgreement = (DynamicObject)this.getModel().getValue("strategicagreement");
        String ismultirate = this.getView().getPageCache().get("ismultirate");
        if (ismultirate == null && strategicAgreement != null) {
            DynamicObjectCollection listModelEntry;
            strategicAgreement = BusinessDataServiceHelper.loadSingle((Object)strategicAgreement.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_strategicagreement"));
            DynamicObjectCollection priceDetailEntry = strategicAgreement.getDynamicObjectCollection("pricedetailentry");
            HashSet<Object> rateSet = new HashSet<Object>(10);
            if (priceDetailEntry != null && priceDetailEntry.size() > 0) {
                for (DynamicObject priceDetail : priceDetailEntry) {
                    DynamicObject materiel = priceDetail.getDynamicObject("materiel");
                    if (materiel == null) continue;
                    for (Object materielId : materielIds) {
                        if (!materielId.equals(materiel.getPkValue()) || priceDetail.getDynamicObject("tax") == null) continue;
                        rateSet.add(priceDetail.getDynamicObject("tax").getPkValue());
                    }
                }
            }
            if ((listModelEntry = this.getModel().getEntryEntity("listmodelentry")) != null && listModelEntry.size() > 0) {
                for (DynamicObject listModel : listModelEntry) {
                    DynamicObjectCollection subListEntry = listModel.getDynamicObjectCollection("sublistentry");
                    if (subListEntry == null || subListEntry.size() <= 0) continue;
                    for (DynamicObject subListObject : subListEntry) {
                        if (subListObject.getDynamicObject("rateobj") == null) continue;
                        rateSet.add(subListObject.getDynamicObject("rateobj").getPkValue());
                    }
                }
            }
            this.getView().getPageCache().put("autoFlag", "true");
            if (rateSet.size() > 1) {
                this.getModel().setValue("ismultirate", (Object)Boolean.TRUE);
            } else if (rateSet.size() == 1) {
                this.getModel().setValue("taxrate", rateSet.toArray()[0]);
                this.getModel().setValue("ismultirate", (Object)Boolean.FALSE);
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (propName) {
            case "treematerial": {
                int curIndex = valueSet[0].getRowIndex();
                if (newValue == null) break;
                this.doMaterialChange(curIndex);
                break;
            }
            case "contracttype": {
                if (newValue != null || oldValue == null) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"ContractTreeListingPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String property = e.getKey();
        int rowIndex = e.getRowIndex();
        int parentRowIndex = e.getParentRowIndex();
        Object newValue = e.getValue();
        switch (property) {
            case "treeamount": 
            case "treeoftax": {
                boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
                if (!isAdjustAmount) break;
                DynamicObjectCollection subEntries = this.getModel().getEntryEntity("treelistentry");
                DynamicObject subEntry = (DynamicObject)subEntries.get(rowIndex);
                BigDecimal qty = subEntry.getBigDecimal("treeqty");
                BigDecimal priceOfTax = subEntry.getBigDecimal("treetaxprice");
                BigDecimal price = subEntry.getBigDecimal("treeprice");
                BigDecimal oldAmount = property.equalsIgnoreCase("treeamount") ? price.multiply(qty) : priceOfTax.multiply(qty);
                boolean isRollBack = ContractEditHelper.amountRollback((IFormView)this.getView(), (DynamicObject)subEntry, (Object)newValue, (Object)oldAmount, (String)property, (int)rowIndex);
                if (!isRollBack) break;
                this.getModel().updateEntryCache(subEntries);
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int curModelRow;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        boolean needSumModelEntry = false;
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "contracttype": {
                if (propValue != null && oldValue != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5408\u540c\u7c7b\u578b\u5c06\u6e05\u7a7a\u5408\u540c\u6e05\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractTreeListingPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONTRACTTYPE_CALLBACK));
                    this.getPageCache().put(CONTRACTTYPE_CACHE, String.valueOf(((DynamicObject)oldValue).getPkValue()));
                    break;
                }
                this.onContractTypeChange();
                break;
            }
            case "treematerial": {
                DynamicObject strategicAgreement;
                if (propValue == null) break;
                DynamicObject material = (DynamicObject)propValue;
                String number = material.getString("number");
                String name = material.getString("name");
                this.getModel().setValue("treelistnumber", (Object)number, rowIndex);
                this.getModel().setValue("treelistname", (Object)name, rowIndex);
                this.getModel().setValue("treematerial", (Object)material, rowIndex);
                DynamicObject measureunit = material.getDynamicObject("baseunit");
                if (measureunit != null) {
                    this.getModel().setValue("treemeasureunit", measureunit.getPkValue(), rowIndex);
                }
                try {
                    boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
                    if (!isMultiRate) {
                        DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
                        this.getModel().setValue("treerateobj", (Object)taxRateObj, rowIndex);
                    } else if (rowIndex > 0) {
                        DynamicObject treeTaxRateObj = (DynamicObject)this.getModel().getValue("treerateobj", rowIndex - 1);
                        this.getModel().setValue("treerateobj", (Object)treeTaxRateObj, rowIndex);
                    }
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                }
                String payDirection = (String)this.getModel().getValue("paydirection");
                if (payDirection == null || !payDirection.equals(PayDirectionEnum.OUT.getValue()) || (strategicAgreement = this.getModel().getDataEntity().getDynamicObject("strategicagreement")) == null) break;
                DynamicObject newTreeMaterial = (DynamicObject)propValue;
                Object treeMaterialId = newTreeMaterial.getPkValue();
                DynamicObjectCollection priceDetailEntry = strategicAgreement.getDynamicObjectCollection("pricedetailentry");
                if (priceDetailEntry.isEmpty()) break;
                for (DynamicObject row : priceDetailEntry) {
                    Object materielId = row.get("materiel_id");
                    if (null == materielId || !treeMaterialId.equals(materielId)) continue;
                    this.getModel().setValue("treetaxprice", (Object)row.getBigDecimal("pricewithtax"), rowIndex);
                    this.getModel().setValue("treerateobj", (Object)row.getDynamicObject("tax"), rowIndex);
                    this.getModel().setValue("treeprice", (Object)row.getBigDecimal("pricewithouttax"), rowIndex);
                }
                break;
            }
            case "treeamount": 
            case "treetax": 
            case "treeoftax": {
                BigDecimal oldVal = oldValue == null ? BigDecimal.ZERO : (BigDecimal)oldValue;
                this.sumToParent(propName, (BigDecimal)propValue, oldVal, rowIndex);
                needSumModelEntry = true;
                break;
            }
            case "taxrate": {
                boolean isMutiRate = (Boolean)this.getModel().getValue("ismultirate");
                boolean isOnList = (Boolean)this.getModel().getValue("isonlist");
                if (isMutiRate || !isOnList) break;
                this.calculateRateRelateData(propValue);
                break;
            }
            case "isonlist": {
                this.setIsShowListingPanel();
                break;
            }
            case "treesysnumber": {
                if (!StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("curModelRow"))) break;
                curModelRow = Integer.parseInt(this.getPageCache().get("curModelRow"));
                HashSet<String> sysNumSet = new HashSet<String>();
                DynamicObjectCollection listmodelEntry = this.getModel().getEntryEntity("listmodelentry");
                DynamicObjectCollection subListEntry = ((DynamicObject)listmodelEntry.get(curModelRow)).getDynamicObjectCollection("sublistentry");
                for (int i = 0; i < subListEntry.size(); ++i) {
                    DynamicObject subListEntryObj = (DynamicObject)subListEntry.get(i);
                    String subSysNumber = subListEntryObj.getString("sysnumber");
                    if (StringUtils.isEmpty((CharSequence)subSysNumber) || i == rowIndex) continue;
                    sysNumSet.add(subSysNumber);
                }
                if (propValue == null || !sysNumSet.contains(propValue.toString())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ContractTreeListingPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("treesysnumber", oldValue, rowIndex);
                return;
            }
            case "ismultirate": {
                boolean isMulRate;
                String flag = this.getPageCache().get("autoFlag");
                this.getPageCache().remove("autoFlag");
                if (flag == null) {
                    this.getPageCache().put("ismultirate", "ture");
                }
                if (isMulRate = ((Boolean)propValue).booleanValue()) break;
                boolean isonList = (Boolean)this.getModel().getValue("isonlist");
                if (isonList) {
                    this.calculateRateRelateData(null);
                    break;
                }
                this.getModel().setValue("taxamount", (Object)0);
                this.getModel().setValue("originalamount", this.getModel().getValue("originaloftaxamount"));
                break;
            }
            case "treeqty": {
                boolean isEnterAmount = (Boolean)this.getModel().getValue("isenteramount");
                if (isEnterAmount) {
                    if (propValue != null && ((BigDecimal)propValue).compareTo(BigDecimal.ZERO) != 0) break;
                    this.getModel().setValue("treetaxprice", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("treeprice", (Object)BigDecimal.ZERO, rowIndex);
                    break;
                }
                if (propValue != null && ((BigDecimal)propValue).compareTo(BigDecimal.ZERO) != 0) break;
                this.getModel().setValue("treetax", (Object)BigDecimal.ZERO, rowIndex);
                break;
            }
        }
        ContractListUpdateTreeListPlugin contractListUpdateTreeListPlugin = new ContractListUpdateTreeListPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)contractListUpdateTreeListPlugin, IContractListUpdateTreeListPlugin.class, (String)"kd.pmgt.pmct.business.sdk.Interface.IContractListUpdateTreeListPlugin", null);
        List returnRes = pluginProxy.callReplaceIfPresent(IContractListUpdateTreeListPlugin::updateListToTreeListSet);
        List entryProsList = new ArrayList();
        if (returnRes.size() > 0) {
            entryProsList = (List)returnRes.get(0);
        }
        if (entryProsList.contains(propName)) {
            String key = propName.substring(4);
            curModelRow = Integer.parseInt(this.getPageCache().get("curModelRow"));
            if (propValue != null) {
                if ("treelistname".equals(propName)) {
                    LocaleDynamicObjectCollection val = (LocaleDynamicObjectCollection)propValue;
                    this.getModel().setValue(key, ((DynamicObject)val.get(0)).get("treelistname"), rowIndex, curModelRow);
                } else if ("treelistingbudgetitem".equals(propName)) {
                    DynamicObjectCollection listModelEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("listmodelentry");
                    DynamicObjectCollection subListEntry = ((DynamicObject)listModelEntry.get(curModelRow)).getDynamicObjectCollection("sublistentry");
                    if (subListEntry.size() == rowIndex) {
                        this.doNewTreeEntryOperation(propValue);
                    }
                    this.getModel().setValue(key, propValue, rowIndex, curModelRow);
                } else {
                    this.getModel().setValue(key, propValue, rowIndex, curModelRow);
                }
            } else if ("treelistingbudgetitem".equals(propName)) {
                this.getModel().setValue(key, null, rowIndex, curModelRow);
            }
        }
        if (needSumModelEntry) {
            curModelRow = Integer.parseInt(this.getPageCache().get("curModelRow"));
            this.sumListModelEntry(curModelRow);
        }
    }

    protected void calculateRateRelateData(Object propValue) {
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject taxRateObj = (DynamicObject)propValue;
        if (propValue != null) {
            taxRate = taxRateObj.getBigDecimal("taxrate");
        } else {
            taxRateObj = null;
        }
        int modelRowCount = this.getModel().getEntryRowCount("listmodelentry");
        for (int i = 0; i < modelRowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex("listmodelentry", i);
            int subRowCount = this.getModel().getEntryRowCount("sublistentry");
            for (int j = 0; j < subRowCount; ++j) {
                this.getModel().setValue("rate", (Object)taxRate, j, i);
                this.getModel().setValue("rateobj", (Object)taxRateObj, j, i);
            }
            DynamicObjectCollection subEntryCol = this.getModel().getEntryEntity("sublistentry");
            this.sumSubEntryParentRow(subEntryCol);
            this.getView().updateView("sublistentry");
        }
        int treeRowCount = this.getModel().getEntryRowCount("treelistentry");
        for (int i = 0; i < treeRowCount; ++i) {
            this.getModel().setValue("treerateobj", (Object)taxRateObj, i);
            this.getModel().setValue("treerate", (Object)taxRate, i);
        }
        if (modelRowCount == 1) {
            CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
            cardEntry.entryRowClick(Integer.valueOf(0));
            cardEntry.selectRows(0, true);
        }
        if (modelRowCount > 0 && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("curModelRow"))) {
            int curModelRow = Integer.parseInt(this.getPageCache().get("curModelRow"));
            CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
            cardEntry.selectRows(curModelRow);
        }
        int modelEntryRowCount = this.getModel().getEntryRowCount("listmodelentry");
        for (int k = 0; k < modelEntryRowCount; ++k) {
            this.sumListModelEntry(k);
        }
    }

    protected boolean isTreeList() {
        return true;
    }

    private void initTreeListEntry(int rowIndex) {
        String pid;
        String id;
        Object pkValue;
        DynamicObject listEntryRow;
        Object contractId;
        boolean exists;
        this.getModel().deleteEntryData("treelistentry");
        DynamicObjectCollection subListEntry = this.getModel().getEntryEntity("sublistentry");
        DynamicObjectCollection treeListEntry = this.getModel().getEntryEntity("treelistentry");
        DynamicObjectType dt = treeListEntry.getDynamicObjectType();
        if (subListEntry == null) {
            return;
        }
        HashMap<String, BigDecimal> parentOfTaxAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> parentTaxAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> parentAmtMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject subListEntryRow : subListEntry) {
            String listParentId = subListEntryRow.getString("listparentid");
            if (StringUtils.isEmpty((CharSequence)listParentId)) continue;
            BigDecimal parentOfTax = (BigDecimal)parentOfTaxAmtMap.get(listParentId);
            BigDecimal subOfTax = subListEntryRow.getBigDecimal("oftax");
            parentOfTax = parentOfTax != null ? parentOfTax.add(subOfTax) : subOfTax;
            parentOfTaxAmtMap.put(listParentId, parentOfTax);
            BigDecimal parentTax = (BigDecimal)parentTaxAmtMap.get(listParentId);
            BigDecimal subTax = subListEntryRow.getBigDecimal("tax");
            parentTax = parentTax != null ? parentTax.add(subTax) : subTax;
            parentTaxAmtMap.put(listParentId, parentTax);
            BigDecimal parentAmt = (BigDecimal)parentAmtMap.get(listParentId);
            BigDecimal subAmount = subListEntryRow.getBigDecimal("amount");
            parentAmt = parentAmt != null ? parentAmt.add(subAmount) : subAmount;
            parentAmtMap.put(listParentId, parentAmt);
        }
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        String paydirection = (String)this.getModel().getValue("paydirection");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter paydirectionFilter = new QFilter("paydirection", "=", (Object)paydirection);
        QFilter taxratechangeFilter = new QFilter("taxratechange", "=", (Object)DefaultEnum.YES.getValue());
        QFilter contractFilter = new QFilter("contract", "=", this.getModel().getValue("id"));
        DynamicObject[] contChanges = BusinessDataServiceHelper.load((String)"pmct_revisiontpl", (String)"taxrate", (QFilter[])new QFilter[]{statusFilter, paydirectionFilter, taxratechangeFilter, contractFilter}, (String)"auditdate asc");
        boolean isRateChange = false;
        DynamicObject taxRateObj = null;
        BigDecimal taxRateVal = null;
        HashMap<Object, DynamicObject> listIdToListMap = new HashMap<Object, DynamicObject>(contChanges.length);
        if (contChanges.length > 0) {
            if (isMultiRate) {
                Set listIdSet = subListEntry.stream().filter(entry -> entry.getBoolean("isleaf")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                Set contChangeIdSet = Arrays.stream(contChanges).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                for (DynamicObject contChange : contChanges = BusinessDataServiceHelper.load((Object[])contChangeIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_revisiontpl"))) {
                    DynamicObjectCollection listCardEntry = contChange.getDynamicObjectCollection("kapianentry");
                    if (listCardEntry.size() <= 0) continue;
                    DynamicObject listCardRow = (DynamicObject)listCardEntry.get(rowIndex);
                    DynamicObjectCollection listEntry = listCardRow.getDynamicObjectCollection("entryentity");
                    for (DynamicObject listEntryRow2 : listEntry) {
                        DynamicObject listObj = listEntryRow2.getDynamicObject("listid");
                        Object listPkValue = listObj.getPkValue();
                        if (!listIdSet.contains(listPkValue) || listIdToListMap.containsKey(listPkValue)) continue;
                        listIdToListMap.put(listPkValue, listEntryRow2);
                    }
                }
                if (!listIdToListMap.isEmpty()) {
                    isRateChange = true;
                }
            } else {
                isRateChange = true;
                taxRateObj = contChanges[0].getDynamicObject("taxrate");
                taxRateVal = taxRateObj.getBigDecimal("taxrate");
            }
        }
        if (exists = QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)(contractId = this.getModel().getDataEntity().getPkValue()))) {
            for (DynamicObject subListEntryRow : subListEntry) {
                DynamicObject listing = new DynamicObject(dt);
                listEntryRow = null;
                if (isRateChange && isMultiRate && (listEntryRow = (DynamicObject)listIdToListMap.get(pkValue = subListEntryRow.getPkValue())) != null) {
                    taxRateObj = listEntryRow.getDynamicObject("rateobj");
                    taxRateVal = listEntryRow.getBigDecimal("taxrate1");
                }
                listing.set("treesysnumber", subListEntryRow.get("sysnumber"));
                listing.set("treelistnumber", subListEntryRow.get("listnumber"));
                listing.set("treematerial", subListEntryRow.get("material"));
                listing.set("treemeasureunit", subListEntryRow.get("measureunit"));
                listing.set("treeqty", subListEntryRow.get("qty"));
                listing.set("treetaxprice", subListEntryRow.get("taxprice"));
                if (!isRateChange || listEntryRow == null) {
                    listing.set("treerate", subListEntryRow.get("rate"));
                } else {
                    listing.set("treerate", (Object)taxRateVal);
                }
                id = subListEntryRow.getString("id");
                if (parentAmtMap.get(id) != null) {
                    listing.set("treeamount", parentAmtMap.get(id));
                } else {
                    listing.set("treeamount", subListEntryRow.get("amount"));
                }
                if (parentOfTaxAmtMap.get(id) != null) {
                    listing.set("treeoftax", parentOfTaxAmtMap.get(id));
                } else {
                    listing.set("treeoftax", subListEntryRow.get("oftax"));
                }
                if (parentTaxAmtMap.get(id) != null) {
                    listing.set("treetax", parentTaxAmtMap.get(id));
                } else {
                    listing.set("treetax", subListEntryRow.get("tax"));
                }
                listing.set("treeprice", subListEntryRow.get("price"));
                listing.set("treedesc", subListEntryRow.get("desc"));
                listing.set("treeisleaf", subListEntryRow.get("isleaf"));
                listing.set("treelistname", subListEntryRow.get("listname"));
                if (!isRateChange || listEntryRow == null) {
                    listing.set("treerateobj", subListEntryRow.get("rateobj"));
                } else {
                    listing.set("treerateobj", (Object)taxRateObj);
                }
                listing.set("treelistingbudgetitem", subListEntryRow.get("listingbudgetitem"));
                pid = "0";
                if (subListEntryRow.get("listparentid") != null && !"".equals(subListEntryRow.get("listparentid"))) {
                    pid = String.valueOf(subListEntryRow.get("listparentid"));
                }
                listing.set("pid", (Object)pid);
                listing.set("id", (Object)subListEntryRow.getString("id"));
                listing.set("seq", subListEntryRow.get("seq"));
                treeListEntry.add((Object)listing);
            }
            this.getModel().updateEntryCache(treeListEntry);
        } else {
            this.getModel().beginInit();
            for (DynamicObject subListEntryRow : subListEntry) {
                int newEntryRow = this.getModel().createNewEntryRow("treelistentry");
                listEntryRow = null;
                if (isRateChange && isMultiRate && (listEntryRow = (DynamicObject)listIdToListMap.get(pkValue = subListEntryRow.getPkValue())) != null) {
                    taxRateObj = listEntryRow.getDynamicObject("rateobj");
                    taxRateVal = listEntryRow.getBigDecimal("taxrate1");
                }
                this.getModel().setValue("treesysnumber", subListEntryRow.get("sysnumber"), newEntryRow);
                this.getModel().setValue("treelistnumber", subListEntryRow.get("listnumber"), newEntryRow);
                this.getModel().setValue("treematerial", subListEntryRow.get("material"), newEntryRow);
                this.getModel().setValue("treemeasureunit", subListEntryRow.get("measureunit"), newEntryRow);
                this.getModel().setValue("treeqty", subListEntryRow.get("qty"), newEntryRow);
                this.getModel().setValue("treetaxprice", subListEntryRow.get("taxprice"), newEntryRow);
                if (!isRateChange || listEntryRow == null) {
                    this.getModel().setValue("treerate", subListEntryRow.get("rate"), newEntryRow);
                } else {
                    this.getModel().setValue("treerate", (Object)taxRateVal, newEntryRow);
                }
                id = subListEntryRow.getString("id");
                if (parentAmtMap.get(id) != null) {
                    this.getModel().setValue("treeamount", parentAmtMap.get(id), newEntryRow);
                } else {
                    this.getModel().setValue("treeamount", subListEntryRow.get("amount"), newEntryRow);
                }
                if (parentOfTaxAmtMap.get(id) != null) {
                    this.getModel().setValue("treeoftax", parentOfTaxAmtMap.get(id), newEntryRow);
                } else {
                    this.getModel().setValue("treeoftax", subListEntryRow.get("oftax"), newEntryRow);
                }
                if (parentTaxAmtMap.get(id) != null) {
                    this.getModel().setValue("treetax", parentTaxAmtMap.get(id), newEntryRow);
                } else {
                    this.getModel().setValue("treetax", subListEntryRow.get("tax"), newEntryRow);
                }
                this.getModel().setValue("treeprice", subListEntryRow.get("price"), newEntryRow);
                this.getModel().setValue("treedesc", subListEntryRow.get("desc"), newEntryRow);
                this.getModel().setValue("treeisleaf", subListEntryRow.get("isleaf"), newEntryRow);
                this.getModel().setValue("treelistname", subListEntryRow.get("listname"), newEntryRow);
                if (!isRateChange || listEntryRow == null) {
                    this.getModel().setValue("treerateobj", subListEntryRow.get("rateobj"), newEntryRow);
                } else {
                    this.getModel().setValue("treerateobj", (Object)taxRateObj, newEntryRow);
                }
                this.getModel().setValue("treelistingbudgetitem", subListEntryRow.get("listingbudgetitem"), newEntryRow);
                pid = "0";
                if (subListEntryRow.get("listparentid") != null && !"".equals(subListEntryRow.get("listparentid"))) {
                    pid = String.valueOf(subListEntryRow.get("listparentid"));
                }
                this.getModel().setValue("pid", (Object)pid, newEntryRow);
                ((DynamicObject)this.getModel().getEntryEntity("treelistentry").get(newEntryRow)).set("id", subListEntryRow.getPkValue());
            }
            this.getModel().endInit();
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
        grid.setCollapse(false);
        this.getView().updateView("treelistentry");
    }

    private void openUploadPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmct_importcontractexcel");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importExcelClosed"));
        this.getView().showForm(showParameter);
    }

    private void doNewTreeEntryOperation(Object budgetItem) {
        int index = this.getModel().createNewEntryRow("sublistentry");
        DynamicObject rowObject = this.getModel().getEntryRowEntity("sublistentry", index);
        ORM orm = ORM.create();
        long listingId = orm.genLongId("pmct_contractlist");
        rowObject.set("id", (Object)listingId);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treelistentry", index);
        if (entryRowEntity != null) {
            entryRowEntity.set("id", (Object)listingId);
        }
        this.getModel().setValue("level", (Object)1, index);
        this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
        this.getModel().setValue("treeisleaf", (Object)Boolean.TRUE, index);
        String subListModelId = (String)this.getModel().getValue("listmodelid", Integer.parseInt(this.getPageCache().get("curModelRow")));
        this.getModel().setValue("sublistmodelid", (Object)subListModelId, index);
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        if (!isMultiRate) {
            DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
            this.getModel().setValue("treerateobj", (Object)taxRateObj, index);
        } else if (index > 0) {
            DynamicObject treeTaxRateObj = (DynamicObject)this.getModel().getValue("treerateobj", index - 1);
            this.getModel().setValue("treerateobj", (Object)treeTaxRateObj, index);
        }
        String sysNum = this.genSysNumber("addnew", index);
        this.getModel().setValue("treesysnumber", (Object)sysNum, index);
        if (budgetItem != null) {
            this.getModel().setValue("treelistingbudgetitem", ((DynamicObject)budgetItem).getPkValue(), index);
        } else {
            this.setDefaultBudgetItem(index);
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
        grid.selectRows(-1);
        this.getModel().getEntryRowEntity("treelistentry", 0).set("isGroupNode", (Object)Boolean.FALSE);
        this.getModel().updateCache();
    }

    private void doInsertTreeEntryOperation(int parentIndex) {
        int paretnIndex = Integer.parseInt(this.getPageCache().get("insertIndex"));
        int curTreeIndex = parentIndex;
        int subEntryRowCount = this.getModel().getEntryRowCount("sublistentry");
        int newRowIndex = -1;
        if (curTreeIndex >= subEntryRowCount) {
            newRowIndex = this.getModel().createNewEntryRow("sublistentry");
        } else if (curTreeIndex > 0) {
            newRowIndex = this.getModel().insertEntryRow("sublistentry", curTreeIndex);
        }
        DynamicObject insertObject = this.getModel().getEntryRowEntity("sublistentry", newRowIndex);
        ORM orm = ORM.create();
        long listingId = orm.genLongId("pmct_contractlist");
        insertObject.set("id", (Object)listingId);
        this.getModel().getEntryRowEntity("treelistentry", newRowIndex).set("id", (Object)listingId);
        DynamicObject parentObj = this.getModel().getEntryRowEntity("sublistentry", paretnIndex);
        if (parentObj != null) {
            this.getModel().setValue("level", (Object)(parentObj.getInt("level") + 1), newRowIndex);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("treeisleaf", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("parent", parentObj.getPkValue(), newRowIndex);
            this.getModel().setValue("listparentid", (Object)parentObj.getPkValue().toString(), newRowIndex);
            this.getModel().getEntryRowEntity("sublistentry", newRowIndex).set("parent", (Object)parentObj);
            this.getModel().getEntryRowEntity("sublistentry", newRowIndex).set("listparentid", (Object)parentObj.getPkValue().toString());
        }
        this.getModel().setValue("isleaf", (Object)Boolean.FALSE, paretnIndex);
        this.getModel().setValue("treeisleaf", (Object)Boolean.FALSE, paretnIndex);
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        if (!isMultiRate) {
            DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
            this.getModel().setValue("treerateobj", (Object)taxRateObj, newRowIndex);
        } else if (newRowIndex > 0) {
            DynamicObject treeTaxRateObj = (DynamicObject)this.getModel().getValue("treerateobj", newRowIndex - 1);
            this.getModel().setValue("treerateobj", (Object)treeTaxRateObj, newRowIndex);
        }
        String sysNumber = this.genSysNumber("insert", newRowIndex);
        this.getModel().setValue("treesysnumber", (Object)sysNumber, newRowIndex);
        String subListModelId = (String)this.getModel().getValue("listmodelid", Integer.parseInt(this.getPageCache().get("curModelRow")));
        this.getModel().setValue("sublistmodelid", (Object)subListModelId, newRowIndex);
        this.setDefaultBudgetItem(newRowIndex);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
        grid.selectRows(-1);
    }

    private void doDeleteTreeEntryOperation() {
        if (this.getPageCache().get("delIndex") != null) {
            String delIndexString = this.getPageCache().get("delIndex");
            this.getPageCache().remove("delIndex");
            String[] indexStrArr = delIndexString.split(",");
            DynamicObjectCollection subListEntry = this.getModel().getEntryEntity("sublistentry");
            for (int k = indexStrArr.length - 1; k >= 0; --k) {
                int delIndex = Integer.parseInt(indexStrArr[k]);
                if (delIndex >= subListEntry.size()) continue;
                DynamicObject parentObj = null;
                String listParentId = (String)this.getModel().getValue("listparentid", delIndex);
                int parentIndex = -1;
                if (listParentId != null) {
                    for (int i = delIndex - 1; i >= 0; --i) {
                        String curRowId = this.getModel().getEntryRowEntity("sublistentry", i).getString("id");
                        if (!listParentId.equals(curRowId)) continue;
                        parentObj = this.getModel().getEntryRowEntity("sublistentry", i);
                        parentIndex = i;
                        break;
                    }
                }
                if (parentObj != null) {
                    int rowCount = this.getModel().getEntryRowCount("sublistentry");
                    boolean isOnlyChild = true;
                    for (int i = parentIndex + 1; i < rowCount; ++i) {
                        String curParentId;
                        if (i == delIndex || !listParentId.equals(curParentId = (String)this.getModel().getValue("listparentid", i))) continue;
                        isOnlyChild = false;
                        break;
                    }
                    if (isOnlyChild) {
                        this.getModel().setValue("isleaf", (Object)Boolean.TRUE, parentIndex);
                        if (!Arrays.asList(indexStrArr).contains(String.valueOf(parentIndex))) {
                            this.getModel().setValue("treeisleaf", (Object)Boolean.TRUE, parentIndex);
                            boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
                            if (!isMultiRate) {
                                DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate");
                                this.getModel().setValue("treerateobj", (Object)rateObj, parentIndex);
                            }
                        }
                    }
                    this.sumRowToParent(parentIndex);
                }
                this.getModel().deleteEntryRow("sublistentry", delIndex);
            }
        }
    }

    private void doAfterSaveAndSubmitOperation() {
        int rowCount = this.getModel().getEntryRowCount("listmodelentry");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject listModel = this.getModel().getEntryRowEntity("listmodelentry", i);
            DynamicObjectCollection listings = listModel.getDynamicObjectCollection("sublistentry");
            String contId = this.getModel().getDataEntity().getPkValue().toString();
            if (listings == null || listings.isEmpty()) continue;
            Object[] listingsArr = new DynamicObject[listings.size()];
            for (int j = 0; j < listings.size(); ++j) {
                DynamicObject listing = (DynamicObject)listings.get(j);
                listing = BusinessDataServiceHelper.loadSingle((Object)listing.getString("id"), (String)"pmct_contractlist");
                listing.set("contractid", (Object)contId);
                listing.set("totalqty", (Object)listing.getBigDecimal("qty"));
                listing.set("lstoftaxamount", (Object)listing.getBigDecimal("oftax"));
                listing.set("latestamount", (Object)listing.getBigDecimal("amount"));
                BigDecimal taxprice = listing.getBigDecimal("taxprice");
                listing.set("avgtaxprice", (Object)taxprice);
                listing.set("curtaxprice", (Object)taxprice);
                if (listing.getString("listparentid") != null && !"".equals(listing.getString("listparentid").trim()) && !"0".equals(listing.getString("listparentid"))) {
                    listing.set("parent", (Object)listing.getString("listparentid"));
                }
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                listing.set("currency", (Object)currency);
                String payDirection = (String)this.getModel().getValue("paydirection");
                listing.set("paydirection", (Object)payDirection);
                listingsArr[j] = listing;
            }
            SaveServiceHelper.save((IDataEntityType)listingsArr[0].getDynamicObjectType(), (Object[])listingsArr);
        }
    }

    private void setIsShowListingPanel() {
        IDataModel model = this.getModel();
        boolean isOnlist = (Boolean)model.getValue("isonlist");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (null == model.getValue("contracttype")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{"isonlist"});
            return;
        }
        if (isOnlist) {
            DynamicObjectCollection listConfigs = dataEntity.getDynamicObjectCollection("listmodelentry");
            this.getView().setEnable(Boolean.TRUE, new String[]{"isonlist"});
            if (listConfigs == null || listConfigs.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
                return;
            }
            if (listConfigs.size() == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{LISTPANEL});
            } else if (listConfigs.size() > 1) {
                this.getView().setVisible(Boolean.TRUE, new String[]{LISTPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"listmodelentry"});
            }
            DynamicObject taxRateObj = (DynamicObject)model.getValue("taxrate");
            BigDecimal taxrate = taxRateObj == null ? BigDecimal.ZERO : taxRateObj.getBigDecimal("taxrate");
            DynamicObjectCollection listModelEntry = model.getEntryEntity("listmodelentry");
            boolean reset = true;
            for (DynamicObject listModelEntryObj : listModelEntry) {
                DynamicObjectCollection curSubListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
                if (curSubListEntry.isEmpty()) continue;
                reset = false;
                break;
            }
            if (reset) {
                for (DynamicObject listModelEntryObj : listModelEntry) {
                    listModelEntryObj.set("rowtaxrate", (Object)taxrate);
                }
                model.setValue("originaloftaxamount", null);
                model.setValue("originalamount", null);
                model.setValue("taxamount", null);
                this.getView().updateView("listmodelentry");
                CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
                cardEntry.entryRowClick(Integer.valueOf(0));
                cardEntry.selectRows(0, true);
            }
            this.getPageCache().put("curModelRow", "0");
        } else {
            DynamicObjectCollection curSubListEntry;
            this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
            DynamicObjectCollection listModelEntry = model.getEntryEntity("listmodelentry");
            DynamicObjectCollection subListEntry = model.getEntryEntity("sublistentry");
            boolean reset = false;
            for (DynamicObject listModelEntryObj : listModelEntry) {
                curSubListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
                if (curSubListEntry.isEmpty()) continue;
                reset = true;
                break;
            }
            if (reset) {
                for (DynamicObject listModelEntryObj : listModelEntry) {
                    listModelEntryObj.set("rowoftax", null);
                    listModelEntryObj.set("rowamount", null);
                    listModelEntryObj.set("rowtax", null);
                    curSubListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
                    curSubListEntry.clear();
                }
                model.deleteEntryData("treelistentry");
                this.getModel().updateEntryCache(listModelEntry);
                this.getModel().updateEntryCache(subListEntry);
                this.getView().updateView("listmodelentry");
                this.getView().updateView("sublistentry");
                this.getView().updateView("treelistentry");
            }
        }
    }

    protected void onContractTypeChange() {
        this.getModel().deleteEntryData("treelistentry");
        this.getModel().deleteEntryData("listmodelentry");
        this.clearHeadAmount();
        DynamicObject contType = (DynamicObject)this.getModel().getValue("contracttype");
        if (contType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
            this.getModel().setValue("isonlist", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isonlist"});
            return;
        }
        if (!contType.getBoolean("isonlist")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isonlist"});
            this.getModel().setValue("isonlist", (Object)Boolean.FALSE);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isonlist"});
            this.getModel().setValue("isonlist", (Object)Boolean.TRUE);
        }
        DynamicObjectCollection listConfigs = ContractTypeUtils.getListConfigs((DynamicObject)contType);
        if (listConfigs == null || listConfigs.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
            return;
        }
        if (listConfigs.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
            this.getPageCache().put("curModelRow", "0");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"listmodelentry"});
        }
        boolean isOnlist = (Boolean)this.getModel().getValue("isonlist");
        if (!isOnlist) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LISTPANEL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LISTPANEL});
        }
        for (DynamicObject listConfig : listConfigs) {
            String tabname = listConfig.getString("tabname");
            String cmpRule = listConfig.getString("computerule");
            int rowIndex = this.getModel().createNewEntryRow("listmodelentry");
            this.getModel().setValue("modelname", (Object)tabname, rowIndex);
            this.getModel().setValue("listmodelid", listConfig.getPkValue(), rowIndex);
            if ("00".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(+)", rowIndex);
            } else if ("01".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(-)", rowIndex);
            } else if ("02".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(0)", rowIndex);
            }
            this.getModel().setEntryCurrentRowIndex("listmodelentry", rowIndex);
        }
        CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
        cardEntry.selectRows(0, true);
    }

    protected void clearHeadAmount() {
        this.getModel().beginInit();
        this.getModel().setValue("originaloftaxamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("originalamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("taxamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("totaloftaxamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("avgtaxrate", (Object)BigDecimal.ZERO);
        this.getModel().setValue("signamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("stdoriginalamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("stdtaxamount", (Object)BigDecimal.ZERO);
        this.getModel().endInit();
        this.getView().updateView("originaloftaxamount");
        this.getView().updateView("originalamount");
        this.getView().updateView("taxamount");
        this.getView().updateView("totaloftaxamount");
        this.getView().updateView("totalamount");
        this.getView().updateView("avgtaxrate");
        this.getView().updateView("signamount");
        this.getView().updateView("stdoriginalamount");
        this.getView().updateView("stdtaxamount");
    }

    private void doMaterialChange(int rowIndex) {
        int subEntryRowCount = this.getModel().getEntryRowCount("sublistentry");
        DynamicObject treeRowEntity = this.getModel().getEntryRowEntity("treelistentry", rowIndex);
        int parentIndex = -1;
        if (treeRowEntity.getBoolean("treeisleaf")) {
            String parentId = treeRowEntity.getString("pid");
            for (int i = rowIndex - 1; i >= 0; --i) {
                String curRowId = this.getModel().getEntryRowEntity("sublistentry", i).getString("id");
                if (!parentId.equals(curRowId)) continue;
                parentIndex = i;
                break;
            }
        }
        if (rowIndex + 1 > subEntryRowCount) {
            if (parentIndex >= 0) {
                this.insertMaterialRow(rowIndex, parentIndex);
            } else {
                this.doNewTreeEntryOperation(null);
            }
        }
    }

    private void insertMaterialRow(int rowInsertIndex, int parentIndex) {
        int newRowIndex = this.getModel().insertEntryRow("sublistentry", rowInsertIndex);
        DynamicObject insertObject = this.getModel().getEntryRowEntity("sublistentry", newRowIndex);
        ORM orm = ORM.create();
        long listingId = orm.genLongId("pmct_contractlist");
        insertObject.set("id", (Object)listingId);
        this.getModel().getEntryRowEntity("treelistentry", newRowIndex).set("id", (Object)listingId);
        if (parentIndex >= 0) {
            DynamicObject treeRowObj = this.getModel().getEntryRowEntity("sublistentry", parentIndex);
            int parentLevel = treeRowObj.getInt("level");
            this.getModel().setValue("level", (Object)(parentLevel + 1), newRowIndex);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("listparentid", (Object)treeRowObj.getString("id"), newRowIndex);
        } else {
            this.getModel().setValue("level", (Object)1, newRowIndex);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("parent", null, newRowIndex);
        }
        String sysNumber = this.genSysNumber("insert", newRowIndex);
        this.getModel().setValue("treesysnumber", (Object)sysNumber, newRowIndex);
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        if (!isMultiRate) {
            DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
            this.getModel().setValue("treerateobj", (Object)taxRateObj, newRowIndex);
        } else if (newRowIndex > 0) {
            DynamicObject treeTaxRateObj = (DynamicObject)this.getModel().getValue("treerateobj", newRowIndex - 1);
            this.getModel().setValue("treerateobj", (Object)treeTaxRateObj, newRowIndex);
        }
        String subListModelId = (String)this.getModel().getValue("listmodelid", Integer.parseInt(this.getPageCache().get("curModelRow")));
        this.getModel().setValue("sublistmodelid", (Object)subListModelId, newRowIndex);
    }

    private void sumToParent(String propName, BigDecimal newAmount, BigDecimal oldAmount, int index) {
        String parentId = String.valueOf(this.getModel().getValue("pid", index));
        if (parentId == null) {
            return;
        }
        for (int i = index - 1; i >= 0; --i) {
            String curRowId = this.getModel().getEntryRowEntity("treelistentry", i).getString("id");
            if (!parentId.equals(curRowId)) continue;
            BigDecimal curAmount = (BigDecimal)this.getModel().getValue(propName, i);
            this.getModel().setValue(propName, (Object)newAmount.add(curAmount).subtract(oldAmount), i);
            break;
        }
    }

    private void sumRowToParent(int parentIndex) {
        String rowParentId;
        int treeEntryRowCount = this.getModel().getEntryRowCount("treelistentry");
        if (this.getModel().getEntryRowEntity("treelistentry", parentIndex) == null) {
            return;
        }
        String parentId = this.getModel().getEntryRowEntity("treelistentry", parentIndex).getString("id");
        BigDecimal parentOfTax = BigDecimal.ZERO;
        BigDecimal parentAmount = BigDecimal.ZERO;
        BigDecimal parentTax = BigDecimal.ZERO;
        for (int i = parentIndex + 1; i < treeEntryRowCount && parentId.equals(rowParentId = this.getModel().getEntryRowEntity("treelistentry", i).getString("pid")); ++i) {
            BigDecimal rowOfTax = (BigDecimal)this.getModel().getValue("treeoftax", i);
            BigDecimal rowAmount = (BigDecimal)this.getModel().getValue("treeamount", i);
            BigDecimal rowTax = (BigDecimal)this.getModel().getValue("treetax", i);
            parentOfTax = parentOfTax.add(rowOfTax);
            parentAmount = parentAmount.add(rowAmount);
            parentTax = parentTax.add(rowTax);
        }
        this.getModel().setValue("treeoftax", (Object)parentOfTax, parentIndex);
        this.getModel().setValue("treeamount", (Object)parentAmount, parentIndex);
        this.getModel().setValue("treetax", (Object)parentTax, parentIndex);
    }

    private void sumListModelEntry(int rowIndex) {
        boolean isMultiRate;
        DynamicObject modelEntry = this.getModel().getEntryRowEntity("listmodelentry", rowIndex);
        DynamicObjectCollection subListEntrys = modelEntry.getDynamicObjectCollection("sublistentry");
        int rowCount = subListEntrys.size();
        BigDecimal oftax = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            boolean istreeleaf = ((DynamicObject)subListEntrys.get(i)).getBoolean("isleaf");
            if (!istreeleaf) continue;
            BigDecimal rowOftax = ((DynamicObject)subListEntrys.get(i)).getBigDecimal("oftax");
            oftax = oftax.add(rowOftax);
            BigDecimal rowAmount = ((DynamicObject)subListEntrys.get(i)).getBigDecimal("amount");
            amount = amount.add(rowAmount);
        }
        BigDecimal tax = oftax.subtract(amount);
        BigDecimal rowTaxrate = BigDecimal.ZERO;
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            rowTaxrate = rowCount == 1 ? ((DynamicObject)subListEntrys.get(0)).getBigDecimal("rate") : tax.divide(amount, 4, 4).multiply(BigDecimal.valueOf(100L));
        }
        if (isMultiRate = this.getModel().getDataEntity().getBoolean("ismultirate")) {
            this.getModel().setValue("rowtaxrate", (Object)rowTaxrate, rowIndex);
        }
        this.getModel().setValue("rowamount", (Object)amount, rowIndex);
        this.getModel().setValue("rowtax", (Object)tax, rowIndex);
        this.getModel().setValue("rowoftax", (Object)oftax, rowIndex);
        this.sumHeadAmount();
        this.headAmount2Entry();
    }

    private void headAmount2Entry() {
        String payDirection = (String)this.getModel().getValue("paydirection");
        String contPayPlanEntryName = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? "outcontpayplanentry" : "incontpayplanentry";
        DynamicObjectCollection contPayPlanEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(contPayPlanEntryName);
        BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
        for (int i = 0; i < contPayPlanEntries.size(); ++i) {
            DynamicObject outContPayPlanEntry = (DynamicObject)contPayPlanEntries.get(i);
            BigDecimal payPercent = outContPayPlanEntry.getBigDecimal("paypercent").divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
            BigDecimal payAmount = outContPayPlanEntry.getBigDecimal("payamount");
            this.getModel().beginInit();
            if (BigDecimal.ZERO.compareTo(payPercent) != 0) {
                this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent), i);
                this.getView().updateView("payamount", i);
            } else if (BigDecimal.ZERO.compareTo(payAmount) != 0) {
                payPercent = BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0 ? payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                this.getModel().setValue("paypercent", (Object)payPercent, i);
                this.getView().updateView("paypercent", i);
            }
            this.getModel().endInit();
        }
    }

    private void sumHeadAmount() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("listmodelentry");
        BigDecimal originalOftaxAmount = BigDecimal.ZERO;
        BigDecimal originalAmount = BigDecimal.ZERO;
        BigDecimal avgTaxrate = BigDecimal.ZERO;
        BigDecimal defaultRate = BigDecimal.valueOf(-1L);
        boolean hasSameRate = true;
        for (int i = 0; i < rowCount; ++i) {
            String cmpType = (String)model.getValue("cmptype", i);
            BigDecimal coefficient = BigDecimal.ONE;
            if ("(0)".equals(cmpType)) continue;
            if ("(-)".equals(cmpType)) {
                coefficient = BigDecimal.valueOf(-1L);
            }
            BigDecimal rowOftax = (BigDecimal)model.getValue("rowoftax", i);
            rowOftax = rowOftax.multiply(coefficient);
            originalOftaxAmount = originalOftaxAmount.add(rowOftax);
            BigDecimal rowAmount = (BigDecimal)model.getValue("rowamount", i);
            rowAmount = rowAmount.multiply(coefficient);
            originalAmount = originalAmount.add(rowAmount);
            BigDecimal rowTaxrate = (BigDecimal)model.getValue("rowtaxrate", i);
            if (BigDecimal.valueOf(-1L).compareTo(defaultRate) == 0) {
                defaultRate = rowTaxrate;
                continue;
            }
            if (defaultRate.compareTo(rowTaxrate) == 0) continue;
            hasSameRate = false;
        }
        BigDecimal taxAmount = originalOftaxAmount.subtract(originalAmount);
        if (originalAmount.compareTo(BigDecimal.ZERO) != 0) {
            avgTaxrate = hasSameRate ? defaultRate : taxAmount.divide(originalAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
        }
        model.beginInit();
        model.setValue("originaloftaxamount", (Object)originalOftaxAmount);
        model.setValue("originalamount", (Object)originalAmount);
        model.setValue("taxamount", (Object)taxAmount);
        model.setValue("totaloftaxamount", (Object)originalOftaxAmount);
        model.setValue("totalamount", (Object)originalAmount);
        model.setValue("avgtaxrate", (Object)avgTaxrate);
        model.endInit();
        this.getView().updateView("originaloftaxamount");
        this.getView().updateView("originalamount");
        this.getView().updateView("taxamount");
        this.getView().updateView("totaloftaxamount");
        this.getView().updateView("totalamount");
        this.getView().updateView("avgtaxrate");
        boolean ismulticurrency = (Boolean)model.getValue("ismulticurrency");
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        if (ismulticurrency) {
            BigDecimal signamount = originalOftaxAmount.multiply(exchangerate);
            BigDecimal stdoriginalamount = originalAmount.multiply(exchangerate);
            BigDecimal stdtaxamount = signamount.subtract(stdoriginalamount);
            model.setValue("signamount", (Object)signamount);
            model.setValue("stdoriginalamount", (Object)stdoriginalamount);
            model.setValue("stdtaxamount", (Object)stdtaxamount);
        }
    }

    private String genSysNumber(String type, int rowIndex) {
        String sysNum = null;
        if (rowIndex == 0) {
            sysNum = "001";
        } else {
            int i;
            String parentId = this.getModel().getEntryRowEntity("treelistentry", rowIndex).getString("pid");
            for (i = rowIndex - 1; i >= 0; --i) {
                String curParentId = this.getModel().getEntryRowEntity("treelistentry", i).getString("pid");
                if (!parentId.equals(curParentId)) continue;
                String num = (String)this.getModel().getValue("treesysnumber", i);
                sysNum = this.genNumber(num, i);
                break;
            }
            if (i < 0 && "insert".equals(type)) {
                for (int j = rowIndex - 1; j >= 0; --j) {
                    String curId = this.getModel().getEntryRowEntity("treelistentry", j).getString("id");
                    if (!parentId.equals(curId)) continue;
                    String parentSysNumber = (String)this.getModel().getValue("treesysnumber", j);
                    if (parentSysNumber == null || "".equals(parentSysNumber)) break;
                    sysNum = parentSysNumber + ".001";
                    break;
                }
            }
        }
        return sysNum;
    }

    private String genNumber(String num, int rowIndex) {
        String sysNum = null;
        try {
            if (num != null && !"".equals(num)) {
                int index = num.lastIndexOf(46);
                if (index < 0) {
                    int codeInt = Integer.parseInt(num);
                    sysNum = String.format("%03d", codeInt + 1);
                } else {
                    String lastCode = num.substring(index + 1, num.length());
                    num = num.substring(0, index + 1);
                    int codeInt = Integer.parseInt(lastCode);
                    String newLastCode = String.format("%03d", codeInt + 1);
                    sysNum = num + newLastCode;
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7cfb\u7edf\u7f16\u7801%2$s\u4e0d\u7b26\u5408\u5168\u6570\u5b57\u683c\u5f0f\u7f16\u7801\u89c4\u5219\u3002", (String)"ContractTreeListingPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), rowIndex + 1, num);
            this.getView().showTipNotification(errMsg);
        }
        return sysNum;
    }

    private boolean isOutContract() {
        String payDirection = this.getModel().getDataEntity().getString("paydirection");
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue());
    }

    protected void setDefaultBudgetItem(int rowIndex) {
        int rowCount = this.getModel().getEntryRowCount("treelistentry");
        DynamicObject newEntry = this.getModel().getEntryRowEntity("treelistentry", rowIndex);
        String parentId = newEntry.getString("pid");
        DynamicObject budgetItem = null;
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)parentId)) {
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("treelistentry", i);
                if (!StringUtils.equals((CharSequence)rowEntity.getPkValue().toString(), (CharSequence)parentId)) continue;
                budgetItem = rowEntity.getDynamicObject("treelistingbudgetitem");
                break;
            }
        }
        if (budgetItem == null) {
            budgetItem = this.getModel().getDataEntity().getDynamicObject("budgetitem");
        }
        if (budgetItem != null) {
            this.getModel().setValue("treelistingbudgetitem", budgetItem.getPkValue(), rowIndex);
        }
    }

    private void sumSubEntryParentRow(DynamicObjectCollection subEntryCol) {
        int size = subEntryCol.size();
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> oftaxAmountMap = new HashMap<String, BigDecimal>(8);
        for (int i = size - 1; i >= 0; --i) {
            DynamicObject subEntryInfo = (DynamicObject)subEntryCol.get(i);
            if (subEntryInfo.getBoolean("isleaf")) {
                String parentId = subEntryInfo.getString("listparentid");
                if (parentId == null || parentId.length() <= 0) continue;
                BigDecimal parentAmount = Optional.ofNullable(amountMap.get(parentId)).orElse(BigDecimal.ZERO);
                BigDecimal parentOfTaxAmount = Optional.ofNullable(oftaxAmountMap.get(parentId)).orElse(BigDecimal.ZERO);
                parentAmount = parentAmount.add(subEntryInfo.getBigDecimal("amount"));
                parentOfTaxAmount = parentOfTaxAmount.add(subEntryInfo.getBigDecimal("oftax"));
                amountMap.put(parentId, parentAmount);
                oftaxAmountMap.put(parentId, parentOfTaxAmount);
                continue;
            }
            String curRowId = subEntryInfo.getString("id");
            BigDecimal amt = Optional.ofNullable(amountMap.get(curRowId)).orElse(BigDecimal.ZERO);
            BigDecimal ofTax = Optional.ofNullable(oftaxAmountMap.get(curRowId)).orElse(BigDecimal.ZERO);
            subEntryInfo.set("amount", (Object)amt);
            subEntryInfo.set("oftax", (Object)ofTax);
            subEntryInfo.set("tax", (Object)ofTax.subtract(amt));
        }
    }
}

