/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.StringUtils;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class InContractEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final Log logger = LogFactory.getLog(InContractEditPlugin.class);
    private static final String CONTRACTSTATUS = "contractstatus";
    private static final String INCONTPAYPLANENTRY = "incontpayplanentry";
    private static final String CONTRISKENTRY = "riskentry";
    private static final String VIEWSTYLE = "viewStyle";
    private static final String INCOME_PLAN_AP = "advconap1";
    private static final String RISKPANEL = "risk_panel";
    private static final String CALLBACKDELETEINCOMEPLANENTRY = "deleteincomeplanentry";
    private static final String BTN_DEL_COMP1 = "delcomp1";
    private static final String BTN_DEL_COMP2 = "delcomp2";
    private static final String LOAD_PLAN_ENTRY_COMP = "loadplanentrycomp";
    private static final String LOAD_RISK_ITEM_COMP = "riskitem";
    private static final String BTN_SAVE = "save";
    private static final String BTN_SUBMIT = "submit";
    private static final String REFRESH_FLAG = "refreshflag";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String TEXTATTACHMENTPANEL = "textattachmentpanel";
    private static final String LASTATTACHMENTPANEL = "lastattachmentpanel";
    private static final String LASTTEXTATTACHMENTPANEL = "lasttextattachmentpanel";
    private static final String FILEFLEX = "fileflex";
    private static final String LASTFILEFLEX = "lastfileflex";
    private static final String CTRL_NEWENTRY = "newentry";
    private static final String CTRL_DELETEENTRY = "deleteentry";
    private static final String ADJUST = "adjust";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pro = (BasedataEdit)this.getView().getControl("project");
        pro.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        pro.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit contractEdit = (BasedataEdit)this.getControl("refcontract");
        contractEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("treelistingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit multiSettlePro = (BasedataEdit)this.getView().getControl("multisettlepro");
        multiSettlePro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)Boolean.TRUE)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
        BasedataEdit partA = (BasedataEdit)this.getView().getControl("parta");
        partA.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit treeMaterial = (BasedataEdit)this.getControl("treematerial");
        treeMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject org;
        super.afterBindData(e);
        String pkId = this.getModel().getValue("id").toString();
        logger.info("\u5f53\u524d\u6536\u5165\u5408\u540c\u5355\u636e\u7684\u4e3b\u952ePK\u4e3a\uff1a{}", (Object)pkId);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String viewStyle = (String)formShowParameter.getCustomParam(VIEWSTYLE);
        boolean ifExist = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        DynamicObject contractStatus = this.getModel().getDataEntity().getDynamicObject(CONTRACTSTATUS);
        if (ifExist && contractStatus != null) {
            String contStatus = this.getModel().getDataEntity().getDynamicObject(CONTRACTSTATUS).getString("number");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)viewStyle) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
                this.gainOriginalContract();
                ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
                this.getView().setVisible(Boolean.FALSE, new String[]{LASTFILEFLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tbviewoldcontract"});
            } else {
                this.gainLastNewContract();
                this.loadLastAttachment();
                this.getView().setVisible(Boolean.TRUE, new String[]{"tbviewoldcontract"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"isadjustamount", "isenteramount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEFLEX});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LASTFILEFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbviewoldcontract"});
        }
        int riskEntryCount = this.getModel().getEntryRowCount(CONTRISKENTRY);
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus)) {
            this.getView().setVisible(Boolean.valueOf(riskEntryCount > 0), new String[]{RISKPANEL});
            this.getView().setVisible(Boolean.valueOf(riskEntryCount == 0), new String[]{LOAD_RISK_ITEM_COMP});
        } else {
            this.getView().setVisible(Boolean.valueOf(riskEntryCount > 0), new String[]{RISKPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{LOAD_RISK_ITEM_COMP, BTN_DEL_COMP2});
        }
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            return;
        }
        if (this.isOpenAccountOrgNullCheck() && (org = (DynamicObject)this.getModel().getValue(this.getAccountingOrg())) != null) {
            Map bizOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)Long.valueOf(org.getPkValue().toString()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            logger.error("orgName={},ID={},bizOrg={}\u3002", new Object[]{org.getLocaleString("name"), org.getPkValue(), bizOrg});
            if (bizOrg == null || bizOrg.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\uff1a%s\uff0c\u6240\u5c5e\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"InContractEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), org.getLocaleString("name")));
            } else {
                this.getModel().setValue("fiaccountorg", bizOrg.get("id"));
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "treelistingbudgetitem": {
                this.setBlankChildren(e.getChangeSet()[0]);
                break;
            }
            case "project": {
                this.clearBudgetItem(model);
                break;
            }
            case "originaloftaxamount": {
                DynamicObjectCollection inContPayPlanEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(INCONTPAYPLANENTRY);
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                for (int i = 0; i < inContPayPlanEntries.size(); ++i) {
                    DynamicObject inContPayPlanEntry = (DynamicObject)inContPayPlanEntries.get(i);
                    BigDecimal payPercent = inContPayPlanEntry.getBigDecimal("paypercent").divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
                    BigDecimal payAmount = inContPayPlanEntry.getBigDecimal("payamount");
                    this.getModel().beginInit();
                    if (BigDecimal.ZERO.compareTo(payPercent) != 0) {
                        this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent), i);
                        this.getView().updateView("payamount", i);
                    } else if (BigDecimal.ZERO.compareTo(payAmount) != 0) {
                        payPercent = BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0 ? payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                        this.getModel().setValue("paypercent", (Object)payPercent, i);
                        this.getView().updateView("paypercent", i);
                    }
                    this.getModel().endInit();
                }
                break;
            }
            case "paypercent": {
                this.recountInPayPlan();
                BigDecimal payPercent = (BigDecimal)this.getModel().getValue("paypercent", rowIndex);
                payPercent = payPercent.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                this.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0) {
                    this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent), rowIndex);
                    this.getView().updateView("payamount", rowIndex);
                }
                this.getModel().endInit();
                break;
            }
            case "payamount": {
                this.recountInPayPlan();
                BigDecimal originalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("originaloftaxamount");
                BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount", rowIndex);
                this.getModel().beginInit();
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) != 0) {
                    this.getModel().setValue("paypercent", (Object)payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)), rowIndex);
                }
                if (BigDecimal.ZERO.compareTo(originalOfTaxAmount) == 0) {
                    this.getModel().setValue("paypercent", (Object)BigDecimal.ZERO, rowIndex);
                }
                this.getView().updateView("paypercent", rowIndex);
                this.getModel().endInit();
                break;
            }
            case "contracttype": {
                if (newValue == null || !newValue.equals(oldValue)) break;
                return;
            }
            case "nodesetting": {
                if (null == newValue) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                    this.getModel().setValue("ctrlstrategy", null, rowIndex);
                    this.getModel().setValue("taskcompletestate", null, rowIndex);
                    return;
                }
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = task.getString("completionstatus");
                String taskState = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                this.getModel().setValue("taskcompletestate", (Object)taskState, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "budgetitem": {
                this.budgetItemChanged(e.getChangeSet()[0]);
                break;
            }
        }
    }

    private void clearBudgetItem(IDataModel model) {
        model.setValue("budgetitem", null);
        DynamicObjectCollection listModelEntry = model.getEntryEntity("listmodelentry");
        for (DynamicObject listModelEntryObj : listModelEntry) {
            DynamicObjectCollection treeListEntry = model.getEntryEntity("treelistentry");
            for (DynamicObject treeListEntryObj : treeListEntry) {
                treeListEntryObj.set("treelistingbudgetitem", null);
            }
            DynamicObjectCollection subListEntry = listModelEntryObj.getDynamicObjectCollection("sublistentry");
            for (DynamicObject subListEntryObj : subListEntry) {
                subListEntryObj.set("listingbudgetitem", null);
            }
            model.updateEntryCache(subListEntry);
        }
        this.getView().updateView("sublistentry");
        this.getView().updateView("treelistentry");
    }

    protected boolean isOpenAccountOrgNullCheck() {
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) throws KDBizException {
        super.beforeF7Select(arg0);
        String name = arg0.getProperty().getName();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (name.equalsIgnoreCase("refcontract")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            ListShowParameter parameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            parameter.getListFilterParameter().getQFilters().add(orgFilter);
            ContractHelper.getContractByStatus((String)"pmct_contract", (ListShowParameter)parameter, (String)"");
            if (project != null) {
                QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
                parameter.getListFilterParameter().getQFilters().add(projectFilter);
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)name, (CharSequence)"budgetitem") || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)name, (CharSequence)"treelistingbudgetitem")) {
            if (project == null) {
                arg0.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"InContractEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)"IN");
            qFilters.add(projectFilter);
            qFilters.add(sourceTypeFilter);
            DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (budgetItems.length == 0) {
                arg0.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e0d\u5b58\u5728\u9884\u7b97\u9879\u3002", (String)"InContractEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                return children == null || children.length == 0;
            }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)name, (CharSequence)"nodesetting")) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            this.beforeSelectNodeSetting(param);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)name, (CharSequence)"multisettlepro")) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            ArrayList<String> excludeStatusIds = new ArrayList<String>();
            excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
            excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
            excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
            QFilter proStatusFilter = new QFilter("prostatus", "not in", (Object)StringUtils.stringArrToLongArr((String[])excludeStatusIds.toArray(new String[excludeStatusIds.size()])));
            proStatusFilter.and("prostatus", "!=", (Object)0);
            DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{proStatusFilter});
            Set projectIdSet = Arrays.stream(projectApprovals).filter(o -> o.getDynamicObject("pro") != null).map(projectApproval -> projectApproval.getDynamicObject("pro").getPkValue()).collect(Collectors.toSet());
            qFilters.add(new QFilter("id", "in", projectIdSet));
            qFilters.add(proStatusFilter);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)name, (CharSequence)"treematerial")) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            int row = arg0.getRow();
            DynamicObjectCollection treeListEntry = this.getModel().getEntryEntity("treelistentry");
            param.setMultiSelect(false);
            if (treeListEntry != null && treeListEntry.size() == row + 1) {
                param.setMultiSelect(true);
            }
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param) {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"003");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals(CALLBACKDELETEINCOMEPLANENTRY) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData(INCONTPAYPLANENTRY);
        }
    }

    private void gainOriginalContract() {
        QFilter contFilter = new QFilter("contract", "=", this.getModel().getValue("id")).and("versionnumber", "=", (Object)1);
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{contFilter});
        if (contractRevisions != null && contractRevisions.length == 1) {
            String contractRevisionId = contractRevisions[0].getPkValue().toString();
            DynamicObject contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisionId, (String)"pmct_contractrevision");
            String contractName = contractRevision.getString("contractname");
            this.getModel().setValue("billname", (Object)contractName);
            Boolean percentModel = contractRevision.getBoolean("inpercentmodel");
            this.getModel().setValue("percentmodel", (Object)percentModel);
            this.loadRiskEntry(contractRevision);
            this.loadInContPlanEntry(contractRevision);
        }
        ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        String key = ((Control)event.getSource()).getKey();
        FormShowParameter formShowParameter = event.getShowParameter();
        if ("project".equals(key)) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(openStyle);
            formShowParameter.setCustomParam("quickAddNew", (Object)Boolean.TRUE);
        }
    }

    private void loadRiskEntry(DynamicObject contractRevision) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(CONTRISKENTRY);
        DynamicObjectCollection riskEntry = contractRevision.getDynamicObjectCollection(CONTRISKENTRY);
        entries.clear();
        if (riskEntry != null && riskEntry.size() > 0) {
            for (DynamicObject entry : riskEntry) {
                DynamicObject item = entries.addNew();
                item.set("risktype", entry.get("risktype"));
                item.set("riskname", entry.get("riskname"));
                item.set("riskdesc", entry.get("riskdesc"));
                item.set("measures", entry.get("measures"));
                item.set("islegalrisk", entry.get("islegalrisk"));
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(CONTRISKENTRY);
    }

    private void loadInContPlanEntry(DynamicObject contractRevision) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(INCONTPAYPLANENTRY);
        DynamicObjectCollection inContPayPlanEntry = contractRevision.getDynamicObjectCollection(INCONTPAYPLANENTRY);
        if (inContPayPlanEntry != null && inContPayPlanEntry.size() > 0) {
            entries.clear();
            for (DynamicObject entry : inContPayPlanEntry) {
                DynamicObject item = entries.addNew();
                item.set("payway", entry.get("incomeway"));
                item.set("paytype", entry.get("incometype"));
                item.set("paymethod", entry.get("incomemethod"));
                item.set("paypercent", entry.get("incomepercent"));
                item.set("payamount", entry.get("incomeamount"));
                item.set("planpaytime", entry.get("planincometime"));
                item.set("remarks", entry.get("incomedescription"));
                item.set("conplanitemid", (Object)String.valueOf(entry.getLong("conincomeitemid")));
                DynamicObject nodeSetting = entry.getDynamicObject("incomenodesetting");
                item.set("nodesetting", (Object)nodeSetting);
                if (null == nodeSetting) continue;
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                item.set("taskcompletestate", (Object)status);
                item.set("nodesettingsource", entry.get("incomesource"));
                item.set("ctrlstrategy", entry.get("incomectrlstrategy"));
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(INCONTPAYPLANENTRY);
    }

    private void gainLastNewContract() {
        this.loadListModelEntryData();
        this.loadLastInContPlanEntry();
        this.loadLastRiskEntry();
    }

    private void loadLastAttachment() {
        String refresh = this.getPageCache().get(REFRESH_FLAG);
        if (refresh == null) {
            String cacheJsonString;
            String cacheKey;
            DynamicObject[] inContractAddAgreements;
            DynamicObject[] inContractRevisions;
            List attachments;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            ArrayList newAttachments = new ArrayList(10);
            ArrayList newTextAttachments = new ArrayList(10);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            statusFilter.and(new QFilter("contract", "=", dataEntity.getPkValue()));
            DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc");
            if (contractRevisions != null && contractRevisions.length > 0) {
                DynamicObject[] textAttachments;
                DynamicObject contractRevision = contractRevisions[0];
                attachments = AttachmentServiceHelper.getAttachments((String)"pmct_contractrevision", (Object)contractRevision.getPkValue(), (String)ATTACHMENTPANEL);
                if (attachments != null && attachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)attachments);
                    newAttachments.addAll(attachments);
                }
                if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_contractrevision", (Object)contractRevision.getPkValue(), (String)TEXTATTACHMENTPANEL)) != null && textAttachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            } else {
                List textAttachments;
                List attachments2 = AttachmentServiceHelper.getAttachments((String)"pmct_incontract", (Object)dataEntity.getPkValue(), (String)ATTACHMENTPANEL);
                if (attachments2 != null && attachments2.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)attachments2);
                    newAttachments.addAll(attachments2);
                }
                if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_incontract", (Object)dataEntity.getPkValue(), (String)TEXTATTACHMENTPANEL)) != null && textAttachments.size() > 0) {
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            }
            DynamicObject contractSign = BusinessDataServiceHelper.loadSingle((String)"pmct_contsign", (String)"id", (QFilter[])new QFilter[]{new QFilter("contract", "=", dataEntity.getPkValue())});
            if (contractSign != null && (attachments = AttachmentServiceHelper.getAttachments((String)"pmct_contsign", (Object)contractSign.getPkValue(), (String)ATTACHMENTPANEL)) != null && attachments.size() > 0) {
                FileAttachmentHelper.setAttachmentUrl((List)attachments);
                newAttachments.addAll(attachments);
            }
            if ((inContractRevisions = BusinessDataServiceHelper.load((String)"pmct_incontractrevision", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc")) != null && inContractRevisions.length > 0) {
                for (DynamicObject inContractRevision : inContractRevisions) {
                    List attachments3 = AttachmentServiceHelper.getAttachments((String)"pmct_incontractrevision", (Object)inContractRevision.getPkValue(), (String)ATTACHMENTPANEL);
                    if (attachments3 == null || attachments3.size() <= 0) continue;
                    FileAttachmentHelper.setAttachmentUrl((List)attachments3);
                    newAttachments.addAll(attachments3);
                }
            }
            if ((inContractAddAgreements = BusinessDataServiceHelper.load((String)"pmct_inaddagreement", (String)String.join((CharSequence)",", "billno", "auditdate"), (QFilter[])new QFilter[]{statusFilter}, (String)"auditdate desc")) != null && inContractAddAgreements.length > 0) {
                for (DynamicObject inContractAddAgreement : inContractAddAgreements) {
                    List textAttachments;
                    List attachments4 = AttachmentServiceHelper.getAttachments((String)"pmct_inaddagreement", (Object)inContractAddAgreement.getPkValue(), (String)ATTACHMENTPANEL);
                    if (attachments4 != null && attachments4.size() > 0) {
                        FileAttachmentHelper.setAttachmentUrl((List)attachments4);
                        newAttachments.addAll(attachments4);
                    }
                    if ((textAttachments = AttachmentServiceHelper.getAttachments((String)"pmct_inaddagreement", (Object)inContractAddAgreement.getPkValue(), (String)TEXTATTACHMENTPANEL)) == null || textAttachments.size() <= 0) continue;
                    FileAttachmentHelper.setAttachmentUrl((List)textAttachments);
                    newTextAttachments.addAll(textAttachments);
                }
            }
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            HashMap attachmentInfo = new HashMap();
            if (newAttachments.size() > 0) {
                AttachmentPanel panel = (AttachmentPanel)this.getControl(LASTATTACHMENTPANEL);
                cacheKey = "TampAttCache" + this.getView().getPageId();
                attachmentInfo.put(LASTATTACHMENTPANEL, newAttachments);
                cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
                cache.put(cacheKey, cacheJsonString);
                panel.bindData(newAttachments);
                this.getView().updateView(LASTATTACHMENTPANEL);
            }
            if (newTextAttachments.size() > 0) {
                AttachmentPanel textPanel = (AttachmentPanel)this.getControl(LASTTEXTATTACHMENTPANEL);
                cacheKey = "TampAttCache" + this.getView().getPageId();
                attachmentInfo.put(LASTTEXTATTACHMENTPANEL, newTextAttachments);
                cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
                cache.put(cacheKey, cacheJsonString);
                textPanel.bindData(newTextAttachments);
                this.getView().updateView(LASTTEXTATTACHMENTPANEL);
            }
        }
    }

    private void loadListModelEntryData() {
        int pricePrecision;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
        ContractEditHelper.setNewListModel((Object)this.getModel().getDataEntity().getPkValue(), (DynamicObjectCollection)listModelEntry);
        Boolean isOnList = (Boolean)model.getValue("isonlist");
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        int n = pricePrecision = currency == null ? 10 : currency.getInt("priceprecision");
        if (listModelEntry.size() > 0 && isOnList.booleanValue()) {
            BigDecimal originalAmount;
            BigDecimal taxRate;
            BigDecimal originalOfTaxAmount = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            DynamicObjectType sublistDy = this.getModel().getEntryEntity("sublistentry").getDynamicObjectType();
            for (DynamicObject listModel : listModelEntry) {
                String cmpType;
                DynamicObjectCollection sublistEntries = new DynamicObjectCollection(sublistDy, (Object)listModel);
                String listModelId = listModel.getString("listmodelid");
                String allProperty = "modifier, createtime, modifytime, number, name, status, creator, enable, masterid, level, longnumber, fullname, isleaf, parent, sysnumber, measureunit, qty, taxprice, taxrate, rateobj, amount, price, tax, oftax, desc, lstsettleqty, lstsettleoftaxamount, changeqty, chgeffectqty, chgoftaxamount, totalqty, curtaxprice, lstoftaxamount, avgtaxprice, ischanged, isaddnew, material, sequence, entryid, currency, listparentid, listingmodel, contractid, paydirection,listingbudgetitem,latestamount";
                QFilter contFilter = new QFilter("contractid", "=", (Object)model.getValue("id").toString()).and("listingmodel", "=", (Object)listModelId);
                DynamicObject[] listEntries = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)allProperty, (QFilter[])new QFilter[]{contFilter}, (String)"sysnumber desc");
                if (null == listEntries || listEntries.length <= 0) continue;
                sublistEntries.clear();
                BigDecimal rowOfTax = BigDecimal.ZERO;
                BigDecimal rowTax = BigDecimal.ZERO;
                for (int i = listEntries.length - 1; i >= 0; --i) {
                    DynamicObject listEntry = listEntries[i];
                    DynamicObject item = sublistEntries.addNew();
                    item.set("id", listEntry.get("id"));
                    item.set("listnumber", (Object)listEntry.getString("number"));
                    item.set("listname", (Object)listEntry.getString("name"));
                    item.set("level", (Object)listEntry.getInt("level"));
                    item.set("longnumber", (Object)listEntry.getString("longnumber"));
                    item.set("isleaf", (Object)listEntry.getBoolean("isleaf"));
                    item.set("parent", (Object)listEntry.getDynamicObject("parent"));
                    item.set("sysnumber", (Object)listEntry.getString("sysnumber"));
                    item.set("measureunit", (Object)listEntry.getDynamicObject("measureunit"));
                    item.set("rate", (Object)listEntry.getBigDecimal("taxrate"));
                    item.set("rateobj", (Object)listEntry.getDynamicObject("rateobj"));
                    BigDecimal lstOfTaxAmount = listEntry.getBigDecimal("lstoftaxamount");
                    item.set("oftax", (Object)lstOfTaxAmount);
                    if (listEntry.getBoolean("isleaf")) {
                        rowOfTax = rowOfTax.add(lstOfTaxAmount);
                    }
                    item.set("desc", (Object)listEntry.getString("desc"));
                    item.set("qty", (Object)listEntry.getBigDecimal("totalqty"));
                    item.set("taxprice", (Object)listEntry.getBigDecimal("curtaxprice"));
                    BigDecimal rate = listEntry.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L));
                    BigDecimal price = listEntry.getBigDecimal("curtaxprice").divide(BigDecimal.ONE.add(rate), pricePrecision, 4);
                    item.set("price", (Object)price);
                    BigDecimal lstOfAmount = listEntry.getBigDecimal("latestamount");
                    if (lstOfAmount == null || lstOfAmount.compareTo(BigDecimal.ZERO) == 0) {
                        lstOfAmount = lstOfTaxAmount.divide(BigDecimal.ONE.add(rate), amtPrecision, 4);
                    }
                    item.set("tax", (Object)lstOfTaxAmount.subtract(lstOfAmount));
                    if (listEntry.getBoolean("isleaf")) {
                        rowTax = rowTax.add(item.getBigDecimal("tax"));
                    }
                    item.set("amount", (Object)lstOfAmount);
                    item.set("material", (Object)listEntry.getDynamicObject("material"));
                    item.set("seq", (Object)listEntry.getInt("sequence"));
                    item.set("listparentid", (Object)listEntry.getString("listparentid"));
                    item.set("sublistmodelid", (Object)listEntry.getString("listingmodel_id"));
                    item.set("listingbudgetitem", (Object)listEntry.getDynamicObject("listingbudgetitem"));
                }
                listModel.set("rowoftax", (Object)rowOfTax);
                rowTax = rowTax.setScale(10, 4);
                BigDecimal rowOriginalAmount = rowOfTax.subtract(rowTax);
                listModel.set("rowtax", (Object)rowTax);
                listModel.set("rowamount", (Object)rowOriginalAmount);
                if (isMultiRate.booleanValue()) {
                    if (listModel.getBigDecimal("rowamount").compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal taxRate2 = rowTax.divide(listModel.getBigDecimal("rowamount"), 10, 4);
                        listModel.set("rowtaxrate", (Object)taxRate2.multiply(BigDecimal.valueOf(100L)));
                    }
                } else {
                    DynamicObject lstTaxRate = (DynamicObject)model.getValue("lsttaxrate");
                    BigDecimal taxRate3 = BigDecimal.ZERO;
                    if (lstTaxRate != null) {
                        taxRate3 = lstTaxRate.getBigDecimal("taxrate");
                    }
                    listModel.set("rowtaxrate", (Object)taxRate3);
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(cmpType = listModel.getString("cmptype"))) && cmpType.contains("+")) {
                    originalOfTaxAmount = originalOfTaxAmount.add(rowOfTax);
                    taxAmount = taxAmount.add(rowTax);
                } else if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)cmpType) && cmpType.contains("-")) {
                    originalOfTaxAmount = originalOfTaxAmount.subtract(rowOfTax);
                    taxAmount = taxAmount.subtract(rowTax);
                }
                listModel.set("sublistentry", (Object)sublistEntries);
            }
            if (isOnList.booleanValue() && !isMultiRate.booleanValue() && null != model.getValue("taxrate")) {
                taxRate = dataEntity.getDynamicObject("taxrate").getBigDecimal("taxrate");
                originalAmount = originalOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 10, 4);
                taxAmount = originalOfTaxAmount.subtract(originalAmount);
            }
            if (isMultiRate.booleanValue() && (originalAmount = originalOfTaxAmount.subtract(taxAmount)).compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxAmount.divide(originalAmount, 10, 4);
                model.setValue("avgtaxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)));
            }
        }
        BigDecimal totalOfTaxAmount = (BigDecimal)model.getValue("totaloftaxamount");
        BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount");
        model.beginInit();
        model.setValue("originaloftaxamount", (Object)totalOfTaxAmount);
        model.setValue("originalamount", (Object)totalAmount);
        model.setValue("taxamount", (Object)totalOfTaxAmount.subtract(totalAmount));
        model.setValue("taxrate", model.getValue("lsttaxrate"));
        model.setValue("avgtaxrate", model.getValue("lstavgtaxrate"));
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal signAmount = NumberHelper.multiply((Object)totalOfTaxAmount, (Object)exChangeRate);
        BigDecimal stdOriginalAmount = BigDecimal.ZERO;
        if (isMultiRate.booleanValue()) {
            if (dataEntity.getBigDecimal("avgtaxrate") != null) {
                stdOriginalAmount = signAmount.divide(BigDecimal.ONE.add(dataEntity.getBigDecimal("avgtaxrate")), 10, 4);
            }
        } else if (null != model.getValue("taxrate")) {
            BigDecimal taxRate = dataEntity.getDynamicObject("taxrate").getBigDecimal("taxrate");
            stdOriginalAmount = signAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 10, 4);
        }
        model.setValue("signamount", (Object)signAmount);
        model.setValue("stdoriginalamount", (Object)stdOriginalAmount);
        model.setValue("stdtaxamount", (Object)signAmount.subtract(stdOriginalAmount));
        model.endInit();
        this.getView().updateView("originaloftaxamount");
        this.getView().updateView("originalamount");
        this.getView().updateView("taxamount");
        this.getView().updateView("signamount");
        this.getView().updateView("stdoriginalamount");
        this.getView().updateView("stdtaxamount");
        this.getView().updateView("taxrate");
        this.getView().updateView("avgtaxrate");
        model.updateEntryCache(listModelEntry);
        this.getView().updateView("listmodelentry");
        if (listModelEntry.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listmodelentry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractlistingpanel"});
        } else if (listModelEntry.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractlistingpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"listmodelentry"});
        }
        int rowCount = model.getEntryRowCount("listmodelentry");
        if (rowCount > 1) {
            CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
            cardEntry.selectRows(0);
            cardEntry.entryRowClick(Integer.valueOf(0));
        } else {
            this.initTreeListEntry();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("deleteplanentrycomp".equals(operateKey)) {
            ConfirmCallBackListener planCallback = new ConfirmCallBackListener(CALLBACKDELETEINCOMEPLANENTRY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5220\u9664\u6536\u6b3e\u8ba1\u5212\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"InContractEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, planCallback);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)BTN_SAVE, (CharSequence)operateKey)) {
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.INDRAFT.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            this.getModel().setValue(CONTRACTSTATUS, (Object)contStatusObj);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            this.getPageCache().put(REFRESH_FLAG, String.valueOf(Boolean.TRUE));
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)ADJUST, (CharSequence)operateKey)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("direction", PayDirectionEnum.IN.getValue());
            paramMap.put("planEntry", INCONTPAYPLANENTRY);
            paramMap.put("percentModel", "percentmodel");
            paramMap.put("payPercent", "paypercent");
            paramMap.put("payAmount", "payamount");
            paramMap.put("Originaloftaxamount", "originaloftaxamount");
            ContractEditHelper.adjustPayPlan((IFormView)this.getView(), paramMap);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)CTRL_NEWENTRY, (CharSequence)operateKey)) {
            this.recountInPayPlan();
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)CTRL_DELETEENTRY, (CharSequence)operateKey)) {
            this.recountInPayPlan();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"doviewoldcontract", (CharSequence)operateKey) && operationResult.isSuccess()) {
            this.doViewContract();
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)CTRL_NEWENTRY, (CharSequence)operateKey)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(INCONTPAYPLANENTRY);
            int rowIndex = entrys.size() - 1;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)BTN_SUBMIT, (CharSequence)operateKey) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
            ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity(INCONTPAYPLANENTRY);
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
            payPlanEntry.set("taskcompletestate", mapData.get(sourceTask.getLong("id")));
            long incomeItemId = payPlanEntry.getLong("conplanitemid");
            if (0L == incomeItemId || QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)incomeItemId)) continue;
            payPlanEntry.set("conplanitemid", null);
        }
    }

    private void initTreeListEntry() {
        this.getModel().deleteEntryData("treelistentry");
        DynamicObjectCollection subListEntry = this.getModel().getEntryEntity("sublistentry");
        DynamicObjectCollection treeListEntry = this.getModel().getEntryEntity("treelistentry");
        String payDirection = (String)this.getModel().getValue("paydirection");
        DynamicObjectType dt = treeListEntry.getDynamicObjectType();
        if (subListEntry == null) {
            return;
        }
        for (DynamicObject dynamicObject : subListEntry) {
            DynamicObject listing = new DynamicObject(dt);
            listing.set("treesysnumber", dynamicObject.get("sysnumber"));
            listing.set("treelistnumber", dynamicObject.get("listnumber"));
            listing.set("treematerial", dynamicObject.get("material"));
            listing.set("treemeasureunit", dynamicObject.get("measureunit"));
            listing.set("treeqty", dynamicObject.get("qty"));
            listing.set("treetaxprice", dynamicObject.get("taxprice"));
            listing.set("treerate", dynamicObject.get("rate"));
            listing.set("treeamount", dynamicObject.get("amount"));
            listing.set("treeprice", dynamicObject.get("price"));
            listing.set("treetax", dynamicObject.get("tax"));
            listing.set("treeprice", dynamicObject.get("price"));
            listing.set("treeoftax", dynamicObject.get("oftax"));
            listing.set("treedesc", dynamicObject.get("desc"));
            listing.set("treeisleaf", dynamicObject.get("isleaf"));
            listing.set("treelistname", dynamicObject.get("listname"));
            listing.set("treerateobj", dynamicObject.get("rateobj"));
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
                listing.set("treelistingbudgetitem", dynamicObject.get("listingbudgetitem"));
            }
            String pid = "0";
            if (dynamicObject.get("listparentid") != null && !"".equals(dynamicObject.get("listparentid"))) {
                pid = String.valueOf(dynamicObject.get("listparentid"));
            }
            listing.set("pid", (Object)pid);
            listing.set("id", (Object)dynamicObject.getString("id"));
            treeListEntry.add((Object)listing);
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treelistentry");
        grid.setCollapse(false);
        this.getModel().updateEntryCache(treeListEntry);
        this.getView().updateView("treelistentry");
    }

    private void loadLastInContPlanEntry() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(INCONTPAYPLANENTRY);
        QFilter contFilter = new QFilter("contract", "=", this.getModel().getValue("id")).and("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        contFilter = contFilter.and(new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue()));
        DynamicObject[] contractIncomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contFilter}, (String)"createtime asc");
        entries.clear();
        if (null != contractIncomeItems && contractIncomeItems.length > 0) {
            Object[] ids = Arrays.stream(contractIncomeItems).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
            for (DynamicObject contractIncomeItem : contractIncomeItems = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                DynamicObject item = entries.addNew();
                item.set("customer", contractIncomeItem.get("customer"));
                item.set("paytype", contractIncomeItem.get("collecttype"));
                item.set("payway", contractIncomeItem.get("collectway"));
                item.set("paymethod", contractIncomeItem.get("collectfeq"));
                item.set("paypercent", contractIncomeItem.get("collectpercent"));
                item.set("payamount", contractIncomeItem.get("collectamount"));
                item.set("planpaytime", contractIncomeItem.get("plancollecttime"));
                item.set("remarks", contractIncomeItem.get("remarks"));
                item.set("conplanitemid", (Object)contractIncomeItem.getPkValue().toString());
                item.set("incomeitemname", (Object)contractIncomeItem.getLocaleString("name").getLocaleValue());
                DynamicObject nodeSetting = contractIncomeItem.getDynamicObject("nodesetting");
                item.set("nodesetting", (Object)nodeSetting);
                if (null == nodeSetting) continue;
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                item.set("taskcompletestate", (Object)status);
                item.set("nodesettingsource", contractIncomeItem.get("nodesettingsource"));
                item.set("ctrlstrategy", contractIncomeItem.get("ctrlstrategy"));
            }
        }
        this.getModel().updateEntryCache(entries);
        this.getView().updateView(INCONTPAYPLANENTRY);
    }

    private void loadLastRiskEntry() {
        long contractPk = Long.parseLong(this.getModel().getValue("id").toString());
        QFilter contFilter = new QFilter("contract", "=", (Object)contractPk).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)kd.bos.dataentity.utils.StringUtils.join((Object[])new String[]{",", "id", CONTRISKENTRY}), (QFilter[])new QFilter[]{contFilter}, (String)"versionnumber desc");
        if (contractRevisions != null && contractRevisions.length > 0) {
            HashMap<String, DynamicObject> revisionMap = new HashMap<String, DynamicObject>();
            Object[] ids = Arrays.stream(contractRevisions).map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision");
            for (DynamicObject contractRevision : contractRevisions = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dt)) {
                String conPkValue = contractRevision.getDynamicObject("contract").getPkValue().toString();
                DynamicObject lastRevision = (DynamicObject)revisionMap.get(conPkValue);
                if (lastRevision == null) {
                    revisionMap.put(conPkValue, contractRevision);
                    continue;
                }
                BigDecimal lastVersion = lastRevision.getBigDecimal("versionnumber");
                BigDecimal curVersion = contractRevision.getBigDecimal("versionnumber");
                if (curVersion.compareTo(lastVersion) <= 0) continue;
                revisionMap.put(conPkValue, contractRevision);
            }
            Set revisionEntrySet = revisionMap.entrySet();
            for (Map.Entry revisionEntry : revisionEntrySet) {
                DynamicObject contractRevision;
                contractRevision = (DynamicObject)revisionEntry.getValue();
                this.loadRiskEntry(contractRevision);
            }
        }
    }

    private void doViewContract() {
        HashMap<String, String> param = new HashMap<String, String>();
        String pkId = this.getModel().getValue("id").toString();
        param.put("pkId", pkId);
        param.put("formId", "pmct_incontract");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam(VIEWSTYLE, (Object)"oldContrct");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_incontract"));
        this.getView().showForm(showParameter);
    }

    protected void setBlankChildren(ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection lists = this.getModel().getEntryEntity("treelistentry");
        this.doSetBlankChildren(newValue, rowIndex, lists);
    }

    private void doSetBlankChildren(DynamicObject newValue, int rowIndex, DynamicObjectCollection lists) {
        if (rowIndex >= lists.size()) {
            logger.error("rowIndex: {}, \u7d22\u5f15\u8d8a\u754c\uff0c\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u5206\u644a\u660e\u7ec6\u5b50\u7ea7\u7a7a\u767d\u9884\u7b97\u9879\u3002", (Object)rowIndex);
            return;
        }
        String parentId = Optional.ofNullable(((DynamicObject)lists.get(rowIndex)).getPkValue().toString()).orElse("0");
        for (int index = rowIndex; index < lists.size(); ++index) {
            String pid = ((DynamicObject)lists.get(index)).getString("pid");
            if (pid == null || "0".equals(pid) || null != ((DynamicObject)lists.get(index)).getString("treelistingbudgetitem") || !parentId.equals(pid)) continue;
            this.getModel().setValue("treelistingbudgetitem", (Object)newValue, index);
        }
        this.doSetBlankChildren(newValue, rowIndex + 1, lists);
    }

    private void recountInPayPlan() {
        HashMap<String, String> percentParamMap = new HashMap<String, String>(16);
        percentParamMap.put("direction", PayDirectionEnum.IN.getValue());
        percentParamMap.put("planEntry", INCONTPAYPLANENTRY);
        percentParamMap.put("percentModel", "percentmodel");
        percentParamMap.put("payPercent", "paypercent");
        percentParamMap.put("payAmount", "payamount");
        percentParamMap.put("Originaloftaxamount", "originaloftaxamount");
        ContractEditHelper.recountPayPlan((IFormView)this.getView(), percentParamMap);
    }

    protected void budgetItemChanged(ChangeData changeData) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (newValue != null && this.getModel().getDataEntity().getBoolean("isonlist")) {
            DynamicObjectCollection listModelEntry = this.getModel().getEntryEntity("listmodelentry");
            for (DynamicObject model : listModelEntry) {
                DynamicObjectCollection listEntry = model.getDynamicObjectCollection("sublistentry");
                for (DynamicObject list : listEntry) {
                    DynamicObject budgetItem = list.getDynamicObject("listingbudgetitem");
                    if (budgetItem != null && (oldValue == null || !budgetItem.getPkValue().equals(oldValue.getPkValue()))) continue;
                    list.set("listingbudgetitem", (Object)newValue);
                }
            }
            DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treelistentry");
            for (DynamicObject entry : treeEntry) {
                DynamicObject budgetItem = entry.getDynamicObject("treelistingbudgetitem");
                if (budgetItem != null && (oldValue == null || !budgetItem.getPkValue().equals(oldValue.getPkValue()))) continue;
                entry.set("treelistingbudgetitem", (Object)newValue);
            }
            this.getModel().setValue("listmodelentry", (Object)listModelEntry);
            this.getModel().setValue("treelistentry", (Object)treeEntry);
            this.getView().updateView("treelistentry");
        }
    }
}

