/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;

public class InContractListPlugin
extends AbstractPmctListPlugin {
    private static final String CONTRACTSTATUS = "contractstatus";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        switch (operateKey) {
            case "revise": {
                this.doContractRevise(args, selectedRows);
                break;
            }
            case "revisehistory": {
                this.doReviseHistory(args, selectedRows);
                break;
            }
            case "dounsign": {
                this.doContractUnsign(args, selectedRows);
                break;
            }
            case "doviewoldcontract": {
                this.beforeDoViewContract(args, selectedRows);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        switch (operateKey) {
            case "dounsign": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "dosign": {
                this.doContractSign(selectedRows);
                break;
            }
            case "dosigninfo": {
                this.doSignInfo(selectedRows);
                break;
            }
            case "doviewoldcontract": {
                this.doViewContract(selectedRows);
                break;
            }
        }
    }

    private void doContractUnsign(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u3002", (String)"InContractListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void doReviseHistory(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u8fdb\u884c\u4fee\u8ba2\u64cd\u4f5c\u3002", (String)"InContractListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
        Long contId = (Long)row.getPrimaryKeyValue();
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("contractId", contId);
        param1.put("paydirection", PayDirectionEnum.IN.getValue());
        ListShowParameter listShow = new ListShowParameter();
        listShow.setBillFormId("pmct_contractrevision");
        listShow.setCustomParams(param1);
        listShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShow);
    }

    private void doContractRevise(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u8fdb\u884c\u4fee\u8ba2\u64cd\u4f5c\u3002", (String)"InContractListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
        Long contId = (Long)row.getPrimaryKeyValue();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contId, (String)"pmct_incontract");
        String contStatus = contract.getDynamicObject(CONTRACTSTATUS).getString("number");
        String contStatusName = contract.getDynamicObject(CONTRACTSTATUS).getString("name");
        if (StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.CLOSED.getValue())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u8ba2\u3002", (String)"InContractListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatusName), Integer.valueOf(3000));
            args.setCancel(true);
            return;
        }
        QFilter contractIdFilter = new QFilter("contract", "=", (Object)contId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.Checked.toString());
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        DynamicObject[] inClaims = BusinessDataServiceHelper.load((String)"pmct_inclaimbill", (String)"id", (QFilter[])new QFilter[]{statusFilter, isNeedSettleFilter, contractIdFilter});
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{statusFilter, contractIdFilter});
        DynamicObject[] inContractRevisions = BusinessDataServiceHelper.load((String)"pmct_incontractrevision", (String)"id", (QFilter[])new QFilter[]{statusFilter, contractIdFilter});
        DynamicObject[] inContractAddAgrceements = BusinessDataServiceHelper.load((String)"pmct_inaddagreement", (String)"id", (QFilter[])new QFilter[]{statusFilter, contractIdFilter});
        if (inClaims.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u4fee\u8ba2\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\uff0c\u8bf7\u5f85\u7d22\u8d54\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractListPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (contractRevisions.length > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("contractId", contId);
            param.put("paydirection", PayDirectionEnum.IN.getValue());
            DynamicObject contractRevision = contractRevisions[0];
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(contractRevision.getPkValue());
            billShowParameter.setFormId("pmct_contractrevision");
            billShowParameter.setCustomParams(param);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
            return;
        }
        if (inContractRevisions.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u4fee\u8ba2\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractListPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (inContractAddAgrceements.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u4fee\u8ba2\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\uff0c\u8bf7\u5f85\u8865\u5145\u534f\u8bae\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractListPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractId", contId);
        param.put("paydirection", PayDirectionEnum.IN.getValue());
        BillShowParameter showbill = new BillShowParameter();
        showbill.setFormId("pmct_contractrevision");
        showbill.setCustomParams(param);
        showbill.setStatus(OperationStatus.ADDNEW);
        showbill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showbill);
    }

    private void doContractSign(ListSelectedRowCollection selectedRowCollection) {
        if (selectedRowCollection.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u3002", (String)"InContractListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object id = selectedRowCollection.get(0).getPrimaryKeyValue();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmct_incontract");
        String contStatus = contract.getDynamicObject(CONTRACTSTATUS).getString("number");
        if (!StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a\u201c\u5df2\u6279\u51c6\u201d\u65f6\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"InContractListPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        map.put("contractId", id);
        map.put("formId", "pmct_contsign");
        map.put(CONTRACTSTATUS, contStatus);
        map.put("ismulticontract", contract.get("ismulticontract"));
        FormShowParameter showParameter = new FormShowParameter();
        QFilter contFilter = new QFilter("contract", "=", id);
        String selectedProperties = "partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, signdate, signaddress, signaddressdetail, contract";
        DynamicObject[] contractSigns = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)selectedProperties, (QFilter[])new QFilter[]{contFilter});
        if (contractSigns != null && contractSigns.length == 1) {
            DynamicObject contractSign = contractSigns[0];
            map.put("pkId", contractSign.getPkValue().toString());
            map.put("signdate", contractSign.getDate("signdate"));
            showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.EDIT);
        } else if (contractSigns == null || contractSigns.length == 0) {
            showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_contsign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doSignInfo(ListSelectedRowCollection selectedRowCollection) {
        if (selectedRowCollection.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u3002", (String)"InContractListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String id = selectedRowCollection.get(0).getPrimaryKeyValue().toString();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmct_incontract");
        String contStatus = contract.getDynamicObject(CONTRACTSTATUS).getString("number");
        if (StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INDRAFT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.INAUDIT.getValue()) || StringUtils.equals((CharSequence)contStatus, (CharSequence)ContractStatusEnum.APPROVED.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u67e5\u770b\u7b7e\u8ba2\u4fe1\u606f\u3002", (String)"InContractListPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        map.put("contractId", id);
        map.put("formId", "pmct_contsign");
        map.put(CONTRACTSTATUS, contStatus);
        map.put("ismulticontract", contract.get("ismulticontract"));
        FormShowParameter showParameter = new FormShowParameter();
        QFilter contFilter = new QFilter("contract", "=", (Object)Long.parseLong(id));
        String selectedProperties = "partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, signdate, signaddress, signaddressdetail, contract";
        DynamicObject[] contractSigns = BusinessDataServiceHelper.load((String)"pmct_contsign", (String)selectedProperties, (QFilter[])new QFilter[]{contFilter});
        if (contractSigns != null && contractSigns.length == 1) {
            DynamicObject contractSign = contractSigns[0];
            map.put("pkId", contractSign.getPkValue().toString());
            showParameter = FormShowParameter.createFormShowParameter(map);
            Object signDate = contract.get("signdate");
            showParameter.setCustomParam("signdate", signDate);
            showParameter.setStatus(OperationStatus.VIEW);
        } else if (contractSigns == null || contractSigns.length == 0) {
            showParameter = FormShowParameter.createFormShowParameter(map);
            Object signDate = contract.get("signdate");
            showParameter.setCustomParam("signdate", signDate);
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_contsign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object data = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"pmct_contsign") && data != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u8ba2\u6210\u529f\u3002", (String)"InContractListPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void doViewContract(ListSelectedRowCollection selectedRowCollection) {
        String id = selectedRowCollection.get(0).getPrimaryKeyValue().toString();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmct_incontract");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pkId", contract.getPkValue().toString());
        param.put("formId", "pmct_incontract");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("viewStyle", (Object)"oldContrct");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_incontract"));
        this.getView().showForm(showParameter);
    }

    private void beforeDoViewContract(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRowCollection) {
        if (selectedRowCollection.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InContractListPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            args.setCancel(true);
        }
    }
}

