/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ItemDetailF7EditPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchAp = (Search)this.getView().getControl("searchap");
        searchAp.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent paramSearchEnterEvent) {
        Search search = (Search)paramSearchEnterEvent.getSource();
        if (StringUtils.equals((CharSequence)"searchap", (CharSequence)search.getKey())) {
            this.updateEntryBySerachText(paramSearchEnterEvent.getText());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object currencyId = this.getView().getFormShowParameter().getCustomParam("currency");
        this.getModel().setValue("currency", currencyId);
        this.updateEntry();
    }

    private DynamicObjectCollection setClaimArrDataToEntry(String payDirection, DynamicObjectCollection entryCollection, DynamicObject[] claimArr) {
        if (claimArr == null || claimArr.length == 0) {
            return entryCollection;
        }
        DynamicObjectType entryType = entryCollection.getDynamicObjectType();
        for (int i = 0; i < claimArr.length; ++i) {
            DynamicObject claim = claimArr[i];
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("detailitem", (Object)claim.getString("billname"));
            entryObj.set("detailpayitem", (Object)claim.getDynamicObject("contpayitem"));
            entryObj.set("detailoftaxamt", (Object)claim.getBigDecimal("claimoftaxamount"));
            entryObj.set("detailtaxamt", (Object)claim.getBigDecimal("taxamount"));
            entryObj.set("detailamt", (Object)claim.getBigDecimal("claimamount"));
            entryObj.set("billnumber", (Object)claim.getString("billno"));
            entryObj.set("billname", (Object)claim.getString("billname"));
            entryObj.set("detailcreator", (Object)claim.getDynamicObject("creator"));
            entryObj.set("detailcreatetime", (Object)claim.getDate("createtime"));
            entryObj.set("detailauditor", (Object)claim.getDynamicObject("auditor"));
            entryObj.set("detailauditdate", (Object)claim.getDate("auditdate"));
            entryObj.set("referbilltype", (Object)"claim");
            entryObj.set("referbillid", claim.getPkValue());
            entryObj.set("detailbudgetitem", (Object)claim.getDynamicObject("budgetitem"));
            entryCollection.add((Object)entryObj);
        }
        return entryCollection;
    }

    private DynamicObjectCollection setPerformRecordArrToEntry(String payDirection, String serachText, Set<Long> selectedPerformEntryIdSet, DynamicObjectCollection entryCollection, DynamicObject[] performRecordArr) {
        if (performRecordArr == null || performRecordArr.length == 0) {
            return entryCollection;
        }
        DynamicObjectType entryType = entryCollection.getDynamicObjectType();
        for (DynamicObject performRecord : performRecordArr) {
            DynamicObject entryObj;
            boolean isNeedSettle;
            boolean isSettle;
            DynamicObjectCollection performRecordEntryCol;
            if (StringUtils.isNotBlank((CharSequence)serachText)) {
                if (performRecord.getString("billno").contains(serachText) || performRecord.getString("name").contains(serachText)) {
                    performRecordEntryCol = performRecord.getDynamicObjectCollection("entryentity");
                    for (DynamicObject performRecordEntry : performRecordEntryCol) {
                        if (selectedPerformEntryIdSet.contains(performRecordEntry.getPkValue())) continue;
                        isSettle = performRecordEntry.getBoolean("issettle");
                        isNeedSettle = performRecordEntry.getBoolean("isneedsettle");
                        if (!isNeedSettle || isSettle) continue;
                        entryObj = this.newEntry(payDirection, performRecord, performRecordEntry, entryType);
                        entryCollection.add((Object)entryObj);
                    }
                    continue;
                }
                performRecordEntryCol = performRecord.getDynamicObjectCollection("entryentity");
                for (DynamicObject performRecordEntry : performRecordEntryCol) {
                    if (selectedPerformEntryIdSet.contains(performRecordEntry.getPkValue()) || !performRecordEntry.getString("record").contains(serachText)) continue;
                    isSettle = performRecordEntry.getBoolean("issettle");
                    isNeedSettle = performRecordEntry.getBoolean("isneedsettle");
                    if (!isNeedSettle || isSettle) continue;
                    entryObj = this.newEntry(payDirection, performRecord, performRecordEntry, entryType);
                    entryCollection.add((Object)entryObj);
                }
                continue;
            }
            performRecordEntryCol = performRecord.getDynamicObjectCollection("entryentity");
            for (DynamicObject performRecordEntry : performRecordEntryCol) {
                if (selectedPerformEntryIdSet.contains(performRecordEntry.getPkValue())) continue;
                isSettle = performRecordEntry.getBoolean("issettle");
                isNeedSettle = performRecordEntry.getBoolean("isneedsettle");
                if (!isNeedSettle || isSettle) continue;
                entryObj = this.newEntry(payDirection, performRecord, performRecordEntry, entryType);
                entryCollection.add((Object)entryObj);
            }
        }
        return entryCollection;
    }

    private DynamicObject newEntry(String payDirection, DynamicObject performRecord, DynamicObject performRecordEntry, DynamicObjectType entryType) {
        DynamicObject entryObj = new DynamicObject(entryType);
        entryObj.set("detailitem", (Object)performRecordEntry.getString("record"));
        entryObj.set("detailpayitem", (Object)performRecordEntry.getDynamicObject("contpayitem"));
        entryObj.set("detailoftaxamt", (Object)performRecordEntry.getBigDecimal("amount"));
        entryObj.set("detailtaxamt", (Object)performRecordEntry.getBigDecimal("tax"));
        entryObj.set("detailamt", (Object)performRecordEntry.getBigDecimal("notaxamount"));
        entryObj.set("billnumber", (Object)performRecord.getString("billno"));
        entryObj.set("billname", (Object)performRecord.getString("name"));
        entryObj.set("detailcreator", (Object)performRecord.getDynamicObject("creator"));
        entryObj.set("detailcreatetime", (Object)performRecord.getDate("createtime"));
        entryObj.set("detailauditor", (Object)performRecord.getDynamicObject("auditor"));
        entryObj.set("detailauditdate", (Object)performRecord.getDate("auditdate"));
        entryObj.set("referbilltype", (Object)"perform");
        entryObj.set("referbillid", performRecord.getPkValue());
        entryObj.set("referentryid", performRecordEntry.getPkValue());
        entryObj.set("detailbudgetitem", (Object)performRecordEntry.getDynamicObject("budgetitem"));
        return entryObj;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"returntoparent", (CharSequence)operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (int i : selectRows) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
                collection.add((Object)entry);
            }
            this.getView().returnDataToParent((Object)collection);
            this.getView().close();
        }
    }

    private void updateEntry() {
        this.updateEntryBySerachText("");
    }

    private void updateEntryBySerachText(String serachText) {
        this.getModel().deleteEntryData("entryentity");
        QFilter claimFilter = null;
        QFilter performFilter = null;
        if (StringUtils.isNotBlank((CharSequence)serachText)) {
            claimFilter = new QFilter("billno", "like", (Object)("%" + serachText + "%")).or(new QFilter("billname", "like", (Object)("%" + serachText + "%")));
            performFilter = new QFilter("billno", "like", (Object)("%" + serachText + "%")).or(new QFilter("name", "like", (Object)("%" + serachText + "%"))).or(new QFilter("entryentity.record", "like", (Object)("%" + serachText + "%")));
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        Map<String, Set<Long>> selectedIdSetMap = this.getSelectedIdSetMap(parentModel);
        Set<Long> selectedClaimBillIdSet = selectedIdSetMap.get("claim");
        Set<Long> selectedPerformEntryIdSet = selectedIdSetMap.get("perform");
        QFilter noSelectedClaimIdFilter = new QFilter("id", "not in", selectedClaimBillIdSet);
        DynamicObject parentObject = parentModel.getDataEntity();
        String payDirection = parentObject.getString("paydirection");
        DynamicObject period = parentObject.getDynamicObject("period");
        Date beginDate = parentObject.getDate("begindate");
        Date endDate = parentObject.getDate("enddate");
        DynamicObject contract = parentObject.getDynamicObject("contract");
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter periodFilter = new QFilter("period", "=", period.getPkValue());
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)payDirection);
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)"0");
        QFilter isNotSettleFilter = new QFilter("issettle", "=", (Object)"0");
        QFilter largeEqBeginDateFilter = new QFilter("bizdate", ">=", (Object)beginDate);
        QFilter lessEqEndDateFilter = new QFilter("bizdate", "<=", (Object)endDate);
        DynamicObjectCollection entryCollection = this.getModel().getEntryEntity("entryentity");
        QFilter[] claimQfilters = new QFilter[]{noSelectedClaimIdFilter, claimFilter, contractFilter, billStatusFilter, periodFilter, payDirectionFilter, isNeedSettleFilter, isNotSettleFilter};
        QFilter[] performRecordQfilters = new QFilter[]{performFilter, contractFilter, billStatusFilter, largeEqBeginDateFilter, lessEqEndDateFilter, payDirectionFilter};
        DynamicObject[] claimArr = this.getClaimArr(payDirection, claimQfilters);
        DynamicObject[] performRecordArr = this.getPerformRecordArr(payDirection, performRecordQfilters);
        entryCollection = this.setClaimArrDataToEntry(payDirection, entryCollection, claimArr);
        entryCollection = this.setPerformRecordArrToEntry(payDirection, serachText, selectedPerformEntryIdSet, entryCollection, performRecordArr);
        this.getModel().updateEntryCache(entryCollection);
        this.getView().updateView("entryentity");
    }

    private DynamicObject[] getClaimArr(String payDirection, QFilter[] qFilters) {
        if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
            return BusinessDataServiceHelper.load((String)"pmct_inclaimbill", (String)"billno,billname,contract,period,contpayitem,claimoftaxamount,taxamount,claimamount,creator,createtime,auditor,auditdate,,isneedsettle,issettle,budgetitem", (QFilter[])qFilters);
        }
        return BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"billno,billname,contract,period,contpayitem,claimoftaxamount,taxamount,claimamount,creator,createtime,auditor,auditdate,budgetitem", (QFilter[])qFilters);
    }

    private DynamicObject[] getPerformRecordArr(String payDirection, QFilter[] qFilters) {
        if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
            DynamicObject[] inPerformRecordArr = BusinessDataServiceHelper.load((String)"pmct_inperformrecords", (String)"billno,name,contract,entryentity,entryentity.record,entryentity.tax,entryentity.amount,entryentity.notaxamount,entryentity.contpayitem,creator,createtime,auditor,auditdate,entryentity.isneedsettle,entryentity.issettle,entryentity.budgetitem", (QFilter[])qFilters);
            return inPerformRecordArr;
        }
        DynamicObject[] outPerformRecordArr = BusinessDataServiceHelper.load((String)"pmct_outperformrecords", (String)"billno,name,contract,entryentity,entryentity.record,entryentity.tax,entryentity.amount,entryentity.notaxamount,entryentity.contpayitem,creator,createtime,auditor,auditdate,entryentity.isneedsettle,entryentity.issettle,entryentity.budgetitem", (QFilter[])qFilters);
        return outPerformRecordArr;
    }

    private Map<String, Set<Long>> getSelectedIdSetMap(IDataModel parentModel) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
        HashSet<Long> selectedClaimBillIdSet = new HashSet<Long>();
        HashSet<Long> selectedPerformEntryIdSet = new HashSet<Long>();
        DynamicObjectCollection payItemDetailEntryCol = parentModel.getEntryEntity("payitemdetailentry");
        for (DynamicObject payItemDetailEntry : payItemDetailEntryCol) {
            String referBillType = payItemDetailEntry.getString("referbilltype");
            if (StringUtils.equals((CharSequence)"claim", (CharSequence)referBillType)) {
                selectedClaimBillIdSet.add(payItemDetailEntry.getLong("referbillid"));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"perform", (CharSequence)referBillType)) continue;
            selectedPerformEntryIdSet.add(payItemDetailEntry.getLong("referentryid"));
        }
        resultMap.put("claim", selectedClaimBillIdSet);
        resultMap.put("perform", selectedPerformEntryIdSet);
        return resultMap;
    }
}

