/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmct.business.helper.ContractSettleHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;
import kd.pmgt.pmct.common.enums.ComputeSourceEnum;
import kd.pmgt.pmct.common.enums.PayItemTypeEnum;
import kd.pmgt.pmct.formplugin.AbstractContractSettleEditUI;

public class OutContractSettleEditUI
extends AbstractContractSettleEditUI {
    private static final Log logger = LogFactory.getLog(OutContractSettleEditUI.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("listmodelentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        BasedataEdit outBudget = (BasedataEdit)this.getControl("outbudget");
        outBudget.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contPartB = (BasedataEdit)this.getControl("contpartb");
        contPartB.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payBudgetItem = (BasedataEdit)this.getView().getControl("paybudgetitem");
        payBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit detailBudgetItem = (BasedataEdit)this.getControl("detailbudgetitem");
        detailBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
            this.getModel().setValue("begindate", (Object)period.getDate("begindate"));
            this.getModel().setValue("enddate", (Object)period.getDate("enddate"));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumamountfield_org_pro"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaloftaxamt_org_pro"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleoftaxamt_org_pro"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcalofamt"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcalofamt"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettleofamt"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumcaltaxamt"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumnotcaltaxamt"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumsettletaxamt"});
        this.getView().updateView("flexpanelap2");
        this.getView().updateView("flexpanelap21");
        this.getView().updateView("flexpanelap22");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int curIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        DynamicObject parentRow = null;
        DynamicObject currentRow = null;
        if (parentRowIndex >= 0 && curIndex >= 0 && (parentRow = this.getModel().getEntryRowEntity("listmodelentry", parentRowIndex)) != null) {
            currentRow = (DynamicObject)parentRow.getDynamicObjectCollection("listentry").get(curIndex);
        }
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal ofTaxAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        boolean amtChangeFlag = false;
        switch (propName) {
            case "thisqty": {
                amtChangeFlag = true;
                qty = (BigDecimal)propValue;
                if (currentRow == null) break;
                BigDecimal totalQty = currentRow.getBigDecimal("totalqty");
                BigDecimal preQty = currentRow.getBigDecimal("preqty");
                preAmount = currentRow.getBigDecimal("preamout");
                BigDecimal balanceQty = totalQty.subtract(preQty);
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                boolean openedContract = contract.getBoolean("openedcontract");
                if (qty.compareTo(balanceQty) > 0 && !openedContract) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u672c\u671f\u8ba1\u91cf\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\uff08\u603b\u6570\u91cf-\u671f\u521d\u7d2f\u8ba1\u8ba1\u91cf\u6570\u91cf\uff09\u3002", (String)"OutContractSettleEditUI_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("thisqty", (Object)BigDecimal.ZERO, curIndex, parentRowIndex);
                    return;
                }
                this.getModel().setValue("lstqty", (Object)preQty.add(qty), curIndex, parentRowIndex);
                BigDecimal taxPrice = currentRow.getBigDecimal("curtaxprice");
                if (taxPrice.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObject rateObj = currentRow.getDynamicObject("listrate");
                    if (rateObj != null) {
                        taxRate = rateObj.getBigDecimal("taxrate");
                    }
                    if (taxRate != null) {
                        taxRate = taxRate.divide(BigDecimal.valueOf(100L));
                        ofTaxAmount = taxPrice.multiply(qty);
                        amount = ofTaxAmount.divide(BigDecimal.ONE.add(taxRate), amtPrecision, 4);
                        tax = ofTaxAmount.subtract(amount);
                    }
                }
                this.getModel().setValue("lstamount", (Object)preAmount.add(amount), curIndex, parentRowIndex);
                break;
            }
            case "thisamount": {
                amtChangeFlag = true;
                if (currentRow == null) break;
                BigDecimal thisAmount = (BigDecimal)propValue;
                DynamicObject rateObj = currentRow.getDynamicObject("listrate");
                if (rateObj != null) {
                    taxRate = rateObj.getBigDecimal("taxrate");
                }
                preAmount = currentRow.getBigDecimal("preamout");
                if (taxRate != null) {
                    if ((taxRate = taxRate.divide(BigDecimal.valueOf(100L))).compareTo(BigDecimal.ZERO) != 0) {
                        ofTaxAmount = thisAmount.multiply(BigDecimal.ONE.add(taxRate));
                        tax = ofTaxAmount.subtract(thisAmount);
                    } else {
                        ofTaxAmount = thisAmount;
                    }
                }
                amount = thisAmount;
                this.getModel().setValue("lstamount", (Object)preAmount.add(amount), curIndex, parentRowIndex);
                break;
            }
            case "thistax": {
                amtChangeFlag = true;
                if (currentRow == null) break;
                tax = (BigDecimal)propValue;
                ofTaxAmount = currentRow.getBigDecimal("thisoftaxmount");
                preAmount = currentRow.getBigDecimal("preamout");
                amount = ofTaxAmount.subtract(tax);
                break;
            }
            case "thisoftaxmount": {
                amtChangeFlag = true;
                if (currentRow == null) break;
                ofTaxAmount = (BigDecimal)propValue;
                DynamicObject rateObj = currentRow.getDynamicObject("listrate");
                if (rateObj != null) {
                    taxRate = rateObj.getBigDecimal("taxrate");
                }
                preAmount = currentRow.getBigDecimal("preamout");
                if (taxRate != null) {
                    if ((taxRate = taxRate.divide(BigDecimal.valueOf(100L))).compareTo(BigDecimal.ZERO) != 0) {
                        amount = ofTaxAmount.divide(BigDecimal.ONE.add(taxRate), 10, 4);
                        tax = ofTaxAmount.subtract(amount);
                    } else {
                        amount = ofTaxAmount;
                    }
                }
                this.getModel().setValue("lstamount", (Object)preAmount.add(amount), curIndex, parentRowIndex);
                break;
            }
            case "listrate": {
                amtChangeFlag = true;
                if (currentRow == null) break;
                DynamicObject rateObj = (DynamicObject)propValue;
                if (rateObj != null) {
                    taxRate = rateObj.getBigDecimal("taxrate");
                }
                BigDecimal thisAmount = currentRow.getBigDecimal("thisamount");
                preAmount = currentRow.getBigDecimal("preamout");
                if (taxRate != null) {
                    if ((taxRate = taxRate.divide(BigDecimal.valueOf(100L))).compareTo(BigDecimal.ZERO) != 0) {
                        ofTaxAmount = thisAmount.multiply(BigDecimal.ONE.add(taxRate));
                        tax = ofTaxAmount.subtract(thisAmount);
                    } else {
                        ofTaxAmount = thisAmount;
                    }
                }
                amount = thisAmount;
                this.getModel().setValue("lstamount", (Object)preAmount.add(amount), curIndex, parentRowIndex);
                break;
            }
        }
        if (amtChangeFlag) {
            this.getModel().beginInit();
            this.getModel().setValue("thisamount", (Object)amount, curIndex, parentRowIndex);
            this.getModel().setValue("thisoftaxmount", (Object)ofTaxAmount, curIndex, parentRowIndex);
            this.getModel().setValue("thistax", (Object)tax, curIndex, parentRowIndex);
            this.getModel().endInit();
            this.getView().updateView("listentry");
            this.getModel().setValue("lstamount", (Object)preAmount.add(amount), curIndex);
            this.sumListModelAmount();
            this.sumHeadAmount();
            ContractSettleHelper.setEnableItementry((IFormView)this.getView());
        }
    }

    private void loadContractListing(DynamicObject contract) {
        DynamicObjectCollection listConfigs = ContractTypeUtils.getListConfigs((DynamicObject)contract.getDynamicObject("contracttype"));
        if (listConfigs == null || listConfigs.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData("listmodelentry");
        for (DynamicObject listConfig : listConfigs) {
            String tabName = listConfig.getString("tabname");
            String cmpRule = listConfig.getString("computerule");
            int rowIndex = this.getModel().createNewEntryRow("listmodelentry");
            this.getModel().setValue("modelname", (Object)tabName, rowIndex);
            this.getModel().setValue("listmodelid", listConfig.getPkValue(), rowIndex);
            if ("00".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(+)", rowIndex);
                continue;
            }
            if ("01".equals(cmpRule)) {
                this.getModel().setValue("cmptype", (Object)"(-)", rowIndex);
                continue;
            }
            if (!"02".equals(cmpRule)) continue;
            this.getModel().setValue("cmptype", (Object)"(0)", rowIndex);
        }
        CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
        cardEntry.selectRows(0);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isOnList = (Boolean)this.getModel().getValue("isonlist");
        if (!isOnList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listingpanelap"});
        } else {
            int rowCount = this.getModel().getEntryRowCount("listmodelentry");
            if (rowCount > 0) {
                CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
                cardEntry.selectRows(0);
                cardEntry.entryRowClick(Integer.valueOf(0));
            }
        }
        ContractSettleHelper.setEnableItementry((IFormView)this.getView());
    }

    @Override
    public void onPeriodChange() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        this.getModel().setValue("begindate", period == null ? null : period.getDate("begindate"));
        this.getModel().setValue("enddate", period == null ? null : period.getDate("enddate"));
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (period == null || contract == null) {
            int rowCount = this.getModel().getEntryRowCount("itementry");
            for (int index = 0; index < rowCount; ++index) {
                DynamicObject payItem = (DynamicObject)this.getModel().getValue("payitem", index);
                String computeSource = payItem.getString("computesource");
                if (!computeSource.equals(ComputeSourceEnum.CLAIM.getValue())) continue;
                this.getModel().setValue("oftaxamount", null, index);
                this.getModel().setValue("amount", null, index);
                this.getModel().setValue("taxamt", null, index);
            }
        } else {
            int rowCount = this.getModel().getEntryRowCount("itementry");
            for (int index = 0; index < rowCount; ++index) {
                DynamicObject payItem = (DynamicObject)this.getModel().getValue("payitem", index);
                String computeSource = payItem.getString("computesource");
                if (!computeSource.equals(ComputeSourceEnum.CLAIM.getValue())) continue;
                QFilter[] filters = new QFilter[]{new QFilter("contract", "=", contract.getPkValue()), new QFilter("period", "=", period.getPkValue()), new QFilter("billstatus", "=", (Object)"C")};
                DynamicObject claim = BusinessDataServiceHelper.loadSingle((String)"pmct_outclaimbill", (String)String.join((CharSequence)",", "claimoftaxamount", "claimamount", "taxamount"), (QFilter[])filters);
                this.getModel().setValue("oftaxamount", (Object)(claim == null ? null : claim.getBigDecimal("claimoftaxamount")), index);
                this.getModel().setValue("amount", (Object)(claim == null ? null : claim.getBigDecimal("claimamount")), index);
                this.getModel().setValue("taxamt", (Object)(claim == null ? null : claim.getBigDecimal("taxamount")), index);
            }
        }
    }

    @Override
    public void onChangeContract() {
        IDataModel model = this.getModel();
        DynamicObject contract = (DynamicObject)model.getValue("contract");
        if (contract != null) {
            QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
            filter.and(new QFilter("contract", "=", contract.getPkValue()));
            DynamicObject[] existedBills = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)"billno", (QFilter[])new QFilter[]{filter});
            DynamicObject dataEntity = model.getDataEntity();
            if (existedBills.length > 0 && !dataEntity.getString("id").equals(existedBills[0].getString("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u652f\u51fa\u5408\u540c\u7ed3\u7b97\u5355%s\uff0c\u518d\u5904\u7406\u540e\u7eed\u5355\u636e\u3002", (String)"OutContractSettleEditUI_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), existedBills[0].getString("billno")));
            }
        }
        model.deleteEntryData("itementry");
        if (contract == null) {
            DynamicObjectCollection listEntry;
            model.setValue("taxrate", null);
            model.setValue("ismultirate", (Object)Boolean.FALSE);
            model.setValue("ismulticurrency", (Object)Boolean.FALSE);
            model.setValue("isonlist", (Object)Boolean.FALSE);
            model.setValue("contattr", null);
            DynamicObjectCollection modelEntry = model.getEntryEntity("listmodelentry");
            if (modelEntry != null) {
                model.deleteEntryData("listmodelentry");
            }
            if ((listEntry = model.getEntryEntity("listentry")) != null) {
                model.deleteEntryData("listentry");
            }
            model.setValue("contpartb", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"contpartb"});
            return;
        }
        DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        Boolean isMultiContract = (Boolean)model.getValue("ismulticontract");
        DynamicObject conProject = singleContract.getDynamicObject("project");
        if (!isMultiContract.booleanValue()) {
            if (conProject != null) {
                model.setValue("project", conProject.getPkValue());
            } else {
                model.setValue("project", null);
            }
        } else {
            String orgPk = singleContract.getDynamicObject("org").getPkValue().toString();
            DynamicObject curOrg = (DynamicObject)model.getValue("org");
            String curOrgPk = curOrg.getPkValue().toString();
            DynamicObject curProject = (DynamicObject)model.getValue("project");
            if (orgPk.equals(curOrgPk) && conProject != null && curProject == null) {
                model.setValue("project", conProject.getPkValue());
            }
        }
        model.setValue("ismulticurrency", (Object)singleContract.getBoolean("ismulticurrency"));
        model.setValue("ismultirate", (Object)singleContract.getBoolean("ismultirate"));
        model.setValue("isonlist", (Object)singleContract.getBoolean("isonlist"));
        DynamicObject taxRate = singleContract.getDynamicObject("lsttaxrate");
        if (taxRate != null) {
            model.setValue("taxrate", taxRate.getPkValue());
        } else {
            taxRate = singleContract.getDynamicObject("taxrate");
            if (taxRate != null) {
                model.setValue("taxrate", taxRate.getPkValue());
            }
        }
        if (singleContract.getDynamicObject("contracttype") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u7684\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"OutContractSettleEditUI_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        Object contTypePk = singleContract.getDynamicObject("contracttype").getPkValue();
        QFilter commonFilter = new QFilter("enable", "=", (Object)"1").and("paymentitemtype", "=", (Object)PayItemTypeEnum.FIXED.getValue());
        QFilter preFilter = new QFilter("ispreitem", "=", (Object)Boolean.TRUE).and(commonFilter);
        QFilter contTypeFilter = new QFilter("contracttype", "in", Collections.singleton(contTypePk)).and(commonFilter);
        boolean isMultiRate = singleContract.getBoolean("ismultirate");
        boolean isOnList = singleContract.getBoolean("isonlist");
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmct_payitem", (String)"id,isupdateamount,computesource,ispreitem,description", (QFilter[])new QFilter[]{preFilter.or(contTypeFilter)}, (String)"ispreitem desc,number asc");
        ORM orm = ORM.create();
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        long[] itemEntryIds = orm.genLongIds((IDataEntityType)itemEntry.getRootEntityType(), payItems.length);
        int itemIndex = 0;
        for (DynamicObject payItem : payItems) {
            int row = model.createNewEntryRow("itementry");
            model.setValue("itementry.id", (Object)itemEntryIds[itemIndex], itemIndex);
            model.setValue("payitem", payItem.getPkValue(), row);
            if (payItem.getBoolean("ispreitem")) {
                if (StringUtils.equals((CharSequence)"850444247600913408", (CharSequence)payItem.getString("id"))) {
                    this.initContractSettleItem(singleContract, taxRate, isMultiRate, isOnList);
                }
            } else {
                model.setValue("remark", (Object)payItem.getString("description"), row);
            }
            ++itemIndex;
        }
        if (!isOnList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listingpanelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"listingpanelap"});
        }
        model.setValue("conttotaloftaxamount", (Object)singleContract.getBigDecimal("totaloftaxamount"));
        model.setValue("totalsettleoftaxamount", (Object)singleContract.getBigDecimal("totalsettleoftaxamount"));
        if (singleContract.getBoolean("ismulticontract")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"contpartb"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contpartb"});
        }
        model.setValue("contpartb", (Object)singleContract.getDynamicObject("partb"));
        this.loadContractListing(singleContract);
    }

    private void initContractSettleItem(DynamicObject contract, DynamicObject taxRate, boolean isMultiRate, boolean isOnList) {
        boolean ismultiContract = (Boolean)this.getModel().getValue("ismulticontract");
        if (!(isMultiRate || isOnList || ismultiContract)) {
            this.getModel().setValue("paybudgetitem", (Object)contract.getDynamicObject("budgetitem"), 0);
        }
        if (isMultiRate && !isOnList && !ismultiContract) {
            this.getModel().setValue("paybudgetitem", (Object)contract.getDynamicObject("budgetitem"), 0);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        int row = event.getRow();
        if ("outbudget".equals(propertyName) || "paybudgetitem".equals(propertyName) || "detailbudgetitem".equals(propertyName)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u9879\u76ee\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"OutContractSettleEditUI_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilterByProject(project, PayDirectionEnum.OUT.getValue());
            if (idFilter == null) {
                return;
            }
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.setMultiSelect(false);
            parameter.getListFilterParameter().getQFilters().add(idFilter);
        } else if ("contract".equals(propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            Boolean isMultiContract = (Boolean)this.getModel().getValue("ismulticontract");
            if (qFilters.size() > 1) {
                List<Long> contractIds = new ArrayList(16);
                QFilter contractQFilter = null;
                for (QFilter qFilter : qFilters) {
                    if (!qFilter.getProperty().startsWith("id") || !qFilter.getCP().equals("in") || qFilter.getValue() == null) continue;
                    contractQFilter = qFilter;
                    contractIds = (List)qFilter.getValue();
                }
                if (isMultiContract.booleanValue()) {
                    contractIds.clear();
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                    Long orgpk = org != null ? Long.valueOf(Long.parseLong(org.getPkValue().toString())) : null;
                    Long propk = project != null ? Long.valueOf(Long.parseLong(project.getPkValue().toString())) : null;
                    DynamicObject[] shareContracts = ContractHelper.getContractByMultiPartSettle((Long)propk, (Long)orgpk);
                    if (shareContracts != null && shareContracts.length > 0) {
                        for (DynamicObject shareContract : shareContracts) {
                            contractIds.add(Long.parseLong(shareContract.getPkValue().toString()));
                        }
                    }
                } else {
                    QFilter contractIdsFilter = new QFilter("id", "in", contractIds);
                    List nonMultipartContractIds = Arrays.stream(BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"multipartsettlement", (QFilter[])new QFilter[]{contractIdsFilter})).filter(contract -> !contract.getBoolean("multipartsettlement")).map(it -> it.getLong("id")).collect(Collectors.toList());
                    contractIds.clear();
                    contractIds.addAll(nonMultipartContractIds);
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("multipartsettlement", "=", (Object)false));
                }
                if (contractQFilter == null && contractIds.size() > 0) {
                    contractQFilter = new QFilter("id", "in", contractIds);
                    showParameter.getListFilterParameter().setQFilters(Collections.singletonList(contractQFilter));
                } else if (contractQFilter != null) {
                    contractQFilter.and(new QFilter("id", "in", contractIds));
                }
            }
            ContractHelper.getContractByStatus((String)"pmct_outcontract_settle", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
        }
        if ("contpartb".equals(propertyName)) {
            DynamicObject contract2 = (DynamicObject)this.getModel().getValue("contract");
            ArrayList<Object> contPartBs = new ArrayList<Object>();
            if (contract2 != null) {
                DynamicObject partB = contract2.getDynamicObject("partb");
                DynamicObjectCollection otherPart = contract2.getDynamicObjectCollection("otherpart");
                contPartBs.add(partB.getPkValue());
                if (!otherPart.isEmpty()) {
                    for (DynamicObject other : otherPart) {
                        contPartBs.add(other.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
            }
            QFilter contPartBFilter = new QFilter("id", "in", contPartBs);
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(contPartBFilter);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }
}

