/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ProjectInvoiceStatisticsPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ProjectInvoiceStatisticsPlugin.class);
    private String[] xAxisArray;

    protected void getAxisArray() {
        if (this.xAxisArray == null || this.xAxisArray.length == 0) {
            this.xAxisArray = new String[]{ResManager.loadKDString((String)"\u53d1\u7968\u7a0e\u989d", (String)"ProjectInvoiceStatisticsPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d", (String)"ProjectInvoiceStatisticsPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d1\u7968\u542b\u7a0e\u91d1\u989d", (String)"ProjectInvoiceStatisticsPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])};
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String propName = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            List orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            Set hasPermProjectIdList = ProjectF7FilterHelper.loadHasPermProjectList((IFormView)this.getView(), (List)orgList);
            QFilter idFilter = new QFilter("id", "in", (Object)hasPermProjectIdList);
            showParameter.getListFilterParameter().getQFilters().add(idFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        Object project = paramMap.get("project");
        if (project == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"initflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"balanceoftax"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoicedetailap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoicechartap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit projectEdit = (BasedataEdit)this.getView().getControl("project");
        projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid inInvoiceEntry = (EntryGrid)this.getControl("inentryentity");
        inInvoiceEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid outInvoiceEntry = (EntryGrid)this.getControl("outentryentity");
        outInvoiceEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if (StringUtils.equals((CharSequence)"viewchart", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjectInvoiceStatisticsPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"initflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"balanceoftax"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"invoicedetailap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"invoicechartap"});
            Label projectLabel = (Label)this.getView().getControl("projectlabelap");
            projectLabel.setText(project.getString("name"));
            this.updateData();
        }
    }

    private void updateData() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            return;
        }
        this.getInInvoiceAmount();
        this.getOutInvoiceAmount();
        this.updateInvoiceChart();
        this.setbalanceTax();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.updateData();
            return;
        }
        if (StringUtils.equals((CharSequence)"startperiod", (CharSequence)propName)) {
            this.clearQuickSearch();
            DynamicObject startPeriod = (DynamicObject)newValue;
            DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
            if (!this.isPeriodValid(startPeriod, endPeriod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u671f\u95f4\u4e0d\u80fd\u665a\u4e8e\u622a\u6b62\u671f\u95f4\u3002", (String)"ProjectInvoiceStatisticsPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("startperiod", null);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"endperiod", (CharSequence)propName)) {
            this.clearQuickSearch();
            DynamicObject endPeriod = (DynamicObject)newValue;
            DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            if (!this.isPeriodValid(startPeriod, endPeriod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u671f\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8d77\u59cb\u671f\u95f4\u3002", (String)"ProjectInvoiceStatisticsPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("endperiod", null);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"thismonth", (CharSequence)propName)) {
            this.clearOtherData(propName);
            return;
        }
        if (StringUtils.equals((CharSequence)"thisyear", (CharSequence)propName)) {
            this.clearOtherData(propName);
            return;
        }
        if (StringUtils.equals((CharSequence)"total", (CharSequence)propName)) {
            this.clearOtherData(propName);
        }
    }

    protected boolean isPeriodValid(DynamicObject startPeriod, DynamicObject endPeriod) {
        Date enddate;
        if (startPeriod == null || endPeriod == null) {
            return true;
        }
        Date begindate = startPeriod.getDate("begindate");
        return begindate.compareTo(enddate = endPeriod.getDate("enddate")) < 0;
    }

    private QFilter getPeriodFilter() {
        QFilter periodFilter = null;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null || endPeriod != null) {
            if (startPeriod != null && endPeriod == null) {
                Date begindate = startPeriod.getDate("begindate");
                periodFilter = new QFilter("invoicedate", ">=", (Object)begindate);
            } else if (startPeriod == null && endPeriod != null) {
                Date enddate = endPeriod.getDate("enddate");
                periodFilter = new QFilter("invoicedate", "<=", (Object)enddate);
            } else if (startPeriod != null && endPeriod != null) {
                Date begindate = startPeriod.getDate("begindate");
                Date enddate = endPeriod.getDate("enddate");
                periodFilter = new QFilter("invoicedate", ">=", (Object)begindate).and(new QFilter("invoicedate", "<=", (Object)enddate));
            }
        } else {
            boolean isThisMonth = (Boolean)this.getModel().getValue("thismonth");
            boolean isThisYear = (Boolean)this.getModel().getValue("thisyear");
            boolean isTotal = (Boolean)this.getModel().getValue("total");
            if (isThisMonth) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 0);
                calendar.set(5, 1);
                Date begindate = calendar.getTime();
                calendar.add(2, 0);
                calendar.set(5, calendar.getActualMaximum(5));
                Date enddate = calendar.getTime();
                periodFilter = new QFilter("invoicedate", ">=", (Object)begindate).and(new QFilter("invoicedate", "<=", (Object)enddate));
            } else if (isThisYear) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(2, 0);
                calendar.set(5, 1);
                Date begindate = calendar.getTime();
                calendar.add(2, calendar.getActualMaximum(2));
                calendar.set(5, calendar.getActualMaximum(5));
                Date enddate = calendar.getTime();
                periodFilter = new QFilter("invoicedate", ">=", (Object)begindate).and(new QFilter("invoicedate", "<=", (Object)enddate));
            } else {
                if (isTotal) {
                    return null;
                }
                return null;
            }
        }
        return periodFilter;
    }

    private void clearQuickSearch() {
        this.getModel().beginInit();
        this.getModel().setValue("thismonth", (Object)Boolean.FALSE);
        this.getModel().setValue("thisyear", (Object)Boolean.FALSE);
        this.getModel().setValue("total", (Object)Boolean.FALSE);
        this.getModel().endInit();
        this.getView().updateView("thismonth");
        this.getView().updateView("thisyear");
        this.getView().updateView("total");
    }

    private void clearOtherData(String propName) {
        this.getModel().beginInit();
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
        if (StringUtils.equals((CharSequence)"thismonth", (CharSequence)propName)) {
            this.getModel().setValue("thisyear", (Object)Boolean.FALSE);
            this.getModel().setValue("total", (Object)Boolean.FALSE);
        } else if (StringUtils.equals((CharSequence)"thisyear", (CharSequence)propName)) {
            this.getModel().setValue("thismonth", (Object)Boolean.FALSE);
            this.getModel().setValue("total", (Object)Boolean.FALSE);
        } else if (StringUtils.equals((CharSequence)"total", (CharSequence)propName)) {
            this.getModel().setValue("thismonth", (Object)Boolean.FALSE);
            this.getModel().setValue("thisyear", (Object)Boolean.FALSE);
        }
        this.getModel().endInit();
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
        this.getView().updateView("thismonth");
        this.getView().updateView("thisyear");
        this.getView().updateView("total");
    }

    private void setbalanceTax() {
        BigDecimal inTotalTax = (BigDecimal)this.getModel().getValue("intotaltax");
        BigDecimal outTotalTax = (BigDecimal)this.getModel().getValue("outtotaltax");
        BigDecimal inOutBalanceTax = outTotalTax.subtract(inTotalTax);
        Label balancetax = (Label)this.getView().getControl("balancetax");
        DecimalFormat df1 = new DecimalFormat("###,###.##");
        balancetax.setText(df1.format(inOutBalanceTax));
        HashMap<String, String> propMap = new HashMap<String, String>();
        HashMap<String, String> otherMap = new HashMap<String, String>();
        if (inOutBalanceTax.compareTo(BigDecimal.ZERO) >= 0) {
            propMap.put("fc", "#00FF66");
            propMap.put("bc", "#00FF66");
            otherMap.put("fc", "#b2b2b2");
            otherMap.put("bc", "#b2b2b2");
            this.getView().updateControlMetadata("positivelabel", propMap);
            this.getView().updateControlMetadata("negativelabel", otherMap);
        } else {
            propMap.put("fc", "#FF0000");
            propMap.put("bc", "#FF0000");
            otherMap.put("fc", "#b2b2b2");
            otherMap.put("bc", "#b2b2b2");
            this.getView().updateControlMetadata("negativelabel", propMap);
            this.getView().updateControlMetadata("positivelabel", otherMap);
        }
    }

    private void getInInvoiceAmount() {
        QFilter projectFilter = new QFilter("project", "=", ((DynamicObject)this.getModel().getValue("project")).getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter periodFilter = this.getPeriodFilter();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,invoicetypeid,invoicetypeid.name,invoicecode,invoiceno,invoicedate,invoicestatus,receivedate,entryentity,totalamount,totaltax,totaloftaxamount", (QFilter[])new QFilter[]{billStatusFilter, projectFilter, periodFilter});
        this.getModel().deleteEntryData("inentryentity");
        if (invoices.length > 0) {
            this.getModel().batchCreateNewEntryRow("inentryentity", invoices.length);
        }
        BigDecimal proTotalTax = BigDecimal.ZERO;
        BigDecimal proTotalAmount = BigDecimal.ZERO;
        BigDecimal proTotalTaxAmount = BigDecimal.ZERO;
        if (invoices.length == 0) {
            this.getModel().setValue("intotaltax", (Object)BigDecimal.ZERO);
            this.getModel().setValue("intotalamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("intotaltaxamount", (Object)BigDecimal.ZERO);
        }
        for (int i = 0; i < invoices.length; ++i) {
            IDataModel model = this.getModel();
            if (invoices[i].getDynamicObject("contract") != null) {
                model.setValue("incontract", invoices[i].getDynamicObject("contract").getPkValue(), i);
            }
            model.setValue("ininvoice", invoices[i].getPkValue(), i);
            model.setValue("ininvoicecode", invoices[i].get("invoicecode"), i);
            model.setValue("ininvoiceno", invoices[i].get("invoiceno"), i);
            model.setValue("ininvoicedate", invoices[i].get("invoicedate"), i);
            model.setValue("ininvoicestatus", invoices[i].get("invoicestatus"), i);
            BigDecimal totalTax = invoices[i].getBigDecimal("totaltax");
            BigDecimal totalAmount = invoices[i].getBigDecimal("totalamount");
            BigDecimal totalOfTaxAmount = invoices[i].getBigDecimal("totaloftaxamount");
            model.setValue("ininvoicetax", (Object)totalTax, i);
            model.setValue("ininvoiceamount", (Object)totalAmount, i);
            model.setValue("ininvoicetaxamount", (Object)totalOfTaxAmount, i);
            if (InvoiceStatusEnum.CANCEL_2.getValue().equals(model.getValue("ininvoicestatus"))) continue;
            proTotalTax = proTotalTax.add(totalTax.setScale(2, RoundingMode.HALF_UP));
            proTotalAmount = proTotalAmount.add(totalAmount.setScale(2, RoundingMode.HALF_UP));
            proTotalTaxAmount = proTotalTaxAmount.add(totalOfTaxAmount.setScale(2, RoundingMode.HALF_UP));
            this.getModel().setValue("intotaltax", (Object)proTotalTax);
            this.getModel().setValue("intotalamount", (Object)proTotalAmount);
            this.getModel().setValue("intotaltaxamount", (Object)proTotalTaxAmount);
        }
    }

    private void getOutInvoiceAmount() {
        QFilter projectFilter = new QFilter("project", "=", ((DynamicObject)this.getModel().getValue("project")).getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter periodFilter = this.getPeriodFilter();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)String.join((CharSequence)",", "contract", "invoicetype", "invoicecode", "invoiceno", "invoicedate", "receivedate", "entryentity", "totalamount", "totaltax", "totaloftaxamount, invoicestatus"), (QFilter[])new QFilter[]{billStatusFilter, projectFilter, periodFilter});
        this.getModel().deleteEntryData("outentryentity");
        if (invoices.length > 0) {
            this.getModel().batchCreateNewEntryRow("outentryentity", invoices.length);
        }
        BigDecimal proTotalTax = BigDecimal.ZERO;
        BigDecimal proTotalAmount = BigDecimal.ZERO;
        BigDecimal proTotalTaxAmount = BigDecimal.ZERO;
        if (invoices.length == 0) {
            this.getModel().setValue("outtotaltax", (Object)BigDecimal.ZERO);
            this.getModel().setValue("outtotalamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("outtotaltaxamount", (Object)BigDecimal.ZERO);
        }
        for (int i = 0; i < invoices.length; ++i) {
            IDataModel model = this.getModel();
            if (invoices[i].getDynamicObject("contract") != null) {
                model.setValue("outcontract", invoices[i].getDynamicObject("contract").getPkValue(), i);
            }
            model.setValue("outinvoice", invoices[i].getPkValue(), i);
            model.setValue("outinvoicetype", invoices[i].get("invoicetype"), i);
            model.setValue("outinvoicecode", invoices[i].get("invoicecode"), i);
            model.setValue("outinvoiceno", invoices[i].get("invoiceno"), i);
            model.setValue("outinvoicedate", invoices[i].get("invoicedate"), i);
            model.setValue("outinvoicestatus", invoices[i].get("invoicestatus"), i);
            BigDecimal totalTax = invoices[i].getBigDecimal("totaltax");
            BigDecimal totalAmount = invoices[i].getBigDecimal("totalamount");
            BigDecimal totalOfTaxAmount = invoices[i].getBigDecimal("totaloftaxamount");
            model.setValue("outinvoicetax", (Object)totalTax, i);
            model.setValue("outinvoiceamount", (Object)totalAmount, i);
            model.setValue("outinvoicetaxamount", (Object)totalOfTaxAmount, i);
            if (invoices[i].getString("invoicestatus").equals(OutInvoiceStatusEnum.CANCEL_6.getValue())) continue;
            proTotalTax = proTotalTax.add(totalTax.setScale(2, RoundingMode.HALF_UP));
            proTotalAmount = proTotalAmount.add(totalAmount.setScale(2, RoundingMode.HALF_UP));
            proTotalTaxAmount = proTotalTaxAmount.add(totalOfTaxAmount.setScale(2, RoundingMode.HALF_UP));
            this.getModel().setValue("outtotaltax", (Object)proTotalTax);
            this.getModel().setValue("outtotalamount", (Object)proTotalAmount);
            this.getModel().setValue("outtotaltaxamount", (Object)proTotalTaxAmount);
        }
    }

    private void updateInvoiceChart() {
        HistogramChart invoiceChart = (HistogramChart)this.getControl("chartap");
        invoiceChart.clearData();
        this.getAxisArray();
        invoiceChart.createXAxis("", this.xAxisArray);
        invoiceChart.createYAxis(ResManager.loadKDString((String)"\u91d1\u989d", (String)"ProjectInvoiceStatisticsPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        invoiceChart.setShowTooltip(true);
        BarSeries outInvoice = invoiceChart.createBarSeries(ResManager.loadKDString((String)"\u9500\u9879", (String)"ProjectInvoiceStatisticsPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        BarSeries inInvoice = invoiceChart.createBarSeries(ResManager.loadKDString((String)"\u8fdb\u9879", (String)"ProjectInvoiceStatisticsPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        outInvoice.setColor("#60B060");
        inInvoice.setColor("#219DEF");
        invoiceChart.setLegendAlign(XAlign.right, YAlign.top);
        inInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("intotaltax")).setScale(2, RoundingMode.HALF_UP), "#219DEF");
        inInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("intotalamount")).setScale(2, RoundingMode.HALF_UP), "#219DEF");
        inInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("intotaltaxamount")).setScale(2, RoundingMode.HALF_UP), "#219DEF");
        outInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("outtotaltax")).setScale(2, RoundingMode.HALF_UP), "#60B060");
        outInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("outtotalamount")).setScale(2, RoundingMode.HALF_UP), "#60B060");
        outInvoice.addData("", (Number)((BigDecimal)this.getModel().getValue("outtotaltaxamount")).setScale(2, RoundingMode.HALF_UP), "#60B060");
        DecimalFormat df1 = new DecimalFormat("###,###.##");
        List outData = outInvoice.getData();
        for (Object outDatum : outData) {
            Map dataMap = (Map)outDatum;
            HashMap labelMap = new HashMap(16);
            HashMap<String, Object> normalMap = new HashMap<String, Object>(16);
            normalMap.put("show", Boolean.TRUE);
            normalMap.put("formatter", df1.format(dataMap.get("value")));
            labelMap.put("normal", normalMap);
            dataMap.put("label", labelMap);
        }
        List inData = inInvoice.getData();
        for (Object inDatum : inData) {
            Map dataMap = (Map)inDatum;
            HashMap labelMap = new HashMap(16);
            HashMap<String, Object> normalMap = new HashMap<String, Object>(16);
            normalMap.put("show", Boolean.TRUE);
            normalMap.put("formatter", df1.format(dataMap.get("value")));
            labelMap.put("normal", normalMap);
            dataMap.put("label", labelMap);
        }
        invoiceChart.bindData(null);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        int index = e.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"ininvoiceno")) {
            this.openInvoiceView("pmct_ininvoice", "inentryentity", "ininvoice", index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"incontract")) {
            this.openDyContractView("pmct_contractkanban", "inentryentity", "incontract", index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"outinvoiceno")) {
            this.openInvoiceView("pmct_outinvoice", "outentryentity", "outinvoice", index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"outcontract")) {
            this.openDyContractView("pmct_contractkanban", "outentryentity", "outcontract", index);
        }
    }

    private void openInvoiceView(String key, String entryentity, String invoice, int index) {
        DynamicObject row = this.getModel().getEntryRowEntity(entryentity, index);
        HashMap map = new HashMap();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(key);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId(row.getDynamicObject(invoice).getPkValue());
        StyleCss css = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openDyContractView(String key, String entryentity, String contract, int index) {
        DynamicObject row = this.getModel().getEntryRowEntity(entryentity, index);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", row.getDynamicObject(contract).getPkValue());
        if ("outcontract".equals(contract)) {
            map.put("payDirection", "IN");
        } else {
            map.put("payDirection", "OUT");
        }
        map.put("formId", key);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }
}

