/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.addition;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ContractAdditionListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String formId = ((ListView)this.getView()).getBillFormId();
        if ("pmct_outaddagreement".equals(formId)) {
            e.getQFilters().add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue()));
        } else {
            e.getQFilters().add(new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            ListView listView = (ListView)this.getView();
            ListSelectedRowCollection rows = listView.getSelectedRows().getBillListSelectedRowCollection();
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ContractAdditionListPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject conAdd = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)"pmct_addagreementtpl");
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)conAdd.getDynamicObject("contract").getPkValue(), (String)"pmct_contracttpl");
            DynamicObject contStatus = contract.getDynamicObject("contractstatus");
            List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            if (statusNums.contains(contStatus.getString("number"))) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractAdditionListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
    }
}

