/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.addition;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;

public class InContAddAgreeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String CALCULATE_RATIO = "calculateratio";
    public static final String CALCULATE_AMOUNT = "calculateamount";
    public static final String INCOMEPLAN_PANEL = "incomeplanpanel";
    public static final String PARAMETER_SOURCE_ID = "sourceid";
    public static final String PARAMETER_CONTRACT_ID = "contractid";
    public static final String PARAMETER_CHANGE_TYPE = "changetype";
    public static final String PARAMETER_FORMID = "formId";
    public static final String PARAMETER_CUSTOM_ENTRY_DATA = "entrydata";
    public static final String DELETEINCOME_ENTRY = "deleteincomeentry";
    public static final String VIEWCOMPARE = "viewcompare";
    private static final String CHANGETYPE_QUANTITY = "0";
    private static final String CHANGETYPE_PRICE = "1";
    private static final String CHANGETYPE_DETAILLISTING = "2";
    private static final String CHANGETYPE_NOTDETAILLISTING = "3";
    public static final String NEWENTRY = "newentry";
    private static final String CTRL_NEWINCOMEENTRY = "newincomeentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("listingbudgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        budgetItem.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmas_projectbudget", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        CardEntry cardEntry = (CardEntry)this.getView().getControl("cardentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"listingbudgetitem", (CharSequence)propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("project");
            if (Objects.nonNull(dynamicObject)) {
                String sourceTypeIn = "IN";
                QFilter contStatusFilter = new QFilter("project", "=", dynamicObject.getPkValue());
                QFilter typeFilter = new QFilter("sourcetype", "=", (Object)sourceTypeIn);
                contStatusFilter.and(typeFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
            } else {
                String msg = ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"InContAddAgreeEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                event.setCancel(true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"nodesetting", (CharSequence)propertyName)) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            this.beforeSelectNodeSetting(param);
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param) {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"003");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        int result = evt.getResult().getValue();
        switch (callBackId) {
            case "nodesetting": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "ctrlstrategy": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            this.budgetItemIsEnable(contract);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"budgetitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"listingbudgetitem"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newincomeentry": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("incomeplanentry");
                int rowIndex = entrys.size() - 1;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        DynamicObjectCollection planEntrys = this.getModel().getEntryEntity("incomeplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])planEntrys.toArray((Object[])new DynamicObject[planEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject planEntry : planEntrys) {
            DynamicObject nodeSetting = planEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            planEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long incomeItemId = planEntry.getLong("conplanitemid");
            if (0L == incomeItemId || QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)incomeItemId)) continue;
            planEntry.set("conplanitemid", null);
        }
    }

    private void budgetItemIsEnable(DynamicObject contract) {
        DynamicObject project = contract.getDynamicObject("project");
        if (Objects.nonNull(project)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"budgetitem"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"listingbudgetitem"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"budgetitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"listingbudgetitem"});
        }
        this.getModel().setValue("budgetitem", (Object)contract.getDynamicObject("budgetitem"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"budgetitem"});
        DynamicObjectCollection cardCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("cardentry");
        for (DynamicObject card : cardCollection) {
            DynamicObjectCollection subEntryCollection = card.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < subEntryCollection.size(); ++i) {
                String subAddType = ((DynamicObject)subEntryCollection.get(i)).getString("subaddtype");
                if (!CHANGETYPE_QUANTITY.equals(subAddType) && !CHANGETYPE_PRICE.equals(subAddType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"listingbudgetitem"});
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"cardentry", (CharSequence)control.getKey())) {
            int curRowIndex = evt.getRow();
            DynamicObjectCollection subEntryCollection = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("cardentry").get(curRowIndex)).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < subEntryCollection.size(); ++i) {
                String subAddType = ((DynamicObject)subEntryCollection.get(i)).getString("subaddtype");
                if (!CHANGETYPE_QUANTITY.equals(subAddType) && !CHANGETYPE_PRICE.equals(subAddType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"listingbudgetitem"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "calculateratio": {
                this.doCalculateRatio(model);
                break;
            }
            case "calculateamount": {
                this.doCalculateAmount(model);
                break;
            }
            case "viewcompare": {
                this.viewCompare();
                break;
            }
            case "deleteincomeentry": {
                this.checkDeleteIncomePlan(args, model);
                break;
            }
            case "newentry": {
                this.initNewEntry(args);
                break;
            }
            case "submit": {
                ((FormOperate)args.getSource()).getOption().setVariableValue("visible", this.getPageCache().get("visible"));
                break;
            }
            case "newincomeentry": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContAddAgreeEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void viewCompare() {
        if (this.getModel().getValue("contract") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContAddAgreeEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAMETER_SOURCE_ID, this.getModel().getDataEntity().getPkValue());
        param.put(PARAMETER_CONTRACT_ID, ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put(PARAMETER_CHANGE_TYPE, PayPlanSourceEnum.ADDITION.getValue());
        param.put(PARAMETER_FORMID, "pmct_inaddagreement");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_inaddagreement")).getDynamicObjectCollection("incomeplanentry").getDynamicObjectType();
        DynamicObjectCollection incomePlanEntries = this.getModel().getEntryEntity("incomeplanentry");
        param.put(PARAMETER_CUSTOM_ENTRY_DATA, DynamicObjectSerializeUtil.serialize((Object[])incomePlanEntries.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_incomeplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void checkDeleteIncomePlan(BeforeDoOperationEventArgs args, IDataModel model) {
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("incomeplanentry");
        DynamicObject entryRowEntity = model.getEntryRowEntity("incomeplanentry", entryCurrentRowIndex);
        String conIncomeitemId = entryRowEntity.getString("conplanitemid");
        if (StringUtils.isNotBlank((CharSequence)conIncomeitemId)) {
            DynamicObject conIncomeitemObj = BusinessDataServiceHelper.loadSingle((Object)conIncomeitemId, (String)"pmbs_contractcollectitem");
            BigDecimal collectedComAmt = conIncomeitemObj.getBigDecimal("collectedcomamt");
            if (collectedComAmt == null || collectedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u6536\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContAddAgreeEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String payItemName = conIncomeitemObj.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{conIncomeitemObj.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContAddAgreeEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = conIncomeitemObj.getBigDecimal("appliedcomamt");
            if (!NumberHelper.isNullZero((BigDecimal)appliedComAmt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u8bf7\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContAddAgreeEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected void doCalculateAmount(IDataModel model) {
        DynamicObjectCollection incomePlanEntry = model.getEntryEntity("incomeplanentry");
        if (!incomePlanEntry.isEmpty()) {
            BigDecimal latestAmountOfTax = (BigDecimal)model.getValue("latestamountoftax");
            for (DynamicObject incomePlanEntryObj : incomePlanEntry) {
                BigDecimal incomePercent = incomePlanEntryObj.getBigDecimal("incomepercent");
                BigDecimal incomeOfTaxAmount = latestAmountOfTax.multiply(incomePercent.divide(BigDecimal.valueOf(100L)));
                incomePlanEntryObj.set("incomeamountoftax", (Object)incomeOfTaxAmount);
                int index = incomePlanEntry.indexOf((Object)incomePlanEntryObj);
                this.getView().updateView("incomeamountoftax", index);
            }
        }
    }

    protected void doCalculateRatio(IDataModel model) {
        DynamicObjectCollection incomePlanEntry = model.getEntryEntity("incomeplanentry");
        if (!incomePlanEntry.isEmpty()) {
            BigDecimal latestAmountOfTax = (BigDecimal)model.getValue("latestamountoftax");
            if ((long)latestAmountOfTax.compareTo(BigDecimal.ZERO) == 0L) {
                return;
            }
            for (DynamicObject incomePlanEntryObj : incomePlanEntry) {
                BigDecimal incomeOfTaxAmount = incomePlanEntryObj.getBigDecimal("incomeamountoftax");
                BigDecimal ratio = incomeOfTaxAmount.divide(latestAmountOfTax, 4, 4).multiply(BigDecimal.valueOf(100L));
                incomePlanEntryObj.set("incomepercent", (Object)ratio);
                int index = incomePlanEntry.indexOf((Object)incomePlanEntryObj);
                this.getView().updateView("incomepercent", index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"incomepercent")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            BigDecimal incomeAmountOfTax = ((BigDecimal)newValue).divide(BigDecimal.valueOf(100L)).multiply(latestAmountOfTax);
            this.getModel().beginInit();
            this.getModel().setValue("incomeamountoftax", (Object)incomeAmountOfTax, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("incomeamountoftax", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomeamountoftax")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            BigDecimal payPercent = BigDecimal.ZERO;
            if (latestAmountOfTax.compareTo(BigDecimal.ZERO) != 0) {
                payPercent = ((BigDecimal)newValue).divide(latestAmountOfTax, 10, 4).multiply(BigDecimal.valueOf(100L));
            }
            this.getModel().beginInit();
            this.getModel().setValue("incomepercent", (Object)payPercent, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("incomepercent", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"contract")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (Objects.nonNull(contract)) {
                DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                DynamicObject budgetItem = singleContract.getDynamicObject("budgetitem");
                DynamicObject project = contract.getDynamicObject("project");
                if (Objects.nonNull(project)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"budgetitem"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"listingbudgetitem"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"budgetitem"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"listingbudgetitem"});
                }
                this.getModel().setValue("budgetitem", (Object)budgetItem);
                this.getView().setEnable(Boolean.FALSE, new String[]{"budgetitem"});
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"listid")) {
            if (Objects.nonNull(newValue)) {
                DynamicObject pmctContractList = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)"pmct_contractlist");
                DynamicObject listingBudgetItem = pmctContractList.getDynamicObject("listingbudgetitem");
                this.getModel().setValue("listingbudgetitem", (Object)listingBudgetItem, rowIndex);
            } else {
                this.getModel().setValue("listingbudgetitem", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"subaddtype")) {
            String subAddType = (String)this.getModel().getValue("subaddtype", rowIndex);
            if (CHANGETYPE_DETAILLISTING.equals(subAddType) || CHANGETYPE_NOTDETAILLISTING.equals(subAddType)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"listingbudgetitem"});
            } else if (CHANGETYPE_QUANTITY.equals(subAddType) || CHANGETYPE_PRICE.equals(subAddType)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"listingbudgetitem"});
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"nodesetting")) {
            this.nodeSettingChange(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"ctrlstrategy")) {
            this.ctrlStrategyChange(rowIndex, newValue, oldValue);
        }
    }

    protected void nodeSettingChange(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        Long incomeItemNodeId = null;
        if (null != incomeItem && null != incomeItem.getDynamicObject("nodesetting")) {
            incomeItemNodeId = incomeItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != incomeItemNodeId && ((DynamicObject)oldValue).getLong("id") == incomeItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContAddAgreeEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String incomeItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        String string = incomeItemStrategy = null == incomeItem ? null : incomeItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && incomeItemStrategy != null && incomeItemStrategy.equals(oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContAddAgreeEditPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String statusA = "A";
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)statusA)) {
            this.getModel().setDataChanged(false);
        }
    }

    private void initNewEntry(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("cardentry");
        DynamicObjectCollection entryCollection = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("cardentry").get(entryCurrentRowIndex)).getDynamicObjectCollection("entryentity");
        this.getView().setEnable(Boolean.FALSE, entryCollection.size(), new String[]{"listingbudgetitem"});
    }
}

