/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.addition;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.enums.contractlist.ContractListClaimTypeEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;
import kd.pmgt.pmct.common.utils.ContractSupplierHelper;

public class OutContAddAgreeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String CALCULATE_RATIO = "calculateratio";
    public static final String CALCULATE_AMOUNT = "calculateamount";
    public static final String ADDITIONPAYPLAN = "additionpayplan";
    public static final String PARAMETER_SOURCE_ID = "sourceid";
    public static final String PARAMETER_CONTRACT_ID = "contractid";
    public static final String PARAMETER_CHANGE_TYPE = "changetype";
    public static final String PARAMETER_FORMID = "formId";
    public static final String PARAMETER_CUSTOM_ENTRY_DATA = "entrydata";
    public static final String DELETEPAYPLAN = "deletepayplan";
    public static final String VIEWCOMPARE = "viewcompare";
    private static final String CTRL_NEWPAYPLAN = "newpayplan";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String UNAUDIT = "unaudit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("listingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        boolean isMultiContract;
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null && !(isMultiContract = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getBoolean("ismulticontract"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"supplier"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newpayplan": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("payplanentry");
                int rowIndex = entrys.size() - 1;
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) {
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                    this.getModel().setValue("supplier", (Object)contract.getDynamicObject("partb"), rowIndex);
                    boolean bl = contract.getBoolean("ismulticontract");
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity("payplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            payPlanEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long payItemId = payPlanEntry.getLong("conplanitemid");
            if (0L == payItemId || QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)payItemId)) continue;
            payPlanEntry.set("conplanitemid", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name;
        switch (name = arg0.getProperty().getName()) {
            case "budgetitem": 
            case "listingbudgetitem": {
                this.beforeBudgetItemF7Select(arg0);
                break;
            }
            case "nodesetting": {
                this.beforeSelectNodeSetting(arg0);
                break;
            }
            case "supplier": {
                this.beforeSelectPlanEntrySupplier(arg0);
                break;
            }
        }
    }

    private void beforeSelectPlanEntrySupplier(BeforeF7SelectEvent evt) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            DynamicObject partB = contract.getDynamicObject("partb");
            DynamicObjectCollection otherParts = contract.getDynamicObjectCollection("otherpart");
            QFilter supplierIdFilter = ContractSupplierHelper.getContractSupplierFilter((DynamicObject)partB, (DynamicObjectCollection)otherParts);
            evt.addCustomQFilter(supplierIdFilter);
        }
    }

    protected void beforeSelectNodeSetting(BeforeF7SelectEvent evt) {
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"004");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    protected void beforeBudgetItemF7Select(BeforeF7SelectEvent arg) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilter(contract);
        if (idFilter == null) {
            return;
        }
        ListShowParameter parameter = (ListShowParameter)arg.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(idFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "calculateratio": {
                this.doCalculateRatio(model);
                break;
            }
            case "calculateamount": {
                this.doCalculateAmount(model);
                break;
            }
            case "viewcompare": {
                this.viewCompare();
                break;
            }
            case "deletepayplan": {
                this.checkDeletePayPlan(args, model);
                break;
            }
            case "submit": {
                ContractEditHelper.setCheckParameter((BeforeDoOperationEventArgs)args, (String)"pmct_outaddagreement", (String)ADDITIONPAYPLAN);
                break;
            }
            case "newpayplan": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContAddAgreeEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void viewCompare() {
        if (this.getModel().getValue("contract") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContAddAgreeEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAMETER_SOURCE_ID, this.getModel().getDataEntity().getPkValue());
        param.put(PARAMETER_CONTRACT_ID, ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put(PARAMETER_CHANGE_TYPE, PayPlanSourceEnum.ADDITION.getValue());
        param.put(PARAMETER_FORMID, "pmct_outaddagreement");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outaddagreement")).getDynamicObjectCollection("payplanentry").getDynamicObjectType();
        DynamicObjectCollection changePayPlanEntries = this.getModel().getEntryEntity("payplanentry");
        param.put(PARAMETER_CUSTOM_ENTRY_DATA, DynamicObjectSerializeUtil.serialize((Object[])changePayPlanEntries.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_fundplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void checkDeletePayPlan(BeforeDoOperationEventArgs args, IDataModel model) {
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("payplanentry");
        DynamicObject entryRowEntity = model.getEntryRowEntity("payplanentry", entryCurrentRowIndex);
        String conPayitemId = entryRowEntity.getString("conplanitemid");
        if (StringUtils.isNotBlank((CharSequence)conPayitemId)) {
            DynamicObject conPayitemObj = BusinessDataServiceHelper.loadSingle((Object)conPayitemId, (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = conPayitemObj.getBigDecimal("reimbursedcomamt");
            BigDecimal paidComAmt = conPayitemObj.getBigDecimal("paidcomamt");
            if (reimbursedComAmt == null || reimbursedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u62a5\u9500\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContAddAgreeEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (paidComAmt == null || paidComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContAddAgreeEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String payItemName = conPayitemObj.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{conPayitemObj.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContAddAgreeEditPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = conPayitemObj.getBigDecimal("appliedcomamt");
            if (!NumberHelper.isNullZero((BigDecimal)appliedComAmt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"OutContAddAgreeEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected void doCalculateAmount(IDataModel model) {
        DynamicObjectCollection changePayPlanEntry = model.getEntryEntity("payplanentry");
        if (!changePayPlanEntry.isEmpty()) {
            BigDecimal latestAmountOfTax = (BigDecimal)model.getValue("latestamountoftax");
            for (DynamicObject changePayPlanEntryObj : changePayPlanEntry) {
                BigDecimal payPercent = changePayPlanEntryObj.getBigDecimal("paypercent");
                BigDecimal payOfTaxAmount = latestAmountOfTax.multiply(payPercent.divide(BigDecimal.valueOf(100L)));
                changePayPlanEntryObj.set("payamountoftax", (Object)payOfTaxAmount);
                int index = changePayPlanEntry.indexOf((Object)changePayPlanEntryObj);
                this.getView().updateView("payamountoftax", index);
            }
        }
    }

    protected void doCalculateRatio(IDataModel model) {
        DynamicObjectCollection changePayPlanEntry = model.getEntryEntity("payplanentry");
        if (!changePayPlanEntry.isEmpty()) {
            BigDecimal latestAmountOfTax = (BigDecimal)model.getValue("latestamountoftax");
            for (DynamicObject changePayPlanEntryObj : changePayPlanEntry) {
                BigDecimal payOfTaxAmount = changePayPlanEntryObj.getBigDecimal("payamountoftax");
                BigDecimal ratio = payOfTaxAmount.divide(latestAmountOfTax, 4, 4).multiply(BigDecimal.valueOf(100L));
                changePayPlanEntryObj.set("paypercent", (Object)ratio);
                int index = changePayPlanEntry.indexOf((Object)changePayPlanEntryObj);
                this.getView().updateView("paypercent", index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"superlistingid")) {
            this.superListingIdChanged(newValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"parentlisting")) {
            this.parentListingChanged((DynamicObject)newValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"paypercent")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            BigDecimal payAmountOfTax = ((BigDecimal)newValue).divide(BigDecimal.valueOf(100L)).multiply(latestAmountOfTax);
            this.getModel().beginInit();
            this.getModel().setValue("payamountoftax", (Object)payAmountOfTax, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("payamountoftax", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"payamountoftax")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            BigDecimal payPercent = BigDecimal.ZERO;
            if (latestAmountOfTax.compareTo(BigDecimal.ZERO) != 0) {
                payPercent = ((BigDecimal)newValue).divide(latestAmountOfTax, 10, 4).multiply(BigDecimal.valueOf(100L));
            }
            this.getModel().beginInit();
            this.getModel().setValue("paypercent", (Object)payPercent, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("paypercent", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"subaddtype")) {
            this.changeSubAddType(rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"nodesetting")) {
            this.changeNodeSetting(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"ctrlstrategy")) {
            this.ctrlStrategyChange(rowIndex, newValue, oldValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callId = e.getCallBackId();
        int result = e.getResult().getValue();
        switch (callId) {
            case "nodesetting": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "ctrlstrategy": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
            }
        }
    }

    protected void changeNodeSetting(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("payplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        Long payItemNodeId = null;
        if (null != payItem && null != payItem.getDynamicObject("nodesetting")) {
            payItemNodeId = payItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != payItemNodeId && ((DynamicObject)oldValue).getLong("id") == payItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContAddAgreeEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus")) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String payItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("payplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        String string = payItemStrategy = null == payItem ? null : payItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && StringUtils.equals((CharSequence)payItemStrategy, (CharSequence)oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutContAddAgreeEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    private void changeSubAddType(int rowIndex) {
        String subClaimType = this.getModel().getValue("subaddtype", rowIndex).toString();
        DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem");
        if (ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(subClaimType) || ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue().equals(subClaimType)) {
            this.getModel().setValue("listingbudgetitem", (Object)budgetItem, rowIndex);
        } else {
            this.getModel().setValue("listingbudgetitem", null, rowIndex);
        }
    }

    protected void updateBudgetViewByProject() {
    }

    protected void parentListingChanged(DynamicObject newValue, int rowIndex) {
    }

    protected void listingBudgetItemChanged(DynamicObject oldValue, DynamicObject newValue, int rowIndex) {
    }

    protected void superListingIdChanged(Object newValue, int rowIndex) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            this.getModel().setDataChanged(false);
        }
    }
}

