/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ApplyPaymentEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    private static final String algoKey = ApplyPaymentEditPlugin.class.getName();
    private static final String ADD_INVOICE = "newinvoiceentry";
    private static final String DELETE_INVOICE = "deleteinvoiceentry";
    private static final String DELETE_PAYENTRY = "deletepayentry";
    private static final String NEW_PAYENTRY = "newpayentry";
    private static final String NEW_SPLITENTRY = "newsplitentry";
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_AUDIT = "audit";
    private static final String TRACKUP = "trackup";
    private static final String PLAYSPLITPANEL = "playsplitpanel";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            String imageNo = (String)this.getModel().getValue("imageno");
            if (!StringUtils.isEmpty((CharSequence)imageNo)) {
                this.getModel().setValue("imageno", null);
            }
        } else {
            String imageNo;
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase && !StringUtils.isEmpty((CharSequence)(imageNo = (String)this.getModel().getValue("imageno")))) {
                this.getModel().setValue("imageno", null);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("bugdetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invoice = (BasedataEdit)this.getView().getControl("invoice");
        invoice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invoiceNo = (BasedataEdit)this.getControl("invoice");
        if (invoiceNo != null) {
            invoiceNo.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_ininvoice", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        String billId = this.getModel().getDataEntity().getPkValue().toString();
        switch (key) {
            case "deletepayentry": {
                EntryGrid control = (EntryGrid)this.getView().getControl("paydetailentry");
                int[] selectRows = control.getSelectRows();
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection entries = (DynamicObjectCollection)dataEntity.get("paydetailentry");
                BigDecimal deleteCurPayAmtOfTaxTotal = BigDecimal.ZERO;
                BigDecimal deleteCurApplyPayTotal = BigDecimal.ZERO;
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject payObj = (DynamicObject)entries.get(selectRows[i]);
                    deleteCurPayAmtOfTaxTotal = deleteCurPayAmtOfTaxTotal.add(payObj.getBigDecimal("curpayamtoftax"));
                    deleteCurApplyPayTotal = deleteCurApplyPayTotal.add(payObj.getBigDecimal("curpayamt"));
                }
                BigDecimal loanTotal = (BigDecimal)this.getModel().getValue("curpaytotal");
                this.getModel().setValue("curpaytotal", (Object)loanTotal.subtract(deleteCurPayAmtOfTaxTotal));
                BigDecimal applyPayTotal = (BigDecimal)this.getModel().getValue("applypaytotal");
                this.getModel().setValue("applypaytotal", (Object)applyPayTotal.subtract(deleteCurApplyPayTotal));
                break;
            }
            case "newinvoiceentry": {
                if ("0".equals(billId) || !"A".equals(this.getModel().getValue("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ApplyPaymentEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject selContract = (DynamicObject)this.getModel().getValue("contract");
                if (selContract == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ApplyPaymentEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.showInvoice("invoiceentry");
                break;
            }
            case "deleteinvoiceentry": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("invoiceentry");
                int[] selRows = grid.getEntryState().getSelectedRows();
                if (selRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ApplyPaymentEditPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                this.synInvoiceData(contract, DELETE_INVOICE);
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                this.updateEntryData();
                break;
            }
        }
    }

    private void updateEntryData() {
        DynamicObject applyPayment = this.getModel().getDataEntity(true);
        DynamicObject contract = applyPayment.getDynamicObject("contract");
        DynamicObject project = applyPayment.getDynamicObject("project");
        DynamicObject org = applyPayment.getDynamicObject("org");
        boolean flag = false;
        if (contract != null) {
            DynamicObjectCollection splitEntry;
            BigDecimal invoiceUnPayment;
            BigDecimal totalApplyAmount;
            BigDecimal totalPayAmount;
            BigDecimal totalSettleOfTaxAmount;
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            String multiPayType = contract.getString("multipaytype");
            if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
                totalPayAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
                totalApplyAmount = multiSettleAmtService.getMultiTotalApplyOfTaxAmount(org, project, contract);
            } else {
                totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
                totalPayAmount = contract.getBigDecimal("totalrealoftaxamount");
                totalApplyAmount = contract.getBigDecimal("totalapplyoftaxamount");
            }
            BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalPayAmount);
            if (applyPayment.getBigDecimal("contractamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                this.getModel().setValue("contractamount", contract.get("totaloftaxamount"));
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalsettleamt").compareTo(totalSettleOfTaxAmount) != 0) {
                this.getModel().setValue("totalsettleamt", (Object)totalSettleOfTaxAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalpayamount").compareTo(totalPayAmount) != 0) {
                this.getModel().setValue("totalpayamount", (Object)totalPayAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("settleunpayamt").compareTo(totalSettleAndUnRealPayAmount) != 0) {
                this.getModel().setValue("settleunpayamt", (Object)totalSettleAndUnRealPayAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalapplyoftaxamount").compareTo(totalApplyAmount) != 0) {
                this.getModel().setValue("totalapplyoftaxamount", (Object)totalApplyAmount);
                flag = true;
            }
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
            if (!contract.getBoolean("ismulticontract")) {
                invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                invoiceUnPayment = contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalPayAmount);
            } else {
                QFilter contpartbFilter;
                QFilter claimFilter;
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter, claimFilter = new QFilter("isclaimed", "=", (Object)Boolean.TRUE), contpartbFilter = new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue())});
                if (invoices.length > 0) {
                    for (DynamicObject inVo : invoices) {
                        invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                    }
                }
                invoiceUnPayment = invoiceOfTaxAmount.subtract(totalPayAmount);
            }
            if (applyPayment.getBigDecimal("invoiceunpayamt").compareTo(invoiceUnPayment) != 0) {
                this.getModel().setValue("invoiceunpayamt", (Object)invoiceUnPayment);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalinvoiceamt").compareTo(invoiceOfTaxAmount) != 0) {
                this.getModel().setValue("totalinvoiceamt", (Object)invoiceOfTaxAmount);
                flag = true;
            }
            if ((splitEntry = this.getModel().getEntryEntity("splitentry")) != null && splitEntry.size() > 0) {
                for (DynamicObject payApplySplit : splitEntry) {
                    DynamicObject proBudget = payApplySplit.getDynamicObject("bugdetitem");
                    if (proBudget == null) continue;
                    QFilter budgetFilter = new QFilter("budgetitem", "=", proBudget.getPkValue());
                    DynamicObject contractBudget = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "contractauditamtex", "settleauditamtex", "payapplyauditamtex"), (QFilter[])new QFilter[]{contractFilter, budgetFilter});
                    if (contractBudget == null) continue;
                    payApplySplit.set("contractmoney", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                    payApplySplit.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                    payApplySplit.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                }
            }
            if (flag) {
                this.getModel().updateEntryCache(splitEntry);
                this.getView().getPageCache().put("flag", "true");
            }
        }
    }

    private void showInvoice(String entryType) {
        QFilter filter = new QFilter("isclaimed", "=", (Object)false);
        String contractId = ((DynamicObject)this.getModel().getValue("contract")).getString("id");
        if (StringUtils.isNotBlank((CharSequence)contractId)) {
            filter.or(new QFilter("contract", "=", (Object)Long.parseLong(contractId)));
        }
        String accountOrgId = ((DynamicObject)this.getModel().getValue("costorg")).getString("id");
        filter.and(new QFilter("accountorg", "=", (Object)Long.parseLong(accountOrgId)));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("invoicestatus", "!=", (Object)InvoiceStatusEnum.CANCEL_2.getValue()));
        DynamicObjectCollection entries = this.getModel().getEntryEntity("invoiceentry");
        List invoiceIds = entries.stream().filter(entry -> entry.getDynamicObject("invoice") != null).map(entry -> entry.getDynamicObject("invoice").getPkValue()).collect(Collectors.toList());
        filter.and(new QFilter("id", "not in", invoiceIds));
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmct_ininvoicef7", (boolean)true);
        param.getListFilterParameter().setFilter(filter);
        param.setMultiSelect(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invoiceentry"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)param);
    }

    private void newSplitEntry(BeforeF7SelectEvent event) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                QFilter filter = new QFilter("project", "=", project.getPkValue());
                filter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(filter);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "contbudgetinfo"));
            } else {
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                HashSet<Object> proIdSet = null;
                if (multiPartSettlement) {
                    proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                    if (proIdSet == null || proIdSet.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ApplyPaymentEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    DynamicObject contPro = contract.getDynamicObject("project");
                    if (contPro != null) {
                        proIdSet = new HashSet<Object>(1);
                        proIdSet.add(contPro.getPkValue());
                    }
                }
                QFilter filter = new QFilter("project", "in", proIdSet);
                filter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(filter);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "contbudgetinfo"));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ApplyPaymentEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (key = operate.getOperateKey()) {
            case "newpayentry": {
                IDataModel model = this.getModel();
                int rowIndex = model.getEntryCurrentRowIndex("paydetailentry");
                DynamicObject contract = (DynamicObject)model.getValue("contract");
                if (contract == null) break;
                boolean isMultiRate = contract.getBoolean("ismultirate");
                if (isMultiRate) {
                    model.setValue("rateval", contract.get("avgtaxrate"), rowIndex);
                    break;
                }
                DynamicObject taxRate = contract.getDynamicObject("taxrate");
                DynamicObject taxRateObj = BusinessDataServiceHelper.loadSingle((Object)taxRate.getPkValue(), (String)"bd_taxrate");
                model.setValue("rate", (Object)taxRate, rowIndex);
                model.setValue("rateval", taxRateObj.get("taxrate"), rowIndex);
                this.getModel().updateCache();
                break;
            }
            case "trackup": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_applymentpay", (Long[])new Long[]{(Long)pkValue});
                if (sourceBills.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ApplyPaymentEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<String> orgIds = new ArrayList<String>(1);
                orgIds.add(this.getModel().getDataEntity().getDynamicObject("org").getString("id"));
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("org", orgIds);
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"ApplyPaymentEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                listShowParameter.setBillFormId("pmbs_contractpayitembook");
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractpayitembook")));
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "deleteinvoiceentry": {
                DynamicObjectCollection invoiceEntry = this.getModel().getEntryEntity("invoiceentry");
                this.getModel().updateCache();
                this.getModel().updateEntryCache(invoiceEntry);
                this.getView().updateView("invoiceentry");
                this.getView().invokeOperation(OperationEnum.SAVE.getValue());
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                String flag = this.getView().getPageCache().get("flag");
                this.getView().getPageCache().remove("flag");
                if (!StringUtils.isNotEmpty((CharSequence)flag)) break;
                this.getView().invokeOperation("refresh");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u5408\u540c\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"ApplyPaymentEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Deprecated
    protected void checkEntryAmount(BeforeDoOperationEventArgs args) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            return;
        }
        DynamicObjectCollection splitEntryCol = billObj.getDynamicObjectCollection("splitentry");
        if (splitEntryCol.size() > 0) {
            BigDecimal totalCurSplitAmt = BigDecimal.ZERO;
            BigDecimal curPayTotal = (BigDecimal)this.getModel().getValue("curpaytotal");
            for (DynamicObject splitEntryRow : splitEntryCol) {
                totalCurSplitAmt = totalCurSplitAmt.add(splitEntryRow.getBigDecimal("cursplitamt"));
            }
            if (totalCurSplitAmt.compareTo(curPayTotal) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u201c\u4ed8\u6b3e\u5206\u644a\u201d\u7684\u201c\u672c\u6b21\u4ed8\u6b3e\u5206\u644a\u91d1\u989d\u201d\u603b\u8ba1\u5e94\u7b49\u4e8e\u672c\u5355\u201c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d(\u542b\u7a0e)\u201d\u3002", (String)"ApplyPaymentEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public DynamicObject getBankInfo(Object pk) {
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"entry_bank.bankaccount, entry_bank.accountname, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (customerOrSupplier != null) {
            DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
            for (DynamicObject row : entryBanks) {
                if (!row.getBoolean("isdefault_bank")) continue;
                return row;
            }
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        if (propertyName.equals("project")) {
            this.projectValueChange(changeSet[0], model);
        } else if (propertyName.equals("contract")) {
            this.contractValueChange(changeSet[0], model);
        } else if (propertyName.equals("supplier")) {
            DynamicObject supplier = (DynamicObject)changeSet[0].getNewValue();
            if (supplier == null) {
                model.setValue("account", null);
                model.setValue("bank", null);
            } else {
                DynamicObject bankInfo = this.getBankInfo(supplier.getPkValue());
                if (bankInfo != null) {
                    model.setValue("account", (Object)bankInfo.getString("bankaccount"));
                    model.setValue("bank", (Object)bankInfo.getDynamicObject("bank").getString("name"));
                } else {
                    model.setValue("account", null);
                    model.setValue("bank", null);
                }
            }
        } else if (propertyName.equals("account")) {
            String account = (String)changeSet[0].getNewValue();
            if (StringUtils.isEmpty((CharSequence)account)) {
                model.setValue("bank", null);
            }
        } else if (propertyName.equals("curpaytotal")) {
            this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
            this.getView().updateView("applypaytotal");
            BigDecimal curPayTotal = (BigDecimal)changeSet[0].getNewValue();
            BigDecimal amount = (BigDecimal)this.getModel().getValue("periodplanamt");
            HashMap<String, String> propMap = new HashMap<String, String>();
            if (curPayTotal.compareTo(amount) > 0) {
                propMap.put("fc", "#FF0000");
            } else {
                propMap.put("fc", "#B2B2B2");
            }
            this.getView().updateControlMetadata("curpaytotal", propMap);
        } else if (propertyName.equals("curpayamtoftax")) {
            this.curPayAmtOfTaxValueChange(changeSet[0], model);
        } else if (propertyName.equals("rateval")) {
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject payDetailEntryRow = model.getEntryRowEntity("paydetailentry", rowIndex);
            BigDecimal rateVal = (BigDecimal)changeData.getNewValue();
            DynamicObject currency = (DynamicObject)model.getValue("contractcurrency");
            int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)currency);
            BigDecimal curPayAmtOfTax = payDetailEntryRow.getBigDecimal("curpayamtoftax");
            BigDecimal tax = curPayAmtOfTax.multiply(rateVal.divide(BigDecimal.valueOf(100L).add(rateVal), 4));
            model.beginInit();
            tax = tax.setScale(amountAccuracy, 4);
            payDetailEntryRow.set("tax", (Object)tax);
            payDetailEntryRow.set("curpayamt", (Object)curPayAmtOfTax.subtract(tax));
            this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
            model.endInit();
            this.getView().updateView("tax", rowIndex);
            this.getView().updateView("curpayamt", rowIndex);
            this.getView().updateView("applypaytotal");
        } else if (propertyName.equals("tax")) {
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject payDetailEntryRow = model.getEntryRowEntity("paydetailentry", rowIndex);
            BigDecimal tax = (BigDecimal)changeData.getNewValue();
            BigDecimal curPayAmtOfTax = payDetailEntryRow.getBigDecimal("curpayamtoftax");
            model.beginInit();
            payDetailEntryRow.set("curpayamt", (Object)curPayAmtOfTax.subtract(tax));
            this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
            model.endInit();
            this.getView().updateView("curpayamt", rowIndex);
            this.getView().updateView("applypaytotal");
        } else if (propertyName.equals("curpayamt")) {
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject payDetailEntryRow = model.getEntryRowEntity("paydetailentry", rowIndex);
            BigDecimal curPayAmt = (BigDecimal)changeData.getNewValue();
            BigDecimal curPayAmtOfTax = payDetailEntryRow.getBigDecimal("curpayamtoftax");
            model.beginInit();
            payDetailEntryRow.set("tax", (Object)curPayAmtOfTax.subtract(curPayAmt));
            model.endInit();
            this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
            this.getView().updateView("tax", rowIndex);
            this.getView().updateView("applypaytotal");
        } else if (propertyName.equals("rate")) {
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject payDetailEntryRow = model.getEntryRowEntity("paydetailentry", rowIndex);
            DynamicObject taxRate = (DynamicObject)changeData.getNewValue();
            if (taxRate == null) {
                model.beginInit();
                model.setValue("rateval", (Object)0, rowIndex);
                payDetailEntryRow.set("tax", (Object)0);
                BigDecimal curPayAmtOfTax = payDetailEntryRow.getBigDecimal("curpayamtoftax");
                payDetailEntryRow.set("curpayamt", (Object)curPayAmtOfTax);
                this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
                model.endInit();
            } else {
                DynamicObject taxRateObj = BusinessDataServiceHelper.loadSingle((Object)taxRate.getPkValue(), (String)"bd_taxrate");
                BigDecimal rateVal = taxRateObj.getBigDecimal("taxrate");
                DynamicObject currency = (DynamicObject)model.getValue("contractcurrency");
                int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)currency);
                BigDecimal curPayAmtOfTax = payDetailEntryRow.getBigDecimal("curpayamtoftax");
                BigDecimal tax = curPayAmtOfTax.multiply(rateVal.divide(BigDecimal.valueOf(100L).add(rateVal), 4));
                model.beginInit();
                tax = tax.setScale(amountAccuracy, 4);
                payDetailEntryRow.set("rateval", (Object)rateVal);
                payDetailEntryRow.set("tax", (Object)tax);
                payDetailEntryRow.set("curpayamt", (Object)curPayAmtOfTax.subtract(tax));
                this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
                model.endInit();
            }
            this.getView().updateView("rateval", rowIndex);
            this.getView().updateView("tax", rowIndex);
            this.getView().updateView("curpayamt", rowIndex);
            this.getView().updateView("applypaytotal");
        }
    }

    private BigDecimal calculateApplyPayTotal() {
        return this.getModel().getEntryEntity("paydetailentry").stream().map(it -> it.getBigDecimal("curpayamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).subtract((BigDecimal)this.getModel().getValue("loantotal"));
    }

    protected void curPayAmtOfTaxValueChange(ChangeData changeData, IDataModel model) {
        BigDecimal curPayAmtOfTaxValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        BigDecimal curPayAmtOfTaxValueChange = null;
        curPayAmtOfTaxValueChange = oldValue != null ? curPayAmtOfTaxValue.subtract(oldValue) : curPayAmtOfTaxValue;
        BigDecimal curPayTotal = (BigDecimal)model.getValue("curpaytotal");
        DynamicObject currency = (DynamicObject)model.getValue("contractcurrency");
        int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)currency);
        model.setValue("curpaytotal", (Object)curPayTotal.add(curPayAmtOfTaxValueChange));
        int rowIndex = changeData.getRowIndex();
        DynamicObject payDetailEntryRow = model.getEntryRowEntity("paydetailentry", rowIndex);
        BigDecimal rateVal = payDetailEntryRow.getBigDecimal("rateval");
        BigDecimal tax = curPayAmtOfTaxValue.multiply(rateVal.divide(BigDecimal.valueOf(100L).add(rateVal), 4));
        model.beginInit();
        tax = tax.setScale(amountAccuracy, 4);
        payDetailEntryRow.set("tax", (Object)tax);
        payDetailEntryRow.set("curpayamt", (Object)curPayAmtOfTaxValue.subtract(tax));
        this.getModel().setValue("applypaytotal", (Object)this.calculateApplyPayTotal());
        model.endInit();
        this.getView().updateView("tax", rowIndex);
        this.getView().updateView("curpayamt", rowIndex);
        this.getView().updateView("applypaytotal");
    }

    protected void projectValueChange(ChangeData changeData, IDataModel model) {
        DynamicObject outProject;
        DynamicObject project = (DynamicObject)changeData.getNewValue();
        DynamicObject curContract = (DynamicObject)model.getValue("contract");
        if (!(project == null || curContract == null || (outProject = curContract.getDynamicObject("project")) != null && outProject.getPkValue().toString().equals(project.getPkValue().toString()))) {
            model.beginInit();
            DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
            if (invoiceEntry != null && invoiceEntry.size() > 0) {
                DynamicObject contract = (DynamicObject)model.getValue("contract");
                this.synInvoiceData(contract, "changeProject");
                Object[] delSubPks = invoiceEntry.stream().map(DataEntityBase::getPkValue).toArray();
                DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)invoiceEntry.get(0)).getDataEntityType(), (Object[])delSubPks);
                model.deleteEntryData("invoiceentry");
            }
            model.setValue("contract", null);
            model.endInit();
            this.getView().updateView("contract");
            this.setContractAmount(model, null, null);
            model.deleteEntryData("splitentry");
        }
    }

    private void synInvoiceData(DynamicObject contract, String operation) {
        if (contract == null) {
            return;
        }
        BigDecimal invoiceTotalOfTaxAmount = BigDecimal.ZERO;
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        DynamicObjectCollection invoiceEntries = new DynamicObjectCollection();
        if (operation.equals(DELETE_INVOICE)) {
            int[] selRows;
            EntryGrid grid = (EntryGrid)this.getView().getControl("invoiceentry");
            for (int selRow : selRows = grid.getEntryState().getSelectedRows()) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("invoiceentry", selRow);
                invoiceEntries.add((Object)rowEntity);
            }
        } else {
            invoiceEntries = this.getModel().getEntryEntity("invoiceentry");
        }
        if (invoiceEntries.size() > 0) {
            for (DynamicObject entry : invoiceEntries) {
                DynamicObject invoice = entry.getDynamicObject("invoice");
                if (invoice == null) continue;
                String invoiceSourceId = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice")).getString("invoicesourceid");
                if (StringUtils.isNotBlank((CharSequence)invoiceSourceId)) {
                    InvoiceHelper.deleteInvoice((DynamicObject)invoice, (String)this.getModel().getDataEntity().getPkValue().toString());
                    continue;
                }
                boolean isUpdateInvoice = entry.getBoolean("isupdateinvoice");
                if (isUpdateInvoice) {
                    invoice.set("isclaimed", (Object)Boolean.FALSE);
                    invoice.set("contract", null);
                    invoice.set("project", null);
                    invoice.set("connecttype", (Object)"null");
                    invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
                }
                invoiceList.add(invoice);
            }
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            BigDecimal invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
            BigDecimal invoiceAmount = contract.getBigDecimal("totalinvoiceamount");
            contract.set("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount.subtract(invoiceTotalOfTaxAmount));
            contract.set("totalinvoiceamount", (Object)invoiceAmount.subtract(invoiceTotalAmount));
            SaveServiceHelper.update((DynamicObject)contract);
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        }
    }

    protected void contractValueChange(ChangeData changeData, IDataModel model) {
        DynamicObject outContract;
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        if (invoiceEntry != null && invoiceEntry.size() > 0) {
            DynamicObject oldContract = (DynamicObject)changeData.getOldValue();
            this.synInvoiceData(oldContract, "changeContract");
            Object[] delSubPks = invoiceEntry.stream().map(DataEntityBase::getPkValue).toArray();
            DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)invoiceEntry.get(0)).getDataEntityType(), (Object[])delSubPks);
            model.deleteEntryData("invoiceentry");
        }
        if ((outContract = (DynamicObject)changeData.getNewValue()) == null) {
            model.setValue("supplier", null);
            this.setContractAmount(model, null, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
            model.deleteEntryData("splitentry");
        } else {
            DynamicObjectCollection entryEntity;
            DynamicObject targetEntry;
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)outContract.getPkValue(), (String)"pmct_outcontract");
            DynamicObject contProject = contract.getDynamicObject("project");
            DynamicObject project = (DynamicObject)model.getValue("project");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (project == null && !multiPartSettlement) {
                model.setValue("project", (Object)contProject);
            }
            if (multiPartSettlement) {
                if (project != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PLAYSPLITPANEL});
                } else {
                    DynamicObjectCollection contShareProScope = contract.getDynamicObjectCollection("contproscope");
                    if (contShareProScope.isEmpty()) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
                    } else {
                        this.getView().setVisible(Boolean.TRUE, new String[]{PLAYSPLITPANEL});
                    }
                }
            } else if (contProject == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{PLAYSPLITPANEL});
            }
            this.getBudgetInfo(contract);
            DynamicObject period = (DynamicObject)model.getValue("period");
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ApplyPaymentEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setContractAmount(model, contract, period);
            model.setValue("contractcurrency", contract.get("currency"));
            DynamicObject partB = contract.getDynamicObject("partb");
            model.setValue("supplier", (Object)partB);
            model.setValue("costorg", (Object)contract.getDynamicObject("fiaccountorg"));
            MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
            BigDecimal amount = BigDecimal.ZERO;
            DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, (DynamicObject)this.getModel().getValue("org"), (DynamicObject)model.getValue("project"));
            if (fundPlanBill != null && (targetEntry = (DynamicObject)(entryEntity = fundPlanBill.getDynamicObjectCollection("outcontractplanentity")).stream().filter(entry -> StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entry.getDynamicObject("outcontract").getPkValue().toString())).findFirst().orElse(null)) != null) {
                amount = targetEntry.getBigDecimal("outperiodplanamt");
                this.getModel().setValue("fundplan", targetEntry.getPkValue());
            }
            this.getModel().setValue("periodplanamt", (Object)amount);
            BigDecimal curPayTotal = (BigDecimal)this.getModel().getValue("curpaytotal");
            if (curPayTotal.compareTo(amount) > 0) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("fc", "#FF0000");
                this.getView().updateControlMetadata("periodplanamt", propMap);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("periodplanamt");
        BigDecimal curPayTotal = (BigDecimal)this.getModel().getValue("curpaytotal");
        if (curPayTotal.compareTo(amount) > 0) {
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("fc", "#FF0000");
            this.getView().updateControlMetadata("periodplanamt", propMap);
        }
        this.setEntryTaskCompleteStatus();
        this.showPaySplitPanel();
    }

    private void showPaySplitPanel() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        DynamicObject contProject = contract.getDynamicObject("project");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        if (multiPartSettlement) {
            DynamicObjectCollection contShareProScope;
            if (project == null && (contShareProScope = contract.getDynamicObjectCollection("contproscope")).isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
            }
        } else if (contProject == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PLAYSPLITPANEL});
        }
    }

    protected void setEntryTaskCompleteStatus() {
        DynamicObjectCollection payDetailEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("paydetailentry");
        List payItemIds = payDetailEntryColl.stream().filter(entry -> null != entry.get("payitem")).map(entry -> entry.getDynamicObject("payitem").getPkValue()).collect(Collectors.toList());
        if (payItemIds.size() > 0) {
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,source,remarks,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payItemIds)});
            Map payItemCompleteStateMap = (Map)ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems).get(NodeSettingSourceEnum.PMBS_TASK.getValue());
            for (int i = 0; i < payDetailEntryColl.size(); ++i) {
                DynamicObject payDetail = (DynamicObject)payDetailEntryColl.get(i);
                if (null == payItemCompleteStateMap || null == payDetail.get("payitem") || null == payDetail.getDynamicObject("payitem").get("nodesetting")) continue;
                Object taskId = payDetail.getDynamicObject("payitem").getDynamicObject("nodesetting").getPkValue();
                payDetail.set("taskcompletestatus", payItemCompleteStateMap.get(taskId));
                this.getView().updateView("paydetailentry", i);
            }
        }
    }

    protected void getBudgetInfo(DynamicObject contract) {
        this.getModel().deleteEntryData("splitentry");
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (multiPartSettlement) {
                Set proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                if (proIdSet != null && !proIdSet.isEmpty()) {
                    filter.and("budgetitem.project", "in", (Object)proIdSet);
                }
            } else {
                DynamicObject contPro = contract.getDynamicObject("project");
                if (contPro != null) {
                    filter.and("budgetitem.project", "=", contPro.getPkValue());
                }
            }
        } else {
            filter.and("budgetitem.project", "=", project.getPkValue());
        }
        DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
        if (contBudgetInfo.length > 0) {
            for (DynamicObject budgetInfo : contBudgetInfo) {
                BigDecimal contractAuditAmtEx = budgetInfo.getBigDecimal("contractauditamtex");
                BigDecimal settleAuditAmtEx = budgetInfo.getBigDecimal("settleauditamtex");
                BigDecimal payApplyAuditAmtEx = budgetInfo.getBigDecimal("payapplyauditamtex");
                BigDecimal payApplySubmitAmtEx = budgetInfo.getBigDecimal("payapplysubmitamtex");
                BigDecimal actualAuditAmtEx = budgetInfo.getBigDecimal("actualauditamtex");
                if (contractAuditAmtEx.compareTo(BigDecimal.ZERO) == 0 && settleAuditAmtEx.compareTo(BigDecimal.ZERO) == 0 && payApplyAuditAmtEx.compareTo(BigDecimal.ZERO) == 0 && actualAuditAmtEx.compareTo(BigDecimal.ZERO) == 0) continue;
                int rowIndex = this.getModel().createNewEntryRow("splitentry");
                this.getModel().setValue("bugdetitem", budgetInfo.getDynamicObject("budgetitem").getPkValue(), rowIndex);
                this.getModel().setValue("contractmoney", (Object)contractAuditAmtEx, rowIndex);
                this.getModel().setValue("settledamount", (Object)settleAuditAmtEx, rowIndex);
                this.getModel().setValue("payedamount", (Object)payApplyAuditAmtEx, rowIndex);
                BigDecimal subtract = settleAuditAmtEx.subtract(payApplySubmitAmtEx);
                this.getModel().setValue("cursplitamt", (Object)(subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO), rowIndex);
            }
        }
        this.getView().updateView("splitentry");
    }

    protected void setContractAmount(IDataModel model, DynamicObject contract, DynamicObject period) {
        if (contract != null) {
            BigDecimal totalApplyAmount;
            BigDecimal totalPayAmount;
            BigDecimal totalSettleOfTaxAmount;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            String multiPayType = contract.getString("multipaytype");
            if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
                totalPayAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
                totalApplyAmount = multiSettleAmtService.getMultiTotalApplyOfTaxAmount(org, project, contract);
                this.setFieldColor("contractamount");
                this.setFieldColor("invoiceunpayamt");
                this.setFieldColor("totalinvoiceamt");
            } else {
                totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
                totalPayAmount = contract.getBigDecimal("totalrealoftaxamount");
                totalApplyAmount = contract.getBigDecimal("totalapplyoftaxamount");
            }
            BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalPayAmount);
            model.setValue("contractamount", contract.get("totaloftaxamount"));
            model.setValue("totalsettleamt", (Object)totalSettleOfTaxAmount);
            model.setValue("totalpayamount", (Object)totalPayAmount);
            model.setValue("settleunpayamt", (Object)totalSettleAndUnRealPayAmount);
            model.setValue("totalapplyoftaxamount", (Object)totalApplyAmount);
            if (!contract.getBoolean("ismulticontract")) {
                model.setValue("invoiceunpayamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalPayAmount));
                model.setValue("totalinvoiceamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"));
            } else {
                QFilter filter = new QFilter("contract", "=", contract.getPkValue());
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
                filter.and(new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue()));
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
                BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
                if (invoices.length > 0) {
                    for (DynamicObject inVo : invoices) {
                        invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                    }
                }
                model.setValue("invoiceunpayamt", (Object)invoiceOfTaxAmount.subtract(totalPayAmount));
                model.setValue("totalinvoiceamt", (Object)invoiceOfTaxAmount);
            }
        } else {
            model.setValue("contractamount", null);
            model.setValue("totalsettleamt", null);
            model.setValue("totalpayamount", null);
            model.setValue("settleunpayamt", null);
            model.setValue("invoiceunpayamt", null);
            model.setValue("totalinvoiceamt", null);
            model.setValue("totalapplyoftaxamount", null);
        }
    }

    private void setFieldColor(String fieldKey) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("bc", "gray");
        propMap.put("fc", "black");
        this.getView().updateControlMetadata(fieldKey, propMap);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("selecebillback")) {
            this.selectBillBack(closedCallBackEvent);
        } else if (actionId.equals("contbudgetinfo")) {
            this.budgetCloseBack(closedCallBackEvent);
        } else if (actionId.equals("invoiceentry")) {
            this.updateInvoiceEntry(closedCallBackEvent);
        }
    }

    protected void updateInvoiceEntry(ClosedCallBackEvent event) {
        if ("invoiceentry".equals(event.getActionId()) && event.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            DynamicObject[] invArr = new DynamicObject[rows.size()];
            int index = 0;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("invoiceentry");
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            BigDecimal invoiceTotalOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
            BigDecimal invoiceTotalAmount = contract.getBigDecimal("totalinvoiceamount");
            for (ListSelectedRow row : rows) {
                String invoicePk = row.getPrimaryKeyValue().toString();
                DynamicObject entryObj = entryColl.addNew();
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)"pmct_ininvoice");
                entryObj.set("invoice", (Object)invoice);
                entryObj.set("invoicetotalamount", (Object)invoice.getBigDecimal("totalamount"));
                entryObj.set("invoicetotaltax", (Object)invoice.getBigDecimal("totaltax"));
                entryObj.set("invoicetotaloftaxamount", (Object)invoice.getBigDecimal("totaloftaxamount"));
                entryObj.set("invoicecurrency", (Object)invoice.getDynamicObject("currency"));
                if (invoice.getBoolean("isclaimed")) {
                    entryObj.set("isupdateinvoice", (Object)false);
                } else {
                    entryObj.set("isupdateinvoice", (Object)true);
                    invoice.set("isclaimed", (Object)Boolean.TRUE);
                    invoice.set("contract", (Object)contract);
                    invoice.set("project", (Object)contract.getDynamicObject("project"));
                    invoice.set("connecttype", (Object)"contract");
                    invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
                }
                invArr[index++] = invoice;
            }
            contract.set("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount);
            contract.set("totalinvoiceamount", (Object)invoiceTotalAmount);
            SaveServiceHelper.update((DynamicObject)contract);
            SaveServiceHelper.save((DynamicObject[])invArr);
            this.getModel().updateCache();
            this.getModel().updateEntryCache(entryColl);
            this.getView().updateView("invoiceentry");
            this.getView().invokeOperation(OperationEnum.SAVE.getValue());
        }
    }

    protected void budgetCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
            for (int i = 0; i < primaryKeyValues.length; ++i) {
                int rowIndex = i > 0 ? this.getModel().createNewEntryRow("splitentry") : this.getModel().getEntryCurrentRowIndex("splitentry");
                this.setBudgetData(primaryKeyValues[i], rowIndex);
            }
        }
    }

    private void setBudgetData(Object primaryKeyValue, int rowIndex) {
        this.getModel().setValue("bugdetitem", primaryKeyValue, rowIndex);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        QFilter filter = new QFilter("budgetitem", "=", primaryKeyValue);
        filter.and(new QFilter("contract", "=", contract.getPkValue()));
        DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
        if (contBudgetInfo.length > 0) {
            BigDecimal contractAuditAmtEx = contBudgetInfo[0].getBigDecimal("contractauditamtex");
            BigDecimal settleAuditAmtEx = contBudgetInfo[0].getBigDecimal("settleauditamtex");
            BigDecimal payApplyAuditAmtEx = contBudgetInfo[0].getBigDecimal("payapplyauditamtex");
            BigDecimal payApplySubmitAmtEx = contBudgetInfo[0].getBigDecimal("payapplysubmitamtex");
            this.getModel().setValue("contractmoney", (Object)contractAuditAmtEx, rowIndex);
            this.getModel().setValue("settledamount", (Object)settleAuditAmtEx, rowIndex);
            this.getModel().setValue("payedamount", (Object)payApplyAuditAmtEx, rowIndex);
            BigDecimal subtract = settleAuditAmtEx.subtract(payApplySubmitAmtEx);
            this.getModel().setValue("cursplitamt", (Object)(subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO), rowIndex);
        }
    }

    protected void selectBillBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            DataSet result = null;
            for (Map.Entry bill : returnData.entrySet()) {
                String formType = (String)bill.getKey();
                ListSelectedRowCollection rows = (ListSelectedRowCollection)bill.getValue();
                ArrayList<Object> billIds = new ArrayList<Object>(rows.size());
                HashSet<Object> entryIds = new HashSet<Object>(rows.size());
                if (StringUtils.equals((CharSequence)formType, (CharSequence)"er_dailyloanbill")) {
                    for (ListSelectedRow row : rows) {
                        billIds.add(row.getPrimaryKeyValue());
                        entryIds.add(row.getEntryPrimaryKeyValue());
                    }
                    if (result == null) {
                        result = this.queryEntityData("er_dailyloanbill", billIds, entryIds);
                        continue;
                    }
                    result = result.union(this.queryEntityData("er_dailyloanbill", billIds, entryIds));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)formType, (CharSequence)"er_tripreqbill")) continue;
                for (ListSelectedRow row : rows) {
                    billIds.add(row.getPrimaryKeyValue());
                    entryIds.add(row.getEntryPrimaryKeyValue());
                }
                if (result == null) {
                    result = this.queryEntityData("er_tripreqbill", billIds, entryIds);
                    continue;
                }
                result = result.union(this.queryEntityData("er_tripreqbill", billIds, entryIds));
            }
            List<Map<String, Object>> bills = this.getBillList(result);
            if (bills == null || bills.isEmpty()) {
                return;
            }
            DynamicObjectCollection loanEntryCols = this.getModel().getEntryEntity("loanentry");
            DynamicObjectType dt = loanEntryCols.getDynamicObjectType();
            for (int i = 0; i < bills.size(); ++i) {
                Map<String, Object> dataSetRow = bills.get(i);
                DynamicObject curLoanObj = new DynamicObject(dt);
                for (Map.Entry<String, Object> entry : dataSetRow.entrySet()) {
                    if (entry.getKey().equals("outpayername")) {
                        DynamicObject outPayer = BusinessDataServiceHelper.loadSingle((Object)entry.getValue(), (String)"bos_usergroup_user");
                        curLoanObj.set(entry.getKey(), outPayer.get("name"));
                        continue;
                    }
                    if (entry.getKey().equals("loancurrency")) {
                        DynamicObject loanCurrency = BusinessDataServiceHelper.loadSingle((Object)entry.getValue(), (String)"bd_currency");
                        curLoanObj.set(entry.getKey(), (Object)loanCurrency);
                        continue;
                    }
                    curLoanObj.set(entry.getKey(), entry.getValue());
                }
                loanEntryCols.add((Object)curLoanObj);
            }
            this.getModel().updateEntryCache(loanEntryCols);
            this.getView().updateView("loanentry");
        }
    }

    protected List<Map<String, Object>> getBillList(DataSet resultDataSet) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Field[] fields = resultDataSet.getRowMeta().getFields();
        Iterator iterator = resultDataSet.iterator();
        HashMap showDataMap = new HashMap();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.getBigDecimal("loanbalance").compareTo(BigDecimal.ZERO) <= 0) continue;
            int mapSize = 10;
            HashMap<String, Object> rowValue = new HashMap<String, Object>(mapSize);
            for (Field field : fields) {
                String name = field.getName();
                rowValue.put(name, row.get(name));
            }
            Long billId = (Long)row.get("sourcebillid");
            if (showDataMap.get(billId) != null) {
                ((List)showDataMap.get(billId)).add(rowValue);
                continue;
            }
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(rowValue);
            showDataMap.put(billId, list);
        }
        for (Map.Entry entry : showDataMap.entrySet()) {
            List showList = (List)entry.getValue();
            if (showList == null || showList.isEmpty()) continue;
            result.addAll(showList);
        }
        return result;
    }

    protected DataSet queryEntityData(String entityName, List<Object> billIds, Set<Object> entryIds) {
        DataSet result = null;
        if (entityName.equalsIgnoreCase("er_dailyloanbill")) {
            QFilter[] loanFilters = new QFilter[]{new QFilter("id", "in", billIds), new QFilter("expenseentryentity.id", "in", entryIds)};
            result = QueryServiceHelper.queryDataSet((String)(algoKey + ".one"), (String)"er_dailyloanbill", (String)"id as sourcebillid, billno as loanno, description as loanreason, expenseentryentity.id as sourceentryid, expenseentryentity.entrycurrency as loancurrency,expenseentryentity.orgiexpebalanceamount as loanbalance, 'er_dailyloanbill' as srcbilltype, applier as outpayername, bizdate as loanbizdate, accountentry.payeraccount as payeraccount", (QFilter[])loanFilters, null);
        }
        return result;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"project")) {
            Object orgValue = this.getModel().getValue("org");
            List<Long> orgList = new ArrayList<Long>(1);
            if (orgValue == null) {
                orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            } else {
                DynamicObject org = (DynamicObject)orgValue;
                orgList.add(Long.parseLong(org.getPkValue().toString()));
            }
            ProjectF7FilterHelper.setProjectF7QFilter((IFormView)this.getView(), (ListShowParameter)param, orgList);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"contract")) {
            this.beforeSelectContract(param);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"supplier")) {
            DynamicObject contract = (DynamicObject)model.getValue("contract");
            if (contract != null) {
                HashSet<Object> suppliers = new HashSet<Object>();
                suppliers.add(contract.getDynamicObject("partb").getPkValue());
                DynamicObjectCollection otherParts = contract.getDynamicObjectCollection("otherpart");
                for (DynamicObject otherPart : otherParts) {
                    DynamicObject baseDataObj = otherPart.getDynamicObject("fbasedataid");
                    suppliers.add(baseDataObj.getPkValue());
                }
                QFilter supFilter = new QFilter("id", "in", suppliers);
                param.getListFilterParameter().getQFilters().add(supFilter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ApplyPaymentEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"bugdetitem")) {
            this.newSplitEntry(beforeF7SelectEvent);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"invoice")) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("invoiceentry");
            List invoiceIds = entries.stream().filter(entry -> entry.getDynamicObject("invoice") != null).map(entry -> entry.getDynamicObject("invoice").getPkValue()).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "not in", invoiceIds);
            filter.and(new QFilter("isclaimed", "=", (Object)false));
            param.getListFilterParameter().getQFilters().add(filter);
        }
    }

    protected void beforeSelectContract(ListShowParameter param) {
        QFilter contractFilter;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        orgList.add(Long.valueOf(org.getPkValue().toString()));
        Long projectPk = project == null ? null : Long.valueOf(Long.parseLong(project.getPkValue().toString()));
        Set shareContractIdPks = orgList.stream().map(orgPk -> ContractHelper.getContractByMultiPartSettle((Long)projectPk, (Long)orgPk)).map(Arrays::asList).flatMap(Collection::stream).map(contract -> Long.parseLong(contract.getPkValue().toString())).collect(Collectors.toSet());
        QFilter shareContractIdsFilter = new QFilter("id", "in", shareContractIdPks);
        QFilter nonMultiSettlementFilter = new QFilter("multipartsettlement", "=", (Object)false);
        if (project == null) {
            QFilter permContractIdFilter = ProjectPermissionHelper.getPermContractFilter(orgList, (boolean)false, null, (String)this.getView().getEntityId(), (String)"view");
            contractFilter = shareContractIdsFilter.or(permContractIdFilter.and(nonMultiSettlementFilter));
        } else {
            contractFilter = new QFilter("project", "=", project.getPkValue());
            contractFilter = shareContractIdsFilter.or(contractFilter.and(nonMultiSettlementFilter));
        }
        param.getListFilterParameter().getQFilters().add(contractFilter);
        ContractHelper.getContractByStatus((String)this.getView().getEntityId(), (ListShowParameter)param, (String)PayDirectionEnum.OUT.getValue());
    }
}

