/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctListPlugin;

public class ApplyPaymentListPlugin
extends AbstractPmctListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if (("submit".equals(operateKey) || "audit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) && selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ApplyPaymentListPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
            this.updateEntryData(selectedRows);
        }
    }

    private void updateEntryData(ListSelectedRowCollection selectedRows) {
        ArrayList<DynamicObject> paymentList = new ArrayList<DynamicObject>(10);
        String applyName = "";
        for (ListSelectedRow listSelectedDatum : selectedRows) {
            DynamicObjectCollection splitEntry;
            BigDecimal invoiceUnPayment;
            BigDecimal totalApplyAmount;
            BigDecimal totalPayAmount;
            BigDecimal totalSettleOfTaxAmount;
            Object primaryKeyValue = listSelectedDatum.getPrimaryKeyValue();
            DynamicObject applyPayment = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_applymentpay"));
            DynamicObject contract = applyPayment.getDynamicObject("contract");
            DynamicObject project = applyPayment.getDynamicObject("project");
            DynamicObject org = applyPayment.getDynamicObject("org");
            boolean flag = false;
            if (contract == null) continue;
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            String multiPayType = contract.getString("multipaytype");
            if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
                totalPayAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
                totalApplyAmount = multiSettleAmtService.getMultiTotalApplyOfTaxAmount(org, project, contract);
            } else {
                totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
                totalPayAmount = contract.getBigDecimal("totalrealoftaxamount");
                totalApplyAmount = contract.getBigDecimal("totalapplyoftaxamount");
            }
            BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalPayAmount);
            if (applyPayment.getBigDecimal("contractamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                applyPayment.set("contractamount", contract.get("totaloftaxamount"));
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalsettleamt").compareTo(totalSettleOfTaxAmount) != 0) {
                applyPayment.set("totalsettleamt", (Object)totalSettleOfTaxAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalpayamount").compareTo(totalPayAmount) != 0) {
                applyPayment.set("totalpayamount", (Object)totalPayAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("settleunpayamt").compareTo(totalSettleAndUnRealPayAmount) != 0) {
                applyPayment.set("settleunpayamt", (Object)totalSettleAndUnRealPayAmount);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalapplyoftaxamount").compareTo(totalApplyAmount) != 0) {
                applyPayment.set("totalapplyoftaxamount", (Object)totalApplyAmount);
                flag = true;
            }
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
            if (!contract.getBoolean("ismulticontract")) {
                invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                invoiceUnPayment = contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalPayAmount);
            } else {
                QFilter contpartbFilter;
                QFilter claimFilter;
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter, claimFilter = new QFilter("isclaimed", "=", (Object)Boolean.TRUE), contpartbFilter = new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue())});
                if (invoices.length > 0) {
                    for (DynamicObject inVo : invoices) {
                        invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                    }
                }
                invoiceUnPayment = invoiceOfTaxAmount.subtract(totalPayAmount);
            }
            if (applyPayment.getBigDecimal("invoiceunpayamt").compareTo(invoiceUnPayment) != 0) {
                applyPayment.set("invoiceunpayamt", (Object)invoiceUnPayment);
                flag = true;
            }
            if (applyPayment.getBigDecimal("totalinvoiceamt").compareTo(invoiceOfTaxAmount) != 0) {
                applyPayment.set("totalinvoiceamt", (Object)invoiceOfTaxAmount);
                flag = true;
            }
            if ((splitEntry = applyPayment.getDynamicObjectCollection("splitentry")) != null && splitEntry.size() > 0) {
                for (DynamicObject payApplySplit : splitEntry) {
                    DynamicObject proBudget = payApplySplit.getDynamicObject("bugdetitem");
                    if (proBudget == null) continue;
                    QFilter budgetFilter = new QFilter("budgetitem", "=", proBudget.getPkValue());
                    DynamicObject contractBudget = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "contractauditamtex", "settleauditamtex", "payapplyauditamtex"), (QFilter[])new QFilter[]{contractFilter, budgetFilter});
                    if (contractBudget == null) continue;
                    payApplySplit.set("contractmoney", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                    payApplySplit.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                    payApplySplit.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                }
            }
            if (!flag) continue;
            this.getView().getPageCache().put("flag", "true");
            paymentList.add(applyPayment);
            if (applyName.isEmpty()) {
                applyName = applyPayment.getString("billno");
                continue;
            }
            applyName = applyName + "," + applyPayment.getString("billno");
        }
        if (paymentList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])paymentList.toArray(new DynamicObject[0]));
            this.getView().getPageCache().put("contractName", applyName);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate source = (FormOperate)args.getSource();
        if ("trackup".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = source.getListSelectedData();
            if (listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApplyPaymentListPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> paymentApplyIds = listSelectedData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_applymentpay", (Long[])paymentApplyIds.toArray(new Long[0]));
            if (sourceBills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ApplyPaymentListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] applyPays = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", paymentApplyIds)});
            List orgIds = Arrays.stream(applyPays).map(applyPay -> applyPay.getDynamicObject("org").getString("id")).distinct().collect(Collectors.toList());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("org", orgIds);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"ApplyPaymentListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            listShowParameter.setBillFormId("pmbs_contractpayitembook");
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractpayitembook")));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (("submit".equals(operateKey) || "audit".equals(operateKey)) && args.getOperationResult().isSuccess()) {
            String contractName = this.getView().getPageCache().get("contractName");
            this.getView().getPageCache().remove("contractName");
            if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                String[] paymentNames;
                for (String paymentName : paymentNames = contractName.split(",")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u9879\u76ee\u5408\u540c\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"ApplyPaymentListPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), paymentName));
                }
            }
        }
    }
}

