/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.common.utils.ShowBankUtils;
import kd.pmgt.pmct.common.utils.WorkflowUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class IncomeApplyEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(IncomeApplyEditPlugin.class);
    public static final String CONFIRMCALLBACK_CONT_PRO_CHANGE = "contprochange";
    public static final String CAS_REC_PUSH_OP = "casrecpush";
    public static final String INCOME_REGISTER_PUSH_OP = "incomeregisterpush";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("bizdate", (Object)new Date());
        this.getModel().setValue("person", (Object)RequestContext.get().getUserId(), 0);
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        sContainer.changeFlexStatus(SplitDirection.right, true);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter;
        super.afterBindData(e);
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        ApprovalRecord record = (ApprovalRecord)this.getControl("approvalrecordap");
        String key = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
        if ("copy".equalsIgnoreCase(key)) {
            WorkflowUtils workflowUtils = new WorkflowUtils();
            workflowUtils.setWorkflow(this.getModel().getDataEntity(), record);
        }
        if ("wf_approvalpage_bac".equals((formShowParameter = this.getView().getFormShowParameter()).getParentFormId())) {
            sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
        } else {
            List arData;
            DynamicObject bill = this.getModel().getDataEntity();
            String billPk = ObjectUtils.nullSafeToString((Object)bill.getPkValue());
            boolean inProcess = false;
            if (!"0".equals(billPk)) {
                inProcess = WorkflowServiceHelper.inProcess((String)billPk);
            }
            if ((arData = record.getArData()) != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)entry.getDynamicObject("entrycontract")), i, new String[]{"contpro"});
            if (entry.getDynamicObject("incomeitem") != null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"paytype"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"paytype"});
        }
        this.setEntryTaskCompleteStatus();
    }

    protected void setEntryTaskCompleteStatus() {
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List payItemIds = entryColl.stream().filter(entry -> null != entry.get("incomeitem")).map(entry -> entry.getDynamicObject("incomeitem").getPkValue()).collect(Collectors.toList());
        if (payItemIds.size() > 0) {
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,source,remarks,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payItemIds)});
            Map payItemCompleteStateMap = (Map)ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems).get(NodeSettingSourceEnum.PMBS_TASK.getValue());
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject entry2 = (DynamicObject)entryColl.get(i);
                if (null == payItemCompleteStateMap || null == entry2.get("incomeitem") || null == entry2.getDynamicObject("incomeitem").get("nodesetting")) continue;
                Object taskId = entry2.getDynamicObject("incomeitem").getDynamicObject("nodesetting").getPkValue();
                entry2.set("taskcompletestatus", payItemCompleteStateMap.get(taskId));
                this.getView().updateView("taskcompletestatus", i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        int curIndex = valueSet[0].getRowIndex();
        String propertyName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (propertyName.equals("project")) {
            DynamicObject project = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (project != null) {
                project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"prostatus", (QFilter[])new QFilter[]{new QFilter("id", "=", project.getPkValue())});
                QFilter proStatusFilter = new QFilter("number", "=", (Object)ProjectStatusEnum.FINANCIAL_CLOSE.getValue());
                DynamicObject proPassStatus = BusinessDataServiceHelper.loadSingle((String)"bd_projectstatus", (String)"id", (QFilter[])new QFilter[]{proStatusFilter});
                if (project.getDynamicObject("prostatus") != null && project.getDynamicObject("prostatus").getPkValue().equals(proPassStatus.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u8d22\u52a1\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u53d1\u751f\u6b64\u4e1a\u52a1\u3002", (String)"IncomeApplyEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("project", oldValue);
                    return;
                }
            }
            this.getModel().setValue("project", (Object)project);
            HashSet<Object> projectSet = new HashSet<Object>();
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entryObject : entry) {
                DynamicObject contract = entryObject.getDynamicObject("entrycontract");
                DynamicObjectCollection subEntryCol = entryObject.getDynamicObjectCollection("subentryentity");
                if (!subEntryCol.isEmpty() && contract != null) {
                    this.unclaimSubEntry(contract, subEntryCol);
                    this.getModel().deleteEntryData("subentryentity");
                }
                if (contract == null) continue;
                DynamicObject contractProject = contract.getDynamicObject("project");
                if (contractProject != null) {
                    projectSet.add(contractProject.getPkValue());
                    continue;
                }
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            if (project != null) {
                projectSet.add(project.getPkValue());
            }
            if (projectSet.size() > 0) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if ("org".equals(propertyName)) {
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
            if (!entryCol.isEmpty()) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (propertyName.equals("period")) {
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
            if (!entryCol.isEmpty()) {
                for (DynamicObject entry : entryCol) {
                    DynamicObject contract = entry.getDynamicObject("entrycontract");
                    DynamicObjectCollection subEntryCol = entry.getDynamicObjectCollection("subentryentity");
                    if (subEntryCol.isEmpty() || contract == null) continue;
                    this.unclaimSubEntry(contract, subEntryCol);
                    this.getModel().deleteEntryData("subentryentity");
                }
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"endreceiptrate")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal endReceiptRate = (BigDecimal)e.getChangeSet()[0].getNewValue();
            if (endReceiptRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(rowIndex);
                cellStyle.setFieldKey("endreceiptrate");
                cellStyle.setForeColor("#DC143C");
                cellStyles.add(cellStyle);
                grid.setCellStyle(cellStyles);
            } else {
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(rowIndex);
                cellStyle.setFieldKey("endreceiptrate");
                cellStyle.setForeColor("#545454");
                cellStyles.add(cellStyle);
                grid.setCellStyle(cellStyles);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"applyoftaxamount")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal applyOfTaxAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal applyAmount = applyOfTaxAmt.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5);
            BigDecimal applyTaxAmount = applyOfTaxAmt.subtract(applyAmount);
            this.getModel().beginInit();
            this.getModel().setValue("applyamount", (Object)applyAmount, rowIndex);
            this.getModel().setValue("applytaxamount", (Object)applyTaxAmount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("applyamount", rowIndex);
            this.getView().updateView("applytaxamount", rowIndex);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            BigDecimal sumAmount = entryGrid.getSum("applyoftaxamount");
            ChangeData changeData = e.getChangeSet()[0];
            BigDecimal applyOfTaxAmount = (BigDecimal)changeData.getNewValue();
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount != null && totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endreceiptrate", (Object)applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            this.getModel().setValue("sumamount", (Object)sumAmount);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"invoice")) {
            DynamicObject invoice = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (invoice == null) {
                this.getModel().setValue("invoicecurrency", null, rowIndex);
                this.getModel().setValue("invoiceamount", null, rowIndex);
                this.getModel().setValue("invoicetax", null, rowIndex);
                this.getModel().setValue("oftaxinvoiceamount", null, rowIndex);
                return;
            }
            DynamicObject currency = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_outinvoice", (String)"isClaimed,contract,project,connecttype,currency,totalamount,totaltax,totaloftaxamount")).getDynamicObject("currency");
            if (currency != null) {
                this.getModel().setValue("invoicecurrency", currency.getPkValue(), rowIndex);
            }
            this.getModel().setValue("invoiceamount", (Object)invoice.getBigDecimal("totalamount"), rowIndex);
            this.getModel().setValue("invoicetax", (Object)invoice.getBigDecimal("totaltax"), rowIndex);
            this.getModel().setValue("oftaxinvoiceamount", (Object)invoice.getBigDecimal("totaloftaxamount"), rowIndex);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"applyamount")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            BigDecimal applyAmount = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal applyTaxAmount = applyOfTaxAmount.subtract(applyAmount);
            this.getModel().beginInit();
            this.getModel().setValue("applytaxamount", (Object)applyTaxAmount, rowIndex);
            this.getModel().setValue("entryunrecamount", (Object)applyOfTaxAmount, rowIndex);
            this.getModel().setValue("entryunlockamount", (Object)applyOfTaxAmount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("applytaxamount", rowIndex);
            this.getView().updateView("entryunrecamount", rowIndex);
            this.getView().updateView("entryunlockamount", rowIndex);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"applytaxamount")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("applytaxamount", rowIndex);
            this.getModel().beginInit();
            this.getModel().setValue("applyamount", (Object)applyOfTaxAmount.subtract(taxAmount), rowIndex);
            this.getModel().endInit();
            this.getView().updateView("applyamount", rowIndex);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"taxrate")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            BigDecimal applyAmount = (BigDecimal)this.getModel().getValue("applyamount", rowIndex);
            if (applyOfTaxAmount != null && applyOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("applyamount", (Object)applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5));
            } else if (applyAmount != null && applyAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("applyoftaxamount", (Object)applyAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"budgetitem")) {
            this.budgetItemChange(curIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            this.getPageCache().put(CONFIRMCALLBACK_CONT_PRO_CHANGE, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u9879\u76ee\u5c06\u5220\u9664\u73b0\u6709\u9879\u76ee\u7684\u201c\u8bf7\u6b3e\u5206\u644a\u201d\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"IncomeApplyEditPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CONT_PRO_CHANGE, (IFormPlugin)this));
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)"bankaccount")) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)newValue)) {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", currentRowIndex);
                if (contract == null) {
                    return;
                }
                DynamicObject customer = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"))).getDynamicObject("parta");
                if (customer == null) {
                    return;
                }
                boolean hasDefaultBankInfo = ShowBankUtils.hasDefaultBankInfo((DynamicObject)customer);
                if (!hasDefaultBankInfo) {
                    this.getModel().setValue("bankaccount", null, currentRowIndex);
                    this.getModel().setValue("bankname", null, currentRowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u6237\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"IncomeApplyEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                customer = BusinessDataServiceHelper.loadSingle((Object)customer.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_customer"));
                DynamicObjectCollection bankCollection = customer.getDynamicObjectCollection("entry_bank");
                boolean exist = false;
                ArrayList bankAccountList = (ArrayList)bankCollection.stream().filter(o -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getString("bankaccount"))).map(o -> o.getString("bankaccount")).collect(Collectors.toList());
                for (DynamicObject bank : bankCollection) {
                    if (!bank.getString("bankaccount").equals(newValue)) continue;
                    exist = true;
                    this.getModel().setValue("bankname", (Object)bank.getDynamicObject("bank").getString("name"), currentRowIndex);
                    this.getModel().setValue("accountname", (Object)bank.getString("accountname"));
                    break;
                }
                if (!exist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u94f6\u884c\u8d26\u53f7\u3002", (String)"IncomeApplyEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    if (bankAccountList.contains(oldValue)) {
                        this.getModel().setValue("bankaccount", oldValue, currentRowIndex);
                    } else {
                        this.getModel().setValue("bankaccount", null, currentRowIndex);
                        this.getModel().setValue("bankname", null, currentRowIndex);
                    }
                }
            } else {
                this.getModel().setValue("bankaccount", null, currentRowIndex);
                this.getModel().setValue("accountname", null, currentRowIndex);
                this.getModel().setValue("bankname", null, currentRowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(CONFIRMCALLBACK_CONT_PRO_CHANGE)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject contract = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                DynamicObject entryContPro = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpro");
                this.setAllAmount(org, period, contract, entryContPro, row);
                this.getModel().deleteEntryData("inapplysplitentry");
                this.setSplitEntryData(contract, entryContPro, row);
            } else {
                String contPro = this.getPageCache().get(CONFIRMCALLBACK_CONT_PRO_CHANGE);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)(contPro == null ? null : Long.valueOf(Long.parseLong(contPro))), row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
            }
        }
    }

    protected void budgetItemChange(int curIndex) {
        DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem", curIndex);
        if (budgetItem != null) {
            DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("inapplysplitentry");
            DynamicObject contract = (DynamicObject)splitEntry.getParent();
            DynamicObject contCurrency = contract.getDynamicObject("contcurrency");
            DynamicObject entryContract = contract.getDynamicObject("entrycontract");
            if (entryContract != null) {
                QFilter contractBudgetQFilter = new QFilter("budgetitem", "=", budgetItem.getPkValue()).and("contract", "=", entryContract.getPkValue());
                DynamicObject contractBudget = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractbudget", (String)"contractauditamtex,settleauditamtex,payapplyauditamtex", (QFilter[])new QFilter[]{contractBudgetQFilter});
                if (contractBudget != null) {
                    this.getModel().setValue("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"), curIndex);
                    this.getModel().setValue("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"), curIndex);
                    this.getModel().setValue("appliedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"), curIndex);
                } else {
                    this.getModel().setValue("contractamount", null, curIndex);
                    this.getModel().setValue("settledamount", null, curIndex);
                    this.getModel().setValue("appliedamount", null, curIndex);
                }
                this.getModel().setValue("incomecurrency", (Object)contCurrency, curIndex);
            }
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        BasedataEdit contract;
        super.registerListener(e);
        BasedataEdit invoice = (BasedataEdit)this.getControl("invoice");
        invoice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        if (budgetItem != null) {
            budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((contract = (BasedataEdit)this.getView().getControl("entrycontract")) != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit invoiceNo = (BasedataEdit)this.getControl("invoice");
        if (invoiceNo != null) {
            invoiceNo.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outinvoice", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("entryentity")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        BasedataEdit entryPro = (BasedataEdit)this.getView().getControl("contpro");
        entryPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit person = (BasedataEdit)this.getView().getControl("person");
        person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bankAccount = (TextEdit)this.getView().getControl("bankaccount");
        bankAccount.addButtonClickListener((ClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"newsubentry")) {
            String billId = this.getModel().getDataEntity().getPkValue().toString();
            boolean exists = QueryServiceHelper.exists((String)"pmct_incomeapply", (Object)billId);
            if (!exists || !StatusEnum.TEMPSAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"IncomeApplyEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u8bf7\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"IncomeApplyEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.showInvoice("subentryentity");
        } else if ("deletesubentry".equals(key)) {
            EntryGrid subGrid = (EntryGrid)this.getControl("subentryentity");
            int[] selRows = subGrid.getEntryState().getSelectedRows();
            if (selRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IncomeApplyEditPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.deleteInvoiceEntry();
        } else if ("deleteentry".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selRows = entryGrid.getEntryState().getSelectedRows();
            for (int i = 0; i < selRows.length; ++i) {
                int index = selRows[i];
                DynamicObject entryObj = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(index);
                DynamicObject contract = entryObj.getDynamicObject("entrycontract");
                DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
                if (subEntryCol.isEmpty() || contract == null) continue;
                this.unclaimSubEntry(contract, subEntryCol);
            }
            this.getModel().deleteEntryData("subentryentity");
        } else if ("autofetch".equals(key)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"IncomeApplyEditPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"IncomeApplyEditPlugin_23", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.doAutoFetch();
            }
        } else if ("selectcontract".equals(key)) {
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"IncomeApplyEditPlugin_23", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.doSelectContract(key);
        } else if ("refresh".equals(key)) {
            ApprovalRecord record = (ApprovalRecord)this.getControl("approvalrecordap");
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            WorkflowUtils workflowUtils = new WorkflowUtils();
            workflowUtils.setWorkflow(dynamicObject, record);
            SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
            boolean inProcess = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)dynamicObject.getPkValue()));
            List arData = record.getArData();
            if (arData != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        } else if ("newsplitentry".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u8bf7\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"IncomeApplyEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("copy".equals(key)) {
            this.getView().getFormShowParameter().getCustomParams().put("businessKey", "copy");
        } else if ("save".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
            this.updataContractData();
        } else if (CAS_REC_PUSH_OP.equals(key) || INCOME_REGISTER_PUSH_OP.equals(key)) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getBigDecimal("entrylockamount").compareTo(entry.getBigDecimal("applyoftaxamount")) < 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"IncomeApplyEditPlugin_26", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("entrycontract").getString("billname")));
            }
        }
    }

    private void updataContractData() {
        DynamicObjectCollection contractInComeCollection = this.getModel().getEntryEntity("entryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (contractInComeCollection.size() > 0) {
            String contractName = "";
            for (DynamicObject contractInCome : contractInComeCollection) {
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                boolean flag = false;
                DynamicObject contract = contractInCome.getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"));
                DynamicObject entryPro = contractInCome.getDynamicObject("contpro");
                if (contractInCome.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                    contractInCome.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                    flag = true;
                }
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && org.apache.commons.lang3.StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryPro, contract, period, null);
                    totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryPro, contract, period);
                } else {
                    InComeUtils inComeUtils = new InComeUtils();
                    totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
                    totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
                }
                if (contractInCome.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                    contractInCome.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                    flag = true;
                }
                if (contractInCome.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                    contractInCome.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                    flag = true;
                }
                contractInCome.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                BigDecimal totalInvoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                if (contractInCome.getBigDecimal("totalinvoiceoftaxamt").compareTo(totalInvoiceOfTaxAmount) != 0) {
                    contractInCome.set("totalinvoiceoftaxamt", (Object)totalInvoiceOfTaxAmount);
                    flag = true;
                    contractInCome.set("totaluninvoicetaxamount", (Object)totalInvoiceOfTaxAmount.subtract(totalRealOfTaxAmount));
                }
                if (!flag) continue;
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contractName)) {
                    contractName = contractName + "," + contract.getString("billname");
                    continue;
                }
                contractName = contract.getString("billname");
            }
            this.getModel().updateEntryCache(contractInComeCollection);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contractName)) {
                this.getView().getPageCache().put("contractName", contractName);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    private void doSelectContract(String key) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)true, (int)2);
        parameter.setShowUsed(true);
        parameter.setShowApproved(true);
        long pkValue = Long.parseLong(org.getPkValue().toString());
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(pkValue);
        ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
        QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), key, PayDirectionEnum.IN, orgs, project);
        parameter.getListFilterParameter().getQFilters().add(contractFilter);
        DynamicObjectCollection contractInfoList = this.getModel().getEntryEntity("entryentity");
        Set existContractIdSet = contractInfoList.stream().filter(dyn -> dyn.getDynamicObject("entrycontract") != null).map(dyn -> Long.parseLong(dyn.getDynamicObject("entrycontract").getPkValue().toString())).collect(Collectors.toSet());
        if (!existContractIdSet.isEmpty()) {
            QFilter contractExcludeFilter = new QFilter("id", "not in", existContractIdSet);
            parameter.getListFilterParameter().getQFilters().add(contractExcludeFilter);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_incontract");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void doAutoFetch() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        Date beginDate = period.getDate("begindate");
        Date endDate = period.getDate("enddate");
        QFilter payDirection = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
        QFilter status = new QFilter("billstatus", "=", (Object)"C");
        QFilter time = new QFilter("signdate", ">=", (Object)beginDate).and(new QFilter("signdate", "<=", (Object)endDate));
        ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
        QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), null, PayDirectionEnum.IN, Collections.singletonList(org.getLong("id")), project);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)"id", (QFilter[])new QFilter[]{contractFilter, payDirection, status, time});
        if (plans.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u6536\u5165\u5408\u540c\u7684\u6536\u6b3e\u8ba1\u5212\u3002", (String)"IncomeApplyEditPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(plans.length);
        for (DynamicObject d : plans) {
            Long contractId = Long.parseLong(d.get("id").toString());
            ids.add(contractId);
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue("sumamount", (Object)BigDecimal.ZERO);
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"));
        ArrayList<DynamicObjectCollection> totalEntries = new ArrayList<DynamicObjectCollection>();
        for (DynamicObject inContract : loads) {
            DynamicObjectCollection entries = inContract.getDynamicObjectCollection("incontpayplanentry");
            if (entries.size() > 0) {
                totalEntries.add(entries);
            }
            for (DynamicObject entry : entries) {
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("entrycontract", (Object)inContract.getPkValue().toString(), rowIndex);
                this.getModel().setValue("paytype", (Object)entry.getString("paytype"), rowIndex);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)project, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("contpro", rowIndex);
                this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)inContract), rowIndex, new String[]{"contpro"});
                DynamicObject partA = inContract.getDynamicObject("parta");
                DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)partA.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_customer"));
                DynamicObjectCollection bankCollection = customer.getDynamicObjectCollection("entry_bank");
                if (!bankCollection.isEmpty()) {
                    for (DynamicObject bank : bankCollection) {
                        if (!bank.getBoolean("isdefault_bank")) continue;
                        this.getModel().setValue("bankname", (Object)bank.getDynamicObject("bank").getString("name"), rowIndex);
                        this.getModel().setValue("bankaccount", (Object)bank.getString("bankaccount"), rowIndex);
                        break;
                    }
                }
                this.getModel().setValue("totaloftaxamount", inContract.get("totaloftaxamount"), rowIndex);
                if (!inContract.getBoolean("ismultirate")) {
                    this.getModel().setValue("conttaxrate", (Object)inContract.getDynamicObject("lsttaxrate").getBigDecimal("taxrate"), rowIndex);
                } else {
                    this.getModel().setValue("conttaxrate", (Object)inContract.getBigDecimal("lstavgtaxrate"), rowIndex);
                }
                this.getModel().setValue("contcurrency", inContract.getDynamicObject("currency").getPkValue(), rowIndex);
                boolean multiPartSettlement = inContract.getBoolean("multipartsettlement");
                String multiPayType = inContract.getString("multipaytype");
                if (multiPartSettlement && org.apache.commons.lang3.StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, inContract);
                    totalRealOfTaxAmount = multiSettleAmtService.getTotalRealOfTaxAmount(org, project, inContract);
                    this.setCellColor("totaloftaxamount", rowIndex);
                    this.setCellColor("totalinvoiceoftaxamt", rowIndex);
                    this.setCellColor("totaluninvoicetaxamount", rowIndex);
                } else {
                    totalSettleOfTaxAmount = inContract.getBigDecimal("totalsettleoftaxamount");
                    totalRealOfTaxAmount = inContract.getBigDecimal("totalrealoftaxamount");
                }
                this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, rowIndex);
                this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, rowIndex);
                this.getModel().setValue("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), rowIndex);
                BigDecimal totalInvoiceOfTaxAmount = inContract.getBigDecimal("totalinvoiceoftaxamount");
                this.getModel().setValue("totalinvoiceoftaxamt", (Object)totalInvoiceOfTaxAmount, rowIndex);
                this.getModel().setValue("totaluninvoicetaxamount", (Object)totalInvoiceOfTaxAmount.subtract(totalRealOfTaxAmount), rowIndex);
                this.setPeriodFundPlan(period, inContract, rowIndex);
                this.getModel().setValue("applyoftaxamount", this.getModel().getValue("amount"), rowIndex);
                this.getModel().setValue("description", (Object)entry.getString("remarks"), rowIndex);
            }
        }
        if (totalEntries.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u6536\u5165\u5408\u540c\u7684\u6536\u6b3e\u8ba1\u5212\u3002", (String)"IncomeApplyEditPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().updateCache();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        BigDecimal sumAmount = entryGrid.getSum("applyoftaxamount");
        this.getModel().setValue("sumamount", (Object)sumAmount);
    }

    private void deleteInvoiceEntry() {
        int upCurIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", upCurIndex);
        DynamicObject contract = rowEntity.getDynamicObject("entrycontract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        BigDecimal invoiceTotalOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
        BigDecimal invoiceTotalAmount = contract.getBigDecimal("totalinvoiceamount");
        EntryGrid subGrid = (EntryGrid)this.getControl("subentryentity");
        int[] selRows = subGrid.getEntryState().getSelectedRows();
        DynamicObject[] invoiceArr = new DynamicObject[selRows.length];
        Object[] delPks = new Object[selRows.length];
        DynamicObjectCollection subEntryEntityCol = this.getModel().getEntryEntity("subentryentity");
        for (int i = selRows.length - 1; i >= 0; --i) {
            int rowIndex = selRows[i];
            DynamicObject invoice = (DynamicObject)this.getModel().getValue("invoice", rowIndex);
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_outinvoice", (String)"isClaimed,contract,project,connecttype,totaloftaxamount,totalamount");
            Boolean isUpdateInvoice = (Boolean)this.getModel().getValue("isupdateinvoice", rowIndex);
            if (isUpdateInvoice.booleanValue()) {
                invoice.set("isclaimed", (Object)Boolean.FALSE);
                invoice.set("contract", null);
                invoice.set("project", null);
                invoice.set("connecttype", (Object)"null");
                invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.subtract(invoice.getBigDecimal("totaloftaxamount"));
                invoiceTotalAmount = invoiceTotalAmount.subtract(invoice.getBigDecimal("totalamount"));
            }
            invoiceArr[i] = invoice;
            delPks[i] = ((DynamicObject)subEntryEntityCol.get(selRows[i])).getPkValue();
            this.getModel().deleteEntryRow("subentryentity", rowIndex);
        }
        contract.set("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount);
        contract.set("totalinvoiceamount", (Object)invoiceTotalAmount);
        SaveServiceHelper.update((DynamicObject)contract);
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incomeapply")).getDynamicObjectCollection("entryentity").getDynamicObjectType();
        DynamicObject entry = new DynamicObject(dt);
        DynamicObjectType subDt = entry.getDynamicObjectCollection("subentryentity").getDynamicObjectType();
        DeleteServiceHelper.delete((IDataEntityType)subDt, (Object[])delPks);
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    private void setPeriodFundPlan(DynamicObject period, DynamicObject inContract, int rowIndex) {
        DynamicObjectCollection entryEntity;
        DynamicObject targetEntry;
        MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, inContract, (DynamicObject)this.getModel().getValue("org"), (DynamicObject)this.getModel().getValue("project"));
        if (fundPlanBill != null && (targetEntry = (DynamicObject)(entryEntity = fundPlanBill.getDynamicObjectCollection("incontractplanentity")).stream().filter(it -> StringUtils.equals((CharSequence)inContract.getPkValue().toString(), (CharSequence)it.getDynamicObject("incontract").getPkValue().toString())).findFirst().orElse(null)) != null) {
            amount = targetEntry.getBigDecimal("inperiodplanamt");
            this.getModel().setValue("fundplan", targetEntry.getPkValue());
        }
        this.getModel().setValue("amount", (Object)amount, rowIndex);
        this.getView().updateView("amount", rowIndex);
    }

    private void unclaimSubEntry(DynamicObject contract, DynamicObjectCollection subEntryCol) {
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        BigDecimal invoiceTotalOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
        BigDecimal invoiceTotalAmount = contract.getBigDecimal("totalinvoiceamount");
        DynamicObject[] invArr = new DynamicObject[subEntryCol.size()];
        Object[] delSubPks = new Object[subEntryCol.size()];
        for (int i = 0; i < subEntryCol.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subEntryCol.get(i);
            DynamicObject invoice = subEntry.getDynamicObject("invoice");
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_outinvoice", (String)"isClaimed,contract,project,connecttype,Totaloftaxamount,Totalamount");
            boolean isUpdateInvoice = subEntry.getBoolean("isupdateinvoice");
            if (isUpdateInvoice) {
                invoice.set("isclaimed", (Object)Boolean.FALSE);
                invoice.set("project", null);
                invoice.set("contract", null);
                invoice.set("connecttype", (Object)"null");
                invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.subtract(invoice.getBigDecimal("totaloftaxamount"));
                invoiceTotalAmount = invoiceTotalAmount.subtract(invoice.getBigDecimal("totalamount"));
            }
            invArr[i] = invoice;
            delSubPks[i] = subEntry.getPkValue();
        }
        contract.set("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount);
        contract.set("totalinvoiceamount", (Object)invoiceTotalAmount);
        SaveServiceHelper.update((DynamicObject)contract);
        DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)subEntryCol.get(0)).getDataEntityType(), (Object[])delSubPks);
        SaveServiceHelper.save((DynamicObject[])invArr);
    }

    private void showInvoice(String entryType) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
        DynamicObject entryContract = rowEntity.getDynamicObject("entrycontract");
        String orgId = ((DynamicObject)this.getModel().getValue("org")).getString("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter filter = new QFilter("isclaimed", "=", (Object)Boolean.FALSE);
        if (entryContract != null) {
            filter.or(new QFilter("contract", "=", (Object)Long.parseLong(entryContract.getPkValue().toString())));
        }
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("invoicestatus", "!=", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue()));
        DynamicObjectCollection subEntry = rowEntity.getDynamicObjectCollection("subentryentity");
        if (subEntry != null && subEntry.size() > 0) {
            Set selectInvoiceIds = subEntry.stream().map(entry -> Long.parseLong(entry.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet());
            filter.and(new QFilter("id", "not in", selectInvoiceIds));
        }
        filter.and(orgFilter);
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmct_outinvoicef7", (boolean)true);
        param.getListFilterParameter().setFilter(filter);
        param.setMultiSelect(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entryType));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"deleteentry")) {
            BigDecimal sumamount = BigDecimal.ZERO;
            DynamicObjectCollection dCollection = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dObject : dCollection) {
                BigDecimal entryBigDecimal = (BigDecimal)dObject.get("applyoftaxamount");
                if (null == entryBigDecimal) continue;
                sumamount = sumamount.add(entryBigDecimal);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"autofetch")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObjectCollection contractEntry = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < contractEntry.size(); ++index) {
                DynamicObject entryContract = ((DynamicObject)contractEntry.get(index)).getDynamicObject("entrycontract");
                entryContract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_incontract");
                this.setSplitEntryData(entryContract, project, index);
            }
            this.getView().updateView("inapplysplitentry");
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)key, (CharSequence)"trackup")) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_incomeapply", (Long[])new Long[]{(Long)pkValue});
            if (sourceBills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"IncomeApplyEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> orgIds = new ArrayList<String>(1);
            orgIds.add(this.getModel().getDataEntity().getDynamicObject("org").getString("id"));
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("org", orgIds);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u6536\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"IncomeApplyEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            listShowParameter.setBillFormId("pmbs_contractcolitembook");
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractcolitembook")));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("save".equals(key) || "submit".equals(key) || "audit".equals(key)) {
            String contractName = this.getView().getPageCache().get("contractName");
            this.getView().getPageCache().remove("contractName");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contractName)) {
                this.getView().updateView("entryentity");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u5408\u540c\u8bf7\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"IncomeApplyEditPlugin_25", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("pmct_incontract") && event.getReturnData() != null) {
            this.selectContractBack(event);
        } else if ("subentryentity".equals(event.getActionId()) && event.getReturnData() != null) {
            this.selectInvoiceBack(event);
        } else if ("incomeaccountbank".equals(event.getActionId()) && event.getReturnData() != null) {
            this.selectBankBack(event);
        }
    }

    private void selectBankBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
            DynamicObject bankRowObject = ShowBankUtils.loadBankInfo((Long)((Long)entryKey), (String)"bd_customer");
            this.getPageCache().put("bankaccountcache", bankRowObject.getString("bankaccount"));
            this.getModel().setValue("bankname", (Object)bankRowObject.getDynamicObject("bank").getString("name"));
            this.getModel().setValue("bankaccount", (Object)bankRowObject.getString("bankaccount"));
            this.getModel().setValue("accountname", (Object)bankRowObject.getString("accountname"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (propertyName.equals("invoice")) {
            QFilter filter = new QFilter("org", "=", org.getPkValue());
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"entrycontract", (CharSequence)propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_incomeapply", (ListShowParameter)showParameter, (String)PayDirectionEnum.IN.getValue());
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"budgetitem", (CharSequence)propertyName)) {
            this.beforeSelectBudgetitemFilter(event);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", event.getRow());
            if (contract != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(ContractHelper.getEntryProFilter((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)contract));
            }
        } else if (propertyName.equals("person")) {
            QFilter qFilter;
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            param.setF7Style(3);
            long currUserId = RequestContext.get().getCurrUserId();
            List qFilterList = param.getListFilterParameter().getQFilters();
            long projectId = 0L;
            Object projectObj = this.getModel().getValue("project");
            if (projectObj != null) {
                DynamicObject project = (DynamicObject)projectObj;
                projectId = Long.parseLong(project.getPkValue().toString());
            }
            if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) != null) {
                qFilterList.add(qFilter);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals("bankaccount")) {
            this.showBankInfoF7();
        }
    }

    private void showBankInfoF7() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", currentRowIndex);
        DynamicObject customer = contract.getDynamicObject("parta");
        if (customer == null) {
            return;
        }
        boolean hasDefaultBankInfo = ShowBankUtils.hasDefaultBankInfo((DynamicObject)customer);
        if (!hasDefaultBankInfo) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u6237\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"IncomeApplyEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowBankUtils.getBankInfoShowParameter((Object)customer.getPkValue(), (String)"bd_customer");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "incomeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void selectContractBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            selectedIds.add(row.getPrimaryKeyValue());
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (Object e : selectedIds) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("entrycontract", e, row);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle(e, (String)"pmct_incontract");
            this.getModel().setValue("contcurrency", contract.getDynamicObject("currency").getPkValue(), row);
            DynamicObject entryContPro = ContractHelper.getContractProject((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)project, (DynamicObject)contract);
            this.getModel().beginInit();
            this.getModel().setValue("contpro", (Object)entryContPro, row);
            this.getModel().endInit();
            this.getView().updateView("contpro", row);
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), row, new String[]{"contpro"});
            this.getModel().setValue("totaloftaxamount", contract.get("totaloftaxamount"), row);
            if (!contract.getBoolean("ismultirate") && contract.getDynamicObject("lsttaxrate") != null) {
                this.getModel().setValue("taxrate", (Object)contract.getDynamicObject("lsttaxrate"), row);
            }
            this.setAllAmount(org, period, contract, entryContPro, row);
            DynamicObject partA = contract.getDynamicObject("parta");
            DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)partA.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_customer"));
            DynamicObjectCollection blankCollection = customer.getDynamicObjectCollection("entry_bank");
            if (blankCollection.size() > 0) {
                for (DynamicObject blank : blankCollection) {
                    if (!blank.getBoolean("isdefault_bank")) continue;
                    this.getModel().setValue("bankname", (Object)blank.getDynamicObject("bank").getString("name"), row);
                    this.getModel().setValue("bankaccount", (Object)blank.getString("bankaccount"), row);
                    break;
                }
            }
            this.setSplitEntryData(contract, entryContPro, row);
        }
    }

    private void setAllAmount(DynamicObject org, DynamicObject period, DynamicObject contract, DynamicObject entryContPro, int row) {
        DynamicObjectCollection entryEntity;
        DynamicObject targetEntry;
        BigDecimal totalRealOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && org.apache.commons.lang3.StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, null);
            totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryContPro, contract, period);
            this.setCellColor("totaloftaxamount", row);
            this.setCellColor("totalinvoiceoftaxamt", row);
            this.setCellColor("totaluninvoicetaxamount", row);
        } else {
            InComeUtils inComeUtils = new InComeUtils();
            totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
            totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
        }
        this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, row);
        this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, row);
        this.getModel().setValue("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), row);
        this.getModel().setValue("applyoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), row);
        MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, org, entryContPro);
        if (fundPlanBill != null && (targetEntry = (DynamicObject)(entryEntity = fundPlanBill.getDynamicObjectCollection("incontractplanentity")).stream().filter(entry -> org.apache.commons.lang3.StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entry.getDynamicObject("incontract").getPkValue().toString())).findFirst().orElse(null)) != null) {
            amount = targetEntry.getBigDecimal("inperiodplanamt");
            this.getModel().setValue("fundplan", targetEntry.getPkValue());
        }
        this.getModel().setValue("amount", (Object)amount, row);
        if (!contract.getBoolean("ismulticontract")) {
            this.getModel().setValue("totaluninvoicetaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount), row);
            this.getModel().setValue("totalinvoiceoftaxamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"), row);
        } else {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
            BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
            if (invoices.length > 0) {
                for (DynamicObject inVo : invoices) {
                    invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                }
            }
            this.getModel().setValue("totaluninvoicetaxamount", (Object)invoiceOfTaxAmount.subtract(totalRealOfTaxAmount), row);
            this.getModel().setValue("totalinvoiceoftaxamt", (Object)invoiceOfTaxAmount, row);
        }
    }

    private void selectInvoiceBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
        DynamicObject[] invArr = new DynamicObject[rows.size()];
        int index = 0;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int entrySelectedRow = entryGrid.getSelectRows()[0];
        DynamicObject selectedEntryObj = (DynamicObject)entryColl.get(entrySelectedRow);
        DynamicObject contract = selectedEntryObj.getDynamicObject("entrycontract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        BigDecimal invoiceTotalOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
        BigDecimal invoiceTotalAmount = contract.getBigDecimal("totalinvoiceamount");
        DynamicObjectCollection subEntryColl = selectedEntryObj.getDynamicObjectCollection("subentryentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (ListSelectedRow row : rows) {
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), row.getPageIndex(), new String[]{"contpro"});
            String invoicePk = row.getPrimaryKeyValue().toString();
            DynamicObject entryObj = subEntryColl.addNew();
            entryObj.set("invoice", (Object)BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)"pmct_outinvoicef7"));
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)"pmct_outinvoice", (String)"isClaimed,contract,project,connecttype,currency,totalamount,totaltax,totaloftaxamount");
            DynamicObject currency = invoice.getDynamicObject("currency");
            if (currency != null) {
                entryObj.set("invoicecurrency", (Object)currency);
            }
            entryObj.set("invoiceamount", (Object)invoice.getBigDecimal("totalamount"));
            entryObj.set("invoicetax", (Object)invoice.getBigDecimal("totaltax"));
            entryObj.set("oftaxinvoiceamount", (Object)invoice.getBigDecimal("totaloftaxamount"));
            if (!invoice.getBoolean("isclaimed")) {
                entryObj.set("isupdateinvoice", (Object)true);
                invoice.set("isclaimed", (Object)Boolean.TRUE);
                int upCurIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject upContract = (DynamicObject)this.getModel().getValue("entrycontract", upCurIndex);
                invoice.set("contract", (Object)upContract);
                invoice.set("project", (Object)upContract.getDynamicObject("project"));
                invoice.set("connecttype", (Object)"contract");
                invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
            } else {
                entryObj.set("isupdateinvoice", (Object)false);
            }
            invArr[index++] = invoice;
        }
        contract.set("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount);
        contract.set("totalinvoiceamount", (Object)invoiceTotalAmount);
        SaveServiceHelper.update((DynamicObject)contract);
        SaveServiceHelper.save((DynamicObject[])invArr);
        this.getView().invokeOperation(OperationEnum.SAVE.getValue());
        this.getView().updateView("subentryentity");
    }

    protected void beforeSelectBudgetitemFilter(BeforeF7SelectEvent event) {
        DynamicObject entryRowEntity = (DynamicObject)this.getModel().getEntryEntity("inapplysplitentry").getParent();
        DynamicObject entryContPro = entryRowEntity.getDynamicObject("contpro");
        Set<Object> proIdSet = null;
        if (entryContPro != null) {
            proIdSet = new HashSet<Object>(1);
            proIdSet.add(entryContPro.getPkValue());
        } else {
            DynamicObject entryContract = entryRowEntity.getDynamicObject("entrycontract");
            boolean multipartSettlement = (entryContract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_incontract")).getBoolean("multipartsettlement");
            if (multipartSettlement) {
                proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)entryContract);
                if (proIdSet == null || proIdSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"IncomeApplyEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            } else {
                DynamicObject contProject = entryContract.getDynamicObject("project");
                if (contProject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"IncomeApplyEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                proIdSet = new HashSet(1);
                proIdSet.add(contProject.getPkValue());
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("project", "in", proIdSet));
        DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
        List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
            QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
            DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
            return children == null || children.length == 0;
        }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("sourcetype", "=", (Object)"IN"));
        ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void setCellColor(String fieldKey, int row) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor("gray");
        cs.setForeColor("black");
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }

    protected void setBudgetItemEnable() {
    }

    private void setSplitEntryData(DynamicObject contract, DynamicObject project, int row) {
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (project != null) {
            filter.and(new QFilter("budgetitem.project", "=", project.getPkValue()));
        } else {
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (multiPartSettlement) {
                Set proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                if (proIdSet != null && !proIdSet.isEmpty()) {
                    filter.and("budgetitem.project", "in", (Object)proIdSet);
                }
            } else {
                DynamicObject contPro = contract.getDynamicObject("project");
                if (contPro != null) {
                    filter.and("budgetitem.project", "=", contPro.getPkValue());
                }
            }
        }
        DynamicObject contractCurrency = contract.getDynamicObject("currency");
        DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_incontractbudgetperf", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection payApplySplitEntry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row)).getDynamicObjectCollection("inapplysplitentry");
        payApplySplitEntry.clear();
        for (int i = 0; i < contractBudgets.length; ++i) {
            DynamicObject contractBudget = contractBudgets[i];
            contractBudget = BusinessDataServiceHelper.loadSingle((Object)contractBudget.getPkValue(), (String)"pmbs_contractbudget");
            DynamicObject payApply = payApplySplitEntry.addNew();
            payApply.set("seq", (Object)(i + 1));
            payApply.set("budgetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
            payApply.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
            payApply.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
            payApply.set("appliedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
            payApply.set("incomecurrency", (Object)contractCurrency);
        }
        this.getView().updateView("inapplysplitentry");
    }
}

