/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.business.service.BudgetPrePayService;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.business.service.PrePayService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.common.utils.WorkflowUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;
import kd.pmgt.pmct.formplugin.convert.ApplyConvertHelper;

public class PaymentApplyEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String OPERATE_PRE_PAY_DEDUCTION_DETAIL = "prepaydeductiondetail";
    private static final String OPERATE_PRE_PAY_DEDUCTION = "prepaydeduction";
    private static final String OPERATE_NEW_SPLIT_ENTRY = "newsplitentry";
    private static final String OPERATE_DELETE_SPLIT_ENTRY = "deletesplitentry";
    public static final String CONFIRMCALLBACK_CONT_PRO_CHANGE = "contprochange";
    public static final String CAS_PAY_PUSH_OP = "caspaypush";
    public static final String PAY_REGISTER_PUSH_OP = "payregister";
    public static final String CONFIRMCALLBACK_PRO_CHANGE = "prochange";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("bizdate", (Object)new Date());
        this.getModel().setValue("person", (Object)RequestContext.get().getUserId(), 0);
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        sContainer.changeFlexStatus(SplitDirection.right, true);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.onChangeSourceType();
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("wf_approvalpage_bac".equals(formShowParameter.getParentFormId())) {
            sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
        } else {
            ApprovalRecord record;
            List arData;
            DynamicObject bill = this.getModel().getDataEntity();
            String billPk = ObjectUtils.nullSafeToString((Object)bill.getPkValue());
            boolean inProcess = false;
            if (!"0".equals(billPk)) {
                inProcess = WorkflowServiceHelper.inProcess((String)billPk);
            }
            if ((arData = (record = (ApprovalRecord)this.getControl("approvalrecordap")).getArData()) != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObjectCollection invoices;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject contract = entry.getDynamicObject("entrycontract");
            if (contract != null) {
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), i, new String[]{"contpro"});
                boolean isMultiContract = contract.getBoolean("ismulticontract");
                if (!isMultiContract) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"contpartb"});
                }
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    this.setCellColor("totaloftaxamount", i);
                    this.setCellColor("totalinvoiceoftaxamount", i);
                    this.setCellColor("totaluninvoicetaxamount", i);
                }
            }
            if ((invoices = entry.getDynamicObjectCollection("subentryentity")).size() > 0) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"applyoftaxamount"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"applyamount"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"applyoftaxamount"});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"applyamount"});
            }
            if (entry.getDynamicObject("payitem") != null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"paymenttype"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"paymenttype"});
            }
            this.setEntryPrePayEnable(entry);
        }
        this.setEntryTaskCompleteStatus();
        this.setDeductibleaMountSum();
    }

    protected void setEntryTaskCompleteStatus() {
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List payItemIds = entryColl.stream().filter(entry -> null != entry.get("payitem")).map(entry -> entry.getDynamicObject("payitem").getPkValue()).collect(Collectors.toList());
        if (payItemIds.size() > 0) {
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,source,remarks,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payItemIds)});
            Map payItemCompleteStateMap = (Map)ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems).get(NodeSettingSourceEnum.PMBS_TASK.getValue());
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject entry2 = (DynamicObject)entryColl.get(i);
                if (null == payItemCompleteStateMap || null == entry2.get("payitem") || null == entry2.getDynamicObject("payitem").get("nodesetting")) continue;
                Object taskId = entry2.getDynamicObject("payitem").getDynamicObject("nodesetting").getPkValue();
                entry2.set("taskcompletestatus", payItemCompleteStateMap.get(taskId));
                this.getView().updateView("taskcompletestatus", i);
            }
        }
    }

    private void onChangeSourceType() {
        FieldEdit project = (FieldEdit)this.getControl("project");
        project.setMustInput(false);
        this.getView().updateView("project");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(key)) {
            this.onChangeSourceType();
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
            if (!entryCol.isEmpty()) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (propertyName.equals("project")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (!entryEntity.isEmpty()) {
                this.getPageCache().put(CONFIRMCALLBACK_PRO_CHANGE, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u9879\u76ee\u4f1a\u6e05\u7a7a\u73b0\u6709\u9879\u76ee\u7684\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentApplyEditPlugin_36", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_PRO_CHANGE, (IFormPlugin)this));
            } else {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                this.getModel().setValue("sumamount", null);
                this.getModel().setValue("payableamount", null);
                DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("payapplysplitentry");
                if (splitEntry != null && !splitEntry.isEmpty()) {
                    splitEntry.clear();
                    this.getView().updateView("payapplysplitentry");
                }
                HashSet<Object> projectSet = new HashSet<Object>();
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
                if (entryCol.isEmpty()) {
                    DynamicObjectCollection subEntry = this.getModel().getEntryEntity("subentryentity");
                    if (subEntry != null && !subEntry.isEmpty()) {
                        subEntry.clear();
                    }
                    return;
                }
                for (DynamicObject entryObject : entryCol) {
                    DynamicObject contractProject;
                    DynamicObject contract = entryObject.getDynamicObject("entrycontract");
                    if (contract == null) continue;
                    DynamicObjectCollection subEntryCol = entryObject.getDynamicObjectCollection("subentryentity");
                    if (!subEntryCol.isEmpty()) {
                        this.unclaimSubEntry(subEntryCol, contract);
                        this.getModel().deleteEntryData("subentryentity");
                    }
                    if ((contractProject = contract.getDynamicObject("project")) != null) {
                        projectSet.add(contractProject.getPkValue());
                        continue;
                    }
                    this.getModel().deleteEntryData("entryentity");
                    return;
                }
                if (project != null) {
                    projectSet.add(project.getPkValue());
                }
                if (!projectSet.isEmpty()) {
                    this.getModel().deleteEntryData("entryentity");
                }
            }
        } else if (propertyName.equals("period")) {
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
            if (!entryCol.isEmpty()) {
                for (DynamicObject entry : entryCol) {
                    DynamicObjectCollection subEntryCol = entry.getDynamicObjectCollection("subentryentity");
                    DynamicObject contract = entry.getDynamicObject("entrycontract");
                    if (subEntryCol.isEmpty() || contract == null) continue;
                    this.unclaimSubEntry(subEntryCol, contract);
                    this.getModel().deleteEntryData("subentryentity");
                }
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"invoice")) {
            DynamicObject invoice = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (invoice == null) {
                this.getModel().setValue("invoicecurrency", null, rowIndex);
                this.getModel().setValue("invoiceamount", null, rowIndex);
                this.getModel().setValue("invoicetax", null, rowIndex);
                this.getModel().setValue("oftaxinvoiceamount", null, rowIndex);
                return;
            }
            DynamicObject currency = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice", (String)"isClaimed,contract,project,connecttype,currency,totalamount,totaltax,totaloftaxamount")).getDynamicObject("currency");
            if (currency != null) {
                this.getModel().setValue("invoicecurrency", currency.getPkValue(), rowIndex);
            }
            this.getModel().setValue("invoiceamount", (Object)invoice.getBigDecimal("totalamount"), rowIndex);
            this.getModel().setValue("invoicetax", (Object)invoice.getBigDecimal("totaltax"), rowIndex);
            this.getModel().setValue("oftaxinvoiceamount", (Object)invoice.getBigDecimal("totaloftaxamount"), rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"applyoftaxamtvo")) {
            this.doUpdateEntryApplyOfTaxAmt();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"applyoftaxamount")) {
            BigDecimal applyOfTaxAmount = (BigDecimal)e.getChangeSet()[0].getNewValue();
            this.applyoftaxamoutChanged(applyOfTaxAmount, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"applyamount")) {
            BigDecimal applyTaxAmount;
            BigDecimal applyAmount = (BigDecimal)e.getChangeSet()[0].getNewValue();
            String paymentType = this.getModel().getValue("paymenttype", rowIndex) == null ? "" : (String)this.getModel().getValue("paymenttype", rowIndex);
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) {
                applyTaxAmount = BigDecimal.ZERO;
                this.getModel().beginInit();
                this.getModel().setValue("thispayableamount", (Object)applyAmount, rowIndex);
                this.getModel().setValue("thispayableexcltaxamount", (Object)applyAmount, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("thispayableamount", rowIndex);
                this.getView().updateView("thispayableexcltaxamount", rowIndex);
                BigDecimal thispayableamount = this.getModel().getValue("thispayableamount", rowIndex) != null ? (BigDecimal)this.getModel().getValue("thispayableamount", rowIndex) : BigDecimal.ZERO;
                BigDecimal entrylockamount = this.getModel().getValue("entrylockamount", rowIndex) != null ? (BigDecimal)this.getModel().getValue("entrylockamount", rowIndex) : BigDecimal.ZERO;
                this.getModel().setValue("entryunlockamount", (Object)thispayableamount.subtract(entrylockamount));
            } else {
                applyTaxAmount = applyOfTaxAmount.subtract(applyAmount);
                BigDecimal thisPrePayDeduction = (BigDecimal)this.getModel().getValue("thisprepaydeduction", rowIndex);
                BigDecimal thisPayAbleAmount = applyOfTaxAmount.subtract(thisPrePayDeduction);
                this.getModel().setValue("thispayableamount", (Object)thisPayAbleAmount, rowIndex);
                this.getModel().setValue("thispayableexcltaxamount", (Object)thisPayAbleAmount.subtract(applyTaxAmount), rowIndex);
            }
            this.getModel().beginInit();
            this.getModel().setValue("applytaxamount", (Object)applyTaxAmount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("applytaxamount", rowIndex);
            this.setPayAbleAmount();
            BigDecimal thisprepaydeduction = this.getModel().getValue("thisprepaydeduction", rowIndex) != null ? (BigDecimal)this.getModel().getValue("thisprepaydeduction", rowIndex) : BigDecimal.ZERO;
            this.getModel().setValue("entryunpayamount", (Object)applyOfTaxAmount.subtract(thisprepaydeduction));
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"applytaxamount")) {
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("applytaxamount", rowIndex);
            BigDecimal thisPrePayDeduction = (BigDecimal)this.getModel().getValue("thisprepaydeduction", rowIndex);
            this.getModel().beginInit();
            this.getModel().setValue("applyamount", (Object)applyOfTaxAmount.subtract(taxAmount), rowIndex);
            this.getModel().setValue("thispayableexcltaxamount", (Object)applyOfTaxAmount.subtract(thisPrePayDeduction).subtract(taxAmount), rowIndex);
            this.getModel().endInit();
            this.getView().updateView("applyamount", rowIndex);
            this.getView().updateView("thispayableexcltaxamount", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taxrate")) {
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
            BigDecimal applyAmount = (BigDecimal)this.getModel().getValue("applyamount", rowIndex);
            if (applyOfTaxAmount != null && applyOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("applyamount", (Object)applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5));
            } else if (applyAmount != null && applyAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("applyoftaxamount", (Object)applyAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))));
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpartb")) {
            DynamicObject contPartb = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (contPartb == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u6e05\u7a7a\u3002", (String)"PaymentApplyEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("contpartb", oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("contpartb", rowIndex);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", rowIndex);
            DynamicObject entryContPro = (DynamicObject)this.getModel().getValue("contpro", rowIndex);
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("contpartb", rowIndex);
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            this.setAllAmount(org, period, contract, entryContPro, rowIndex, supplier);
            this.changeBankInfo(contPartb, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"thisprepaydeduction")) {
            this.thisPrePayDeductionChange((BigDecimal)newValue, rowIndex, true);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"cursplitamt")) {
            this.curSplitAmtChange(rowIndex, (BigDecimal)newValue);
            this.getView().updateView("payapplysplitentry");
            DynamicObject contractEntry = (DynamicObject)this.getModel().getEntryEntity("payapplysplitentry").getParent();
            this.setEntryPrePayEnable(contractEntry);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"bugdetitem")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            DynamicObject contract = entryRowEntity.getDynamicObject("entrycontract");
            DynamicObjectCollection splitEnties = entryRowEntity.getDynamicObjectCollection("payapplysplitentry");
            DynamicObject budgetItem = ((DynamicObject)splitEnties.get(rowIndex)).getDynamicObject("bugdetitem");
            if (budgetItem != null) {
                QFilter filter = new QFilter("budgetitem", "=", budgetItem.getPkValue());
                filter.and(new QFilter("contract", "=", contract.getPkValue()));
                DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
                if (contBudgetInfo.length > 0) {
                    BigDecimal contractAuditAmtEx = contBudgetInfo[0].getBigDecimal("contractauditamtex");
                    BigDecimal settleAuditAmtEx = contBudgetInfo[0].getBigDecimal("settleauditamtex");
                    BigDecimal payApplyAuditAmtEx = contBudgetInfo[0].getBigDecimal("payapplyauditamtex");
                    BigDecimal payApplySubmitAmtEx = contBudgetInfo[0].getBigDecimal("payapplysubmitamtex");
                    this.getModel().setValue("contractamount", (Object)contractAuditAmtEx, rowIndex, entryCurrentRowIndex);
                    this.getModel().setValue("settledamount", (Object)settleAuditAmtEx, rowIndex, entryCurrentRowIndex);
                    this.getModel().setValue("payedamount", (Object)payApplyAuditAmtEx, rowIndex, entryCurrentRowIndex);
                    BigDecimal subtract = settleAuditAmtEx.subtract(payApplySubmitAmtEx);
                    this.getModel().setValue("cursplitamt", (Object)(subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO), rowIndex, entryCurrentRowIndex);
                } else {
                    this.getModel().setValue("contractamount", null, rowIndex, entryCurrentRowIndex);
                    this.getModel().setValue("settledamount", null, rowIndex, entryCurrentRowIndex);
                    this.getModel().setValue("payedamount", null, rowIndex, entryCurrentRowIndex);
                    this.getModel().setValue("cursplitamt", null, rowIndex, entryCurrentRowIndex);
                }
            } else {
                this.getModel().setValue("contractamount", null, rowIndex, entryCurrentRowIndex);
                this.getModel().setValue("settledamount", null, rowIndex, entryCurrentRowIndex);
                this.getModel().setValue("payedamount", null, rowIndex, entryCurrentRowIndex);
                this.getModel().setValue("cursplitamt", null, rowIndex, entryCurrentRowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            this.getPageCache().put(CONFIRMCALLBACK_CONT_PRO_CHANGE, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u9879\u76ee\u5c06\u5220\u9664\u73b0\u6709\u9879\u76ee\u7684\u201c\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u201d\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentApplyEditPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CONT_PRO_CHANGE, (IFormPlugin)this));
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"paymenttype")) {
            this.paymentTypeChange(rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entrycontract")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)"pmct_outcontract");
            DynamicObject entryContPro = ContractHelper.getContractProject((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)project, (DynamicObject)contract);
            this.getModel().beginInit();
            this.getModel().setValue("contpro", (Object)entryContPro, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("contpro", rowIndex);
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), rowIndex, new String[]{"contpro"});
            this.getModel().setValue("contcurrency", contract.getDynamicObject("currency").getPkValue(), rowIndex);
            this.getModel().setValue("totaloftaxamount", contract.get("totaloftaxamount"), rowIndex);
            if (!contract.getBoolean("ismultirate") && contract.getDynamicObject("lsttaxrate") != null) {
                this.getModel().setValue("taxrate", (Object)contract.getDynamicObject("lsttaxrate"), rowIndex);
            }
            this.getModel().setValue("controlrate", (Object)contract.getBigDecimal("payrate"), rowIndex);
            DynamicObject contPartB = contract.getDynamicObject("partb");
            this.getModel().setValue("contpartb", (Object)contPartB, rowIndex);
            if (contract.getBoolean("ismulticontract")) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"contpartb"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"contpartb"});
            }
            this.fillSplitEntry(rowIndex);
        }
    }

    protected void paymentTypeChange(int rowIndex) {
        BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount", rowIndex);
        this.applyoftaxamoutChanged(applyOfTaxAmount, rowIndex);
        String paymentType = (String)this.getModel().getValue("paymenttype", rowIndex);
        if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) {
            DynamicObjectCollection payApplySplitEntry = this.getModel().getEntryEntity("payapplysplitentry");
            ArrayList<Integer> deleteRows = new ArrayList<Integer>(payApplySplitEntry.size());
            for (int splitIndex = 0; splitIndex < payApplySplitEntry.size(); ++splitIndex) {
                if (!((DynamicObject)payApplySplitEntry.get(splitIndex)).getBoolean("prepaysplit")) continue;
                deleteRows.add(splitIndex);
            }
            if (deleteRows.size() > 0) {
                this.getModel().deleteEntryRows("payapplysplitentry", deleteRows.stream().mapToInt(i -> i).toArray());
            }
        }
        this.setEntryPrePayEnable(this.getModel().getEntryRowEntity("entryentity", rowIndex));
        this.setPrePayDeductionButtonEnable();
    }

    protected void curSplitAmtChange(int splitRowIndex, BigDecimal curSplitAmt) {
        Boolean prePaySplit = (Boolean)this.getModel().getValue("prepaysplit", splitRowIndex);
        if (prePaySplit.booleanValue()) {
            DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("bugdetitem", splitRowIndex);
            int contractRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            BigDecimal deductibleAmount = this.getDeductibleAmount(budgetItem).add(curSplitAmt);
            if (deductibleAmount.compareTo(curSplitAmt) < 0) {
                DynamicObject contCurrency = (DynamicObject)this.getModel().getValue("contcurrency", contractRowIndex);
                String budgetItemName = budgetItem == null ? "" : budgetItem.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\uff1a%1$s\u7684\u201c\u672c\u6b21\u4ed8\u6b3e\u7533\u8bf7\u5206\u644a\u91d1\u989d\u201d\u6c47\u603b\u503c\u4e0d\u53ef\u5927\u4e8e\u8be5\u9884\u7b97\u9879\u7684\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%2$s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PaymentApplyEditPlugin_25", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), budgetItemName, CurrencyFormatUtil.getAfterFormatString((DynamicObject)contCurrency, (Object)deductibleAmount)));
                this.getModel().setValue("cursplitamt", (Object)deductibleAmount, splitRowIndex);
            }
            this.getModel().setValue("thisprepaydeduction", (Object)this.getSumCurSplitAmountByPrePaySplit(), contractRowIndex);
        }
    }

    protected BigDecimal getDeductibleAmount(DynamicObject budgetItem) {
        Object orgId = ((DynamicObject)this.getModel().getValue("org")).getPkValue();
        DynamicObjectCollection contractEntries = this.getModel().getEntryEntity("entryentity");
        int contractRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject contractEntry = this.getModel().getEntryRowEntity("entryentity", contractRowIndex);
        DynamicObject contract = contractEntry.getDynamicObject("entrycontract");
        DynamicObject contPro = contractEntry.getDynamicObject("contpro");
        Object projectId = contPro == null ? null : contPro.getPkValue();
        PrePayService prePayService = new PrePayService();
        BudgetPrePayService budgetPrePayService = new BudgetPrePayService();
        Map prePaySplitBudgetData = budgetPrePayService.getPrePaySplitBudgetData(contract, projectId, orgId);
        Map thisPrePaySplitBudgetData = prePayService.getThisPrePaySplitBudgetData(contract, projectId, contractEntries);
        Object budgetItemId = budgetItem == null ? Long.valueOf(0L) : budgetItem.getPkValue();
        Map splitData = (Map)prePaySplitBudgetData.get(budgetItemId);
        Map thisSplitData = (Map)thisPrePaySplitBudgetData.get(budgetItemId);
        BigDecimal prePayAmount = (BigDecimal)splitData.get("prepayamount");
        BigDecimal prePayDeduction = splitData.get(OPERATE_PRE_PAY_DEDUCTION) == null ? BigDecimal.ZERO : (BigDecimal)splitData.get(OPERATE_PRE_PAY_DEDUCTION);
        BigDecimal thisPrePayDeduction = thisSplitData == null || thisSplitData.get(OPERATE_PRE_PAY_DEDUCTION) == null ? BigDecimal.ZERO : (BigDecimal)thisSplitData.get(OPERATE_PRE_PAY_DEDUCTION);
        return prePayAmount.subtract(prePayDeduction).subtract(thisPrePayDeduction);
    }

    protected BigDecimal getSumCurSplitAmountByPrePaySplit() {
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("payapplysplitentry");
        BigDecimal sum = BigDecimal.ZERO;
        for (DynamicObject split : splitEntry) {
            if (!split.getBoolean("prepaysplit")) continue;
            sum = sum.add(split.getBigDecimal("cursplitamt"));
        }
        return sum;
    }

    protected void thisPrePayDeductionChange(BigDecimal thisPrePayDeduction, int rowIndex, boolean validate) {
        BigDecimal thisDeductionAmountByContract;
        PrePayService prePayService;
        BigDecimal deductibleAmountByContract;
        DynamicObjectCollection contractEntries = this.getModel().getEntryEntity("entryentity");
        DynamicObject contractEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", rowIndex);
        DynamicObject entryContPro = (DynamicObject)this.getModel().getValue("contpro", rowIndex);
        Object projectId = entryContPro == null ? null : entryContPro.getPkValue();
        Object orgId = ((DynamicObject)this.getModel().getValue("org")).getPkValue();
        if (validate && (deductibleAmountByContract = (prePayService = new PrePayService()).getDeductibleAmountByContract(contract, projectId, orgId)).compareTo(thisDeductionAmountByContract = prePayService.getThisDeductionAmountByContract(contract, projectId, contractEntries)) < 0) {
            String contractName = contract.getString("billname");
            thisPrePayDeduction = deductibleAmountByContract.subtract(thisDeductionAmountByContract).add(thisPrePayDeduction);
            DynamicObject currency = contractEntry.getDynamicObject("contcurrency");
            String showDeductibleAmountString = CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)thisPrePayDeduction);
            if (entryContPro != null) {
                String projectName = entryContPro.getLocaleString("name").getLocaleValue();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\u7684\u201c\u672c\u6b21\u9884\u4ed8\u6b3e\u62b5\u6263\u201d\u91d1\u989d\u6c47\u603b\u503c\u4e0d\u53ef\u5927\u4e8e\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%3$s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PaymentApplyEditPlugin_26", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName, projectName, showDeductibleAmountString));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u5408\u540c\uff1a%1$s\u3011\u7684\u201c\u672c\u6b21\u9884\u4ed8\u6b3e\u62b5\u6263\u201d\u91d1\u989d\u6c47\u603b\u503c\u4e0d\u53ef\u5927\u4e8e\u201c\u5269\u4f59\u53ef\u62b5\u6263\u91d1\u989d\u201d%2$s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PaymentApplyEditPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName, showDeductibleAmountString));
            }
            this.getModel().beginInit();
            this.getModel().setValue("thisprepaydeduction", (Object)thisPrePayDeduction, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("thisprepaydeduction", rowIndex);
        }
        BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("applyoftaxamount");
        BigDecimal thisPayableAmount = applyOfTaxAmount.subtract(thisPrePayDeduction);
        this.getModel().setValue("thispayableamount", (Object)thisPayableAmount, rowIndex);
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
        if (rateObj != null) {
            taxRate = rateObj.getBigDecimal("taxrate");
        }
        BigDecimal thisPayAbleExclTaxAmount = thisPayableAmount.divide(BigDecimal.ONE.add(taxRate.multiply(new BigDecimal("0.01"))), 10, 5);
        this.getModel().setValue("thispayableexcltaxamount", (Object)thisPayAbleExclTaxAmount, rowIndex);
        this.setPayAbleAmount();
    }

    private void changeBankInfo(DynamicObject supplier, int rowIndex) {
        if (supplier != null) {
            String entity = supplier.getDataEntityType().getName();
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)entity);
            DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
            DynamicObject defaultBankAccountInfo = null;
            for (int i = 0; i < bankColls.size(); ++i) {
                if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
                defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
            }
            if (defaultBankAccountInfo != null) {
                this.getModel().setValue("bankaccount", (Object)defaultBankAccountInfo.getString("bankaccount"), rowIndex);
            } else {
                this.getModel().setValue("bankaccount", null, rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(CONFIRMCALLBACK_CONT_PRO_CHANGE)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("thisprepaydeduction", null, row);
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject contract = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                DynamicObject entryConPro = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpro");
                DynamicObject supplier = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpartb");
                this.setAllAmount(org, period, contract, entryConPro, row, supplier);
                this.getModel().deleteEntryData("payapplysplitentry");
                this.fillSplitEntry(row);
            } else {
                String contPro = this.getPageCache().get(CONFIRMCALLBACK_CONT_PRO_CHANGE);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)(contPro == null ? null : Long.valueOf(Long.parseLong(contPro))), row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
            }
        } else if (message.equals(CONFIRMCALLBACK_PRO_CHANGE)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                this.getModel().setValue("sumamount", null);
                this.getModel().setValue("payableamount", null);
                DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("payapplysplitentry");
                if (splitEntry != null && !splitEntry.isEmpty()) {
                    splitEntry.clear();
                    this.getView().updateView("payapplysplitentry");
                }
                HashSet<Object> projectSet = new HashSet<Object>();
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
                if (entryCol.isEmpty()) {
                    DynamicObjectCollection subEntry = this.getModel().getEntryEntity("subentryentity");
                    if (subEntry != null && !subEntry.isEmpty()) {
                        subEntry.clear();
                    }
                    return;
                }
                for (DynamicObject entryObject : entryCol) {
                    DynamicObject contractProject;
                    DynamicObject contract = entryObject.getDynamicObject("entrycontract");
                    if (contract == null) continue;
                    DynamicObjectCollection subEntryCol = entryObject.getDynamicObjectCollection("subentryentity");
                    if (!subEntryCol.isEmpty()) {
                        this.unclaimSubEntry(subEntryCol, contract);
                        this.getModel().deleteEntryData("subentryentity");
                    }
                    if ((contractProject = contract.getDynamicObject("project")) != null) {
                        projectSet.add(contractProject.getPkValue());
                        continue;
                    }
                    this.getModel().deleteEntryData("entryentity");
                    return;
                }
                if (project != null) {
                    projectSet.add(project.getPkValue());
                }
                if (!projectSet.isEmpty()) {
                    this.getModel().deleteEntryData("entryentity");
                }
            } else {
                String project = this.getPageCache().get(CONFIRMCALLBACK_PRO_CHANGE);
                this.getModel().beginInit();
                this.getModel().setValue("project", project == null ? null : Long.valueOf(Long.parseLong(project)));
                this.getModel().endInit();
                this.getView().updateView("project");
            }
        }
    }

    public void doUpdateEntryApplyOfTaxAmt() {
        int upCurIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", upCurIndex);
        DynamicObjectCollection subEntry = rowEntity.getDynamicObjectCollection("subentryentity");
        if (subEntry.size() > 0) {
            BigDecimal sumSubApplyAmt = subEntry.stream().map(entry -> entry.getBigDecimal("applyoftaxamtvo")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("applyoftaxamount", (Object)sumSubApplyAmt, upCurIndex);
            this.getView().updateView("applyoftaxamount", upCurIndex);
        }
    }

    public void applyoftaxamoutChanged(BigDecimal applyOfTaxAmount, int rowIndex) {
        BigDecimal applyAmount;
        String paymentType;
        String string = paymentType = this.getModel().getValue("paymenttype", rowIndex) == null ? "" : (String)this.getModel().getValue("paymenttype", rowIndex);
        if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) {
            applyAmount = applyOfTaxAmount;
            this.getModel().beginInit();
            this.getModel().setValue("thispayableamount", (Object)applyOfTaxAmount, rowIndex);
            this.getModel().setValue("thispayableexcltaxamount", (Object)applyOfTaxAmount, rowIndex);
            this.getModel().setValue("applytaxamount", null, rowIndex);
            this.getModel().setValue("thisprepaydeduction", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("thispayableamount", rowIndex);
            this.getView().updateView("thispayableexcltaxamount", rowIndex);
            this.getView().updateView("applytaxamount", rowIndex);
            this.getView().updateView("thisprepaydeduction", rowIndex);
            BigDecimal thispayableamount = this.getModel().getValue("thispayableamount", rowIndex) != null ? (BigDecimal)this.getModel().getValue("thispayableamount", rowIndex) : BigDecimal.ZERO;
            BigDecimal entrylockamount = this.getModel().getValue("entrylockamount", rowIndex) != null ? (BigDecimal)this.getModel().getValue("entrylockamount", rowIndex) : BigDecimal.ZERO;
            this.getModel().setValue("entryunlockamount", (Object)thispayableamount.subtract(entrylockamount));
        } else {
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal oneAddTaxRete = BigDecimal.ONE.add(taxRate.multiply(new BigDecimal("0.01")));
            applyAmount = applyOfTaxAmount.divide(oneAddTaxRete, 10, 5);
            BigDecimal applyTaxAmount = applyOfTaxAmount.subtract(applyAmount);
            this.getModel().setValue("applytaxamount", (Object)applyTaxAmount, rowIndex);
            BigDecimal thisPrePayDeduction = (BigDecimal)this.getModel().getValue("thisprepaydeduction", rowIndex);
            BigDecimal thisPayAbleAmount = applyOfTaxAmount.subtract(thisPrePayDeduction);
            this.getModel().setValue("thispayableamount", (Object)thisPayAbleAmount, rowIndex);
            BigDecimal thisPayableExclTaxAmount = thisPayAbleAmount.divide(oneAddTaxRete, 10, 5);
            this.getModel().setValue("thispayableexcltaxamount", (Object)thisPayableExclTaxAmount, rowIndex);
        }
        this.getModel().beginInit();
        this.getModel().setValue("applyamount", (Object)applyAmount, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("applyamount", rowIndex);
        this.setPayAbleAmount();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        BigDecimal sumAmount = entryGrid.getSum("applyoftaxamount");
        BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
        BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
        if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L));
            this.getModel().setValue("endpaymentrate", (Object)rate, rowIndex);
        }
        this.getModel().setValue("sumamount", (Object)sumAmount);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        super.registerListener(e);
        BasedataEdit invoice = (BasedataEdit)this.getView().getControl("invoice");
        invoice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contPartb = (BasedataEdit)this.getView().getControl("contpartb");
        contPartb.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("entrycontract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit invoiceNo = (BasedataEdit)this.getControl("invoice");
        if (invoiceNo != null) {
            invoiceNo.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_ininvoice", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("entryentity")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("bugdetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryPro = (BasedataEdit)this.getView().getControl("contpro");
        entryPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit person = (BasedataEdit)this.getView().getControl("person");
        person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        this.setDeductibleaMountSum();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"newsubentry")) {
            this.addInvoiceEntryRow(args);
        } else if ("deletesubentry".equals(key)) {
            this.deleteInvoiceEntryRow(args);
        } else if ("autofetch".equals(key)) {
            this.doAutoFetch(args);
        } else if ("selectcontract".equals(key)) {
            this.selectContract(args, key);
        } else if ("deleteentry".equals(key)) {
            this.deletePayEntry();
        } else if ("refresh".equals(key)) {
            ApprovalRecord record = (ApprovalRecord)this.getControl("approvalrecordap");
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            WorkflowUtils workflowUtils = new WorkflowUtils();
            workflowUtils.setWorkflow(dynamicObject, record);
            SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
            boolean flag = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)dynamicObject.getPkValue()));
            List arData = record.getArData();
            if (arData != null && arData.size() > 0 || flag) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        } else if (OPERATE_NEW_SPLIT_ENTRY.equals(key)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"PaymentApplyEditPlugin_27", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)OPERATE_PRE_PAY_DEDUCTION, (CharSequence)key)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u9884\u4ed8\u6b3e\u62b5\u6263\u7684\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u884c\uff08\u652f\u51fa\u7c7b\u578b\u4e0d\u4e3a\u201c\u9884\u4ed8\u6b3e\u201d\uff09\u3002", (String)"PaymentApplyEditPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u9700\u8981\u8fdb\u884c\u9884\u4ed8\u6b3e\u62b5\u6263\u7684\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u884c\uff08\u652f\u51fa\u7c7b\u578b\u4e0d\u4e3a\u201c\u9884\u4ed8\u6b3e\u201d\uff09\u3002", (String)"PaymentApplyEditPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("save".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
            this.updateEntryData();
        } else if (StringUtils.equals((CharSequence)OPERATE_DELETE_SPLIT_ENTRY, (CharSequence)key)) {
            this.beforeDeleteSplitEntry();
        } else if (StringUtils.equals((CharSequence)PAY_REGISTER_PUSH_OP, (CharSequence)key)) {
            if (ApplyConvertHelper.validateIsBankBOTP(this.getModel().getDataEntity().getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyEditPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getBigDecimal("entrylockamount").compareTo(entry.getBigDecimal("thispayableamount")) < 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d\u201d\u5c06\u8d85\u51fa\u9650\u989d\u3002", (String)"PaymentApplyEditPlugin_34", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("entrycontract").getString("billname")));
                return;
            }
        } else if (StringUtils.equals((CharSequence)CAS_PAY_PUSH_OP, (CharSequence)key)) {
            if (ApplyConvertHelper.validateCanNotBankChangePush(this.getModel().getDataEntity().getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyEditPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("bankinfopush".equals(key)) {
            if (ApplyConvertHelper.validateCanNotBankChangePush(this.getModel().getDataEntity().getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3001\u8fd8\u672a\u201c\u6574\u5355\u4ed8\u6e05\u201d\u3001\u4e14\u6ca1\u6709\u5173\u8054\u672a\u5ba1\u6838\u7684\u94f6\u884c\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyEditPlugin_33", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("bankinfolist".equals(key)) {
            Long paymentApplyPk = (Long)this.getModel().getDataEntity().getPkValue();
            ListShowParameter parameter = new ListShowParameter();
            if (ApplyConvertHelper.validateCanNotBankChangeList(paymentApplyPk)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentApplyEditPlugin_35", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            parameter.getListFilterParameter().getQFilters().add(new QFilter("paymentapply", "=", (Object)paymentApplyPk));
            parameter.setBillFormId("pmct_bankchange");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    protected void beforeDeleteSplitEntry() {
        EntryGrid splitEntryGrid = (EntryGrid)this.getControl("payapplysplitentry");
        int[] selectRows = splitEntryGrid.getSelectRows();
        boolean calculateThisPrePayDeduction = false;
        BigDecimal sumSplitAmount = BigDecimal.ZERO;
        for (int index = 0; index < selectRows.length; ++index) {
            DynamicObject split = this.getModel().getEntryRowEntity("payapplysplitentry", selectRows[index]);
            if (!split.getBoolean("prepaysplit")) continue;
            calculateThisPrePayDeduction = true;
            sumSplitAmount = sumSplitAmount.add(split.getBigDecimal("cursplitamt"));
        }
        if (calculateThisPrePayDeduction) {
            int contractCurRow = this.getModel().getEntryCurrentRowIndex("entryentity");
            BigDecimal thisPrePayDeduction = this.getSumCurSplitAmountByPrePaySplit().subtract(sumSplitAmount);
            this.getModel().beginInit();
            this.getModel().setValue("thisprepaydeduction", (Object)thisPrePayDeduction, contractCurRow);
            this.getModel().endInit();
            this.getView().updateView("thisprepaydeduction", contractCurRow);
            this.thisPrePayDeductionChange(thisPrePayDeduction, contractCurRow, false);
        }
        this.setEntryPrePayEnable((DynamicObject)this.getModel().getEntryEntity("payapplysplitentry").getParent());
    }

    private void updateEntryData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObjectCollection contractPayCollection = this.getModel().getEntryEntity("entryentity");
        if (contractPayCollection != null && contractPayCollection.size() > 0) {
            String contractName = "";
            for (DynamicObject contractPay : contractPayCollection) {
                DynamicObjectCollection payApplySplitEntry;
                BigDecimal totalUnInvoiceAmount;
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                boolean flag = false;
                DynamicObject contract = contractPay.getDynamicObject("entrycontract");
                if (contract == null) continue;
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                DynamicObject entryPro = contractPay.getDynamicObject("contpro");
                DynamicObject supplier = contractPay.getDynamicObject("contpartb");
                if (contractPay.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                    contractPay.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                    flag = true;
                }
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryPro, contract, period, supplier);
                    totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryPro, contract, period, supplier);
                } else {
                    InComeUtils inComeUtils = new InComeUtils();
                    totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, supplier);
                    totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, supplier);
                }
                if (contractPay.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                    contractPay.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                    flag = true;
                }
                if (contractPay.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                    contractPay.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                    flag = true;
                }
                contractPay.set("totalunpaidoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
                if (!contract.getBoolean("ismulticontract")) {
                    invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
                    totalUnInvoiceAmount = contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount);
                } else {
                    QFilter contpartbFilter;
                    QFilter claimFilter;
                    QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{contractFilter, statusFilter, claimFilter = new QFilter("isclaimed", "=", (Object)Boolean.TRUE), contpartbFilter = new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue())});
                    if (invoices.length > 0) {
                        for (DynamicObject inVo : invoices) {
                            invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                        }
                    }
                    totalUnInvoiceAmount = invoiceOfTaxAmount.subtract(totalRealOfTaxAmount);
                }
                if (contractPay.getBigDecimal("totalinvoiceoftaxamount").compareTo(contract.getBigDecimal("totalinvoiceoftaxamount")) != 0) {
                    contractPay.set("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount);
                    contractPay.set("totaluninvoicetaxamount", (Object)totalUnInvoiceAmount);
                    flag = true;
                }
                if ((payApplySplitEntry = contractPay.getDynamicObjectCollection("payapplysplitentry")) != null && payApplySplitEntry.size() > 0) {
                    for (DynamicObject payApplySplit : payApplySplitEntry) {
                        DynamicObject proBudget = payApplySplit.getDynamicObject("bugdetitem");
                        if (proBudget == null) continue;
                        QFilter budgetFilter = new QFilter("budgetitem", "=", proBudget.getPkValue());
                        DynamicObject contractBudget = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "contractauditamtex", "settleauditamtex", "payapplyauditamtex"), (QFilter[])new QFilter[]{contractFilter, budgetFilter});
                        if (contractBudget == null) continue;
                        payApplySplit.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                        payApplySplit.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                        payApplySplit.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                    }
                }
                if (!flag) continue;
                if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                    contractName = contractName + "," + contract.getString("billname");
                    continue;
                }
                contractName = contractName + contract.getString("billname");
            }
            if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                this.getModel().updateEntryCache(contractPayCollection);
                this.getView().getPageCache().put("contractName", contractName);
            }
        }
    }

    private void newSplitEntry(BeforeF7SelectEvent event) {
        Set<Object> proIdSet;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject entryContPro = entryRowEntity.getDynamicObject("contpro");
        if (entryContPro != null) {
            proIdSet = new HashSet<Object>(1);
            proIdSet.add(entryContPro.getPkValue());
        } else {
            DynamicObject entryContract = entryRowEntity.getDynamicObject("entrycontract");
            boolean multipartSettlement = (entryContract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
            if (multipartSettlement) {
                proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)entryContract);
                if (proIdSet == null || proIdSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PaymentApplyEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            } else {
                DynamicObject contProject = entryContract.getDynamicObject("project");
                if (contProject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PaymentApplyEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                proIdSet = new HashSet(1);
                proIdSet.add(contProject.getPkValue());
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("project", "in", proIdSet));
        DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
        List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
            QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
            DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
            return children == null || children.length == 0;
        }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
        ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void deletePayEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selRows = entryGrid.getEntryState().getSelectedRows();
        for (int i = 0; i < selRows.length; ++i) {
            DynamicObject entryObj = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(selRows[i]);
            DynamicObject contract = entryObj.getDynamicObject("entrycontract");
            DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
            if (subEntryCol.size() <= 0 || contract == null) continue;
            this.unclaimSubEntry(subEntryCol, contract);
        }
        this.getModel().deleteEntryData("subentryentity");
    }

    private void selectContract(BeforeDoOperationEventArgs args, String key) {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PaymentApplyEditPlugin_28", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_outcontractf7", (boolean)true, (int)2);
        parameter.setShowUsed(true);
        parameter.setShowApproved(true);
        long pkValue = Long.parseLong(org.getPkValue().toString());
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(pkValue);
        ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
        QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), key, PayDirectionEnum.OUT, orgs, project);
        parameter.getListFilterParameter().getQFilters().add(contractFilter);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_outcontract");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void doAutoFetch(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        ArrayList<Long> ids = new ArrayList<Long>();
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PaymentApplyEditPlugin_29", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PaymentApplyEditPlugin_28", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            Date beginDate = period.getDate("begindate");
            Date endDate = period.getDate("enddate");
            QFilter numberFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
            ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
            QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), null, PayDirectionEnum.OUT, Collections.singletonList(org.getLong("id")), project);
            DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"id", (QFilter[])new QFilter[]{contractFilter});
            if (plans.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u652f\u51fa\u5408\u540c\u7684\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"PaymentApplyEditPlugin_30", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject d : plans) {
                Long contractId = Long.parseLong(d.get("id").toString());
                ids.add(contractId);
            }
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setValue("sumamount", (Object)BigDecimal.ZERO);
            DynamicObject[] outContracts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
            ArrayList<DynamicObjectCollection> totalEntriesList = new ArrayList<DynamicObjectCollection>();
            for (DynamicObject outContract : outContracts) {
                DynamicObjectCollection entries = outContract.getDynamicObjectCollection("outcontpayplanentry");
                if (!entries.isEmpty()) {
                    totalEntriesList.add(entries);
                }
                for (DynamicObject entry : entries) {
                    BigDecimal totalRealOfTaxAmount;
                    BigDecimal totalSettleOfTaxAmount;
                    Date planPayTime = entry.getDate("planpaytime");
                    if (planPayTime == null || planPayTime.before(beginDate) || planPayTime.after(endDate)) continue;
                    int rowIndex = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("entrycontract", outContract.getPkValue(), rowIndex);
                    this.getModel().setValue("paymenttype", entry.get("paytype"), rowIndex);
                    this.getModel().setValue("contcurrency", outContract.getDynamicObject("currency").getPkValue(), rowIndex);
                    if (!outContract.getBoolean("ismultirate")) {
                        this.getModel().setValue("conttaxrate", (Object)outContract.getDynamicObject("taxrate").getBigDecimal("taxrate"), rowIndex);
                    } else {
                        this.getModel().setValue("conttaxrate", (Object)outContract.getBigDecimal("avgtaxrate"), rowIndex);
                    }
                    this.getModel().setValue("totaloftaxamount", outContract.get("totaloftaxamount"), rowIndex);
                    boolean multiPartSettlement = outContract.getBoolean("multipartsettlement");
                    String multiPayType = outContract.getString("multipaytype");
                    if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                        MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                        totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, outContract);
                        totalRealOfTaxAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, outContract);
                        this.setCellColor("totaloftaxamount", rowIndex);
                        this.setCellColor("totalinvoiceoftaxamount", rowIndex);
                        this.setCellColor("totaluninvoicetaxamount", rowIndex);
                    } else {
                        totalSettleOfTaxAmount = outContract.getBigDecimal("totalsettleoftaxamount");
                        totalRealOfTaxAmount = outContract.getBigDecimal("totalrealoftaxamount");
                    }
                    this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, rowIndex);
                    this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, rowIndex);
                    this.getModel().setValue("controlrate", (Object)outContract.getBigDecimal("payrate"), rowIndex);
                    if (!outContract.getBoolean("ismulticontract")) {
                        this.getModel().setValue("totalinvoiceoftaxamount", (Object)outContract.getBigDecimal("totalinvoiceoftaxamount"), rowIndex);
                        this.getModel().setValue("totaluninvoicetaxamount", (Object)outContract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount), rowIndex);
                    } else {
                        QFilter filter = new QFilter("contract", "=", outContract.getPkValue());
                        filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                        filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
                        filter.and(new QFilter("contpartb", "=", outContract.getDynamicObject("partb").getPkValue()));
                        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
                        BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
                        if (invoices.length > 0) {
                            for (DynamicObject invo : invoices) {
                                invoiceOfTaxAmount = invoiceOfTaxAmount.add(invo.getBigDecimal("totaloftaxamount"));
                            }
                        }
                        this.getModel().setValue("totaluninvoicetaxamount", (Object)invoiceOfTaxAmount.subtract(totalRealOfTaxAmount), rowIndex);
                        this.getModel().setValue("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount, rowIndex);
                    }
                    this.getModel().setValue("totalunpaidoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), rowIndex);
                    this.getModel().setValue("amount", entry.get("payamount"), rowIndex);
                    this.getModel().setValue("applyoftaxamount", entry.get("payamount"), rowIndex);
                    this.getModel().setValue("endpaymentrate", entry.get("paypercent"), rowIndex);
                }
            }
            if (totalEntriesList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u652f\u51fa\u5408\u540c\u7684\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"PaymentApplyEditPlugin_30", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getModel().updateCache();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        BigDecimal sumAmount = entryGrid.getSum("applyoftaxamount");
        this.getModel().setValue("sumamount", (Object)sumAmount);
    }

    private void deleteInvoiceEntryRow(BeforeDoOperationEventArgs args) {
        EntryGrid subGrid = (EntryGrid)this.getControl("subentryentity");
        int[] selRows = subGrid.getEntryState().getSelectedRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PaymentApplyEditPlugin_31", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int upCurIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", upCurIndex);
        DynamicObjectCollection subEntryCol = rowEntity.getDynamicObjectCollection("subentryentity");
        DynamicObjectCollection invoiceEntry = new DynamicObjectCollection();
        BigDecimal entryAppOfTaxAmt = rowEntity.getBigDecimal("applyoftaxamount");
        for (int i = 0; i < selRows.length; ++i) {
            DynamicObject subEntry = (DynamicObject)subEntryCol.get(selRows[i]);
            entryAppOfTaxAmt = entryAppOfTaxAmt.subtract(subEntry.getBigDecimal("applyoftaxamtvo"));
            invoiceEntry.add((Object)subEntry);
        }
        entryAppOfTaxAmt = entryAppOfTaxAmt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : entryAppOfTaxAmt;
        this.getModel().setValue("applyoftaxamount", (Object)entryAppOfTaxAmt, upCurIndex);
        this.getView().updateView("applyoftaxamount", upCurIndex);
        DynamicObject upContract = rowEntity.getDynamicObject("entrycontract");
        if (invoiceEntry.size() > 0 && upContract != null) {
            this.unclaimSubEntry(invoiceEntry, upContract);
            this.getView().invokeOperation(OperationEnum.SAVE.getValue());
            this.getView().invokeOperation("refresh");
        }
    }

    private void addInvoiceEntryRow(BeforeDoOperationEventArgs args) {
        String billId = this.getModel().getDataEntity().getPkValue().toString();
        boolean exists = QueryServiceHelper.exists((String)"pmct_paymentapply", (Object)billId);
        if (!exists || !StatusEnum.TEMPSAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"PaymentApplyEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"PaymentApplyEditPlugin_27", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.showInvoice("subentryentity");
    }

    private void unclaimSubEntry(DynamicObjectCollection subEntryCol, DynamicObject contract) {
        if (contract == null) {
            return;
        }
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        Object[] delSubPks = new Object[subEntryCol.size()];
        BigDecimal invoiceTotalOfTaxAmount = BigDecimal.ZERO;
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        for (int i = 0; i < subEntryCol.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subEntryCol.get(i);
            DynamicObject invoice = subEntry.getDynamicObject("invoice");
            if (invoice != null) {
                String invoiceSourceId = (invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice")).getString("invoicesourceid");
                if (StringUtils.isNotBlank((CharSequence)invoiceSourceId)) {
                    InvoiceHelper.deleteInvoice((DynamicObject)invoice, (String)this.getModel().getDataEntity().getPkValue().toString());
                } else {
                    boolean isUpdateInvoice = subEntry.getBoolean("isupdateinvoice");
                    if (isUpdateInvoice) {
                        invoice.set("isclaimed", (Object)Boolean.FALSE);
                        invoice.set("project", null);
                        invoice.set("contract", null);
                        invoice.set("contpartb", null);
                        invoice.set("connecttype", (Object)"null");
                        invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                        invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
                    }
                    invoiceList.add(invoice);
                }
            }
            delSubPks[i] = subEntry.getPkValue();
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        BigDecimal invoiceOfTaxAmount = contract.getBigDecimal("totalinvoiceoftaxamount");
        BigDecimal invoiceAmount = contract.getBigDecimal("totalinvoiceamount");
        contract.set("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount.subtract(invoiceTotalOfTaxAmount));
        contract.set("totalinvoiceamount", (Object)invoiceAmount.subtract(invoiceTotalAmount));
        SaveServiceHelper.update((DynamicObject)contract);
        DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)subEntryCol.get(0)).getDataEntityType(), (Object[])delSubPks);
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[invoiceList.size()]));
        }
    }

    private void showInvoice(String entryType) {
        QFilter filter = new QFilter("isclaimed", "=", (Object)Boolean.FALSE);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
        DynamicObject contract = rowEntity.getDynamicObject("entrycontract");
        if (contract != null) {
            filter.or(new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString())));
        }
        Object accountOrgId = ((DynamicObject)this.getModel().getValue("accountorg")).getPkValue();
        filter.and(new QFilter("accountorg", "=", accountOrgId));
        filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filter.and(new QFilter("invoicestatus", "!=", (Object)InvoiceStatusEnum.CANCEL_2.getValue()));
        DynamicObjectCollection subEntry = rowEntity.getDynamicObjectCollection("subentryentity");
        if (subEntry != null && subEntry.size() > 0) {
            Set selectInvoiceIds = subEntry.stream().map(entry -> Long.parseLong(entry.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet());
            filter.and(new QFilter("id", "not in", selectInvoiceIds));
        }
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"pmct_ininvoicef7", (boolean)true);
        param.getListFilterParameter().setFilter(filter);
        param.setMultiSelect(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entryType));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (key = operate.getOperateKey()) {
            case "deleteentry": {
                BigDecimal sumamount = BigDecimal.ZERO;
                DynamicObjectCollection dCollection = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject dObject : dCollection) {
                    BigDecimal entryBigDecimal = (BigDecimal)dObject.get("applyoftaxamount");
                    if (null == entryBigDecimal) continue;
                    sumamount = sumamount.add(entryBigDecimal);
                }
                this.getModel().setValue("sumamount", (Object)sumamount);
                this.setPayAbleAmount();
                break;
            }
            case "autofetch": {
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
                BigDecimal sumamount = entryCol.stream().map(entry -> entry.getBigDecimal("applyoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("sumamount", (Object)sumamount);
                break;
            }
            case "trackup": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_paymentapply", (Long[])new Long[]{(Long)pkValue});
                if (sourceBills.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"PaymentApplyEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<String> orgIds = new ArrayList<String>(1);
                orgIds.add(this.getModel().getDataEntity().getDynamicObject("org").getString("id"));
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("org", orgIds);
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u67e5\u770b", (String)"PaymentApplyEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                listShowParameter.setBillFormId("pmbs_contractpayitembook");
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sourceBills.get("pmbs_contractpayitembook")));
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "save": {
                String flag = this.getView().getPageCache().get("newEntry");
                this.getView().getPageCache().remove("newEntry");
                String contractName = this.getView().getPageCache().get("contractName");
                this.getView().getPageCache().remove("contractName");
                if (flag != null || !StringUtils.isNotEmpty((CharSequence)contractName) || !afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().updateView("entryentity");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry2 = (DynamicObject)entryEntity.get(i);
                    if (entry2.getDynamicObject("payitem") != null) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"paymenttype"});
                    } else {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{"paymenttype"});
                    }
                    this.setEntryPrePayEnable(entry2);
                }
                this.getView().updateView("payapplysplitentry");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"PaymentApplyEditPlugin_32", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName));
                break;
            }
            case "submit": 
            case "audit": 
            case "unsubmit": 
            case "unaudit": {
                String contractName = this.getView().getPageCache().get("contractName");
                this.getView().getPageCache().remove("contractName");
                if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                    this.getView().updateView("entryentity");
                    this.getView().updateView("payapplysplitentry");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"PaymentApplyEditPlugin_32", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName));
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry3 = (DynamicObject)entryEntity.get(i);
                    DynamicObject contract = entry3.getDynamicObject("entrycontract");
                    if (contract == null) continue;
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                    boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                    String multiPayType = contract.getString("multipaytype");
                    if (!multiPartSettlement || !StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) continue;
                    this.setCellColor("totaloftaxamount", i);
                    this.setCellColor("totalinvoiceoftaxamount", i);
                    this.setCellColor("totaluninvoicetaxamount", i);
                }
                break;
            }
            case "prepaydeductiondetail": {
                this.afterDoPrePayDeductionDetail();
                break;
            }
            case "prepaydeduction": {
                this.afterDoPrePayDeduction();
                break;
            }
            case "newsplitentry": {
                this.setEntryPrePayEnable((DynamicObject)this.getModel().getEntryEntity("payapplysplitentry").getParent());
                break;
            }
        }
    }

    protected void setEntryPrePayEnable(DynamicObject contractEntry) {
        if (contractEntry == null) {
            return;
        }
        int rowIndex = contractEntry.getInt("seq") - 1;
        if (StringUtils.equals((CharSequence)contractEntry.getString("paymenttype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"thisprepaydeduction"});
        } else {
            DynamicObjectCollection splitEntry = contractEntry.getDynamicObjectCollection("payapplysplitentry");
            long count = splitEntry.stream().filter(entry -> entry.getBoolean("prepaysplit")).count();
            if (count == 0L) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"thisprepaydeduction"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"thisprepaydeduction"});
                for (int splitRowIndex = 0; splitRowIndex < splitEntry.size(); ++splitRowIndex) {
                    if (((DynamicObject)splitEntry.get(splitRowIndex)).getBoolean("prepaysplit")) {
                        this.getView().setEnable(Boolean.FALSE, splitRowIndex, new String[]{"bugdetitem"});
                        continue;
                    }
                    this.getView().setEnable(Boolean.TRUE, splitRowIndex, new String[]{"bugdetitem"});
                }
            }
        }
    }

    private void setPayAbleAmount() {
        BigDecimal payAbleAmount = BigDecimal.ZERO;
        DynamicObjectCollection contractEntry = this.getModel().getEntryEntity("entryentity");
        if (contractEntry != null) {
            for (DynamicObject entry : contractEntry) {
                payAbleAmount = payAbleAmount.add(entry.getBigDecimal("thispayableamount"));
            }
        }
        this.getModel().setValue("payableamount", (Object)payAbleAmount);
    }

    private void afterDoPrePayDeduction() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("pmas_projectbudget");
        showParameter.setFormId("pmbs_prepaysplitbudget");
        showParameter.setLookUp(true);
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u5206\u644a\u9884\u7b97\u9879", (String)"PaymentApplyEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        DynamicObject contEntry = (DynamicObject)this.getModel().getEntryEntity("payapplysplitentry").getParent();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        showParameter.setCustomParam("org", org.getPkValue());
        DynamicObject contPro = contEntry.getDynamicObject("contpro");
        if (contPro != null) {
            showParameter.setCustomParam("contpro", contPro.getPkValue());
        }
        DynamicObject cont = contEntry.getDynamicObject("entrycontract");
        showParameter.setCustomParam("entrycontract", cont.getPkValue());
        DynamicObject contCurrency = contEntry.getDynamicObject("contcurrency");
        showParameter.setCustomParam("contcurrency", contCurrency.getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmbs_prepaysplitbudget"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void afterDoPrePayDeductionDetail() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770b\u9884\u4ed8\u6b3e\u62b5\u6263\u8be6\u60c5\u7684\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u884c\u3002", (String)"PaymentApplyEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"PaymentApplyEditPlugin_27", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmct_prepaydetail");
        showParameter.setAppId(this.getView().getFormShowParameter().getAppId());
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        DynamicObject entryContract = (DynamicObject)this.getModel().getValue("entrycontract", selectRows[0]);
        showParameter.setCustomParam("contract", entryContract.getPkValue());
        BigDecimal contractAmount = (BigDecimal)this.getModel().getValue("totaloftaxamount", selectRows[0]);
        showParameter.setCustomParam("contractamount", (Object)contractAmount);
        DynamicObject contCurrency = (DynamicObject)this.getModel().getValue("contcurrency", selectRows[0]);
        showParameter.setCustomParam("contractcurrency", contCurrency.getPkValue());
        DynamicObject project = (DynamicObject)this.getModel().getValue("contpro", selectRows[0]);
        if (project != null) {
            showParameter.setCustomParam("project", project.getPkValue());
        }
        String paymentType = (String)this.getModel().getValue("paymenttype", selectRows[0]);
        showParameter.setCustomParam("paymenttype", (Object)paymentType);
        BigDecimal thisPrePayDeductionAmount = (BigDecimal)this.getModel().getValue("thisprepaydeduction", selectRows[0]);
        showParameter.setCustomParam("thisprepaydeduction", (Object)thisPrePayDeductionAmount);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        showParameter.setCustomParam("org", org.getPkValue());
        String billStatus = (String)this.getModel().getValue("billstatus", selectRows[0]);
        showParameter.setCustomParam("billstatus", (Object)billStatus);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_prepaydetail"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.equals("pmct_outcontract") && event.getReturnData() != null) {
            this.selectContractCloseBack(event);
        } else if ("subentryentity".equals(actionId) && event.getReturnData() != null) {
            this.selectInvoiceBack(event);
        } else if ("pmbs_prepaysplitbudget".equals(actionId) && event.getReturnData() != null) {
            this.selectPrePayBudgetItemBack(event);
        }
    }

    protected void selectPrePayBudgetItemBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        DynamicObject contractEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(this.getModel().getEntryCurrentRowIndex("entryentity"));
        DynamicObjectCollection splitEntry = contractEntry.getDynamicObjectCollection("payapplysplitentry");
        DynamicObject entryContract = contractEntry.getDynamicObject("entrycontract");
        int index = splitEntry.size() + 1;
        for (Map.Entry entry : returnData.entrySet()) {
            DynamicObject split = new DynamicObject(splitEntry.getDynamicObjectType());
            split.set("seq", (Object)index++);
            DynamicObject budgetItem = null;
            if (QueryServiceHelper.exists((String)"pmas_projectbudget", entry.getKey())) {
                budgetItem = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"pmas_projectbudget");
                split.set("bugdetitem", (Object)budgetItem);
            }
            split.set("prepaysplit", (Object)Boolean.TRUE);
            split.set("deductibleamount", entry.getValue());
            split.set("cursplitamt", (Object)this.getDeductibleAmount(budgetItem));
            QFilter filter = new QFilter("budgetitem", "=", entry.getKey());
            filter.and(new QFilter("contract", "=", entryContract.getPkValue()));
            DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
            if (contBudgetInfo.length > 0) {
                BigDecimal contractAuditAmtEx = contBudgetInfo[0].getBigDecimal("contractauditamtex");
                BigDecimal settleAuditAmtEx = contBudgetInfo[0].getBigDecimal("settleauditamtex");
                BigDecimal payApplyAuditAmtEx = contBudgetInfo[0].getBigDecimal("payapplyauditamtex");
                split.set("contractamount", (Object)contractAuditAmtEx);
                split.set("settledamount", (Object)settleAuditAmtEx);
                split.set("payedamount", (Object)payApplyAuditAmtEx);
            }
            splitEntry.add((Object)split);
        }
        this.getView().updateView("payapplysplitentry");
        int contractCurRow = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("thisprepaydeduction", (Object)this.getSumCurSplitAmountByPrePaySplit(), contractCurRow);
        this.setEntryPrePayEnable((DynamicObject)splitEntry.getParent());
        this.setDeductibleaMountSum();
    }

    protected void selectInvoiceBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
        DynamicObject[] invArr = new DynamicObject[rows.size()];
        int index = 0;
        int upCurIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject upCurEntryEntity = this.getModel().getEntryRowEntity("entryentity", upCurIndex);
        DynamicObject upContract = (DynamicObject)this.getModel().getValue("entrycontract", upCurIndex);
        upContract = BusinessDataServiceHelper.loadSingle((Object)upContract.getPkValue(), (String)"pmct_outcontract");
        BigDecimal invoiceTotalOfTaxAmount = upContract.getBigDecimal("totalinvoiceoftaxamount");
        BigDecimal invoiceTotalAmount = upContract.getBigDecimal("totalinvoiceamount");
        BigDecimal applyOfTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection subEntryEntity = upCurEntryEntity.getDynamicObjectCollection("subentryentity");
        if (rows.size() > 0 && subEntryEntity.size() > 0) {
            applyOfTaxAmount = upCurEntryEntity.getBigDecimal("applyoftaxamount");
        }
        for (ListSelectedRow row : rows) {
            String invoicePk = row.getPrimaryKeyValue().toString();
            int rowIndex = this.getModel().createNewEntryRow("subentryentity");
            this.getModel().setValue("invoice", (Object)invoicePk.toString(), rowIndex);
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)"pmct_ininvoice", (String)"isClaimed,contract,project,connecttype,currency,totalamount,totaltax,totaloftaxamount,contpartb,totaluseamt");
            DynamicObject currency = invoice.getDynamicObject("currency");
            if (currency != null) {
                this.getModel().setValue("invoicecurrency", currency.getPkValue(), rowIndex);
            }
            this.getModel().setValue("invoiceamount", (Object)invoice.getBigDecimal("totalamount"), rowIndex);
            this.getModel().setValue("invoicetax", (Object)invoice.getBigDecimal("totaltax"), rowIndex);
            this.getModel().setValue("oftaxinvoiceamount", (Object)invoice.getBigDecimal("totaloftaxamount"), rowIndex);
            BigDecimal subEntryApplyAmt = NumberHelper.subtract((Object)invoice.getBigDecimal("totaloftaxamount"), (Object)invoice.getBigDecimal("totaluseamt"));
            this.getModel().setValue("applyoftaxamtvo", (Object)subEntryApplyAmt, rowIndex);
            applyOfTaxAmount = applyOfTaxAmount.add(subEntryApplyAmt);
            if (invoice.getBoolean("isclaimed")) {
                this.getModel().setValue("isupdateinvoice", (Object)false, rowIndex);
            } else {
                this.getModel().setValue("isupdateinvoice", (Object)true, rowIndex);
                invoice.set("isclaimed", (Object)Boolean.TRUE);
                invoice.set("contract", (Object)upContract);
                invoice.set("contpartb", upContract.getDynamicObject("partb").getPkValue());
                invoice.set("project", (Object)upCurEntryEntity.getDynamicObject("contpro"));
                invoice.set("connecttype", (Object)"contract");
                invoiceTotalOfTaxAmount = invoiceTotalOfTaxAmount.add(invoice.getBigDecimal("totaloftaxamount"));
                invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("totalamount"));
            }
            invArr[index++] = invoice;
        }
        upContract.set("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount);
        upContract.set("totalinvoiceamount", (Object)invoiceTotalAmount);
        SaveServiceHelper.update((DynamicObject)upContract);
        SaveServiceHelper.save((DynamicObject[])invArr);
        if (rows.size() > 0) {
            this.getModel().setValue("applyoftaxamount", (Object)applyOfTaxAmount, upCurIndex);
        }
        this.getModel().setValue("totalinvoiceoftaxamount", (Object)invoiceTotalOfTaxAmount, upCurIndex);
        BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", upCurIndex);
        this.getModel().setValue("totaluninvoicetaxamount", (Object)invoiceTotalOfTaxAmount.subtract(totalRealOfTaxAmount), upCurIndex);
        this.getView().updateView("applyoftaxamount", upCurIndex);
        this.getView().updateView("totalinvoiceoftaxamount", upCurIndex);
        this.getView().updateView("totaluninvoicetaxamount", upCurIndex);
        this.getView().getPageCache().put("newEntry", "true");
        this.getView().invokeOperation(OperationEnum.SAVE.getValue());
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"PaymentApplyEditPlugin_32", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), upContract.getString("billname")));
        this.getView().invokeOperation("refresh");
    }

    protected void budgetCloseBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    protected void selectContractCloseBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        for (ListSelectedRow listSelectedRow : rows) {
            selectedIds.add(listSelectedRow.getPrimaryKeyValue());
        }
        for (Object e : selectedIds) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("entrycontract", e, row);
        }
    }

    private void fillSplitEntry(int addRow) {
        DynamicObject model = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObject addContractRowObj = (DynamicObject)model.getDynamicObjectCollection("entryentity").get(addRow);
        DynamicObject entryContract = addContractRowObj.getDynamicObject("entrycontract");
        DynamicObject entryContPro = addContractRowObj.getDynamicObject("contpro");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_outcontract");
        if (contract != null) {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            if (entryContPro == null) {
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                if (multiPartSettlement) {
                    Set proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                    if (proIdSet != null && !proIdSet.isEmpty()) {
                        filter.and("budgetitem.project", "in", (Object)proIdSet);
                    }
                } else {
                    DynamicObject contPro = contract.getDynamicObject("project");
                    if (contPro != null) {
                        filter.and("budgetitem.project", "=", contPro.getPkValue());
                    }
                }
            } else {
                filter.and("budgetitem.project", "=", entryContPro.getPkValue());
            }
            DynamicObject[] contractBudgetEntry = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "id", "budgetitem", "contractauditamtex", "settleauditamtex", "payapplyauditamtex"), (QFilter[])new QFilter[]{filter});
            DynamicObjectCollection paySplitEntry = addContractRowObj.getDynamicObjectCollection("payapplysplitentry");
            for (int i = 0; i < contractBudgetEntry.length; ++i) {
                DynamicObject contractBudget = contractBudgetEntry[i];
                DynamicObject paySplitEntryRowObj = paySplitEntry.addNew();
                paySplitEntryRowObj.set("seq", (Object)(i + 1));
                paySplitEntryRowObj.set("bugdetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
                paySplitEntryRowObj.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                paySplitEntryRowObj.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                paySplitEntryRowObj.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
            }
            this.getView().updateView("payapplysplitentry");
        }
    }

    private void setAllAmount(DynamicObject org, DynamicObject period, DynamicObject contract, DynamicObject entryContPro, int row, DynamicObject supplier) {
        DynamicObjectCollection entryEntity;
        DynamicObject targetEntry;
        BigDecimal totalRealOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, supplier);
            totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryContPro, contract, period, supplier);
            this.setCellColor("totaloftaxamount", row);
            this.setCellColor("totalinvoiceoftaxamount", row);
            this.setCellColor("totaluninvoicetaxamount", row);
        } else {
            InComeUtils inComeUtils = new InComeUtils();
            totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, supplier);
            totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, supplier);
        }
        this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, row);
        this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, row);
        BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount);
        this.getModel().setValue("totalunpaidoftaxamount", (Object)totalSettleAndUnRealPayAmount, row);
        this.getModel().setValue("applyoftaxamount", (Object)totalSettleAndUnRealPayAmount, row);
        MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, org, entryContPro);
        if (fundPlanBill != null && (targetEntry = (DynamicObject)(entryEntity = fundPlanBill.getDynamicObjectCollection("outcontractplanentity")).stream().filter(entry -> StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entry.getDynamicObject("outcontract").getPkValue().toString())).findFirst().orElse(null)) != null) {
            amount = targetEntry.getBigDecimal("outperiodplanamt");
            this.getModel().setValue("fundplan", targetEntry.getPkValue());
        }
        this.getModel().setValue("amount", (Object)amount, row);
        if (!contract.getBoolean("ismulticontract")) {
            this.getModel().setValue("totaluninvoicetaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount), row);
            this.getModel().setValue("totalinvoiceoftaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"), row);
        } else {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
            if (supplier != null) {
                filter.and(new QFilter("contpartb", "=", supplier.getPkValue()));
            }
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
            BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
            if (invoices.length > 0) {
                for (DynamicObject inVo : invoices) {
                    invoiceOfTaxAmount = invoiceOfTaxAmount.add(inVo.getBigDecimal("totaloftaxamount"));
                }
            }
            this.getModel().setValue("totaluninvoicetaxamount", (Object)invoiceOfTaxAmount.subtract(totalRealOfTaxAmount), row);
            this.getModel().setValue("totalinvoiceoftaxamount", (Object)invoiceOfTaxAmount, row);
        }
        if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue("endpaymentrate", (Object)totalRealOfTaxAmount.divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), row);
        }
        PrePayService prePayService = new PrePayService();
        Object projectId = entryContPro == null ? null : entryContPro.getPkValue();
        DynamicObjectCollection contractEntries = this.getModel().getEntryEntity("entryentity");
        BigDecimal deductibleAmountByContract = prePayService.getDeductibleAmountByContract(contract, projectId, org.getPkValue());
        BigDecimal thisDeductionAmountByContract = prePayService.getThisDeductionAmountByContract(contract, projectId, contractEntries);
        this.getModel().setValue("thisprepaydeduction", (Object)deductibleAmountByContract.subtract(thisDeductionAmountByContract), row);
    }

    private void setCellColor(String fieldKey, int row) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor("gray");
        cs.setForeColor("black");
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (propertyName.equals("invoice")) {
            QFilter filter = new QFilter("org", "=", org.getPkValue());
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"entrycontract", (CharSequence)propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_paymentapply", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
        } else if ("contpartb".equals(propertyName)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", this.getModel().getEntryCurrentRowIndex("entryentity"));
            ArrayList<Object> contPartbs = new ArrayList<Object>();
            if (contract != null) {
                DynamicObject partb = contract.getDynamicObject("partb");
                DynamicObjectCollection otherPart = contract.getDynamicObjectCollection("otherpart");
                contPartbs.add(partb.getPkValue());
                if (otherPart.size() > 0) {
                    for (DynamicObject other : otherPart) {
                        contPartbs.add(other.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
            }
            QFilter contPartbFilter = new QFilter("id", "in", contPartbs);
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(contPartbFilter);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"bugdetitem")) {
            this.newSplitEntry(event);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", event.getRow());
            if (contract != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(ContractHelper.getEntryProFilter((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)contract));
                showParameter.setMultiSelect(false);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"person")) {
            QFilter qFilter;
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            param.setF7Style(3);
            List qFilterList = param.getListFilterParameter().getQFilters();
            long currUserId = RequestContext.get().getCurrUserId();
            long projectId = 0L;
            Object projectObj = this.getModel().getValue("project");
            if (projectObj != null) {
                DynamicObject project = (DynamicObject)projectObj;
                projectId = Long.parseLong(project.getPkValue().toString());
            }
            if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) != null) {
                qFilterList.add(qFilter);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("entryentity")) {
            this.setPrePayDeductionButtonEnable();
            int row = evt.getRow();
            if (row == -1) {
                row = 0;
            }
            this.setEntryPrePayEnable(this.getModel().getEntryRowEntity("entryentity", row));
        }
    }

    private void setPrePayDeductionButtonEnable() {
        EntryGrid contractEntryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection payApplySplitEntry = this.getModel().getEntryEntity("payapplysplitentry");
        if (payApplySplitEntry != null && payApplySplitEntry.getParent() != null && StringUtils.equals((CharSequence)((DynamicObject)payApplySplitEntry.getParent()).getString("paymenttype"), (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue()) && contractEntryGrid.getSelectRows().length == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{OPERATE_PRE_PAY_DEDUCTION});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{OPERATE_PRE_PAY_DEDUCTION});
        }
    }

    protected void showOrHidePayApplySplitEntry() {
    }

    private void setDeductibleaMountSum() {
        EntryGrid grid = (EntryGrid)this.getControl("payapplysplitentry");
        HashMap<String, String> floatBottomData = new HashMap<String, String>(16);
        DynamicObject contCurrency = (DynamicObject)this.getModel().getValue("contcurrency");
        DynamicObjectCollection collection = this.getModel().getEntryEntity("payapplysplitentry");
        if (collection == null) {
            return;
        }
        HashMap<Long, BigDecimal> sumMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject dynamicObject : collection) {
            DynamicObject budgetItem;
            if (!dynamicObject.getBoolean("prepaysplit") || (budgetItem = (DynamicObject)dynamicObject.get("bugdetitem")) == null) continue;
            Long id = Long.parseLong(budgetItem.getPkValue().toString());
            sumMap.put(id, dynamicObject.getBigDecimal("deductibleamount"));
        }
        BigDecimal sum = Arrays.stream(sumMap.values().toArray(new BigDecimal[0])).reduce(BigDecimal.ZERO, BigDecimal::add);
        floatBottomData.put("deductibleamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)contCurrency, (Object)sum));
        grid.setFloatButtomData(floatBottomData);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!StatusEnum.TEMPSAVE.getValue().equals(billStatus)) {
            this.getModel().setDataChanged(false);
        }
    }
}

