/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contclaim;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.contractlist.ContractListClaimTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ClaimTplEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    protected static String LISTINGFORMID = "pmct_contractlist";
    protected static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    protected static final String CLAIM_PAY_PLAN = "claimpayplan";
    protected static final String CUR_LIST_ROW = "curListRow";
    protected static final String DELETE_ENTRY = "deleteentry";
    protected static final String AMT_PRECISION = "amtprecision";
    protected static final String PRICE_PRECISION = "priceprecision";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit superListingName = (TextEdit)this.getView().getControl("superlistingname");
        superListingName.addButtonClickListener((ClickListener)this);
        BasedataEdit listing = (BasedataEdit)this.getControl("listid");
        listing.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("kapianentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject payItem = BusinessDataServiceHelper.loadSingle((Object)"849909148731577344", (String)"pmct_payitem");
        this.getModel().setValue("contpayitem", (Object)payItem);
        ContractHelper.showContractList((IFormView)this.getView());
        this.getPageCache().put(CUR_LIST_ROW, "0");
        if (this.isOutContract()) {
            ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
        } else {
            ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String entryKey;
        String property = e.getKey();
        int rowIndex = e.getRowIndex();
        Object newValue = e.getValue();
        switch (property) {
            case "oftax": 
            case "amount": {
                boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
                if (!isAdjustAmount) break;
                DynamicObjectCollection subEntries = this.getModel().getEntryEntity("entryentity");
                DynamicObject subEntry = (DynamicObject)subEntries.get(rowIndex);
                BigDecimal qty = subEntry.getBigDecimal("qty");
                BigDecimal priceOfTax = subEntry.getBigDecimal("oftaxprice");
                BigDecimal price = subEntry.getBigDecimal("price");
                BigDecimal oldAmount = property.equalsIgnoreCase("amount") ? price.multiply(qty) : priceOfTax.multiply(qty);
                boolean isRollBack = ContractEditHelper.amountRollback((IFormView)this.getView(), (DynamicObject)subEntry, (Object)newValue, (Object)oldAmount, (String)property, (int)rowIndex);
                if (!isRollBack) break;
                this.getModel().updateEntryCache(subEntries);
                e.setCancel(true);
                break;
            }
        }
        if (e.getSource() instanceof FieldEdit && "entryentity".equalsIgnoreCase(entryKey = ((FieldEdit)e.getSource()).getEntryKey()) && !((Boolean)this.getModel().getValue("isneedsettle")).booleanValue()) {
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object propNewValue = e.getChangeSet()[0].getNewValue();
        Object propOldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "claimoftaxamount": {
                this.changeClaimOfTaxAmount((BigDecimal)propNewValue);
                break;
            }
            case "claimamount": {
                BigDecimal claimOfTaxAmount = (BigDecimal)this.getModel().getValue("claimoftaxamount");
                this.calculateTaxAmount(claimOfTaxAmount);
                break;
            }
            case "subclaimtype": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeSubClaimType(propNewValue, rowIndex, curListRow);
                break;
            }
            case "listid": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeList(propNewValue, propOldValue, rowIndex, curListRow);
                break;
            }
            case "materiel": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeMaterial(propNewValue, rowIndex, curListRow);
                break;
            }
            case "qty": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeQty(rowIndex, curListRow);
                break;
            }
            case "price": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changePrice(propNewValue, rowIndex, curListRow);
                break;
            }
            case "rateobj": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeRateObj(propNewValue, rowIndex, curListRow);
                break;
            }
            case "oftaxprice": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeOfTaxPrice(propNewValue, rowIndex, curListRow);
                break;
            }
            case "oftax": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeOfTax(propNewValue, rowIndex, curListRow);
                break;
            }
            case "amount": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeAmount(propNewValue, rowIndex, curListRow);
                break;
            }
            case "changecount": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeCount(propNewValue, rowIndex, curListRow);
                break;
            }
            case "afterclaimoftaxprice": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeAfterClaimOfTaxPrice(propNewValue, rowIndex, curListRow);
                break;
            }
            case "superlistingname": {
                int curListRow = Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW));
                this.changeSuperListingName((String)propNewValue, rowIndex, curListRow);
                break;
            }
            case "sysnum": {
                this.validateSysNum(e);
                break;
            }
            case "isadjustamount": {
                boolean isAdjustAmount = (Boolean)propNewValue;
                DynamicObjectCollection entityEntry = this.getModel().getDataEntity().getDynamicObjectCollection("kapianentry");
                if (isAdjustAmount) break;
                int index = 0;
                for (DynamicObject entity : entityEntry) {
                    DynamicObjectCollection subEntries = entity.getDynamicObjectCollection("entryentity");
                    boolean isEnterAmount = (Boolean)this.getModel().getValue("isenteramount");
                    boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                    ContractEditHelper.resetEntryAmountField((DynamicObjectCollection)subEntries, (boolean)isEnterAmount, (boolean)isOfTaxContract, (DynamicObject)currency, (String)"qty", (String)"oftax", (String)"amount", (String)"subtaxrate", (String)"oftaxprice", (String)"price", (String)"tax");
                    this.getModel().updateEntryCache(subEntries);
                    this.getView().updateView("entryentity");
                    this.summaryToCard(index);
                    ++index;
                }
                break;
            }
        }
    }

    private void validateSysNum(PropertyChangedArgs e) {
        String jumpPropertyChangeEvent = this.getView().getPageCache().get("jumpPropertyChangeEvent");
        if (StringUtils.equals((CharSequence)jumpPropertyChangeEvent, (CharSequence)"true")) {
            this.getView().getPageCache().remove("jumpPropertyChangeEvent");
            return;
        }
        Object propValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String curModelRow = this.getPageCache().get(CUR_LIST_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        HashSet<String> sysNumSet = new HashSet<String>();
        DynamicObjectCollection listmodelEntry = this.getModel().getEntryEntity("kapianentry");
        DynamicObject currentListModel = (DynamicObject)listmodelEntry.get(parentModelRow);
        DynamicObjectCollection entryEntity = currentListModel.getDynamicObjectCollection("entryentity");
        String changeType = (String)this.getModel().getValue("subclaimtype", rowIndex, parentModelRow);
        if (ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue().equals(changeType) || ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(changeType)) {
            DynamicObject[] listings;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryEntityObj;
                String sysNumber;
                if (i == rowIndex || !StringUtils.isNotEmpty((CharSequence)(sysNumber = (entryEntityObj = (DynamicObject)entryEntity.get(i)).getString("sysnum")))) continue;
                sysNumSet.add(sysNumber);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put("jumpPropertyChangeEvent", "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ClaimTplEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            Object listModelId = this.getModel().getValue("listmodelid", parentModelRow);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            for (DynamicObject listing : listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
                String listSysNum = listing.getString("sysnumber");
                if (!StringUtils.isNotEmpty((CharSequence)listSysNum)) continue;
                sysNumSet.add(listSysNum);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put("jumpPropertyChangeEvent", "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ClaimTplEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
            }
        }
    }

    private void changeSuperListingName(String propNewValue, int rowIndex, int curListRow) {
        if (propNewValue == null || propNewValue.isEmpty()) {
            Long superListingId = (Long)this.getModel().getValue("superlistingid", rowIndex, curListRow);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                Long newListingId = ((DynamicObject)entryEntity.get(i)).getLong("newlistingid");
                if (!newListingId.equals(superListingId)) continue;
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"subclaimtype"});
            }
            DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
            String subChangeType = row.getString("subclaimtype");
            String sysNum = this.genSysNumber(subChangeType);
            this.getModel().setValue("sysnum", (Object)sysNum, rowIndex, curListRow);
        }
    }

    private void changeClaimOfTaxAmount(BigDecimal claimOfTaxAmount) {
        Boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
        BigDecimal taxRate = taxRateObj == null ? BigDecimal.ZERO : taxRateObj.getBigDecimal("taxrate");
        int amtPrecision = this.getPrecision(AMT_PRECISION);
        if (!isMultiRate.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("claimamount", (Object)claimOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(ONE_HUNDRED)), amtPrecision, 4));
            this.getModel().endInit();
            this.getView().updateView("claimamount");
        }
        this.calculateTaxAmount(claimOfTaxAmount);
    }

    private void calculateTaxAmount(BigDecimal claimOfTaxAmount) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        Boolean isNeedSettle = (Boolean)this.getModel().getValue("isneedsettle");
        if (contract == null || !contract.getBoolean("isonlist") || !isNeedSettle.booleanValue()) {
            this.getModel().setValue("taxamount", (Object)claimOfTaxAmount.subtract((BigDecimal)this.getModel().getValue("claimamount")));
        }
    }

    private void summaryToCard(int curListRow) {
        DynamicObjectCollection cardEntries = this.getModel().getEntryEntity("kapianentry");
        DynamicObject cardEntry = (DynamicObject)cardEntries.get(curListRow);
        DynamicObjectCollection subEntryEntity = cardEntry.getDynamicObjectCollection("entryentity");
        BigDecimal listTotalAmount = BigDecimal.ZERO;
        BigDecimal listTotalOfTaxAmount = BigDecimal.ZERO;
        int amtPrecision = this.getPrecision(AMT_PRECISION);
        for (DynamicObject entity : subEntryEntity) {
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal ofTax = BigDecimal.ZERO;
            BigDecimal taxRate = entity.getBigDecimal("subtaxrate").divide(ONE_HUNDRED);
            if (ContractListClaimTypeEnum.COUNT_CHANGE.getValue().equals(entity.getString("subclaimtype"))) {
                amount = entity.getBigDecimal("thisafteroftaxamount").divide(BigDecimal.ONE.add(taxRate), amtPrecision, 4);
                ofTax = entity.getBigDecimal("thisafteroftaxamount");
            } else if (ContractListClaimTypeEnum.PRICE_CHANGE.getValue().equals(entity.getString("subclaimtype"))) {
                amount = entity.getBigDecimal("thisafteroftaxamount").divide(BigDecimal.ONE.add(taxRate), amtPrecision, 4);
                ofTax = entity.getBigDecimal("thisafteroftaxamount");
            } else if (ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(entity.getString("subclaimtype"))) {
                amount = entity.getBigDecimal("amount");
                ofTax = entity.getBigDecimal("oftax");
            }
            listTotalAmount = listTotalAmount.add(amount);
            listTotalOfTaxAmount = listTotalOfTaxAmount.add(ofTax);
        }
        this.getModel().setValue("totalamount", (Object)listTotalAmount, curListRow);
        this.getModel().setValue("totaltax", (Object)listTotalOfTaxAmount.subtract(listTotalAmount), curListRow);
        this.getModel().setValue("totaloftaxamount", (Object)listTotalOfTaxAmount, curListRow);
        if (((Boolean)this.getModel().getValue("isneedsettle")).booleanValue()) {
            this.changeTotalOfTaxAmount(cardEntries);
            this.changeTotalAmount(cardEntries);
            this.changeTotalTax(cardEntries);
        }
    }

    private void changeTotalTax(DynamicObjectCollection cardEntry) {
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject entry : cardEntry) {
            String capType = entry.getString("cmptype");
            BigDecimal totalOfTaxAmount = entry.getBigDecimal("totaltax");
            if ("(+)".equals(capType)) {
                total = total.add(totalOfTaxAmount);
                continue;
            }
            if (!"(-)".equals(capType)) continue;
            total = total.subtract(totalOfTaxAmount);
        }
        this.getModel().setValue("taxamount", (Object)total);
    }

    private void changeTotalAmount(DynamicObjectCollection cardEntry) {
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject entry : cardEntry) {
            String capType = entry.getString("cmptype");
            BigDecimal totalOfTaxAmount = entry.getBigDecimal("totalamount");
            if ("(+)".equals(capType)) {
                total = total.add(totalOfTaxAmount);
                continue;
            }
            if (!"(-)".equals(capType)) continue;
            total = total.subtract(totalOfTaxAmount);
        }
        this.getModel().setValue("claimamount", (Object)total);
    }

    private void changeTotalOfTaxAmount(DynamicObjectCollection cardEntries) {
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject entry : cardEntries) {
            String capType = entry.getString("cmptype");
            BigDecimal totalOfTaxAmount = entry.getBigDecimal("totaloftaxamount");
            if ("(+)".equals(capType)) {
                total = total.add(totalOfTaxAmount);
                continue;
            }
            if (!"(-)".equals(capType)) continue;
            total = total.subtract(totalOfTaxAmount);
        }
        this.getModel().setValue("claimoftaxamount", (Object)total);
    }

    private void changeAfterClaimOfTaxPrice(Object propNewValue, int rowIndex, int curListRow) {
        BigDecimal afterClaimOfTaxPrice = (BigDecimal)propNewValue;
        if (afterClaimOfTaxPrice.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("thisafteroftaxamount", (Object)BigDecimal.ZERO, rowIndex, curListRow);
            this.getModel().setValue("subafteroftaxamount", (Object)BigDecimal.ZERO, rowIndex, curListRow);
            this.getView().updateView("entryentity");
            this.summaryToCard(curListRow);
            return;
        }
        this.getModel().beginInit();
        BigDecimal ofTaxPrice = (BigDecimal)this.getModel().getValue("oftaxprice", rowIndex, curListRow);
        BigDecimal beAffectedCount = (BigDecimal)this.getModel().getValue("beaffectedcount", rowIndex, curListRow);
        BigDecimal thisAfterOftaxAmount = afterClaimOfTaxPrice.subtract(ofTaxPrice).multiply(beAffectedCount);
        this.getModel().setValue("thisafteroftaxamount", (Object)thisAfterOftaxAmount, rowIndex, curListRow);
        BigDecimal ofTax = (BigDecimal)this.getModel().getValue("oftax", rowIndex, curListRow);
        this.getModel().setValue("subafteroftaxamount", (Object)thisAfterOftaxAmount.add(ofTax), rowIndex, curListRow);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    private void changeCount(Object propNewValue, int rowIndex, int curListRow) {
        this.getModel().beginInit();
        BigDecimal changeCount = (BigDecimal)propNewValue;
        BigDecimal ofTaxPrice = (BigDecimal)this.getModel().getValue("oftaxprice", rowIndex, curListRow);
        this.getModel().setValue("thisafteroftaxamount", (Object)changeCount.multiply(ofTaxPrice), rowIndex, curListRow);
        BigDecimal thisAfterOfTaxAmount = (BigDecimal)this.getModel().getValue("thisafteroftaxamount", rowIndex, curListRow);
        BigDecimal ofTax = (BigDecimal)this.getModel().getValue("oftax", rowIndex, curListRow);
        this.getModel().setValue("subafteroftaxamount", (Object)thisAfterOfTaxAmount.add(ofTax), rowIndex, curListRow);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    protected void changeAmount(Object propNewValue, int rowIndex, int curListRow) {
        BigDecimal amount = (BigDecimal)propNewValue;
        boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
        if (isAdjustAmount) {
            BigDecimal oftax = (BigDecimal)this.getModel().getValue("oftax", rowIndex, curListRow);
            this.getModel().setValue("tax", (Object)oftax.subtract(amount), rowIndex, curListRow);
        } else {
            this.getModel().beginInit();
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
            BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED, 10, 4);
            BigDecimal ofTax = amount.multiply(BigDecimal.ONE.add(subTaxRate));
            this.getModel().setValue("oftax", (Object)ofTax, rowIndex, curListRow);
            this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
            if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal price = amount.divide(qty, pricePrecision, 4);
                this.getModel().setValue("price", (Object)price, rowIndex, curListRow);
                this.getModel().setValue("oftaxprice", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        this.summaryToCard(curListRow);
    }

    private void changeOfTax(Object propNewValue, int rowIndex, int curListRow) {
        BigDecimal ofTax = (BigDecimal)propNewValue;
        boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
        if (isAdjustAmount) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
            this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
        } else {
            this.getModel().beginInit();
            int pricePrecision = this.getPrecision(PRICE_PRECISION);
            BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED);
            this.getModel().setValue("amount", (Object)ofTax.divide(BigDecimal.ONE.add(subTaxRate), pricePrecision, 4), rowIndex, curListRow);
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
            if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("price", (Object)amount.divide(qty, pricePrecision, 4), rowIndex, curListRow);
            }
            this.getModel().setValue("tax", (Object)amount.multiply(subTaxRate), rowIndex, curListRow);
            BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex, curListRow);
            this.getModel().setValue("oftaxprice", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        this.summaryToCard(curListRow);
    }

    private void changeOfTaxPrice(Object propNewValue, int rowIndex, int curListRow) {
        int pricePrecision = this.getPrecision(PRICE_PRECISION);
        BigDecimal ofTaxPrice = (BigDecimal)propNewValue;
        BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED);
        this.getModel().beginInit();
        BigDecimal price = ofTaxPrice.divide(BigDecimal.ONE.add(subTaxRate), pricePrecision, 4);
        this.getModel().setValue("price", (Object)price, rowIndex, curListRow);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
        BigDecimal amount = price.multiply(qty);
        this.getModel().setValue("amount", (Object)amount, rowIndex, curListRow);
        BigDecimal ofTax = ofTaxPrice.multiply(qty);
        this.getModel().setValue("oftax", (Object)ofTax, rowIndex, curListRow);
        this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
        this.getModel().endInit();
        this.summaryToCard(curListRow);
        this.getView().updateView("entryentity");
    }

    private void changeRateObj(Object propNewValue, int rowIndex, int curListRow) {
        BigDecimal subTaxRate;
        BigDecimal amount;
        this.getModel().beginInit();
        if (propNewValue != null) {
            BigDecimal taxRate = ((DynamicObject)propNewValue).getBigDecimal("taxrate");
            this.getModel().setValue("subtaxrate", (Object)taxRate, rowIndex, curListRow);
            amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
            subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED);
            this.getModel().setValue("tax", (Object)amount.multiply(subTaxRate), rowIndex, curListRow);
        } else {
            subTaxRate = BigDecimal.ZERO;
            this.getModel().setValue("subtaxrate", (Object)subTaxRate, rowIndex, curListRow);
        }
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex, curListRow);
        this.getModel().setValue("oftaxprice", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
        amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
        this.getModel().setValue("oftax", (Object)amount.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    private void changePrice(Object propNewValue, int rowIndex, int curListRow) {
        this.getModel().beginInit();
        BigDecimal price = (BigDecimal)propNewValue;
        BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED);
        this.getModel().setValue("oftaxprice", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
        this.getModel().setValue("amount", (Object)qty.multiply(price), rowIndex, curListRow);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
        this.getModel().setValue("tax", (Object)amount.multiply(subTaxRate), rowIndex, curListRow);
        this.getModel().setValue("oftax", (Object)amount.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    private void changeQty(int rowIndex, int curListRow) {
        int amtPrecision = this.getPrecision(AMT_PRECISION);
        this.getModel().beginInit();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex, curListRow);
        this.getModel().setValue("amount", (Object)price.multiply(qty), rowIndex, curListRow);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex, curListRow);
        BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("subtaxrate", rowIndex, curListRow)).divide(ONE_HUNDRED);
        this.getModel().setValue("tax", (Object)amount.multiply(subTaxRate), rowIndex, curListRow);
        this.getModel().setValue("oftax", (Object)amount.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    private void changeMaterial(Object propNewValue, int rowIndex, int curListRow) {
        if (propNewValue != null) {
            DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)propNewValue).getPkValue(), (String)"bd_material");
            this.getModel().setValue("materiel", (Object)material, rowIndex, curListRow);
            this.getModel().setValue("listnumber", (Object)material.getString("number"), rowIndex, curListRow);
            this.getModel().setValue("listname", (Object)material.getString("name"), rowIndex, curListRow);
            this.getModel().setValue("measureunit", (Object)material.getDynamicObject("baseunit"), rowIndex, curListRow);
        } else {
            this.getModel().setValue("materiel", null, rowIndex, curListRow);
            this.getModel().setValue("listnumber", null, rowIndex, curListRow);
            this.getModel().setValue("listname", null, rowIndex, curListRow);
            this.getModel().setValue("measureunit", null, rowIndex, curListRow);
        }
    }

    private void changeList(Object propNewValue, Object propOldValue, int rowIndex, int curListRow) {
        IDataModel model = this.getModel();
        int amtPrecision = this.getPrecision(AMT_PRECISION);
        model.beginInit();
        if (propNewValue != null) {
            boolean result = this.validatorListing(((DynamicObject)propNewValue).getPkValue().toString());
            if (result) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u6e05\u5355\u6b63\u5728\u7ed3\u7b97\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ClaimTplEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ((DynamicObject)propNewValue).get("name")));
                if (propOldValue != null) {
                    model.setValue("listid", ((DynamicObject)propOldValue).getPkValue(), rowIndex, curListRow);
                    propNewValue = propOldValue;
                } else {
                    model.setValue("listid", null, rowIndex, curListRow);
                    return;
                }
            }
            DynamicObject conList = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)propNewValue).getPkValue(), (String)"pmct_contractlist");
            model.setValue("listnumber", (Object)conList.getString("number"), rowIndex, curListRow);
            model.setValue("listname", (Object)conList.getString("name"), rowIndex, curListRow);
            model.setValue("materiel", (Object)conList.getDynamicObject("material"), rowIndex, curListRow);
            model.setValue("measureunit", (Object)conList.getDynamicObject("measureunit"), rowIndex, curListRow);
            BigDecimal qty = conList.getBigDecimal("totalqty");
            model.setValue("qty", (Object)qty, rowIndex, curListRow);
            model.setValue("rateobj", (Object)conList.getDynamicObject("rateobj"), rowIndex, curListRow);
            BigDecimal taxRate = conList.getBigDecimal("taxrate");
            model.setValue("subtaxrate", (Object)taxRate, rowIndex, curListRow);
            BigDecimal curTaxPrice = conList.getBigDecimal("curtaxprice");
            model.setValue("oftaxprice", (Object)curTaxPrice, rowIndex, curListRow);
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            int pricePrecision = currency != null ? currency.getInt(PRICE_PRECISION) : 10;
            BigDecimal price = NumberHelper.divide((Object)curTaxPrice, (Object)BigDecimal.ONE.add(taxRate.divide(ONE_HUNDRED)), (int)pricePrecision, (RoundingMode)RoundingMode.HALF_UP);
            model.setValue("price", (Object)price, rowIndex, curListRow);
            BigDecimal ofTax = conList.getBigDecimal("lstoftaxamount");
            model.setValue("oftax", (Object)ofTax, rowIndex, curListRow);
            BigDecimal amount = (BigDecimal)conList.get("latestamount");
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
                amount = ofTax.divide(BigDecimal.ONE.add(taxRate.divide(ONE_HUNDRED)), amtPrecision, 4);
            }
            model.setValue("amount", (Object)amount, rowIndex, curListRow);
            model.setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
            BigDecimal settledCount = conList.getBigDecimal("lstsettleqty");
            model.setValue("settledcount", (Object)settledCount, rowIndex, curListRow);
            model.setValue("settledoftaxamount", conList.get("lstsettleoftaxamount"), rowIndex, curListRow);
            model.setValue("settledtaxamt", conList.get("lstsettletaxamt"), rowIndex, curListRow);
            String subClaimType = (String)model.getValue("subclaimtype", rowIndex, curListRow);
            if (ContractListClaimTypeEnum.PRICE_CHANGE.getValue().equals(subClaimType)) {
                model.setValue("beaffectedcount", (Object)qty.subtract(settledCount), rowIndex, curListRow);
            }
            model.setValue("sysnum", (Object)conList.getString("sysnumber"), rowIndex, curListRow);
        } else {
            this.cleanSubEntry(rowIndex, curListRow);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.summaryToCard(curListRow);
    }

    private boolean validatorListing(String listEntryId) {
        String contractSettleFromId;
        boolean result = false;
        String formBillId = this.getModel().getDataEntityType().getName();
        String string = contractSettleFromId = formBillId.equals("pmct_inclaimbill") ? "pmct_incontract_settle" : "pmct_outcontract_settle";
        if (StringUtils.isNotEmpty((CharSequence)listEntryId)) {
            DynamicObject listing = BusinessDataServiceHelper.loadSingle((Object)listEntryId, (String)"pmct_contractlist");
            String contractId = listing.getString("contractid");
            String listingModelId = listing.getString("listingmodel_id");
            QFilter contFilter = new QFilter("contract", "=", (Object)Long.parseLong(contractId)).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] contractSettles = BusinessDataServiceHelper.load((String)contractSettleFromId, (String)"id", (QFilter[])new QFilter[]{contFilter});
            if (null != contractSettles && contractSettles.length > 0) {
                for (DynamicObject contractSettle : contractSettles) {
                    boolean present;
                    DynamicObjectCollection listEntry;
                    DynamicObjectCollection listModelEntry = (contractSettle = BusinessDataServiceHelper.loadSingle((Object)contractSettle.getPkValue(), (String)contractSettleFromId)).getDynamicObjectCollection("listmodelentry");
                    DynamicObject modelEntry = listModelEntry.stream().filter(entry -> listingModelId.equals(entry.getString("listmodelid"))).findFirst().orElse(null);
                    if (null == modelEntry || null == (listEntry = modelEntry.getDynamicObjectCollection("listentry")) || listEntry.isEmpty() || !(present = listEntry.stream().anyMatch(entry -> listEntryId.equals(entry.getDynamicObject("listing").getPkValue().toString())))) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void cleanSubEntry(int rowIndex, int curListRow) {
        IDataModel model = this.getModel();
        model.setValue("listnumber", null, rowIndex, curListRow);
        model.setValue("listname", null, rowIndex, curListRow);
        model.setValue("materiel", null, rowIndex, curListRow);
        model.setValue("measureunit", null, rowIndex, curListRow);
        model.setValue("qty", null, rowIndex, curListRow);
        model.setValue("price", null, rowIndex, curListRow);
        model.setValue("amount", null, rowIndex, curListRow);
        model.setValue("rateobj", null, rowIndex, curListRow);
        model.setValue("subtaxrate", null, rowIndex, curListRow);
        model.setValue("tax", null, rowIndex, curListRow);
        model.setValue("oftaxprice", null, rowIndex, curListRow);
        model.setValue("oftax", null, rowIndex, curListRow);
        model.setValue("settledcount", null, rowIndex, curListRow);
        model.setValue("settledoftaxamount", null, rowIndex, curListRow);
        model.setValue("settledtaxamt", null, rowIndex, curListRow);
        model.setValue("beaffectedcount", null, rowIndex, curListRow);
        model.setValue("changecount", null, rowIndex, curListRow);
        model.setValue("thisafteroftaxamount", null, rowIndex, curListRow);
        model.setValue("subafteroftaxamount", null, rowIndex, curListRow);
        model.setValue("remark", null, rowIndex, curListRow);
        model.setValue("sysnum", null, rowIndex, curListRow);
    }

    private void changeSubClaimType(Object propNewValue, int rowIndex, int curListRow) {
        IDataModel model = this.getModel();
        this.cleanSubEntry(rowIndex, curListRow);
        model.setValue("listid", null, rowIndex, curListRow);
        Boolean isMultiRate = (Boolean)model.getValue("ismultirate");
        if (ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(propNewValue) && !isMultiRate.booleanValue()) {
            DynamicObject rateObj;
            DynamicObject contract = (DynamicObject)model.getValue("contract");
            if (contract != null && (rateObj = contract.getDynamicObject("lsttaxrate")) != null) {
                rateObj = BusinessDataServiceHelper.loadSingle((Object)rateObj.getPkValue(), (String)"bd_taxrate");
                model.setValue("rateobj", (Object)rateObj, rowIndex, curListRow);
                model.setValue("subtaxrate", (Object)rateObj.getBigDecimal("taxrate"), rowIndex, curListRow);
            }
        } else {
            model.setValue("rateobj", null, rowIndex, curListRow);
            model.setValue("subtaxrate", null, rowIndex, curListRow);
        }
        if (ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue().equals(propNewValue) || ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(propNewValue)) {
            ORM orm = ORM.create();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contractlist");
            long genLongId = orm.genLongId((IDataEntityType)dt);
            model.setValue("newlistingid", (Object)genLongId, rowIndex, curListRow);
            model.setValue("sysnum", null, rowIndex, curListRow);
            String sysNum = this.genSysNumber(propNewValue.toString());
            model.setValue("sysnum", (Object)sysNum, rowIndex, curListRow);
        } else {
            model.setValue("sysnum", null, rowIndex, curListRow);
        }
    }

    private String genSysNumber(String type) {
        String sysNum = null;
        if (StringUtils.equals((CharSequence)type, (CharSequence)ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue()) || StringUtils.equals((CharSequence)type, (CharSequence)ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue())) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subclaimtype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue()) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue())) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("kapianentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", (Object)0);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            sysNum = ContractListHelper.genSysNumberRule((DynamicObject[])listings, excludeSysNum);
        }
        return sysNum;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.equals("superlistingname")) {
            this.showSuperListingList();
        }
    }

    private void showSuperListingList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)LISTINGFORMID, (boolean)true, (int)3, (boolean)true);
        List qFilters = lsp.getListFilterParameter().getQFilters();
        this.addContractAndListModelFilter(qFilters);
        lsp.setBillFormId(LISTINGFORMID);
        lsp.setMultiSelect(false);
        ArrayList<DynamicObject> listingList = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)LISTINGFORMID);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry;
            if (i == rowIndex || !StringUtils.equals((CharSequence)"3", (CharSequence)(entry = (DynamicObject)entryEntity.get(i)).getString("subclaimtype"))) continue;
            DynamicObject listing = new DynamicObject((DynamicObjectType)dt);
            listing.set("id", entry.get("newlistingid"));
            listing.set("parent_id", entry.get("superlistingid"));
            listing.set("number", entry.get("listnumber"));
            listing.set("name", entry.get("listname"));
            listing.set("desc", entry.get("remark"));
            DynamicObject material = entry.getDynamicObject("materiel");
            if (material != null) {
                listing.set("material", (Object)material);
            }
            listingList.add(listing);
        }
        qFilters.add(new QFilter("isleaf", "=", (Object)DefaultEnum.NO.getValue()));
        lsp.setCustomParam("addlisting", (Object)DynamicObjectSerializeUtil.serialize((Object[])listingList.toArray(new DynamicObject[listingList.size()]), (DynamicObjectType)dt));
        int index = this.getModel().getEntryCurrentRowIndex("kapianentry");
        Object listModelId = this.getModel().getValue("listmodelid", index);
        lsp.setCustomParam("listmodelid", listModelId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "superlistingcallback");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void addContractAndListModelFilter(List<QFilter> qFilters) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("kapianentry");
        Object listModelId = this.getModel().getValue("listmodelid", rowIndex);
        qFilters.add(new QFilter("listingmodel", "=", listModelId));
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            qFilters.add(new QFilter("contractid", "=", (Object)contract.getPkValue().toString()));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforef7selectevent) {
        String name = beforef7selectevent.getProperty().getName();
        if (name.equals("listid")) {
            this.beforeListingSelect(beforef7selectevent);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (DELETE_ENTRY.equals(operateKey)) {
            this.summaryToCard(Integer.parseInt(this.getPageCache().get(CUR_LIST_ROW)));
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)operateKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object budgetitem = this.getModel().getValue("budgetitem");
            if (budgetitem != null) {
                this.getModel().setValue("listingbudgetitem", ((DynamicObject)budgetitem).getPkValue(), rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"listingbudgetitem"});
            }
        }
    }

    private void beforeListingSelect(BeforeF7SelectEvent beforef7selectevent) {
        ListShowParameter lsp = (ListShowParameter)beforef7selectevent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        this.addContractAndListModelFilter(qFilters);
        ArrayList<Object> selectedListId = new ArrayList<Object>(10);
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntities) {
            if (entry.getDynamicObject("listid") == null) continue;
            selectedListId.add(entry.getDynamicObject("listid").getPkValue());
        }
        QFilter selectedFilter = new QFilter("id", "not in", selectedListId);
        qFilters.add(selectedFilter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("superlistingcallback".equals(actionId) && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !returnData.isEmpty()) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object pkValue = returnData.get(0).getPrimaryKeyValue();
            this.getModel().setValue("superlistingid", pkValue, rowIndex);
            boolean isExist = QueryServiceHelper.exists((String)LISTINGFORMID, (Object)pkValue);
            String sysNum = null;
            if (isExist) {
                sysNum = this.genSysNum(pkValue, isExist);
                this.getModel().setValue("sysnum", (Object)sysNum, rowIndex);
                this.getModel().setValue("parentlisting", pkValue, rowIndex);
                DynamicObject listModel = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)LISTINGFORMID);
                this.getModel().setValue("superlistingname", (Object)listModel.getLocaleString("name"), rowIndex);
            } else {
                this.getModel().setValue("parentlisting", null, rowIndex);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    long newListingId = ((DynamicObject)entryEntity.get(i)).getLong("newlistingid");
                    if (newListingId != Long.parseLong(pkValue.toString())) continue;
                    this.getModel().setValue("superlistingname", (Object)((DynamicObject)entryEntity.get(i)).getString("listname"), rowIndex);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"subclaimtype"});
                }
                sysNum = this.genSysNum(pkValue, isExist);
                this.getModel().setValue("sysnum", (Object)sysNum, rowIndex);
            }
        }
    }

    public String genSysNum(Object pkValue, boolean isExist) {
        int count = 0;
        String sysNum = null;
        if (isExist) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subclaimtype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue()) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue())) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("kapianentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", pkValue);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            DynamicObject parentListing = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_contractlist");
            String parentSysNum = parentListing.getString("sysnumber");
            sysNum = String.format("%s.%03d", parentSysNum, ++count);
            if (listings.length > 0) {
                for (DynamicObject listing : listings) {
                    String curSysNum = listing.getString("sysnumber");
                    while (StringUtils.equals((CharSequence)curSysNum, (CharSequence)sysNum)) {
                        sysNum = String.format("%s.%03d", parentSysNum, ++count);
                    }
                }
            }
            while (excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%s.%03d", parentSysNum, ++count);
            }
        } else {
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            String parentSysNum = null;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entryEntity) {
                long superListingId;
                long listingId = entry.getLong("newlistingid");
                if (listingId == Long.parseLong(pkValue.toString())) {
                    parentSysNum = entry.getString("sysnum");
                    sysNum = String.format("%s.%03d", parentSysNum, ++count);
                }
                if ((superListingId = entry.getLong("superlistingid")) != Long.parseLong(pkValue.toString())) continue;
                String entrySysNum = entry.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            while (sysNum != null && excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%s.%03d", parentSysNum, ++count);
            }
        }
        return sysNum;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"kapianentry", (CharSequence)control.getKey())) {
            int curListRow = evt.getRow();
            this.getPageCache().put(CUR_LIST_ROW, String.valueOf(curListRow));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("unaudit")) {
            DynamicObject contractf7 = this.getModel().getDataEntity().getDynamicObject("contract");
            contractf7 = BusinessDataServiceHelper.loadSingle((Object)contractf7.getPkValue(), (String)"pmct_contracttpl");
            DynamicObject contStatus = contractf7.getDynamicObject("contractstatus");
            List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            if (statusNums.contains(contStatus.getString("number"))) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ClaimTplEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean isOutContract() {
        String payDirection = this.getModel().getDataEntity().getString("paydirection");
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue());
    }

    private int getPrecision(String precision) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (StringUtils.equals((CharSequence)precision, (CharSequence)AMT_PRECISION)) {
            if (currency == null || currency.getInt(AMT_PRECISION) == 0) {
                return 2;
            }
            return currency.getInt(AMT_PRECISION);
        }
        if (currency == null || currency.getInt(PRICE_PRECISION) == 0) {
            return 4;
        }
        return currency.getInt(PRICE_PRECISION);
    }
}

