/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contclaim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.enums.contractlist.ContractListClaimTypeEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class InContractClaimBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    public static final String DELETEINCOMEPLAN = "deleteincomeplan";
    public static final String SAVE = "save";
    public static final String SUBMIT = "submit";
    public static final String UNAUDIT = "unaudit";
    public static final String PARAMETER_SOURCE_ID = "sourceid";
    public static final String PARAMETER_CONTRACT_ID = "contractid";
    public static final String PARAMETER_CHANGE_TYPE = "changetype";
    public static final String PARAMETER_FORM_ID = "formId";
    public static final String PARAMETER_CUSTOM_ENTRY_DATA = "entrydata";
    protected static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    protected static final String CALCULATE_RATIO = "calculateratio";
    protected static final String CALCULATE_AMOUNT = "calculateamount";
    protected static final String CLAIM_INCOME_PLAN = "claimincomeplan";
    protected static final String VIEWCOMPARE = "viewcompare";
    private static final String CONTRACT = "contract";
    private static final String IS_CLOSEDCALLBACK_CONTRACT = "isContractClosedCallBack";
    private static final String CTRL_ADDINCOMEPLAN = "addincomeplan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl(CONTRACT);
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("listingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
        ContractHelper.showIncomePlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_INCOME_PLAN, (String)"claimincomeplanentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "addincomeplan": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("claimincomeplanentry");
                int rowIndex = entrys.size() - 1;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        DynamicObjectCollection planEntrys = this.getModel().getEntryEntity("claimincomeplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])planEntrys.toArray((Object[])new DynamicObject[planEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject planEntry : planEntrys) {
            DynamicObject nodeSetting = planEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            planEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long incomeItemId = planEntry.getLong("conplanitemid");
            if (0L == incomeItemId || QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)incomeItemId)) continue;
            planEntry.set("conplanitemid", null);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Date date = new Date();
        this.getModel().setValue("reqdate", (Object)date);
        this.getModel().setValue("replydate", (Object)date);
        DynamicObject payItem = BusinessDataServiceHelper.loadSingle((Object)849909148731577344L, (String)"pmct_payitem");
        this.getModel().setValue("contpayitem", (Object)payItem);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    private void onChangeContract() {
        this.getModel().setValue("claimoftaxamount", null);
        this.getModel().setValue("taxamount", null);
        this.getModel().setValue("claimamount", null);
        DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
        if (contract == null) {
            this.getModel().setValue("taxrate", null);
            this.getModel().setValue("avgtaxrate", null);
            this.getModel().setValue("budgetitem", null);
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.get("id").toString()), (String)"pmct_incontract");
        this.getModel().setValue("org", contract.getDynamicObject("org").getPkValue(), 0);
        DynamicObject project = contract.getDynamicObject("project");
        if (project != null) {
            this.getModel().setValue("project", project.getPkValue(), 0);
        } else {
            this.getModel().setValue("project", null);
        }
        DynamicObject budgetitem = contract.getDynamicObject("budgetitem");
        if (project != null && budgetitem != null) {
            this.getModel().setValue("budgetitem", contract.getDynamicObject("budgetitem").getPkValue());
        }
        boolean isMultiRate = contract.getBoolean("ismultirate");
        this.getModel().setValue("ismultirate", (Object)isMultiRate);
        if (contract.getBoolean("ismultirate")) {
            BigDecimal lstAvgTaxRate = contract.getBigDecimal("lstavgtaxrate");
            if (lstAvgTaxRate != null && lstAvgTaxRate.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("avgtaxrate", (Object)lstAvgTaxRate);
            } else {
                this.getModel().setValue("avgtaxrate", (Object)contract.getBigDecimal("avgtaxrate"));
            }
            this.getModel().setValue("taxrate", null);
        } else {
            this.getModel().setValue("avgtaxrate", null);
            DynamicObject taxRate = contract.getDynamicObject("lsttaxrate");
            if (taxRate != null) {
                this.getModel().setValue("taxrate", taxRate.getPkValue());
            } else {
                taxRate = contract.getDynamicObject("taxrate");
                if (taxRate != null) {
                    this.getModel().setValue("taxrate", taxRate.getPkValue());
                }
            }
        }
        DynamicObjectCollection payPlanEntry = this.getModel().getEntryEntity("claimincomeplanentry");
        for (int i = 0; i < payPlanEntry.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)payPlanEntry.get(i);
            if (null != entryEntity.get("nodesetting")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "project": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
                if (contract == null || newValue == null || newValue.equals(contract.getDynamicObject("project"))) break;
                this.getModel().setValue(CONTRACT, null);
                break;
            }
            case "contract": {
                if (!this.checkContractMutex(e)) {
                    return;
                }
                ContractHelper.showContractList((IFormView)this.getView());
                ContractHelper.initListCardEntry((IFormView)this.getView(), (String)"kapianentry", (DynamicObject)((DynamicObject)newValue));
                ContractHelper.loadIncomePlanEntry((IFormView)this.getView(), (DynamicObject)((DynamicObject)newValue), (String)CLAIM_INCOME_PLAN);
                this.onChangeContract();
                break;
            }
            case "incomepercent": {
                this.changePayPercent(rowIndex);
                break;
            }
            case "incomeamountoftax": {
                this.changePayAmountOfTax(rowIndex);
                break;
            }
            case "isneedsettle": {
                this.changeIsNeedSettle();
                break;
            }
            case "subclaimtype": {
                this.changeSubClaimType(rowIndex);
                break;
            }
            case "nodesetting": {
                this.nodeSettingChange(rowIndex, newValue, oldValue);
                break;
            }
            case "ctrlstrategy": {
                this.ctrlStrategyChange(rowIndex, newValue, oldValue);
                break;
            }
        }
    }

    protected void nodeSettingChange(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("claimincomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        Long incomeItemNodeId = null;
        if (null != incomeItem && null != incomeItem.getDynamicObject("nodesetting")) {
            incomeItemNodeId = incomeItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != incomeItemNodeId && ((DynamicObject)oldValue).getLong("id") == incomeItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContractClaimBillPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String incomeItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("claimincomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        String string = incomeItemStrategy = null == incomeItem ? null : incomeItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && incomeItemStrategy != null && incomeItemStrategy.equals(oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContractClaimBillPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    protected void changeIsNeedSettle() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
        ContractHelper.showIncomePlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_INCOME_PLAN, (String)"claimincomeplanentry");
        ContractHelper.loadIncomePlanEntry((IFormView)this.getView(), (DynamicObject)contract, (String)CLAIM_INCOME_PLAN);
        ContractHelper.initListCardEntry((IFormView)this.getView(), (String)"kapianentry", (DynamicObject)contract);
        this.getView().updateView();
        this.getModel().setValue("claimoftaxamount", null);
        this.getModel().setValue("taxamount", null);
        this.getModel().setValue("claimamount", null);
    }

    protected void changePayAmountOfTax(int rowIndex) {
        this.getModel().beginInit();
        BigDecimal payAmountOfTax = (BigDecimal)this.getModel().getValue("incomeamountoftax", rowIndex);
        BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int amtPrecision = currency == null ? 2 : currency.getInt("amtprecision");
        this.getModel().setValue("incomepercent", (Object)payAmountOfTax.multiply(ONE_HUNDRED).divide(afterOfTaxAmount, amtPrecision, 4));
        this.getModel().endInit();
        this.getView().updateView("incomepercent", rowIndex);
    }

    protected void changePayPercent(int rowIndex) {
        this.getModel().beginInit();
        BigDecimal payPercent = ((BigDecimal)this.getModel().getValue("incomepercent", rowIndex)).divide(ONE_HUNDRED);
        BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
        this.getModel().setValue("incomeamountoftax", (Object)afterOfTaxAmount.multiply(payPercent));
        this.getModel().endInit();
        this.getView().updateView("incomeamountoftax", rowIndex);
    }

    private boolean checkContractMutex(PropertyChangedArgs e) {
        DynamicObject newContract = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newContract == null) {
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"C");
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        QFilter contractFilter = new QFilter(CONTRACT, "=", newContract.getPkValue());
        QFilter unContainFilter = new QFilter("id", "!=", (Object)Long.parseLong(dataEntity.getPkValue().toString()));
        DynamicObject[] inClaims = BusinessDataServiceHelper.load((String)"pmct_inclaimbill", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, isNeedSettleFilter, contractFilter, unContainFilter});
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] inContractRevisions = BusinessDataServiceHelper.load((String)"pmct_incontractrevision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        DynamicObject[] inContAddAgreements = BusinessDataServiceHelper.load((String)"pmct_inaddagreement", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter, unContainFilter});
        if (inClaims.length > 0) {
            DynamicObject inClaim = inClaims[0];
            this.getPageCache().put("inClaimId", inClaim.getPkValue().toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\u3002\u662f\u5426\u8df3\u8f6c\u5230\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\u8fdb\u884c\u5904\u7406\uff1f", (String)"InContractClaimBillPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_CLOSEDCALLBACK_CONTRACT, (IFormPlugin)this));
            this.getModel().setValue(CONTRACT, null);
            return false;
        }
        if (contractRevisions.length > 0) {
            this.getModel().setValue(CONTRACT, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4fee\u8ba2\u5355\uff0c\u8bf7\u5f85\u4fee\u8ba2\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractClaimBillPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (inContractRevisions.length > 0) {
            this.getModel().setValue(CONTRACT, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractClaimBillPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (inContAddAgreements.length > 0) {
            this.getModel().setValue(CONTRACT, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u7d22\u8d54\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\uff0c\u8bf7\u5f85\u8865\u5145\u534f\u8bae\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"InContractClaimBillPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "showclaimrecords": {
                DynamicObject obj = (DynamicObject)this.getModel().getValue(CONTRACT);
                if (obj == null) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractClaimBillPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String billFormId = this.getView().getFormShowParameter().getFormId();
                ListShowParameter parameter = new ListShowParameter();
                parameter.getListFilterParameter().setFilter(new QFilter("contract.id", "=", obj.get("id")));
                parameter.getListFilterParameter().setFilter(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                parameter.setLookUp(true);
                parameter.setMultiSelect(false);
                parameter.setFormId("bos_listf7");
                parameter.setBillFormId(billFormId);
                StyleCss css = new StyleCss();
                css.setWidth("1068");
                css.setHeight("648");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setShowTitle(false);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "calculateratio": {
                this.doCalculateRatio();
                break;
            }
            case "calculateamount": {
                this.doCalculateAmount();
                break;
            }
            case "deleteincomeplan": {
                this.checkDeleteIncomePlan(args);
                break;
            }
            case "viewcompare": {
                this.viewCompare();
                break;
            }
            case "submit": {
                ContractEditHelper.setCheckParameter((BeforeDoOperationEventArgs)args, (String)"pmct_inclaimbill", (String)CLAIM_INCOME_PLAN);
                break;
            }
            case "addincomeplan": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
                if (contract != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractClaimBillPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    protected void checkDeleteIncomePlan(BeforeDoOperationEventArgs args) {
        EntryGrid claimIncomePlanEntry = (EntryGrid)this.getControl("claimincomeplanentry");
        int[] selectRows = claimIncomePlanEntry.getSelectRows();
        for (int index = 0; index < selectRows.length; ++index) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("claimincomeplanentry", selectRows[index]);
            String conIncomeItemId = entryRowEntity.getString("conplanitemid");
            if (!StringUtils.isNotBlank((CharSequence)conIncomeItemId)) continue;
            DynamicObject conPayItemObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(conIncomeItemId), (String)"pmbs_contractcollectitem");
            BigDecimal collectedComAmt = conPayItemObj.getBigDecimal("collectedcomamt");
            if (collectedComAmt == null || collectedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u6536\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractClaimBillPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String payItemName = conPayItemObj.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{conPayItemObj.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractClaimBillPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = conPayItemObj.getBigDecimal("appliedcomamt");
            if (NumberHelper.isNullZero((BigDecimal)appliedComAmt)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u8bf7\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractClaimBillPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected void viewCompare() {
        if (this.getModel().getValue(CONTRACT) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractClaimBillPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAMETER_SOURCE_ID, this.getModel().getDataEntity().getPkValue());
        param.put(PARAMETER_CONTRACT_ID, ((DynamicObject)this.getModel().getValue(CONTRACT)).getPkValue());
        param.put(PARAMETER_CHANGE_TYPE, PayPlanSourceEnum.CLAIM.getValue());
        param.put(PARAMETER_FORM_ID, "pmct_inclaimbill");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_inclaimbill")).getDynamicObjectCollection("claimincomeplanentry").getDynamicObjectType();
        DynamicObjectCollection incomePlanEntry = this.getModel().getEntryEntity("claimincomeplanentry");
        param.put(PARAMETER_CUSTOM_ENTRY_DATA, DynamicObjectSerializeUtil.serialize((Object[])incomePlanEntry.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_incomeplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void doCalculateAmount() {
        DynamicObjectCollection claimIncomePlanEntry = this.getModel().getEntryEntity("claimincomeplanentry");
        if (!claimIncomePlanEntry.isEmpty()) {
            BigDecimal afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount");
            for (DynamicObject claimIncomePlanEntryObj : claimIncomePlanEntry) {
                BigDecimal payPercent = claimIncomePlanEntryObj.getBigDecimal("incomepercent");
                BigDecimal payAmountOfTax = afterOfTaxAmount.multiply(payPercent.divide(BigDecimal.valueOf(100L)));
                claimIncomePlanEntryObj.set("incomeamountoftax", (Object)payAmountOfTax);
                int index = claimIncomePlanEntry.indexOf((Object)claimIncomePlanEntryObj);
                this.getView().updateView("incomeamountoftax", index);
            }
        }
    }

    protected void doCalculateRatio() {
        BigDecimal afterOfTaxAmount;
        DynamicObjectCollection claimIncomePlanEntry = this.getModel().getEntryEntity("claimincomeplanentry");
        if (!claimIncomePlanEntry.isEmpty() && (afterOfTaxAmount = (BigDecimal)this.getModel().getValue("afteroftaxamount")) != null && afterOfTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
            for (DynamicObject claimIncomePlanEntryObj : claimIncomePlanEntry) {
                BigDecimal payAmountOfTax = claimIncomePlanEntryObj.getBigDecimal("incomeamountoftax");
                BigDecimal ratio = payAmountOfTax.divide(afterOfTaxAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
                claimIncomePlanEntryObj.set("incomepercent", (Object)ratio);
                int index = claimIncomePlanEntry.indexOf((Object)claimIncomePlanEntryObj);
                this.getView().updateView("incomepercent", index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "contract": {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ContractHelper.getContractByStatus((String)"pmct_inclaimbill", (ListShowParameter)showParameter, (String)PayDirectionEnum.IN.getValue());
                break;
            }
            case "budgetitem": 
            case "listingbudgetitem": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
                QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilter(contract);
                if (idFilter == null) {
                    return;
                }
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "nodesetting": {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                this.beforeSelectNodeSetting(param);
                break;
            }
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param) {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"003");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callId = e.getCallBackId();
        int result = e.getResult().getValue();
        switch (callId) {
            case "isContractClosedCallBack": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    String inClaimId = this.getPageCache().get("inClaimId");
                    this.getPageCache().remove("inClaimId");
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setPkId((Object)Long.parseLong(inClaimId));
                    billShowParameter.setFormId("pmct_inclaimbill");
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)billShowParameter);
                    break;
                }
                this.getPageCache().remove("inClaimId");
                break;
            }
            case "nodesetting": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "ctrlstrategy": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
            }
        }
    }

    @Deprecated
    protected void updateBudgetViewByProject() {
    }

    private void changeSubClaimType(int rowIndex) {
        String subClaimType = this.getModel().getValue("subclaimtype", rowIndex).toString();
        DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem");
        if (ContractListClaimTypeEnum.NEW_DETAIL_LIST.getValue().equals(subClaimType) || ContractListClaimTypeEnum.NEW_NON_DETAIL_LIST.getValue().equals(subClaimType)) {
            this.getModel().setValue("listingbudgetitem", (Object)budgetItem, rowIndex);
        } else {
            this.getModel().setValue("listingbudgetitem", null, rowIndex);
        }
    }
}

