/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contclarific;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class InClarificBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getModel().getValue("clarificdate") == null) {
            this.getModel().setValue("clarificdate", (Object)new Date());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject contract;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"peoplef7", (CharSequence)key)) {
            ChangeData[] datas = e.getChangeSet();
            if (datas.length == 1) {
                ChangeData data = datas[0];
                DynamicObject newValue = (DynamicObject)data.getNewValue();
                this.setPeopleData(newValue);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"contract", (CharSequence)key) && (contract = (DynamicObject)this.getModel().getValue("contract")) != null) {
            DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            if (singleContract.getDynamicObject("project") != null) {
                this.getModel().setValue("project", singleContract.getDynamicObject("project").getPkValue());
            } else {
                this.getModel().setValue("project", null);
            }
        }
    }

    private void setPeopleData(DynamicObject obj) {
        IDataModel model = this.getModel();
        int curRowInd = model.getEntryCurrentRowIndex("entryentity");
        if (obj == null) {
            this.getModel().setValue("people", null, curRowInd);
            this.getModel().setValue("department", null, curRowInd);
            this.getModel().setValue("position", null, curRowInd);
            this.getModel().setValue("phone", null, curRowInd);
        } else {
            DynamicObjectCollection doc = (DynamicObjectCollection)obj.get("entryentity");
            Object position = null;
            DynamicObject dpt = null;
            if (doc.size() >= 1) {
                DynamicObject row = (DynamicObject)doc.get(0);
                position = row.get("position");
                dpt = row.getDynamicObject("dpt");
            }
            this.getModel().setValue("people", obj.get("name"), curRowInd);
            this.getModel().setValue("department", dpt != null ? dpt.getPkValue() : null, curRowInd);
            this.getModel().setValue("position", position, curRowInd);
            this.getModel().setValue("phone", obj.get("phone"), curRowInd);
        }
        model.setEntryCurrentRowIndex("entryentity", curRowInd);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contractEdit = (BasedataEdit)this.getView().getControl("contract");
        contractEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String key = arg0.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"contract", (CharSequence)key)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_inclarificbill", (ListShowParameter)showParameter, (String)PayDirectionEnum.IN.getValue());
        }
    }
}

