/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.contpref;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.business.helper.PerformHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;
import kd.pmgt.pmct.common.enums.DirectionEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class OutContractPerformBillPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject project;
        DynamicObject contract;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object propValue = valueSet[0].getNewValue();
        boolean amtChangeFlag = false;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal noTaxAmount = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"contract")) {
            this.getModel().deleteEntryData("entryentity");
            contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                if (singleContract.getDynamicObject("project") != null) {
                    this.getModel().setValue("project", singleContract.getDynamicObject("project").getPkValue());
                } else {
                    this.getModel().setValue("project", null);
                }
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"isneedsettle")) {
            boolean isneedsettle = (Boolean)this.getModel().getValue("isneedsettle");
            if (isneedsettle) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"contpayitem"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"contpayitem"});
                this.getModel().setValue("contpayitem", null, rowIndex);
                this.getModel().setValue("budgetitem", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"amount")) {
            DynamicObject object;
            DynamicObject contract2;
            amtChangeFlag = true;
            amount = (BigDecimal)propValue;
            tax = (BigDecimal)this.getModel().getValue("tax", rowIndex);
            noTaxAmount = amount.subtract(tax);
            if (BigDecimal.ZERO.compareTo(amount) != 0 && this.getModel().getValue("budgetitem", rowIndex) == null && (contract2 = BusinessDataServiceHelper.loadSingle((Object)(object = (DynamicObject)this.getModel().getValue("contract")).getPkValue(), (String)"pmct_outcontract")) != null && contract2.getDynamicObject("budgetitem") != null) {
                this.getModel().setValue("budgetitem", contract2.getDynamicObject("budgetitem").getPkValue(), rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"notaxamount")) {
            amtChangeFlag = true;
            noTaxAmount = (BigDecimal)propValue;
            tax = (BigDecimal)this.getModel().getValue("tax", rowIndex);
            amount = noTaxAmount.add(tax);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"tax")) {
            amtChangeFlag = true;
            tax = (BigDecimal)propValue;
            noTaxAmount = (BigDecimal)this.getModel().getValue("notaxamount", rowIndex);
            amount = tax.add(noTaxAmount);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"project") && (contract = (DynamicObject)this.getModel().getValue("contract")) != null && ((project = contract.getDynamicObject("project")) == null || propValue == null || !((DynamicObject)propValue).getPkValue().equals(project.getPkValue()))) {
            this.getModel().setValue("contract", null);
        }
        if (amtChangeFlag) {
            this.getModel().beginInit();
            this.getModel().setValue("amount", (Object)amount, rowIndex);
            this.getModel().setValue("notaxamount", (Object)noTaxAmount, rowIndex);
            this.getModel().setValue("tax", (Object)tax, rowIndex);
            boolean ismulticurrency = (Boolean)this.getModel().getValue("ismulticurrency");
            if (ismulticurrency) {
                BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
                BigDecimal stdamount = amount.multiply(exchangerate);
                BigDecimal stdnoTaxAmount = noTaxAmount.multiply(exchangerate);
                BigDecimal stdtax = tax.multiply(exchangerate);
                this.getModel().setValue("stdamount", (Object)stdamount, rowIndex);
                this.getModel().setValue("stdnotaxamount", (Object)stdnoTaxAmount, rowIndex);
                this.getModel().setValue("stdtax", (Object)stdtax, rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("amount", rowIndex);
            this.getView().updateView("notaxamount", rowIndex);
            this.getView().updateView("tax", rowIndex);
            if (ismulticurrency) {
                this.getView().updateView("stdamount", rowIndex);
                this.getView().updateView("stdnotaxamount", rowIndex);
                this.getView().updateView("stdtax", rowIndex);
            }
        }
        IFormView view = this.getView();
        PerformHelper.setTotalData((IFormView)view);
    }

    private boolean checkIsProjectCostControl() {
        DynamicObject[] proApp;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        boolean projectCostControlFlag = false;
        if (project != null && (proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null && proApp.length > 0) {
            projectCostControlFlag = proApp[0].getBoolean("projectcostcontrol");
        }
        return projectCostControlFlag;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contpayitem = (BasedataEdit)this.getControl("contpayitem");
        contpayitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contract = (BasedataEdit)this.getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetitem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpayitem")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContractPerformBillPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject contracttype = contract.getDynamicObject("contracttype");
            if (null != contracttype) {
                QFilter filter4 = this.getContTypeIdQFilter(contracttype);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter4);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contract")) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_outperformrecords", (ListShowParameter)parameter, (String)PayDirectionEnum.OUT.getValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"budgetitem", (CharSequence)propertyName)) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilter(contract);
            if (idFilter == null) {
                return;
            }
            parameter.getListFilterParameter().getQFilters().add(idFilter);
        }
    }

    protected QFilter getContTypeIdQFilter(DynamicObject contracttype) {
        QFilter ispreitem = new QFilter("ispreitem", "!=", (Object)Boolean.TRUE);
        QFilter direction = new QFilter("direction", "!=", (Object)DirectionEnum.NON.getValue());
        QFilter iscompute = new QFilter("iscompute", "!=", (Object)Boolean.TRUE);
        QFilter filter1 = ispreitem.and(direction).and(iscompute);
        QFilter filter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter typeQFilter = new QFilter("contracttype.fbasedataid", "in", Collections.singletonList(contracttype.getPkValue())).or("contracttype.fbasedataid", "=", null);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pmct_payitem", (String)"id", (QFilter[])new QFilter[]{typeQFilter, filter1, filter3});
        return new QFilter("id", "in", collection.stream().map(obj -> obj.get("id")).collect(Collectors.toSet()));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getModel().getValue("bizdate") == null) {
            this.getModel().setValue("bizdate", (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        PerformHelper.setTotalData((IFormView)view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"insertentry", (CharSequence)operateKey)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"OutContractPerformBillPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            ArrayList<Integer> indexList = new ArrayList<Integer>(10);
            ArrayList<Integer> budgetItemIndexList = new ArrayList<Integer>(10);
            boolean isProjectCostControlFlag = this.checkIsProjectCostControl();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject budgetItem;
                boolean isneedsettle = (Boolean)this.getModel().getValue("isneedsettle", i);
                DynamicObject contpayitem = (DynamicObject)this.getModel().getValue("contpayitem", i);
                if (isneedsettle && contpayitem == null) {
                    indexList.add(i + 1);
                }
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                boolean isOpenedContract = contract.getBoolean("openedcontract");
                if (!isneedsettle || !isProjectCostControlFlag || isOpenedContract || multiPartSettlement || (budgetItem = (DynamicObject)this.getModel().getValue("budgetitem", i)) != null) continue;
                budgetItemIndexList.add(i + 1);
            }
            boolean isStop = false;
            if (indexList.size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u8bb0\u5f55\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u52fe\u9009\u201c\u9700\u8981\u72ec\u7acb\u7ed3\u7b97\u201d\uff0c\u8bf7\u9009\u62e9\u5408\u540c\u652f\u4ed8\u9879\u3002", (String)"OutContractPerformBillPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ((Object)indexList).toString()));
                isStop = true;
            }
            if (budgetItemIndexList.size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u8bb0\u5f55\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u52fe\u9009\u201c\u9700\u8981\u72ec\u7acb\u7ed3\u7b97\u201d\uff0c\u8bf7\u9009\u62e9\u9879\u76ee\u9884\u7b97\u9879\u3002", (String)"OutContractPerformBillPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), ((Object)budgetItemIndexList).toString()));
                isStop = true;
            }
            if (isStop) {
                args.setCancel(true);
            }
        }
    }
}

