/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctConvertPlugin;

public class IncomeApplyToIncomeRegisterConvertPlugin
extends AbstractPmctConvertPlugin {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet extendedDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtTypeName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = extendedDataEntitySet.FindByEntityKey(tgtTypeName)) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject period = dataEntity.getDynamicObject("period");
            DynamicObjectCollection contractEntries = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : contractEntries) {
                BigDecimal totalApplyOfTaxAmount;
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                DynamicObject contract = entry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = entry.getDynamicObject("contpro");
                BigDecimal thisPaymentOfTaxAmount = entry.getBigDecimal("receiptoftaxamount");
                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, null);
                    totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryContPro, contract, period);
                    totalApplyOfTaxAmount = multiSettleAmtService.getMultiIncomeApplyAmount(org, entryContPro, contract, period);
                } else {
                    InComeUtils inComeUtils = new InComeUtils();
                    totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
                    totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
                    totalApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, null);
                }
                entry.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                entry.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                entry.set("preapplyoftaxamtsum", (Object)totalApplyOfTaxAmount);
                entry.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("startreceiptrate", (Object)totalRealOfTaxAmount.divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)));
                }
                entry.set("receipttaxamount", (Object)thisPaymentOfTaxAmount.subtract(entry.getBigDecimal("receiptamount")));
            }
        }
    }
}

