/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.path.FilePathFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.common.utils.ContractOfficeUtil;

public class ContractDocBillDesignPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ContractDocBillDesignPlugin.class);
    private static final String WEBOFFICEAP = "webofficeap";
    private static final String TEMPDOCURL = "tempdocurl";
    private static final String TEMPDOCNAME = "tempdocname";
    private static final String CONTDOCURL = "contdocurl";
    private static final String CONTDOCNAME = "contdocname";
    private static final String CONTTEMPID = "conttempid";
    private static final String BILLID = "contractId";
    private static final String FILENAME = "filename";
    private static final String FILEPATH = "filepath";
    private static final String URL = "url";
    private static final String FORMID_CONTTEMPLATE = "pmct_conttemplate";
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String FBILLTYPE = "FBillType";
    private static final String FMODIFYTIME = "FModifyTime";
    private static final String FATTACHMENTNAME = "FAttachmentName";
    private static final String FINTERID = "FInterID";
    private static final String FCREATETIME = "fcreatetime";
    private static final String FALIASFILENAME = "FaliasFileName";
    private static final String FEXTNAME = "FExtName";
    private static final String FATTACHMENTSIZE = "FATTACHMENTSIZE";
    private static final String FCREATEMEN = "FCREATEMEN";
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private static final String FDESCRIPTION = "fdescription";
    private static final String FFILEID = "FFileId";
    private static final String FILESOURCE = "filesource";
    private static final String NEW = "new";
    private static final int WEBOFFICE_GEN = 100;
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String TEXT_ATTACHMENTPANEL = "textattachmentpanel";
    private static final String OPREATE_ONLINE_SAVE = "onlinesave";
    private static final String OPREATE_GENERATE_ATTACHMENTS = "generateattachments";
    private static final String OPREATE_SWITCH_TPL = "switchtpl";
    public static final String LIKE_PMGT_CONTBILLDOC = "%pmgt_contbilldoc%";
    private static final String VERSION = "version";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        Object contTempId = paramMap.get(CONTTEMPID);
        Object billId = paramMap.get("contract");
        Object contDocBillId = paramMap.get("contdocbillid");
        this.getModel().setValue(CONTTEMPID, contTempId);
        this.getModel().setValue(BILLID, billId);
        this.getModel().setValue("contdocbillid", contDocBillId);
        if (paramMap.get(VERSION) != null) {
            this.getPageCache().put(VERSION, String.valueOf(paramMap.get(VERSION)));
            this.getModel().setValue(NEW, (Object)Boolean.TRUE);
        }
    }

    public void afterBindData(EventObject e) {
        Object onlyView;
        DynamicObjectCollection templateEntry;
        super.afterBindData(e);
        Object contDocBillId = this.getModel().getValue("contdocbillid");
        if (StringUtils.isBlank((Object)contDocBillId) || Long.parseLong(contDocBillId.toString()) == 0L) {
            logger.error("{}\u754c\u9762({})\u83b7\u53d6\u5408\u540c\u6b63\u6587ID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5f02\u5e38\u3002", (Object)EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getDisplayName(), (Object)this.getView().getEntityId());
            return;
        }
        Object billId = this.getModel().getValue(BILLID);
        DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((Object)contDocBillId, (String)"pmct_contdocbill");
        String billDocUrl = contDocBill.getString("billdocurl");
        String billDocName = contDocBill.getString("billdocname");
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        Object contTempId = this.getModel().getValue(CONTTEMPID);
        if (contTempId == null || Long.parseLong(contTempId.toString()) == 0L) {
            webOffice.openNew(WebOfficeFileType.word);
            return;
        }
        boolean isFirst = false;
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
        if (((Boolean)this.getModel().getValue(NEW)).booleanValue()) {
            templateEntry = contDocBill.getDynamicObjectCollection("templateentry");
            if (templateEntry.size() == 0 || !contDocBill.getDynamicObject("conttemp").getPkValue().equals(contTempId)) {
                isFirst = true;
                billDocName = contTemp.getString(TEMPDOCNAME);
                billDocUrl = contTemp.getString(TEMPDOCURL);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)billDocUrl)) {
                templateEntry = contDocBill.getDynamicObjectCollection("templateentry");
                for (DynamicObject templateEntryObj : templateEntry) {
                    DynamicObject template = templateEntryObj.getDynamicObject("template");
                    if (template == null) continue;
                    String curTempId = contDocBill.getString("conttemp_id");
                    if (!StringUtils.equals((CharSequence)template.getString("id"), (CharSequence)curTempId)) continue;
                    billDocUrl = templateEntryObj.getString("lastbilldocurl");
                    billDocName = templateEntryObj.getString("lastbilldocname");
                    break;
                }
            }
            QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)contDocBillId.toString());
            QFilter fInterIdFilter1 = new QFilter(FINTERID, "=", (Object)billId.toString());
            boolean exists = QueryServiceHelper.exists((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter});
            boolean existOnCont = QueryServiceHelper.exists((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter1});
            if (StringUtils.isBlank((CharSequence)billDocUrl) || !exists || !existOnCont) {
                isFirst = true;
                billDocName = contTemp.getString(TEMPDOCNAME);
                billDocUrl = contTemp.getString(TEMPDOCURL);
            }
        }
        if (StringUtils.isBlank((CharSequence)billDocUrl)) {
            webOffice.openNew(WebOfficeFileType.word);
            return;
        }
        billDocUrl = FilePathFactory.getFilePath().getRealPath(billDocUrl);
        String newDocUrl = UrlService.getAttachmentFullUrl((String)billDocUrl);
        if (StringUtils.isEmpty((CharSequence)newDocUrl)) {
            return;
        }
        String billDocNameEncode = "";
        try {
            billDocNameEncode = URLEncoder.encode(billDocName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Throwable)ex);
        }
        newDocUrl = newDocUrl.replace(billDocName, billDocNameEncode);
        webOffice.open(newDocUrl);
        String billFormId = this.getBillFormId(contTemp);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
        String userName = RequestContext.get().getUserName();
        if (isFirst) {
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        } else {
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.TRACKING_EDIT);
        }
        DynamicObjectCollection bookMarkEntryCol = contTemp.getDynamicObjectCollection("bookmarkentry");
        if (bookMarkEntryCol.size() > 0) {
            List canEditBookMarkList = bookMarkEntryCol.stream().filter(a -> a.getBoolean("canedit")).map(b -> b.getString("bookmarkkey")).collect(Collectors.toList());
            ContractOfficeUtil.renderContract((IFormView)this.getView(), (WebOffice)webOffice, (DynamicObject)contTemp, (DynamicObject)bill);
            if (this.isWebOfficeOrLocalWps()) {
                webOffice.setEditableAreas(canEditBookMarkList, this.getPassword());
            }
        }
        if ((onlyView = this.getView().getFormShowParameter().getCustomParam("onlyView")) != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
            webOffice.limitDoc(this.getPassword());
        }
    }

    private String getBillFormId(DynamicObject contTemp) {
        String conttemplatetype = contTemp.getString("conttemplatetype");
        String billFormId = "pmct_incontract";
        if (StringUtils.equals((CharSequence)"OUT", (CharSequence)conttemplatetype)) {
            billFormId = "pmct_outcontract";
        } else if (StringUtils.equals((CharSequence)"OUTADDAGREEMENT", (CharSequence)conttemplatetype)) {
            billFormId = "pmct_outaddagreement";
        } else if (StringUtils.equals((CharSequence)"INADDAGREEMENT", (CharSequence)conttemplatetype)) {
            billFormId = "pmct_inaddagreement";
        } else if (StringUtils.equals((CharSequence)"STRATEGICAGREEMENT", (CharSequence)conttemplatetype)) {
            billFormId = "pmct_strategicagreement";
        }
        return billFormId;
    }

    public DynamicObject uploadDoc(Long pkId, String billType, String aliasFileName, String attachmentName, String url, int fileSize, String attachmentpanel, int fileSource) {
        QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)pkId.toString());
        QFilter fattachmentnameFilter = new QFilter(FALIASFILENAME, "=", (Object)aliasFileName);
        String selectString = "FFileId,FCREATEMEN,FATTACHMENTSIZE,FAttachmentName,FaliasFileName,fcreatetime,FModifyTime";
        DynamicObject[] contBillDocFileObjArr = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)selectString, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentnameFilter});
        Date now = new Date();
        if (contBillDocFileObjArr.length <= 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
            long id = ORM.create().genLongId(BOS_ATTACHMENT);
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("FNUMBER", (Object)this.getFileNumberString());
            dynamicObject.set(FBILLTYPE, (Object)billType);
            dynamicObject.set(FATTACHMENTPANEL, (Object)attachmentpanel);
            dynamicObject.set(FINTERID, (Object)pkId);
            dynamicObject.set(FMODIFYTIME, (Object)now);
            dynamicObject.set(FCREATETIME, (Object)now);
            dynamicObject.set(FALIASFILENAME, (Object)aliasFileName);
            dynamicObject.set(FATTACHMENTNAME, (Object)attachmentName);
            dynamicObject.set(FEXTNAME, (Object)(aliasFileName != null ? aliasFileName.substring(aliasFileName.lastIndexOf(46) + 1) : ""));
            dynamicObject.set(FATTACHMENTSIZE, (Object)fileSize);
            dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getUserId());
            Object contTempId = this.getModel().getValue(CONTTEMPID);
            DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
            String billFormId = this.getBillFormId(contTemp);
            if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_inaddagreement") || StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_outaddagreement")) {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_strategicagreement")) {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u6218\u7565\u534f\u8bae\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            } else {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u5408\u540c\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
            dynamicObject.set(FFILEID, (Object)url);
            dynamicObject.set(FILESOURCE, (Object)fileSource);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            return dynamicObject;
        }
        DynamicObject contDocAttach = contBillDocFileObjArr[0];
        contDocAttach.set(FMODIFYTIME, (Object)now);
        contDocAttach.set(FATTACHMENTSIZE, (Object)fileSize);
        contDocAttach.set(FFILEID, (Object)url);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contDocAttach});
        return contDocAttach;
    }

    protected String getFileNumberString() {
        StringBuilder prefixStr = new StringBuilder("rc-upload-");
        long currentTimeMillis = System.currentTimeMillis();
        SecureRandom r = new SecureRandom();
        int suffix = r.nextInt(99) + 1;
        return prefixStr.append(currentTimeMillis).append('-').append(suffix).toString();
    }

    protected void sycFileToCont(DynamicObject attachment, String billFormId, Object billId) {
        String fileName;
        QFilter fattachmentnameFilter;
        String selectString = "FFileId,FCREATEMEN,FATTACHMENTSIZE,FAttachmentName,FaliasFileName,fcreatetime,FModifyTime";
        QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)billId.toString());
        DynamicObject[] contBillDocFileObjArr = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)selectString, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentnameFilter = new QFilter(FATTACHMENTNAME, "=", (Object)(fileName = attachment.getString(FALIASFILENAME)))});
        if (contBillDocFileObjArr.length <= 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
            long id = ORM.create().genLongId(BOS_ATTACHMENT);
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("FNUMBER", (Object)this.getFileNumberString());
            dynamicObject.set(FBILLTYPE, (Object)billFormId);
            dynamicObject.set(FATTACHMENTPANEL, (Object)ATTACHMENTPANEL);
            dynamicObject.set(FINTERID, billId);
            dynamicObject.set(FMODIFYTIME, attachment.get(FMODIFYTIME));
            dynamicObject.set(FCREATETIME, attachment.get(FCREATETIME));
            dynamicObject.set(FALIASFILENAME, (Object)fileName);
            dynamicObject.set(FATTACHMENTNAME, (Object)fileName);
            dynamicObject.set(FEXTNAME, (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            dynamicObject.set(FATTACHMENTSIZE, attachment.get(FATTACHMENTSIZE));
            dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getCurrUserId());
            if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_inaddagreement") || StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_outaddagreement")) {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u8865\u5145\u534f\u8bae\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmct_strategicagreement")) {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u6218\u7565\u534f\u8bae\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            } else {
                dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u5408\u540c\u6b63\u6587\u9644\u4ef6", (String)"ContractDocBillDesignPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
            dynamicObject.set(FFILEID, attachment.get(FFILEID));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            DynamicObject contDocAttach = contBillDocFileObjArr[0];
            contDocAttach.set(FMODIFYTIME, attachment.get(FMODIFYTIME));
            contDocAttach.set(FATTACHMENTSIZE, attachment.get(FATTACHMENTSIZE));
            contDocAttach.set(FFILEID, attachment.get(FFILEID));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contDocAttach});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"savebilldoc", (CharSequence)operateKey)) {
            this.saveBillDoc();
        } else if (StringUtils.equals((CharSequence)OPREATE_ONLINE_SAVE, (CharSequence)operateKey)) {
            this.onlineSave();
        } else if (StringUtils.equals((CharSequence)OPREATE_GENERATE_ATTACHMENTS, (CharSequence)operateKey)) {
            this.generateattachments();
        } else if (StringUtils.equals((CharSequence)OPREATE_SWITCH_TPL, (CharSequence)operateKey)) {
            ContractOfficeUtil.openSelectbodytpl((AbstractFormPlugin)this);
        }
    }

    protected String getContDocName(DynamicObject contTemp) {
        String contDocName;
        Object billId = this.getModel().getValue(BILLID);
        String billFormId = this.getBillFormId(contTemp);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
        String billName = billObj.getString("billname");
        String tempName = contTemp.getString("name");
        Object contDocBillId = this.getModel().getValue("contdocbillid");
        QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)contDocBillId.toString());
        String patternName = String.format("%s_%s_V", billName, tempName);
        QFilter fattachmentnameFilter = new QFilter(FATTACHMENTNAME, "like", (Object)String.format("%s%s%s", "%", patternName, "%"));
        String selectString = "FFileId,FCREATEMEN,FATTACHMENTSIZE,FAttachmentName,FaliasFileName,fcreatetime,FModifyTime";
        DynamicObject[] contBillDocFileObjArr = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)selectString, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentnameFilter}, (String)"FAttachmentName desc");
        if (contBillDocFileObjArr.length <= 0) {
            contDocName = String.format("%s1.0", patternName);
        } else {
            String fattachmentName = contBillDocFileObjArr[0].getString(FATTACHMENTNAME);
            int suffix = fattachmentName.lastIndexOf(46);
            String versionStr = fattachmentName.substring(patternName.length(), suffix);
            int version = new BigDecimal(versionStr).intValue() + 1;
            contDocName = String.format("%s%s.0", patternName, version);
        }
        return contDocName;
    }

    protected String getPassword() {
        Object systemParameter = SystemParamHelper.getAppParameter((String)"textpassword", (String)"pmct");
        if (StringUtils.isBlank((Object)systemParameter)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u8bbe\u7f6e\u6b63\u6587\u5bc6\u7801\u3002", (String)"ContractDocBillDesignPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        }
        return systemParameter.toString();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"pmct_generateattachments", (CharSequence)actionId) && event.getReturnData() != null) {
            this.generateAttachmentsCloseCallBack((Map)event.getReturnData());
        } else if (StringUtils.equals((CharSequence)"pmct_selectbodytpl", (CharSequence)actionId) && event.getReturnData() != null) {
            this.selectbodytplCloseCallBack(event.getReturnData());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        String contDocUrl = (String)this.getModel().getValue(CONTDOCURL);
        String contDocName = (String)this.getModel().getValue(CONTDOCNAME);
        Object[] urls = evt.getUrls();
        String callbackKey = evt.getCallbackKey();
        Map<String, String> urlMap = ContractDocBillDesignPlugin.handleFileUrl(urls, contDocName);
        String filePath = urlMap.get(FILEPATH);
        String fileName = urlMap.get(FILENAME);
        String url = urlMap.get(URL);
        Map<String, String> uploadDataMap = ContractDocBillDesignPlugin.uploadTempFile(url, contDocUrl, filePath, fileName);
        fileName = uploadDataMap.get(FILENAME);
        url = uploadDataMap.get(URL);
        if (StringUtils.equals((CharSequence)WEBOFFICEAP, (CharSequence)callbackKey)) {
            DynamicObject billObj;
            this.getModel().setValue(CONTDOCURL, (Object)url);
            this.getModel().setValue(CONTDOCNAME, (Object)fileName);
            int fileSize = Integer.parseInt(uploadDataMap.get("filesize"));
            Long billId = this.getModel().getDataEntity().getLong(BILLID);
            Object contTempId = this.getModel().getValue(CONTTEMPID);
            DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
            String billFormId = this.getBillFormId(contTemp);
            Long contDocBillId = this.getModel().getDataEntity().getLong("contdocbillid");
            DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((Object)contDocBillId, (String)"pmct_contdocbill");
            if (((Boolean)this.getModel().getValue(NEW)).booleanValue()) {
                String format = this.getPageCache().get("format");
                if (format != null) {
                    String attachmentName = this.getPageCache().get(FILENAME);
                    if (StringUtils.equals((CharSequence)format, (CharSequence)"PDF")) {
                        InputStream in = FileAttachmentHelper.wordToPdf((String)url, (String)fileName);
                        String pdfFileName = fileName.substring(0, fileName.lastIndexOf(46));
                        pdfFileName = String.format("%s.pdf", pdfFileName);
                        int pdfFileSize = 0;
                        try {
                            pdfFileSize = in.available();
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                        String decryptUrl = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(url);
                        String pdfUrl = String.format("%s.pdf", decryptUrl.substring(0, decryptUrl.lastIndexOf(46)));
                        logger.info("beforedUploadPDF,ecryptWordUrl:{},pdfUrl:{},pdfFileName:{}", new Object[]{decryptUrl, pdfUrl, pdfFileName});
                        FileAttachmentHelper.uploadFile((InputStream)in, (String)pdfFileName, (String)pdfUrl);
                        QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)billId.toString());
                        QFilter fattachmentPanelFilter = new QFilter(FATTACHMENTPANEL, "=", (Object)TEXT_ATTACHMENTPANEL);
                        QFilter fileSourceFilter = new QFilter(FILESOURCE, "=", (Object)100);
                        DeleteServiceHelper.delete((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentPanelFilter, fileSourceFilter});
                        attachmentName = String.format("%s%s", attachmentName, ".pdf");
                        this.uploadDoc(billId, billFormId, pdfFileName, attachmentName, pdfUrl, pdfFileSize, TEXT_ATTACHMENTPANEL, 100);
                    } else {
                        QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)billId.toString());
                        QFilter fattachmentPanelFilter = new QFilter(FATTACHMENTPANEL, "=", (Object)TEXT_ATTACHMENTPANEL);
                        QFilter fileSourceFilter = new QFilter(FILESOURCE, "=", (Object)100);
                        DeleteServiceHelper.delete((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter, fattachmentPanelFilter, fileSourceFilter});
                        attachmentName = String.format("%s%s", attachmentName, ".doc");
                        this.uploadDoc(billId, billFormId, fileName, attachmentName, url, fileSize, TEXT_ATTACHMENTPANEL, 100);
                    }
                    this.getPageCache().remove(FILENAME);
                    this.getPageCache().remove("format");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u9644\u4ef6\u6210\u529f\u3002", (String)"ContractDocBillDesignPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ContractDocBillDesignPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                }
                logger.info("beforeUpdateDocBillNewVersion,fileName:{},url:{},", (Object)fileName, (Object)FileServiceExtFactory.getAttachFileServiceExt().getRealPath(url));
                this.updateDocBillNewVersion(fileName, url, contDocBill);
            } else {
                QFilter fInterIdFilter = new QFilter(FINTERID, "=", (Object)contDocBillId.toString());
                boolean exists = QueryServiceHelper.exists((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter});
                if (!exists) {
                    fInterIdFilter = new QFilter(FINTERID, "=", (Object)billId.toString());
                    DeleteServiceHelper.delete((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{fInterIdFilter});
                }
                DynamicObject billDocAttach = this.uploadDoc(contDocBillId, "pmct_contdocbill", fileName, fileName, url, fileSize, ATTACHMENTPANEL, 0);
                this.sycFileToCont(billDocAttach, billFormId, billId);
                this.updateDocBill(fileName, url, contDocBill);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ContractDocBillDesignPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contDocBill});
            if ((billFormId.equals("pmct_outcontract") || billFormId.equals("pmct_incontract")) && (billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId)) != null) {
                billObj.set("hasconttext", (Object)"1");
                SaveServiceHelper.update((DynamicObject)billObj);
            }
        }
    }

    protected void updateDocBill(String fileName, String url, DynamicObject contDocBill) {
        contDocBill.set("billdocurl", (Object)url);
        contDocBill.set("billdocname", (Object)fileName);
        DynamicObjectCollection templateEntry = contDocBill.getDynamicObjectCollection("templateentry");
        Object tempId = this.getModel().getValue(CONTTEMPID);
        boolean isExistTemp = false;
        for (DynamicObject templateEntryObj : templateEntry) {
            DynamicObject template = templateEntryObj.getDynamicObject("template");
            if (template == null) continue;
            String curTempId = contDocBill.getString("conttemp_id");
            if (!StringUtils.equals((CharSequence)template.getString("id"), (CharSequence)curTempId)) continue;
            isExistTemp = true;
            templateEntryObj.set("template", tempId);
            templateEntryObj.set("lastbilldocurl", (Object)url);
            templateEntryObj.set("lastbilldocname", (Object)fileName);
            break;
        }
        if (!isExistTemp) {
            DynamicObject templateEntryObj = templateEntry.addNew();
            templateEntryObj.set("template", tempId);
            templateEntryObj.set("lastbilldocurl", (Object)url);
            templateEntryObj.set("lastbilldocname", (Object)fileName);
        }
    }

    protected void updateDocBillNewVersion(String fileName, String url, DynamicObject contDocBill) {
        contDocBill.set("billdocurl", (Object)url);
        contDocBill.set("billdocname", (Object)fileName);
        Object tempId = this.getModel().getValue(CONTTEMPID);
        contDocBill.set("conttemp", tempId);
        DynamicObjectCollection templateEntry = contDocBill.getDynamicObjectCollection("templateentry");
        templateEntry.clear();
        DynamicObject templateEntryObj = new DynamicObject(templateEntry.getDynamicObjectType());
        templateEntryObj.set("template", tempId);
        templateEntryObj.set("lastbilldocurl", (Object)url);
        templateEntryObj.set("lastbilldocname", (Object)fileName);
        templateEntry.add((Object)templateEntryObj);
    }

    public static void openWebOfficeFile(WebOffice webOffice, String url, String fileName) {
        String tUrl = UrlService.getAttachmentFullUrl((String)url);
        String urlName = tUrl.substring(tUrl.lastIndexOf(47));
        String[] files = urlName.split("\\.");
        String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
        try {
            tFileName = URLEncoder.encode(tFileName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        String tExtend = files.length == 2 ? files[1] : "doc";
        fileName = tFileName + '.' + tExtend;
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
        tUrl = tUrl + fileName;
        webOffice.openAll(tUrl, fileName);
    }

    public static Map<String, String> handleFileUrl(Object[] urls, String tempDocName) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof Map) {
            filePath = ((Map)urlData).get(URL).toString();
            if (StringUtils.isBlank((CharSequence)tempDocName)) {
                String name;
                fileName = name = ((Map)urlData).get("name").toString();
                if (StringUtils.isBlank((CharSequence)name)) {
                    fileName = "NONAMEDOC";
                }
            } else {
                fileName = tempDocName;
            }
            url = filePath;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        return dataMap;
    }

    public static Map<String, String> uploadTempFile(String url, String docurl, String filePath, String fileName) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        int fileSize = 0;
        if (url.contains("tempfile")) {
            FileItem fileItem;
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            if (StringUtils.isNotBlank((CharSequence)docurl)) {
                docurl = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(docurl);
                fileItem = new FileItem(fileName, docurl, in);
                fileItem.setCreateNewFileWhenExists(false);
            } else {
                String path = ContractOfficeUtil.generateBillDocPath((String)fileName);
                fileItem = new FileItem(fileName, path, in);
                fileItem.setCreateNewFileWhenExists(true);
            }
            try {
                fileSize = fileItem.getInputStream().available();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            String turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        dataMap.put("filesize", String.valueOf(fileSize));
        return dataMap;
    }

    private void beforeSaveDoc() {
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        String passWord = this.getPassword();
        Object contTempId = this.getModel().getValue(CONTTEMPID);
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
        DynamicObjectCollection bookMarkEntryCol = contTemp.getDynamicObjectCollection("bookmarkentry");
        List canEditBookMarkList = bookMarkEntryCol.stream().filter(a -> a.getBoolean("canedit")).map(b -> b.getString("bookmarkkey")).collect(Collectors.toList());
        if (bookMarkEntryCol.size() > 0 && this.isWebOfficeOrLocalWps()) {
            webOffice.setEditableAreas(canEditBookMarkList, passWord);
        }
    }

    private void saveBillDoc() {
        this.beforeSaveDoc();
        Object contTempId = this.getModel().getValue(CONTTEMPID);
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
        String contDocName = (String)this.getModel().getValue(CONTDOCNAME);
        if (StringUtils.isBlank((CharSequence)contDocName)) {
            contDocName = this.getContDocName(contTemp);
        }
        String suffix = StringUtils.isNotBlank((CharSequence)contDocName) && contDocName.endsWith(".docx") ? ".docx" : ".doc";
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.save(String.format("%s%s", contDocName, suffix));
    }

    private void onlineSave() {
        this.beforeSaveDoc();
        Object contTempId = this.getModel().getValue(CONTTEMPID);
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
        String billFormId = this.getBillFormId(contTemp);
        Object billId = this.getModel().getValue(BILLID);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
        String contDocName = (String)this.getModel().getValue(CONTDOCNAME);
        if (StringUtils.isEmpty((CharSequence)contDocName)) {
            String suffix = contDocName.endsWith(".docx") ? ".docx" : ".doc";
            int version = Integer.parseInt(this.getPageCache().get(VERSION));
            contDocName = String.format("%s_V%s.0%s", billObj.getString("billno"), version, suffix);
        }
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.save(contDocName);
    }

    private void generateattachments() {
        Object billId = this.getModel().getValue(BILLID);
        QFilter panelFilter = new QFilter(FATTACHMENTPANEL, "=", (Object)TEXT_ATTACHMENTPANEL);
        QFilter billIdFilter = new QFilter(FINTERID, "=", (Object)String.valueOf(billId));
        QFilter fileSourceFilter = new QFilter(FILESOURCE, "=", (Object)100);
        DynamicObject attachment = BusinessDataServiceHelper.loadSingle((String)BOS_ATTACHMENT, (QFilter[])new QFilter[]{panelFilter, billIdFilter, fileSourceFilter});
        if (attachment == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmct_generateattachments");
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmct_generateattachments"));
            Object contTempId = this.getModel().getValue(CONTTEMPID);
            DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
            String billFormId = this.getBillFormId(contTemp);
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
            parameter.setCustomParam("billno", (Object)billObj.getString("billno"));
            this.getView().showForm(parameter);
        } else {
            String extName = attachment.getString(FEXTNAME);
            if (StringUtils.equals((CharSequence)"pdf", (CharSequence)extName)) {
                this.getPageCache().put("format", "PDF");
            } else {
                this.getPageCache().put("format", "Word");
            }
            String fileName = attachment.getString(FATTACHMENTNAME);
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            this.getPageCache().put(FILENAME, fileName);
            this.onlineSave();
        }
    }

    private void generateAttachmentsCloseCallBack(Map<String, String> returnData) {
        this.getPageCache().put(FILENAME, returnData.get(FILENAME));
        this.getPageCache().put("format", returnData.get("format"));
        this.onlineSave();
    }

    private void selectbodytplCloseCallBack(Object contTempId) {
        if (!contTempId.equals(this.getModel().getValue(CONTTEMPID))) {
            this.getModel().setValue(CONTTEMPID, contTempId);
            int version = Integer.parseInt(this.getPageCache().get(VERSION));
            this.getPageCache().put(VERSION, String.valueOf(version + 1));
        }
        DynamicObject contTemp = BusinessDataServiceHelper.loadSingle((Object)contTempId, (String)FORMID_CONTTEMPLATE);
        this.getModel().setValue(CONTDOCNAME, null);
        this.getModel().setValue(CONTDOCURL, null);
        String billDocUrl = contTemp.getString(TEMPDOCURL);
        String billDocName = contTemp.getString(TEMPDOCNAME);
        billDocUrl = FilePathFactory.getFilePath().getRealPath(billDocUrl);
        String newDocUrl = UrlService.getAttachmentFullUrl((String)billDocUrl);
        if (StringUtils.isEmpty((CharSequence)newDocUrl)) {
            return;
        }
        String billDocNameEncode = "";
        try {
            billDocNameEncode = URLEncoder.encode(billDocName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Throwable)ex);
        }
        newDocUrl = newDocUrl.replace(billDocName, billDocNameEncode);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.open(newDocUrl);
        newDocUrl = newDocUrl.replace(billDocName, billDocNameEncode);
        webOffice.open(newDocUrl);
        String billFormId = this.getBillFormId(contTemp);
        Object billId = this.getModel().getValue(BILLID);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
        String userName = RequestContext.get().getUserName();
        webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        DynamicObjectCollection bookMarkEntryCol = contTemp.getDynamicObjectCollection("bookmarkentry");
        if (bookMarkEntryCol.size() > 0) {
            List canEditBookMarkList = bookMarkEntryCol.stream().filter(a -> a.getBoolean("canedit")).map(b -> b.getString("bookmarkkey")).collect(Collectors.toList());
            ContractOfficeUtil.renderContract((IFormView)this.getView(), (WebOffice)webOffice, (DynamicObject)contTemp, (DynamicObject)bill);
            if (this.isWebOfficeOrLocalWps()) {
                webOffice.setEditableAreas(canEditBookMarkList, this.getPassword());
            }
        }
    }

    private boolean isWebOfficeOrLocalWps() {
        Map newAttachParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_fileserverconfig");
        Object editType = newAttachParam.get("editbuttongroup");
        if (StringUtils.isNotBlank(editType)) {
            return "1".equals(editType);
        }
        return true;
    }
}

