/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.doc;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.common.enums.ContTemplateTypeEnum;
import kd.pmgt.pmct.common.utils.ContractOfficeUtil;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;

public class ContractDocPlugin
extends AbstractPmctFormPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(ContractDocPlugin.class);
    private static final int WEBOFFICE_GEN = 100;
    private static final String OPREATE_TEXT_EDIT = "textedit";
    private static final String VERSION = "version";

    public void registerListener(EventObject e) {
        AttachmentPanel textAttachmentPanel;
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        if (attachmentPanel != null) {
            attachmentPanel.addUploadListener((UploadListener)this);
        }
        if ((textAttachmentPanel = (AttachmentPanel)this.getView().getControl("textattachmentpanel")) != null) {
            textAttachmentPanel.addUploadListener((UploadListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            this.setAgreementDocEnable();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setAgreementDocEnable();
    }

    private void setAgreementDocEnable() {
        String formId;
        List<String> needSetBtnEnable = Arrays.asList("pmct_incontract", "pmct_outcontract", "pmct_strategicagreement", "pmct_inaddagreement", "pmct_outaddagreement");
        if (!needSetBtnEnable.contains(formId = this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        String docBtn = "agreementdoc";
        if ("pmct_incontract".equals(formId) || "pmct_outcontract".equals(formId)) {
            docBtn = "bar_contdoc";
        } else if ("pmct_inaddagreement".equals(formId) || "pmct_outaddagreement".equals(formId)) {
            docBtn = "agreementdoc";
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        Object billId = this.getModel().getValue("id");
        boolean hasContDocBill = QueryServiceHelper.exists((String)"pmct_contdocbill", (QFilter[])new QFilter[]{new QFilter("contract", "=", billId)});
        if (StringUtils.equals((CharSequence)StatusEnum.TEMPSAVE.getValue(), (CharSequence)billStatus) || hasContDocBill) {
            this.getView().setEnable(Boolean.TRUE, new String[]{docBtn});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{docBtn});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"editcontdoc", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"agreementdoc", (CharSequence)operateKey)) {
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u4fe1\u606f\u3002", (String)"ContractDocPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            Object billId = this.getModel().getValue("id");
            DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((String)"pmct_contdocbill", (String)"id,conttemp", (QFilter[])new QFilter[]{new QFilter("contract", "=", billId)});
            if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
                if (contDocBill != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("formId", "pmct_contdocbill");
                    map.put("pkId", contDocBill.getPkValue().toString());
                    FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(parameter);
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("formId", "pmct_contdocbill");
                    map.put("contractid", billId);
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    String formId = dataEntity.getDynamicObjectType().getName();
                    String basetype = "";
                    switch (formId) {
                        case "pmct_outcontract": 
                        case "pmct_incontract": {
                            basetype = "pmct_contractf7";
                            break;
                        }
                        case "pmct_strategicagreement": {
                            basetype = "pmct_strategicagreementf7";
                            break;
                        }
                        case "pmct_inaddagreement": 
                        case "pmct_outaddagreement": {
                            basetype = "pmct_addagreementf7";
                            break;
                        }
                    }
                    map.put("basetype", basetype);
                    FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setStatus(OperationStatus.ADDNEW);
                    this.getView().showForm(parameter);
                }
            } else if (contDocBill != null) {
                WebOfficeBrowserParam param = new WebOfficeBrowserParam("pmct_contbilldesign");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("conttempid", contDocBill.get("conttemp_id"));
                paramMap.put("contract", billId.toString());
                paramMap.put("contdocbillid", contDocBill.get("id"));
                if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
                    paramMap.put("onlyView", "1");
                }
                boolean isInProcess = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)billId.toString()));
                String appId = this.getView().getFormShowParameter().getAppId();
                if (isInProcess && !StringUtils.equals((CharSequence)appId, (CharSequence)"wftask")) {
                    paramMap.put("onlyView", "1");
                }
                param.setParams(paramMap);
                String url = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)param);
                this.getView().openUrl(url);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e5f\u6ca1\u6709\u76f8\u5e94\u7684\u6b63\u6587\u3002", (String)"ContractDocPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)"edittemp", (CharSequence)operateKey)) {
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u6570\u636e\u3002", (String)"ContractDocPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            WebOfficeBrowserParam param = new WebOfficeBrowserParam("pmct_conttemplatedesign");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("conttempid", this.getModel().getValue("id"));
            boolean effective = (Boolean)this.getModel().getValue("effective");
            if (effective) {
                paramMap.put("effective", "true");
            }
            param.setParams(paramMap);
            String url = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)param);
            this.getView().openUrl(url);
        } else if (StringUtils.equals((CharSequence)"viewtemp", (CharSequence)operateKey)) {
            WebOfficeBrowserParam param = new WebOfficeBrowserParam("pmct_conttemplatedesign");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("conttempid", this.getModel().getValue("id"));
            paramMap.put("onlyView", "1");
            param.setParams(paramMap);
            String url = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)param);
            this.getView().openUrl(url);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object source = showParameter.getCustomParam("source");
            if (source != null) {
                String tempDocUrl = (String)this.getModel().getValue("tempdocurl");
                String tempDocName = (String)this.getModel().getValue("tempdocname");
                if (tempDocUrl.isEmpty() || tempDocName.isEmpty()) {
                    return;
                }
                FileService service = FileServiceFactory.getAttachmentFileService();
                InputStream inputStream = service.getInputStream(tempDocUrl);
                String path = ContractOfficeUtil.generateTplPath((String)tempDocName);
                try {
                    tempDocName = URLEncoder.encode(tempDocName, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage());
                }
                FileItem fileItem = new FileItem(tempDocName, path, inputStream);
                fileItem.setCreateNewFileWhenExists(true);
                String turl = service.upload(fileItem);
                this.getModel().setValue("tempdocurl", (Object)turl);
            }
        } else if (StringUtils.equals((CharSequence)OPREATE_TEXT_EDIT, (CharSequence)operateKey)) {
            this.beforeTextEdit(args);
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] urls;
        for (Object attachObj : urls = evt.getUrls()) {
            DynamicObject billObj;
            LinkedHashMap attachMap;
            String status;
            if (!(attachObj instanceof LinkedHashMap) || !StringUtils.equalsIgnoreCase((CharSequence)(status = (String)(attachMap = (LinkedHashMap)attachObj).get("status")), (CharSequence)"success")) continue;
            String billPkId = (String)attachMap.get("billPkId");
            DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((String)"pmct_contdocbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("contract", "=", (Object)Long.parseLong(billPkId))});
            if (contDocBill == null) continue;
            String url = (String)attachMap.get("url");
            String attachmentPrefixUrl = UrlService.getAttachmentPrefixUrl((String)url);
            String decodeUrl = null;
            try {
                decodeUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            if (decodeUrl != null) {
                decodeUrl = decodeUrl.substring(attachmentPrefixUrl.length());
            }
            QFilter fInterIdFilter = new QFilter("FInterID", "=", (Object)contDocBill.getString("id"));
            QFilter fUrlFilter = new QFilter("FFileId", "=", (Object)decodeUrl);
            DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{fInterIdFilter, fUrlFilter});
            boolean hasContText = false;
            Object curBillId = this.getModel().getDataEntity().getPkValue();
            fInterIdFilter = new QFilter("FInterID", "=", (Object)contDocBill.getString("id"));
            DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"FFileId", (QFilter[])new QFilter[]{fInterIdFilter});
            if (attachments.length > 0) {
                DynamicObject[] conFields;
                List fFileIds = Arrays.stream(attachments).map(o -> o.getString("FFileId")).collect(Collectors.toList());
                fInterIdFilter = new QFilter("FInterID", "=", (Object)curBillId.toString());
                for (DynamicObject conField : conFields = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"FFileId", (QFilter[])new QFilter[]{fInterIdFilter})) {
                    String fFileId = conField.getString("FFileId");
                    if (!fFileIds.contains(fFileId)) continue;
                    hasContText = true;
                    break;
                }
            }
            if (hasContText || !QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)curBillId) || (billObj = BusinessDataServiceHelper.loadSingle((Object)curBillId, (String)"pmct_contracttpl")) == null) continue;
            billObj.set("hasconttext", (Object)"0");
            SaveServiceHelper.update((DynamicObject)billObj);
        }
    }

    public void remove(UploadEvent evt) {
        Object attachmentObj;
        String callBackKey = evt.getCallbackKey();
        Object[] urls = evt.getUrls();
        if (StringUtils.equals((CharSequence)callBackKey, (CharSequence)"textattachmentpanel") && (attachmentObj = urls[0]) instanceof LinkedHashMap) {
            LinkedHashMap attachMap = (LinkedHashMap)attachmentObj;
            String billPkId = (String)attachMap.get("billPkId");
            String url = (String)attachMap.get("url");
            String attachmentPrefixUrl = UrlService.getAttachmentPrefixUrl((String)url);
            String decodeUrl = null;
            try {
                decodeUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            if (decodeUrl != null) {
                decodeUrl = decodeUrl.substring(attachmentPrefixUrl.length());
            }
            Object curBillId = this.getModel().getDataEntity().getPkValue();
            QFilter fInterIdFilter = new QFilter("FInterID", "=", (Object)String.valueOf(curBillId));
            QFilter fUrlFilter = new QFilter("FFileId", "=", (Object)decodeUrl);
            DynamicObject attachment = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"filesource", (QFilter[])new QFilter[]{fInterIdFilter});
            if (attachment != null && attachment.getInt("filesource") == 100) {
                DynamicObject billObj;
                QFilter billIdFilter = new QFilter("contract", "=", curBillId);
                DeleteServiceHelper.delete((String)"pmct_contdocbill", (QFilter[])new QFilter[]{billIdFilter});
                if (QueryServiceHelper.exists((String)"pmct_contracttpl", (Object)curBillId) && (billObj = BusinessDataServiceHelper.loadSingle((Object)curBillId, (String)"pmct_contracttpl", (String)"hasconttext")) != null) {
                    billObj.set("hasconttext", (Object)"0");
                    SaveServiceHelper.update((DynamicObject)billObj);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (event.getReturnData() != null && StringUtils.equals((CharSequence)"pmct_selectbodytpl", (CharSequence)actionId)) {
            Object contTemplateId = event.getReturnData();
            QFilter billIdFilter = new QFilter("contract", "=", this.getModel().getDataEntity().getPkValue());
            DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((String)"pmct_contdocbill", (String)"conttemp,templateentry.lastbilldocname", (QFilter[])billIdFilter.toArray());
            if (contDocBill == null) {
                contDocBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contdocbill"));
                this.initContDocBill(contDocBill, contTemplateId);
            }
            this.openWebOfficeDesignView(contDocBill, contTemplateId);
        }
    }

    private void beforeTextEdit(BeforeDoOperationEventArgs args) {
        DynamicObject contract;
        Object billId = this.getModel().getDataEntity().getPkValue();
        if (billId == null || billId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ContractDocPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject contractType = null;
        QFilter contTemplateTypeFilter = null;
        if (StringUtils.equals((CharSequence)"pmct_outcontract", (CharSequence)formId)) {
            contractType = (DynamicObject)this.getModel().getValue("contracttype");
            if (contractType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractDocPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            contTemplateTypeFilter = new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.OUT.getValue());
        } else if (StringUtils.equals((CharSequence)"pmct_incontract", (CharSequence)formId)) {
            contractType = (DynamicObject)this.getModel().getValue("contracttype");
            if (contractType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractDocPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            contTemplateTypeFilter = new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.IN.getValue());
        } else if (StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            contractType = (DynamicObject)this.getModel().getValue("agreementtype");
            if (contractType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u534f\u8bae\uff08\u5408\u540c\uff09\u7c7b\u578b\u3002", (String)"ContractDocPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            contTemplateTypeFilter = new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.STRATEGICAGREEMENT.getValue());
        } else if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)formId)) {
            contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ContractDocPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            contractType = contract.getDynamicObject("contracttype");
            contTemplateTypeFilter = new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.OUTADDAGREEMENT.getValue());
        } else if (StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)formId)) {
            contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"ContractDocPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            contractType = contract.getDynamicObject("contracttype");
            contTemplateTypeFilter = new QFilter("conttemplatetype", "=", (Object)ContTemplateTypeEnum.INADDAGREEMENT.getValue());
        }
        if (contractType != null) {
            Set contTypeTplIdSet = ContractTypeUtils.getContTplList((Object)contractType.getPkValue(), (QFilter)contTemplateTypeFilter);
            if (contTypeTplIdSet.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6b63\u6587\u6a21\u677f\u3002", (String)"ContractDocPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            } else if (contTypeTplIdSet.size() == 1) {
                Long contTemplateId = (Long)contTypeTplIdSet.iterator().next();
                QFilter billIdFilter = new QFilter("contract", "=", billId);
                DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((String)"pmct_contdocbill", (String)"conttemp,templateentry.lastbilldocname", (QFilter[])billIdFilter.toArray());
                if (contDocBill == null) {
                    contDocBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contdocbill"));
                    this.initContDocBill(contDocBill, contTemplateId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contDocBill});
                }
                this.openWebOfficeDesignView(contDocBill, contTemplateId);
            } else {
                QFilter billIdFilter = new QFilter("contract", "=", billId);
                DynamicObject contDocBill = BusinessDataServiceHelper.loadSingle((String)"pmct_contdocbill", (String)"conttemp,templateentry.lastbilldocname", (QFilter[])billIdFilter.toArray());
                if (contDocBill != null && contDocBill.getDynamicObjectCollection("templateentry").size() > 0) {
                    Object contTemplateId = contDocBill.getDynamicObject("conttemp").getPkValue();
                    this.openWebOfficeDesignView(contDocBill, contTemplateId);
                } else {
                    ContractOfficeUtil.openSelectbodytpl((AbstractFormPlugin)this);
                }
            }
        }
    }

    private void openWebOfficeDesignView(DynamicObject contDocBill, Object contTemplateId) {
        WebOfficeBrowserParam param = new WebOfficeBrowserParam("pmct_contbilldesign");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("contdocbillid", contDocBill.getPkValue());
        paramMap.put("conttempid", contTemplateId);
        paramMap.put("contract", this.getModel().getDataEntity().getPkValue());
        int version = 1;
        DynamicObjectCollection templateEntry = contDocBill.getDynamicObjectCollection("templateentry");
        if (templateEntry != null && !templateEntry.isEmpty()) {
            String lastBillDocName = ((DynamicObject)templateEntry.get(0)).getString("lastbilldocname");
            String versionStr = lastBillDocName.substring(lastBillDocName.lastIndexOf(86) + 1, lastBillDocName.lastIndexOf(46));
            version = new BigDecimal(versionStr).intValue() + 1;
        }
        paramMap.put(VERSION, version);
        param.setParams(paramMap);
        String url = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)param);
        this.getView().openUrl(url);
    }

    private void initContDocBill(DynamicObject contDocBill, Object contTempId) {
        Long id = ORM.create().genLongId("pmct_contdocbill");
        contDocBill.set("id", (Object)id);
        contDocBill.set("billno", this.getModel().getValue("billname"));
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"pmct_outcontract", (CharSequence)formId) || StringUtils.equals((CharSequence)"pmct_incontract", (CharSequence)formId)) {
            contDocBill.set("basetype", (Object)"pmct_contractf7");
        } else if (StringUtils.equals((CharSequence)"pmct_outaddagreement", (CharSequence)formId) || StringUtils.equals((CharSequence)"pmct_inaddagreement", (CharSequence)formId)) {
            contDocBill.set("basetype", (Object)"pmct_addagreementf7");
        } else if (StringUtils.equals((CharSequence)"pmct_strategicagreement", (CharSequence)formId)) {
            contDocBill.set("basetype", (Object)"pmct_strategicagreementf7");
        }
        contDocBill.set("contract", this.getModel().getDataEntity().getPkValue());
        contDocBill.set("conttemp", contTempId);
        contDocBill.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        contDocBill.set("createtime", (Object)new Date());
        contDocBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contDocBill});
    }
}

