/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.esignature;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.pmgt.pmbs.business.helper.AESHelper;
import kd.pmgt.pmbs.business.helper.OpenApiHelper;
import kd.pmgt.pmbs.business.helper.RandomHelper;
import kd.pmgt.pmbs.business.helper.SignInfoHelper;
import kd.pmgt.pmbs.common.config.CloudPlatformInterfaceConfig;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.http.HttpClientUtils;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;

public class ESignatureContractPlugin
extends AbstractPmctFormPlugin {
    private static final Log log = LogFactory.getLog(ESignatureContractPlugin.class);
    protected static final String E_SIGN_CALL_BACK = "esign_call_back";
    protected static final String CREATE_CONTRACT = "createcontract";
    protected static final String PREVIEW_CONTRACT = "previewcontract";
    protected static final String UPLOAD_CONTRACT = "uploadcontract";
    protected static final String USER_MANUAL_SIGN = "usermanualsign";
    protected static final String CUSTOMER_MANUAL_SIGN = "customermanualsign";
    protected static final String VIEW_SIGN = "viewsign";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if (!(CREATE_CONTRACT.equals(operationKey) || PREVIEW_CONTRACT.equals(operationKey) || UPLOAD_CONTRACT.equals(operationKey) || USER_MANUAL_SIGN.equals(operationKey) || VIEW_SIGN.equals(operationKey) || CUSTOMER_MANUAL_SIGN.equals(operationKey))) {
            return;
        }
        List contractSubject = new ArrayList(10);
        String partAId = "";
        String partBId = "";
        String payDirection = (String)this.getModel().getValue("paydirection");
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            contractSubject = SignInfoHelper.getContractSubjectByUOrgId((Object)this.getModel().getDataEntity().getDynamicObject("partb").getPkValue());
            if (contractSubject.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u4e59\u65b9\u4e0d\u5b58\u5728\u5408\u540c\u4e3b\u4f53\uff0c\u8bf7\u5148\u65b0\u589e\u5408\u540c\u4e3b\u4f53\u3002", (String)"ESignatureContractPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            partBId = (String)contractSubject.get(0);
            partAId = SignInfoHelper.getCompanyAuthUserIdByCustomer((Object)this.getModel().getDataEntity().getDynamicObject("parta").getPkValue());
            if (partAId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u7532\u65b9\u4e0d\u5b58\u5728\u7b7e\u7ea6\u4e3b\u4f53\uff0c\u8bf7\u5148\u65b0\u589e\u7b7e\u7ea6\u4e3b\u4f53\u3002", (String)"ESignatureContractPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
            contractSubject = SignInfoHelper.getContractSubjectByUOrgId((Object)this.getModel().getDataEntity().getDynamicObject("parta").getPkValue());
            if (contractSubject.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u7532\u65b9\u4e0d\u5b58\u5728\u5408\u540c\u4e3b\u4f53\uff0c\u8bf7\u5148\u65b0\u589e\u5408\u540c\u4e3b\u4f53\u3002", (String)"ESignatureContractPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            partAId = (String)contractSubject.get(0);
            partBId = SignInfoHelper.getCompanyAuthUserIdBySupplier((Object)this.getModel().getDataEntity().getDynamicObject("partb").getPkValue());
            if (partBId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u4e59\u65b9\u4e0d\u5b58\u5728\u7b7e\u7ea6\u4e3b\u4f53\uff0c\u8bf7\u5148\u65b0\u589e\u7b7e\u7ea6\u4e3b\u4f53\u3002", (String)"ESignatureContractPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String kdAppId = (String)contractSubject.get(1);
        String UUID2 = (String)contractSubject.get(2);
        String nonce = RandomHelper.random((int)32);
        String signType = "AES";
        String version = "1.0";
        String contractNo = (String)this.getModel().getValue("billno");
        String url = String.valueOf(SystemParamHelper.getAppParameter((String)"esignatureurl", (String)"pmbs"));
        switch (operationKey) {
            case "createcontract": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.createContract("pmct_incontract", url, kdAppId, nonce, signType, version, contractNo, UUID2);
                    break;
                }
                if (!PayDirectionEnum.OUT.getValue().equals(payDirection)) break;
                this.createContract("pmct_outcontract", url, kdAppId, nonce, signType, version, contractNo, UUID2);
                break;
            }
            case "previewcontract": {
                this.previewContract(url, kdAppId, nonce, signType, version, contractNo, UUID2);
                break;
            }
            case "uploadcontract": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.uploadContract(url, kdAppId, nonce, signType, partBId, version, contractNo, UUID2);
                    break;
                }
                if (!PayDirectionEnum.OUT.getValue().equals(payDirection)) break;
                this.uploadContract(url, kdAppId, nonce, signType, partAId, version, contractNo, UUID2);
                break;
            }
            case "usermanualsign": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.userManualSign(url, kdAppId, nonce, signType, partBId, version, contractNo, UUID2);
                    break;
                }
                if (!PayDirectionEnum.OUT.getValue().equals(payDirection)) break;
                this.userManualSign(url, kdAppId, nonce, signType, partAId, version, contractNo, UUID2);
                break;
            }
            case "viewsign": {
                this.viewSign(url, kdAppId, nonce, signType, version, contractNo, UUID2);
                break;
            }
            case "customermanualsign": {
                if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                    this.customerManualSign(url, kdAppId, nonce, signType, partAId, version, contractNo, UUID2);
                    break;
                }
                if (!PayDirectionEnum.OUT.getValue().equals(payDirection)) break;
                this.customerManualSign(url, kdAppId, nonce, signType, partBId, version, contractNo, UUID2);
                break;
            }
        }
    }

    private void customerManualSign(String url, String kdAppId, String nonce, String signType, String userId, String version, String contractNo, String UUID2) {
        url = url + CloudPlatformInterfaceConfig.HANDSIGNURLINTERFACE + "?kdAppId=" + kdAppId + "&nonce=" + nonce + "&signType=" + signType;
        JSONObject signParams = new JSONObject();
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        String[] userIds = new String[]{userId};
        data.put("userIds", (Object)userIds);
        data.put("acrosspageSign", (Object)false);
        signParams.put("data", (Object)data);
        log.info("customerManualSign signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        HashMap<String, String> requestData = new HashMap<String, String>(1);
        requestData.put("sign", sign);
        log.info("customerManualSign HttpClientUtils post url:{},requestData:{}", (Object)url, requestData);
        String responseValue = HttpClientUtils.post((String)url, requestData, null, null);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("customerManualSign responseJsonValue:{}", (Object)responseJsonValue);
        if (responseValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(10);
        paramsMap.put("formId", "pmbs_signpage");
        paramsMap.put("url", responseJsonValue.getJSONObject("data").getString("handSignUrl"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramsMap);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1000px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void viewSign(String url, String kdAppId, String nonce, String signType, String version, String contractNo, String UUID2) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("kdAppId", kdAppId);
        params.put("nonce", nonce);
        params.put("signType", signType);
        JSONObject signParams = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        signParams.put("data", (Object)data);
        log.info("viewSign signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        params.put("sign", sign);
        url = url + CloudPlatformInterfaceConfig.PREVIEWINTERFACE;
        log.info("viewSign HttpClientUtils get url:{},params:{}", (Object)url, params);
        String responseValue = HttpClientUtils.get((String)url, params);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("viewSign responseJsonValue:{}", (Object)responseJsonValue);
        if (responseJsonValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(10);
        paramsMap.put("formId", "pmbs_signpage");
        paramsMap.put("url", responseJsonValue.getJSONArray("data").getJSONObject(0).getJSONObject("sealInfo").getString("previewOfPcUrl"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramsMap);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1000px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void userManualSign(String url, String kdAppId, String nonce, String signType, String userId, String version, String contractNo, String UUID2) {
        url = url + CloudPlatformInterfaceConfig.HANDSIGNURLINTERFACE + "?kdAppId=" + kdAppId + "&nonce=" + nonce + "&signType=" + signType;
        JSONObject signParams = new JSONObject();
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        String[] userIds = new String[]{userId};
        data.put("userIds", (Object)userIds);
        data.put("acrosspageSign", (Object)false);
        signParams.put("data", (Object)data);
        log.info("userManualSign signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        HashMap<String, String> requestData = new HashMap<String, String>(1);
        requestData.put("sign", sign);
        log.info("userManualSign HttpClientUtils post url:{},requestData:{}", (Object)url, requestData);
        String responseValue = HttpClientUtils.post((String)url, requestData, null, null);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("userManualSign responseJsonValue:{}", (Object)responseJsonValue);
        if (responseJsonValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(10);
        paramsMap.put("formId", "pmbs_signpage");
        paramsMap.put("url", responseJsonValue.getJSONObject("data").getString("handSignUrl"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramsMap);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1000px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void uploadContract(String url, String kdAppId, String nonce, String signType, String userId, String version, String contractNo, String UUID2) {
        DynamicObject openApi = OpenApiHelper.getOpenApiByNumber((String)E_SIGN_CALL_BACK);
        if (openApi == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5f00\u653e\u5e73\u53f0\u914d\u7f6e\u56de\u8c03\u63a5\u53e3\u3002", (String)"ESignatureContractPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        url = url + CloudPlatformInterfaceConfig.UPLOADCONTRACTINTERFACE + "?kdAppId=" + kdAppId + "&nonce=" + nonce + "&signType=" + signType;
        JSONObject signParams = new JSONObject();
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        String[] userIds = new String[]{userId};
        data.put("userIds", (Object)userIds);
        data.put("acrosspageSign", (Object)false);
        String callBackUrl = RequestContext.get().getClientFullContextPath() + "kapi" + openApi.getString("urlformat");
        data.put("notifyUrl", (Object)callBackUrl);
        signParams.put("data", (Object)data);
        log.info("uploadContract signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        HashMap<String, String> requestData = new HashMap<String, String>(1);
        requestData.put("sign", sign);
        log.info("uploadContract HttpClientUtils post url:{},requestData:{}", (Object)url, requestData);
        String responseValue = HttpClientUtils.post((String)url, requestData, null, null);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("uploadContract responseJsonValue:{}", (Object)responseJsonValue);
        if (responseJsonValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u6210\u529f\u4e0a\u4f20\u81f3\u7b7e\u7ae0\u5e73\u53f0\u3002", (String)"ESignatureContractPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
    }

    private void previewContract(String url, String kdAppId, String nonce, String signType, String version, String contractNo, String UUID2) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("kdAppId", kdAppId);
        params.put("nonce", nonce);
        params.put("signType", signType);
        JSONObject signParams = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        signParams.put("data", (Object)data);
        log.info("previewContract signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        params.put("sign", sign);
        url = url + CloudPlatformInterfaceConfig.PREVIEWINTERFACE;
        log.info("previewContract HttpClientUtils get url:{},params:{}", (Object)url, params);
        String responseValue = HttpClientUtils.get((String)url, params);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("previewContract responseJsonValue:{}", (Object)responseJsonValue);
        if (responseJsonValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(10);
        paramsMap.put("formId", "pmbs_signpage");
        paramsMap.put("url", responseJsonValue.getJSONArray("data").getJSONObject(0).getJSONObject("nosealInfo").getString("previewOfPcUrl"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramsMap);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1000px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContract(String formId, String url, String kdAppId, String nonce, String signType, String version, String contractNo, String UUID2) {
        String templateId = CloudPlatformInterfaceConfig.TEMPLATE_ID;
        url = url + CloudPlatformInterfaceConfig.CREATECONTRACTINTERFACE + "?kdAppId=" + kdAppId + "&nonce=" + nonce + "&signType=" + signType;
        JSONObject signParams = new JSONObject();
        signParams.put("nonce", (Object)nonce);
        signParams.put("version", (Object)version);
        JSONObject data = new JSONObject();
        data.put("contractNo", (Object)contractNo);
        data.put("templateID", (Object)templateId);
        data.put("needConvert", (Object)true);
        signParams.put("data", (Object)data);
        log.info("createContract signParams:{}", (Object)signParams);
        String sign = AESHelper.encrypt((String)UUID2, (String)signParams.toString());
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)this.getModel().getDataEntity().getPkValue(), (String)"textattachmentpanel");
        List filter = attachments.stream().filter(att -> att.get("name").toString().substring(0, att.get("name").toString().lastIndexOf(".")).equals(contractNo)).collect(Collectors.toList());
        Map attachment = filter.size() <= 0 ? (Map)attachments.get(0) : (Map)filter.get(0);
        InputStream inputStream = null;
        String fileName = attachment.get("name").toString();
        try {
            URL url1 = new URL(attachment.get("url").toString());
            HttpURLConnection conn = (HttpURLConnection)url1.openConnection();
            inputStream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        HashMap<String, String> requestData = new HashMap<String, String>(1);
        requestData.put("sign", sign);
        log.info("createContract HttpClientUtils post url:{},requestData:{},inputStream:{},fileName:{}", new Object[]{url, requestData, inputStream, fileName});
        String responseValue = HttpClientUtils.post((String)url, requestData, (InputStream)inputStream, (String)fileName);
        JSONObject responseJsonValue = JSONObject.parseObject((String)responseValue);
        log.info("createContract responseJsonValue:{}", (Object)responseJsonValue);
        if (responseJsonValue == null) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e0a\u4f20\u5408\u540c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESignatureContractPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        if (0 != responseJsonValue.getInteger("code")) {
            this.getView().showMessage(responseJsonValue.getString("msg"));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5408\u540c\u521b\u5efa\u6210\u529f\u3002", (String)"ESignatureContractPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
    }
}

