/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.InvoiceSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctInvoicePlugin;

public class InInvoiceEditPlugin
extends AbstractPmctInvoicePlugin {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initHead();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contPartB = (BasedataEdit)this.getView().getControl("contpartb");
        contPartB.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit seller = (BasedataEdit)this.getControl("seller");
        seller.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit buyer = (BasedataEdit)this.getControl("buyer");
        buyer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void initHead() {
        boolean isReceive = (Boolean)this.getModel().getValue("isreceived");
        this.getView().setEnable(Boolean.valueOf(isReceive), new String[]{"receiver", "receivedate"});
        String source = (String)this.getModel().getValue("source");
        String billStatus = (String)this.getModel().getValue("billstatus");
        this.getView().setEnable(Boolean.valueOf(InvoiceSourceEnum.SOURCE_00.getValue().equals(source) && StatusEnum.TEMPSAVE.getValue().equals(billStatus)), new String[]{"totaluseamt"});
        this.getView().updateView("totaluseamt");
    }

    private void onChangeContract() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        this.getModel().setValue("isclaimed", (Object)(contract != null ? 1 : 0));
        if (contract == null) {
            this.getModel().setValue("contpartb", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"contpartb"});
            return;
        }
        DynamicObject singleContract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        if (singleContract.getBoolean("ismulticontract")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"contpartb"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contpartb"});
        }
        this.getModel().setValue("contpartb", (Object)singleContract.getDynamicObject("partb"));
        this.getView().updateView("contpartb");
        this.getModel().beginInit();
        DynamicObject project = singleContract.getDynamicObject("project");
        if (project == null) {
            this.getModel().setValue("project", null);
            this.getView().updateView("project");
            return;
        }
        this.getModel().setValue("project", project.getPkValue(), 0);
        this.getModel().endInit();
        this.getView().updateView("project");
    }

    private void onChangeIsReceived() {
        boolean isReceived = (Boolean)this.getModel().getValue("isreceived");
        this.getView().setEnable(Boolean.valueOf(isReceived), new String[]{"receiver", "receivedate"});
        if (isReceived) {
            this.getModel().setValue("receivedate", (Object)new Date());
            this.getModel().setValue("receiver", (Object)RequestContext.get().getCurrUserId(), 0);
        } else {
            this.getModel().setValue("receivedate", null);
            this.getModel().setValue("receiver", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        BigDecimal totalTax = this.getModel().getDataEntity().getBigDecimal("totaltax");
        BigDecimal totalAmount = this.getModel().getDataEntity().getBigDecimal("totalamount");
        BigDecimal totalOfTaxAmount = this.getModel().getDataEntity().getBigDecimal("totaloftaxamount");
        BigDecimal totalUseAmt = this.getModel().getDataEntity().getBigDecimal("totaluseamt");
        switch (propertyName) {
            case "contract": {
                this.onChangeContract();
                break;
            }
            case "isreceived": {
                this.onChangeIsReceived();
                break;
            }
            case "taxrate": {
                DynamicObject taxRate = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
                if (taxRate != null) {
                    this.getModel().setValue("taxvalue", taxRate.get("taxrate"), rowIndex);
                } else {
                    this.getModel().setValue("taxvalue", null);
                }
            }
            case "qty": 
            case "oftaxprice": 
            case "price": 
            case "oftaxamount": {
                this.computeEntry(propertyName, rowIndex);
                this.computeTotal();
                break;
            }
            case "tax": 
            case "amount": {
                this.computeTotal();
                break;
            }
            case "totalamount": 
            case "totaltax": {
                this.getModel().beginInit();
                this.getModel().setValue("totaloftaxamount", (Object)NumberHelper.add((Object)totalAmount, (Object)totalTax));
                this.getModel().endInit();
                this.getView().updateView("totaloftaxamount");
                this.getModel().setValue("availableamt", (Object)NumberHelper.add((Object)totalAmount, (Object)totalTax).subtract(totalUseAmt));
                break;
            }
            case "totaloftaxamount": {
                this.getModel().beginInit();
                if (totalTax.compareTo(BigDecimal.ZERO) != 0 && totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                    return;
                }
                if (totalTax.compareTo(BigDecimal.ZERO) != 0 && totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("totalamount", (Object)totalOfTaxAmount.subtract(totalTax));
                } else if (totalTax.compareTo(BigDecimal.ZERO) == 0 && totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue("totaltax", (Object)totalOfTaxAmount.subtract(totalAmount));
                }
                this.getModel().endInit();
                this.getView().updateView("totalamount");
                this.getView().updateView("totaltax");
                break;
            }
            case "totaluseamt": {
                if (totalOfTaxAmount.compareTo(totalUseAmt) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u7d2f\u8ba1\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u51fa\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"InInvoiceEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("totaluseamt", (Object)BigDecimal.ZERO);
                    this.getModel().endInit();
                    break;
                }
                this.getModel().setValue("availableamt", (Object)totalOfTaxAmount.subtract(totalUseAmt));
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String key = event.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"contract", (CharSequence)key)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_ininvoice", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
        } else if ("contpartb".equals(key)) {
            DynamicObject object = (DynamicObject)this.getModel().getValue("contract");
            ArrayList<Object> contPartbs = new ArrayList<Object>();
            if (object != null) {
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"pmct_outcontract");
                DynamicObject partb = contract.getDynamicObject("partb");
                DynamicObjectCollection otherPart = contract.getDynamicObjectCollection("otherpart");
                contPartbs.add(partb.getPkValue());
                if (otherPart.size() > 0) {
                    for (DynamicObject other : otherPart) {
                        contPartbs.add(other.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
            }
            QFilter contPartbFilter = new QFilter("id", "in", contPartbs);
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(contPartbFilter);
        } else if (StringUtils.equals((CharSequence)"seller", (CharSequence)key)) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            parameter.getListFilterParameter().getQFilters().add(enableFilter);
        } else if (StringUtils.equals((CharSequence)"buyer", (CharSequence)key)) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
            if (hashPermOrgUnits.size() == 0) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
                List accountOrgs = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)hashPermOrgUnits, (String)"10");
                if (accountOrgs.size() == 0) {
                    qFilters.add(new QFilter("id", "=", (Object)0L));
                } else {
                    List allOrgIds = OrgTreeUtils.getParentByOrgIds((List)accountOrgs, (String)"10");
                    if (allOrgIds.size() > 0) {
                        qFilters.add(new QFilter("id", "in", (Object)allOrgIds));
                    }
                }
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection pictureEntry;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)OperationEnum.SAVE.getValue()) || StringUtils.equals((CharSequence)operateKey, (CharSequence)OperationEnum.SUBMIT.getValue())) && (pictureEntry = this.getModel().getEntryEntity("pictureentry")) != null && pictureEntry.size() > 0) {
            for (DynamicObject picture : pictureEntry) {
                String filename = picture.getString("filename");
                if (!StringUtils.isNotBlank((CharSequence)filename) || filename.length() <= 200) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5f71\u50cf\u6587\u4ef6\u540d\u79f0\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7200\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u56fe\u7247\u540d\u79f0\u3002", (String)"InInvoiceEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit") && (operationResult = args.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

