/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.invoice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.pmgt.pmct.business.helper.InvoiceHelper;
import kd.pmgt.pmct.common.utils.InvoiceUtils;

public class InInvoiceListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InInvoiceListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("receive".equals(operateKey)) {
            RefObject receiverId = new RefObject();
            if (!operate.getOption().tryGetVariableValue("receiver_id", receiverId)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "pmct_invoicereceive");
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_invoicereceive");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
                args.setCancel(true);
            }
        } else if ("claim".equals(operateKey)) {
            ListSelectedRowCollection selCols = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            boolean flag = InvoiceHelper.verifyClaim((ListSelectedRowCollection)selCols, (IFormView)this.getView());
            DynamicObject selectProject = null;
            ArrayList<Long> list = new ArrayList<Long>();
            HashSet objects = new HashSet();
            if (!flag) {
                args.setCancel(true);
                return;
            }
            int size = selCols.size();
            if (size > 1) {
                Object[] primaryKeyValues = selCols.getPrimaryKeyValues();
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"));
                boolean verifyOrg = InvoiceHelper.verifyOrg((DynamicObject[])dynamicObjects, objects, (IFormView)this.getView());
                boolean sameProjectFlag = InvoiceHelper.verifyProjectOnly((DynamicObject[])dynamicObjects);
                if (sameProjectFlag) {
                    selectProject = dynamicObjects[0].getDynamicObject("project");
                }
                list = new ArrayList(objects);
                if (!verifyOrg) {
                    args.setCancel(true);
                    return;
                }
            }
            if (size == 1) {
                DynamicObject selInvoice = BusinessDataServiceHelper.loadSingle((Object)selCols.get(0).getPrimaryKeyValue(), (String)"pmct_ininvoice");
                Object orgPk = selInvoice.getDynamicObject("org").getPkValue();
                list.add(Long.valueOf(orgPk.toString()));
                selectProject = selInvoice.getDynamicObject("project");
            }
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("pmct_conclaiminvoice");
            HashMap<String, List<Object>> customParams = new HashMap<String, List<Object>>(16);
            List invoices = selCols.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            customParams.put("invoiceIds", invoices);
            customParams.put("selectProject", (List<Object>)selectProject);
            customParams.put("orgList", list);
            param.setCustomParams(customParams);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_conclaiminvoice");
            param.setCloseCallBack(callBack);
            this.getView().showForm(param);
            args.setCancel(true);
        } else if ("noncontclaim".equals(operateKey)) {
            ListSelectedRowCollection selCols = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            boolean flag = InvoiceHelper.verifyClaim((ListSelectedRowCollection)selCols, (IFormView)this.getView());
            if (!flag) {
                args.setCancel(true);
                return;
            }
            RefObject projectId = new RefObject();
            if (!operate.getOption().tryGetVariableValue("project_id", projectId)) {
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                parameter.setMultiSelect(false);
                long orgId = RequestContext.get().getOrgId();
                List orgIds = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true);
                QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
                parameter.getListFilterParameter().getQFilters().add(orgFilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bd_project");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                args.setCancel(true);
            }
        } else if ("download".equals(operateKey)) {
            List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            if (orgIds != null && orgIds.size() != 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "pmct_daterange");
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_daterange");
                HashMap<String, String> customParams = new HashMap<String, String>(16);
                customParams.put("direction", "in");
                parameter.setCustomParams(customParams);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"InInvoiceListPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            }
        } else if ("importinvoice".equals(operateKey)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmct_invoiceimport");
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_invoiceimport");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("unclaim".equals(operateKey) || "noncontclaim".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        } else if ("receive".equals(operateKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u7968\u6210\u529f\u3002", (String)"InInvoiceListPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if ("unreceive".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("bd_project".equals(event.getActionId()) && event.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            if (rows.size() > 0) {
                String projectId = rows.get(0).getPrimaryKeyValue().toString();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("project_id", projectId);
                this.getView().invokeOperation("noncontclaim", operateOption);
            }
        } else if ("pmct_daterange".equals(event.getActionId()) && event.getReturnData() != null) {
            QFilter enableFilter;
            List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            Map map = (Map)event.getReturnData();
            Date beginDate = (Date)map.get("beginDate");
            Date endDate = (Date)map.get("endDate");
            String selectType = null;
            if (map.get("selectType") != null) {
                selectType = map.get("selectType").toString();
            }
            String appId = null;
            String appSecret = null;
            String encryptKey = null;
            QFilter filter = new QFilter("org", "=", orgIds.get(0));
            DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"pmct_invoiceconfig", (String)"appid,appsecret,encryptkey", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("enable", "=", (Object)"1")});
            if (config != null) {
                appId = config.getString("appid");
                appSecret = config.getString("appsecret");
                encryptKey = config.getString("encryptkey");
            } else {
                config = BusinessDataServiceHelper.loadSingle((String)"er_bd_kdinvoicecloudcfg", (String)"client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{filter, enableFilter});
                if (config != null) {
                    appId = config.getString("client_id");
                    appSecret = config.getString("client_secret");
                    encryptKey = config.getString("encrypt_key");
                }
            }
            if (config == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u7ef4\u62a4\u53d1\u7968\u4e91\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InInvoiceListPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String url = null;
            DynamicObject invoiceUrl = BusinessDataServiceHelper.loadSingle((String)"pmct_inoviceurl", (String)"url", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"invoiceurlbillno")});
            if (invoiceUrl != null) {
                url = invoiceUrl.getString("url");
            } else {
                filter = new QFilter("config_key", "=", (Object)"dim_imc_config_fpy_url");
                DynamicObject urlConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_param_configuration", (String)"config_value", (QFilter[])new QFilter[]{filter});
                if (urlConfig != null) {
                    url = urlConfig.getString("config_value");
                }
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u53d1\u7968\u4e91\u6388\u6743\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InInvoiceListPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String resultString = InvoiceUtils.getToken((String)appId, (String)appSecret, (String)url);
            logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u83b7\u53d6Token\u63a5\u53e3\u65f6\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)resultString);
            if (resultString == null || resultString.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"InInvoiceListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject result = JSONObject.parseObject((String)resultString);
            if (result == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"InInvoiceListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String errCode = result.getString("errcode");
            if (StringUtils.isEmpty((CharSequence)errCode) || !"0000".equals(errCode)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91Token\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InInvoiceListPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), result.getString("description")));
                return;
            }
            String token = result.getString("access_token");
            JSONObject response = this.queryInvoiceInfo(token, encryptKey, beginDate, endDate, selectType, url, "");
            if (response == null) {
                logger.info("first request queryInvoiceInfo response is null");
                return;
            }
            String responseErrCode = response.getString("errcode");
            if (!StringUtils.isEmpty((CharSequence)responseErrCode) && !"0000".equals(responseErrCode)) {
                String description = result.getString("description");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"InInvoiceListPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), responseErrCode, description));
                return;
            }
            Integer totalElement = response.getInteger("totalElement");
            if ((response = this.queryInvoiceInfo(token, encryptKey, beginDate, endDate, selectType, url, String.valueOf(totalElement))) == null) {
                logger.info("second request queryInvoiceInfo response is null");
                return;
            }
            InvoiceHelper.processInvoice((JSONObject)response, (Long)((Long)orgIds.get(0)), (IFormView)this.getView());
            BillList x = (BillList)this.getView().getControl("billlistap");
            x.refresh();
        } else if ("pmct_invoiceimport".equals(event.getActionId()) || "pmct_conclaiminvoice".equals(event.getActionId())) {
            this.getView().invokeOperation("refresh");
        } else if ("pmct_invoicereceive".equals(event.getActionId())) {
            Map map = (Map)event.getReturnData();
            if (map == null || map.get("receiver") == null || map.get("receivedate") == null) {
                return;
            }
            String receiverID = (String)map.get("receiver");
            String receiveDate = (String)map.get("receivedate");
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] selectIds = selectedRows.stream().map(o -> o.getPrimaryKeyValue().toString()).collect(Collectors.toList()).toArray();
            if (selectIds.length > 0) {
                DynamicObject[] inInvoices = BusinessDataServiceHelper.load((Object[])selectIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"));
                DynamicObject receiver = BusinessDataServiceHelper.loadSingle((Object)receiverID, (String)"bos_user");
                for (DynamicObject inInvoice : inInvoices) {
                    inInvoice.set("receiver", (Object)receiver);
                    inInvoice.set("receivedate", (Object)new Date(Long.parseLong(receiveDate)));
                    inInvoice.set("isreceived", (Object)true);
                }
                SaveServiceHelper.update((DynamicObject[])inInvoices);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u7968\u6210\u529f\u3002", (String)"InInvoiceListPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private JSONObject queryInvoiceInfo(String token, String encryptKey, Date beginDate, Date endDate, String selectType, String url, String pageSize) {
        String responseString = InvoiceUtils.queryInvoiceInfo((String)token, (String)encryptKey, (Date)beginDate, (Date)endDate, (String)selectType, (String)url, (String)pageSize);
        if (responseString == null || responseString.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"InInvoiceListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return null;
        }
        return JSONObject.parseObject((String)responseString);
    }
}

