/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.common.utils.WorkflowUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class IncomeRegisterEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static String incomeApplySelector = Stream.of("entryentity", "entrycontract", "applyoftaxamount").collect(Collectors.joining(","));
    private static final String CONTCURRENCY = "contcurrency";
    public static final String CONFIRMCALLBACK_CONT_PRO_CHANGE = "contprochange";
    private static final String OP_RECCONFIRM = "recconfirm";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("bizdate", (Object)new Date());
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        sContainer.changeFlexStatus(SplitDirection.right, true);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.onChangeSourceType(false);
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("wf_approvalpage_bac".equals(formShowParameter.getParentFormId())) {
            sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
        } else {
            ApprovalRecord record;
            List arData;
            DynamicObject bill = this.getModel().getDataEntity(true);
            String billPk = ObjectUtils.nullSafeToString((Object)bill.getPkValue());
            boolean inProcess = false;
            if (!"0".equals(billPk)) {
                inProcess = WorkflowServiceHelper.inProcess((String)billPk);
            }
            if ((arData = (record = (ApprovalRecord)this.getControl("approvalrecordap")).getArData()) != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)entry.getDynamicObject("entrycontract")), i, new String[]{"contpro"});
        }
    }

    private void onChangeSourceType(boolean clearData) {
        if (clearData) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"itempanel"});
        FieldEdit project = (FieldEdit)this.getControl("project");
        project.setMustInput(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (propertyName.equals("receiptoftaxamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal applyOfTaxAmount = (BigDecimal)changeData.getNewValue();
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endreceiptrate", (Object)applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal receiptAmount = applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5);
            BigDecimal receiptTaxAmount = applyOfTaxAmount.subtract(receiptAmount);
            this.getModel().beginInit();
            this.getModel().setValue("receiptamount", (Object)receiptAmount, rowIndex);
            this.getModel().setValue("receipttaxamount", (Object)receiptTaxAmount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("receiptamount", rowIndex);
            this.getView().updateView("receipttaxamount", rowIndex);
        } else if (propertyName.equals("project")) {
            DynamicObject project = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryColl.clear();
            this.getView().updateView("entryentity");
            if (project == null) {
                return;
            }
            HashSet<Object> projectSet = new HashSet<Object>();
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject contract;
                DynamicObject entryObject = (DynamicObject)entry.get(i);
                if (entryObject == null || (contract = entryObject.getDynamicObject("entrycontract")) == null) continue;
                DynamicObject contractProject = contract.getDynamicObject("project");
                if (contractProject != null) {
                    projectSet.add(contractProject.getPkValue());
                    continue;
                }
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            projectSet.add(project.getPkValue());
            if (projectSet.size() > 1) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (propertyName.equals("period")) {
            this.getModel().deleteEntryData("entryentity");
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"startreceiptrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal startReceiptRate = (BigDecimal)changeData.getNewValue();
            BigDecimal endReceiptRate = (BigDecimal)this.getModel().getValue("endreceiptrate", rowIndex);
            this.updateEndStartRate(startReceiptRate, endReceiptRate, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"endreceiptrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal endReceiptRate = (BigDecimal)changeData.getNewValue();
            BigDecimal startReceiptRate = (BigDecimal)this.getModel().getValue("startreceiptrate", rowIndex);
            this.updateEndStartRate(startReceiptRate, endReceiptRate, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"receiptamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal receiptamount = (BigDecimal)changeData.getNewValue();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal receipttaxamount = receiptamount.multiply(taxRate.divide(BigDecimal.valueOf(100L)));
            BigDecimal receiptoftaxamount = receiptamount.add(receipttaxamount);
            this.getModel().beginInit();
            this.getModel().setValue("receiptoftaxamount", (Object)receiptoftaxamount, rowIndex);
            this.getModel().setValue("receipttaxamount", (Object)receipttaxamount, rowIndex);
            this.getModel().endInit();
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endreceiptrate", (Object)receiptoftaxamount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            this.getView().updateView("receiptoftaxamount", rowIndex);
            this.getView().updateView("receipttaxamount", rowIndex);
            this.getView().updateView("endreceiptrate", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taxrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("receiptoftaxamount", rowIndex);
            BigDecimal applyAmount = (BigDecimal)this.getModel().getValue("receiptamount", rowIndex);
            if (applyOfTaxAmount != null && applyOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("receiptamount", (Object)applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5));
            } else if (applyAmount != null && applyAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("receiptoftaxamount", (Object)applyAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))));
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"receipttaxamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal receiptoftaxamount = (BigDecimal)this.getModel().getValue("receiptoftaxamount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("receipttaxamount", rowIndex);
            this.getModel().beginInit();
            this.getModel().setValue("receiptamount", (Object)receiptoftaxamount.subtract(taxAmount), rowIndex);
            this.getModel().endInit();
            this.getView().updateView("receiptamount", rowIndex);
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endreceiptrate", (Object)receiptoftaxamount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            this.getView().updateView("receiptoftaxamount", rowIndex);
            this.getView().updateView("receipttaxamount", rowIndex);
            this.getView().updateView("endreceiptrate", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"receiptamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"receiptshareamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal receiptAmt = (BigDecimal)this.getModel().getValue("receiptamt", rowIndex);
            BigDecimal receiptShareAmount = (BigDecimal)this.getModel().getValue("receiptshareamount", rowIndex);
            this.getModel().setValue("tatolreceiptamount", (Object)receiptAmt.add(receiptShareAmount), rowIndex);
            this.getView().updateView("tatolreceiptamount", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"budgetitem")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().getEntryEntity("entryentity");
            DynamicObject budgetItemObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject entryContract = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(entryCurrentRowIndex)).getDynamicObject("entrycontract");
            QFilter contFilter = new QFilter("contract", "=", entryContract.getPkValue());
            QFilter budgetFilter = new QFilter("budgetitem", "=", budgetItemObject.getPkValue());
            contFilter.and(budgetFilter);
            DynamicObject[] contractBudgetEntry = BusinessDataServiceHelper.load((String)"pmbs_incontractbudgetperf", (String)String.join((CharSequence)",", "id", "budgetitem", "contractauditamtex", "settleauditamtex", "actualauditamtex"), (QFilter[])new QFilter[]{contFilter});
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (contractBudgetEntry.length > 0) {
                this.getModel().setValue("contractamount", (Object)contractBudgetEntry[0].getBigDecimal("contractauditamtex"), rowIndex);
                this.getModel().setValue("settleamount", (Object)contractBudgetEntry[0].getBigDecimal("settleauditamtex"), rowIndex);
                this.getModel().setValue("receiptamt", (Object)contractBudgetEntry[0].getBigDecimal("actualauditamtex"), rowIndex);
            } else {
                this.getModel().setValue("contractamount", null, rowIndex);
                this.getModel().setValue("settleamount", null, rowIndex);
                this.getModel().setValue("receiptamt", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            this.getPageCache().put(CONFIRMCALLBACK_CONT_PRO_CHANGE, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u9879\u76ee\u5c06\u5220\u9664\u73b0\u6709\u9879\u76ee\u7684\u201c\u6536\u6b3e\u5206\u644a\u201d\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"IncomeRegisterEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CONT_PRO_CHANGE, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(CONFIRMCALLBACK_CONT_PRO_CHANGE)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject contract = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                DynamicObject entryContPro = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpro");
                this.setAllAmount(org, period, contract, entryContPro, row);
                this.getModel().deleteEntryData("subentryentity");
                this.setSplitEntryData(contract, entryContPro, row);
            } else {
                String contPro = this.getPageCache().get(CONFIRMCALLBACK_CONT_PRO_CHANGE);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)(contPro == null ? null : Long.valueOf(Long.parseLong(contPro))), row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("entrycontract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        budgetItem.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmas_projectbudget", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit incomeItem = (BasedataEdit)this.getView().getControl("incomeitem");
        incomeItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contPro = (BasedataEdit)this.getView().getControl("contpro");
        if (contPro != null) {
            contPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid grid;
        int[] rows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equals("autofetch")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"IncomeRegisterEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"IncomeRegisterEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter periodFilter = new QFilter("period", "=", period.getPkValue());
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
            ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
            QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), null, PayDirectionEnum.IN, Collections.singletonList(org.getLong("id")), project);
            DynamicObject[] inContracts = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)"id", (QFilter[])new QFilter[]{contractFilter});
            List inContractIDs = Arrays.stream(inContracts).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter conEntryFilter = new QFilter("entryentity.entrycontract", "in", inContractIDs);
            QFilter[] filters1 = new QFilter[]{conEntryFilter, periodFilter, billstatusFilter};
            DynamicObject[] incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)incomeApplySelector, (QFilter[])filters1);
            if (incomeApplys.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u7684\u8bf7\u6b3e\u5355\u3002", (String)"IncomeRegisterEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>();
            HashMap<Object, BigDecimal> sumApplyamountMap = new HashMap<Object, BigDecimal>();
            this.mergeInComeApplys(incomeApplys, contractMap, sumApplyamountMap);
            this.getModel().deleteEntryData("entryentity");
            contractMap.forEach((object, contract) -> {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("entrycontract", contract.getPkValue(), row);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)project, row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
                this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), row, new String[]{"contpro"});
                this.getModel().setValue(CONTCURRENCY, contract.getDynamicObject("currency").getPkValue(), row);
                if (!contract.getBoolean("ismultirate")) {
                    this.getModel().setValue("conttaxrate", (Object)contract.getDynamicObject("lsttaxrate").getBigDecimal("taxrate"), row);
                } else {
                    this.getModel().setValue("conttaxrate", (Object)contract.getBigDecimal("lstavgtaxrate"), row);
                }
                this.getModel().setValue("totaloftaxamount", contract.get("totaloftaxamount"), row);
                this.setAllAmount(org, period, (DynamicObject)contract, project, row);
                this.setSplitEntryData((DynamicObject)contract, project, row);
            });
        } else if (key.equals("selectcontract")) {
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"IncomeRegisterEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)true, (int)2);
            parameter.setShowUsed(true);
            parameter.setShowApproved(true);
            long pkValue = Long.parseLong(org.getPkValue().toString());
            ArrayList<Long> orgs = new ArrayList<Long>();
            orgs.add(pkValue);
            ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
            QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), key, PayDirectionEnum.IN, orgs, project);
            parameter.getListFilterParameter().getQFilters().add(contractFilter);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_incontract");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (key.equals("refresh")) {
            ApprovalRecord record = (ApprovalRecord)this.getControl("approvalrecordap");
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            WorkflowUtils workflowUtils = new WorkflowUtils();
            workflowUtils.setWorkflow(dynamicObject, record);
            SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
            boolean inProcess = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)dynamicObject.getPkValue()));
            List arData = record.getArData();
            if (arData != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        } else if ("save".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
            this.updateContractData();
        } else if ("sharenewentry".equals(key) && (rows = (grid = (EntryGrid)this.getView().getControl("entryentity")).getEntryState().getSelectedRows()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u6536\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"IncomeRegisterEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void updateContractData() {
        DynamicObjectCollection contractInComeCollection = this.getModel().getEntryEntity("entryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        String contractName = "";
        if (contractInComeCollection.size() > 0) {
            for (DynamicObject contractPay : contractInComeCollection) {
                boolean flag = false;
                DynamicObject contract = contractPay.getDynamicObject("entrycontract");
                DynamicObject entryContPro = contractPay.getDynamicObject("contpro");
                if (contract != null) {
                    BigDecimal totalApplyOfTaxAmount;
                    BigDecimal totalRealOfTaxAmount;
                    BigDecimal totalSettleOfTaxAmount;
                    contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                    if (contractPay.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                        flag = true;
                        contractPay.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                    }
                    boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                    String multiPayType = contract.getString("multipaytype");
                    if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                        MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                        totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, null);
                        totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryContPro, contract, period);
                        totalApplyOfTaxAmount = multiSettleAmtService.getMultiIncomeApplyAmount(org, entryContPro, contract, period);
                    } else {
                        InComeUtils inComeUtils = new InComeUtils();
                        totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
                        totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
                        totalApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, null);
                    }
                    if (contractPay.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                        flag = true;
                        contractPay.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                    }
                    if (contractPay.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                        flag = true;
                        contractPay.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                    }
                    if (contractPay.getBigDecimal("preapplyoftaxamtsum").compareTo(totalApplyOfTaxAmount) != 0) {
                        flag = true;
                        contractPay.set("preapplyoftaxamtsum", (Object)totalApplyOfTaxAmount);
                    }
                    contractPay.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                }
                if (!flag) continue;
                if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                    contractName = contractName + "," + contract.getString("billname");
                    continue;
                }
                contractName = contractName + contract.getString("billname");
            }
            if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                this.getModel().updateEntryCache(contractInComeCollection);
                this.getView().getPageCache().put("contractName", contractName);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("save".equals(key) || "submit".equals(key) || "audit".equals(key)) {
            String contractName = this.getView().getPageCache().get("contractName");
            this.getView().getPageCache().remove("contractName");
            boolean isPush = (Boolean)this.getModel().getValue("pushed");
            if (StringUtils.isNotEmpty((CharSequence)contractName) && !isPush) {
                this.getView().updateView("entryentity");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u6536\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u3010%s\u3011\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u5b9e\u6536\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"IncomeRegisterEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName));
            }
            if (isPush) {
                if ("save".equals(key)) {
                    if (args.getOperationResult().isSuccess()) {
                        this.getView().invokeOperation("audit");
                    } else {
                        this.getModel().setValue("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                    }
                }
                if ("audit".equals(key)) {
                    if (!args.getOperationResult().isSuccess()) {
                        this.getModel().setValue("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"IncomeRegisterEditPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    }
                }
                if (args.getOperationResult().isSuccess()) {
                    args.getOperationResult().setShowMessage(false);
                }
            }
        } else if (OP_RECCONFIRM.equals(key)) {
            boolean isPush = (Boolean)this.getModel().getValue("pushed");
            if (args.getOperationResult().isSuccess() && isPush) {
                this.getModel().setValue("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
                this.getView().invokeOperation("save");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("pmct_incontract") && event.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            ArrayList<Object> selectedIds = new ArrayList<Object>(10);
            for (ListSelectedRow row : rows) {
                selectedIds.add(row.getPrimaryKeyValue());
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            for (Object e : selectedIds) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("entrycontract", e, row);
                DynamicObject contract = BusinessDataServiceHelper.loadSingle(e, (String)"pmct_incontract");
                DynamicObject entryContPro = ContractHelper.getContractProject((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)project, (DynamicObject)contract);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)entryContPro, row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
                this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), row, new String[]{"contpro"});
                this.getModel().setValue(CONTCURRENCY, contract.getDynamicObject("currency").getPkValue(), row);
                this.getModel().setValue("totaloftaxamount", contract.get("totaloftaxamount"), row);
                if (!contract.getBoolean("ismultirate") && contract.getDynamicObject("lsttaxrate") != null) {
                    this.getModel().setValue("taxrate", (Object)contract.getDynamicObject("lsttaxrate"), row);
                }
                this.setAllAmount(org, period, contract, entryContPro, row);
                this.setSplitEntryData(contract, entryContPro, row);
            }
        }
    }

    private void setAllAmount(DynamicObject org, DynamicObject period, DynamicObject contract, DynamicObject entryContPro, int row) {
        BigDecimal totalApplyOfTaxAmount;
        BigDecimal totalRealOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, null);
            totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryContPro, contract, period);
            totalApplyOfTaxAmount = multiSettleAmtService.getMultiIncomeApplyAmount(org, entryContPro, contract, period);
            this.setCellColor("totaloftaxamount", row);
        } else {
            InComeUtils inComeUtils = new InComeUtils();
            totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
            totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
            totalApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, null);
        }
        this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, row);
        this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, row);
        this.getModel().setValue("preapplyoftaxamtsum", (Object)totalApplyOfTaxAmount, row);
        this.getModel().setValue("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), row);
        if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue("startreceiptrate", (Object)totalRealOfTaxAmount.divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), row);
        }
    }

    private void setCellColor(String fieldKey, int row) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor("gray");
        cs.setForeColor("black");
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }

    private void mergeInComeApplys(DynamicObject[] incomeApplys, HashMap<Object, DynamicObject> contractMap, HashMap<Object, BigDecimal> sumApplyamountMap) {
        DynamicObjectCollection entries = new DynamicObjectCollection();
        for (DynamicObject incomeApply : incomeApplys) {
            entries.addAll((Collection)incomeApply.getDynamicObjectCollection("entryentity"));
        }
        for (DynamicObject contractApply : entries) {
            BigDecimal applyoftaxamount = contractApply.getBigDecimal("applyoftaxamount");
            if (null == contractApply.getDynamicObject("entrycontract")) continue;
            Object pkValue = contractApply.getDynamicObject("entrycontract").getPkValue();
            if (!contractMap.containsKey(pkValue)) {
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_incontract");
                contractMap.put(pkValue, contract);
            }
            if (sumApplyamountMap.containsKey(pkValue)) {
                applyoftaxamount = sumApplyamountMap.get(pkValue).add(applyoftaxamount);
            }
            sumApplyamountMap.put(pkValue, applyoftaxamount);
        }
    }

    private void setCellStyle(String entryKey, int rowIndex, String fieldKey, String color, List<CellStyle> cellStyles) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
    }

    private void updateEndStartRate(BigDecimal startReceiptRate, BigDecimal endReceiptRate, int rowIndex) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        if (startReceiptRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
            this.setCellStyle("entryentity", rowIndex, "startreceiptrate", "#DC143C", cellStyles);
        } else {
            this.setCellStyle("entryentity", rowIndex, "startreceiptrate", "#545454", cellStyles);
        }
        if (endReceiptRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
            this.setCellStyle("entryentity", rowIndex, "endreceiptrate", "#DC143C", cellStyles);
        } else {
            this.setCellStyle("entryentity", rowIndex, "endreceiptrate", "#545454", cellStyles);
        }
        grid.setCellStyle(cellStyles);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject contract;
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"entrycontract", (CharSequence)key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_incomeregister", (ListShowParameter)showParameter, (String)PayDirectionEnum.IN.getValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"budgetitem", (CharSequence)key)) {
            DynamicObject entryRowEntity = (DynamicObject)this.getModel().getEntryEntity("subentryentity").getParent();
            DynamicObject entryContPro = entryRowEntity.getDynamicObject("contpro");
            Set<Object> proIdSet = null;
            if (entryContPro != null) {
                proIdSet = new HashSet<Object>(1);
                proIdSet.add(entryContPro.getPkValue());
            } else {
                DynamicObject entryContract = entryRowEntity.getDynamicObject("entrycontract");
                boolean multipartSettlement = (entryContract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_incontract")).getBoolean("multipartsettlement");
                if (multipartSettlement) {
                    proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)entryContract);
                    if (proIdSet == null || proIdSet.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"IncomeRegisterEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                } else {
                    DynamicObject contProject = entryContract.getDynamicObject("project");
                    if (contProject == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"IncomeRegisterEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    proIdSet = new HashSet(1);
                    proIdSet.add(contProject.getPkValue());
                }
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("project", "in", proIdSet));
            DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
            List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                return children == null || children.length == 0;
            }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            filter.and(new QFilter("sourcetype", "=", (Object)"IN"));
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("incomeitem".equals(key)) {
            DynamicObject contract2 = (DynamicObject)this.getModel().getValue("entrycontract", this.getModel().getEntryCurrentRowIndex("entryentity"));
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (null != contract2) {
                QFilter contractFilter = new QFilter("contract", "=", contract2.getPkValue());
                parameter.getListFilterParameter().getQFilters().add(contractFilter);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"contpro") && (contract = (DynamicObject)this.getModel().getValue("entrycontract", beforeF7SelectEvent.getRow())) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(ContractHelper.getEntryProFilter((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)contract));
        }
    }

    private void setSplitEntryData(DynamicObject contract, DynamicObject project, int row) {
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (project != null) {
            filter.and(new QFilter("budgetitem.project", "=", project.getPkValue()));
        } else {
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            if (multiPartSettlement) {
                Set proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                if (proIdSet != null && !proIdSet.isEmpty()) {
                    filter.and("budgetitem.project", "in", (Object)proIdSet);
                }
            } else {
                DynamicObject contPro = contract.getDynamicObject("project");
                if (contPro != null) {
                    filter.and("budgetitem.project", "=", contPro.getPkValue());
                }
            }
        }
        DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_incontractbudgetperf", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection payApplySplitEntry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row)).getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < contractBudgets.length; ++i) {
            DynamicObject contractBudget = contractBudgets[i];
            contractBudget = BusinessDataServiceHelper.loadSingle((Object)contractBudget.getPkValue(), (String)"pmbs_contractbudget");
            DynamicObject payApply = payApplySplitEntry.addNew();
            payApply.set("seq", (Object)(i + 1));
            payApply.set("budgetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
            payApply.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
            payApply.set("settleamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
            payApply.set("receiptamt", (Object)contractBudget.getBigDecimal("actualauditamtex"));
        }
        this.getView().updateView("subentryentity");
    }
}

