/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;
import kd.pmgt.pmct.common.utils.WorkflowUtils;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class PaymentRegisterEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(PaymentRegisterEditPlugin.class);
    private static String paymentSelector = Stream.of("entryentity", "entrycontract", "applyoftaxamount", "contpartb").collect(Collectors.joining(","));
    private static final String CONTCURRENCY = "contcurrency";
    public static final String CONFIRMCALLBACK_CONT_PRO_CHANGE = "contprochange";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("bizdate", (Object)new Date());
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        sContainer.changeFlexStatus(SplitDirection.right, true);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.onChangeSourceType(false);
        SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("wf_approvalpage_bac".equals(formShowParameter.getParentFormId())) {
            sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
        } else {
            ApprovalRecord record;
            List arData;
            DynamicObject bill = this.getModel().getDataEntity();
            String billPk = ObjectUtils.nullSafeToString((Object)bill.getPkValue());
            boolean inProcess = false;
            if (!"0".equals(billPk)) {
                inProcess = WorkflowServiceHelper.inProcess((String)billPk);
            }
            if ((arData = (record = (ApprovalRecord)this.getControl("approvalrecordap")).getArData()) != null && arData.size() > 0 || inProcess) {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
            } else {
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)entry.getDynamicObject("entrycontract")), i, new String[]{"contpro"});
        }
    }

    private void onChangeSourceType(boolean clearData) {
        if (clearData) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"itempanel"});
        FieldEdit project = (FieldEdit)this.getControl("project");
        project.setMustInput(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("thispaymentoftaxamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal applyOfTaxAmount = (BigDecimal)changeData.getNewValue();
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endpaymentrate", (Object)applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal paymentamount = applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5);
            BigDecimal paymenttaxamount = applyOfTaxAmount.subtract(paymentamount);
            this.getModel().beginInit();
            this.getModel().setValue("thispaymentamount", (Object)paymentamount, rowIndex);
            this.getModel().setValue("thispaymenttaxamount", (Object)paymenttaxamount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("thispaymentamount", rowIndex);
            this.getView().updateView("thispaymenttaxamount", rowIndex);
        } else if (propertyName.equals("project")) {
            DynamicObject project = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (project == null) {
                return;
            }
            HashSet<Object> projectSet = new HashSet<Object>();
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject contract;
                DynamicObject entryObject = (DynamicObject)entry.get(i);
                if (entryObject == null || (contract = entryObject.getDynamicObject("entrycontract")) == null) continue;
                DynamicObject contractProject = contract.getDynamicObject("project");
                if (contractProject != null) {
                    projectSet.add(contractProject.getPkValue());
                    continue;
                }
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            projectSet.add(project.getPkValue());
            if (projectSet.size() > 1) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (propertyName.equals("period")) {
            this.getModel().deleteEntryData("entryentity");
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"startpaymentrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal startReceiptRate = (BigDecimal)changeData.getNewValue();
            BigDecimal endReceiptRate = (BigDecimal)this.getModel().getValue("endpaymentrate");
            this.updateEndStartRate(startReceiptRate, endReceiptRate, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"endpaymentrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal endReceiptRate = (BigDecimal)changeData.getNewValue();
            BigDecimal startReceiptRate = (BigDecimal)this.getModel().getValue("startpaymentrate");
            this.updateEndStartRate(startReceiptRate, endReceiptRate, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"thispaymentamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal paymentamount = (BigDecimal)changeData.getNewValue();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal paymenttaxamount = paymentamount.multiply(taxRate.divide(BigDecimal.valueOf(100L)));
            BigDecimal paymentoftaxamount = paymentamount.add(paymenttaxamount);
            this.getModel().beginInit();
            this.getModel().setValue("thispaymentoftaxamount", (Object)paymentoftaxamount, rowIndex);
            this.getModel().setValue("thispaymenttaxamount", (Object)paymenttaxamount, rowIndex);
            this.getModel().endInit();
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("thispaymentoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endpaymentrate", (Object)applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            this.getView().updateView("thispaymentoftaxamount", rowIndex);
            this.getView().updateView("thispaymenttaxamount", rowIndex);
            this.getView().updateView("endpaymentrate", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"thispaymenttaxamount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("thispaymentoftaxamount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("thispaymenttaxamount", rowIndex);
            this.getModel().beginInit();
            this.getModel().setValue("thispaymentamount", (Object)applyOfTaxAmount.subtract(taxAmount), rowIndex);
            this.getModel().endInit();
            this.getView().updateView("thispaymentamount", rowIndex);
            BigDecimal totalSettleOfTaxAmount = (BigDecimal)this.getModel().getValue("totalsettleoftaxamount", rowIndex);
            BigDecimal totalRealOfTaxAmount = (BigDecimal)this.getModel().getValue("totalrealoftaxamount", rowIndex);
            if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("endpaymentrate", (Object)applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), rowIndex);
            }
            this.getView().updateView("thispaymentoftaxamount", rowIndex);
            this.getView().updateView("thispaymenttaxamount", rowIndex);
            this.getView().updateView("endpaymentrate", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"taxrate")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject rateObj = (DynamicObject)this.getModel().getValue("taxrate", rowIndex);
            if (rateObj != null) {
                taxRate = rateObj.getBigDecimal("taxrate");
            }
            BigDecimal applyOfTaxAmount = (BigDecimal)this.getModel().getValue("thispaymentoftaxamount", rowIndex);
            BigDecimal applyAmount = (BigDecimal)this.getModel().getValue("thispaymentamount", rowIndex);
            if (applyOfTaxAmount != null && applyOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("thispaymentamount", (Object)applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5));
            } else if (applyAmount != null && applyAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.getModel().setValue("thispaymentoftaxamount", (Object)applyAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))));
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpartb")) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject contPartB = (DynamicObject)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (contPartB == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u6e05\u7a7a\u3002", (String)"PaymentRegisterEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("contpartb", oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("contpartb", rowIndex);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", rowIndex);
            DynamicObject entryContPro = (DynamicObject)this.getModel().getValue("contpro", rowIndex);
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("contpartb", rowIndex);
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            this.setAllAmount(org, period, contract, entryContPro, rowIndex, supplier);
            this.changeBankInfo(contPartB, rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"bankaccount")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            String newBankAccount = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((CharSequence)newBankAccount)) {
                this.getModel().setValue("bankname", null, rowIndex);
                this.getModel().setValue("bankaccount", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"budgetitem")) {
            DynamicObject budgetItemObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (budgetItemObject == null) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryContract = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(entryCurrentRowIndex)).getDynamicObject("entrycontract");
            DynamicObject contCurrency = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(entryCurrentRowIndex)).getDynamicObject(CONTCURRENCY);
            QFilter contFilter = new QFilter("contract", "=", entryContract.getPkValue());
            QFilter budgetFilter = new QFilter("budgetitem", "=", budgetItemObject.getPkValue());
            contFilter.and(budgetFilter);
            DynamicObject[] contractBudgetEntry = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "id", "budgetitem", "contractauditamtex", "settleauditamtex", "actualauditamtex"), (QFilter[])new QFilter[]{contFilter});
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue("subcurrency", (Object)contCurrency, rowIndex);
            if (contractBudgetEntry.length > 0) {
                this.getModel().setValue("contractamount", (Object)contractBudgetEntry[0].getBigDecimal("contractauditamtex"), rowIndex);
                this.getModel().setValue("settleamount", (Object)contractBudgetEntry[0].getBigDecimal("settleauditamtex"), rowIndex);
                this.getModel().setValue("actualpayamt", (Object)contractBudgetEntry[0].getBigDecimal("actualauditamtex"), rowIndex);
            } else {
                this.getModel().setValue("contractamount", null, rowIndex);
                this.getModel().setValue("settleamount", null, rowIndex);
                this.getModel().setValue("actualpayamt", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            this.getPageCache().put(CONFIRMCALLBACK_CONT_PRO_CHANGE, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u9879\u76ee\u5c06\u5220\u9664\u73b0\u6709\u9879\u76ee\u7684\u201c\u4ed8\u6b3e\u5206\u644a\u201d\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentRegisterEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CONT_PRO_CHANGE, (IFormPlugin)this));
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"payitem")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            if (changeData.getNewValue() != null) {
                this.getModel().setValue("paymenttype", (Object)((DynamicObject)changeData.getNewValue()).getString("paytype"), rowIndex);
            } else {
                this.getModel().setValue("paymenttype", null, rowIndex);
            }
            this.getModel().beginInit();
            this.getModel().setValue("payapplyno", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("payapplyno", rowIndex);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"payapplyno")) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            this.getModel().beginInit();
            if (changeData.getNewValue() != null) {
                this.getModel().setValue("payitem", (Object)((DynamicObject)changeData.getNewValue()).getDynamicObject("payitem"), rowIndex);
                this.getModel().setValue("paymenttype", (Object)((DynamicObject)changeData.getNewValue()).getString("paymenttype"), rowIndex);
            } else {
                this.getModel().setValue("payitem", null, rowIndex);
                this.getModel().setValue("paymenttype", null, rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("payitem", rowIndex);
            this.getView().updateView("paymenttype", rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String message = messageBoxClosedEvent.getCallBackId();
        if (message.equals(CONFIRMCALLBACK_CONT_PRO_CHANGE)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject contract = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("entrycontract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                DynamicObject entryConPro = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpro");
                DynamicObject supplier = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("contpartb");
                this.setAllAmount(org, period, contract, entryConPro, row, supplier);
                this.getModel().deleteEntryData("subentryentity");
                this.fillSplitEntry(row);
            } else {
                String contPro = this.getPageCache().get(CONFIRMCALLBACK_CONT_PRO_CHANGE);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)(contPro == null ? null : Long.valueOf(Long.parseLong(contPro))), row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("entrycontract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
        BasedataEdit contPartb = (BasedataEdit)this.getView().getControl("contpartb");
        contPartb.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payItem = (BasedataEdit)this.getView().getControl("payitem");
        payItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        budgetItem.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmas_projectbudget", (Object)beforeF7ViewDetailEvent.getPkId()));
        });
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit entryPro = (BasedataEdit)this.getView().getControl("contpro");
        entryPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payApplyNo = (BasedataEdit)this.getView().getControl("payapplyno");
        if (payApplyNo != null) {
            payApplyNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            payApplyNo.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_paymentapply", (String)"entryentity.id", (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    protected void showOrHidePaySplitEntry() {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "autofetch": {
                DynamicObject project = (DynamicObject)model.getValue("project");
                DynamicObject period = (DynamicObject)model.getValue("period");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PaymentRegisterEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (period == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PaymentRegisterEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                QFilter periodFilter = new QFilter("period", "=", period.getPkValue());
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
                QFilter[] paymentFilters = new QFilter[]{projectFilter, periodFilter, billStatusFilter};
                DynamicObject[] paymentApplys = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)paymentSelector, (QFilter[])paymentFilters);
                DynamicObject[] singleApplymentPays = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"contract,supplier,paydetailentry.curpayamtoftax", (QFilter[])paymentFilters);
                if (paymentApplys.length < 1 && singleApplymentPays.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8be5\u671f\u95f4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u6216\u4ed8\u6b3e\u7533\u8bf7\uff08\u5355\u5408\u540c\uff09\u3002", (String)"PaymentRegisterEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>();
                HashMap<Object, BigDecimal> sumApplyamountMap = new HashMap<Object, BigDecimal>();
                this.mergePaymentApplys(paymentApplys, contractMap, sumApplyamountMap);
                this.mergeSingleApplymentPays(singleApplymentPays, contractMap, sumApplyamountMap);
                model.deleteEntryData("entryentity");
                InComeUtils inComeUtils = new InComeUtils();
                HashMap<Object, BigDecimal> finalSumApplyamountMap = sumApplyamountMap;
                contractMap.forEach((object, contract) -> {
                    int row = model.createNewEntryRow("entryentity");
                    model.setValue("entrycontract", contract.getPkValue(), row);
                    model.setValue(CONTCURRENCY, contract.getDynamicObject("currency").getPkValue(), row);
                    model.setValue("contpro", (Object)project, row);
                    BigDecimal contTaxRate = contract.getBoolean("ismultirate") ? contract.getBigDecimal("lstavgtaxrate") : contract.getDynamicObject("lsttaxrate").getBigDecimal("taxrate");
                    model.setValue("conttaxrate", (Object)contTaxRate, row);
                    model.setValue("totaloftaxamount", contract.get("totaloftaxamount"), row);
                    BigDecimal totalsettleoftaxamount = inComeUtils.totalsettleoftaxamount(contract, period, contract.getDynamicObject("partb"));
                    BigDecimal totalrealoftaxamount = inComeUtils.totalrealoftaxamount(contract, period, contract.getDynamicObject("partb"));
                    model.setValue("totalsettleoftaxamount", (Object)totalsettleoftaxamount, row);
                    model.setValue("totalrealoftaxamount", (Object)totalrealoftaxamount, row);
                    model.setValue("totalunpaidoftaxamount", (Object)totalsettleoftaxamount.subtract(totalrealoftaxamount), row);
                    Object partbPk = contract.getDynamicObject("partb").getPkValue();
                    String pkValue = contract.getPkValue().toString() + partbPk;
                    model.setValue("preapplyoftaxamtsum", finalSumApplyamountMap.get(pkValue), row);
                    model.setValue("controlrate", (Object)contract.getBigDecimal("payrate"), row);
                    boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                    String multiPayType = contract.getString("multipaytype");
                    if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                        this.setCellColor("totaloftaxamount", row);
                        this.setCellColor("totalunpaidoftaxamount", row);
                    }
                    if (totalsettleoftaxamount.compareTo(BigDecimal.ZERO) != 0) {
                        model.setValue("startpaymentrate", (Object)totalrealoftaxamount.divide(totalsettleoftaxamount, 5, 6).multiply(BigDecimal.valueOf(100L)), row);
                    }
                    this.fillSplitEntry(row);
                });
                break;
            }
            case "selectcontract": {
                DynamicObject period = (DynamicObject)model.getValue("period");
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (period == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PaymentRegisterEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject project = (DynamicObject)model.getValue("project");
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                long pkValue = Long.parseLong(org.getPkValue().toString());
                ArrayList<Long> orgs = new ArrayList<Long>();
                orgs.add(pkValue);
                ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
                QFilter contractFilter = contractSelectSupport.getContractFilter(this.getView().getEntityId(), key, PayDirectionEnum.OUT, orgs, project);
                parameter.getListFilterParameter().getQFilters().add(contractFilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_outcontract");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "refresh": {
                ApprovalRecord record = (ApprovalRecord)this.getControl("approvalrecordap");
                DynamicObject dynamicObject = model.getDataEntity();
                WorkflowUtils workflowUtils = new WorkflowUtils();
                workflowUtils.setWorkflow(dynamicObject, record);
                SplitContainer sContainer = (SplitContainer)this.getControl("splitcontainerap");
                boolean inProcess = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)dynamicObject.getPkValue()));
                List arData = record.getArData();
                if (arData != null && arData.size() > 0 || inProcess) {
                    sContainer.changeFlexStatus(SplitDirection.right, Boolean.FALSE.booleanValue());
                    break;
                }
                sContainer.changeFlexStatus(SplitDirection.right, Boolean.TRUE.booleanValue());
                break;
            }
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                DynamicObjectCollection contractPayCollection = this.getModel().getEntryEntity("entryentity");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject period = (DynamicObject)model.getValue("period");
                String contractName = "";
                if (contractPayCollection.size() <= 0) break;
                InComeUtils inComeUtils = new InComeUtils();
                for (DynamicObject contractPay : contractPayCollection) {
                    boolean flag = false;
                    DynamicObject contract2 = contractPay.getDynamicObject("entrycontract");
                    DynamicObject entryPro = contractPay.getDynamicObject("contpro");
                    DynamicObject supplier = contractPay.getDynamicObject("contpartb");
                    if (contract2 != null) {
                        BigDecimal totalPayApplyOfTaxAmount;
                        BigDecimal totalRealOfTaxAmount;
                        BigDecimal totalSettleOfTaxAmount;
                        contract2 = BusinessDataServiceHelper.loadSingle((Object)contract2.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                        if (contractPay.getBigDecimal("totaloftaxamount").compareTo(contract2.getBigDecimal("totaloftaxamount")) != 0) {
                            flag = true;
                            contractPay.set("totaloftaxamount", (Object)contract2.getBigDecimal("totaloftaxamount"));
                        }
                        boolean multiPartSettlement = contract2.getBoolean("multipartsettlement");
                        String multiPayType = contract2.getString("multipaytype");
                        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryPro, contract2, period, supplier);
                            totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryPro, contract2, period, supplier);
                            totalPayApplyOfTaxAmount = multiSettleAmtService.getMultiPayApplyAmount(org, entryPro, contract2, period, supplier);
                        } else {
                            totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract2, period, supplier);
                            totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract2, period, supplier);
                            totalPayApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract2, period, supplier);
                        }
                        if (contractPay.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                            flag = true;
                            contractPay.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                        }
                        if (contractPay.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                            flag = true;
                            contractPay.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                        }
                        if (contractPay.getBigDecimal("preapplyoftaxamtsum").compareTo(totalPayApplyOfTaxAmount) != 0) {
                            flag = true;
                            contractPay.set("preapplyoftaxamtsum", (Object)totalPayApplyOfTaxAmount);
                        }
                        contractPay.set("totalunpaidoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                    }
                    if (!flag) continue;
                    if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                        contractName = contractName + "," + contract2.getString("billname");
                        continue;
                    }
                    contractName = contractName + contract2.getString("billname");
                }
                this.getModel().updateEntryCache(contractPayCollection);
                this.getView().getPageCache().put("contractName", contractName);
                break;
            }
            case "newsplitentry": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"PaymentRegisterEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("save".equals(key) || "submit".equals(key) || "audit".equals(key)) {
            String contractName = this.getView().getPageCache().get("contractName");
            this.getView().getPageCache().remove("contractName");
            boolean isPush = (Boolean)this.getModel().getValue("pushed");
            if (StringUtils.isNotEmpty((CharSequence)contractName) && !isPush) {
                this.getView().updateView("entryentity");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u4ed8\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u5b9e\u4ed8\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"PaymentRegisterEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contractName));
            }
            if (isPush) {
                if ("save".equals(key)) {
                    if (args.getOperationResult().isSuccess()) {
                        this.getView().invokeOperation("audit");
                    } else {
                        this.getModel().setValue("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                    }
                }
                if ("audit".equals(key)) {
                    if (!args.getOperationResult().isSuccess()) {
                        this.getModel().setValue("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentRegisterEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    }
                }
                if (args.getOperationResult().isSuccess()) {
                    args.getOperationResult().setShowMessage(false);
                }
            }
        } else if ("payconfirm".equals(key)) {
            boolean isPush = (Boolean)this.getModel().getValue("pushed");
            if (args.getOperationResult().isSuccess() && isPush) {
                this.getModel().setValue("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
                this.getView().invokeOperation("save");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("pmct_outcontract") && event.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getReturnData();
            ArrayList<Object> selectedIds = new ArrayList<Object>(rows.size());
            for (ListSelectedRow row : rows) {
                selectedIds.add(row.getPrimaryKeyValue());
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            for (Object e : selectedIds) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("entrycontract", e, row);
                DynamicObject contract = BusinessDataServiceHelper.loadSingle(e, (String)"pmct_outcontract");
                DynamicObject entryContPro = ContractHelper.getContractProject((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)project, (DynamicObject)contract);
                this.getModel().beginInit();
                this.getModel().setValue("contpro", (Object)entryContPro, row);
                this.getModel().endInit();
                this.getView().updateView("contpro", row);
                this.getView().setEnable(ContractHelper.getContractProjectEnable((DynamicObject)project, (DynamicObject)contract), row, new String[]{"contpro"});
                this.getModel().setValue(CONTCURRENCY, contract.getDynamicObject("currency").getPkValue(), row);
                this.getModel().setValue("totaloftaxamount", contract.get("totaloftaxamount"), row);
                if (!contract.getBoolean("ismultirate")) {
                    this.getModel().setValue("taxrate", (Object)contract.getDynamicObject("lsttaxrate"), row);
                }
                this.getModel().setValue("controlrate", (Object)contract.getBigDecimal("payrate"), row);
                if (contract.getBoolean("ismulticontract")) {
                    this.getView().setEnable(Boolean.TRUE, row, new String[]{"contpartb"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, row, new String[]{"contpartb"});
                }
                this.getModel().setValue("contpartb", (Object)contract.getDynamicObject("partb"), row);
                this.fillSplitEntry(row);
            }
        }
    }

    private void setAllAmount(DynamicObject org, DynamicObject period, DynamicObject contract, DynamicObject entryContPro, int row, DynamicObject supplier) {
        BigDecimal totalPayApplyOfTaxAmount;
        BigDecimal totalRealOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, supplier);
            totalRealOfTaxAmount = multiSettleAmtService.getMultiPayAmount(org, entryContPro, contract, period, supplier);
            totalPayApplyOfTaxAmount = multiSettleAmtService.getMultiPayApplyAmount(org, entryContPro, contract, period, supplier);
            this.setCellColor("totaloftaxamount", row);
        } else {
            InComeUtils inComeUtils = new InComeUtils();
            totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, supplier);
            totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, supplier);
            totalPayApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, supplier);
        }
        this.getModel().setValue("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount, row);
        this.getModel().setValue("totalrealoftaxamount", (Object)totalRealOfTaxAmount, row);
        this.getModel().setValue("preapplyoftaxamtsum", (Object)totalPayApplyOfTaxAmount, row);
        this.getModel().setValue("totalunpaidoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount), row);
        if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue("startpaymentrate", (Object)totalRealOfTaxAmount.divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L)), row);
        }
    }

    private void fillSplitEntry(int addRow) {
        DynamicObject model = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObject addContractRowObj = (DynamicObject)model.getDynamicObjectCollection("entryentity").get(addRow);
        DynamicObject entryContract = addContractRowObj.getDynamicObject("entrycontract");
        DynamicObject entryContPro = addContractRowObj.getDynamicObject("contpro");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_outcontract");
        if (contract != null) {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            if (entryContPro == null) {
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                if (multiPartSettlement) {
                    Set proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)contract);
                    if (proIdSet != null && !proIdSet.isEmpty()) {
                        filter.and("budgetitem.project", "in", (Object)proIdSet);
                    }
                } else {
                    DynamicObject contPro = contract.getDynamicObject("project");
                    if (contPro != null) {
                        filter.and("budgetitem.project", "=", contPro.getPkValue());
                    }
                }
            } else {
                filter.and("budgetitem.project", "=", entryContPro.getPkValue());
            }
            DynamicObject contractCurrency = contract.getDynamicObject("currency");
            DynamicObject[] contractBudgetEntry = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)String.join((CharSequence)",", "id", "budgetitem", "contractauditamtex", "settleauditamtex", "actualauditamtex"), (QFilter[])new QFilter[]{filter});
            DynamicObjectCollection paySplitEntry = addContractRowObj.getDynamicObjectCollection("subentryentity");
            for (int i = 0; i < contractBudgetEntry.length; ++i) {
                DynamicObject contractBudget = contractBudgetEntry[i];
                DynamicObject paySplitEntryRowObj = paySplitEntry.addNew();
                paySplitEntryRowObj.set("seq", (Object)(i + 1));
                paySplitEntryRowObj.set("budgetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
                paySplitEntryRowObj.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                paySplitEntryRowObj.set("settleamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                paySplitEntryRowObj.set("actualpayamt", (Object)contractBudget.getBigDecimal("actualauditamtex"));
                paySplitEntryRowObj.set("subcurrency", (Object)contractCurrency);
            }
            this.getView().updateView("subentryentity");
        }
    }

    private void setCellColor(String fieldKey, int row) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor("gray");
        cs.setForeColor("black");
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }

    private void mergeSingleApplymentPays(DynamicObject[] singleApplymentPays, HashMap<Object, DynamicObject> contractMap, HashMap<Object, BigDecimal> sumApplyamountMap) {
        for (DynamicObject singleApplymentPay : singleApplymentPays) {
            DynamicObjectCollection payDetailEntry = singleApplymentPay.getDynamicObjectCollection("paydetailentry");
            Object contPk = singleApplymentPay.getDynamicObject("contract").getPkValue();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contPk, (String)"pmct_outcontract");
            for (DynamicObject payDetailObj : payDetailEntry) {
                BigDecimal curpayamtoftax = payDetailObj.getBigDecimal("curpayamtoftax");
                Object partbPk = singleApplymentPay.getDynamicObject("supplier") != null ? singleApplymentPay.getDynamicObject("supplier").getPkValue() : contract.getDynamicObject("partb").getPkValue();
                String pkValue = contPk.toString() + partbPk;
                if (!contractMap.containsKey(contPk)) {
                    contractMap.put(contPk, contract);
                }
                if (sumApplyamountMap.containsKey(pkValue)) {
                    curpayamtoftax = sumApplyamountMap.get(pkValue).add(curpayamtoftax);
                }
                sumApplyamountMap.put(pkValue, curpayamtoftax);
            }
        }
    }

    private void mergePaymentApplys(DynamicObject[] paymentApplys, HashMap<Object, DynamicObject> contractMap, HashMap<Object, BigDecimal> sumApplyamountMap) {
        DynamicObjectCollection entries = new DynamicObjectCollection();
        for (DynamicObject paymentAppl : paymentApplys) {
            entries.addAll((Collection)paymentAppl.getDynamicObjectCollection("entryentity"));
        }
        for (DynamicObject contractApply : entries) {
            BigDecimal applyoftaxamount = contractApply.getBigDecimal("applyoftaxamount");
            if (null == contractApply.getDynamicObject("entrycontract")) continue;
            Object contPk = contractApply.getDynamicObject("entrycontract").getPkValue();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contPk, (String)"pmct_outcontract");
            Object partbPk = contractApply.getDynamicObject("contpartb") != null ? contractApply.getDynamicObject("contpartb").getPkValue() : contract.getDynamicObject("partb").getPkValue();
            String pkValue = contPk.toString() + partbPk;
            if (!contractMap.containsKey(contPk)) {
                contractMap.put(contPk, contract);
            }
            if (sumApplyamountMap.containsKey(pkValue)) {
                applyoftaxamount = sumApplyamountMap.get(pkValue).add(applyoftaxamount);
            }
            sumApplyamountMap.put(pkValue, applyoftaxamount);
        }
    }

    private void setCellStyle(String entryKey, int rowIndex, String fieldKey, String color, List<CellStyle> cellStyles) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
    }

    private void updateEndStartRate(BigDecimal startReceiptRate, BigDecimal endReceiptRate, int rowIndex) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        if (startReceiptRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
            this.setCellStyle("entryentity", rowIndex, "startpaymentrate", "#DC143C", cellStyles);
        } else {
            this.setCellStyle("entryentity", rowIndex, "startpaymentrate", "#545454", cellStyles);
        }
        if (endReceiptRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
            this.setCellStyle("entryentity", rowIndex, "endpaymentrate", "#DC143C", cellStyles);
        } else {
            this.setCellStyle("entryentity", rowIndex, "endpaymentrate", "#545454", cellStyles);
        }
        grid.setCellStyle(cellStyles);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"entrycontract", (CharSequence)propertyName)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ContractHelper.getContractByStatus((String)"pmct_paymentregister", (ListShowParameter)showParameter, (String)PayDirectionEnum.OUT.getValue());
        } else if ("contpartb".equals(propertyName)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", this.getModel().getEntryCurrentRowIndex("entryentity"));
            ArrayList<Object> contPartbs = new ArrayList<Object>();
            if (contract != null) {
                DynamicObject partb = contract.getDynamicObject("partb");
                DynamicObjectCollection otherPart = contract.getDynamicObjectCollection("otherpart");
                contPartbs.add(partb.getPkValue());
                if (otherPart.size() > 0) {
                    for (DynamicObject other : otherPart) {
                        contPartbs.add(other.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
            }
            QFilter contPartbFilter = new QFilter("id", "in", contPartbs);
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(contPartbFilter);
        } else if ("payitem".equals(propertyName)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", this.getModel().getEntryCurrentRowIndex("entryentity"));
            QFilter contractFilter = null;
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (null != contract) {
                contractFilter = new QFilter("contract", "=", contract.getPkValue());
                parameter.getListFilterParameter().getQFilters().add(contractFilter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"budgetitem", (CharSequence)propertyName)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            DynamicObject entryContPro = entryRowEntity.getDynamicObject("contpro");
            Set<Object> proIdSet = null;
            if (entryContPro != null) {
                proIdSet = new HashSet<Object>(1);
                proIdSet.add(entryContPro.getPkValue());
            } else {
                DynamicObject entryContract = entryRowEntity.getDynamicObject("entrycontract");
                boolean multipartSettlement = (entryContract = BusinessDataServiceHelper.loadSingle((Object)entryContract.getPkValue(), (String)"pmct_outcontract")).getBoolean("multipartsettlement");
                if (multipartSettlement) {
                    proIdSet = ContractHelper.getSharePermPros((IFormView)this.getView(), (DynamicObject)entryContract);
                    if (proIdSet == null || proIdSet.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PaymentRegisterEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                } else {
                    DynamicObject contProject = entryContract.getDynamicObject("project");
                    if (contProject == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9879\u76ee\u9884\u7b97\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PaymentRegisterEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    proIdSet = new HashSet(1);
                    proIdSet.add(contProject.getPkValue());
                }
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("project", "in", proIdSet));
            DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])qFilters.toArray(new QFilter[0]));
            List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                return children == null || children.length == 0;
            }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            filter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"contpro")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("entrycontract", beforeF7SelectEvent.getRow());
            if (contract != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(ContractHelper.getEntryProFilter((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (DynamicObject)contract));
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"payapplyno")) {
            this.beforePayApplyNoSelect(beforeF7SelectEvent);
        }
    }

    private void beforePayApplyNoSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject contPro;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Object orgId = ((DynamicObject)this.getModel().getValue("org")).getPkValue();
        filterList.add(new QFilter("org", "=", orgId));
        DynamicObject entryContract = (DynamicObject)this.getModel().getValue("entrycontract", beforeF7SelectEvent.getRow());
        if (entryContract != null) {
            Object contractId = entryContract.getPkValue();
            filterList.add(new QFilter("contract", "=", contractId));
        }
        if ((contPro = (DynamicObject)this.getModel().getValue("contpro", beforeF7SelectEvent.getRow())) != null) {
            filterList.add(new QFilter("contpro", "=", contPro.getPkValue()));
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private void changeBankInfo(DynamicObject supplier, int rowIndex) {
        if (supplier != null) {
            String entity = supplier.getDataEntityType().getName();
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)entity);
            DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
            DynamicObject defaultBankAccountInfo = null;
            for (int i = 0; i < bankColls.size(); ++i) {
                if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
                defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
            }
            if (defaultBankAccountInfo != null) {
                if (defaultBankAccountInfo.getDynamicObject("bank") != null) {
                    this.getModel().setValue("bankname", (Object)defaultBankAccountInfo.getDynamicObject("bank").getString("name"), rowIndex);
                }
                this.getModel().setValue("bankaccount", (Object)defaultBankAccountInfo.getString("bankaccount"), rowIndex);
            } else {
                this.getModel().setValue("bankaccount", null, rowIndex);
            }
        }
    }
}

