/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.revision;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.enums.pmct.ChangeTypeEnum;
import kd.pmgt.pmbs.common.enums.pmct.ContractChangeStandardEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.helper.ContractListHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractRevisionBillEditPlugin
extends AbstractPmctBillPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ContractRevisionBillEditPlugin.class);
    public static final BigDecimal MAX_CONTROL_DECIMAL = new BigDecimal("9999999999999.999");
    public static final BigDecimal MIN_CONTROL_DECIMAL = new BigDecimal("-9999999999999.999");
    public static final String CHANGEPAYPLAN = "changepayplan";
    public static final String CHANGEINCOMEPLAN = "changeincomeplan";
    private static final String JUMPTOUNAUDITCHANGE_CALLBACKID = "jumpToUnAuditChangeId";
    private static final String CHANGEID = "changeId";
    private static final String CUR_MODEL_ROW = "curModelRow";

    public void afterBindData(EventObject e) {
        int rowCount;
        String parentId;
        if (this.getView().getParentView() != null && StringUtils.equals((CharSequence)(parentId = this.getView().getParentView().getEntityId()), (CharSequence)"pmct_dynamiccontract")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
        if ((rowCount = this.getModel().getEntryRowCount("kapianentry")) == 1) {
            this.getPageCache().put(CUR_MODEL_ROW, "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"kapianentry"});
        }
        if (rowCount > 0) {
            CardEntry cardEntry = (CardEntry)this.getControl("kapianentry");
            cardEntry.selectRows(0);
            cardEntry.entryRowClick(Integer.valueOf(0));
        }
        if (this.isOutContract()) {
            ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
        } else {
            ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        }
        this.configChangeTypeSelectList();
        boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
        if (taxRateChange) {
            boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
            if (isMultiRate) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedtaxrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedtaxrate"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate", "changedtaxrate"});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject period = EcPeriodUtils.getCurrentPeriod();
        if (period != null) {
            this.getModel().setValue("period", period.getPkValue());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("kapianentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        String formId = this.getFormId();
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                if ("pmct_incontractrevision".equals(formId)) {
                    this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_incontract", (Object)beforeF7ViewDetailEvent.getPkId()));
                } else {
                    this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmct_outcontract", (Object)beforeF7ViewDetailEvent.getPkId()));
                }
            });
        }
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"kapianentry", (CharSequence)control.getKey())) {
            int curRowIndex = evt.getRow();
            this.getPageCache().put(CUR_MODEL_ROW, String.valueOf(curRowIndex));
            int size = this.getModel().getEntryRowCount("entryentity");
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                this.setSubChangeTypeEnable();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int rowIndex;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)key) && (rowIndex = this.getModel().getEntryCurrentRowIndex("kapianentry")) < 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u6e05\u5355\u6a21\u677f\u3002", (String)"ContractRevisionBillEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            DynamicObject contractf7 = this.getModel().getDataEntity().getDynamicObject("contract");
            contractf7 = BusinessDataServiceHelper.loadSingle((Object)contractf7.getPkValue(), (String)"pmct_contracttpl");
            DynamicObject contStatus = contractf7.getDynamicObject("contractstatus");
            List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            if (statusNums.contains(contStatus.getString("number"))) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractRevisionBillEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"deleteentry")) {
            this.summaryAmountToCardEntry(null);
            this.summaryAmountToHeadInfo();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"newentry")) {
            boolean taxRateChange;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.initEntryTaxRate(rowIndex);
            Object budgetitem = this.getModel().getValue("budgetitem");
            if (budgetitem != null) {
                this.getModel().setValue("listingbudgetitem", ((DynamicObject)budgetitem).getPkValue(), rowIndex);
            }
            if (taxRateChange = ((Boolean)this.getModel().getValue("taxratechange")).booleanValue()) {
                this.getModel().setValue("subchangetype", (Object)ChangeTypeEnum.TAXRATECHGANGE.getValue(), rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (JUMPTOUNAUDITCHANGE_CALLBACKID.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String changeId = this.getPageCache().get(CHANGEID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pkId", changeId);
            map.put("formId", this.getFormId());
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(map);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String property = e.getKey();
        int rowIndex = e.getRowIndex();
        Object newValue = e.getValue();
        switch (property) {
            case "oftax": 
            case "amount": {
                boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
                if (!isAdjustAmount) break;
                DynamicObjectCollection subEntries = this.getModel().getEntryEntity("entryentity");
                DynamicObject subEntry = (DynamicObject)subEntries.get(rowIndex);
                BigDecimal qty = subEntry.getBigDecimal("qty");
                BigDecimal priceOfTax = subEntry.getBigDecimal("hanshuidanj");
                BigDecimal price = subEntry.getBigDecimal("price");
                BigDecimal oldAmount = property.equalsIgnoreCase("amount") ? price.multiply(qty) : priceOfTax.multiply(qty);
                boolean isRollBack = ContractEditHelper.amountRollback((IFormView)this.getView(), (DynamicObject)subEntry, (Object)newValue, (Object)oldAmount, (String)property, (int)rowIndex);
                if (!isRollBack) break;
                this.getModel().updateEntryCache(subEntries);
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object propValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "contract": {
                this.contractChanged(e);
                break;
            }
            case "revisionoftaxamount": {
                this.revisionOfTaxAmountChanged();
                break;
            }
            case "revisionamount": {
                this.revisionAmountChanged();
                break;
            }
            case "taxrate": {
                this.taxRateChanged();
                break;
            }
            case "taxamount": {
                this.taxAmountChanged();
                break;
            }
            case "curbgse": {
                this.entryEntityCurbgseChanged(index);
                break;
            }
            case "changedtaxrate": {
                this.changedTaxRateChanged();
                break;
            }
            case "materiel": {
                this.materialChanged(e, index);
                break;
            }
            case "shouyingxsl": {
                this.effectedQtyChanged(e);
                this.effQtyOrChangedOfTaxPriceChanged(index);
                break;
            }
            case "subchangetype": {
                this.subChangedTypeChanged(e, propValue);
                break;
            }
            case "biangengsl": {
                this.changedQtyChanged(e);
                break;
            }
            case "biangenghouhsdj": {
                this.effQtyOrChangedOfTaxPriceChanged(index);
                break;
            }
            case "curbgbhsje": {
                this.effQtyOrChangedOfTaxPriceChanged(index);
                break;
            }
            case "hsbgje": {
                String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
                int parentModelRow = Integer.parseInt(curModelRow);
                if (!this.summaryAmountToCardEntry(null)) {
                    this.getModel().setValue("shouyingxsl", (Object)BigDecimal.ZERO, index, parentModelRow);
                    return;
                }
                if (this.summaryAmountToHeadInfo()) break;
                this.getModel().setValue("shouyingxsl", (Object)BigDecimal.ZERO, index, parentModelRow);
                break;
            }
            case "qty": 
            case "price": 
            case "taxrate1": {
                this.qtyOrPriceOrTaxrateChanged(index);
                break;
            }
            case "hanshuidanj": {
                this.ofTaxPriceChanged(index);
                break;
            }
            case "oftax": {
                this.ofTaxChanged(propValue, index);
                break;
            }
            case "amount": {
                this.amountChanged(propValue, index);
                break;
            }
            case "superlistingid": {
                this.superListingIdChanged(index, e.getChangeSet()[0]);
                break;
            }
            case "sysnum": {
                this.validateSysNum(e);
                break;
            }
            case "taxratechange": {
                this.taxRateChangeChanged(e);
                break;
            }
            case "changedrateobj": {
                this.rateObjChanged(e);
                break;
            }
            case "project": {
                this.projectChanged(propValue);
                break;
            }
            case "isadjustamount": {
                boolean isAdjustAmount = (Boolean)propValue;
                DynamicObjectCollection entityEntry = this.getModel().getDataEntity().getDynamicObjectCollection("kapianentry");
                if (isAdjustAmount) break;
                for (DynamicObject entity : entityEntry) {
                    DynamicObjectCollection subEntries = entity.getDynamicObjectCollection("entryentity");
                    boolean isEnterAmount = (Boolean)this.getModel().getValue("isenteramount");
                    boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                    ContractEditHelper.resetEntryAmountField((DynamicObjectCollection)subEntries, (boolean)isEnterAmount, (boolean)isOfTaxContract, (DynamicObject)currency, (String)"qty", (String)"oftax", (String)"amount", (String)"taxrate1", (String)"hanshuidanj", (String)"price", (String)"tax");
                    this.getModel().updateEntryCache(subEntries);
                    this.getView().updateView("entryentity");
                    int rowIndex = 0;
                    for (DynamicObject subEntry : subEntries) {
                        String subChangeType = subEntry.getString("subchangetype");
                        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
                            this.summaryAmountToSuperListing(rowIndex, -1);
                        }
                        ++rowIndex;
                    }
                }
                this.summaryAmountToCardEntry(null);
                this.summaryAmountToHeadInfo();
                break;
            }
            case "settledamt": 
            case "applytaxamount": 
            case "applyamount": 
            case "invoicetaxamount": 
            case "invoiceamount": {
                Boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
                Boolean isOnList = (Boolean)this.getModel().getValue("isbasedonlist");
                if (!taxRateChange.booleanValue() || !isOnList.booleanValue()) break;
                this.updateEntryAmountByChangeRate(index);
                break;
            }
        }
    }

    protected void projectChanged(Object newValue) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (contract != null) {
            if (newValue != null && !newValue.equals(contract.getDynamicObject("project"))) {
                this.getModel().setValue("contract", null);
            } else if (newValue == null) {
                this.getModel().setValue("contract", null);
            }
        }
    }

    protected void rateObjChanged(PropertyChangedArgs e) {
        boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
        if (taxRateChange) {
            BigDecimal taxrateValue = BigDecimal.ZERO;
            Object propValue = e.getChangeSet()[0].getNewValue();
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObject taxRateObj = (DynamicObject)propValue;
            if (taxRateObj != null) {
                taxrateValue = taxRateObj.getBigDecimal("taxrate");
            }
            this.getModel().setValue("changedtaxrate1", (Object)taxrateValue, index);
            BigDecimal taxRate1 = (BigDecimal)this.getModel().getValue("taxrate1", index);
            if (taxRate1 == null) {
                taxRate1 = BigDecimal.ZERO;
            }
            if (taxrateValue.compareTo(taxRate1) == 0) {
                BigDecimal changedPriceOfTax = (BigDecimal)this.getModel().getValue("hanshuidanj", index);
                this.getModel().setValue("curbgse", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("biangenghouhsdj", (Object)changedPriceOfTax, index);
                this.updateEntryAmountByChangeRate(index);
            } else {
                this.updateEntryAmountByChangeRate(index);
            }
        }
    }

    protected void taxRateChangeChanged(PropertyChangedArgs e) {
        Object propValue = e.getChangeSet()[0].getNewValue();
        this.configChangeTypeSelectList();
        this.clearTaxRateChangeData();
        boolean taxRateChange = (Boolean)propValue;
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
        if (taxRateChange) {
            if (isMultiRate) {
                BigDecimal avgTaxrate = (BigDecimal)this.getModel().getValue("avgtaxrate");
                this.getModel().setValue("changedavgtaxrate", (Object)avgTaxrate);
                BigDecimal srcTaxAmount = (BigDecimal)this.getModel().getValue("srctaxamount");
                BigDecimal srcAmount = (BigDecimal)this.getModel().getValue("srcamount");
                this.getModel().setValue("avgtaxrate", (Object)this.getTaxRateByAmount(srcAmount, srcTaxAmount));
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedtaxrate"});
                if (Boolean.TRUE.equals(isOfTaxContract)) {
                    boolean isBasedOnList = (Boolean)this.getModel().getValue("isbasedonlist");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionoftaxamount"});
                    if (isBasedOnList) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"revisionamount"});
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"revisionamount"});
                    }
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionamount"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount"});
                }
            } else {
                this.doloadAllConEntry();
                DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrate");
                this.getModel().setValue("changedtaxrate", (Object)taxrate);
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedtaxrate"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"revisionoftaxamount"});
            }
        } else {
            this.getModel().setValue("changedavgtaxrate", (Object)0);
            this.getModel().setValue("changedtaxrate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate", "changedtaxrate"});
            if (isMultiRate) {
                boolean isBasedOnList = (Boolean)this.getModel().getValue("isbasedonlist");
                if (!isBasedOnList) {
                    this.getModel().setValue("revisionoftaxamount", (Object)0);
                    this.getModel().setValue("revisionamount", (Object)0);
                    this.getModel().setValue("taxamount", (Object)0);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"revisionamount"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionoftaxamount"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionamount"});
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount"});
            }
        }
    }

    protected void clearTaxRateChangeData() {
        int rowCount = this.getModel().getEntryRowCount("kapianentry");
        EntryGrid control = (EntryGrid)this.getControl("kapianentry");
        for (int j = rowCount - 1; j >= 0; --j) {
            control.selectRows(j);
            this.getModel().deleteEntryData("entryentity");
            this.summaryAmountToCardEntry(String.valueOf(j));
            this.summaryAmountToHeadInfo();
        }
    }

    protected void doloadAllConEntry() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (null == contract) {
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        int rowCount = this.getModel().getEntryRowCount("kapianentry");
        EntryGrid control = (EntryGrid)this.getControl("kapianentry");
        for (int i = rowCount - 1; i >= 0; --i) {
            control.selectRows(i);
            this.getPageCache().put(CUR_MODEL_ROW, String.valueOf(i));
            this.doloadCurrentSelectEntry(contract, i);
        }
    }

    protected void doloadCurrentSelectEntry(DynamicObject contract, int rowIndex) {
        DynamicObject[] conList;
        this.getModel().deleteEntryData("entryentity");
        Object listModelId = this.getModel().getValue("listmodelid", rowIndex);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("listingmodel", "=", (Object)listModelId.toString()));
        qFilters.add(new QFilter("contractid", "=", (Object)contract.getString("id")));
        qFilters.add(new QFilter("isleaf", "=", (Object)DefaultEnum.YES.getValue()));
        String selectProperties = "id";
        for (DynamicObject list : conList = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[0]))) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("subchangetype", (Object)ChangeTypeEnum.TAXRATECHGANGE.getValue(), index);
            this.getModel().setValue("listid", (Object)list, index);
        }
    }

    protected void configChangeTypeSelectList() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
        ComboEdit comboEdit = (ComboEdit)this.getControl("subchangetype");
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List selectValues = property.getComboItems();
        if (taxRateChange) {
            for (ValueMapItem selectValue : selectValues) {
                if (!selectValue.getValue().equals(ChangeTypeEnum.TAXRATECHGANGE.getValue())) continue;
                comboItems.add(new ComboItem(selectValue.getName(), selectValue.getValue()));
                break;
            }
        } else {
            for (ValueMapItem selectValue : selectValues) {
                if (selectValue.getValue().equals(ChangeTypeEnum.TAXRATECHGANGE.getValue())) continue;
                comboItems.add(new ComboItem(selectValue.getName(), selectValue.getValue()));
            }
        }
        comboEdit.setComboItems(comboItems);
    }

    private void validateSysNum(PropertyChangedArgs e) {
        String jumpPropertyChangeEvent = this.getView().getPageCache().get("jumpPropertyChangeEvent");
        if (StringUtils.equals((CharSequence)jumpPropertyChangeEvent, (CharSequence)"true")) {
            this.getView().getPageCache().remove("jumpPropertyChangeEvent");
            return;
        }
        Object propValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        HashSet<String> sysNumSet = new HashSet<String>();
        DynamicObjectCollection listmodelEntry = this.getModel().getEntryEntity("kapianentry");
        DynamicObject currentListModel = (DynamicObject)listmodelEntry.get(parentModelRow);
        DynamicObjectCollection entryEntity = currentListModel.getDynamicObjectCollection("entryentity");
        DynamicObject subEntryObj = (DynamicObject)entryEntity.get(rowIndex);
        String changeType = subEntryObj.getString("subchangetype");
        if (StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) || StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) {
            DynamicObject[] listings;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryEntityObj;
                String sysNumber;
                if (i == rowIndex || !StringUtils.isNotEmpty((CharSequence)(sysNumber = (entryEntityObj = (DynamicObject)entryEntity.get(i)).getString("sysnum")))) continue;
                sysNumSet.add(sysNumber);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put("jumpPropertyChangeEvent", "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ContractRevisionBillEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            Object listModelId = this.getModel().getValue("listmodelid", parentModelRow);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            for (DynamicObject listing : listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
                String listSysNum = listing.getString("sysnumber");
                if (!StringUtils.isNotEmpty((CharSequence)listSysNum)) continue;
                sysNumSet.add(listSysNum);
            }
            if (propValue != null && sysNumSet.contains(propValue.toString())) {
                this.getView().getPageCache().put("jumpPropertyChangeEvent", "true");
                this.getModel().setValue("sysnum", oldValue, rowIndex, parentModelRow);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u6539\u56de\u539f\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ContractRevisionBillEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), propValue, oldValue));
            }
        }
    }

    private void initEntryTaxRate(int rowIndex) {
        int parentRow = this.getModel().getEntryCurrentRowIndex("kapianentry");
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
        String changeType = (String)this.getModel().getValue("subchangetype", rowIndex);
        if (!isMultiRate && taxRateObj != null && !StringUtils.equals((CharSequence)changeType, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) {
            taxRateObj = BusinessDataServiceHelper.loadSingle((Object)taxRateObj.getPkValue(), (String)"bd_taxrate");
            BigDecimal rate = taxRateObj.getBigDecimal("taxrate");
            this.getModel().setValue("rateobj", taxRateObj.getPkValue(), rowIndex, parentRow);
            this.getModel().setValue("taxrate1", (Object)rate, rowIndex, parentRow);
        }
    }

    private void superListingIdChanged(int index, ChangeData changeData) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int parentRowIndex = -1;
        int oldParentRowIndex = -1;
        for (int i = 0; i < rowCount; ++i) {
            long newLong;
            long newListingId = (Long)this.getModel().getValue("newlistingid", i);
            if (oldValue != null) {
                long newLong2;
                long oldLong = Long.parseLong(oldValue.toString());
                if (oldLong != 0L && newListingId == oldLong) {
                    oldParentRowIndex = i;
                    continue;
                }
                if (newValue == null || (newLong2 = Long.parseLong(newValue.toString())) == 0L || newListingId != newLong2) continue;
                parentRowIndex = i;
                continue;
            }
            if (newValue == null || (newLong = Long.parseLong(newValue.toString())) == 0L || newListingId != newLong) continue;
            parentRowIndex = i;
        }
        if (parentRowIndex != -1) {
            this.summaryAmountToSuperListing(index, parentRowIndex);
        }
        if (oldParentRowIndex != -1) {
            this.summaryAmountToSuperListing(index, oldParentRowIndex);
        }
    }

    private void materialChanged(PropertyChangedArgs e, int index) {
        DynamicObject material = (DynamicObject)e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        IDataModel model = this.getModel();
        int currentIndex = model.getEntryCurrentRowIndex("entryentity");
        String subChangeType = (String)model.getValue("subchangetype", currentIndex);
        if (material != null) {
            model.setValue("subchangetype", (Object)subChangeType, index);
            if (model.getValue("materiel", index) == null) {
                model.setValue("materiel", material.getPkValue(), index);
                return;
            }
            String name = material.getLocaleString("name").getLocaleValue();
            String number = material.getString("number");
            model.setValue("listname", (Object)name, index);
            model.setValue("listnumber", (Object)number, index);
            DynamicObject measureunit = material.getDynamicObject("baseunit");
            if (measureunit != null) {
                model.setValue("measureunit", measureunit.getPkValue(), index);
            }
            model.setValue("qty", null, index);
            model.setValue("price", null, index);
            model.setValue("hanshuidanj", null, index);
            model.setValue("oftax", null, index);
            if (oldValue != null) {
                model.setValue("superlistingname", null, index);
                model.setValue("superlistingid", null, index);
            }
            model.setValue("remark", null, index);
        } else {
            model.setValue("listname", null, index);
            model.setValue("listnumber", null, index);
            model.setValue("measureunit", null, index);
            model.setValue("qty", null, index);
            model.setValue("price", null, index);
            model.setValue("hanshuidanj", null, index);
            model.setValue("oftax", null, index);
            model.setValue("remark", null, index);
        }
    }

    private void contractChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject newContract = (DynamicObject)e.getChangeSet()[0].getNewValue();
        model.setValue("revisionoftaxamount", (Object)0);
        model.setValue("revisionamount", (Object)0);
        model.setValue("taxamount", (Object)0);
        model.setValue("srcamountoftax", (Object)0);
        model.setValue("srctaxamount", (Object)0);
        model.setValue("srcamount", (Object)0);
        model.setValue("latestamountoftax", (Object)0);
        model.setValue("latesttaxamount", (Object)0);
        model.setValue("latestamount", (Object)0);
        boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
        if (newContract == null) {
            model.setValue("taxrate", null);
            model.setValue("avgtaxrate", (Object)0);
            model.setValue("changedtaxrate", null);
            model.setValue("changedavgtaxrate", (Object)0);
            model.setValue("isbasedonlist", (Object)Boolean.FALSE);
            model.deleteEntryData("kapianentry");
            if (StringUtils.equals((CharSequence)"pmct_outcontractrevision", (CharSequence)this.getFormId())) {
                model.deleteEntryData("changepayplanentry");
            } else if (StringUtils.equals((CharSequence)"pmct_incontractrevision", (CharSequence)this.getFormId())) {
                model.deleteEntryData("incomeplanentry");
            }
            model.setValue("contattr", null);
            this.getModel().setValue("changestandard", null);
            boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
            if (taxRateChange) {
                if (isMultiRate) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"changedavgtaxrate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"changedtaxrate"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"changedtaxrate"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate", "changedtaxrate"});
            }
            return;
        }
        if (this.checkContractMutex(model, dataEntity, newContract = BusinessDataServiceHelper.loadSingle((Object)newContract.getPkValue(), (String)"pmct_contracttpl"))) {
            if (StringUtils.equals((CharSequence)"pmct_outcontractrevision", (CharSequence)this.getFormId())) {
                model.deleteEntryData("changepayplanentry");
            } else if (StringUtils.equals((CharSequence)"pmct_incontractrevision", (CharSequence)this.getFormId())) {
                model.deleteEntryData("incomeplanentry");
            }
            this.setCurrencyFlexSpace(newContract);
            return;
        }
        this.setCurrencyFlexSpace(newContract);
        this.getModel().setValue("changestandard", newContract.get("changestandard"));
        DynamicObject project = newContract.getDynamicObject("project");
        if (project != null) {
            model.setValue("project", project.getPkValue(), 0);
        } else {
            model.setValue("project", null);
        }
        boolean isMultiRate = newContract.getBoolean("ismultirate");
        model.setValue("ismultirate", (Object)isMultiRate);
        DynamicObject taxRate = newContract.getDynamicObject("lsttaxrate");
        if (taxRate != null) {
            model.setValue("taxrate", taxRate.getPkValue(), 0);
        }
        if (isMultiRate) {
            model.setValue("taxrate", null);
            model.setValue("avgtaxrate", newContract.get("lstavgtaxrate"));
        }
        BigDecimal totalOfTaxAmount = newContract.getBigDecimal("totaloftaxamount");
        BigDecimal totalAmount = newContract.getBigDecimal("totalamount");
        BigDecimal srcTaxAmount = NumberHelper.subtract((Object)totalOfTaxAmount, (Object)totalAmount);
        model.setValue("srcamountoftax", (Object)totalOfTaxAmount);
        model.setValue("srctaxamount", (Object)srcTaxAmount);
        model.setValue("srcamount", (Object)totalAmount);
        model.setValue("latestamountoftax", (Object)totalOfTaxAmount);
        model.setValue("latesttaxamount", (Object)srcTaxAmount);
        model.setValue("latestamount", (Object)totalAmount);
        DynamicObject contractType = newContract.getDynamicObject("contracttype");
        boolean isOnList = newContract.getBoolean("isonlist");
        model.setValue("isbasedonlist", (Object)isOnList);
        this.isBaseList(model, contractType, isOnList);
        this.loadChangePlanEntry(model, newContract);
        if (StringUtils.equals((CharSequence)"pmct_incontractrevision", (CharSequence)this.getFormId())) {
            FieldEdit control = (FieldEdit)this.getControl("revisionoftaxamount");
            control.setMustInput(!isOnList);
        }
        if (!isOnList) {
            if (taxRateChange) {
                if (isMultiRate) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionamount"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"revisionoftaxamount"});
                }
            } else if (isMultiRate) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount", "revisionamount"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"revisionoftaxamount"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"revisionamount"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"revisionoftaxamount", "revisionamount"});
        }
        if (taxRateChange) {
            if (isMultiRate) {
                model.setValue("changedavgtaxrate", newContract.get("lstavgtaxrate"));
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedtaxrate"});
            } else {
                this.doloadAllConEntry();
                model.setValue("changedtaxrate", taxRate != null ? taxRate.getPkValue() : null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"changedtaxrate"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"changedavgtaxrate", "changedtaxrate"});
        }
    }

    private void setCurrencyFlexSpace(DynamicObject newContract) {
        boolean isMultiCurrency = this.getModel().getDataEntity().getBoolean("ismulticurrency");
        if (newContract != null) {
            isMultiCurrency = newContract.getBoolean("ismulticurrency");
        }
        if (isMultiCurrency) {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
            ctrl = new HashMap();
            marginMap = new HashMap();
            styleMap = new HashMap();
            marginMap.put("l", "5px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("stdcurrencyinfo", ctrl);
        } else {
            HashMap ctrl = new HashMap();
            HashMap<String, String> marginMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
            marginMap.put("r", "0px");
            styleMap.put("m", marginMap);
            ctrl.put("s", styleMap);
            this.getView().updateControlMetadata("amountinfo", ctrl);
        }
    }

    private void loadChangePlanEntry(IDataModel model, DynamicObject newContract) {
        if (this.isOutContract()) {
            this.loadOutChangePlanEntry(model, newContract);
        } else {
            this.loadIncomeChangePlanEntry(model, newContract);
        }
    }

    private void loadIncomeChangePlanEntry(IDataModel model, DynamicObject newContract) {
        QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue()).and(new QFilter("autogenerated", "=", (Object)Boolean.FALSE));
        contractFilter = contractFilter.and(new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue()));
        String selectProperties = String.join((CharSequence)",", "customer", "collecttype", "collectfeq", "collectway", "collectpercent", "collectamount", "plancollecttime", "remarks", "sourcebill", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
        DynamicObject[] collectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter}, (String)"createtime asc");
        DynamicObjectCollection changeIncomePlanEntity = model.getEntryEntity("incomeplanentry");
        changeIncomePlanEntity.clear();
        for (DynamicObject collectItem : collectItems) {
            DynamicObject changeIncomePlanObj = changeIncomePlanEntity.addNew();
            changeIncomePlanObj.set("customer", (Object)collectItem.getDynamicObject("customer"));
            changeIncomePlanObj.set("incometype", (Object)collectItem.getString("collecttype"));
            changeIncomePlanObj.set("incomefeq", (Object)collectItem.getString("collectfeq"));
            changeIncomePlanObj.set("incomeway", (Object)collectItem.getDynamicObject("collectway"));
            changeIncomePlanObj.set("incomepercent", (Object)collectItem.getBigDecimal("collectpercent"));
            changeIncomePlanObj.set("incomeamountoftax", (Object)collectItem.getBigDecimal("collectamount"));
            changeIncomePlanObj.set("planincometime", (Object)collectItem.getDate("plancollecttime"));
            changeIncomePlanObj.set("remarks", (Object)collectItem.getString("remarks"));
            changeIncomePlanObj.set("conplanitemid", (Object)collectItem.getString("id"));
            changeIncomePlanObj.set("incomeplansourceid", (Object)collectItem.getString("sourcebill"));
            DynamicObject nodeSetting = collectItem.getDynamicObject("nodesetting");
            changeIncomePlanObj.set("nodesetting", (Object)nodeSetting);
            if (null != nodeSetting && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                changeIncomePlanObj.set("taskcompletestate", (Object)status);
            }
            changeIncomePlanObj.set("nodesettingsource", (Object)collectItem.getString("nodesettingsource"));
            changeIncomePlanObj.set("ctrlstrategy", (Object)collectItem.getString("ctrlstrategy"));
            changeIncomePlanObj.set("incomeitemname", (Object)collectItem.getString("name"));
        }
        for (int i = 0; i < changeIncomePlanEntity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"customer"});
            DynamicObject entryEntity = (DynamicObject)changeIncomePlanEntity.get(i);
            if (null != entryEntity.get("nodesetting")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
        }
        this.getView().updateView("incomeplanentry");
    }

    private void loadOutChangePlanEntry(IDataModel model, DynamicObject newContract) {
        QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)Boolean.FALSE);
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        String selectProperties = String.join((CharSequence)",", "supplier", "paytype", "payfeq", "payway", "paypercent", "payamount", "planpaytime", "remarks", "payplanentryid", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter}, (String)"createtime asc");
        if (payItems.length <= 0) {
            model.deleteEntryData("changepayplanentry");
            return;
        }
        DynamicObjectCollection changePayPlanEntryEntity = model.getEntryEntity("changepayplanentry");
        changePayPlanEntryEntity.clear();
        for (DynamicObject payItem : payItems) {
            DynamicObject changePayPlanObj = changePayPlanEntryEntity.addNew();
            changePayPlanObj.set("supplier", payItem.get("supplier"));
            changePayPlanObj.set("paytype", (Object)payItem.getString("paytype"));
            changePayPlanObj.set("payfeq", (Object)payItem.getString("payfeq"));
            changePayPlanObj.set("payway", (Object)payItem.getDynamicObject("payway"));
            changePayPlanObj.set("paypercent", (Object)payItem.getBigDecimal("paypercent"));
            changePayPlanObj.set("payamountoftax", (Object)payItem.getBigDecimal("payamount"));
            changePayPlanObj.set("planpaytime", (Object)payItem.getDate("planpaytime"));
            changePayPlanObj.set("remarks", (Object)payItem.getString("remarks"));
            changePayPlanObj.set("conplanitemid", (Object)payItem.getString("id"));
            changePayPlanObj.set("payplansourceid", (Object)payItem.getString("payplanentryid"));
            DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
            changePayPlanObj.set("nodesetting", (Object)nodeSetting);
            if (null != nodeSetting && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                changePayPlanObj.set("taskcompletestate", (Object)status);
            }
            changePayPlanObj.set("nodesettingsource", (Object)payItem.getString("nodesettingsource"));
            changePayPlanObj.set("ctrlstrategy", (Object)payItem.getString("ctrlstrategy"));
            changePayPlanObj.set("conplanitemid", (Object)payItem.getPkValue().toString());
            String payItemName = payItem.getLocaleString("name").getLocaleValue();
            if (StringUtils.isBlank((CharSequence)payItemName)) {
                payItemName = payItem.getString("name");
            }
            changePayPlanObj.set("payitemname", (Object)payItemName);
        }
        boolean isMultiContract = newContract.getBoolean("ismulticontract");
        for (int i = 0; i < changePayPlanEntryEntity.size(); ++i) {
            DynamicObject entryEntity;
            if (!isMultiContract) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"supplier"});
            }
            if (null != (entryEntity = (DynamicObject)changePayPlanEntryEntity.get(i)).get("nodesetting")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
        }
        this.getView().updateView("changepayplanentry");
    }

    private void isBaseList(IDataModel model, DynamicObject contractType, boolean isonlist) {
        if (isonlist) {
            if (contractType != null) {
                DynamicObjectCollection listConfigs = ContractTypeUtils.getListConfigs((DynamicObject)contractType);
                if (listConfigs == null || listConfigs.size() <= 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u914d\u7f6e\u5f53\u524d\u5408\u540c\u7c7b\u578b\u7684\u6e05\u5355\u3002", (String)"ContractRevisionBillEditPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                model.deleteEntryData("kapianentry");
                for (DynamicObject listConfig : listConfigs) {
                    String tabname = listConfig.getString("tabname");
                    String cmpRule = listConfig.getString("computerule");
                    int rowIndex = model.createNewEntryRow("kapianentry");
                    model.setValue("modelname", (Object)tabname, rowIndex);
                    model.setValue("listmodelid", listConfig.getPkValue(), rowIndex);
                    if (StringUtils.equals((CharSequence)"00", (CharSequence)cmpRule)) {
                        model.setValue("cmptype", (Object)"(+)", rowIndex);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"01", (CharSequence)cmpRule)) {
                        model.setValue("cmptype", (Object)"(-)", rowIndex);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"02", (CharSequence)cmpRule)) continue;
                    model.setValue("cmptype", (Object)"(0)", rowIndex);
                }
                CardEntry cardEntry = (CardEntry)this.getControl("kapianentry");
                cardEntry.selectRows(0);
                if (listConfigs.size() == 1) {
                    this.getPageCache().put(CUR_MODEL_ROW, "0");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"kapianentry"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"kapianentry"});
                }
            }
        } else {
            model.deleteEntryData("kapianentry");
        }
    }

    private boolean checkContractMutex(IDataModel model, DynamicObject dataEntity, DynamicObject newContract) {
        QFilter contractFilter = new QFilter("contract", "=", newContract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "not in", (Object)StatusEnum.CHECKED.getValue());
        QFilter idFilter = new QFilter("id", "not in", dataEntity.getPkValue());
        DynamicObject[] notAuditChanges = BusinessDataServiceHelper.load((String)this.getFormId(), (String)"id,billno,billname", (QFilter[])new QFilter[]{contractFilter, billStatusFilter, idFilter});
        if (notAuditChanges != null && notAuditChanges.length > 0) {
            model.setValue("contract", null);
            this.getPageCache().put(CHANGEID, notAuditChanges[0].get("id").toString());
            ConfirmCallBackListener jumpToUnAuditChangeId = new ConfirmCallBackListener(JUMPTOUNAUDITCHANGE_CALLBACKID, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u53d8\u66f4\u5355\u3002\u662f\u5426\u8df3\u8f6c\u5230\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u8fdb\u884c\u5904\u7406\uff1f", (String)"ContractRevisionBillEditPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, jumpToUnAuditChangeId);
            return true;
        }
        DynamicObject[] notAuditRevision = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"billno", (QFilter[])new QFilter[]{contractFilter, billStatusFilter});
        if (notAuditRevision != null && notAuditRevision.length > 0) {
            model.setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u53d8\u66f4\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4fee\u8ba2\u5355\uff0c\u8bf7\u5f85\u4fee\u8ba2\u5355\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ContractRevisionBillEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        String formId = this.getView().getFormShowParameter().getFormId();
        String claimFormBillId = null;
        String contAddAgreementFormId = null;
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incontractrevision")) {
            claimFormBillId = "pmct_inclaimbill";
            contAddAgreementFormId = "pmct_inaddagreement";
        } else if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontractrevision")) {
            claimFormBillId = "pmct_outclaimbill";
            contAddAgreementFormId = "pmct_outaddagreement";
        }
        DynamicObject[] inClaims = BusinessDataServiceHelper.load((String)claimFormBillId, (String)"id", (QFilter[])new QFilter[]{billStatusFilter, isNeedSettleFilter, contractFilter});
        if (inClaims.length > 0) {
            model.setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u53d8\u66f4\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7d22\u8d54\u5355\uff0c\u8bf7\u5f85\u7d22\u8d54\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"ContractRevisionBillEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject[] contAddAgreement = BusinessDataServiceHelper.load((String)contAddAgreementFormId, (String)"id", (QFilter[])new QFilter[]{billStatusFilter, contractFilter});
        if (contAddAgreement.length > 0) {
            model.setValue("contract", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u53d8\u66f4\u5355\uff0c\u56e0\u4e3a\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8865\u5145\u534f\u8bae\uff0c\u8bf7\u5f85\u8865\u5145\u534f\u8bae\u5b8c\u6210\u4e4b\u540e\u518d\u8fdb\u884c\u5904\u7406\u3002", (String)"ContractRevisionBillEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void revisionOfTaxAmountChanged() {
        IDataModel model = this.getModel();
        BigDecimal revisionOfTaxAmount = (BigDecimal)model.getValue("revisionoftaxamount");
        boolean isMultirate = (Boolean)model.getValue("ismultirate");
        DynamicObject taxRateObject = (DynamicObject)model.getValue("taxrate");
        if (!isMultirate && taxRateObject != null) {
            BigDecimal taxRate = taxRateObject.getBigDecimal("taxrate");
            boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
            BigDecimal revisionAmount = BigDecimal.ZERO;
            if (!taxRateChange) {
                revisionAmount = this.getWithoutTaxValue(taxRate, revisionOfTaxAmount);
            }
            BigDecimal taxAmount = revisionOfTaxAmount.subtract(revisionAmount);
            model.setValue("revisionamount", (Object)revisionAmount);
            model.setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)revisionOfTaxAmount));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)revisionAmount));
        } else if (isMultirate) {
            BigDecimal revisionAmount = (BigDecimal)model.getValue("revisionamount");
            BigDecimal taxAmount = revisionOfTaxAmount.subtract(revisionAmount);
            model.setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)revisionOfTaxAmount));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)revisionAmount));
            boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
            if (taxRateChange) {
                if (taxAmount != null && revisionAmount != null) {
                    model.setValue("changedavgtaxrate", (Object)this.getTaxRateByAmount(NumberHelper.add((Object)srcAmount, (Object)revisionAmount), NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount)));
                }
            } else if (taxAmount != null && revisionAmount != null) {
                model.setValue("avgtaxrate", (Object)this.getTaxRateByAmount(NumberHelper.add((Object)srcAmount, (Object)revisionAmount), NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount)));
            }
        }
    }

    private void revisionAmountChanged() {
        IDataModel model = this.getModel();
        boolean isMultiRate = (Boolean)this.getModel().getValue("ismultirate");
        if (isMultiRate) {
            BigDecimal revisionOfTaxAmount = (BigDecimal)this.getModel().getValue("revisionoftaxamount");
            BigDecimal revisionAmount = (BigDecimal)this.getModel().getValue("revisionamount");
            BigDecimal taxAmount = revisionOfTaxAmount.subtract(revisionAmount);
            this.getModel().setValue("taxamount", (Object)taxAmount);
            BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
            BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
            BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
            model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)revisionOfTaxAmount));
            model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
            model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)revisionAmount));
            this.getModel().setValue("changedavgtaxrate", (Object)this.getTaxRateByAmount(NumberHelper.add((Object)srcAmount, (Object)revisionAmount), NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount)));
        }
    }

    private void taxRateChanged() {
        DynamicObject taxRateObject = (DynamicObject)this.getModel().getValue("taxrate");
        if (taxRateObject != null) {
            boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
            boolean isBasedOnList = (Boolean)this.getModel().getValue("isbasedonlist");
            if (isBasedOnList || !isBasedOnList && !taxRateChange) {
                BigDecimal revisionOfTaxAmount = (BigDecimal)this.getModel().getValue("revisionoftaxamount");
                BigDecimal revisionAmount = this.getWithoutTaxValue(taxRateObject.getBigDecimal("taxrate"), revisionOfTaxAmount);
                BigDecimal taxAmount = revisionOfTaxAmount.subtract(revisionAmount);
                this.getModel().setValue("revisionamount", (Object)revisionAmount);
                this.getModel().setValue("taxamount", (Object)taxAmount);
            }
        }
    }

    private void taxAmountChanged() {
        Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
        if (Boolean.TRUE.equals(isOfTaxContract)) {
            BigDecimal revisionOfTaxAmount = (BigDecimal)this.getModel().getValue("revisionoftaxamount");
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount");
            BigDecimal srcamount = (BigDecimal)this.getModel().getValue("srcamount");
            BigDecimal srctaxamount = (BigDecimal)this.getModel().getValue("srctaxamount");
            this.getModel().setValue("revisionamount", (Object)revisionOfTaxAmount.subtract(taxAmount));
            this.getModel().setValue("latestamount", (Object)srcamount.add(revisionOfTaxAmount.subtract(taxAmount)));
            this.getModel().setValue("latesttaxamount", (Object)srctaxamount.add(taxAmount));
        } else {
            BigDecimal revisionAmount = (BigDecimal)this.getModel().getValue("revisionamount");
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount");
            BigDecimal srcamountoftax = (BigDecimal)this.getModel().getValue("srcamountoftax");
            this.getModel().setValue("revisionoftaxamount", (Object)revisionAmount.add(taxAmount));
            BigDecimal srctaxamount = (BigDecimal)this.getModel().getValue("srctaxamount");
            this.getModel().setValue("latestamountoftax", (Object)srcamountoftax.add(revisionAmount.add(taxAmount)));
            this.getModel().setValue("latesttaxamount", (Object)srctaxamount.add(taxAmount));
        }
    }

    private void entryEntityCurbgseChanged(int index) {
        Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
        BigDecimal curbgse = (BigDecimal)this.getModel().getValue("curbgse", index);
        if (Boolean.TRUE.equals(isOfTaxContract)) {
            BigDecimal hsbgje = (BigDecimal)this.getModel().getValue("hsbgje", index);
            this.getModel().setValue("curbgbhsje", (Object)hsbgje.subtract(curbgse), index);
        } else {
            BigDecimal curbgbhsje = (BigDecimal)this.getModel().getValue("curbgbhsje", index);
            this.getModel().setValue("hsbgje", (Object)curbgbhsje.add(curbgse));
            BigDecimal ofTax = (BigDecimal)this.getModel().getValue("oftax", index);
            this.getModel().setValue("bghhszje", (Object)ofTax.add(curbgbhsje.add(curbgse)), index);
        }
    }

    protected void changedTaxRateChanged() {
        DynamicObject changedTaxRateObj = (DynamicObject)this.getModel().getValue("changedtaxrate");
        boolean taxRateChange = (Boolean)this.getModel().getValue("taxratechange");
        BigDecimal curTaxrate = BigDecimal.ZERO;
        if (changedTaxRateObj != null) {
            curTaxrate = changedTaxRateObj.getBigDecimal("taxrate");
        }
        if (taxRateChange) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (null == contract) {
                return;
            }
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
            DynamicObject currency = contract.getDynamicObject("currency");
            int amtPrecision = currency == null ? 4 : currency.getInt("amtprecision");
            boolean isBasedOnList = (Boolean)this.getModel().getValue("isbasedonlist");
            Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
            if (!isBasedOnList) {
                DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue("taxrate");
                BigDecimal oriTaxRate = BigDecimal.ZERO;
                if (taxRateObj != null) {
                    oriTaxRate = taxRateObj.getBigDecimal("taxrate");
                }
                if (oriTaxRate.compareTo(curTaxrate) != 0) {
                    BigDecimal srcTaxAmount = (BigDecimal)this.getModel().getValue("srctaxamount");
                    BigDecimal srcAmount = (BigDecimal)this.getModel().getValue("srcamount");
                    if (Boolean.TRUE.equals(isOfTaxContract)) {
                        BigDecimal srcAmountOfTax = (BigDecimal)this.getModel().getValue("srcamountoftax");
                        BigDecimal taxAmountByStandard = this.getTaxAmountByStandard(contract, isOfTaxContract);
                        BigDecimal currRate = BigDecimal.ONE.add(curTaxrate.divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP));
                        BigDecimal currAmt = srcAmountOfTax.subtract(taxAmountByStandard).divide(currRate, amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal preRate = BigDecimal.ONE.add(oriTaxRate.divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP));
                        BigDecimal preAmt = srcAmountOfTax.subtract(taxAmountByStandard).divide(preRate, amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal revisionAmount = currAmt.subtract(preAmt);
                        this.getModel().setValue("revisionoftaxamount", (Object)0);
                        this.getModel().setValue("revisionamount", (Object)revisionAmount);
                        this.getModel().beginInit();
                        this.getModel().setValue("taxamount", (Object)BigDecimal.ZERO.subtract(revisionAmount));
                        this.getModel().endInit();
                        this.getView().updateView("taxamount");
                        this.getModel().setValue("latesttaxamount", (Object)srcTaxAmount.add(BigDecimal.ZERO.subtract(revisionAmount)));
                        this.getModel().setValue("latestamount", (Object)srcAmount.add(revisionAmount));
                    } else {
                        BigDecimal taxAmountByStandard = this.getTaxAmountByStandard(contract, isOfTaxContract);
                        BigDecimal currRate = curTaxrate.divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal currAmt = srcAmount.subtract(taxAmountByStandard).multiply(currRate);
                        BigDecimal preRate = oriTaxRate.divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal preAmt = srcAmount.subtract(taxAmountByStandard).multiply(preRate);
                        BigDecimal revisionTaxAmount = currAmt.subtract(preAmt);
                        this.getModel().setValue("revisionamount", (Object)0);
                        this.getModel().setValue("revisionoftaxamount", (Object)revisionTaxAmount);
                        this.getModel().beginInit();
                        this.getModel().setValue("taxamount", (Object)revisionTaxAmount.subtract(BigDecimal.ZERO));
                        this.getModel().endInit();
                        this.getView().updateView("taxamount");
                        this.getModel().setValue("latesttaxamount", (Object)srcTaxAmount.add(revisionTaxAmount.subtract(BigDecimal.ZERO)));
                        this.getModel().setValue("latestamount", (Object)srcAmount);
                    }
                } else {
                    this.getModel().setValue("revisionoftaxamount", (Object)0);
                    this.getModel().setValue("revisionamount", (Object)0);
                    this.getModel().setValue("taxamount", (Object)0);
                }
            }
            int rowCount = this.getModel().getEntryRowCount("kapianentry");
            EntryGrid control = (EntryGrid)this.getControl("kapianentry");
            for (int j = rowCount - 1; j >= 0; --j) {
                control.selectRows(j);
                this.getPageCache().put(CUR_MODEL_ROW, String.valueOf(j));
                int size = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < size; ++i) {
                    IDataModel model = this.getModel();
                    model.beginInit();
                    model.setValue("changedrateobj", (Object)changedTaxRateObj, i);
                    model.setValue("changedtaxrate1", (Object)curTaxrate, i);
                    model.endInit();
                    this.getView().updateView("changedrateobj", i);
                    this.getView().updateView("changedtaxrate1", i);
                    this.updateEntryAmountByChangeRate(i);
                }
            }
        } else {
            boolean isBasedOnList = (Boolean)this.getModel().getValue("isbasedonlist");
            if (!isBasedOnList) {
                this.getModel().setValue("revisionoftaxamount", (Object)0);
                this.getModel().setValue("revisionamount", (Object)0);
                this.getModel().setValue("taxamount", (Object)0);
                BigDecimal srcTaxAmount = (BigDecimal)this.getModel().getValue("srctaxamount");
                BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount");
                this.getModel().setValue("latesttaxamount", (Object)srcTaxAmount.add(taxAmount));
                BigDecimal srcAmount = (BigDecimal)this.getModel().getValue("srcamount");
                BigDecimal reVisionAmount = (BigDecimal)this.getModel().getValue("revisionamount");
                this.getModel().setValue("latestamount", (Object)srcAmount.add(reVisionAmount));
            }
        }
    }

    private void effectedQtyChanged(PropertyChangedArgs e) {
        BigDecimal qty;
        BigDecimal shouyingxsl;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String subchangetype = (String)this.getModel().getValue("subchangetype", rowIndex);
        if (StringUtils.equals((CharSequence)ChangeTypeEnum.PRICECHANGE.getValue(), (CharSequence)subchangetype) && NumberHelper.compareValue((Object)(shouyingxsl = (BigDecimal)this.getModel().getValue("shouyingxsl", rowIndex)), (Object)(qty = (BigDecimal)this.getModel().getValue("qty", rowIndex))) > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53d7\u5f71\u54cd\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u539f\u6570\u91cf\u201c%s\u201d\u3002", (String)"ContractRevisionBillEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), qty.toString()));
            this.getModel().setValue("shouyingxsl", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
    }

    private void effQtyOrChangedOfTaxPriceChanged(int rowIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)model.getEntryEntity("kapianentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        String subChangeType = row.getString("subchangetype");
        if (StringUtils.equals((CharSequence)ChangeTypeEnum.PRICECHANGE.getValue(), (CharSequence)subChangeType)) {
            BigDecimal curChangePrice = row.getBigDecimal("biangenghouhsdj");
            BigDecimal curChangeQty = row.getBigDecimal("shouyingxsl");
            BigDecimal curTaxPrice = row.getBigDecimal("hanshuidanj");
            BigDecimal changedTaxPrice = NumberHelper.multiply((Object)curChangePrice.subtract(curTaxPrice), (Object)curChangeQty);
            if (this.checkIsOutOfRand(changedTaxPrice)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("shouyingxsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            model.setValue("hsbgje", (Object)changedTaxPrice, rowIndex, parentModelRow);
            BigDecimal lastTotalTaxAmount = row.getBigDecimal("oftax");
            BigDecimal afterChangedTotalAmount = NumberHelper.add((Object)lastTotalTaxAmount, (Object)changedTaxPrice);
            if (!this.checkIsOutOfRand(afterChangedTotalAmount)) {
                model.setValue("bghhszje", (Object)afterChangedTotalAmount, rowIndex, parentModelRow);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("shouyingxsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
        }
        if (!this.summaryAmountToCardEntry(null)) {
            model.setValue("shouyingxsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("shouyingxsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void subChangedTypeChanged(PropertyChangedArgs e, Object propValue) {
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        model.setValue("listid", null, rowIndex);
        model.setValue("parentlisting", null, rowIndex);
        model.setValue("listnumber", (Object)"", rowIndex);
        model.setValue("listname", (Object)"", rowIndex);
        model.setValue("measureunit", null, rowIndex);
        model.setValue("qty", null, rowIndex);
        model.setValue("price", null, rowIndex);
        model.setValue("amount", null, rowIndex);
        model.setValue("rateobj", null, rowIndex);
        model.setValue("tax", null, rowIndex);
        model.setValue("hanshuidanj", null, rowIndex);
        model.setValue("oftax", null, rowIndex);
        model.setValue("yijiesuansl", (Object)0, rowIndex);
        model.setValue("yijiesuanhsje", (Object)0, rowIndex);
        model.setValue("biangengsl", (Object)0, rowIndex);
        model.setValue("shouyingxsl", null, rowIndex);
        model.setValue("biangenghouhsdj", null, rowIndex);
        model.setValue("hsbgje", null, rowIndex);
        model.setValue("bghhszje", null, rowIndex);
        model.setValue("remark", (Object)"", rowIndex);
        model.setValue("materiel", null, rowIndex);
        model.setValue("taxrate1", (Object)0, rowIndex);
        model.setValue("superlistingid", null, rowIndex);
        model.setValue("superlistingname", null, rowIndex);
        if (StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) || StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) {
            ORM orm = ORM.create();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_contractlist");
            long genLongId = orm.genLongId((IDataEntityType)dt);
            model.setValue("newlistingid", (Object)genLongId, rowIndex);
            model.setValue("sysnum", null, rowIndex);
            String sysNum = this.genSysNumber(propValue.toString());
            model.setValue("sysnum", (Object)sysNum, rowIndex);
        } else {
            model.setValue("newlistingid", (Object)0, rowIndex);
            model.setValue("sysnum", null, rowIndex);
        }
        this.initEntryTaxRate(rowIndex);
        if ((StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) || StringUtils.equals((CharSequence)propValue.toString(), (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) && this.isOutContract()) {
            this.setDefaultBudget(rowIndex);
        }
    }

    private String genSysNumber(String type) {
        String sysNum = null;
        if (StringUtils.equals((CharSequence)type, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) || StringUtils.equals((CharSequence)type, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) {
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> excludeSysNum = new ArrayList<String>();
            for (DynamicObject listEntryObj : subEntryEntity) {
                String subChangeType = listEntryObj.getString("subchangetype");
                if (!StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) && !StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) continue;
                String entrySysNum = listEntryObj.getString("sysnum");
                excludeSysNum.add(entrySysNum);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            int parentRowIndex = this.getModel().getEntryCurrentRowIndex("kapianentry");
            Object listModelId = this.getModel().getValue("listmodelid", parentRowIndex);
            QFilter listModelFilter = new QFilter("listingmodel", "=", listModelId);
            qFilters.add(listModelFilter);
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                QFilter contractIdFilter = new QFilter("contractid", "=", (Object)contract.getString("id"));
                qFilters.add(contractIdFilter);
            }
            QFilter parentFilter = new QFilter("parent", "=", (Object)0);
            qFilters.add(parentFilter);
            DynamicObject[] listings = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)"sysnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
            sysNum = ContractListHelper.genSysNumberRule((DynamicObject[])listings, excludeSysNum);
        }
        return sysNum;
    }

    protected void setDefaultBudget(int rowIndex) {
        DynamicObject contract = this.getModel().getDataEntity().getDynamicObject("contract");
        if (contract != null && contract.getDynamicObject("budgetitem") != null) {
            this.getModel().setValue("listingbudgetitem", contract.getDynamicObject("budgetitem").getPkValue(), rowIndex);
        }
    }

    private void changedQtyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("kapianentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        String subChangeType = row.getString("subchangetype");
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)"0")) {
            BigDecimal qty;
            BigDecimal curChangeQty = row.getBigDecimal("biangengsl");
            if (NumberHelper.compareValue((Object)curChangeQty.add(qty = row.getBigDecimal("qty")), (Object)BigDecimal.ZERO) < 0) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u539f\u6570\u91cf\u7684\u8d1f\u503c\uff08-%s\uff09\u3002", (String)"ContractRevisionBillEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), qty.toString()));
                this.getModel().setValue("biangengsl", e.getChangeSet()[0].getOldValue(), rowIndex, parentModelRow);
                return;
            }
            BigDecimal curTaxPrice = row.getBigDecimal("hanshuidanj");
            BigDecimal changedTaxPrice = NumberHelper.multiply((Object)curTaxPrice, (Object)curChangeQty);
            if (this.checkIsOutOfRand(changedTaxPrice)) {
                this.getModel().setValue("biangengsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            this.getModel().setValue("hsbgje", (Object)changedTaxPrice, rowIndex, parentModelRow);
            BigDecimal lastTotalTaxAmount = row.getBigDecimal("oftax");
            BigDecimal afterChangedTotalAmount = lastTotalTaxAmount.add(changedTaxPrice);
            if (!this.checkIsOutOfRand(afterChangedTotalAmount)) {
                this.getModel().setValue("bghhszje", (Object)afterChangedTotalAmount, rowIndex, parentModelRow);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("biangengsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
        }
        if (!this.summaryAmountToCardEntry(null)) {
            this.getModel().setValue("biangengsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("biangengsl", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void qtyOrPriceOrTaxrateChanged(int rowIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("kapianentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        String subChangeType = row.getString("subchangetype");
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)"2")) {
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal price = row.getBigDecimal("price");
            BigDecimal taxrate1 = row.getBigDecimal("taxrate1");
            BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
            BigDecimal hanshuidanj = this.getOfTaxValue(taxrate1, price);
            BigDecimal oftax = NumberHelper.multiply((Object)hanshuidanj, (Object)qty);
            if (this.checkIsOutOfRand(amount, hanshuidanj, oftax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            model.setValue("amount", (Object)amount, rowIndex, parentModelRow);
            model.setValue("hanshuidanj", (Object)hanshuidanj, rowIndex, parentModelRow);
            model.setValue("oftax", (Object)oftax, rowIndex, parentModelRow);
            model.setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
        }
        if (!this.summaryAmountToCardEntry(null)) {
            model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private void ofTaxChanged(Object propNewValue, int rowIndex) {
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("kapianentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        String subChangeType = row.getString("subchangetype");
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
            BigDecimal oftax = (BigDecimal)propNewValue;
            boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
            if (isAdjustAmount) {
                BigDecimal amount = row.getBigDecimal("amount");
                this.getModel().setValue("tax", (Object)oftax.subtract(amount), rowIndex, parentModelRow);
            } else {
                this.getModel().beginInit();
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal taxrate1 = row.getBigDecimal("taxrate1");
                BigDecimal priceOfTax = row.getBigDecimal("hanshuidanj");
                BigDecimal price = row.getBigDecimal("price");
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    priceOfTax = NumberHelper.divide((Object)oftax, (Object)qty, (int)10, (RoundingMode)RoundingMode.HALF_UP);
                    price = this.getWithoutTaxValue(taxrate1, priceOfTax);
                }
                BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
                if (this.checkIsOutOfRand(amount, price, priceOfTax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                    return;
                }
                this.getModel().setValue("amount", (Object)amount, rowIndex, parentModelRow);
                this.getModel().setValue("hanshuidanj", (Object)priceOfTax, rowIndex, parentModelRow);
                this.getModel().setValue("price", (Object)price, rowIndex, parentModelRow);
                this.getModel().setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
            this.summaryAmountToSuperListing(rowIndex, -1);
        }
        if (!this.summaryAmountToCardEntry(null)) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    protected void amountChanged(Object propNewValue, int rowIndex) {
        int curListRow = Integer.parseInt(this.getPageCache().get(CUR_MODEL_ROW));
        String subChangeType = (String)this.getModel().getValue("subchangetype", rowIndex, curListRow);
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue())) {
            BigDecimal amount = (BigDecimal)propNewValue;
            boolean isAdjustAmount = (Boolean)this.getModel().getValue("isadjustamount");
            if (isAdjustAmount) {
                BigDecimal ofTax = (BigDecimal)this.getModel().getValue("oftax", rowIndex, curListRow);
                this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
            } else {
                this.getModel().beginInit();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                int pricePrecision = CurrencyHelper.getPriceAccuracy((DynamicObject)currency);
                BigDecimal subTaxRate = ((BigDecimal)this.getModel().getValue("taxrate1", rowIndex, curListRow)).divide(BigDecimal.valueOf(100L), 10, 4);
                BigDecimal ofTax = amount.multiply(BigDecimal.ONE.add(subTaxRate));
                this.getModel().setValue("oftax", (Object)ofTax, rowIndex, curListRow);
                this.getModel().setValue("tax", (Object)ofTax.subtract(amount), rowIndex, curListRow);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex, curListRow);
                if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal price = amount.divide(qty, pricePrecision, 4);
                    this.getModel().setValue("price", (Object)price, rowIndex, curListRow);
                    this.getModel().setValue("hanshuidanj", (Object)price.multiply(BigDecimal.ONE.add(subTaxRate)), rowIndex, curListRow);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
            this.summaryAmountToSuperListing(rowIndex, -1);
        }
        if (!this.summaryAmountToCardEntry(null)) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, curListRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            this.getModel().setValue("oftax", (Object)BigDecimal.ZERO, rowIndex, curListRow);
        }
    }

    private void ofTaxPriceChanged(int rowIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        DynamicObject row = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("kapianentry").get(parentModelRow)).getDynamicObjectCollection("entryentity").get(rowIndex);
        String subChangeType = row.getString("subchangetype");
        if (StringUtils.equals((CharSequence)subChangeType, (CharSequence)"2")) {
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal taxrate1 = row.getBigDecimal("taxrate1");
            BigDecimal priceOfTax = row.getBigDecimal("hanshuidanj");
            BigDecimal oftax = NumberHelper.multiply((Object)priceOfTax, (Object)qty);
            BigDecimal price = this.getWithoutTaxValue(taxrate1, priceOfTax);
            BigDecimal amount = NumberHelper.multiply((Object)qty, (Object)price);
            if (this.checkIsOutOfRand(amount, price, oftax, NumberHelper.subtract((Object)oftax, (Object)amount))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8fc7\u5927\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                model.setValue("hanshuidanj", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
                return;
            }
            model.setValue("amount", (Object)amount, rowIndex, parentModelRow);
            model.setValue("price", (Object)price, rowIndex, parentModelRow);
            model.setValue("oftax", (Object)oftax, rowIndex, parentModelRow);
            model.setValue("tax", (Object)NumberHelper.subtract((Object)oftax, (Object)amount), rowIndex, parentModelRow);
        }
        if (!this.summaryAmountToCardEntry(null)) {
            model.setValue("hanshuidanj", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
            return;
        }
        if (!this.summaryAmountToHeadInfo()) {
            model.setValue("hanshuidanj", (Object)BigDecimal.ZERO, rowIndex, parentModelRow);
        }
    }

    private String getFormId() {
        return this.getView().getFormShowParameter().getFormId();
    }

    private void setSubChangeTypeEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> hasSubIdSet = new HashSet<Long>();
        for (DynamicObject entry : entryEntity) {
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)entry.getString("subchangetype")) || entry.getDynamicObject("parentlisting") != null || entry.getLong("superlistingid") == 0L) continue;
            hasSubIdSet.add(entry.getLong("superlistingid"));
        }
        int rowCount = entryEntity.size();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (StringUtils.equals((CharSequence)"3", (CharSequence)entry.getString("subchangetype")) && hasSubIdSet.contains(entry.getLong("newlistingid"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"subchangetype"});
                continue;
            }
            if (!StringUtils.equals((CharSequence)"3", (CharSequence)entry.getString("subchangetype"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"subchangetype"});
        }
    }

    private void summaryAmountToSuperListing(int rowIndex, int parentIndex) {
        IDataModel model = this.getModel();
        String curModelRow = this.getPageCache().get(CUR_MODEL_ROW);
        int parentModelRow = Integer.parseInt(curModelRow);
        long superId = 0L;
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("kapianentry", parentModelRow);
        DynamicObjectCollection subEntrys = cardEntry.getDynamicObjectCollection("entryentity");
        if (parentIndex != -1) {
            DynamicObject row = (DynamicObject)subEntrys.get(parentIndex);
            superId = row.getLong("newlistingid");
        } else if (((DynamicObject)subEntrys.get(rowIndex)).get("superlistingid") != null) {
            superId = ((DynamicObject)subEntrys.get(rowIndex)).getLong("superlistingid");
        } else {
            return;
        }
        if (superId != 0L) {
            int rowCount = subEntrys.getRowCount();
            int parentRowIndex = -1;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject subEntryRow = (DynamicObject)subEntrys.get(i);
                long newListingId = subEntryRow.getLong("newlistingid");
                long superListingId = subEntryRow.getLong("superlistingid");
                if (newListingId == superId) {
                    parentRowIndex = i;
                    continue;
                }
                if (superListingId != superId) continue;
                totalAmount = NumberHelper.add((Object)subEntryRow.getBigDecimal("amount"), (Object)totalAmount);
                totalTaxAmount = NumberHelper.add((Object)subEntryRow.getBigDecimal("tax"), (Object)totalTaxAmount);
                totalOfTaxAmount = NumberHelper.add((Object)subEntryRow.getBigDecimal("oftax"), (Object)totalOfTaxAmount);
            }
            if (parentRowIndex != -1) {
                model.setValue("amount", (Object)totalAmount, parentRowIndex, parentModelRow);
                model.setValue("tax", (Object)totalTaxAmount, parentRowIndex, parentModelRow);
                model.setValue("oftax", (Object)totalOfTaxAmount, parentRowIndex, parentModelRow);
            }
        }
    }

    protected boolean summaryAmountToCardEntry(String curRow) {
        Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
        String curModelRow = StringUtils.isEmpty((CharSequence)curRow) ? this.getPageCache().get(CUR_MODEL_ROW) : curRow;
        int cardRowIndex = Integer.parseInt(curModelRow);
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("kapianentry", cardRowIndex);
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
        BigDecimal revisionOfTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        HashMap<Object, DynamicObject> parentMap = new HashMap<Object, DynamicObject>();
        for (int j = 0; j < subEntrys.size(); ++j) {
            DynamicObject changeEntry = (DynamicObject)subEntrys.get(j);
            String string = changeEntry.getString("subchangetype");
            if (StringUtils.equals((CharSequence)ChangeTypeEnum.NUMBERCHANGE.getValue(), (CharSequence)string) || StringUtils.equals((CharSequence)ChangeTypeEnum.PRICECHANGE.getValue(), (CharSequence)string)) {
                BigDecimal ofTaxAmount = (BigDecimal)changeEntry.get("hsbgje");
                BigDecimal amount = this.getWithoutTaxValue(changeEntry.getBigDecimal("taxrate1"), ofTaxAmount);
                BigDecimal tax = NumberHelper.subtract((Object)ofTaxAmount, (Object)amount);
                taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                revisionOfTaxAmount = NumberHelper.add((Object)revisionOfTaxAmount, (Object)ofTaxAmount);
                continue;
            }
            if (StringUtils.equals((CharSequence)ChangeTypeEnum.DETAILLISTING.getValue(), (CharSequence)string)) {
                BigDecimal oftax = (BigDecimal)changeEntry.get("oftax");
                BigDecimal tax = (BigDecimal)changeEntry.get("tax");
                revisionOfTaxAmount = NumberHelper.add((Object)revisionOfTaxAmount, (Object)oftax);
                taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                DynamicObject parent = this.getOriginalParent(changeEntry, subEntrys);
                if (parent == null || !parent.getBoolean("isleaf")) continue;
                parentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
                continue;
            }
            if (!StringUtils.equals((CharSequence)ChangeTypeEnum.TAXRATECHGANGE.getValue(), (CharSequence)string)) continue;
            if (Boolean.TRUE.equals(isOfTaxContract)) {
                revisionOfTaxAmount = BigDecimal.ZERO;
            } else {
                BigDecimal changeAmount = (BigDecimal)changeEntry.get("hsbgje");
                revisionOfTaxAmount = NumberHelper.add((Object)revisionOfTaxAmount, (Object)changeAmount);
            }
            taxAmount = NumberHelper.add((Object)taxAmount, (Object)changeEntry.get("curbgse"));
        }
        Set entries = parentMap.entrySet();
        for (Map.Entry entry : entries) {
            DynamicObject parent = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = parent.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = parent.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            revisionOfTaxAmount = NumberHelper.subtract((Object)revisionOfTaxAmount, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
        }
        boolean isOutOfRand = this.checkIsOutOfRand(revisionOfTaxAmount, taxAmount, NumberHelper.subtract((Object)revisionOfTaxAmount, (Object)taxAmount));
        if (isOutOfRand) {
            return false;
        }
        this.getModel().setValue("totaloftaxamount", (Object)revisionOfTaxAmount, cardRowIndex);
        this.getModel().setValue("totaltax", (Object)taxAmount, cardRowIndex);
        this.getModel().setValue("totalamount", (Object)NumberHelper.subtract((Object)revisionOfTaxAmount, (Object)taxAmount), cardRowIndex);
        return true;
    }

    private boolean summaryAmountToHeadInfo() {
        IDataModel model = this.getModel();
        DynamicObjectCollection cardEntrys = model.getEntryEntity("kapianentry");
        BigDecimal revisionoftaxamount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        HashMap<Object, DynamicObject> addParentMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> subtractParentMap = new HashMap<Object, DynamicObject>();
        for (int i = 0; i < cardEntrys.size(); ++i) {
            DynamicObject cardEntry = (DynamicObject)cardEntrys.get(i);
            String string = cardEntry.getString("cmptype");
            int n = 0;
            if (StringUtils.equals((CharSequence)string, (CharSequence)"(+)")) {
                n = 1;
            } else if (StringUtils.equals((CharSequence)string, (CharSequence)"(-)")) {
                n = -1;
            }
            if (n == 0) continue;
            DynamicObjectCollection subEntrys = (DynamicObjectCollection)cardEntry.get("entryentity");
            for (int j = 0; j < subEntrys.size(); ++j) {
                DynamicObject changeEntry = (DynamicObject)subEntrys.get(j);
                String subChangeType = changeEntry.getString("subchangetype");
                if (StringUtils.equals((CharSequence)ChangeTypeEnum.NUMBERCHANGE.getValue(), (CharSequence)subChangeType) || StringUtils.equals((CharSequence)ChangeTypeEnum.PRICECHANGE.getValue(), (CharSequence)subChangeType)) {
                    BigDecimal ofTaxAmount = (BigDecimal)changeEntry.get("hsbgje");
                    BigDecimal amount = this.getWithoutTaxValue(changeEntry.getBigDecimal("taxrate1"), ofTaxAmount);
                    BigDecimal tax = NumberHelper.subtract((Object)ofTaxAmount, (Object)amount);
                    if (n == 1) {
                        revisionoftaxamount = NumberHelper.add((Object)revisionoftaxamount, (Object)ofTaxAmount);
                        taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                        continue;
                    }
                    if (n != -1) continue;
                    revisionoftaxamount = NumberHelper.subtract((Object)revisionoftaxamount, (Object)ofTaxAmount);
                    taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
                    continue;
                }
                if (StringUtils.equals((CharSequence)ChangeTypeEnum.DETAILLISTING.getValue(), (CharSequence)subChangeType)) {
                    BigDecimal oftax = (BigDecimal)changeEntry.get("oftax");
                    BigDecimal tax = (BigDecimal)changeEntry.get("tax");
                    if (n == 1) {
                        revisionoftaxamount = NumberHelper.add((Object)revisionoftaxamount, (Object)oftax);
                        taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
                    } else if (n == -1) {
                        revisionoftaxamount = NumberHelper.subtract((Object)revisionoftaxamount, (Object)oftax);
                        taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
                    }
                    DynamicObject parent = this.getOriginalParent(changeEntry, subEntrys);
                    if (parent == null || !parent.getBoolean("isleaf")) continue;
                    if (n == 1) {
                        addParentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
                        continue;
                    }
                    if (n != -1) continue;
                    subtractParentMap.put(parent.getPkValue(), BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"pmct_contractlist"));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)ChangeTypeEnum.TAXRATECHGANGE.getValue(), (CharSequence)subChangeType)) continue;
                Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
                BigDecimal curbgbhsje = (BigDecimal)changeEntry.get("curbgbhsje");
                BigDecimal ofTaxAmount = (BigDecimal)changeEntry.get("hsbgje");
                if (n == 1) {
                    if (Boolean.TRUE.equals(isOfTaxContract)) {
                        revisionoftaxamount = BigDecimal.ZERO;
                        taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)curbgbhsje);
                        continue;
                    }
                    revisionoftaxamount = NumberHelper.add((Object)revisionoftaxamount, (Object)ofTaxAmount);
                    taxAmount = NumberHelper.add((Object)taxAmount, (Object)ofTaxAmount);
                    continue;
                }
                if (n != -1) continue;
                if (Boolean.TRUE.equals(isOfTaxContract)) {
                    revisionoftaxamount = BigDecimal.ZERO;
                    taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)curbgbhsje);
                    continue;
                }
                revisionoftaxamount = NumberHelper.subtract((Object)revisionoftaxamount, (Object)ofTaxAmount);
                taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)ofTaxAmount);
            }
        }
        Set entries = addParentMap.entrySet();
        for (Map.Entry entry : entries) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = dynamicObject.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = dynamicObject.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            revisionoftaxamount = NumberHelper.subtract((Object)revisionoftaxamount, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.subtract((Object)taxAmount, (Object)tax);
        }
        Set entries1 = subtractParentMap.entrySet();
        for (Map.Entry entry : entries1) {
            DynamicObject parent = (DynamicObject)entry.getValue();
            BigDecimal lastOfTaxAmount = parent.getBigDecimal("lstoftaxamount");
            BigDecimal taxrate = parent.getBigDecimal("taxrate");
            BigDecimal amount = this.getWithoutTaxValue(taxrate, lastOfTaxAmount);
            BigDecimal tax = NumberHelper.subtract((Object)lastOfTaxAmount, (Object)amount);
            revisionoftaxamount = NumberHelper.add((Object)revisionoftaxamount, (Object)lastOfTaxAmount);
            taxAmount = NumberHelper.add((Object)taxAmount, (Object)tax);
        }
        BigDecimal bigDecimal = NumberHelper.subtract((Object)revisionoftaxamount, (Object)taxAmount);
        boolean bl = this.checkIsOutOfRand(revisionoftaxamount, taxAmount, bigDecimal);
        if (bl) {
            return false;
        }
        model.setValue("revisionoftaxamount", (Object)revisionoftaxamount);
        model.setValue("taxamount", (Object)taxAmount);
        model.setValue("revisionamount", (Object)bigDecimal);
        BigDecimal srcAmountoftax = (BigDecimal)model.getValue("srcamountoftax");
        BigDecimal srcTaxAmount = (BigDecimal)model.getValue("srctaxamount");
        BigDecimal srcAmount = (BigDecimal)model.getValue("srcamount");
        model.setValue("latestamountoftax", (Object)NumberHelper.add((Object)srcAmountoftax, (Object)revisionoftaxamount));
        model.setValue("latesttaxamount", (Object)NumberHelper.add((Object)srcTaxAmount, (Object)taxAmount));
        model.setValue("latestamount", (Object)NumberHelper.add((Object)srcAmount, (Object)bigDecimal));
        return true;
    }

    private DynamicObject getOriginalParent(DynamicObject changeEntry, DynamicObjectCollection subEntrys) {
        if (changeEntry != null) {
            DynamicObject parentListing = changeEntry.getDynamicObject("parentlisting");
            long superListingId = changeEntry.getLong("superlistingid");
            if (parentListing != null) {
                return parentListing;
            }
            if (parentListing == null && superListingId != 0L) {
                return this.getOriginalParent(this.findParentIndex(superListingId, subEntrys), subEntrys);
            }
        }
        return null;
    }

    private DynamicObject findParentIndex(long superListingId, DynamicObjectCollection subEntrys) {
        for (DynamicObject entry : subEntrys) {
            if (entry.getLong("newlistingid") != superListingId) continue;
            return entry;
        }
        return null;
    }

    private BigDecimal getWithoutTaxValue(BigDecimal taxRate, BigDecimal value) {
        BigDecimal rate = taxRate.divide(BigDecimal.valueOf(100L));
        return value.divide(BigDecimal.ONE.add(rate), 10, 4);
    }

    private BigDecimal getTaxRateByAmount(BigDecimal amount, BigDecimal taxAmount) {
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxRate = taxAmount.divide(amount, 10, 4);
        return taxRate.multiply(BigDecimal.valueOf(100L));
    }

    private BigDecimal getOfTaxValue(BigDecimal rate, BigDecimal value) {
        BigDecimal taxrate = rate.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
        return value.multiply(taxrate.add(BigDecimal.ONE));
    }

    private boolean checkIsOutOfRand(BigDecimal ... bigDecimals) {
        for (BigDecimal bigDecimal : bigDecimals) {
            if (bigDecimal == null) break;
            if (bigDecimal.compareTo(MAX_CONTROL_DECIMAL) <= 0 && bigDecimal.compareTo(MIN_CONTROL_DECIMAL) >= 0) continue;
            return true;
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (propertyName.equals("contract")) {
            String formId = this.getView().getEntityId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incontractrevision")) {
                ContractHelper.getContractByStatus((String)formId, (ListShowParameter)parameter, (String)PayDirectionEnum.IN.getValue());
            } else if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontractrevision")) {
                ContractHelper.getContractByStatus((String)formId, (ListShowParameter)parameter, (String)PayDirectionEnum.OUT.getValue());
            }
        }
    }

    private boolean isOutContract() {
        String payDirection = this.getModel().getDataEntity().getString("paydirection");
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue());
    }

    private BigDecimal getTaxAmountByStandard(DynamicObject contract, Boolean isOfTaxContract) {
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        String changeStandard = (String)this.getModel().getValue("changestandard");
        if (Boolean.TRUE.equals(isOfTaxContract)) {
            if (ContractChangeStandardEnum.CONTRACTSETTLE.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalsettleoftaxamount");
            }
            if (ContractChangeStandardEnum.CONTRACTAPPLY.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalapplyoftaxamount");
            }
            if (ContractChangeStandardEnum.CONTRACTINVOICE.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalinvoiceoftaxamount");
            }
        } else {
            if (ContractChangeStandardEnum.CONTRACTSETTLE.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalsettleamount");
            }
            if (ContractChangeStandardEnum.CONTRACTAPPLY.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalapplyamount");
            }
            if (ContractChangeStandardEnum.CONTRACTINVOICE.getValue().equals(changeStandard)) {
                return contract.getBigDecimal("totalinvoiceamount");
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getEntryTaxAmountByStandard(int index) {
        IDataModel model = this.getModel();
        Boolean isOfTaxContract = (Boolean)model.getValue("isoftaxcontract");
        String changeStandard = (String)model.getValue("changestandard");
        if (Boolean.TRUE.equals(isOfTaxContract)) {
            if (ContractChangeStandardEnum.CONTRACTSETTLE.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("yijiesuanhsje", index);
            }
            if (ContractChangeStandardEnum.CONTRACTAPPLY.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("applytaxamount", index);
            }
            if (ContractChangeStandardEnum.CONTRACTINVOICE.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("invoicetaxamount", index);
            }
        } else {
            if (ContractChangeStandardEnum.CONTRACTSETTLE.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("settledamt", index);
            }
            if (ContractChangeStandardEnum.CONTRACTAPPLY.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("applyamount", index);
            }
            if (ContractChangeStandardEnum.CONTRACTINVOICE.getValue().equals(changeStandard)) {
                return (BigDecimal)model.getValue("invoiceamount", index);
            }
        }
        return BigDecimal.ZERO;
    }

    private void updateEntryAmountByChangeRate(int index) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        if (null == contract) {
            return;
        }
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
        DynamicObject currency = contract.getDynamicObject("currency");
        int amtPrecision = currency == null ? 4 : currency.getInt("amtprecision");
        IDataModel model = this.getModel();
        BigDecimal curTaxrate = (BigDecimal)model.getValue("changedtaxrate1", index);
        Boolean isOfTaxContract = (Boolean)this.getModel().getValue("isoftaxcontract");
        BigDecimal taxRate1 = (BigDecimal)model.getValue("taxrate1", index);
        if (taxRate1.compareTo(curTaxrate) == 0) {
            BigDecimal priceOfTax = (BigDecimal)model.getValue("hanshuidanj", index);
            model.setValue("biangenghouhsdj", (Object)priceOfTax, index);
            model.setValue("curbgse", (Object)BigDecimal.ZERO, index);
            model.setValue("curbgbhsje", (Object)BigDecimal.ZERO, index);
            model.setValue("hsbgje", (Object)BigDecimal.ZERO, index);
        } else if (Boolean.TRUE.equals(isOfTaxContract)) {
            BigDecimal yijiesuanhsje = this.getEntryTaxAmountByStandard(index);
            BigDecimal ofTax = (BigDecimal)model.getValue("oftax", index);
            BigDecimal currRate = BigDecimal.ONE.add(((BigDecimal)model.getValue("changedtaxrate1")).divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP));
            BigDecimal preRate = BigDecimal.ONE.add(((BigDecimal)model.getValue("taxrate1")).divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP));
            BigDecimal currAmt = ofTax.subtract(yijiesuanhsje).divide(currRate, amtPrecision, RoundingMode.HALF_UP);
            BigDecimal preAmt = ofTax.subtract(yijiesuanhsje).divide(preRate, amtPrecision, RoundingMode.HALF_UP);
            BigDecimal changeAmt = currAmt.subtract(preAmt);
            model.beginInit();
            model.setValue("curbgse", (Object)BigDecimal.ZERO.subtract(changeAmt), index);
            model.endInit();
            model.setValue("curbgbhsje", (Object)changeAmt, index);
            this.getView().updateView("curbgse", index);
            BigDecimal hanshuidanj = (BigDecimal)model.getValue("hanshuidanj", index);
            model.setValue("biangenghouhsdj", (Object)hanshuidanj, index);
            model.setValue("hsbgje", (Object)BigDecimal.ZERO, index);
            this.getModel().setValue("bghhszje", (Object)ofTax, index);
        } else {
            BigDecimal amount = (BigDecimal)model.getValue("amount", index);
            BigDecimal settledAmt = this.getEntryTaxAmountByStandard(index);
            BigDecimal currRate = ((BigDecimal)model.getValue("changedtaxrate1")).divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP);
            BigDecimal preRate = ((BigDecimal)model.getValue("taxrate1")).divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP);
            BigDecimal currAmt = amount.subtract(settledAmt).multiply(currRate);
            BigDecimal preAmt = amount.subtract(settledAmt).multiply(preRate);
            BigDecimal changeAmt = currAmt.subtract(preAmt);
            model.beginInit();
            model.setValue("curbgse", (Object)changeAmt.subtract(BigDecimal.ZERO), index);
            model.endInit();
            model.setValue("hsbgje", (Object)changeAmt, index);
            this.getView().updateView("curbgse", index);
            BigDecimal price = (BigDecimal)model.getValue("price", index);
            model.setValue("biangenghouhsdj", (Object)price.multiply(BigDecimal.ONE.add(((BigDecimal)model.getValue("changedtaxrate1")).divide(new BigDecimal("100"), amtPrecision, RoundingMode.HALF_UP))), index);
            model.setValue("curbgbhsje", (Object)BigDecimal.ZERO, index);
            BigDecimal ofTax = (BigDecimal)model.getValue("oftax", index);
            model.setValue("bghhszje", (Object)ofTax.add(changeAmt), index);
        }
    }
}

